/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ActionMenuView;
import android.widget.ListPopupWindow;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public class ActionMenuItemView
extends TextView
implements MenuView.ItemView,
View.OnClickListener,
View.OnLongClickListener,
ActionMenuView.ActionMenuChildView {
    private static final int MAX_ICON_SIZE = 32;
    private static final String TAG = "ActionMenuItemView";
    private boolean mAllowTextWithIcon;
    private boolean mExpandedFormat;
    private ListPopupWindow.ForwardingListener mForwardingListener;
    private Drawable mIcon;
    private MenuItemImpl mItemData;
    private MenuBuilder.ItemInvoker mItemInvoker;
    private int mMaxIconSize;
    private int mMinWidth;
    private PopupCallback mPopupCallback;
    private int mSavedPaddingLeft;
    private CharSequence mTitle;

    public ActionMenuItemView(Context context) {
        this(context, null);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        Resources resources = context.getResources();
        this.mAllowTextWithIcon = resources.getBoolean(17956945);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ActionMenuItemView, n, n2);
        this.mMinWidth = typedArray.getDimensionPixelSize(0, 0);
        typedArray.recycle();
        this.mMaxIconSize = (int)(0.5f + 32.0f * resources.getDisplayMetrics().density);
        this.setOnClickListener(this);
        this.setOnLongClickListener(this);
        this.mSavedPaddingLeft = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTextButtonVisibility() {
        boolean bl;
        boolean bl2;
        block3: {
            block2: {
                bl2 = !TextUtils.isEmpty(this.mTitle);
                if (this.mIcon == null) break block2;
                boolean bl3 = this.mItemData.showsTextAsAction();
                bl = false;
                if (!bl3) break block3;
                if (this.mAllowTextWithIcon) break block2;
                boolean bl4 = this.mExpandedFormat;
                bl = false;
                if (!bl4) break block3;
            }
            bl = true;
        }
        CharSequence charSequence = bl2 & bl ? this.mTitle : null;
        this.setText(charSequence);
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        return this.onHoverEvent(motionEvent);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        this.onPopulateAccessibilityEvent(accessibilityEvent);
        return true;
    }

    @Override
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    public boolean hasText() {
        return !TextUtils.isEmpty(this.getText());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n) {
        this.mItemData = menuItemImpl;
        this.setIcon(menuItemImpl.getIcon());
        this.setTitle(menuItemImpl.getTitleForItemView(this));
        this.setId(menuItemImpl.getItemId());
        int n2 = menuItemImpl.isVisible() ? 0 : 8;
        this.setVisibility(n2);
        this.setEnabled(menuItemImpl.isEnabled());
        if (menuItemImpl.hasSubMenu() && this.mForwardingListener == null) {
            this.mForwardingListener = new ActionMenuItemForwardingListener();
        }
    }

    @Override
    public boolean needsDividerAfter() {
        return this.hasText();
    }

    @Override
    public boolean needsDividerBefore() {
        return this.hasText() && this.mItemData.getIcon() == null;
    }

    @Override
    public void onClick(View view) {
        if (this.mItemInvoker != null) {
            this.mItemInvoker.invokeItem(this.mItemData);
        }
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mAllowTextWithIcon = this.getContext().getResources().getBoolean(17956945);
        this.updateTextButtonVisibility();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onLongClick(View view) {
        if (this.hasText()) {
            return false;
        }
        int[] nArray = new int[2];
        Rect rect = new Rect();
        this.getLocationOnScreen(nArray);
        this.getWindowVisibleDisplayFrame(rect);
        Context context = this.getContext();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = nArray[1] + n2 / 2;
        int n4 = nArray[0] + n / 2;
        if (view.getLayoutDirection() == 0) {
            n4 = context.getResources().getDisplayMetrics().widthPixels - n4;
        }
        Toast toast = Toast.makeText(context, this.mItemData.getTitle(), 0);
        if (n3 < rect.height()) {
            toast.setGravity(8388661, n4, n2);
        } else {
            toast.setGravity(81, 0, n2);
        }
        toast.show();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        boolean bl = this.hasText();
        if (bl && this.mSavedPaddingLeft >= 0) {
            super.setPadding(this.mSavedPaddingLeft, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
        super.onMeasure(n, n2);
        int n3 = View.MeasureSpec.getMode(n);
        int n4 = View.MeasureSpec.getSize(n);
        int n5 = this.getMeasuredWidth();
        int n6 = n3 == Integer.MIN_VALUE ? Math.min(n4, this.mMinWidth) : this.mMinWidth;
        if (n3 != 0x40000000 && this.mMinWidth > 0 && n5 < n6) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec(n6, 0x40000000), n2);
        }
        if (!bl && this.mIcon != null) {
            super.setPadding((this.getMeasuredWidth() - this.mIcon.getBounds().width()) / 2, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onPopulateAccessibilityEvent(accessibilityEvent);
        CharSequence charSequence = this.getContentDescription();
        if (!TextUtils.isEmpty(charSequence)) {
            accessibilityEvent.getText().add(charSequence);
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mItemData.hasSubMenu() && this.mForwardingListener != null && this.mForwardingListener.onTouch(this, motionEvent)) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    @Override
    public boolean prefersCondensedTitle() {
        return true;
    }

    @Override
    public void setCheckable(boolean bl) {
    }

    @Override
    public void setChecked(boolean bl) {
    }

    public void setExpandedFormat(boolean bl) {
        if (this.mExpandedFormat != bl) {
            this.mExpandedFormat = bl;
            if (this.mItemData != null) {
                this.mItemData.actionFormatChanged();
            }
        }
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (drawable2 != null) {
            int n = drawable2.getIntrinsicWidth();
            int n2 = drawable2.getIntrinsicHeight();
            if (n > this.mMaxIconSize) {
                float f = (float)this.mMaxIconSize / (float)n;
                n = this.mMaxIconSize;
                n2 = (int)(f * (float)n2);
            }
            if (n2 > this.mMaxIconSize) {
                float f = (float)this.mMaxIconSize / (float)n2;
                n2 = this.mMaxIconSize;
                n = (int)(f * (float)n);
            }
            drawable2.setBounds(0, 0, n, n2);
        }
        this.setCompoundDrawables(drawable2, null, null, null);
        this.updateTextButtonVisibility();
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker itemInvoker) {
        this.mItemInvoker = itemInvoker;
    }

    @Override
    public void setPadding(int n, int n2, int n3, int n4) {
        this.mSavedPaddingLeft = n;
        super.setPadding(n, n2, n3, n4);
    }

    public void setPopupCallback(PopupCallback popupCallback) {
        this.mPopupCallback = popupCallback;
    }

    @Override
    public void setShortcut(boolean bl, char c) {
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.setContentDescription(this.mTitle);
        this.updateTextButtonVisibility();
    }

    @Override
    public boolean showsIcon() {
        return true;
    }

    private class ActionMenuItemForwardingListener
    extends ListPopupWindow.ForwardingListener {
        public ActionMenuItemForwardingListener() {
            super(ActionMenuItemView.this);
        }

        @Override
        public ListPopupWindow getPopup() {
            if (ActionMenuItemView.this.mPopupCallback != null) {
                return ActionMenuItemView.this.mPopupCallback.getPopup();
            }
            return null;
        }

        @Override
        protected boolean onForwardingStarted() {
            MenuBuilder.ItemInvoker itemInvoker = ActionMenuItemView.this.mItemInvoker;
            boolean bl = false;
            if (itemInvoker != null) {
                boolean bl2 = ActionMenuItemView.this.mItemInvoker.invokeItem(ActionMenuItemView.this.mItemData);
                bl = false;
                if (bl2) {
                    ListPopupWindow listPopupWindow = this.getPopup();
                    bl = false;
                    if (listPopupWindow != null) {
                        boolean bl3 = listPopupWindow.isShowing();
                        bl = false;
                        if (bl3) {
                            bl = true;
                        }
                    }
                }
            }
            return bl;
        }

        @Override
        protected boolean onForwardingStopped() {
            ListPopupWindow listPopupWindow = this.getPopup();
            if (listPopupWindow != null) {
                listPopupWindow.dismiss();
                return true;
            }
            return false;
        }
    }

    public static abstract class PopupCallback {
        public abstract ListPopupWindow getPopup();
    }
}

