/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.text.style.SuggestionSpan;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.InputBindResult;
import java.util.ArrayList;
import java.util.List;

public interface IInputMethodManager
extends IInterface {
    public void addClient(IInputMethodClient var1, IInputContext var2, int var3, int var4) throws RemoteException;

    public void finishInput(IInputMethodClient var1) throws RemoteException;

    public InputMethodSubtype getCurrentInputMethodSubtype() throws RemoteException;

    public List<InputMethodInfo> getEnabledInputMethodList() throws RemoteException;

    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String var1, boolean var2) throws RemoteException;

    public List<InputMethodInfo> getInputMethodList() throws RemoteException;

    public int getInputMethodWindowVisibleHeight() throws RemoteException;

    public InputMethodSubtype getLastInputMethodSubtype() throws RemoteException;

    public List getShortcutInputMethodsAndSubtypes() throws RemoteException;

    public void hideMySoftInput(IBinder var1, int var2) throws RemoteException;

    public boolean hideSoftInput(IInputMethodClient var1, int var2, ResultReceiver var3) throws RemoteException;

    public boolean notifySuggestionPicked(SuggestionSpan var1, String var2, int var3) throws RemoteException;

    public void notifyUserAction(int var1) throws RemoteException;

    public void registerSuggestionSpansForNotification(SuggestionSpan[] var1) throws RemoteException;

    public void removeClient(IInputMethodClient var1) throws RemoteException;

    public void setAdditionalInputMethodSubtypes(String var1, InputMethodSubtype[] var2) throws RemoteException;

    public boolean setCurrentInputMethodSubtype(InputMethodSubtype var1) throws RemoteException;

    public void setImeWindowStatus(IBinder var1, int var2, int var3) throws RemoteException;

    public void setInputMethod(IBinder var1, String var2) throws RemoteException;

    public void setInputMethodAndSubtype(IBinder var1, String var2, InputMethodSubtype var3) throws RemoteException;

    public boolean setInputMethodEnabled(String var1, boolean var2) throws RemoteException;

    public boolean shouldOfferSwitchingToNextInputMethod(IBinder var1) throws RemoteException;

    public void showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient var1, String var2) throws RemoteException;

    public void showInputMethodPickerFromClient(IInputMethodClient var1) throws RemoteException;

    public void showMySoftInput(IBinder var1, int var2) throws RemoteException;

    public boolean showSoftInput(IInputMethodClient var1, int var2, ResultReceiver var3) throws RemoteException;

    public InputBindResult startInput(IInputMethodClient var1, IInputContext var2, EditorInfo var3, int var4) throws RemoteException;

    public boolean switchToLastInputMethod(IBinder var1) throws RemoteException;

    public boolean switchToNextInputMethod(IBinder var1, boolean var2) throws RemoteException;

    public void updateStatusIcon(IBinder var1, String var2, int var3) throws RemoteException;

    public InputBindResult windowGainedFocus(IInputMethodClient var1, IBinder var2, int var3, int var4, int var5, EditorInfo var6, IInputContext var7) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodManager {
        private static final String DESCRIPTOR = "com.android.internal.view.IInputMethodManager";
        static final int TRANSACTION_addClient = 6;
        static final int TRANSACTION_finishInput = 9;
        static final int TRANSACTION_getCurrentInputMethodSubtype = 23;
        static final int TRANSACTION_getEnabledInputMethodList = 2;
        static final int TRANSACTION_getEnabledInputMethodSubtypeList = 3;
        static final int TRANSACTION_getInputMethodList = 1;
        static final int TRANSACTION_getInputMethodWindowVisibleHeight = 30;
        static final int TRANSACTION_getLastInputMethodSubtype = 4;
        static final int TRANSACTION_getShortcutInputMethodsAndSubtypes = 5;
        static final int TRANSACTION_hideMySoftInput = 17;
        static final int TRANSACTION_hideSoftInput = 11;
        static final int TRANSACTION_notifySuggestionPicked = 22;
        static final int TRANSACTION_notifyUserAction = 31;
        static final int TRANSACTION_registerSuggestionSpansForNotification = 21;
        static final int TRANSACTION_removeClient = 7;
        static final int TRANSACTION_setAdditionalInputMethodSubtypes = 29;
        static final int TRANSACTION_setCurrentInputMethodSubtype = 24;
        static final int TRANSACTION_setImeWindowStatus = 20;
        static final int TRANSACTION_setInputMethod = 15;
        static final int TRANSACTION_setInputMethodAndSubtype = 16;
        static final int TRANSACTION_setInputMethodEnabled = 28;
        static final int TRANSACTION_shouldOfferSwitchingToNextInputMethod = 27;
        static final int TRANSACTION_showInputMethodAndSubtypeEnablerFromClient = 14;
        static final int TRANSACTION_showInputMethodPickerFromClient = 13;
        static final int TRANSACTION_showMySoftInput = 18;
        static final int TRANSACTION_showSoftInput = 10;
        static final int TRANSACTION_startInput = 8;
        static final int TRANSACTION_switchToLastInputMethod = 25;
        static final int TRANSACTION_switchToNextInputMethod = 26;
        static final int TRANSACTION_updateStatusIcon = 19;
        static final int TRANSACTION_windowGainedFocus = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputMethodManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IInputMethodManager) {
                return (IInputMethodManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<InputMethodInfo> list = this.getInputMethodList();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<InputMethodInfo> list = this.getEnabledInputMethodList();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    List<InputMethodSubtype> list = this.getEnabledInputMethodSubtypeList(string2, bl);
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InputMethodSubtype inputMethodSubtype = this.getLastInputMethodSubtype();
                    parcel2.writeNoException();
                    if (inputMethodSubtype != null) {
                        parcel2.writeInt(1);
                        inputMethodSubtype.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List list = this.getShortcutInputMethodsAndSubtypes();
                    parcel2.writeNoException();
                    parcel2.writeList(list);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addClient(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()), IInputContext.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeClient(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    IInputContext iInputContext = IInputContext.Stub.asInterface(parcel.readStrongBinder());
                    EditorInfo editorInfo = parcel.readInt() != 0 ? EditorInfo.CREATOR.createFromParcel(parcel) : null;
                    InputBindResult inputBindResult = this.startInput(iInputMethodClient, iInputContext, editorInfo, parcel.readInt());
                    parcel2.writeNoException();
                    if (inputBindResult != null) {
                        parcel2.writeInt(1);
                        inputBindResult.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.finishInput(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    int n3 = parcel.readInt();
                    ResultReceiver resultReceiver = parcel.readInt() != 0 ? ResultReceiver.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.showSoftInput(iInputMethodClient, n3, resultReceiver);
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    int n5 = parcel.readInt();
                    ResultReceiver resultReceiver = parcel.readInt() != 0 ? ResultReceiver.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.hideSoftInput(iInputMethodClient, n5, resultReceiver);
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IInputMethodClient iInputMethodClient = IInputMethodClient.Stub.asInterface(parcel.readStrongBinder());
                    IBinder iBinder = parcel.readStrongBinder();
                    int n7 = parcel.readInt();
                    int n8 = parcel.readInt();
                    int n9 = parcel.readInt();
                    EditorInfo editorInfo = parcel.readInt() != 0 ? EditorInfo.CREATOR.createFromParcel(parcel) : null;
                    InputBindResult inputBindResult = this.windowGainedFocus(iInputMethodClient, iBinder, n7, n8, n9, editorInfo, IInputContext.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    if (inputBindResult != null) {
                        parcel2.writeInt(1);
                        inputBindResult.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.showInputMethodPickerFromClient(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setInputMethod(parcel.readStrongBinder(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    String string3 = parcel.readString();
                    InputMethodSubtype inputMethodSubtype = parcel.readInt() != 0 ? InputMethodSubtype.CREATOR.createFromParcel(parcel) : null;
                    this.setInputMethodAndSubtype(iBinder, string3, inputMethodSubtype);
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.hideMySoftInput(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.showMySoftInput(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.updateStatusIcon(parcel.readStrongBinder(), parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setImeWindowStatus(parcel.readStrongBinder(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.registerSuggestionSpansForNotification(parcel.createTypedArray(SuggestionSpan.CREATOR));
                    parcel2.writeNoException();
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SuggestionSpan suggestionSpan = parcel.readInt() != 0 ? SuggestionSpan.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.notifySuggestionPicked(suggestionSpan, parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    int n10 = bl ? 1 : 0;
                    parcel2.writeInt(n10);
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InputMethodSubtype inputMethodSubtype = this.getCurrentInputMethodSubtype();
                    parcel2.writeNoException();
                    if (inputMethodSubtype != null) {
                        parcel2.writeInt(1);
                        inputMethodSubtype.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InputMethodSubtype inputMethodSubtype = parcel.readInt() != 0 ? InputMethodSubtype.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.setCurrentInputMethodSubtype(inputMethodSubtype);
                    parcel2.writeNoException();
                    int n11 = bl ? 1 : 0;
                    parcel2.writeInt(n11);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.switchToLastInputMethod(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    int n12 = bl ? 1 : 0;
                    parcel2.writeInt(n12);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = this.switchToNextInputMethod(iBinder, bl);
                    parcel2.writeNoException();
                    int n13 = bl2 ? 1 : 0;
                    parcel2.writeInt(n13);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.shouldOfferSwitchingToNextInputMethod(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    int n14 = bl ? 1 : 0;
                    parcel2.writeInt(n14);
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl3 = this.setInputMethodEnabled(string4, bl);
                    parcel2.writeNoException();
                    int n15 = bl3 ? 1 : 0;
                    parcel2.writeInt(n15);
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAdditionalInputMethodSubtypes(parcel.readString(), parcel.createTypedArray(InputMethodSubtype.CREATOR));
                    parcel2.writeNoException();
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n16 = this.getInputMethodWindowVisibleHeight();
                    parcel2.writeNoException();
                    parcel2.writeInt(n16);
                    return true;
                }
                case 31: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.notifyUserAction(parcel.readInt());
            return true;
        }

        private static class Proxy
        implements IInputMethodManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addClient(IInputMethodClient iInputMethodClient, IInputContext iInputContext, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    IBinder iBinder2 = null;
                    if (iInputContext != null) {
                        iBinder2 = iInputContext.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void finishInput(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InputMethodSubtype getCurrentInputMethodSubtype() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    InputMethodSubtype inputMethodSubtype = parcel2.readInt() != 0 ? InputMethodSubtype.CREATOR.createFromParcel(parcel2) : null;
                    return inputMethodSubtype;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<InputMethodInfo> getEnabledInputMethodList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<InputMethodInfo> arrayList = parcel2.createTypedArrayList(InputMethodInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String string2, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(3, parcel2, parcel, 0);
                    parcel.readException();
                    ArrayList<InputMethodSubtype> arrayList = parcel.createTypedArrayList(InputMethodSubtype.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public List<InputMethodInfo> getInputMethodList() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<InputMethodInfo> arrayList = parcel2.createTypedArrayList(InputMethodInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getInputMethodWindowVisibleHeight() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InputMethodSubtype getLastInputMethodSubtype() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    InputMethodSubtype inputMethodSubtype = parcel2.readInt() != 0 ? InputMethodSubtype.CREATOR.createFromParcel(parcel2) : null;
                    return inputMethodSubtype;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List getShortcutInputMethodsAndSubtypes() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList arrayList = parcel2.readArrayList(this.getClass().getClassLoader());
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void hideMySoftInput(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hideSoftInput(IInputMethodClient iInputMethodClient, int n, ResultReceiver resultReceiver) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                            parcel2.writeStrongBinder(iBinder);
                            parcel2.writeInt(n);
                            if (resultReceiver != null) {
                                parcel2.writeInt(1);
                                resultReceiver.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(11, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean notifySuggestionPicked(SuggestionSpan suggestionSpan, String string2, int n) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (suggestionSpan != null) {
                                parcel2.writeInt(1);
                                suggestionSpan.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeString(string2);
                            parcel2.writeInt(n);
                            this.mRemote.transact(22, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public void notifyUserAction(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(31, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void registerSuggestionSpansForNotification(SuggestionSpan[] suggestionSpanArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeTypedArray(suggestionSpanArray, 0);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeClient(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setAdditionalInputMethodSubtypes(String string2, InputMethodSubtype[] inputMethodSubtypeArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeTypedArray(inputMethodSubtypeArray, 0);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setCurrentInputMethodSubtype(InputMethodSubtype inputMethodSubtype) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (inputMethodSubtype != null) {
                                parcel2.writeInt(1);
                                inputMethodSubtype.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(24, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public void setImeWindowStatus(IBinder iBinder, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setInputMethod(IBinder iBinder, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setInputMethodAndSubtype(IBinder iBinder, String string2, InputMethodSubtype inputMethodSubtype) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    if (inputMethodSubtype != null) {
                        parcel.writeInt(1);
                        inputMethodSubtype.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setInputMethodEnabled(String string2, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeString(string2);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            this.mRemote.transact(28, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            @Override
            public boolean shouldOfferSwitchingToNextInputMethod(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient iInputMethodClient, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void showInputMethodPickerFromClient(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void showMySoftInput(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean showSoftInput(IInputMethodClient iInputMethodClient, int n, ResultReceiver resultReceiver) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                            parcel2.writeStrongBinder(iBinder);
                            parcel2.writeInt(n);
                            if (resultReceiver != null) {
                                parcel2.writeInt(1);
                                resultReceiver.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(10, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InputBindResult startInput(IInputMethodClient iInputMethodClient, IInputContext iInputContext, EditorInfo editorInfo, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    IBinder iBinder2 = null;
                    if (iInputContext != null) {
                        iBinder2 = iInputContext.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder2);
                    if (editorInfo != null) {
                        parcel.writeInt(1);
                        editorInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    InputBindResult inputBindResult = parcel2.readInt() != 0 ? InputBindResult.CREATOR.createFromParcel(parcel2) : null;
                    return inputBindResult;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean switchToLastInputMethod(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean switchToNextInputMethod(IBinder iBinder, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeStrongBinder(iBinder);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            this.mRemote.transact(26, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            @Override
            public void updateStatusIcon(IBinder iBinder, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InputBindResult windowGainedFocus(IInputMethodClient iInputMethodClient, IBinder iBinder, int n, int n2, int n3, EditorInfo editorInfo, IInputContext iInputContext) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder2 = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder2);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (editorInfo != null) {
                        parcel.writeInt(1);
                        editorInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    IBinder iBinder3 = null;
                    if (iInputContext != null) {
                        iBinder3 = iInputContext.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder3);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    InputBindResult inputBindResult = parcel2.readInt() != 0 ? InputBindResult.CREATOR.createFromParcel(parcel2) : null;
                    return inputBindResult;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

