/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseSurfaceHolder
implements SurfaceHolder {
    static final boolean DEBUG = false;
    private static final String TAG = "BaseSurfaceHolder";
    public final ArrayList<SurfaceHolder.Callback> mCallbacks = new ArrayList();
    SurfaceHolder.Callback[] mGottenCallbacks;
    boolean mHaveGottenCallbacks;
    long mLastLockTime = 0L;
    protected int mRequestedFormat = -1;
    int mRequestedHeight = -1;
    int mRequestedType = -1;
    int mRequestedWidth = -1;
    public Surface mSurface;
    final Rect mSurfaceFrame;
    public final ReentrantLock mSurfaceLock = new ReentrantLock();
    Rect mTmpDirty;
    int mType = -1;

    public BaseSurfaceHolder() {
        this.mSurface = new Surface();
        this.mSurfaceFrame = new Rect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Canvas internalLockCanvas(Rect rect) {
        if (this.mType == 3) {
            throw new SurfaceHolder.BadSurfaceTypeException("Surface type is SURFACE_TYPE_PUSH_BUFFERS");
        }
        this.mSurfaceLock.lock();
        boolean bl = this.onAllowLockCanvas();
        Canvas canvas = null;
        if (bl) {
            if (rect == null) {
                if (this.mTmpDirty == null) {
                    this.mTmpDirty = new Rect();
                }
                this.mTmpDirty.set(this.mSurfaceFrame);
                rect = this.mTmpDirty;
            }
            try {
                Canvas canvas2;
                canvas = canvas2 = this.mSurface.lockCanvas(rect);
            }
            catch (Exception exception) {
                Log.e(TAG, "Exception locking surface", exception);
                canvas = null;
            }
        }
        if (canvas != null) {
            this.mLastLockTime = SystemClock.uptimeMillis();
            return canvas;
        }
        long l = 100L + this.mLastLockTime;
        long l2 = SystemClock.uptimeMillis();
        if (l > l2) {
            long l3 = l - l2;
            try {
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {}
            l2 = SystemClock.uptimeMillis();
        }
        this.mLastLockTime = l2;
        this.mSurfaceLock.unlock();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addCallback(SurfaceHolder.Callback callback) {
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            if (!this.mCallbacks.contains(callback)) {
                this.mCallbacks.add(callback);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SurfaceHolder.Callback[] getCallbacks() {
        if (this.mHaveGottenCallbacks) {
            return this.mGottenCallbacks;
        }
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            int n = this.mCallbacks.size();
            if (n > 0) {
                if (this.mGottenCallbacks == null || this.mGottenCallbacks.length != n) {
                    this.mGottenCallbacks = new SurfaceHolder.Callback[n];
                }
                this.mCallbacks.toArray(this.mGottenCallbacks);
            } else {
                this.mGottenCallbacks = null;
            }
            this.mHaveGottenCallbacks = true;
            return this.mGottenCallbacks;
        }
    }

    public int getRequestedFormat() {
        return this.mRequestedFormat;
    }

    public int getRequestedHeight() {
        return this.mRequestedHeight;
    }

    public int getRequestedType() {
        return this.mRequestedType;
    }

    public int getRequestedWidth() {
        return this.mRequestedWidth;
    }

    @Override
    public Surface getSurface() {
        return this.mSurface;
    }

    @Override
    public Rect getSurfaceFrame() {
        return this.mSurfaceFrame;
    }

    @Override
    public Canvas lockCanvas() {
        return this.internalLockCanvas(null);
    }

    @Override
    public Canvas lockCanvas(Rect rect) {
        return this.internalLockCanvas(rect);
    }

    public abstract boolean onAllowLockCanvas();

    public abstract void onRelayoutContainer();

    public abstract void onUpdateSurface();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeCallback(SurfaceHolder.Callback callback) {
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            this.mCallbacks.remove(callback);
            return;
        }
    }

    @Override
    public void setFixedSize(int n, int n2) {
        if (this.mRequestedWidth != n || this.mRequestedHeight != n2) {
            this.mRequestedWidth = n;
            this.mRequestedHeight = n2;
            this.onRelayoutContainer();
        }
    }

    @Override
    public void setFormat(int n) {
        if (this.mRequestedFormat != n) {
            this.mRequestedFormat = n;
            this.onUpdateSurface();
        }
    }

    @Override
    public void setSizeFromLayout() {
        if (this.mRequestedWidth != -1 || this.mRequestedHeight != -1) {
            this.mRequestedHeight = -1;
            this.mRequestedWidth = -1;
            this.onRelayoutContainer();
        }
    }

    public void setSurfaceFrameSize(int n, int n2) {
        this.mSurfaceFrame.top = 0;
        this.mSurfaceFrame.left = 0;
        this.mSurfaceFrame.right = n;
        this.mSurfaceFrame.bottom = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setType(int n) {
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                n = 0;
            }
        }
        switch (n) {
            case 0: 
            case 3: {
                if (this.mRequestedType != n) break;
            }
            default: {
                return;
            }
        }
        this.mRequestedType = n;
        this.onUpdateSurface();
    }

    public void ungetCallbacks() {
        this.mHaveGottenCallbacks = false;
    }

    @Override
    public void unlockCanvasAndPost(Canvas canvas) {
        this.mSurface.unlockCanvasAndPost(canvas);
        this.mSurfaceLock.unlock();
    }
}

