/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.util.Collection;
import java.util.Iterator;

public class Preconditions {
    public static float checkArgumentFinite(float f, String string2) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(string2 + " must not be NaN");
        }
        if (Float.isInfinite(f)) {
            throw new IllegalArgumentException(string2 + " must not be infinite");
        }
        return f;
    }

    public static float checkArgumentInRange(float f, float f2, float f3, String string2) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(string2 + " must not be NaN");
        }
        if (f < f2) {
            Object[] objectArray = new Object[]{string2, Float.valueOf(f2), Float.valueOf(f3)};
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too low)", objectArray));
        }
        if (f > f3) {
            Object[] objectArray = new Object[]{string2, Float.valueOf(f2), Float.valueOf(f3)};
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too high)", objectArray));
        }
        return f;
    }

    public static int checkArgumentInRange(int n, int n2, int n3, String string2) {
        if (n < n2) {
            Object[] objectArray = new Object[]{string2, n2, n3};
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too low)", objectArray));
        }
        if (n > n3) {
            Object[] objectArray = new Object[]{string2, n2, n3};
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too high)", objectArray));
        }
        return n;
    }

    public static int checkArgumentNonnegative(int n, String string2) {
        if (n < 0) {
            throw new IllegalArgumentException(string2);
        }
        return n;
    }

    public static long checkArgumentNonnegative(long l, String string2) {
        if (l < 0L) {
            throw new IllegalArgumentException(string2);
        }
        return l;
    }

    public static int checkArgumentPositive(int n, String string2) {
        if (n <= 0) {
            throw new IllegalArgumentException(string2);
        }
        return n;
    }

    public static float[] checkArrayElementsInRange(float[] fArray, float f, float f2, String string2) {
        Preconditions.checkNotNull(fArray, string2 + " must not be null");
        for (int i = 0; i < fArray.length; ++i) {
            float f3 = fArray[i];
            if (Float.isNaN(f3)) {
                throw new IllegalArgumentException(string2 + "[" + i + "] must not be NaN");
            }
            if (f3 < f) {
                Object[] objectArray = new Object[]{string2, i, Float.valueOf(f), Float.valueOf(f2)};
                throw new IllegalArgumentException(String.format("%s[%d] is out of range of [%f, %f] (too low)", objectArray));
            }
            if (!(f3 > f2)) continue;
            Object[] objectArray = new Object[]{string2, i, Float.valueOf(f), Float.valueOf(f2)};
            throw new IllegalArgumentException(String.format("%s[%d] is out of range of [%f, %f] (too high)", objectArray));
        }
        return fArray;
    }

    public static <T> T[] checkArrayElementsNotNull(T[] TArray, String string2) {
        if (TArray == null) {
            throw new NullPointerException(string2 + " must not be null");
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] != null) continue;
            Object[] objectArray = new Object[]{string2, i};
            throw new NullPointerException(String.format("%s[%d] must not be null", objectArray));
        }
        return TArray;
    }

    public static <T> Collection<T> checkCollectionElementsNotNull(Collection<T> collection, String string2) {
        if (collection == null) {
            throw new NullPointerException(string2 + " must not be null");
        }
        long l = 0L;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == null) {
                Object[] objectArray = new Object[]{string2, l};
                throw new NullPointerException(String.format("%s[%d] must not be null", objectArray));
            }
            ++l;
        }
        return collection;
    }

    public static <T> Collection<T> checkCollectionNotEmpty(Collection<T> collection, String string2) {
        if (collection == null) {
            throw new NullPointerException(string2 + " must not be null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(string2 + " is empty");
        }
        return collection;
    }

    public static void checkFlagsArgument(int n, int n2) {
        if ((n & n2) != n) {
            throw new IllegalArgumentException("Requested flags 0x" + Integer.toHexString(n) + ", but only 0x" + Integer.toHexString(n2) + " are allowed");
        }
    }

    public static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T> T checkNotNull(T t, Object object) {
        if (t == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t;
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }
}

