/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telecom;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.ConnectionRequest;
import android.telecom.PhoneAccountHandle;
import com.android.internal.telecom.IConnectionServiceAdapter;

public interface IConnectionService
extends IInterface {
    public void abort(String var1) throws RemoteException;

    public void addConnectionServiceAdapter(IConnectionServiceAdapter var1) throws RemoteException;

    public void answer(String var1) throws RemoteException;

    public void answerVideo(String var1, int var2) throws RemoteException;

    public void conference(String var1, String var2) throws RemoteException;

    public void createConnection(PhoneAccountHandle var1, String var2, ConnectionRequest var3, boolean var4, boolean var5) throws RemoteException;

    public void deflect(String var1, String var2) throws RemoteException;

    public void disconnect(String var1) throws RemoteException;

    public void hold(String var1) throws RemoteException;

    public void mergeConference(String var1) throws RemoteException;

    public void onAudioStateChanged(String var1, AudioState var2) throws RemoteException;

    public void onPostDialContinue(String var1, boolean var2) throws RemoteException;

    public void playDtmfTone(String var1, char var2) throws RemoteException;

    public void reject(String var1) throws RemoteException;

    public void removeConnectionServiceAdapter(IConnectionServiceAdapter var1) throws RemoteException;

    public void setActiveSubscription(String var1) throws RemoteException;

    public void setLocalCallHold(String var1, int var2) throws RemoteException;

    public void splitFromConference(String var1) throws RemoteException;

    public void stopDtmfTone(String var1) throws RemoteException;

    public void swapConference(String var1) throws RemoteException;

    public void unhold(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IConnectionService {
        private static final String DESCRIPTOR = "com.android.internal.telecom.IConnectionService";
        static final int TRANSACTION_abort = 4;
        static final int TRANSACTION_addConnectionServiceAdapter = 1;
        static final int TRANSACTION_answer = 6;
        static final int TRANSACTION_answerVideo = 5;
        static final int TRANSACTION_conference = 15;
        static final int TRANSACTION_createConnection = 3;
        static final int TRANSACTION_deflect = 7;
        static final int TRANSACTION_disconnect = 9;
        static final int TRANSACTION_hold = 10;
        static final int TRANSACTION_mergeConference = 17;
        static final int TRANSACTION_onAudioStateChanged = 12;
        static final int TRANSACTION_onPostDialContinue = 19;
        static final int TRANSACTION_playDtmfTone = 13;
        static final int TRANSACTION_reject = 8;
        static final int TRANSACTION_removeConnectionServiceAdapter = 2;
        static final int TRANSACTION_setActiveSubscription = 21;
        static final int TRANSACTION_setLocalCallHold = 20;
        static final int TRANSACTION_splitFromConference = 16;
        static final int TRANSACTION_stopDtmfTone = 14;
        static final int TRANSACTION_swapConference = 18;
        static final int TRANSACTION_unhold = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IConnectionService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IConnectionService) {
                return (IConnectionService)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addConnectionServiceAdapter(IConnectionServiceAdapter.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeConnectionServiceAdapter(IConnectionServiceAdapter.Stub.asInterface(parcel.readStrongBinder()));
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PhoneAccountHandle phoneAccountHandle = parcel.readInt() != 0 ? PhoneAccountHandle.CREATOR.createFromParcel(parcel) : null;
                    String string2 = parcel.readString();
                    ConnectionRequest connectionRequest = parcel.readInt() != 0 ? ConnectionRequest.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    this.createConnection(phoneAccountHandle, string2, connectionRequest, bl, bl2);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.abort(parcel.readString());
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.answerVideo(parcel.readString(), parcel.readInt());
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.answer(parcel.readString());
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.deflect(parcel.readString(), parcel.readString());
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.reject(parcel.readString());
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disconnect(parcel.readString());
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.hold(parcel.readString());
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unhold(parcel.readString());
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = parcel.readString();
                    AudioState audioState = parcel.readInt() != 0 ? AudioState.CREATOR.createFromParcel(parcel) : null;
                    this.onAudioStateChanged(string3, audioState);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.playDtmfTone(parcel.readString(), (char)parcel.readInt());
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.stopDtmfTone(parcel.readString());
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.conference(parcel.readString(), parcel.readString());
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.splitFromConference(parcel.readString());
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.mergeConference(parcel.readString());
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.swapConference(parcel.readString());
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.onPostDialContinue(string4, bl);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setLocalCallHold(parcel.readString(), parcel.readInt());
                    return true;
                }
                case 21: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.setActiveSubscription(parcel.readString());
            return true;
        }

        private static class Proxy
        implements IConnectionService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public void abort(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addConnectionServiceAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iConnectionServiceAdapter != null) {
                        iBinder = iConnectionServiceAdapter.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void answer(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void answerVideo(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void conference(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(15, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void createConnection(PhoneAccountHandle phoneAccountHandle, String string2, ConnectionRequest connectionRequest, boolean bl, boolean bl2) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (phoneAccountHandle != null) {
                        parcel.writeInt(1);
                        phoneAccountHandle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    if (connectionRequest != null) {
                        parcel.writeInt(1);
                        connectionRequest.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
                int n2 = bl ? n : 0;
                parcel.writeInt(n2);
                if (!bl2) {
                    n = 0;
                }
                parcel.writeInt(n);
                this.mRemote.transact(3, parcel, null, 1);
                parcel.recycle();
            }

            @Override
            public void deflect(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(7, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void disconnect(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(9, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void hold(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(10, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void mergeConference(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(17, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onAudioStateChanged(String string2, AudioState audioState) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (audioState != null) {
                        parcel.writeInt(1);
                        audioState.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(12, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onPostDialContinue(String string2, boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(19, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void playDtmfTone(String string2, char c) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(c);
                    this.mRemote.transact(13, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void reject(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeConnectionServiceAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iConnectionServiceAdapter != null) {
                        iBinder = iConnectionServiceAdapter.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setActiveSubscription(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(21, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setLocalCallHold(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(20, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void splitFromConference(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(16, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void stopDtmfTone(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(14, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void swapConference(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(18, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void unhold(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(11, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

