/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.Credentials;
import android.net.LocalSocket;
import android.os.Process;
import android.os.SELinux;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.util.Log;
import android.util.Slog;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import dalvik.system.PathClassLoader;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import libcore.io.IoUtils;

class ZygoteConnection {
    private static final int CONNECTION_TIMEOUT_MILLIS = 1000;
    private static final int MAX_ZYGOTE_ARGC = 1024;
    private static final String TAG = "Zygote";
    private static final int[][] intArray2d;
    private final String abiList;
    private final LocalSocket mSocket;
    private final DataOutputStream mSocketOutStream;
    private final BufferedReader mSocketReader;
    private final Credentials peer;
    private final String peerSecurityContext;

    static {
        int[] nArray = new int[]{0, 0};
        intArray2d = (int[][])Array.newInstance(Integer.TYPE, nArray);
    }

    ZygoteConnection(LocalSocket localSocket, String string2) throws IOException {
        this.mSocket = localSocket;
        this.abiList = string2;
        this.mSocketOutStream = new DataOutputStream(localSocket.getOutputStream());
        this.mSocketReader = new BufferedReader(new InputStreamReader(localSocket.getInputStream()), 256);
        this.mSocket.setSoTimeout(1000);
        try {
            this.peer = this.mSocket.getPeerCredentials();
        }
        catch (IOException iOException) {
            Log.e(TAG, "Cannot read peer credentials", iOException);
            throw iOException;
        }
        this.peerSecurityContext = SELinux.getPeerContext(this.mSocket.getFileDescriptor());
    }

    public static void applyDebuggerSystemProperty(Arguments arguments) {
        if ("1".equals(SystemProperties.get("ro.debuggable"))) {
            arguments.debugFlags = 1 | arguments.debugFlags;
        }
    }

    private static void applyInvokeWithSecurityPolicy(Arguments arguments, Credentials credentials, String string2) throws ZygoteSecurityException {
        int n = credentials.getUid();
        if (arguments.invokeWith != null && n != 0) {
            throw new ZygoteSecurityException("Peer is not permitted to specify an explicit invoke-with wrapper command");
        }
        if (arguments.invokeWith != null && !SELinux.checkSELinuxAccess(string2, string2, "zygote", "specifyinvokewith")) {
            throw new ZygoteSecurityException("Peer is not permitted to specify an explicit invoke-with wrapper command");
        }
    }

    public static void applyInvokeWithSystemProperty(Arguments arguments) {
        if (arguments.invokeWith == null && arguments.niceName != null && arguments.niceName != null) {
            String string2 = "wrap." + arguments.niceName;
            if (string2.length() > 31) {
                string2 = string2.substring(0, 31);
            }
            arguments.invokeWith = SystemProperties.get(string2);
            if (arguments.invokeWith != null && arguments.invokeWith.length() == 0) {
                arguments.invokeWith = null;
            }
        }
    }

    private static void applyRlimitSecurityPolicy(Arguments arguments, Credentials credentials, String string2) throws ZygoteSecurityException {
        int n = credentials.getUid();
        if (n != 0 && n != 1000 && arguments.rlimits != null) {
            throw new ZygoteSecurityException("This UID may not specify rlimits.");
        }
        if (arguments.rlimits != null && !SELinux.checkSELinuxAccess(string2, string2, "zygote", "specifyrlimits")) {
            throw new ZygoteSecurityException("Peer may not specify rlimits");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void applyUidSecurityPolicy(Arguments arguments, Credentials credentials, String string2) throws ZygoteSecurityException {
        int n = credentials.getUid();
        if (n != 0) {
            if (n == 1000) {
                String string3 = SystemProperties.get("ro.factorytest");
                boolean bl = !string3.equals("1") && !string3.equals("2");
                if (bl && arguments.uidSpecified && arguments.uid < 1000) {
                    throw new ZygoteSecurityException("System UID may not launch process with UID < 1000");
                }
            } else if (arguments.uidSpecified || arguments.gidSpecified || arguments.gids != null) {
                throw new ZygoteSecurityException("App UIDs may not specify uid's or gid's");
            }
        }
        if ((arguments.uidSpecified || arguments.gidSpecified || arguments.gids != null) && !SELinux.checkSELinuxAccess(string2, string2, "zygote", "specifyids")) {
            throw new ZygoteSecurityException("Peer may not specify uid's or gid's");
        }
        if (!arguments.uidSpecified) {
            arguments.uid = credentials.getUid();
            arguments.uidSpecified = true;
        }
        if (!arguments.gidSpecified) {
            arguments.gid = credentials.getGid();
            arguments.gidSpecified = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void applyseInfoSecurityPolicy(Arguments arguments, Credentials credentials, String string2) throws ZygoteSecurityException {
        block5: {
            block4: {
                int n = credentials.getUid();
                if (arguments.seInfo == null) break block4;
                if (n != 0 && n != 1000) {
                    throw new ZygoteSecurityException("This UID may not specify SELinux info.");
                }
                if (!SELinux.checkSELinuxAccess(string2, string2, "zygote", "specifyseinfo")) break block5;
            }
            return;
        }
        throw new ZygoteSecurityException("Peer may not specify SELinux info");
    }

    private void checkTime(long l, String string2) {
        long l2 = SystemClock.elapsedRealtime();
        if (l2 - l > 1000L) {
            Slog.w(TAG, "Slow operation: " + (l2 - l) + "ms so far, now at " + string2);
        }
    }

    private boolean handleAbiListQuery() {
        try {
            byte[] byArray = this.abiList.getBytes(StandardCharsets.US_ASCII);
            this.mSocketOutStream.writeInt(byArray.length);
            this.mSocketOutStream.write(byArray);
            return false;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Error writing to command socket", iOException);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleChildProc(Arguments arguments, FileDescriptor[] fileDescriptorArray, FileDescriptor fileDescriptor, PrintStream printStream) throws ZygoteInit.MethodAndArgsCaller {
        String string2;
        this.closeSocket();
        ZygoteInit.closeServerSocket();
        if (fileDescriptorArray != null) {
            try {
                ZygoteInit.reopenStdio(fileDescriptorArray[0], fileDescriptorArray[1], fileDescriptorArray[2]);
                int n = fileDescriptorArray.length;
                for (int i = 0; i < n; ++i) {
                    IoUtils.closeQuietly((FileDescriptor)fileDescriptorArray[i]);
                }
                printStream = System.err;
            }
            catch (IOException iOException) {
                Log.e(TAG, "Error reopening stdio", iOException);
            }
        }
        if (arguments.niceName != null) {
            Process.setArgV0(arguments.niceName);
        }
        if (arguments.runtimeInit) {
            if (arguments.invokeWith != null) {
                WrapperInit.execApplication(arguments.invokeWith, arguments.niceName, arguments.targetSdkVersion, fileDescriptor, arguments.remainingArgs);
                return;
            }
            RuntimeInit.zygoteInit(arguments.targetSdkVersion, arguments.remainingArgs, null);
            return;
        }
        try {
            string2 = arguments.remainingArgs[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ZygoteConnection.logAndPrintError(printStream, "Missing required class name argument", null);
            return;
        }
        String[] stringArray = new String[-1 + arguments.remainingArgs.length];
        System.arraycopy(arguments.remainingArgs, 1, stringArray, 0, stringArray.length);
        if (arguments.invokeWith != null) {
            WrapperInit.execStandalone(arguments.invokeWith, arguments.classpath, string2, stringArray);
            return;
        }
        ClassLoader classLoader = arguments.classpath != null ? new PathClassLoader(arguments.classpath, ClassLoader.getSystemClassLoader()) : ClassLoader.getSystemClassLoader();
        try {
            ZygoteInit.invokeStaticMain(classLoader, string2, stringArray);
            return;
        }
        catch (RuntimeException runtimeException) {
            ZygoteConnection.logAndPrintError(printStream, "Error starting.", runtimeException);
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleParentProc(int n, FileDescriptor[] fileDescriptorArray, FileDescriptor fileDescriptor, Arguments arguments) {
        boolean bl;
        block21: {
            int n2;
            block20: {
                int n3;
                if (n > 0) {
                    this.setChildPgid(n);
                }
                if (fileDescriptorArray != null) {
                    int n4 = fileDescriptorArray.length;
                    for (int i = 0; i < n4; ++i) {
                        IoUtils.closeQuietly((FileDescriptor)fileDescriptorArray[i]);
                    }
                }
                bl = false;
                if (fileDescriptor == null) break block21;
                bl = false;
                if (n <= 0) break block21;
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(fileDescriptor));
                n2 = -1;
                n2 = n3 = dataInputStream.readInt();
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {}
                catch (IOException iOException) {
                    Log.w(TAG, "Error reading pid from wrapped process, child may have died", iOException);
                    break block20;
                }
                break block20;
                finally {
                    dataInputStream.close();
                }
            }
            bl = false;
            if (n2 > 0) {
                int n5 = n2;
                while (n5 > 0 && n5 != n) {
                    n5 = Process.getParentPid(n5);
                }
                if (n5 > 0) {
                    Log.i(TAG, "Wrapped process has pid " + n2);
                    n = n2;
                    bl = true;
                } else {
                    Log.w(TAG, "Wrapped process reported a pid that is not a child of the process that we forked: childPid=" + n + " innerPid=" + n2);
                    bl = false;
                }
            }
        }
        try {
            this.mSocketOutStream.writeInt(n);
            this.mSocketOutStream.writeBoolean(bl);
            return false;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Error writing to command socket", iOException);
            return true;
        }
    }

    private static void logAndPrintError(PrintStream printStream, String string2, Throwable object) {
        Log.e(TAG, string2, (Throwable)object);
        if (printStream != null) {
            StringBuilder stringBuilder = new StringBuilder().append(string2);
            if (object == null) {
                object = "";
            }
            printStream.println(stringBuilder.append(object).toString());
        }
    }

    private String[] readArgumentList() throws IOException {
        String string2;
        block5: {
            try {
                string2 = this.mSocketReader.readLine();
                if (string2 != null) break block5;
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                Log.e(TAG, "invalid Zygote wire format: non-int at argc");
                throw new IOException("invalid wire format");
            }
        }
        int n = Integer.parseInt(string2);
        if (n > 1024) {
            throw new IOException("max arg count exceeded");
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.mSocketReader.readLine();
            if (stringArray[i] != null) continue;
            throw new IOException("truncated request");
        }
        return stringArray;
    }

    private void setChildPgid(int n) {
        try {
            ZygoteInit.setpgid(n, ZygoteInit.getpgid(this.peer.getPid()));
            return;
        }
        catch (IOException iOException) {
            Log.i(TAG, "Zygote: setpgid failed. This is normal if peer is not in our session");
            return;
        }
    }

    void closeSocket() {
        try {
            this.mSocket.close();
            return;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Exception while closing command socket in parent", iOException);
            return;
        }
    }

    FileDescriptor getFileDescriptor() {
        return this.mSocket.getFileDescriptor();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean runOnce() throws ZygoteInit.MethodAndArgsCaller {
        block32: {
            var1_1 = null;
            var2_2 = SystemClock.elapsedRealtime();
            try {
                var6_3 = this.readArgumentList();
                var7_4 = this.mSocket.getAncillaryFileDescriptors();
                this.checkTime(var2_2, "zygoteConnection.runOnce: readArgumentList");
                if (var6_3 == null) {
                    this.closeSocket();
                    return true;
                }
            }
            catch (IOException var4_5) {
                Log.w("Zygote", "IOException on command socket " + var4_5.getMessage());
                this.closeSocket();
                return true;
            }
            var8_6 = null;
            if (var7_4 != null) {
                var27_7 = var7_4.length;
                var8_6 = null;
                if (var27_7 >= 3) {
                    var28_8 = new FileOutputStream(var7_4[2]);
                    var8_6 = new PrintStream(var28_8);
                }
            }
            var9_9 = -1;
            var10_10 = null;
            var11_11 = null;
            var12_12 = new Arguments(var6_3);
            try {
                var19_13 = var12_12.abiListQuery;
                var10_10 = null;
                var11_11 = null;
                if (var19_13) {
                    return this.handleAbiListQuery();
                }
                if (var12_12.permittedCapabilities != 0L || var12_12.effectiveCapabilities != 0L) {
                    throw new ZygoteSecurityException("Client may not specify capabilities: permitted=0x" + Long.toHexString(var12_12.permittedCapabilities) + ", effective=0x" + Long.toHexString(var12_12.effectiveCapabilities));
                }
                break block32;
            }
            catch (IOException var18_14) {
                var1_1 = var12_12;
lbl39:
                // 2 sources

                while (true) {
                    ZygoteConnection.logAndPrintError(var8_6, "Exception creating pipe", (Throwable)var18_15);
lbl41:
                    // 5 sources

                    while (true) {
                        if (var9_9 == 0) {
                            try {
                                IoUtils.closeQuietly(var11_11);
                                var11_11 = null;
                                this.handleChildProc(var1_1, var7_4, var10_10, var8_6);
                            }
                            catch (Throwable var14_34) {
                                IoUtils.closeQuietly(var10_10);
                                IoUtils.closeQuietly(var11_11);
                                throw var14_34;
                            }
                            IoUtils.closeQuietly(var10_10);
                            IoUtils.closeQuietly(null);
                            return true;
                        }
                        ** GOTO lbl-1000
                        break;
                    }
                    break;
                }
            }
            catch (ErrnoException var13_24) lbl-1000:
            // 2 sources

            {
                while (true) {
                    ZygoteConnection.logAndPrintError(var8_6, "Exception creating pipe", (Throwable)var13_25);
                    ** GOTO lbl41
                    break;
                }
            }
            catch (IllegalArgumentException var16_27) lbl-1000:
            // 2 sources

            {
                while (true) {
                    ZygoteConnection.logAndPrintError(var8_6, "Invalid zygote arguments", (Throwable)var16_28);
                    ** GOTO lbl41
                    break;
                }
            }
            catch (ZygoteSecurityException var17_30) lbl-1000:
            // 2 sources

            {
                while (true) {
                    ZygoteConnection.logAndPrintError(var8_6, "Zygote security policy prevents request: ", (Throwable)var17_31);
                    ** GOTO lbl41
                    break;
                }
            }
lbl-1000:
            // 1 sources

            {
                IoUtils.closeQuietly(var10_10);
                var10_10 = null;
                var15_33 = this.handleParentProc(var9_9, var7_4, var11_11, var1_1);
            }
            IoUtils.closeQuietly(null);
            IoUtils.closeQuietly(var11_11);
            return var15_33;
            catch (IOException var18_16) {
                var10_10 = null;
                var1_1 = null;
                var11_11 = null;
                ** continue;
            }
        }
        try {
            ZygoteConnection.applyUidSecurityPolicy(var12_12, this.peer, this.peerSecurityContext);
            ZygoteConnection.applyRlimitSecurityPolicy(var12_12, this.peer, this.peerSecurityContext);
            ZygoteConnection.applyInvokeWithSecurityPolicy(var12_12, this.peer, this.peerSecurityContext);
            ZygoteConnection.applyseInfoSecurityPolicy(var12_12, this.peer, this.peerSecurityContext);
            this.checkTime(var2_2, "zygoteConnection.runOnce: apply security policies");
            ZygoteConnection.applyDebuggerSystemProperty(var12_12);
            ZygoteConnection.applyInvokeWithSystemProperty(var12_12);
            this.checkTime(var2_2, "zygoteConnection.runOnce: apply security policies");
            var20_17 = null;
            if (var12_12.rlimits != null) {
                var20_17 = (int[][])var12_12.rlimits.toArray((T[])ZygoteConnection.intArray2d);
            }
            var21_18 = var12_12.runtimeInit;
            var10_10 = null;
            var11_11 = null;
            if (var21_18) {
                var22_19 = var12_12.invokeWith;
                var10_10 = null;
                var11_11 = null;
                if (var22_19 != null) {
                    var23_20 = Os.pipe();
                    var10_10 = var23_20[1];
                    var11_11 = var23_20[0];
                    ZygoteInit.setCloseOnExec(var11_11, true);
                }
            }
            var24_21 = new int[]{-1, -1};
            var25_22 = this.mSocket.getFileDescriptor();
            if (var25_22 != null) {
                var24_21[0] = var25_22.getInt$();
            }
            if ((var26_23 = ZygoteInit.getServerSocketFileDescriptor()) != null) {
                var24_21[1] = var26_23.getInt$();
            }
            this.checkTime(var2_2, "zygoteConnection.runOnce: preForkAndSpecialize");
            var9_9 = Zygote.forkAndSpecialize(var12_12.uid, var12_12.gid, var12_12.gids, var12_12.debugFlags, var20_17, var12_12.mountExternal, var12_12.seInfo, var12_12.niceName, var24_21, var12_12.instructionSet, var12_12.appDataDir);
            this.checkTime(var2_2, "zygoteConnection.runOnce: postForkAndSpecialize");
            var1_1 = var12_12;
            ** continue;
        }
        catch (ZygoteSecurityException var17_32) {
            var1_1 = var12_12;
            ** continue;
        }
        catch (IllegalArgumentException var16_29) {
            var1_1 = var12_12;
            ** continue;
        }
        catch (ErrnoException var13_26) {
            var1_1 = var12_12;
            ** continue;
        }
    }

    static class Arguments {
        boolean abiListQuery;
        String appDataDir;
        boolean capabilitiesSpecified;
        String classpath;
        int debugFlags;
        long effectiveCapabilities;
        int gid = 0;
        boolean gidSpecified;
        int[] gids;
        String instructionSet;
        String invokeWith;
        int mountExternal = 0;
        String niceName;
        long permittedCapabilities;
        String[] remainingArgs;
        ArrayList<int[]> rlimits;
        boolean runtimeInit;
        String seInfo;
        boolean seInfoSpecified;
        int targetSdkVersion;
        boolean targetSdkVersionSpecified;
        int uid = 0;
        boolean uidSpecified;

        Arguments(String[] stringArray) throws IllegalArgumentException {
            this.parseArgs(stringArray);
        }

        /*
         * Unable to fully structure code
         */
        private void parseArgs(String[] var1_1) throws IllegalArgumentException {
            block21: {
                block43: {
                    block42: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        block37: {
                                            block36: {
                                                block35: {
                                                    block33: {
                                                        block34: {
                                                            block32: {
                                                                block31: {
                                                                    block30: {
                                                                        block29: {
                                                                            block28: {
                                                                                block27: {
                                                                                    block26: {
                                                                                        block25: {
                                                                                            block24: {
                                                                                                var2_2 = 0;
                                                                                                block4: while (true) {
                                                                                                    block23: {
                                                                                                        block22: {
                                                                                                            if (var2_2 >= var1_1.length) break block22;
                                                                                                            var3_3 = var1_1[var2_2];
                                                                                                            if (!var3_3.equals("--")) break block23;
                                                                                                            ++var2_2;
                                                                                                        }
lbl8:
                                                                                                        // 2 sources

                                                                                                        while (this.runtimeInit && this.classpath != null) {
                                                                                                            throw new IllegalArgumentException("--runtime-init and -classpath are incompatible");
                                                                                                        }
                                                                                                        break block21;
                                                                                                    }
                                                                                                    if (!var3_3.startsWith("--setuid=")) break;
                                                                                                    if (this.uidSpecified) {
                                                                                                        throw new IllegalArgumentException("Duplicate arg specified");
                                                                                                    }
                                                                                                    this.uidSpecified = true;
                                                                                                    this.uid = Integer.parseInt(var3_3.substring(1 + var3_3.indexOf(61)));
lbl17:
                                                                                                    // 22 sources

                                                                                                    while (true) {
                                                                                                        ++var2_2;
                                                                                                        continue block4;
                                                                                                        break;
                                                                                                    }
                                                                                                    break;
                                                                                                }
                                                                                                if (!var3_3.startsWith("--setgid=")) break block24;
                                                                                                if (this.gidSpecified) {
                                                                                                    throw new IllegalArgumentException("Duplicate arg specified");
                                                                                                }
                                                                                                this.gidSpecified = true;
                                                                                                this.gid = Integer.parseInt(var3_3.substring(1 + var3_3.indexOf(61)));
                                                                                                ** GOTO lbl17
                                                                                            }
                                                                                            if (!var3_3.startsWith("--target-sdk-version=")) break block25;
                                                                                            if (this.targetSdkVersionSpecified) {
                                                                                                throw new IllegalArgumentException("Duplicate target-sdk-version specified");
                                                                                            }
                                                                                            this.targetSdkVersionSpecified = true;
                                                                                            this.targetSdkVersion = Integer.parseInt(var3_3.substring(1 + var3_3.indexOf(61)));
                                                                                            ** GOTO lbl17
                                                                                        }
                                                                                        if (!var3_3.equals("--enable-debugger")) break block26;
                                                                                        this.debugFlags = 1 | this.debugFlags;
                                                                                        ** GOTO lbl17
                                                                                    }
                                                                                    if (!var3_3.equals("--enable-safemode")) break block27;
                                                                                    this.debugFlags = 8 | this.debugFlags;
                                                                                    ** GOTO lbl17
                                                                                }
                                                                                if (!var3_3.equals("--enable-checkjni")) break block28;
                                                                                this.debugFlags = 2 | this.debugFlags;
                                                                                ** GOTO lbl17
                                                                            }
                                                                            if (!var3_3.equals("--enable-jni-logging")) break block29;
                                                                            this.debugFlags = 16 | this.debugFlags;
                                                                            ** GOTO lbl17
                                                                        }
                                                                        if (!var3_3.equals("--enable-assert")) break block30;
                                                                        this.debugFlags = 4 | this.debugFlags;
                                                                        ** GOTO lbl17
                                                                    }
                                                                    if (!var3_3.equals("--runtime-init")) break block31;
                                                                    this.runtimeInit = true;
                                                                    ** GOTO lbl17
                                                                }
                                                                if (!var3_3.startsWith("--seinfo=")) break block32;
                                                                if (this.seInfoSpecified) {
                                                                    throw new IllegalArgumentException("Duplicate arg specified");
                                                                }
                                                                this.seInfoSpecified = true;
                                                                this.seInfo = var3_3.substring(1 + var3_3.indexOf(61));
                                                                ** GOTO lbl17
                                                            }
                                                            if (!var3_3.startsWith("--capabilities=")) break block33;
                                                            if (this.capabilitiesSpecified) {
                                                                throw new IllegalArgumentException("Duplicate arg specified");
                                                            }
                                                            this.capabilitiesSpecified = true;
                                                            var12_9 = var3_3.substring(1 + var3_3.indexOf(61)).split(",", 2);
                                                            if (var12_9.length != 1) break block34;
                                                            this.permittedCapabilities = this.effectiveCapabilities = Long.decode(var12_9[0]).longValue();
                                                            ** GOTO lbl17
                                                        }
                                                        this.permittedCapabilities = Long.decode(var12_9[0]);
                                                        this.effectiveCapabilities = Long.decode(var12_9[1]);
                                                        ** GOTO lbl17
                                                    }
                                                    if (!var3_3.startsWith("--rlimit=")) break block35;
                                                    var8_6 = var3_3.substring(1 + var3_3.indexOf(61)).split(",");
                                                    if (var8_6.length != 3) {
                                                        throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                                                    }
                                                    var9_7 = new int[var8_6.length];
                                                    for (var10_8 = 0; var10_8 < var8_6.length; ++var10_8) {
                                                        var9_7[var10_8] = Integer.parseInt(var8_6[var10_8]);
                                                    }
                                                    if (this.rlimits == null) {
                                                        this.rlimits = new ArrayList<E>();
                                                    }
                                                    this.rlimits.add(var9_7);
                                                    ** GOTO lbl17
                                                }
                                                if (!var3_3.equals("-classpath")) break block36;
                                                if (this.classpath != null) {
                                                    throw new IllegalArgumentException("Duplicate arg specified");
                                                }
                                                ++var2_2;
                                                try {
                                                    this.classpath = var1_1[var2_2];
                                                    ** GOTO lbl17
                                                }
                                                catch (IndexOutOfBoundsException var7_10) {
                                                    throw new IllegalArgumentException("-classpath requires argument");
                                                }
                                            }
                                            if (!var3_3.startsWith("--setgroups=")) break block37;
                                            if (this.gids != null) {
                                                throw new IllegalArgumentException("Duplicate arg specified");
                                            }
                                            var5_4 = var3_3.substring(1 + var3_3.indexOf(61)).split(",");
                                            this.gids = new int[var5_4.length];
                                            var6_5 = -1 + var5_4.length;
                                            while (true) {
                                                if (var6_5 < 0) ** GOTO lbl17
                                                this.gids[var6_5] = Integer.parseInt(var5_4[var6_5]);
                                                --var6_5;
                                            }
                                        }
                                        if (!var3_3.equals("--invoke-with")) break block38;
                                        if (this.invokeWith != null) {
                                            throw new IllegalArgumentException("Duplicate arg specified");
                                        }
                                        ++var2_2;
                                        try {
                                            this.invokeWith = var1_1[var2_2];
                                            ** GOTO lbl17
                                        }
                                        catch (IndexOutOfBoundsException var4_11) {
                                            throw new IllegalArgumentException("--invoke-with requires argument");
                                        }
                                    }
                                    if (!var3_3.startsWith("--nice-name=")) break block39;
                                    if (this.niceName != null) {
                                        throw new IllegalArgumentException("Duplicate arg specified");
                                    }
                                    this.niceName = var3_3.substring(1 + var3_3.indexOf(61));
                                    ** GOTO lbl17
                                }
                                if (!var3_3.equals("--mount-external-multiuser")) break block40;
                                this.mountExternal = 2;
                                ** GOTO lbl17
                            }
                            if (!var3_3.equals("--mount-external-multiuser-all")) break block41;
                            this.mountExternal = 3;
                            ** GOTO lbl17
                        }
                        if (!var3_3.equals("--query-abi-list")) break block42;
                        this.abiListQuery = true;
                        ** GOTO lbl17
                    }
                    if (!var3_3.startsWith("--instruction-set=")) break block43;
                    this.instructionSet = var3_3.substring(1 + var3_3.indexOf(61));
                    ** GOTO lbl17
                }
                if (!var3_3.startsWith("--app-data-dir=")) ** GOTO lbl8
                this.appDataDir = var3_3.substring(1 + var3_3.indexOf(61));
                ** while (true)
            }
            this.remainingArgs = new String[var1_1.length - var2_2];
            System.arraycopy(var1_1, var2_2, this.remainingArgs, 0, this.remainingArgs.length);
        }
    }
}

