/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import java.io.FileDescriptor;
import java.io.IOException;

public final class TransferPipe
implements Runnable {
    static final boolean DEBUG = false;
    static final long DEFAULT_TIMEOUT = 5000L;
    static final String TAG = "TransferPipe";
    String mBufferPrefix;
    boolean mComplete;
    long mEndTime;
    String mFailure;
    final ParcelFileDescriptor[] mFds;
    FileDescriptor mOutFd;
    final Thread mThread = new Thread(this, "TransferPipe");

    public TransferPipe() throws IOException {
        this.mFds = ParcelFileDescriptor.createPipe();
    }

    static void go(Caller caller, IInterface iInterface, FileDescriptor fileDescriptor, String string2, String[] stringArray) throws IOException, RemoteException {
        TransferPipe.go(caller, iInterface, fileDescriptor, string2, stringArray, 5000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void go(Caller caller, IInterface iInterface, FileDescriptor fileDescriptor, String string2, String[] stringArray, long l) throws IOException, RemoteException {
        if (iInterface.asBinder() instanceof Binder) {
            try {
                caller.go(iInterface, fileDescriptor, string2, stringArray);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
        TransferPipe transferPipe = new TransferPipe();
        try {
            caller.go(iInterface, transferPipe.getWriteFd().getFileDescriptor(), string2, stringArray);
            transferPipe.go(fileDescriptor, l);
            return;
        }
        finally {
            transferPipe.kill();
        }
    }

    static void goDump(IBinder iBinder, FileDescriptor fileDescriptor, String[] stringArray) throws IOException, RemoteException {
        TransferPipe.goDump(iBinder, fileDescriptor, stringArray, 5000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void goDump(IBinder iBinder, FileDescriptor fileDescriptor, String[] stringArray, long l) throws IOException, RemoteException {
        if (iBinder instanceof Binder) {
            try {
                iBinder.dump(fileDescriptor, stringArray);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
        TransferPipe transferPipe = new TransferPipe();
        try {
            iBinder.dumpAsync(transferPipe.getWriteFd().getFileDescriptor(), stringArray);
            transferPipe.go(fileDescriptor, l);
            return;
        }
        finally {
            transferPipe.kill();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void closeFd(int n) {
        if (this.mFds[n] != null) {
            try {
                this.mFds[n].close();
            }
            catch (IOException iOException) {}
            this.mFds[n] = null;
        }
    }

    ParcelFileDescriptor getReadFd() {
        return this.mFds[0];
    }

    public ParcelFileDescriptor getWriteFd() {
        return this.mFds[1];
    }

    public void go(FileDescriptor fileDescriptor) throws IOException {
        this.go(fileDescriptor, 5000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void go(FileDescriptor fileDescriptor, long l) throws IOException {
        try {
            synchronized (this) {
                this.mOutFd = fileDescriptor;
            }
        }
        catch (Throwable throwable) {
            this.kill();
            throw throwable;
        }
        {
            this.mEndTime = l + SystemClock.uptimeMillis();
            this.closeFd(1);
            this.mThread.start();
            while (this.mFailure == null && !this.mComplete) {
                long l2 = this.mEndTime - SystemClock.uptimeMillis();
                if (l2 <= 0L) {
                    this.mThread.interrupt();
                    throw new IOException("Timeout");
                }
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.mFailure != null) {
                throw new IOException(this.mFailure);
            }
        }
        this.kill();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void kill() {
        synchronized (this) {
            this.closeFd(0);
            this.closeFd(1);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [6 : 134->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setBufferPrefix(String string2) {
        this.mBufferPrefix = string2;
    }

    static interface Caller {
        public void go(IInterface var1, FileDescriptor var2, String var3, String[] var4) throws RemoteException;
    }
}

