/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.util.Log;
import com.android.internal.util.XmlUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParserException;

public class PowerProfile {
    private static final String ATTR_NAME = "name";
    public static final String POWER_AUDIO = "dsp.audio";
    public static final String POWER_BATTERY_CAPACITY = "battery.capacity";
    public static final String POWER_BLUETOOTH_ACTIVE = "bluetooth.active";
    public static final String POWER_BLUETOOTH_AT_CMD = "bluetooth.at";
    public static final String POWER_BLUETOOTH_ON = "bluetooth.on";
    public static final String POWER_CPU_ACTIVE = "cpu.active";
    public static final String POWER_CPU_AWAKE = "cpu.awake";
    public static final String POWER_CPU_IDLE = "cpu.idle";
    public static final String POWER_CPU_SPEEDS = "cpu.speeds";
    public static final String POWER_FLASHLIGHT = "camera.flashlight";
    public static final String POWER_GPS_ON = "gps.on";
    public static final String POWER_NONE = "none";
    public static final String POWER_RADIO_ACTIVE = "radio.active";
    public static final String POWER_RADIO_ON = "radio.on";
    public static final String POWER_RADIO_SCANNING = "radio.scanning";
    public static final String POWER_SCREEN_FULL = "screen.full";
    public static final String POWER_SCREEN_ON = "screen.on";
    public static final String POWER_VIDEO = "dsp.video";
    public static final String POWER_WIFI_ACTIVE = "wifi.active";
    public static final String POWER_WIFI_BATCHED_SCAN = "wifi.batchedscan";
    public static final String POWER_WIFI_ON = "wifi.on";
    public static final String POWER_WIFI_SCAN = "wifi.scan";
    public static final String PROJECTID = PowerProfile.getProjectID();
    public static final String PRO_ID_A600CG = "7";
    public static final String PRO_ID_A601CG = "5";
    public static final String TAG = "PowerProfile";
    private static final String TAG_ARRAY = "array";
    private static final String TAG_ARRAYITEM = "value";
    private static final String TAG_DEVICE = "device";
    private static final String TAG_ITEM = "item";
    private static final String TAG_PROJECT = "project";
    static final HashMap<String, Object> sPowerMap = new HashMap();

    public PowerProfile(Context context) {
        if (sPowerMap.size() == 0) {
            this.readPowerValuesFromXml(context);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileText(String string2) {
        BufferedReader bufferedReader;
        File file = new File(string2);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string3;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3);
            }
        }
        catch (IOException iOException) {
            return stringBuilder.toString();
        }
        {
            bufferedReader.close();
            return stringBuilder.toString();
        }
    }

    public static String getProjectID() {
        return PowerProfile.getFileText("/sys/module/intel_mid_sfi/parameters/project_id");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPowerValuesFromXml(Context context) {
        XmlResourceParser xmlResourceParser = context.getResources().getXml(0x111000F);
        boolean bl = false;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string2 = null;
        try {
            XmlUtils.beginDocument(xmlResourceParser, TAG_DEVICE);
            while (true) {
                String string3;
                block22: {
                    XmlUtils.nextElement(xmlResourceParser);
                    string3 = xmlResourceParser.getName();
                    if (string3 == null) {
                        if (!bl) return;
                        sPowerMap.put(string2, arrayList.toArray(new Double[arrayList.size()]));
                        return;
                    }
                    if (string3.equals(TAG_PROJECT)) {
                        String string4 = xmlResourceParser.getAttributeValue(null, ATTR_NAME);
                        if (PROJECTID.equals(PRO_ID_A600CG) || PROJECTID.equals(PRO_ID_A601CG)) {
                            Log.i(TAG, "use a600cg power profile");
                            if (!"a600cg".equals(string4)) {
                                Log.i(TAG, "Skip project: " + string4);
                                XmlUtils.skipCurrentTag(xmlResourceParser);
                            }
                        } else {
                            Log.i(TAG, "use a500cg power profile");
                            if (!"a500cg".equals(string4)) {
                                Log.i(TAG, "Skip project: " + string4);
                                XmlUtils.skipCurrentTag(xmlResourceParser);
                            }
                        }
                    }
                    if (bl && !string3.equals(TAG_ARRAYITEM)) {
                        sPowerMap.put(string2, arrayList.toArray(new Double[arrayList.size()]));
                        bl = false;
                    }
                    if (!string3.equals(TAG_ARRAY)) break block22;
                    bl = true;
                    arrayList.clear();
                    string2 = xmlResourceParser.getAttributeValue(null, ATTR_NAME);
                }
                if (!string3.equals(TAG_ITEM) && !string3.equals(TAG_ARRAYITEM)) continue;
                String string5 = null;
                if (!bl) {
                    string5 = xmlResourceParser.getAttributeValue(null, ATTR_NAME);
                }
                if (xmlResourceParser.next() != 4) continue;
                String string6 = xmlResourceParser.getText();
                double d = 0.0;
                try {
                    double d2;
                    d = d2 = Double.valueOf(string6).doubleValue();
                }
                catch (NumberFormatException numberFormatException) {}
                if (string3.equals(TAG_ITEM)) {
                    sPowerMap.put(string5, d);
                    continue;
                }
                if (!bl) continue;
                arrayList.add(d);
                continue;
                break;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException(xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            xmlResourceParser.close();
        }
    }

    public double getAveragePower(String string2) {
        if (sPowerMap.containsKey(string2)) {
            Object object = sPowerMap.get(string2);
            if (object instanceof Double[]) {
                return ((Double[])object)[0];
            }
            return (Double)sPowerMap.get(string2);
        }
        return 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getAveragePower(String string2, int n) {
        double d = 0.0;
        if (!sPowerMap.containsKey(string2)) return d;
        Object object = sPowerMap.get(string2);
        if (!(object instanceof Double[])) return (Double)object;
        Double[] doubleArray = (Double[])object;
        if (doubleArray.length > n && n >= 0) {
            return doubleArray[n];
        }
        if (n < 0) return d;
        return doubleArray[-1 + doubleArray.length];
    }

    public double getBatteryCapacity() {
        return this.getAveragePower(POWER_BATTERY_CAPACITY);
    }

    public int getNumSpeedSteps() {
        Object object = sPowerMap.get(POWER_CPU_SPEEDS);
        if (object != null && object instanceof Double[]) {
            return ((Double[])object).length;
        }
        return 1;
    }
}

