/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.IBinder;
import android.os.SystemClock;
import android.util.EventLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class BinderInternal {
    static WeakReference<GcWatcher> sGcWatcher = new WeakReference<GcWatcher>(new GcWatcher());
    static ArrayList<Runnable> sGcWatchers = new ArrayList();
    static long sLastGcTime;
    static Runnable[] sTmpWatchers;

    static {
        sTmpWatchers = new Runnable[1];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addGcWatcher(Runnable runnable) {
        ArrayList<Runnable> arrayList = sGcWatchers;
        synchronized (arrayList) {
            sGcWatchers.add(runnable);
            return;
        }
    }

    public static final native void disableBackgroundScheduling(boolean var0);

    static void forceBinderGc() {
        BinderInternal.forceGc("Binder");
    }

    public static void forceGc(String string2) {
        EventLog.writeEvent(2741, string2);
        Runtime.getRuntime().gc();
    }

    public static final native IBinder getContextObject();

    public static long getLastGcTime() {
        return sLastGcTime;
    }

    static final native void handleGc();

    public static final native void joinThreadPool();

    static final class GcWatcher {
        GcWatcher() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            BinderInternal.handleGc();
            sLastGcTime = SystemClock.uptimeMillis();
            ArrayList<Runnable> arrayList = sGcWatchers;
            synchronized (arrayList) {
                sTmpWatchers = sGcWatchers.toArray(sTmpWatchers);
            }
            int n = 0;
            while (true) {
                if (n >= sTmpWatchers.length) {
                    sGcWatcher = new WeakReference<GcWatcher>(new GcWatcher());
                    return;
                }
                if (sTmpWatchers[n] != null) {
                    sTmpWatchers[n].run();
                }
                ++n;
            }
        }
    }
}

