/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkStats;
import android.net.wifi.WifiManager;
import android.os.BadParcelableException;
import android.os.BatteryStats;
import android.os.Build;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.SignalStrength;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.LogWriter;
import android.util.MutableInt;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.net.NetworkStatsFactory;
import com.android.internal.os.AtomicFile;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BatteryStatsHelper;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.JournaledFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class BatteryStatsImpl
extends BatteryStats {
    private static final int BATTERY_PLUGGED_NONE = 0;
    public static final Parcelable.Creator<BatteryStatsImpl> CREATOR;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_HISTORY = false;
    static final long DELAY_UPDATE_WAKELOCKS = 5000L;
    static final int DELTA_BATTERY_LEVEL_FLAG = 524288;
    static final int DELTA_EVENT_FLAG = 0x800000;
    static final int DELTA_STATE2_FLAG = 0x200000;
    static final int DELTA_STATE_FLAG = 0x100000;
    static final int DELTA_STATE_MASK = -16777216;
    static final int DELTA_TIME_ABS = 524285;
    static final int DELTA_TIME_INT = 524286;
    static final int DELTA_TIME_LONG = 524287;
    static final int DELTA_TIME_MASK = 524287;
    static final int DELTA_WAKELOCK_FLAG = 0x400000;
    private static final int MAGIC = -1166707595;
    static final int MAX_HISTORY_BUFFER = 262144;
    private static final int MAX_HISTORY_ITEMS = 2000;
    static final int MAX_LEVEL_STEPS = 200;
    static final int MAX_MAX_HISTORY_BUFFER = 327680;
    private static final int MAX_MAX_HISTORY_ITEMS = 3000;
    private static final int MAX_WAKELOCKS_PER_UID = 100;
    static final int MSG_REPORT_POWER_CHANGE = 2;
    static final int MSG_UPDATE_WAKELOCKS = 1;
    static final int NET_UPDATE_ALL = 65535;
    static final int NET_UPDATE_MOBILE = 1;
    static final int NET_UPDATE_WIFI = 2;
    private static final int[] PROC_WAKELOCKS_FORMAT;
    static final int STATE_BATTERY_HEALTH_MASK = 7;
    static final int STATE_BATTERY_HEALTH_SHIFT = 26;
    static final int STATE_BATTERY_PLUG_MASK = 3;
    static final int STATE_BATTERY_PLUG_SHIFT = 24;
    static final int STATE_BATTERY_STATUS_MASK = 7;
    static final int STATE_BATTERY_STATUS_SHIFT = 29;
    private static final String TAG = "BatteryStatsImpl";
    private static final boolean USE_OLD_HISTORY = false;
    private static final int VERSION = 114;
    private static final int[] WAKEUP_SOURCES_FORMAT;
    private static int sKernelWakelockUpdateVersion;
    private static int sNumSpeedSteps;
    final BatteryStats.HistoryEventTracker mActiveEvents;
    int mAudioOnNesting;
    StopwatchTimer mAudioOnTimer;
    final ArrayList<StopwatchTimer> mAudioTurnedOnTimers;
    boolean mBluetoothOn;
    StopwatchTimer mBluetoothOnTimer;
    private int mBluetoothPingCount;
    private int mBluetoothPingStart = -1;
    int mBluetoothState = -1;
    final StopwatchTimer[] mBluetoothStateTimer;
    BluetoothHeadset mBtHeadset;
    private BatteryCallback mCallback;
    int mChangedStates = 0;
    int mChangedStates2 = 0;
    final long[] mChargeStepDurations;
    public final AtomicFile mCheckinFile;
    private NetworkStats mCurMobileSnapshot;
    int mCurStepMode = 0;
    private NetworkStats mCurWifiSnapshot;
    int mCurrentBatteryLevel;
    int mDischargeAmountScreenOff;
    int mDischargeAmountScreenOffSinceCharge;
    int mDischargeAmountScreenOn;
    int mDischargeAmountScreenOnSinceCharge;
    int mDischargeCurrentLevel;
    int mDischargePlugLevel;
    int mDischargeScreenOffUnplugLevel;
    int mDischargeScreenOnUnplugLevel;
    int mDischargeStartLevel;
    final long[] mDischargeStepDurations;
    int mDischargeUnplugLevel;
    boolean mDistributeWakelockCpu;
    String mEndPlatformVersion;
    private final JournaledFile mFile;
    boolean mFlashlightOn;
    StopwatchTimer mFlashlightOnTimer;
    final ArrayList<StopwatchTimer> mFullTimers;
    final ArrayList<StopwatchTimer> mFullWifiLockTimers;
    boolean mGlobalWifiRunning;
    StopwatchTimer mGlobalWifiRunningTimer;
    int mGpsNesting;
    public final MyHandler mHandler;
    boolean mHaveBatteryLevel = false;
    int mHighDischargeAmountSinceCharge;
    BatteryStats.HistoryItem mHistory;
    final BatteryStats.HistoryItem mHistoryAddTmp;
    long mHistoryBaseTime;
    final Parcel mHistoryBuffer;
    int mHistoryBufferLastPos = -1;
    BatteryStats.HistoryItem mHistoryCache;
    final BatteryStats.HistoryItem mHistoryCur;
    BatteryStats.HistoryItem mHistoryEnd;
    private BatteryStats.HistoryItem mHistoryIterator;
    BatteryStats.HistoryItem mHistoryLastEnd;
    final BatteryStats.HistoryItem mHistoryLastLastWritten;
    final BatteryStats.HistoryItem mHistoryLastWritten;
    boolean mHistoryOverflow = false;
    final BatteryStats.HistoryItem mHistoryReadTmp;
    final HashMap<BatteryStats.HistoryTag, Integer> mHistoryTagPool;
    int mInitStepMode = 0;
    private String mInitialAcquireWakeName;
    private int mInitialAcquireWakeUid = -1;
    boolean mInteractive;
    StopwatchTimer mInteractiveTimer;
    final SparseIntArray mIsolatedUids = new SparseIntArray();
    private boolean mIteratingHistory;
    private final HashMap<String, SamplingTimer> mKernelWakelockStats;
    int mLastChargeStepLevel;
    long mLastChargeStepTime;
    int mLastDischargeStepLevel;
    long mLastDischargeStepTime;
    long mLastHistoryElapsedRealtime = 0L;
    private NetworkStats mLastMobileSnapshot;
    final ArrayList<StopwatchTimer> mLastPartialTimers;
    long mLastRecordedClockRealtime;
    long mLastRecordedClockTime;
    String mLastWakeupReason = null;
    long mLastWakeupUptimeMs = 0L;
    private NetworkStats mLastWifiSnapshot;
    long mLastWriteTime = 0L;
    int mLowDischargeAmountSinceCharge;
    boolean mLowPowerModeEnabled;
    StopwatchTimer mLowPowerModeEnabledTimer;
    int mMaxChargeStepLevel;
    int mMinDischargeStepLevel;
    @GuardedBy(value="this")
    private String[] mMobileIfaces;
    LongSamplingCounter mMobileRadioActiveAdjustedTime;
    StopwatchTimer mMobileRadioActivePerAppTimer;
    long mMobileRadioActiveStartTime;
    StopwatchTimer mMobileRadioActiveTimer;
    LongSamplingCounter mMobileRadioActiveUnknownCount;
    LongSamplingCounter mMobileRadioActiveUnknownTime;
    int mMobileRadioPowerState;
    int mModStepMode = 0;
    final LongSamplingCounter[] mNetworkByteActivityCounters;
    final LongSamplingCounter[] mNetworkPacketActivityCounters;
    private final NetworkStatsFactory mNetworkStatsFactory;
    int mNextHistoryTagIdx = 0;
    boolean mNoAutoReset;
    int mNumChargeStepDurations;
    int mNumDischargeStepDurations;
    int mNumHistoryItems;
    int mNumHistoryTagChars = 0;
    boolean mOnBattery;
    boolean mOnBatteryInternal;
    final TimeBase mOnBatteryScreenOffTimeBase;
    final TimeBase mOnBatteryTimeBase;
    final ArrayList<StopwatchTimer> mPartialTimers;
    Parcel mPendingWrite = null;
    int mPhoneDataConnectionType = -1;
    final StopwatchTimer[] mPhoneDataConnectionsTimer;
    boolean mPhoneOn;
    StopwatchTimer mPhoneOnTimer;
    private int mPhoneServiceState = -1;
    private int mPhoneServiceStateRaw = -1;
    StopwatchTimer mPhoneSignalScanningTimer;
    int mPhoneSignalStrengthBin = -1;
    int mPhoneSignalStrengthBinRaw = -1;
    final StopwatchTimer[] mPhoneSignalStrengthsTimer;
    private int mPhoneSimStateRaw = -1;
    private final Map<String, KernelWakelockStats> mProcWakelockFileStats;
    private final long[] mProcWakelocksData;
    private final String[] mProcWakelocksName;
    int mReadHistoryChars;
    String[] mReadHistoryStrings;
    int[] mReadHistoryUids;
    private boolean mReadOverflow;
    long mRealtime;
    long mRealtimeStart;
    boolean mRecordAllHistory;
    boolean mRecordingHistory = false;
    int mScreenBrightnessBin = -1;
    final StopwatchTimer[] mScreenBrightnessTimer;
    StopwatchTimer mScreenOnTimer;
    int mScreenState = 0;
    int mSensorNesting;
    final SparseArray<ArrayList<StopwatchTimer>> mSensorTimers;
    boolean mShuttingDown;
    long mStartClockTime;
    int mStartCount;
    String mStartPlatformVersion;
    private NetworkStats mTmpNetworkStats;
    private final NetworkStats.Entry mTmpNetworkStatsEntry;
    long mTrackRunningHistoryElapsedRealtime = 0L;
    long mTrackRunningHistoryUptime = 0L;
    final SparseArray<Uid> mUidStats = new SparseArray();
    long mUptime;
    long mUptimeStart;
    int mVideoOnNesting;
    StopwatchTimer mVideoOnTimer;
    final ArrayList<StopwatchTimer> mVideoTurnedOnTimers;
    boolean mWakeLockImportant;
    int mWakeLockNesting;
    private final HashMap<String, SamplingTimer> mWakeupReasonStats;
    final SparseArray<ArrayList<StopwatchTimer>> mWifiBatchedScanTimers;
    int mWifiFullLockNesting = 0;
    @GuardedBy(value="this")
    private String[] mWifiIfaces;
    int mWifiMulticastNesting = 0;
    final ArrayList<StopwatchTimer> mWifiMulticastTimers;
    boolean mWifiOn;
    StopwatchTimer mWifiOnTimer;
    final ArrayList<StopwatchTimer> mWifiRunningTimers;
    int mWifiScanNesting = 0;
    final ArrayList<StopwatchTimer> mWifiScanTimers;
    int mWifiSignalStrengthBin = -1;
    final StopwatchTimer[] mWifiSignalStrengthsTimer;
    int mWifiState = -1;
    final StopwatchTimer[] mWifiStateTimer;
    int mWifiSupplState = -1;
    final StopwatchTimer[] mWifiSupplStateTimer;
    final ArrayList<StopwatchTimer> mWindowTimers;
    final ReentrantLock mWriteLock;

    static {
        sKernelWakelockUpdateVersion = 0;
        PROC_WAKELOCKS_FORMAT = new int[]{5129, 8201, 9, 9, 9, 8201};
        WAKEUP_SOURCES_FORMAT = new int[]{4105, 8457, 265, 265, 265, 265, 8457};
        CREATOR = new Parcelable.Creator<BatteryStatsImpl>(){

            @Override
            public BatteryStatsImpl createFromParcel(Parcel parcel) {
                return new BatteryStatsImpl(parcel);
            }

            public BatteryStatsImpl[] newArray(int n) {
                return new BatteryStatsImpl[n];
            }
        };
    }

    public BatteryStatsImpl() {
        this.mPartialTimers = new ArrayList();
        this.mFullTimers = new ArrayList();
        this.mWindowTimers = new ArrayList();
        this.mSensorTimers = new SparseArray();
        this.mWifiRunningTimers = new ArrayList();
        this.mFullWifiLockTimers = new ArrayList();
        this.mWifiMulticastTimers = new ArrayList();
        this.mWifiScanTimers = new ArrayList();
        this.mWifiBatchedScanTimers = new SparseArray();
        this.mAudioTurnedOnTimers = new ArrayList();
        this.mVideoTurnedOnTimers = new ArrayList();
        this.mLastPartialTimers = new ArrayList();
        this.mOnBatteryTimeBase = new TimeBase();
        this.mOnBatteryScreenOffTimeBase = new TimeBase();
        this.mActiveEvents = new BatteryStats.HistoryEventTracker();
        this.mHistoryBuffer = Parcel.obtain();
        this.mHistoryLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryLastLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryReadTmp = new BatteryStats.HistoryItem();
        this.mHistoryAddTmp = new BatteryStats.HistoryItem();
        this.mHistoryTagPool = new HashMap();
        this.mHistoryCur = new BatteryStats.HistoryItem();
        this.mScreenBrightnessTimer = new StopwatchTimer[5];
        this.mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
        this.mPhoneDataConnectionsTimer = new StopwatchTimer[17];
        this.mNetworkByteActivityCounters = new LongSamplingCounter[4];
        this.mNetworkPacketActivityCounters = new LongSamplingCounter[4];
        this.mWifiStateTimer = new StopwatchTimer[8];
        this.mWifiSupplStateTimer = new StopwatchTimer[13];
        this.mWifiSignalStrengthsTimer = new StopwatchTimer[5];
        this.mBluetoothStateTimer = new StopwatchTimer[4];
        this.mMobileRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
        this.mDischargeStepDurations = new long[200];
        this.mChargeStepDurations = new long[200];
        this.mKernelWakelockStats = new HashMap();
        this.mWakeupReasonStats = new HashMap();
        this.mProcWakelocksName = new String[3];
        this.mProcWakelocksData = new long[3];
        this.mProcWakelockFileStats = new HashMap<String, KernelWakelockStats>();
        this.mNetworkStatsFactory = new NetworkStatsFactory();
        this.mCurMobileSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mLastMobileSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mCurWifiSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mLastWifiSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mTmpNetworkStatsEntry = new NetworkStats.Entry();
        this.mMobileIfaces = new String[0];
        this.mWifiIfaces = new String[0];
        this.mWriteLock = new ReentrantLock();
        this.mFile = null;
        this.mCheckinFile = null;
        this.mHandler = null;
        this.clearHistoryLocked();
    }

    public BatteryStatsImpl(Parcel parcel) {
        this.mPartialTimers = new ArrayList();
        this.mFullTimers = new ArrayList();
        this.mWindowTimers = new ArrayList();
        this.mSensorTimers = new SparseArray();
        this.mWifiRunningTimers = new ArrayList();
        this.mFullWifiLockTimers = new ArrayList();
        this.mWifiMulticastTimers = new ArrayList();
        this.mWifiScanTimers = new ArrayList();
        this.mWifiBatchedScanTimers = new SparseArray();
        this.mAudioTurnedOnTimers = new ArrayList();
        this.mVideoTurnedOnTimers = new ArrayList();
        this.mLastPartialTimers = new ArrayList();
        this.mOnBatteryTimeBase = new TimeBase();
        this.mOnBatteryScreenOffTimeBase = new TimeBase();
        this.mActiveEvents = new BatteryStats.HistoryEventTracker();
        this.mHistoryBuffer = Parcel.obtain();
        this.mHistoryLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryLastLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryReadTmp = new BatteryStats.HistoryItem();
        this.mHistoryAddTmp = new BatteryStats.HistoryItem();
        this.mHistoryTagPool = new HashMap();
        this.mHistoryCur = new BatteryStats.HistoryItem();
        this.mScreenBrightnessTimer = new StopwatchTimer[5];
        this.mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
        this.mPhoneDataConnectionsTimer = new StopwatchTimer[17];
        this.mNetworkByteActivityCounters = new LongSamplingCounter[4];
        this.mNetworkPacketActivityCounters = new LongSamplingCounter[4];
        this.mWifiStateTimer = new StopwatchTimer[8];
        this.mWifiSupplStateTimer = new StopwatchTimer[13];
        this.mWifiSignalStrengthsTimer = new StopwatchTimer[5];
        this.mBluetoothStateTimer = new StopwatchTimer[4];
        this.mMobileRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
        this.mDischargeStepDurations = new long[200];
        this.mChargeStepDurations = new long[200];
        this.mKernelWakelockStats = new HashMap();
        this.mWakeupReasonStats = new HashMap();
        this.mProcWakelocksName = new String[3];
        this.mProcWakelocksData = new long[3];
        this.mProcWakelockFileStats = new HashMap<String, KernelWakelockStats>();
        this.mNetworkStatsFactory = new NetworkStatsFactory();
        this.mCurMobileSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mLastMobileSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mCurWifiSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mLastWifiSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mTmpNetworkStatsEntry = new NetworkStats.Entry();
        this.mMobileIfaces = new String[0];
        this.mWifiIfaces = new String[0];
        this.mWriteLock = new ReentrantLock();
        this.mFile = null;
        this.mCheckinFile = null;
        this.mHandler = null;
        this.clearHistoryLocked();
        this.readFromParcel(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    public BatteryStatsImpl(File file, Handler handler) {
        this.mPartialTimers = new ArrayList();
        this.mFullTimers = new ArrayList();
        this.mWindowTimers = new ArrayList();
        this.mSensorTimers = new SparseArray();
        this.mWifiRunningTimers = new ArrayList();
        this.mFullWifiLockTimers = new ArrayList();
        this.mWifiMulticastTimers = new ArrayList();
        this.mWifiScanTimers = new ArrayList();
        this.mWifiBatchedScanTimers = new SparseArray();
        this.mAudioTurnedOnTimers = new ArrayList();
        this.mVideoTurnedOnTimers = new ArrayList();
        this.mLastPartialTimers = new ArrayList();
        this.mOnBatteryTimeBase = new TimeBase();
        this.mOnBatteryScreenOffTimeBase = new TimeBase();
        this.mActiveEvents = new BatteryStats.HistoryEventTracker();
        this.mHistoryBuffer = Parcel.obtain();
        this.mHistoryLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryLastLastWritten = new BatteryStats.HistoryItem();
        this.mHistoryReadTmp = new BatteryStats.HistoryItem();
        this.mHistoryAddTmp = new BatteryStats.HistoryItem();
        this.mHistoryTagPool = new HashMap();
        this.mHistoryCur = new BatteryStats.HistoryItem();
        this.mScreenBrightnessTimer = new StopwatchTimer[5];
        this.mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
        this.mPhoneDataConnectionsTimer = new StopwatchTimer[17];
        this.mNetworkByteActivityCounters = new LongSamplingCounter[4];
        this.mNetworkPacketActivityCounters = new LongSamplingCounter[4];
        this.mWifiStateTimer = new StopwatchTimer[8];
        this.mWifiSupplStateTimer = new StopwatchTimer[13];
        this.mWifiSignalStrengthsTimer = new StopwatchTimer[5];
        this.mBluetoothStateTimer = new StopwatchTimer[4];
        this.mMobileRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
        this.mDischargeStepDurations = new long[200];
        this.mChargeStepDurations = new long[200];
        this.mKernelWakelockStats = new HashMap();
        this.mWakeupReasonStats = new HashMap();
        this.mProcWakelocksName = new String[3];
        this.mProcWakelocksData = new long[3];
        this.mProcWakelockFileStats = new HashMap<String, KernelWakelockStats>();
        this.mNetworkStatsFactory = new NetworkStatsFactory();
        this.mCurMobileSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mLastMobileSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mCurWifiSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mLastWifiSnapshot = new NetworkStats(SystemClock.elapsedRealtime(), 50);
        this.mTmpNetworkStatsEntry = new NetworkStats.Entry();
        this.mMobileIfaces = new String[0];
        this.mWifiIfaces = new String[0];
        this.mWriteLock = new ReentrantLock();
        this.mFile = file != null ? new JournaledFile(new File(file, "batterystats.bin"), new File(file, "batterystats.bin.tmp")) : null;
        this.mCheckinFile = new AtomicFile(new File(file, "batterystats-checkin.bin"));
        this.mHandler = new MyHandler(handler.getLooper());
        this.mStartCount = 1 + this.mStartCount;
        this.mScreenOnTimer = new StopwatchTimer(null, -1, null, this.mOnBatteryTimeBase);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(null, -100 - i, null, this.mOnBatteryTimeBase);
        }
        this.mInteractiveTimer = new StopwatchTimer(null, -9, null, this.mOnBatteryTimeBase);
        this.mLowPowerModeEnabledTimer = new StopwatchTimer(null, -2, null, this.mOnBatteryTimeBase);
        this.mPhoneOnTimer = new StopwatchTimer(null, -3, null, this.mOnBatteryTimeBase);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(null, -200 - i, null, this.mOnBatteryTimeBase);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(null, -199, null, this.mOnBatteryTimeBase);
        for (int i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(null, -300 - i, null, this.mOnBatteryTimeBase);
        }
        for (int i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
            this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
        }
        this.mMobileRadioActiveTimer = new StopwatchTimer(null, -400, null, this.mOnBatteryTimeBase);
        this.mMobileRadioActivePerAppTimer = new StopwatchTimer(null, -401, null, this.mOnBatteryTimeBase);
        this.mMobileRadioActiveAdjustedTime = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mMobileRadioActiveUnknownTime = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mMobileRadioActiveUnknownCount = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mWifiOnTimer = new StopwatchTimer(null, -4, null, this.mOnBatteryTimeBase);
        this.mGlobalWifiRunningTimer = new StopwatchTimer(null, -5, null, this.mOnBatteryTimeBase);
        for (int i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i] = new StopwatchTimer(null, -600 - i, null, this.mOnBatteryTimeBase);
        }
        for (int i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i] = new StopwatchTimer(null, -700 - i, null, this.mOnBatteryTimeBase);
        }
        for (int i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i] = new StopwatchTimer(null, -800 - i, null, this.mOnBatteryTimeBase);
        }
        this.mBluetoothOnTimer = new StopwatchTimer(null, -6, null, this.mOnBatteryTimeBase);
        int n = 0;
        while (true) {
            if (n >= 4) {
                String string2;
                this.mAudioOnTimer = new StopwatchTimer(null, -7, null, this.mOnBatteryTimeBase);
                this.mVideoOnTimer = new StopwatchTimer(null, -8, null, this.mOnBatteryTimeBase);
                this.mFlashlightOnTimer = new StopwatchTimer(null, -9, null, this.mOnBatteryTimeBase);
                this.mOnBatteryInternal = false;
                this.mOnBattery = false;
                this.initTimes(1000L * SystemClock.uptimeMillis(), 1000L * SystemClock.elapsedRealtime());
                this.mEndPlatformVersion = string2 = Build.ID;
                this.mStartPlatformVersion = string2;
                this.mDischargeStartLevel = 0;
                this.mDischargeUnplugLevel = 0;
                this.mDischargePlugLevel = -1;
                this.mDischargeCurrentLevel = 0;
                this.mCurrentBatteryLevel = 0;
                this.initDischarge();
                this.clearHistoryLocked();
                return;
            }
            this.mBluetoothStateTimer[n] = new StopwatchTimer(null, -500 - n, null, this.mOnBatteryTimeBase);
            ++n;
        }
    }

    private void addHistoryBufferLocked(long l, long l2, byte by, BatteryStats.HistoryItem historyItem) {
        if (this.mIteratingHistory) {
            throw new IllegalStateException("Can't do this while iterating history!");
        }
        this.mHistoryBufferLastPos = this.mHistoryBuffer.dataPosition();
        this.mHistoryLastLastWritten.setTo(this.mHistoryLastWritten);
        this.mHistoryLastWritten.setTo(l + this.mHistoryBaseTime, by, historyItem);
        this.writeHistoryDelta(this.mHistoryBuffer, this.mHistoryLastWritten, this.mHistoryLastLastWritten);
        this.mLastHistoryElapsedRealtime = l;
        historyItem.wakelockTag = null;
        historyItem.wakeReasonTag = null;
        historyItem.eventCode = 0;
        historyItem.eventTag = null;
    }

    private static int addLevelSteps(long[] lArray, int n, long l, int n2, long l2, long l3) {
        if (l >= 0L && n2 > 0) {
            long l4 = l3 - l;
            for (int i = 0; i < n2; ++i) {
                System.arraycopy((long[])lArray, (int)0, (long[])lArray, (int)1, (int)(-1 + lArray.length));
                long l5 = l4 / (long)(n2 - i);
                l4 -= l5;
                if (l5 > 0xFFFFFFFFFFL) {
                    l5 = 0xFFFFFFFFFFL;
                }
                lArray[0] = l5 | l2;
            }
            if ((n += n2) > lArray.length) {
                n = lArray.length;
            }
        }
        return n;
    }

    private int buildBatteryLevelInt(BatteryStats.HistoryItem historyItem) {
        return 0xFE000000 & historyItem.batteryLevel << 25 | 0x1FFC000 & historyItem.batteryTemperature << 14 | 0x3FFF & historyItem.batteryVoltage;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int buildStateInt(BatteryStats.HistoryItem historyItem) {
        int n;
        if ((1 & historyItem.batteryPlugType) != 0) {
            n = 1;
            return (7 & historyItem.batteryStatus) << 29 | (7 & historyItem.batteryHealth) << 26 | (n & 3) << 24 | 0xFFFFFF & historyItem.states;
        }
        if ((2 & historyItem.batteryPlugType) != 0) {
            n = 2;
            return (7 & historyItem.batteryStatus) << 29 | (7 & historyItem.batteryHealth) << 26 | (n & 3) << 24 | 0xFFFFFF & historyItem.states;
        }
        int n2 = 4 & historyItem.batteryPlugType;
        n = 0;
        if (n2 == 0) return (7 & historyItem.batteryStatus) << 29 | (7 & historyItem.batteryHealth) << 26 | (n & 3) << 24 | 0xFFFFFF & historyItem.states;
        n = 3;
        return (7 & historyItem.batteryStatus) << 29 | (7 & historyItem.batteryHealth) << 26 | (n & 3) << 24 | 0xFFFFFF & historyItem.states;
    }

    private long computeTimePerLevel(long[] lArray, int n) {
        if (n <= 0) {
            return -1L;
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l += 0xFFFFFFFFFFL & lArray[i];
        }
        return l / (long)n;
    }

    private static String[] excludeFromStringArray(String[] stringArray, String string2) {
        int n = ArrayUtils.indexOf(stringArray, string2);
        if (n >= 0) {
            String[] stringArray2 = new String[-1 + stringArray.length];
            if (n > 0) {
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
            }
            if (n < -1 + stringArray.length) {
                System.arraycopy(stringArray, n + 1, stringArray2, n, -1 + (stringArray.length - n));
            }
            return stringArray2;
        }
        return stringArray;
    }

    private int fixPhoneServiceState(int n, int n2) {
        if (this.mPhoneSimStateRaw == 1 && n == 1 && n2 > 0) {
            n = 0;
        }
        return n;
    }

    private int getCurrentBluetoothPingCount() {
        List<BluetoothDevice> list;
        if (this.mBtHeadset != null && (list = this.mBtHeadset.getConnectedDevices()).size() > 0) {
            return this.mBtHeadset.getBatteryUsageHint(list.get(0));
        }
        return -1;
    }

    private static String[] includeInStringArray(String[] stringArray, String string2) {
        if (ArrayUtils.indexOf(stringArray, string2) >= 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[1 + stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string2;
        return stringArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initActiveHistoryEventsLocked(long l, long l2) {
        int n = 0;
        while (n < 9) {
            HashMap<String, SparseIntArray> hashMap;
            if ((this.mRecordAllHistory || n != 1) && (hashMap = this.mActiveEvents.getStateForEvent(n)) != null) {
                for (Map.Entry<String, SparseIntArray> entry : hashMap.entrySet()) {
                    SparseIntArray sparseIntArray = entry.getValue();
                    for (int i = 0; i < sparseIntArray.size(); ++i) {
                        this.addHistoryEventLocked(l, l2, n, entry.getKey(), sparseIntArray.keyAt(i));
                    }
                }
            }
            ++n;
        }
        return;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Map<String, KernelWakelockStats> parseProcWakelocks(byte[] byArray, int n, boolean bl) {
        int n2;
        int n3;
        for (n3 = 0; n3 < n && byArray[n3] != 10 && byArray[n3] != 0; ++n3) {
        }
        int n4 = n2 = n3 + 1;
        synchronized (this) {
            Map<String, KernelWakelockStats> map = this.mProcWakelockFileStats;
            sKernelWakelockUpdateVersion = 1 + sKernelWakelockUpdateVersion;
            int n5 = 0;
            boolean bl2 = true;
            while (true) {
                int n6;
                if (!bl2 || (bl2 = false) || !true) {
                    if (n6 < n && byArray[n6] != 10 && byArray[n6] != 0) {
                        ++n6;
                        continue;
                    }
                    n2 = n6 + 1;
                    if (n2 >= n - 1) {
                        return map;
                    }
                    String[] stringArray = this.mProcWakelocksName;
                    long[] lArray = this.mProcWakelocksData;
                    int n7 = n4;
                    while (true) {
                        if (n7 < n2) {
                            if ((0x80 & byArray[n7]) != 0) {
                                byArray[n7] = 63;
                            }
                        } else {
                            int[] nArray = bl ? WAKEUP_SOURCES_FORMAT : PROC_WAKELOCKS_FORMAT;
                            boolean bl3 = Process.parseProcLine(byArray, n4, n2, nArray, stringArray, lArray, null);
                            String string2 = stringArray[0];
                            int n8 = (int)lArray[1];
                            long l = bl ? 1000L * lArray[2] : (500L + lArray[2]) / 1000L;
                            if (!bl3 || string2.length() <= 0) break;
                            if (!map.containsKey(string2)) {
                                map.put(string2, new KernelWakelockStats(n8, l, sKernelWakelockUpdateVersion));
                                ++n5;
                                break;
                            }
                            KernelWakelockStats kernelWakelockStats = map.get(string2);
                            if (kernelWakelockStats.mVersion == sKernelWakelockUpdateVersion) {
                                kernelWakelockStats.mCount = n8 + kernelWakelockStats.mCount;
                                kernelWakelockStats.mTotalTime = l + kernelWakelockStats.mTotalTime;
                                break;
                            }
                            kernelWakelockStats.mCount = n8;
                            kernelWakelockStats.mTotalTime = l;
                            kernelWakelockStats.mVersion = sKernelWakelockUpdateVersion;
                            ++n5;
                            break;
                        }
                        ++n7;
                    }
                    n4 = n2;
                }
                if (n2 >= n) break;
                n6 = n4;
            }
            if (map.size() != n5) {
                Iterator<KernelWakelockStats> iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().mVersion == sKernelWakelockUpdateVersion) continue;
                    iterator.remove();
                }
            }
            return map;
        }
    }

    private void readHistoryTag(int n, BatteryStats.HistoryTag historyTag) {
        historyTag.string = this.mReadHistoryStrings[n];
        historyTag.uid = this.mReadHistoryUids[n];
        historyTag.poolIdx = n;
    }

    /*
     * Exception decompiling
     */
    private final Map<String, KernelWakelockStats> readKernelWakelockStats() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Nonsensical loop would be emitted - failure
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.considerAsDoLoopStart(LoopIdentifier.java:438)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.identifyLoops1(LoopIdentifier.java:65)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:681)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void recordCurrentTimeChangeLocked(long l, long l2, long l3) {
        if (this.mRecordingHistory) {
            this.mHistoryCur.currentTime = l;
            this.mLastRecordedClockTime = l;
            this.mLastRecordedClockRealtime = l2;
            this.addHistoryBufferLocked(l2, l3, (byte)5, this.mHistoryCur);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    private void requestWakelockCpuUpdate() {
        if (!this.mHandler.hasMessages(1)) {
            Message message = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(message, 5000L);
        }
    }

    private void resetAllStatsLocked() {
        this.mStartCount = 0;
        this.initTimes(1000L * SystemClock.uptimeMillis(), 1000L * SystemClock.elapsedRealtime());
        this.mScreenOnTimer.reset(false);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].reset(false);
        }
        this.mInteractiveTimer.reset(false);
        this.mLowPowerModeEnabledTimer.reset(false);
        this.mPhoneOnTimer.reset(false);
        this.mAudioOnTimer.reset(false);
        this.mVideoOnTimer.reset(false);
        this.mFlashlightOnTimer.reset(false);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].reset(false);
        }
        this.mPhoneSignalScanningTimer.reset(false);
        for (int i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].reset(false);
        }
        for (int i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i].reset(false);
            this.mNetworkPacketActivityCounters[i].reset(false);
        }
        this.mMobileRadioActiveTimer.reset(false);
        this.mMobileRadioActivePerAppTimer.reset(false);
        this.mMobileRadioActiveAdjustedTime.reset(false);
        this.mMobileRadioActiveUnknownTime.reset(false);
        this.mMobileRadioActiveUnknownCount.reset(false);
        this.mWifiOnTimer.reset(false);
        this.mGlobalWifiRunningTimer.reset(false);
        for (int i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].reset(false);
        }
        for (int i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].reset(false);
        }
        for (int i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].reset(false);
        }
        this.mBluetoothOnTimer.reset(false);
        for (int i = 0; i < 4; ++i) {
            this.mBluetoothStateTimer[i].reset(false);
        }
        for (int i = 0; i < this.mUidStats.size(); ++i) {
            if (!this.mUidStats.valueAt(i).reset()) continue;
            this.mUidStats.remove(this.mUidStats.keyAt(i));
            --i;
        }
        if (this.mKernelWakelockStats.size() > 0) {
            for (SamplingTimer samplingTimer : this.mKernelWakelockStats.values()) {
                this.mOnBatteryScreenOffTimeBase.remove(samplingTimer);
            }
            this.mKernelWakelockStats.clear();
        }
        if (this.mWakeupReasonStats.size() > 0) {
            for (SamplingTimer samplingTimer : this.mWakeupReasonStats.values()) {
                this.mOnBatteryTimeBase.remove(samplingTimer);
            }
            this.mWakeupReasonStats.clear();
        }
        this.initDischarge();
        this.clearHistoryLocked();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void startRecordingHistory(long l, long l2, boolean bl) {
        this.mRecordingHistory = true;
        this.mLastRecordedClockTime = this.mHistoryCur.currentTime = System.currentTimeMillis();
        this.mLastRecordedClockRealtime = l;
        byte by = bl ? (byte)7 : 5;
        this.addHistoryBufferLocked(l, l2, by, this.mHistoryCur);
        this.mHistoryCur.currentTime = 0L;
        if (bl) {
            this.initActiveHistoryEventsLocked(l, l2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateAllPhoneStateLocked(int n, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        this.mPhoneServiceStateRaw = n;
        this.mPhoneSimStateRaw = n2;
        this.mPhoneSignalStrengthBinRaw = n3;
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        if (n2 == 1 && n == 1 && n3 > 0) {
            n = 0;
        }
        if (n == 3) {
            n3 = -1;
        } else {
            bl2 = false;
            bl = false;
            if (n != 0) {
                bl2 = false;
                bl = false;
                if (n == 1) {
                    bl = true;
                    boolean bl3 = this.mPhoneSignalScanningTimer.isRunningLocked();
                    bl2 = false;
                    n3 = 0;
                    if (!bl3) {
                        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                        historyItem.states = 0x200000 | historyItem.states;
                        bl2 = true;
                        this.mPhoneSignalScanningTimer.startRunningLocked(l);
                        n3 = 0;
                    }
                }
            }
        }
        if (!bl && this.mPhoneSignalScanningTimer.isRunningLocked()) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFDFFFFF & historyItem.states;
            bl2 = true;
            this.mPhoneSignalScanningTimer.stopRunningLocked(l);
        }
        if (this.mPhoneServiceState != n) {
            this.mHistoryCur.states = 0xFFFFFE3F & this.mHistoryCur.states | n << 6;
            bl2 = true;
            this.mPhoneServiceState = n;
        }
        if (this.mPhoneSignalStrengthBin != n3) {
            if (this.mPhoneSignalStrengthBin >= 0) {
                this.mPhoneSignalStrengthsTimer[this.mPhoneSignalStrengthBin].stopRunningLocked(l);
            }
            if (n3 >= 0) {
                if (!this.mPhoneSignalStrengthsTimer[n3].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[n3].startRunningLocked(l);
                }
                this.mHistoryCur.states = 0xFFFFFFC7 & this.mHistoryCur.states | n3 << 3;
                bl2 = true;
            } else {
                this.stopAllPhoneSignalStrengthTimersLocked(-1);
            }
            this.mPhoneSignalStrengthBin = n3;
        }
        if (bl2) {
            this.addHistoryRecordLocked(l, l2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateNetworkActivityLocked(int n, long l) {
        block12: {
            if (SystemProperties.getBoolean("net.qtaguid_enabled", false)) {
                block11: {
                    if ((n & 1) != 0 && this.mMobileIfaces.length > 0) {
                        NetworkStats networkStats;
                        NetworkStats networkStats2;
                        NetworkStats networkStats3 = this.mCurMobileSnapshot;
                        try {
                            this.mCurMobileSnapshot = networkStats2 = this.mNetworkStatsFactory.readNetworkStatsDetail(-1, this.mMobileIfaces, 0, this.mLastMobileSnapshot);
                            this.mLastMobileSnapshot = networkStats3;
                            if (!this.mOnBatteryInternal) break block11;
                        }
                        catch (IOException iOException) {
                            Log.wtf(TAG, "Failed to read mobile network stats", iOException);
                            return;
                        }
                        this.mTmpNetworkStats = networkStats = NetworkStats.subtract(networkStats2, networkStats3, null, null, this.mTmpNetworkStats);
                        long l2 = this.mMobileRadioActivePerAppTimer.checkpointRunningLocked(l);
                        long l3 = networkStats.getTotalPackets();
                        int n2 = networkStats.size();
                        for (int i = 0; i < n2; ++i) {
                            NetworkStats.Entry entry = networkStats.getValues(i, this.mTmpNetworkStatsEntry);
                            if (entry.rxBytes == 0L || entry.txBytes == 0L) continue;
                            Uid uid = this.getUidStatsLocked(this.mapUid(entry.uid));
                            uid.noteNetworkActivityLocked(0, entry.rxBytes, entry.rxPackets);
                            uid.noteNetworkActivityLocked(1, entry.txBytes, entry.txPackets);
                            if (l2 > 0L) {
                                long l4 = entry.rxPackets + entry.txPackets;
                                long l5 = l2 * l4 / l3;
                                uid.noteMobileRadioActiveTimeLocked(l5);
                                l2 -= l5;
                                l3 -= l4;
                            }
                            this.mNetworkByteActivityCounters[0].addCountLocked(entry.rxBytes);
                            this.mNetworkByteActivityCounters[1].addCountLocked(entry.txBytes);
                            this.mNetworkPacketActivityCounters[0].addCountLocked(entry.rxPackets);
                            this.mNetworkPacketActivityCounters[1].addCountLocked(entry.txPackets);
                        }
                        if (l2 > 0L) {
                            this.mMobileRadioActiveUnknownTime.addCountLocked(l2);
                            this.mMobileRadioActiveUnknownCount.addCountLocked(1L);
                        }
                    }
                }
                if ((n & 2) != 0 && this.mWifiIfaces.length > 0) {
                    NetworkStats networkStats;
                    NetworkStats networkStats4;
                    NetworkStats networkStats5 = this.mCurWifiSnapshot;
                    try {
                        this.mCurWifiSnapshot = networkStats4 = this.mNetworkStatsFactory.readNetworkStatsDetail(-1, this.mWifiIfaces, 0, this.mLastWifiSnapshot);
                        this.mLastWifiSnapshot = networkStats5;
                        if (!this.mOnBatteryInternal) break block12;
                    }
                    catch (IOException iOException) {
                        Log.wtf(TAG, "Failed to read wifi network stats", iOException);
                        return;
                    }
                    this.mTmpNetworkStats = networkStats = NetworkStats.subtract(networkStats4, networkStats5, null, null, this.mTmpNetworkStats);
                    int n3 = networkStats.size();
                    for (int i = 0; i < n3; ++i) {
                        NetworkStats.Entry entry = networkStats.getValues(i, this.mTmpNetworkStatsEntry);
                        if (entry.rxBytes == 0L || entry.txBytes == 0L) continue;
                        Uid uid = this.getUidStatsLocked(this.mapUid(entry.uid));
                        uid.noteNetworkActivityLocked(2, entry.rxBytes, entry.rxPackets);
                        uid.noteNetworkActivityLocked(3, entry.txBytes, entry.txPackets);
                        this.mNetworkByteActivityCounters[2].addCountLocked(entry.rxBytes);
                        this.mNetworkByteActivityCounters[3].addCountLocked(entry.txBytes);
                        this.mNetworkPacketActivityCounters[2].addCountLocked(entry.rxPackets);
                        this.mNetworkPacketActivityCounters[3].addCountLocked(entry.txPackets);
                    }
                }
            }
        }
    }

    private int writeHistoryTag(BatteryStats.HistoryTag historyTag) {
        Integer n = this.mHistoryTagPool.get(historyTag);
        if (n != null) {
            return n;
        }
        int n2 = this.mNextHistoryTagIdx;
        BatteryStats.HistoryTag historyTag2 = new BatteryStats.HistoryTag();
        historyTag2.setTo(historyTag);
        historyTag.poolIdx = n2;
        this.mHistoryTagPool.put(historyTag2, n2);
        this.mNextHistoryTagIdx = 1 + this.mNextHistoryTagIdx;
        this.mNumHistoryTagChars += 1 + historyTag2.string.length();
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    void addHistoryBufferLocked(long l, long l2, BatteryStats.HistoryItem historyItem) {
        int n;
        block10: {
            block11: {
                block9: {
                    if (!this.mHaveBatteryLevel || !this.mRecordingHistory) break block9;
                    long l3 = l + this.mHistoryBaseTime - this.mHistoryLastWritten.time;
                    int n2 = this.mHistoryLastWritten.states ^ historyItem.states;
                    int n3 = this.mHistoryLastWritten.states2 ^ historyItem.states2;
                    int n4 = this.mHistoryLastWritten.states ^ this.mHistoryLastLastWritten.states;
                    int n5 = this.mHistoryLastWritten.states2 ^ this.mHistoryLastLastWritten.states2;
                    if (!(this.mHistoryBufferLastPos < 0 || this.mHistoryLastWritten.cmd != 0 || l3 >= 1000L || (n2 & n4) != 0 || (n3 & n5) != 0 || this.mHistoryLastWritten.wakelockTag != null && historyItem.wakelockTag != null || this.mHistoryLastWritten.wakeReasonTag != null && historyItem.wakeReasonTag != null || this.mHistoryLastWritten.eventCode != 0 && historyItem.eventCode != 0 || this.mHistoryLastWritten.batteryLevel != historyItem.batteryLevel || this.mHistoryLastWritten.batteryStatus != historyItem.batteryStatus || this.mHistoryLastWritten.batteryHealth != historyItem.batteryHealth || this.mHistoryLastWritten.batteryPlugType != historyItem.batteryPlugType || this.mHistoryLastWritten.batteryTemperature != historyItem.batteryTemperature || this.mHistoryLastWritten.batteryVoltage != historyItem.batteryVoltage)) {
                        this.mHistoryBuffer.setDataSize(this.mHistoryBufferLastPos);
                        this.mHistoryBuffer.setDataPosition(this.mHistoryBufferLastPos);
                        this.mHistoryBufferLastPos = -1;
                        l = this.mHistoryLastWritten.time - this.mHistoryBaseTime;
                        if (this.mHistoryLastWritten.wakelockTag != null) {
                            historyItem.wakelockTag = historyItem.localWakelockTag;
                            historyItem.wakelockTag.setTo(this.mHistoryLastWritten.wakelockTag);
                        }
                        if (this.mHistoryLastWritten.wakeReasonTag != null) {
                            historyItem.wakeReasonTag = historyItem.localWakeReasonTag;
                            historyItem.wakeReasonTag.setTo(this.mHistoryLastWritten.wakeReasonTag);
                        }
                        if (this.mHistoryLastWritten.eventCode != 0) {
                            historyItem.eventCode = this.mHistoryLastWritten.eventCode;
                            historyItem.eventTag = historyItem.localEventTag;
                            historyItem.eventTag.setTo(this.mHistoryLastWritten.eventTag);
                        }
                        this.mHistoryLastWritten.setTo(this.mHistoryLastLastWritten);
                    }
                    if ((n = this.mHistoryBuffer.dataSize()) < 262144) break block10;
                    if (!this.mHistoryOverflow) {
                        this.mHistoryOverflow = true;
                        this.addHistoryBufferLocked(l, l2, (byte)0, historyItem);
                        this.addHistoryBufferLocked(l, l2, (byte)6, historyItem);
                        return;
                    }
                    if (this.mHistoryLastWritten.batteryLevel != historyItem.batteryLevel || n < 327680 && (0x1D0000 & (this.mHistoryLastWritten.states ^ historyItem.states)) != 0 && (0x90000000 & (this.mHistoryLastWritten.states2 ^ historyItem.states2)) != 0) break block11;
                }
                return;
            }
            this.addHistoryBufferLocked(l, l2, (byte)0, historyItem);
            return;
        }
        if (n == 0) {
            this.mLastRecordedClockTime = historyItem.currentTime = System.currentTimeMillis();
            this.mLastRecordedClockRealtime = l;
            this.addHistoryBufferLocked(l, l2, (byte)7, historyItem);
        }
        this.addHistoryBufferLocked(l, l2, (byte)0, historyItem);
    }

    void addHistoryEventLocked(long l, long l2, int n, String string2, int n2) {
        this.mHistoryCur.eventCode = n;
        this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
        this.mHistoryCur.eventTag.string = string2;
        this.mHistoryCur.eventTag.uid = n2;
        this.addHistoryRecordLocked(l, l2);
    }

    void addHistoryRecordInnerLocked(long l, long l2, BatteryStats.HistoryItem historyItem) {
        this.addHistoryBufferLocked(l, l2, historyItem);
    }

    void addHistoryRecordLocked(long l, long l2) {
        long l3;
        long l4;
        if (this.mTrackRunningHistoryElapsedRealtime != 0L && (l4 = l2 - this.mTrackRunningHistoryUptime) < (l3 = l - this.mTrackRunningHistoryElapsedRealtime) - 20L) {
            long l5 = l - (l3 - l4);
            this.mHistoryAddTmp.setTo(this.mHistoryLastWritten);
            this.mHistoryAddTmp.wakelockTag = null;
            this.mHistoryAddTmp.wakeReasonTag = null;
            this.mHistoryAddTmp.eventCode = 0;
            BatteryStats.HistoryItem historyItem = this.mHistoryAddTmp;
            historyItem.states = Integer.MAX_VALUE & historyItem.states;
            this.addHistoryRecordInnerLocked(l5, l2, this.mHistoryAddTmp);
        }
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        historyItem.states = Integer.MIN_VALUE | historyItem.states;
        this.mTrackRunningHistoryElapsedRealtime = l;
        this.mTrackRunningHistoryUptime = l2;
        this.addHistoryRecordInnerLocked(l, l2, this.mHistoryCur);
    }

    /*
     * Enabled aggressive block sorting
     */
    void addHistoryRecordLocked(long l, long l2, byte by, BatteryStats.HistoryItem historyItem) {
        BatteryStats.HistoryItem historyItem2 = this.mHistoryCache;
        if (historyItem2 != null) {
            this.mHistoryCache = historyItem2.next;
        } else {
            historyItem2 = new BatteryStats.HistoryItem();
        }
        historyItem2.setTo(l + this.mHistoryBaseTime, by, historyItem);
        this.addHistoryRecordLocked(historyItem2);
    }

    void addHistoryRecordLocked(BatteryStats.HistoryItem historyItem) {
        this.mNumHistoryItems = 1 + this.mNumHistoryItems;
        historyItem.next = null;
        this.mHistoryLastEnd = this.mHistoryEnd;
        if (this.mHistoryEnd != null) {
            this.mHistoryEnd.next = historyItem;
            this.mHistoryEnd = historyItem;
            return;
        }
        this.mHistoryEnd = historyItem;
        this.mHistory = historyItem;
    }

    public void addIsolatedUidLocked(int n, int n2) {
        this.mIsolatedUids.put(n, n2);
    }

    void aggregateLastWakeupUptimeLocked(long l) {
        if (this.mLastWakeupReason != null) {
            long l2 = l - this.mLastWakeupUptimeMs;
            SamplingTimer samplingTimer = this.getWakeupReasonTimerLocked(this.mLastWakeupReason);
            samplingTimer.addCurrentReportedCount(1);
            samplingTimer.addCurrentReportedTotalTime(1000L * l2);
            this.mLastWakeupReason = null;
        }
    }

    void clearHistoryLocked() {
        this.mHistoryBaseTime = 0L;
        this.mLastHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryUptime = 0L;
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryBuffer.setDataCapacity(131072);
        this.mHistoryLastLastWritten.clear();
        this.mHistoryLastWritten.clear();
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        this.mHistoryBufferLastPos = -1;
        this.mHistoryOverflow = false;
        this.mLastRecordedClockTime = 0L;
        this.mLastRecordedClockRealtime = 0L;
    }

    @Override
    public void commitCurrentHistoryBatchLocked() {
        this.mHistoryLastWritten.cmd = (byte)-1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commitPendingDataToDisk() {
        Parcel parcel;
        synchronized (this) {
            parcel = this.mPendingWrite;
            this.mPendingWrite = null;
            if (parcel == null) {
                return;
            }
            this.mWriteLock.lock();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.mFile.chooseForWrite());
            fileOutputStream.write(parcel.marshall());
            fileOutputStream.flush();
            FileUtils.sync(fileOutputStream);
            fileOutputStream.close();
            this.mFile.commit();
            return;
        }
        catch (IOException iOException) {
            Slog.w("BatteryStats", "Error writing battery statistics", iOException);
            this.mFile.rollback();
            return;
        }
        finally {
            parcel.recycle();
            this.mWriteLock.unlock();
        }
    }

    @Override
    public long computeBatteryRealtime(long l, int n) {
        return this.mOnBatteryTimeBase.computeRealtime(l, n);
    }

    @Override
    public long computeBatteryScreenOffRealtime(long l, int n) {
        return this.mOnBatteryScreenOffTimeBase.computeRealtime(l, n);
    }

    @Override
    public long computeBatteryScreenOffUptime(long l, int n) {
        return this.mOnBatteryScreenOffTimeBase.computeUptime(l, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long computeBatteryTimeRemaining(long l) {
        long l2;
        if (!this.mOnBattery || this.mNumDischargeStepDurations < 1 || (l2 = this.computeTimePerLevel(this.mDischargeStepDurations, this.mNumDischargeStepDurations)) <= 0L) {
            return -1L;
        }
        return 1000L * (l2 * (long)this.mCurrentBatteryLevel);
    }

    @Override
    public long computeBatteryUptime(long l, int n) {
        return this.mOnBatteryTimeBase.computeUptime(l, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long computeChargeTimeRemaining(long l) {
        long l2;
        if (this.mOnBattery || this.mNumChargeStepDurations < 1 || (l2 = this.computeTimePerLevel(this.mChargeStepDurations, this.mNumChargeStepDurations)) <= 0L) {
            return -1L;
        }
        return 1000L * (l2 * (long)(100 - this.mCurrentBatteryLevel));
    }

    @Override
    public long computeRealtime(long l, int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                return this.mRealtime + (l - this.mRealtimeStart);
            }
            case 1: {
                return l - this.mRealtimeStart;
            }
            case 2: 
        }
        return l - this.mOnBatteryTimeBase.getRealtimeStart();
    }

    @Override
    public long computeUptime(long l, int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                return this.mUptime + (l - this.mUptimeStart);
            }
            case 1: {
                return l - this.mUptimeStart;
            }
            case 2: 
        }
        return l - this.mOnBatteryTimeBase.getUptimeStart();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void distributeWorkLocked(int n) {
        Uid uid = this.mUidStats.get(1010);
        if (uid != null) {
            long l = this.computeBatteryRealtime(1000L * SystemClock.elapsedRealtime(), n);
            for (int i = -1 + uid.mProcessStats.size(); i >= 0; --i) {
                Uid.Proc proc = uid.mProcessStats.valueAt(i);
                long l2 = this.getGlobalWifiRunningTime(l, n);
                for (int j = 0; j < this.mUidStats.size(); ++j) {
                    long l3;
                    Uid uid2 = this.mUidStats.valueAt(j);
                    if (uid2.mUid == 1010 || (l3 = uid2.getWifiRunningTime(l, n)) <= 0L) continue;
                    Uid.Proc proc2 = uid2.getProcessStatsLocked("*wifi*");
                    long l4 = l3 * proc.getUserTime(n) / l2;
                    proc2.mUserTime = l4 + proc2.mUserTime;
                    proc.mUserTime -= l4;
                    long l5 = l3 * proc.getSystemTime(n) / l2;
                    proc2.mSystemTime = l5 + proc2.mSystemTime;
                    proc.mSystemTime -= l5;
                    long l6 = l3 * proc.getForegroundTime(n) / l2;
                    proc2.mForegroundTime = l6 + proc2.mForegroundTime;
                    proc.mForegroundTime -= l6;
                    for (int k = 0; k < proc.mSpeedBins.length; ++k) {
                        SamplingCounter samplingCounter = proc.mSpeedBins[k];
                        if (samplingCounter == null) continue;
                        long l7 = l3 * (long)samplingCounter.getCountLocked(n) / l2;
                        SamplingCounter samplingCounter2 = proc2.mSpeedBins[k];
                        if (samplingCounter2 == null) {
                            TimeBase timeBase = this.mOnBatteryTimeBase;
                            proc2.mSpeedBins[k] = samplingCounter2 = new SamplingCounter(timeBase);
                        }
                        samplingCounter2.mCount.addAndGet((int)l7);
                        samplingCounter.mCount.addAndGet((int)(-l7));
                    }
                    l2 -= l3;
                }
            }
        }
    }

    @Override
    public void dumpLocked(Context context, PrintWriter printWriter, int n, int n2, long l) {
        super.dumpLocked(context, printWriter, n, n2, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void finishAddingCpuLocked(int n, int n2, int n3, long[] lArray) {
        boolean bl;
        int n4;
        int n5 = this.mPartialTimers.size();
        if (n != 0) {
            Uid uid;
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                Uid uid2;
                StopwatchTimer stopwatchTimer = this.mPartialTimers.get(i);
                if (!stopwatchTimer.mInList || (uid2 = stopwatchTimer.mUid) == null || uid2.mUid == 1000) continue;
                ++n6;
            }
            if (n6 != 0) {
                for (int i = 0; i < n5; ++i) {
                    Uid uid3;
                    StopwatchTimer stopwatchTimer = this.mPartialTimers.get(i);
                    if (!stopwatchTimer.mInList || (uid3 = stopwatchTimer.mUid) == null || uid3.mUid == 1000) continue;
                    int n7 = n2 / n6;
                    int n8 = n3 / n6;
                    n2 -= n7;
                    n3 -= n8;
                    --n6;
                    Uid.Proc proc = uid3.getProcessStatsLocked("*wakelock*");
                    proc.addCpuTimeLocked(n7, n8);
                    proc.addSpeedStepTimes(lArray);
                }
            }
            if ((n2 != 0 || n3 != 0) && (uid = this.getUidStatsLocked(1000)) != null) {
                Uid.Proc proc = uid.getProcessStatsLocked("*lost*");
                proc.addCpuTimeLocked(n2, n3);
                proc.addSpeedStepTimes(lArray);
            }
        }
        boolean bl2 = n5 != (n4 = this.mLastPartialTimers.size());
        for (int i = 0; i < n4 && !bl2; bl2 |= bl, ++i) {
            bl = this.mPartialTimers.get(i) != this.mLastPartialTimers.get(i);
        }
        if (!bl2) {
            for (int i = 0; i < n4; ++i) {
                this.mPartialTimers.get((int)i).mInList = true;
            }
            return;
        } else {
            for (int i = 0; i < n4; ++i) {
                this.mLastPartialTimers.get((int)i).mInList = false;
            }
            this.mLastPartialTimers.clear();
            for (int i = 0; i < n5; ++i) {
                StopwatchTimer stopwatchTimer = this.mPartialTimers.get(i);
                stopwatchTimer.mInList = true;
                this.mLastPartialTimers.add(stopwatchTimer);
            }
        }
    }

    @Override
    public void finishIteratingHistoryLocked() {
        this.mIteratingHistory = false;
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
        this.mReadHistoryStrings = null;
    }

    @Override
    public void finishIteratingOldHistoryLocked() {
        this.mIteratingHistory = false;
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
        this.mHistoryIterator = null;
    }

    public long getAwakeTimeBattery() {
        return this.computeBatteryUptime(this.getBatteryUptimeLocked(), 1);
    }

    public long getAwakeTimePlugged() {
        return 1000L * SystemClock.uptimeMillis() - this.getAwakeTimeBattery();
    }

    @Override
    public long getBatteryRealtime(long l) {
        return this.mOnBatteryTimeBase.getRealtime(l);
    }

    @Override
    public long getBatteryUptime(long l) {
        return this.mOnBatteryTimeBase.getUptime(l);
    }

    long getBatteryUptimeLocked() {
        return this.mOnBatteryTimeBase.getUptime(1000L * SystemClock.uptimeMillis());
    }

    @Override
    public long getBluetoothOnTime(long l, int n) {
        return this.mBluetoothOnTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public int getBluetoothPingCount() {
        if (this.mBluetoothPingStart == -1) {
            return this.mBluetoothPingCount;
        }
        if (this.mBtHeadset != null) {
            return this.getCurrentBluetoothPingCount() - this.mBluetoothPingStart;
        }
        return 0;
    }

    @Override
    public int getBluetoothStateCount(int n, int n2) {
        return this.mBluetoothStateTimer[n].getCountLocked(n2);
    }

    @Override
    public long getBluetoothStateTime(int n, long l, int n2) {
        return this.mBluetoothStateTimer[n].getTotalTimeLocked(l, n2);
    }

    @Override
    public long[] getChargeStepDurationsArray() {
        return this.mChargeStepDurations;
    }

    @Override
    public int getCpuSpeedSteps() {
        return sNumSpeedSteps;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getDischargeAmount(int n) {
        int n2 = n == 0 ? this.getHighDischargeAmountSinceCharge() : this.getDischargeStartLevel() - this.getDischargeCurrentLevel();
        if (n2 >= 0) return n2;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDischargeAmountScreenOff() {
        synchronized (this) {
            int n = this.mDischargeAmountScreenOff;
            if (this.mOnBattery && this.mScreenState != 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                n += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDischargeAmountScreenOffSinceCharge() {
        synchronized (this) {
            int n = this.mDischargeAmountScreenOffSinceCharge;
            if (this.mOnBattery && this.mScreenState != 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                n += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDischargeAmountScreenOn() {
        synchronized (this) {
            int n = this.mDischargeAmountScreenOn;
            if (this.mOnBattery && this.mScreenState == 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                n += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDischargeAmountScreenOnSinceCharge() {
        synchronized (this) {
            int n = this.mDischargeAmountScreenOnSinceCharge;
            if (this.mOnBattery && this.mScreenState == 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                n += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDischargeCurrentLevel() {
        synchronized (this) {
            return this.getDischargeCurrentLevelLocked();
        }
    }

    public int getDischargeCurrentLevelLocked() {
        return this.mDischargeCurrentLevel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDischargeStartLevel() {
        synchronized (this) {
            return this.getDischargeStartLevelLocked();
        }
    }

    public int getDischargeStartLevelLocked() {
        return this.mDischargeUnplugLevel;
    }

    @Override
    public long[] getDischargeStepDurationsArray() {
        return this.mDischargeStepDurations;
    }

    @Override
    public String getEndPlatformVersion() {
        return this.mEndPlatformVersion;
    }

    @Override
    public long getFlashlightOnCount(int n) {
        return this.mFlashlightOnTimer.getCountLocked(n);
    }

    @Override
    public long getFlashlightOnTime(long l, int n) {
        return this.mFlashlightOnTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public long getGlobalWifiRunningTime(long l, int n) {
        return this.mGlobalWifiRunningTimer.getTotalTimeLocked(l, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getHighDischargeAmountSinceCharge() {
        synchronized (this) {
            int n = this.mHighDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                n += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return n;
        }
    }

    @Override
    public long getHistoryBaseTime() {
        return this.mHistoryBaseTime;
    }

    @Override
    public int getHistoryStringPoolBytes() {
        return 12 * this.mReadHistoryStrings.length + 2 * this.mReadHistoryChars;
    }

    @Override
    public int getHistoryStringPoolSize() {
        return this.mReadHistoryStrings.length;
    }

    @Override
    public String getHistoryTagPoolString(int n) {
        return this.mReadHistoryStrings[n];
    }

    @Override
    public int getHistoryTagPoolUid(int n) {
        return this.mReadHistoryUids[n];
    }

    @Override
    public int getHistoryTotalSize() {
        return 262144;
    }

    @Override
    public int getHistoryUsedSize() {
        return this.mHistoryBuffer.dataSize();
    }

    @Override
    public long getInteractiveTime(long l, int n) {
        return this.mInteractiveTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public boolean getIsOnBattery() {
        return this.mOnBattery;
    }

    public Map<String, ? extends Timer> getKernelWakelockStats() {
        return this.mKernelWakelockStats;
    }

    public SamplingTimer getKernelWakelockTimerLocked(String string2) {
        SamplingTimer samplingTimer = this.mKernelWakelockStats.get(string2);
        if (samplingTimer == null) {
            samplingTimer = new SamplingTimer(this.mOnBatteryScreenOffTimeBase, true);
            this.mKernelWakelockStats.put(string2, samplingTimer);
        }
        return samplingTimer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getLowDischargeAmountSinceCharge() {
        synchronized (this) {
            int n = this.mLowDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                n += -1 + (this.mDischargeUnplugLevel - this.mDischargeCurrentLevel);
            }
            return n;
        }
    }

    @Override
    public int getLowPowerModeEnabledCount(int n) {
        return this.mLowPowerModeEnabledTimer.getCountLocked(n);
    }

    @Override
    public long getLowPowerModeEnabledTime(long l, int n) {
        return this.mLowPowerModeEnabledTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public long getMobileRadioActiveAdjustedTime(int n) {
        return this.mMobileRadioActiveAdjustedTime.getCountLocked(n);
    }

    @Override
    public int getMobileRadioActiveCount(int n) {
        return this.mMobileRadioActiveTimer.getCountLocked(n);
    }

    @Override
    public long getMobileRadioActiveTime(long l, int n) {
        return this.mMobileRadioActiveTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public int getMobileRadioActiveUnknownCount(int n) {
        return (int)this.mMobileRadioActiveUnknownCount.getCountLocked(n);
    }

    @Override
    public long getMobileRadioActiveUnknownTime(int n) {
        return this.mMobileRadioActiveUnknownTime.getCountLocked(n);
    }

    @Override
    public long getNetworkActivityBytes(int n, int n2) {
        if (n >= 0 && n < this.mNetworkByteActivityCounters.length) {
            return this.mNetworkByteActivityCounters[n].getCountLocked(n2);
        }
        return 0L;
    }

    @Override
    public long getNetworkActivityPackets(int n, int n2) {
        if (n >= 0 && n < this.mNetworkPacketActivityCounters.length) {
            return this.mNetworkPacketActivityCounters[n].getCountLocked(n2);
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getNextHistoryLocked(BatteryStats.HistoryItem historyItem) {
        int n = this.mHistoryBuffer.dataPosition();
        if (n == 0) {
            historyItem.clear();
        }
        if (n >= this.mHistoryBuffer.dataSize()) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        long l = historyItem.time;
        long l2 = historyItem.currentTime;
        this.readHistoryDelta(this.mHistoryBuffer, historyItem);
        if (historyItem.cmd == 5) return true;
        if (historyItem.cmd == 7) return true;
        if (l2 == 0L) return true;
        historyItem.currentTime = l2 + (historyItem.time - l);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getNextOldHistoryLocked(BatteryStats.HistoryItem historyItem) {
        BatteryStats.HistoryItem historyItem2;
        boolean bl = this.mHistoryBuffer.dataPosition() >= this.mHistoryBuffer.dataSize();
        if (!bl) {
            this.readHistoryDelta(this.mHistoryBuffer, this.mHistoryReadTmp);
            boolean bl2 = this.mReadOverflow;
            boolean bl3 = this.mHistoryReadTmp.cmd == 6;
            this.mReadOverflow = bl3 | bl2;
        }
        if ((historyItem2 = this.mHistoryIterator) == null) {
            if (this.mReadOverflow) return false;
            if (bl) return false;
            Slog.w(TAG, "Old history ends before new history!");
            return false;
        }
        historyItem.setTo(historyItem2);
        this.mHistoryIterator = historyItem2.next;
        if (this.mReadOverflow) return true;
        if (bl) {
            Slog.w(TAG, "New history ends before old history!");
            return true;
        }
        if (historyItem.same(this.mHistoryReadTmp)) return true;
        FastPrintWriter fastPrintWriter = new FastPrintWriter(new LogWriter(5, TAG));
        fastPrintWriter.println("Histories differ!");
        fastPrintWriter.println("Old history:");
        new BatteryStats.HistoryPrinter().printNextItem(fastPrintWriter, historyItem, 0L, false, true);
        fastPrintWriter.println("New history:");
        new BatteryStats.HistoryPrinter().printNextItem(fastPrintWriter, this.mHistoryReadTmp, 0L, false, true);
        ((PrintWriter)fastPrintWriter).flush();
        return true;
    }

    @Override
    public int getNumChargeStepDurations() {
        return this.mNumChargeStepDurations;
    }

    @Override
    public int getNumDischargeStepDurations() {
        return this.mNumDischargeStepDurations;
    }

    public Uid.Pkg getPackageStatsLocked(int n, String string2) {
        return this.getUidStatsLocked(this.mapUid(n)).getPackageStatsLocked(string2);
    }

    @Override
    public int getParcelVersion() {
        return 114;
    }

    @Override
    public int getPhoneDataConnectionCount(int n, int n2) {
        return this.mPhoneDataConnectionsTimer[n].getCountLocked(n2);
    }

    @Override
    public long getPhoneDataConnectionTime(int n, long l, int n2) {
        return this.mPhoneDataConnectionsTimer[n].getTotalTimeLocked(l, n2);
    }

    @Override
    public int getPhoneOnCount(int n) {
        return this.mPhoneOnTimer.getCountLocked(n);
    }

    @Override
    public long getPhoneOnTime(long l, int n) {
        return this.mPhoneOnTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public long getPhoneSignalScanningTime(long l, int n) {
        return this.mPhoneSignalScanningTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public int getPhoneSignalStrengthCount(int n, int n2) {
        return this.mPhoneSignalStrengthsTimer[n].getCountLocked(n2);
    }

    @Override
    public long getPhoneSignalStrengthTime(int n, long l, int n2) {
        return this.mPhoneSignalStrengthsTimer[n].getTotalTimeLocked(l, n2);
    }

    public Uid.Proc getProcessStatsLocked(int n, String string2) {
        return this.getUidStatsLocked(this.mapUid(n)).getProcessStatsLocked(string2);
    }

    public long getProcessWakeTime(int n, int n2, long l) {
        BatteryStats.Uid.Pid pid;
        long l2 = 0L;
        int n3 = this.mapUid(n);
        Uid uid = this.mUidStats.get(n3);
        if (uid != null && (pid = uid.mPids.get(n2)) != null) {
            long l3 = pid.mWakeSumMs;
            if (pid.mWakeNesting > 0) {
                l2 = l - pid.mWakeStartMs;
            }
            l2 += l3;
        }
        return l2;
    }

    @Override
    public long getScreenBrightnessTime(int n, long l, int n2) {
        return this.mScreenBrightnessTimer[n].getTotalTimeLocked(l, n2);
    }

    @Override
    public int getScreenOnCount(int n) {
        return this.mScreenOnTimer.getCountLocked(n);
    }

    @Override
    public long getScreenOnTime(long l, int n) {
        return this.mScreenOnTimer.getTotalTimeLocked(l, n);
    }

    public Uid.Pkg.Serv getServiceStatsLocked(int n, String string2, String string3) {
        return this.getUidStatsLocked(this.mapUid(n)).getServiceStatsLocked(string2, string3);
    }

    @Override
    public long getStartClockTime() {
        if (!this.isStartClockTimeValid()) {
            this.mStartClockTime = System.currentTimeMillis();
            if (this.isStartClockTimeValid()) {
                this.recordCurrentTimeChangeLocked(this.mStartClockTime, SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
            }
        }
        return this.mStartClockTime;
    }

    @Override
    public int getStartCount() {
        return this.mStartCount;
    }

    @Override
    public String getStartPlatformVersion() {
        return this.mStartPlatformVersion;
    }

    @Override
    public SparseArray<? extends BatteryStats.Uid> getUidStats() {
        return this.mUidStats;
    }

    public Uid getUidStatsLocked(int n) {
        Uid uid = this.mUidStats.get(n);
        if (uid == null) {
            uid = new Uid(n);
            this.mUidStats.put(n, uid);
        }
        return uid;
    }

    public Map<String, ? extends Timer> getWakeupReasonStats() {
        return this.mWakeupReasonStats;
    }

    public SamplingTimer getWakeupReasonTimerLocked(String string2) {
        SamplingTimer samplingTimer = this.mWakeupReasonStats.get(string2);
        if (samplingTimer == null) {
            samplingTimer = new SamplingTimer(this.mOnBatteryTimeBase, true);
            this.mWakeupReasonStats.put(string2, samplingTimer);
        }
        return samplingTimer;
    }

    @Override
    public long getWifiOnTime(long l, int n) {
        return this.mWifiOnTimer.getTotalTimeLocked(l, n);
    }

    @Override
    public int getWifiSignalStrengthCount(int n, int n2) {
        return this.mWifiSignalStrengthsTimer[n].getCountLocked(n2);
    }

    @Override
    public long getWifiSignalStrengthTime(int n, long l, int n2) {
        return this.mWifiSignalStrengthsTimer[n].getTotalTimeLocked(l, n2);
    }

    @Override
    public int getWifiStateCount(int n, int n2) {
        return this.mWifiStateTimer[n].getCountLocked(n2);
    }

    @Override
    public long getWifiStateTime(int n, long l, int n2) {
        return this.mWifiStateTimer[n].getTotalTimeLocked(l, n2);
    }

    @Override
    public int getWifiSupplStateCount(int n, int n2) {
        return this.mWifiSupplStateTimer[n].getCountLocked(n2);
    }

    @Override
    public long getWifiSupplStateTime(int n, long l, int n2) {
        return this.mWifiSupplStateTimer[n].getTotalTimeLocked(l, n2);
    }

    void initDischarge() {
        this.mLowDischargeAmountSinceCharge = 0;
        this.mHighDischargeAmountSinceCharge = 0;
        this.mDischargeAmountScreenOn = 0;
        this.mDischargeAmountScreenOnSinceCharge = 0;
        this.mDischargeAmountScreenOff = 0;
        this.mDischargeAmountScreenOffSinceCharge = 0;
        this.mLastDischargeStepTime = -1L;
        this.mNumDischargeStepDurations = 0;
        this.mLastChargeStepTime = -1L;
        this.mNumChargeStepDurations = 0;
    }

    void initTimes(long l, long l2) {
        this.mStartClockTime = System.currentTimeMillis();
        this.mOnBatteryTimeBase.init(l, l2);
        this.mOnBatteryScreenOffTimeBase.init(l, l2);
        this.mRealtime = 0L;
        this.mUptime = 0L;
        this.mRealtimeStart = l2;
        this.mUptimeStart = l;
    }

    public boolean isOnBattery() {
        return this.mOnBattery;
    }

    public boolean isScreenOn() {
        return this.mScreenState == 2;
    }

    boolean isStartClockTimeValid() {
        return this.mStartClockTime > 31536000000L;
    }

    public int mapUid(int n) {
        int n2 = this.mIsolatedUids.get(n, -1);
        if (n2 > 0) {
            return n2;
        }
        return n;
    }

    public void noteActivityPausedLocked(int n) {
        this.getUidStatsLocked(this.mapUid(n)).noteActivityPausedLocked(SystemClock.elapsedRealtime());
    }

    public void noteActivityResumedLocked(int n) {
        this.getUidStatsLocked(this.mapUid(n)).noteActivityResumedLocked(SystemClock.elapsedRealtime());
    }

    public void noteAudioOffLocked(int n) {
        int n2;
        if (this.mAudioOnNesting == 0) {
            return;
        }
        int n3 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.mAudioOnNesting = n2 = -1 + this.mAudioOnNesting;
        if (n2 == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFBFFFFF & historyItem.states;
            this.addHistoryRecordLocked(l, l2);
            this.mAudioOnTimer.stopRunningLocked(l);
        }
        this.getUidStatsLocked(n3).noteAudioTurnedOffLocked(l);
    }

    public void noteAudioOnLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        if (this.mAudioOnNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x400000 | historyItem.states;
            this.addHistoryRecordLocked(l, l2);
            this.mAudioOnTimer.startRunningLocked(l);
        }
        this.mAudioOnNesting = 1 + this.mAudioOnNesting;
        this.getUidStatsLocked(n2).noteAudioTurnedOnLocked(l);
    }

    public void noteBluetoothOffLocked() {
        if (this.mBluetoothOn) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFFEFFFF & historyItem.states;
            this.addHistoryRecordLocked(l, l2);
            this.mBluetoothOn = false;
            this.mBluetoothOnTimer.stopRunningLocked(l);
        }
    }

    public void noteBluetoothOnLocked() {
        if (!this.mBluetoothOn) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x10000 | historyItem.states;
            this.addHistoryRecordLocked(l, l2);
            this.mBluetoothOn = true;
            this.mBluetoothOnTimer.startRunningLocked(l);
        }
    }

    public void noteBluetoothStateLocked(int n) {
        if (this.mBluetoothState != n) {
            long l = SystemClock.elapsedRealtime();
            if (this.mBluetoothState >= 0) {
                this.mBluetoothStateTimer[this.mBluetoothState].stopRunningLocked(l);
            }
            this.mBluetoothState = n;
            this.mBluetoothStateTimer[n].startRunningLocked(l);
        }
    }

    public void noteChangeWakelockFromSourceLocked(WorkSource workSource, int n, String string2, String string3, int n2, WorkSource workSource2, int n3, String string4, String string5, int n4, boolean bl) {
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        int n5 = workSource2.size();
        for (int i = 0; i < n5; ++i) {
            this.noteStartWakeLocked(workSource2.get(i), n3, string4, string5, n4, bl, l, l2);
        }
        int n6 = workSource.size();
        for (int i = 0; i < n6; ++i) {
            this.noteStopWakeLocked(workSource.get(i), n, string2, string3, n2, l, l2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteCurrentTimeChangedLocked() {
        long l;
        block3: {
            block2: {
                long l2;
                l = System.currentTimeMillis();
                long l3 = SystemClock.elapsedRealtime();
                long l4 = SystemClock.uptimeMillis();
                if (this.isStartClockTimeValid() && this.mLastRecordedClockTime != 0L && l >= (l2 = this.mLastRecordedClockTime + (l3 - this.mLastRecordedClockRealtime)) - 500L && l <= l2 + 500L) break block2;
                this.recordCurrentTimeChangeLocked(l, l3, l4);
                if (this.isStartClockTimeValid()) break block3;
            }
            return;
        }
        this.mStartClockTime = l;
    }

    public void noteEventLocked(int n, String string2, int n2) {
        int n3 = this.mapUid(n2);
        if (!this.mActiveEvents.updateState(n, string2, n3, 0)) {
            return;
        }
        this.addHistoryEventLocked(SystemClock.elapsedRealtime(), SystemClock.uptimeMillis(), n, string2, n3);
    }

    public void noteFlashlightOffLocked() {
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        if (this.mFlashlightOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states2 = 0xF7FFFFFF & historyItem.states2;
            this.addHistoryRecordLocked(l, l2);
            this.mFlashlightOn = false;
            this.mFlashlightOnTimer.stopRunningLocked(l);
        }
    }

    public void noteFlashlightOnLocked() {
        if (!this.mFlashlightOn) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states2 = 0x8000000 | historyItem.states2;
            this.addHistoryRecordLocked(l, l2);
            this.mFlashlightOn = true;
            this.mFlashlightOnTimer.startRunningLocked(l);
        }
    }

    public void noteFullWifiLockAcquiredFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteFullWifiLockAcquiredLocked(workSource.get(i));
        }
    }

    public void noteFullWifiLockAcquiredLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        if (this.mWifiFullLockNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x10000000 | historyItem.states;
            this.addHistoryRecordLocked(l, l2);
        }
        this.mWifiFullLockNesting = 1 + this.mWifiFullLockNesting;
        this.getUidStatsLocked(n2).noteFullWifiLockAcquiredLocked(l);
    }

    public void noteFullWifiLockReleasedFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteFullWifiLockReleasedLocked(workSource.get(i));
        }
    }

    public void noteFullWifiLockReleasedLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.mWifiFullLockNesting = -1 + this.mWifiFullLockNesting;
        if (this.mWifiFullLockNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xEFFFFFFF & historyItem.states;
            this.addHistoryRecordLocked(l, l2);
        }
        this.getUidStatsLocked(n2).noteFullWifiLockReleasedLocked(l);
    }

    public void noteInteractiveLocked(boolean bl) {
        long l;
        block3: {
            block2: {
                if (this.mInteractive == bl) break block2;
                l = SystemClock.elapsedRealtime();
                this.mInteractive = bl;
                if (!bl) break block3;
                this.mInteractiveTimer.startRunningLocked(l);
            }
            return;
        }
        this.mInteractiveTimer.stopRunningLocked(l);
    }

    public void noteJobFinishLocked(String string2, int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.getUidStatsLocked(n2).noteStopJobLocked(string2, l);
        if (!this.mActiveEvents.updateState(16390, string2, n2, 0)) {
            return;
        }
        this.addHistoryEventLocked(l, l2, 16390, string2, n2);
    }

    public void noteJobStartLocked(String string2, int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.getUidStatsLocked(n2).noteStartJobLocked(string2, l);
        if (!this.mActiveEvents.updateState(32774, string2, n2, 0)) {
            return;
        }
        this.addHistoryEventLocked(l, l2, 32774, string2, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteLowPowerMode(boolean bl) {
        if (this.mLowPowerModeEnabled != bl) {
            int n = bl ? 4 : 0;
            this.mModStepMode |= n ^ 4 & this.mCurStepMode;
            this.mCurStepMode = n | 0xFFFFFFFB & this.mCurStepMode;
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            this.mLowPowerModeEnabled = bl;
            if (bl) {
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states2 = Integer.MIN_VALUE | historyItem.states2;
                this.mLowPowerModeEnabledTimer.startRunningLocked(l);
            } else {
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states2 = Integer.MAX_VALUE & historyItem.states2;
                this.mLowPowerModeEnabledTimer.stopRunningLocked(l);
            }
            this.addHistoryRecordLocked(l, l2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteMobileRadioPowerState(int n, long l) {
        long l2 = SystemClock.elapsedRealtime();
        long l3 = SystemClock.uptimeMillis();
        if (this.mMobileRadioPowerState != n) {
            long l4;
            boolean bl = n == DataConnectionRealTimeInfo.DC_POWER_STATE_MEDIUM || n == DataConnectionRealTimeInfo.DC_POWER_STATE_HIGH;
            if (bl) {
                l4 = l2;
                this.mMobileRadioActiveStartTime = l2;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = 0x2000000 | historyItem.states;
            } else {
                l4 = l / 1000000L;
                long l5 = this.mMobileRadioActiveStartTime;
                if (l4 < l5) {
                    Slog.wtf(TAG, "Data connection inactive timestamp " + l4 + " is before start time " + l5);
                    l4 = l2;
                } else if (l4 < l2) {
                    this.mMobileRadioActiveAdjustedTime.addCountLocked(l2 - l4);
                }
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = 0xFDFFFFFF & historyItem.states;
            }
            this.addHistoryRecordLocked(l2, l3);
            this.mMobileRadioPowerState = n;
            if (!bl) {
                this.mMobileRadioActiveTimer.stopRunningLocked(l4);
                this.updateNetworkActivityLocked(1, l4);
                this.mMobileRadioActivePerAppTimer.stopRunningLocked(l4);
                return;
            }
            this.mMobileRadioActiveTimer.startRunningLocked(l2);
            this.mMobileRadioActivePerAppTimer.startRunningLocked(l2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteNetworkInterfaceTypeLocked(String string2, int n) {
        if (TextUtils.isEmpty(string2)) {
            return;
        }
        this.mMobileIfaces = ConnectivityManager.isNetworkTypeMobile(n) ? BatteryStatsImpl.includeInStringArray(this.mMobileIfaces, string2) : BatteryStatsImpl.excludeFromStringArray(this.mMobileIfaces, string2);
        if (ConnectivityManager.isNetworkTypeWifi(n)) {
            this.mWifiIfaces = BatteryStatsImpl.includeInStringArray(this.mWifiIfaces, string2);
            return;
        }
        this.mWifiIfaces = BatteryStatsImpl.excludeFromStringArray(this.mWifiIfaces, string2);
    }

    public void noteNetworkStatsEnabledLocked() {
        this.updateNetworkActivityLocked(65535, SystemClock.elapsedRealtime());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notePhoneDataConnectionStateLocked(int n, boolean bl) {
        int n2 = 0;
        if (bl) {
            switch (n) {
                default: {
                    n2 = 16;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 5: {
                    n2 = 5;
                    break;
                }
                case 6: {
                    n2 = 6;
                    break;
                }
                case 7: {
                    n2 = 7;
                    break;
                }
                case 8: {
                    n2 = 8;
                    break;
                }
                case 9: {
                    n2 = 9;
                    break;
                }
                case 10: {
                    n2 = 10;
                    break;
                }
                case 11: {
                    n2 = 11;
                    break;
                }
                case 12: {
                    n2 = 12;
                    break;
                }
                case 13: {
                    n2 = 13;
                    break;
                }
                case 14: {
                    n2 = 14;
                    break;
                }
                case 15: {
                    n2 = 15;
                }
            }
        }
        if (this.mPhoneDataConnectionType != n2) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            this.mHistoryCur.states = 0xFFFFC1FF & this.mHistoryCur.states | n2 << 9;
            this.addHistoryRecordLocked(l, l2);
            if (this.mPhoneDataConnectionType >= 0) {
                this.mPhoneDataConnectionsTimer[this.mPhoneDataConnectionType].stopRunningLocked(l);
            }
            this.mPhoneDataConnectionType = n2;
            this.mPhoneDataConnectionsTimer[n2].startRunningLocked(l);
        }
    }

    public void notePhoneOffLocked() {
        if (this.mPhoneOn) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFFBFFFF & historyItem.states;
            this.addHistoryRecordLocked(l, l2);
            this.mPhoneOn = false;
            this.mPhoneOnTimer.stopRunningLocked(l);
        }
    }

    public void notePhoneOnLocked() {
        if (!this.mPhoneOn) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x40000 | historyItem.states;
            this.addHistoryRecordLocked(l, l2);
            this.mPhoneOn = true;
            this.mPhoneOnTimer.startRunningLocked(l);
        }
    }

    public void notePhoneSignalStrengthLocked(SignalStrength signalStrength) {
        int n = signalStrength.getLevel();
        this.updateAllPhoneStateLocked(this.mPhoneServiceStateRaw, this.mPhoneSimStateRaw, n);
    }

    public void notePhoneStateLocked(int n, int n2) {
        this.updateAllPhoneStateLocked(n, n2, this.mPhoneSignalStrengthBinRaw);
    }

    public void noteProcessDiedLocked(int n, int n2) {
        int n3 = this.mapUid(n);
        Uid uid = this.mUidStats.get(n3);
        if (uid != null) {
            uid.mPids.remove(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteProcessFinishLocked(String string2, int n) {
        long l;
        long l2;
        int n2;
        block3: {
            block2: {
                n2 = this.mapUid(n);
                if (!this.mActiveEvents.updateState(16385, string2, n2, 0)) break block2;
                l2 = SystemClock.elapsedRealtime();
                l = SystemClock.uptimeMillis();
                this.getUidStatsLocked(n2).updateProcessStateLocked(string2, 3, l2);
                if (this.mRecordAllHistory) break block3;
            }
            return;
        }
        this.addHistoryEventLocked(l2, l, 16385, string2, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteProcessStartLocked(String string2, int n) {
        int n2 = this.mapUid(n);
        if (this.isOnBattery()) {
            this.getUidStatsLocked(n2).getProcessStatsLocked(string2).incStartsLocked();
        }
        if (!this.mActiveEvents.updateState(32769, string2, n2, 0) || !this.mRecordAllHistory) {
            return;
        }
        this.addHistoryEventLocked(SystemClock.elapsedRealtime(), SystemClock.uptimeMillis(), 32769, string2, n2);
    }

    public void noteProcessStateLocked(String string2, int n, int n2) {
        int n3 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        this.getUidStatsLocked(n3).updateProcessStateLocked(string2, n2, l);
    }

    public void noteResetAudioLocked() {
        if (this.mAudioOnNesting > 0) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            this.mAudioOnNesting = 0;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFFBFFFFF & historyItem.states;
            this.addHistoryRecordLocked(l, l2);
            this.mAudioOnTimer.stopAllRunningLocked(l);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                this.mUidStats.valueAt(i).noteResetAudioLocked(l);
            }
        }
    }

    public void noteResetVideoLocked() {
        if (this.mVideoOnNesting > 0) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            this.mAudioOnNesting = 0;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states2 = 0xBFFFFFFF & historyItem.states2;
            this.addHistoryRecordLocked(l, l2);
            this.mVideoOnTimer.stopAllRunningLocked(l);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                this.mUidStats.valueAt(i).noteResetVideoLocked(l);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteScreenBrightnessLocked(int n) {
        int n2 = n / 51;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= 5) {
            n2 = 4;
        }
        if (this.mScreenBrightnessBin != n2) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            this.mHistoryCur.states = 0xFFFFFFF8 & this.mHistoryCur.states | n2 << 0;
            this.addHistoryRecordLocked(l, l2);
            if (this.mScreenState == 2) {
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(l);
                }
                this.mScreenBrightnessTimer[n2].startRunningLocked(l);
            }
            this.mScreenBrightnessBin = n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteScreenStateLocked(int n) {
        if (this.mScreenState == n) return;
        int n2 = this.mScreenState;
        this.mScreenState = n;
        if (n != 0) {
            int n3 = n - 1;
            if (n3 < 4) {
                this.mModStepMode |= n3 ^ 3 & this.mCurStepMode;
                this.mCurStepMode = n3 | 0xFFFFFFFC & this.mCurStepMode;
            } else {
                Slog.wtf(TAG, "Unexpected screen state: " + n);
            }
        }
        if (n == 2) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x100000 | historyItem.states;
            this.addHistoryRecordLocked(l, l2);
            this.mScreenOnTimer.startRunningLocked(l);
            if (this.mScreenBrightnessBin >= 0) {
                this.mScreenBrightnessTimer[this.mScreenBrightnessBin].startRunningLocked(l);
            }
            this.updateTimeBasesLocked(this.mOnBatteryTimeBase.isRunning(), false, 1000L * SystemClock.uptimeMillis(), 1000L * l);
            this.noteStartWakeLocked(-1, -1, "screen", null, 0, false, l, l2);
            if (!this.mOnBatteryInternal) return;
            this.updateDischargeScreenLevelsLocked(false, true);
            return;
        }
        if (n2 != 2) return;
        long l = SystemClock.elapsedRealtime();
        long l3 = SystemClock.uptimeMillis();
        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
        historyItem.states = 0xFFEFFFFF & historyItem.states;
        this.addHistoryRecordLocked(l, l3);
        this.mScreenOnTimer.stopRunningLocked(l);
        if (this.mScreenBrightnessBin >= 0) {
            this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(l);
        }
        this.noteStopWakeLocked(-1, -1, "screen", "screen", 0, l, l3);
        this.updateTimeBasesLocked(this.mOnBatteryTimeBase.isRunning(), true, 1000L * SystemClock.uptimeMillis(), 1000L * l);
        if (!this.mOnBatteryInternal) return;
        this.updateDischargeScreenLevelsLocked(true, false);
    }

    public void noteStartGpsLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        if (this.mGpsNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x20000000 | historyItem.states;
            this.addHistoryRecordLocked(l, l2);
        }
        this.mGpsNesting = 1 + this.mGpsNesting;
        this.getUidStatsLocked(n2).noteStartGps(l);
    }

    public void noteStartSensorLocked(int n, int n2) {
        int n3 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        if (this.mSensorNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x800000 | historyItem.states;
            this.addHistoryRecordLocked(l, l2);
        }
        this.mSensorNesting = 1 + this.mSensorNesting;
        this.getUidStatsLocked(n3).noteStartSensor(n2, l);
    }

    public void noteStartWakeFromSourceLocked(WorkSource workSource, int n, String string2, String string3, int n2, boolean bl) {
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        int n3 = workSource.size();
        for (int i = 0; i < n3; ++i) {
            this.noteStartWakeLocked(workSource.get(i), n, string2, string3, n2, bl, l, l2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteStartWakeLocked(int n, int n2, String string2, String string3, int n3, boolean bl, long l, long l2) {
        int n4 = this.mapUid(n);
        if (n3 == 0) {
            this.aggregateLastWakeupUptimeLocked(l2);
            if (string3 == null) {
                string3 = string2;
            }
            if (this.mRecordAllHistory && this.mActiveEvents.updateState(32773, string3, n4, 0)) {
                this.addHistoryEventLocked(l, l2, 32773, string3, n4);
            }
            if (this.mWakeLockNesting == 0) {
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = 0x40000000 | historyItem.states;
                BatteryStats.HistoryTag historyTag = this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                this.mInitialAcquireWakeName = string3;
                historyTag.string = string3;
                BatteryStats.HistoryTag historyTag2 = this.mHistoryCur.wakelockTag;
                this.mInitialAcquireWakeUid = n4;
                historyTag2.uid = n4;
                boolean bl2 = !bl;
                this.mWakeLockImportant = bl2;
                this.addHistoryRecordLocked(l, l2);
            } else if (!this.mWakeLockImportant && !bl && this.mHistoryLastWritten.cmd == 0) {
                if (this.mHistoryLastWritten.wakelockTag != null) {
                    this.mHistoryLastWritten.wakelockTag = null;
                    BatteryStats.HistoryTag historyTag = this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                    this.mInitialAcquireWakeName = string3;
                    historyTag.string = string3;
                    BatteryStats.HistoryTag historyTag3 = this.mHistoryCur.wakelockTag;
                    this.mInitialAcquireWakeUid = n4;
                    historyTag3.uid = n4;
                    this.addHistoryRecordLocked(l, l2);
                }
                this.mWakeLockImportant = true;
            }
            this.mWakeLockNesting = 1 + this.mWakeLockNesting;
        }
        if (n4 >= 0) {
            this.requestWakelockCpuUpdate();
            this.getUidStatsLocked(n4).noteStartWakeLocked(n2, string2, n3, l);
        }
    }

    public void noteStopGpsLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.mGpsNesting = -1 + this.mGpsNesting;
        if (this.mGpsNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xDFFFFFFF & historyItem.states;
            this.addHistoryRecordLocked(l, l2);
        }
        this.getUidStatsLocked(n2).noteStopGps(l);
    }

    public void noteStopSensorLocked(int n, int n2) {
        int n3 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.mSensorNesting = -1 + this.mSensorNesting;
        if (this.mSensorNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFF7FFFFF & historyItem.states;
            this.addHistoryRecordLocked(l, l2);
        }
        this.getUidStatsLocked(n3).noteStopSensor(n2, l);
    }

    public void noteStopWakeFromSourceLocked(WorkSource workSource, int n, String string2, String string3, int n2) {
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        int n3 = workSource.size();
        for (int i = 0; i < n3; ++i) {
            this.noteStopWakeLocked(workSource.get(i), n, string2, string3, n2, l, l2);
        }
    }

    public void noteStopWakeLocked(int n, int n2, String string2, String string3, int n3, long l, long l2) {
        int n4 = this.mapUid(n);
        if (n3 == 0) {
            this.mWakeLockNesting = -1 + this.mWakeLockNesting;
            if (this.mRecordAllHistory) {
                if (string3 == null) {
                    string3 = string2;
                }
                if (this.mActiveEvents.updateState(16389, string3, n4, 0)) {
                    this.addHistoryEventLocked(l, l2, 16389, string3, n4);
                }
            }
            if (this.mWakeLockNesting == 0) {
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = 0xBFFFFFFF & historyItem.states;
                this.mInitialAcquireWakeName = null;
                this.mInitialAcquireWakeUid = -1;
                this.addHistoryRecordLocked(l, l2);
            }
        }
        if (n4 >= 0) {
            this.requestWakelockCpuUpdate();
            this.getUidStatsLocked(n4).noteStopWakeLocked(n2, string2, n3, l);
        }
    }

    public void noteSyncFinishLocked(String string2, int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.getUidStatsLocked(n2).noteStopSyncLocked(string2, l);
        if (!this.mActiveEvents.updateState(16388, string2, n2, 0)) {
            return;
        }
        this.addHistoryEventLocked(l, l2, 16388, string2, n2);
    }

    public void noteSyncStartLocked(String string2, int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.getUidStatsLocked(n2).noteStartSyncLocked(string2, l);
        if (!this.mActiveEvents.updateState(32772, string2, n2, 0)) {
            return;
        }
        this.addHistoryEventLocked(l, l2, 32772, string2, n2);
    }

    public void noteUserActivityLocked(int n, int n2) {
        if (this.mOnBatteryInternal) {
            this.getUidStatsLocked(this.mapUid(n)).noteUserActivityLocked(n2);
        }
    }

    public void noteVibratorOffLocked(int n) {
        this.getUidStatsLocked(this.mapUid(n)).noteVibratorOffLocked();
    }

    public void noteVibratorOnLocked(int n, long l) {
        this.getUidStatsLocked(this.mapUid(n)).noteVibratorOnLocked(l);
    }

    public void noteVideoOffLocked(int n) {
        int n2;
        if (this.mVideoOnNesting == 0) {
            return;
        }
        int n3 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.mVideoOnNesting = n2 = -1 + this.mVideoOnNesting;
        if (n2 == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states2 = 0xBFFFFFFF & historyItem.states2;
            this.addHistoryRecordLocked(l, l2);
            this.mVideoOnTimer.stopRunningLocked(l);
        }
        this.getUidStatsLocked(n3).noteVideoTurnedOffLocked(l);
    }

    public void noteVideoOnLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        if (this.mVideoOnNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states2 = 0x40000000 | historyItem.states2;
            this.addHistoryRecordLocked(l, l2);
            this.mVideoOnTimer.startRunningLocked(l);
        }
        this.mVideoOnNesting = 1 + this.mVideoOnNesting;
        this.getUidStatsLocked(n2).noteVideoTurnedOnLocked(l);
    }

    public void noteWakeupReasonLocked(String string2) {
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.aggregateLastWakeupUptimeLocked(l2);
        this.mHistoryCur.wakeReasonTag = this.mHistoryCur.localWakeReasonTag;
        this.mHistoryCur.wakeReasonTag.string = string2;
        this.mHistoryCur.wakeReasonTag.uid = 0;
        this.mLastWakeupReason = string2;
        this.mLastWakeupUptimeMs = l2;
        this.addHistoryRecordLocked(l, l2);
    }

    public void noteWifiBatchedScanStartedFromSourceLocked(WorkSource workSource, int n) {
        int n2 = workSource.size();
        for (int i = 0; i < n2; ++i) {
            this.noteWifiBatchedScanStartedLocked(workSource.get(i), n);
        }
    }

    public void noteWifiBatchedScanStartedLocked(int n, int n2) {
        int n3 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        this.getUidStatsLocked(n3).noteWifiBatchedScanStartedLocked(n2, l);
    }

    public void noteWifiBatchedScanStoppedFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteWifiBatchedScanStoppedLocked(workSource.get(i));
        }
    }

    public void noteWifiBatchedScanStoppedLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        this.getUidStatsLocked(n2).noteWifiBatchedScanStoppedLocked(l);
    }

    public void noteWifiMulticastDisabledFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteWifiMulticastDisabledLocked(workSource.get(i));
        }
    }

    public void noteWifiMulticastDisabledLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.mWifiMulticastNesting = -1 + this.mWifiMulticastNesting;
        if (this.mWifiMulticastNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xFBFFFFFF & historyItem.states;
            this.addHistoryRecordLocked(l, l2);
        }
        this.getUidStatsLocked(n2).noteWifiMulticastDisabledLocked(l);
    }

    public void noteWifiMulticastEnabledFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteWifiMulticastEnabledLocked(workSource.get(i));
        }
    }

    public void noteWifiMulticastEnabledLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        if (this.mWifiMulticastNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x4000000 | historyItem.states;
            this.addHistoryRecordLocked(l, l2);
        }
        this.mWifiMulticastNesting = 1 + this.mWifiMulticastNesting;
        this.getUidStatsLocked(n2).noteWifiMulticastEnabledLocked(l);
    }

    public void noteWifiOffLocked() {
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        if (this.mWifiOn) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states2 = 0xEFFFFFFF & historyItem.states2;
            this.addHistoryRecordLocked(l, l2);
            this.mWifiOn = false;
            this.mWifiOnTimer.stopRunningLocked(l);
        }
    }

    public void noteWifiOnLocked() {
        if (!this.mWifiOn) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states2 = 0x10000000 | historyItem.states2;
            this.addHistoryRecordLocked(l, l2);
            this.mWifiOn = true;
            this.mWifiOnTimer.startRunningLocked(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void noteWifiRssiChangedLocked(int n) {
        int n2 = WifiManager.calculateSignalLevel(n, 5);
        if (this.mWifiSignalStrengthBin != n2) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            if (this.mWifiSignalStrengthBin >= 0) {
                this.mWifiSignalStrengthsTimer[this.mWifiSignalStrengthBin].stopRunningLocked(l);
            }
            if (n2 >= 0) {
                if (!this.mWifiSignalStrengthsTimer[n2].isRunningLocked()) {
                    this.mWifiSignalStrengthsTimer[n2].startRunningLocked(l);
                }
                this.mHistoryCur.states2 = 0xFFFFFF8F & this.mHistoryCur.states2 | n2 << 4;
                this.addHistoryRecordLocked(l, l2);
            } else {
                this.stopAllWifiSignalStrengthTimersLocked(-1);
            }
            this.mWifiSignalStrengthBin = n2;
        }
    }

    public void noteWifiRunningChangedLocked(WorkSource workSource, WorkSource workSource2) {
        if (this.mGlobalWifiRunning) {
            long l = SystemClock.elapsedRealtime();
            int n = workSource.size();
            for (int i = 0; i < n; ++i) {
                this.getUidStatsLocked(this.mapUid(workSource.get(i))).noteWifiStoppedLocked(l);
            }
            int n2 = workSource2.size();
            for (int i = 0; i < n2; ++i) {
                this.getUidStatsLocked(this.mapUid(workSource2.get(i))).noteWifiRunningLocked(l);
            }
        } else {
            Log.w(TAG, "noteWifiRunningChangedLocked -- called while WIFI not running");
        }
    }

    public void noteWifiRunningLocked(WorkSource workSource) {
        if (!this.mGlobalWifiRunning) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states2 = 0x20000000 | historyItem.states2;
            this.addHistoryRecordLocked(l, l2);
            this.mGlobalWifiRunning = true;
            this.mGlobalWifiRunningTimer.startRunningLocked(l);
            int n = workSource.size();
            for (int i = 0; i < n; ++i) {
                this.getUidStatsLocked(this.mapUid(workSource.get(i))).noteWifiRunningLocked(l);
            }
        } else {
            Log.w(TAG, "noteWifiRunningLocked -- called while WIFI running");
        }
    }

    public void noteWifiScanStartedFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteWifiScanStartedLocked(workSource.get(i));
        }
    }

    public void noteWifiScanStartedLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        if (this.mWifiScanNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x8000000 | historyItem.states;
            this.addHistoryRecordLocked(l, l2);
        }
        this.mWifiScanNesting = 1 + this.mWifiScanNesting;
        this.getUidStatsLocked(n2).noteWifiScanStartedLocked(l);
    }

    public void noteWifiScanStoppedFromSourceLocked(WorkSource workSource) {
        int n = workSource.size();
        for (int i = 0; i < n; ++i) {
            this.noteWifiScanStoppedLocked(workSource.get(i));
        }
    }

    public void noteWifiScanStoppedLocked(int n) {
        int n2 = this.mapUid(n);
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.mWifiScanNesting = -1 + this.mWifiScanNesting;
        if (this.mWifiScanNesting == 0) {
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0xF7FFFFFF & historyItem.states;
            this.addHistoryRecordLocked(l, l2);
        }
        this.getUidStatsLocked(n2).noteWifiScanStoppedLocked(l);
    }

    public void noteWifiStateLocked(int n, String string2) {
        if (this.mWifiState != n) {
            long l = SystemClock.elapsedRealtime();
            if (this.mWifiState >= 0) {
                this.mWifiStateTimer[this.mWifiState].stopRunningLocked(l);
            }
            this.mWifiState = n;
            this.mWifiStateTimer[n].startRunningLocked(l);
        }
    }

    public void noteWifiStoppedLocked(WorkSource workSource) {
        if (this.mGlobalWifiRunning) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states2 = 0xDFFFFFFF & historyItem.states2;
            this.addHistoryRecordLocked(l, l2);
            this.mGlobalWifiRunning = false;
            this.mGlobalWifiRunningTimer.stopRunningLocked(l);
            int n = workSource.size();
            for (int i = 0; i < n; ++i) {
                this.getUidStatsLocked(this.mapUid(workSource.get(i))).noteWifiStoppedLocked(l);
            }
        } else {
            Log.w(TAG, "noteWifiStoppedLocked -- called while WIFI not running");
        }
    }

    public void noteWifiSupplicantStateChangedLocked(int n, boolean bl) {
        if (this.mWifiSupplState != n) {
            long l = SystemClock.elapsedRealtime();
            long l2 = SystemClock.uptimeMillis();
            if (this.mWifiSupplState >= 0) {
                this.mWifiSupplStateTimer[this.mWifiSupplState].stopRunningLocked(l);
            }
            this.mWifiSupplState = n;
            this.mWifiSupplStateTimer[n].startRunningLocked(l);
            this.mHistoryCur.states2 = 0xFFFFFFF0 & this.mHistoryCur.states2 | n << 0;
            this.addHistoryRecordLocked(l, l2);
        }
    }

    @Override
    public void prepareForDumpLocked() {
        this.pullPendingStateUpdatesLocked();
        this.getStartClockTime();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pullPendingStateUpdatesLocked() {
        this.updateKernelWakelocksLocked();
        this.updateNetworkActivityLocked(65535, SystemClock.elapsedRealtime());
        if (this.mOnBatteryInternal) {
            boolean bl = this.mScreenState == 2;
            this.updateDischargeScreenLevelsLocked(bl, bl);
        }
    }

    public void readFromParcel(Parcel parcel) {
        this.readFromParcelLocked(parcel);
    }

    /*
     * Enabled aggressive block sorting
     */
    void readFromParcelLocked(Parcel parcel) {
        int n = parcel.readInt();
        if (n != -1166707595) {
            throw new ParcelFormatException("Bad magic number: #" + Integer.toHexString(n));
        }
        this.readHistory(parcel, false);
        this.mStartCount = parcel.readInt();
        this.mStartClockTime = parcel.readLong();
        this.mStartPlatformVersion = parcel.readString();
        this.mEndPlatformVersion = parcel.readString();
        this.mUptime = parcel.readLong();
        this.mUptimeStart = parcel.readLong();
        this.mRealtime = parcel.readLong();
        this.mRealtimeStart = parcel.readLong();
        boolean bl = parcel.readInt() != 0;
        this.mOnBattery = bl;
        this.mOnBatteryInternal = false;
        this.mOnBatteryTimeBase.readFromParcel(parcel);
        this.mOnBatteryScreenOffTimeBase.readFromParcel(parcel);
        this.mScreenState = 0;
        this.mScreenOnTimer = new StopwatchTimer(null, -1, null, this.mOnBatteryTimeBase, parcel);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(null, -100 - i, null, this.mOnBatteryTimeBase, parcel);
        }
        this.mInteractive = false;
        this.mInteractiveTimer = new StopwatchTimer(null, -9, null, this.mOnBatteryTimeBase, parcel);
        this.mPhoneOn = false;
        this.mLowPowerModeEnabledTimer = new StopwatchTimer(null, -2, null, this.mOnBatteryTimeBase, parcel);
        this.mPhoneOnTimer = new StopwatchTimer(null, -3, null, this.mOnBatteryTimeBase, parcel);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(null, -200 - i, null, this.mOnBatteryTimeBase, parcel);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(null, -199, null, this.mOnBatteryTimeBase, parcel);
        for (int i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(null, -300 - i, null, this.mOnBatteryTimeBase, parcel);
        }
        for (int i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, parcel);
            this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, parcel);
        }
        this.mMobileRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
        this.mMobileRadioActiveTimer = new StopwatchTimer(null, -400, null, this.mOnBatteryTimeBase, parcel);
        this.mMobileRadioActivePerAppTimer = new StopwatchTimer(null, -401, null, this.mOnBatteryTimeBase, parcel);
        this.mMobileRadioActiveAdjustedTime = new LongSamplingCounter(this.mOnBatteryTimeBase, parcel);
        this.mMobileRadioActiveUnknownTime = new LongSamplingCounter(this.mOnBatteryTimeBase, parcel);
        this.mMobileRadioActiveUnknownCount = new LongSamplingCounter(this.mOnBatteryTimeBase, parcel);
        this.mWifiOn = false;
        this.mWifiOnTimer = new StopwatchTimer(null, -4, null, this.mOnBatteryTimeBase, parcel);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer = new StopwatchTimer(null, -5, null, this.mOnBatteryTimeBase, parcel);
        for (int i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i] = new StopwatchTimer(null, -600 - i, null, this.mOnBatteryTimeBase, parcel);
        }
        for (int i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i] = new StopwatchTimer(null, -700 - i, null, this.mOnBatteryTimeBase, parcel);
        }
        for (int i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i] = new StopwatchTimer(null, -800 - i, null, this.mOnBatteryTimeBase, parcel);
        }
        this.mBluetoothOn = false;
        this.mBluetoothOnTimer = new StopwatchTimer(null, -6, null, this.mOnBatteryTimeBase, parcel);
        for (int i = 0; i < 4; ++i) {
            this.mBluetoothStateTimer[i] = new StopwatchTimer(null, -500 - i, null, this.mOnBatteryTimeBase, parcel);
        }
        this.mAudioOnNesting = 0;
        this.mAudioOnTimer = new StopwatchTimer(null, -7, null, this.mOnBatteryTimeBase);
        this.mVideoOnNesting = 0;
        this.mVideoOnTimer = new StopwatchTimer(null, -8, null, this.mOnBatteryTimeBase);
        this.mFlashlightOn = false;
        this.mFlashlightOnTimer = new StopwatchTimer(null, -9, null, this.mOnBatteryTimeBase, parcel);
        this.mDischargeUnplugLevel = parcel.readInt();
        this.mDischargePlugLevel = parcel.readInt();
        this.mDischargeCurrentLevel = parcel.readInt();
        this.mCurrentBatteryLevel = parcel.readInt();
        this.mLowDischargeAmountSinceCharge = parcel.readInt();
        this.mHighDischargeAmountSinceCharge = parcel.readInt();
        this.mDischargeAmountScreenOn = parcel.readInt();
        this.mDischargeAmountScreenOnSinceCharge = parcel.readInt();
        this.mDischargeAmountScreenOff = parcel.readInt();
        this.mDischargeAmountScreenOffSinceCharge = parcel.readInt();
        this.mNumDischargeStepDurations = parcel.readInt();
        parcel.readLongArray(this.mDischargeStepDurations);
        this.mNumChargeStepDurations = parcel.readInt();
        parcel.readLongArray(this.mChargeStepDurations);
        this.mLastWriteTime = parcel.readLong();
        this.mBluetoothPingCount = parcel.readInt();
        this.mBluetoothPingStart = -1;
        this.mKernelWakelockStats.clear();
        int n2 = parcel.readInt();
        for (int i = 0; i < n2; ++i) {
            if (parcel.readInt() == 0) continue;
            String string2 = parcel.readString();
            SamplingTimer samplingTimer = new SamplingTimer(this.mOnBatteryScreenOffTimeBase, parcel);
            this.mKernelWakelockStats.put(string2, samplingTimer);
        }
        this.mWakeupReasonStats.clear();
        int n3 = parcel.readInt();
        for (int i = 0; i < n3; ++i) {
            if (parcel.readInt() == 0) continue;
            String string3 = parcel.readString();
            SamplingTimer samplingTimer = new SamplingTimer(this.mOnBatteryTimeBase, parcel);
            this.mWakeupReasonStats.put(string3, samplingTimer);
        }
        this.mPartialTimers.clear();
        this.mFullTimers.clear();
        this.mWindowTimers.clear();
        this.mWifiRunningTimers.clear();
        this.mFullWifiLockTimers.clear();
        this.mWifiScanTimers.clear();
        this.mWifiBatchedScanTimers.clear();
        this.mWifiMulticastTimers.clear();
        this.mAudioTurnedOnTimers.clear();
        this.mVideoTurnedOnTimers.clear();
        sNumSpeedSteps = parcel.readInt();
        int n4 = parcel.readInt();
        this.mUidStats.clear();
        int n5 = 0;
        while (n5 < n4) {
            int n6 = parcel.readInt();
            Uid uid = new Uid(n6);
            uid.readFromParcelLocked(this.mOnBatteryTimeBase, this.mOnBatteryScreenOffTimeBase, parcel);
            this.mUidStats.append(n6, uid);
            ++n5;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    void readHistory(Parcel parcel, boolean bl) {
        BatteryStats.HistoryTag historyTag;
        long l = parcel.readLong();
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        int n = parcel.readInt();
        for (int i = 0; i < n; this.mNumHistoryTagChars += 1 + historyTag.string.length(), ++i) {
            int n2 = parcel.readInt();
            String string2 = parcel.readString();
            int n3 = parcel.readInt();
            historyTag = new BatteryStats.HistoryTag();
            historyTag.string = string2;
            historyTag.uid = n3;
            historyTag.poolIdx = n2;
            this.mHistoryTagPool.put(historyTag, n2);
            if (n2 < this.mNextHistoryTagIdx) continue;
            this.mNextHistoryTagIdx = n2 + 1;
        }
        int n4 = parcel.readInt();
        int n5 = parcel.dataPosition();
        if (n4 >= 983040) {
            Slog.w(TAG, "File corrupt: history data buffer too large " + n4);
        } else if ((n4 & 0xFFFFFFFC) != n4) {
            Slog.w(TAG, "File corrupt: history data buffer not aligned " + n4);
        } else {
            this.mHistoryBuffer.appendFrom(parcel, n5, n4);
            parcel.setDataPosition(n5 + n4);
        }
        if (bl) {
            this.readOldHistory(parcel);
        }
        this.mHistoryBaseTime = l;
        if (this.mHistoryBaseTime > 0L) {
            long l2 = SystemClock.elapsedRealtime();
            this.mHistoryBaseTime = 1L + (this.mHistoryBaseTime - l2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readHistoryDelta(Parcel parcel, BatteryStats.HistoryItem historyItem) {
        int n = parcel.readInt();
        int n2 = n & 0x7FFFF;
        historyItem.cmd = 0;
        historyItem.numReadInts = 1;
        if (n2 < 524285) {
            historyItem.time += (long)n2;
        } else {
            if (n2 == 524285) {
                historyItem.time = parcel.readLong();
                historyItem.numReadInts = 2 + historyItem.numReadInts;
                historyItem.readFromParcel(parcel);
                return;
            }
            if (n2 == 524286) {
                int n3 = parcel.readInt();
                historyItem.time += (long)n3;
                historyItem.numReadInts = 1 + historyItem.numReadInts;
            } else {
                historyItem.time = parcel.readLong() + historyItem.time;
                historyItem.numReadInts = 2 + historyItem.numReadInts;
            }
        }
        if ((0x80000 & n) != 0) {
            int n4 = parcel.readInt();
            historyItem.batteryLevel = (byte)(0x7F & n4 >> 25);
            historyItem.batteryTemperature = (short)(n4 << 7 >> 21);
            historyItem.batteryVoltage = (char)(n4 & 0x3FFF);
            historyItem.numReadInts = 1 + historyItem.numReadInts;
        }
        if ((0x100000 & n) != 0) {
            int n5 = parcel.readInt();
            historyItem.states = 0xFF000000 & n | 0xFFFFFF & n5;
            historyItem.batteryStatus = (byte)(7 & n5 >> 29);
            historyItem.batteryHealth = (byte)(7 & n5 >> 26);
            historyItem.batteryPlugType = (byte)(3 & n5 >> 24);
            switch (historyItem.batteryPlugType) {
                case 1: {
                    historyItem.batteryPlugType = 1;
                    break;
                }
                case 2: {
                    historyItem.batteryPlugType = (byte)2;
                    break;
                }
                case 3: {
                    historyItem.batteryPlugType = (byte)4;
                    break;
                }
            }
            historyItem.numReadInts = 1 + historyItem.numReadInts;
        } else {
            historyItem.states = 0xFF000000 & n | 0xFFFFFF & historyItem.states;
        }
        if ((0x200000 & n) != 0) {
            historyItem.states2 = parcel.readInt();
        }
        if ((0x400000 & n) != 0) {
            int n6 = parcel.readInt();
            int n7 = n6 & 0xFFFF;
            int n8 = 0xFFFF & n6 >> 16;
            if (n7 != 65535) {
                historyItem.wakelockTag = historyItem.localWakelockTag;
                this.readHistoryTag(n7, historyItem.wakelockTag);
            } else {
                historyItem.wakelockTag = null;
            }
            if (n8 != 65535) {
                historyItem.wakeReasonTag = historyItem.localWakeReasonTag;
                this.readHistoryTag(n8, historyItem.wakeReasonTag);
            } else {
                historyItem.wakeReasonTag = null;
            }
            historyItem.numReadInts = 1 + historyItem.numReadInts;
        } else {
            historyItem.wakelockTag = null;
            historyItem.wakeReasonTag = null;
        }
        if ((0x800000 & n) != 0) {
            historyItem.eventTag = historyItem.localEventTag;
            int n9 = parcel.readInt();
            historyItem.eventCode = 0xFFFF & n9;
            this.readHistoryTag(0xFFFF & n9 >> 16, historyItem.eventTag);
            historyItem.numReadInts = 1 + historyItem.numReadInts;
            return;
        }
        historyItem.eventCode = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readLocked() {
        if (this.mFile == null) {
            Slog.w("BatteryStats", "readLocked: no file associated with this instance");
            return;
        }
        this.mUidStats.clear();
        try {
            File file = this.mFile.chooseForRead();
            if (!file.exists()) return;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = BatteryStatsHelper.readFully(fileInputStream);
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            fileInputStream.close();
            this.readSummaryFromParcel(parcel);
        }
        catch (Exception exception) {
            Slog.e("BatteryStats", "Error reading battery statistics", exception);
        }
        this.mEndPlatformVersion = Build.ID;
        if (this.mHistoryBuffer.dataPosition() <= 0) {
            return;
        }
        this.mRecordingHistory = true;
        long l = SystemClock.elapsedRealtime();
        long l2 = SystemClock.uptimeMillis();
        this.addHistoryBufferLocked(l, l2, (byte)4, this.mHistoryCur);
        this.startRecordingHistory(l, l2, false);
    }

    void readOldHistory(Parcel parcel) {
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void readSummaryFromParcel(Parcel parcel) {
        int n = parcel.readInt();
        if (n != 114) {
            Slog.w("BatteryStats", "readFromParcel: version got " + n + ", expected " + 114 + "; erasing old stats");
            return;
        }
        this.readHistory(parcel, true);
        this.mStartCount = parcel.readInt();
        this.mUptime = parcel.readLong();
        this.mRealtime = parcel.readLong();
        this.mStartClockTime = parcel.readLong();
        this.mStartPlatformVersion = parcel.readString();
        this.mEndPlatformVersion = parcel.readString();
        this.mOnBatteryTimeBase.readSummaryFromParcel(parcel);
        this.mOnBatteryScreenOffTimeBase.readSummaryFromParcel(parcel);
        this.mDischargeUnplugLevel = parcel.readInt();
        this.mDischargePlugLevel = parcel.readInt();
        this.mDischargeCurrentLevel = parcel.readInt();
        this.mCurrentBatteryLevel = parcel.readInt();
        this.mLowDischargeAmountSinceCharge = parcel.readInt();
        this.mHighDischargeAmountSinceCharge = parcel.readInt();
        this.mDischargeAmountScreenOnSinceCharge = parcel.readInt();
        this.mDischargeAmountScreenOffSinceCharge = parcel.readInt();
        this.mNumDischargeStepDurations = parcel.readInt();
        parcel.readLongArray(this.mDischargeStepDurations);
        this.mNumChargeStepDurations = parcel.readInt();
        parcel.readLongArray(this.mChargeStepDurations);
        this.mStartCount = 1 + this.mStartCount;
        this.mScreenState = 0;
        this.mScreenOnTimer.readSummaryFromParcelLocked(parcel);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].readSummaryFromParcelLocked(parcel);
        }
        this.mInteractive = false;
        this.mInteractiveTimer.readSummaryFromParcelLocked(parcel);
        this.mPhoneOn = false;
        this.mLowPowerModeEnabledTimer.readSummaryFromParcelLocked(parcel);
        this.mPhoneOnTimer.readSummaryFromParcelLocked(parcel);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].readSummaryFromParcelLocked(parcel);
        }
        this.mPhoneSignalScanningTimer.readSummaryFromParcelLocked(parcel);
        for (int i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].readSummaryFromParcelLocked(parcel);
        }
        for (int i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i].readSummaryFromParcelLocked(parcel);
            this.mNetworkPacketActivityCounters[i].readSummaryFromParcelLocked(parcel);
        }
        this.mMobileRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
        this.mMobileRadioActiveTimer.readSummaryFromParcelLocked(parcel);
        this.mMobileRadioActivePerAppTimer.readSummaryFromParcelLocked(parcel);
        this.mMobileRadioActiveAdjustedTime.readSummaryFromParcelLocked(parcel);
        this.mMobileRadioActiveUnknownTime.readSummaryFromParcelLocked(parcel);
        this.mMobileRadioActiveUnknownCount.readSummaryFromParcelLocked(parcel);
        this.mWifiOn = false;
        this.mWifiOnTimer.readSummaryFromParcelLocked(parcel);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer.readSummaryFromParcelLocked(parcel);
        for (int i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].readSummaryFromParcelLocked(parcel);
        }
        for (int i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].readSummaryFromParcelLocked(parcel);
        }
        for (int i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].readSummaryFromParcelLocked(parcel);
        }
        this.mBluetoothOn = false;
        this.mBluetoothOnTimer.readSummaryFromParcelLocked(parcel);
        for (int i = 0; i < 4; ++i) {
            this.mBluetoothStateTimer[i].readSummaryFromParcelLocked(parcel);
        }
        this.mFlashlightOn = false;
        this.mFlashlightOnTimer.readSummaryFromParcelLocked(parcel);
        int n2 = parcel.readInt();
        if (n2 > 10000) {
            Slog.w(TAG, "File corrupt: too many kernel wake locks " + n2);
            return;
        }
        for (int i = 0; i < n2; ++i) {
            if (parcel.readInt() == 0) continue;
            this.getKernelWakelockTimerLocked(parcel.readString()).readSummaryFromParcelLocked(parcel);
        }
        int n3 = parcel.readInt();
        if (n3 > 10000) {
            Slog.w(TAG, "File corrupt: too many wakeup reasons " + n3);
            return;
        }
        for (int i = 0; i < n3; ++i) {
            if (parcel.readInt() == 0) continue;
            this.getWakeupReasonTimerLocked(parcel.readString()).readSummaryFromParcelLocked(parcel);
        }
        sNumSpeedSteps = parcel.readInt();
        if (sNumSpeedSteps < 0) throw new BadParcelableException("Bad speed steps in data: " + sNumSpeedSteps);
        if (sNumSpeedSteps > 100) {
            throw new BadParcelableException("Bad speed steps in data: " + sNumSpeedSteps);
        }
        int n4 = parcel.readInt();
        if (n4 > 10000) {
            Slog.w(TAG, "File corrupt: too many uids " + n4);
            return;
        }
        int n5 = 0;
        while (n5 < n4) {
            int n6;
            int n7 = parcel.readInt();
            Uid uid = new Uid(n7);
            this.mUidStats.put(n7, uid);
            uid.mWifiRunning = false;
            if (parcel.readInt() != 0) {
                uid.mWifiRunningTimer.readSummaryFromParcelLocked(parcel);
            }
            uid.mFullWifiLockOut = false;
            if (parcel.readInt() != 0) {
                uid.mFullWifiLockTimer.readSummaryFromParcelLocked(parcel);
            }
            uid.mWifiScanStarted = false;
            if (parcel.readInt() != 0) {
                uid.mWifiScanTimer.readSummaryFromParcelLocked(parcel);
            }
            uid.mWifiBatchedScanBinStarted = -1;
            for (int i = 0; i < 5; ++i) {
                if (parcel.readInt() == 0) continue;
                uid.makeWifiBatchedScanBin(i, null);
                uid.mWifiBatchedScanTimer[i].readSummaryFromParcelLocked(parcel);
            }
            uid.mWifiMulticastEnabled = false;
            if (parcel.readInt() != 0) {
                uid.mWifiMulticastTimer.readSummaryFromParcelLocked(parcel);
            }
            if (parcel.readInt() != 0) {
                uid.createAudioTurnedOnTimerLocked().readSummaryFromParcelLocked(parcel);
            }
            if (parcel.readInt() != 0) {
                uid.createVideoTurnedOnTimerLocked().readSummaryFromParcelLocked(parcel);
            }
            if (parcel.readInt() != 0) {
                uid.createForegroundActivityTimerLocked().readSummaryFromParcelLocked(parcel);
            }
            uid.mProcessState = 3;
            for (int i = 0; i < 3; ++i) {
                if (parcel.readInt() == 0) continue;
                uid.makeProcessState(i, null);
                uid.mProcessStateTimer[i].readSummaryFromParcelLocked(parcel);
            }
            if (parcel.readInt() != 0) {
                uid.createVibratorOnTimerLocked().readSummaryFromParcelLocked(parcel);
            }
            if (parcel.readInt() != 0) {
                if (uid.mUserActivityCounters == null) {
                    uid.initUserActivityLocked();
                }
                for (int i = 0; i < 3; ++i) {
                    uid.mUserActivityCounters[i].readSummaryFromParcelLocked(parcel);
                }
            }
            if (parcel.readInt() != 0) {
                if (uid.mNetworkByteActivityCounters == null) {
                    uid.initNetworkActivityLocked();
                }
                for (int i = 0; i < 4; ++i) {
                    uid.mNetworkByteActivityCounters[i].readSummaryFromParcelLocked(parcel);
                    uid.mNetworkPacketActivityCounters[i].readSummaryFromParcelLocked(parcel);
                }
                uid.mMobileRadioActiveTime.readSummaryFromParcelLocked(parcel);
                uid.mMobileRadioActiveCount.readSummaryFromParcelLocked(parcel);
            }
            if ((n6 = parcel.readInt()) > 100) {
                Slog.w(TAG, "File corrupt: too many wake locks " + n6);
                return;
            }
            for (int i = 0; i < n6; ++i) {
                uid.readWakeSummaryFromParcelLocked(parcel.readString(), parcel);
            }
            int n8 = parcel.readInt();
            if (n8 > 100) {
                Slog.w(TAG, "File corrupt: too many syncs " + n8);
                return;
            }
            for (int i = 0; i < n8; ++i) {
                uid.readSyncSummaryFromParcelLocked(parcel.readString(), parcel);
            }
            int n9 = parcel.readInt();
            if (n9 > 100) {
                Slog.w(TAG, "File corrupt: too many job timers " + n9);
                return;
            }
            for (int i = 0; i < n9; ++i) {
                uid.readJobSummaryFromParcelLocked(parcel.readString(), parcel);
            }
            int n10 = parcel.readInt();
            if (n10 > 1000) {
                Slog.w(TAG, "File corrupt: too many sensors " + n10);
                return;
            }
            for (int i = 0; i < n10; ++i) {
                int n11 = parcel.readInt();
                if (parcel.readInt() == 0) continue;
                uid.getSensorTimerLocked(n11, true).readSummaryFromParcelLocked(parcel);
            }
            int n12 = parcel.readInt();
            if (n12 > 1000) {
                Slog.w(TAG, "File corrupt: too many processes " + n12);
                return;
            }
            for (int i = 0; i < n12; ++i) {
                int n13;
                long l;
                long l2;
                long l3;
                Uid.Proc proc = uid.getProcessStatsLocked(parcel.readString());
                proc.mLoadedUserTime = l3 = parcel.readLong();
                proc.mUserTime = l3;
                proc.mLoadedSystemTime = l2 = parcel.readLong();
                proc.mSystemTime = l2;
                proc.mLoadedForegroundTime = l = parcel.readLong();
                proc.mForegroundTime = l;
                proc.mLoadedStarts = n13 = parcel.readInt();
                proc.mStarts = n13;
                int n14 = parcel.readInt();
                if (n14 > 100) {
                    Slog.w(TAG, "File corrupt: too many speed bins " + n14);
                    return;
                }
                proc.mSpeedBins = new SamplingCounter[n14];
                for (int j = 0; j < n14; ++j) {
                    if (parcel.readInt() == 0) continue;
                    proc.mSpeedBins[j] = new SamplingCounter(this.mOnBatteryTimeBase);
                    proc.mSpeedBins[j].readSummaryFromParcelLocked(parcel);
                }
                if (!proc.readExcessivePowerFromParcelLocked(parcel)) return;
            }
            int n15 = parcel.readInt();
            if (n15 > 10000) {
                Slog.w(TAG, "File corrupt: too many packages " + n15);
                return;
            }
            for (int i = 0; i < n15; ++i) {
                int n16;
                String string2 = parcel.readString();
                Uid.Pkg pkg = uid.getPackageStatsLocked(string2);
                pkg.mLoadedWakeups = n16 = parcel.readInt();
                pkg.mWakeups = n16;
                int n17 = parcel.readInt();
                if (n17 > 1000) {
                    Slog.w(TAG, "File corrupt: too many services " + n17);
                    return;
                }
                for (int j = 0; j < n17; ++j) {
                    int n18;
                    int n19;
                    long l;
                    Uid.Pkg.Serv serv = uid.getServiceStatsLocked(string2, parcel.readString());
                    serv.mLoadedStartTime = l = parcel.readLong();
                    serv.mStartTime = l;
                    serv.mLoadedStarts = n19 = parcel.readInt();
                    serv.mStarts = n19;
                    serv.mLoadedLaunches = n18 = parcel.readInt();
                    serv.mLaunches = n18;
                }
            }
            ++n5;
        }
    }

    public void removeIsolatedUidLocked(int n, int n2) {
        if (this.mIsolatedUids.get(n, -1) == n2) {
            this.mIsolatedUids.delete(n);
        }
    }

    public void removeUidStatsLocked(int n) {
        this.mUidStats.remove(n);
    }

    public void reportExcessiveCpuLocked(int n, String string2, long l, long l2) {
        int n2 = this.mapUid(n);
        Uid uid = this.mUidStats.get(n2);
        if (uid != null) {
            uid.reportExcessiveCpuLocked(string2, l, l2);
        }
    }

    public void reportExcessiveWakeLocked(int n, String string2, long l, long l2) {
        int n2 = this.mapUid(n);
        Uid uid = this.mUidStats.get(n2);
        if (uid != null) {
            uid.reportExcessiveWakeLocked(string2, l, l2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void resetAllStatsCmdLocked() {
        this.resetAllStatsLocked();
        long l = SystemClock.uptimeMillis();
        long l2 = l * 1000L;
        long l3 = SystemClock.elapsedRealtime();
        long l4 = l3 * 1000L;
        this.mDischargeStartLevel = this.mHistoryCur.batteryLevel;
        this.pullPendingStateUpdatesLocked();
        this.addHistoryRecordLocked(l3, l);
        byte by = this.mHistoryCur.batteryLevel;
        this.mCurrentBatteryLevel = by;
        this.mDischargePlugLevel = by;
        this.mDischargeUnplugLevel = by;
        this.mDischargeCurrentLevel = by;
        this.mOnBatteryTimeBase.reset(l2, l4);
        this.mOnBatteryScreenOffTimeBase.reset(l2, l4);
        if ((0x80000 & this.mHistoryCur.states) == 0) {
            if (this.mScreenState == 2) {
                this.mDischargeScreenOnUnplugLevel = this.mHistoryCur.batteryLevel;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = this.mHistoryCur.batteryLevel;
            }
            this.mDischargeAmountScreenOn = 0;
            this.mDischargeAmountScreenOff = 0;
        }
        this.initActiveHistoryEventsLocked(l3, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBatteryState(int n, int n2, int n3, int n4, int n5, int n6) {
        synchronized (this) {
            boolean bl;
            boolean bl2 = n3 == 0;
            long l = SystemClock.uptimeMillis();
            long l2 = SystemClock.elapsedRealtime();
            int n7 = this.mHistoryCur.batteryStatus;
            if (!this.mHaveBatteryLevel) {
                this.mHaveBatteryLevel = true;
                boolean bl3 = this.mOnBattery;
                if (bl2 == bl3) {
                    if (bl2) {
                        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                        historyItem.states = 0xFFF7FFFF & historyItem.states;
                    } else {
                        BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                        historyItem.states = 0x80000 | historyItem.states;
                    }
                }
                n7 = n;
            }
            if (bl2) {
                this.mDischargeCurrentLevel = n4;
                if (!this.mRecordingHistory) {
                    this.mRecordingHistory = true;
                    this.startRecordingHistory(l2, l, true);
                }
            } else if (n4 < 96 && !this.mRecordingHistory) {
                this.mRecordingHistory = true;
                this.startRecordingHistory(l2, l, true);
            }
            this.mCurrentBatteryLevel = n4;
            if (this.mDischargePlugLevel < 0) {
                this.mDischargePlugLevel = n4;
            }
            if (bl2 != (bl = this.mOnBattery)) {
                this.mHistoryCur.batteryLevel = (byte)n4;
                this.mHistoryCur.batteryStatus = (byte)n;
                this.mHistoryCur.batteryHealth = (byte)n2;
                this.mHistoryCur.batteryPlugType = (byte)n3;
                this.mHistoryCur.batteryTemperature = (short)n5;
                this.mHistoryCur.batteryVoltage = (char)n6;
                this.setOnBatteryLocked(l2, l, bl2, n7, n4);
            } else {
                byte by = this.mHistoryCur.batteryLevel;
                boolean bl4 = false;
                if (by != n4) {
                    this.mHistoryCur.batteryLevel = (byte)n4;
                    bl4 = true;
                }
                if (this.mHistoryCur.batteryStatus != n) {
                    this.mHistoryCur.batteryStatus = (byte)n;
                    bl4 = true;
                }
                if (this.mHistoryCur.batteryHealth != n2) {
                    this.mHistoryCur.batteryHealth = (byte)n2;
                    bl4 = true;
                }
                if (this.mHistoryCur.batteryPlugType != n3) {
                    this.mHistoryCur.batteryPlugType = (byte)n3;
                    bl4 = true;
                }
                if (n5 >= 10 + this.mHistoryCur.batteryTemperature || n5 <= -10 + this.mHistoryCur.batteryTemperature) {
                    this.mHistoryCur.batteryTemperature = (short)n5;
                    bl4 = true;
                }
                if (n6 > 20 + this.mHistoryCur.batteryVoltage || n6 < -20 + this.mHistoryCur.batteryVoltage) {
                    this.mHistoryCur.batteryVoltage = (char)n6;
                    bl4 = true;
                }
                if (bl4) {
                    this.addHistoryRecordLocked(l2, l);
                }
                long l3 = (long)this.mInitStepMode << 48 | (long)this.mModStepMode << 56 | (long)(n4 & 0xFF) << 40;
                if (bl2) {
                    if (this.mLastDischargeStepLevel != n4 && this.mMinDischargeStepLevel > n4) {
                        this.mNumDischargeStepDurations = BatteryStatsImpl.addLevelSteps(this.mDischargeStepDurations, this.mNumDischargeStepDurations, this.mLastDischargeStepTime, this.mLastDischargeStepLevel - n4, l3, l2);
                        this.mLastDischargeStepLevel = n4;
                        this.mMinDischargeStepLevel = n4;
                        this.mLastDischargeStepTime = l2;
                        this.mInitStepMode = this.mCurStepMode;
                        this.mModStepMode = 0;
                    }
                } else if (this.mLastChargeStepLevel != n4 && this.mMaxChargeStepLevel < n4) {
                    this.mNumChargeStepDurations = BatteryStatsImpl.addLevelSteps(this.mChargeStepDurations, this.mNumChargeStepDurations, this.mLastChargeStepTime, n4 - this.mLastChargeStepLevel, l3, l2);
                    this.mLastChargeStepLevel = n4;
                    this.mMaxChargeStepLevel = n4;
                    this.mLastChargeStepTime = l2;
                    this.mInitStepMode = this.mCurStepMode;
                    this.mModStepMode = 0;
                }
            }
            if (!bl2 && n == 5) {
                this.mRecordingHistory = false;
            }
            return;
        }
    }

    public void setBtHeadset(BluetoothHeadset bluetoothHeadset) {
        if (bluetoothHeadset != null && this.mBtHeadset == null && this.isOnBattery() && this.mBluetoothPingStart == -1) {
            this.mBluetoothPingStart = this.getCurrentBluetoothPingCount();
        }
        this.mBtHeadset = bluetoothHeadset;
    }

    public void setCallback(BatteryCallback batteryCallback) {
        this.mCallback = batteryCallback;
    }

    public void setNoAutoReset(boolean bl) {
        this.mNoAutoReset = bl;
    }

    public void setNumSpeedSteps(int n) {
        if (sNumSpeedSteps == 0) {
            sNumSpeedSteps = n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setOnBatteryLocked(long l, long l2, boolean bl, int n, int n2) {
        boolean bl2;
        block12: {
            boolean bl3;
            long l3;
            long l4;
            block9: {
                boolean bl4;
                block10: {
                    block11: {
                        Message message = this.mHandler.obtainMessage(2);
                        int n3 = bl ? 1 : 0;
                        message.arg1 = n3;
                        this.mHandler.sendMessage(message);
                        l4 = l2 * 1000L;
                        l3 = l * 1000L;
                        bl3 = this.mScreenState == 2;
                        if (!bl) break block9;
                        boolean bl5 = this.mNoAutoReset;
                        bl2 = false;
                        bl4 = false;
                        if (bl5) break block10;
                        if (n == 5 || n2 >= 90 || this.mDischargeCurrentLevel < 20 && n2 >= 80) break block11;
                        int n4 = this.getHighDischargeAmountSinceCharge();
                        bl2 = false;
                        bl4 = false;
                        if (n4 < 200) break block10;
                        int n5 = this.mHistoryBuffer.dataSize();
                        bl2 = false;
                        bl4 = false;
                        if (n5 < 262144) break block10;
                    }
                    Slog.i(TAG, "Resetting battery stats: level=" + n2 + " status=" + n + " dischargeLevel=" + this.mDischargeCurrentLevel + " lowAmount=" + this.getLowDischargeAmountSinceCharge() + " highAmount=" + this.getHighDischargeAmountSinceCharge());
                    if (this.getLowDischargeAmountSinceCharge() >= 20) {
                        final Parcel parcel = Parcel.obtain();
                        this.writeSummaryToParcel(parcel, true);
                        BackgroundThread.getHandler().post(new Runnable(){

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public void run() {
                                AtomicFile atomicFile = BatteryStatsImpl.this.mCheckinFile;
                                synchronized (atomicFile) {
                                    FileOutputStream fileOutputStream = null;
                                    try {
                                        fileOutputStream = BatteryStatsImpl.this.mCheckinFile.startWrite();
                                        fileOutputStream.write(parcel.marshall());
                                        fileOutputStream.flush();
                                        FileUtils.sync(fileOutputStream);
                                        fileOutputStream.close();
                                        BatteryStatsImpl.this.mCheckinFile.finishWrite(fileOutputStream);
                                    }
                                    catch (IOException iOException) {
                                        Slog.w("BatteryStats", "Error writing checkin battery statistics", iOException);
                                        BatteryStatsImpl.this.mCheckinFile.failWrite(fileOutputStream);
                                    }
                                    finally {
                                        parcel.recycle();
                                    }
                                    return;
                                }
                            }
                        });
                    }
                    bl2 = true;
                    this.resetAllStatsLocked();
                    this.mDischargeStartLevel = n2;
                    bl4 = true;
                    this.mNumDischargeStepDurations = 0;
                }
                this.mOnBatteryInternal = bl;
                this.mOnBattery = bl;
                this.mLastDischargeStepLevel = n2;
                this.mMinDischargeStepLevel = n2;
                this.mLastDischargeStepTime = -1L;
                this.mInitStepMode = this.mCurStepMode;
                this.mModStepMode = 0;
                this.pullPendingStateUpdatesLocked();
                this.mHistoryCur.batteryLevel = (byte)n2;
                BatteryStats.HistoryItem historyItem = this.mHistoryCur;
                historyItem.states = 0xFFF7FFFF & historyItem.states;
                if (bl4) {
                    this.mRecordingHistory = true;
                    this.startRecordingHistory(l, l2, bl4);
                }
                this.addHistoryRecordLocked(l, l2);
                this.mDischargeUnplugLevel = n2;
                this.mDischargeCurrentLevel = n2;
                if (bl3) {
                    this.mDischargeScreenOnUnplugLevel = n2;
                    this.mDischargeScreenOffUnplugLevel = 0;
                } else {
                    this.mDischargeScreenOnUnplugLevel = 0;
                    this.mDischargeScreenOffUnplugLevel = n2;
                }
                this.mDischargeAmountScreenOn = 0;
                this.mDischargeAmountScreenOff = 0;
                boolean bl6 = !bl3;
                this.updateTimeBasesLocked(true, bl6, l4, l3);
                break block12;
            }
            this.mOnBatteryInternal = bl;
            this.mOnBattery = bl;
            this.pullPendingStateUpdatesLocked();
            this.mHistoryCur.batteryLevel = (byte)n2;
            BatteryStats.HistoryItem historyItem = this.mHistoryCur;
            historyItem.states = 0x80000 | historyItem.states;
            this.addHistoryRecordLocked(l, l2);
            this.mDischargePlugLevel = n2;
            this.mDischargeCurrentLevel = n2;
            if (n2 < this.mDischargeUnplugLevel) {
                this.mLowDischargeAmountSinceCharge += -1 + (this.mDischargeUnplugLevel - n2);
                this.mHighDischargeAmountSinceCharge += this.mDischargeUnplugLevel - n2;
            }
            this.updateDischargeScreenLevelsLocked(bl3, bl3);
            boolean bl7 = !bl3;
            this.updateTimeBasesLocked(false, bl7, l4, l3);
            this.mNumChargeStepDurations = 0;
            this.mLastChargeStepLevel = n2;
            this.mMaxChargeStepLevel = n2;
            this.mLastChargeStepTime = -1L;
            this.mInitStepMode = this.mCurStepMode;
            this.mModStepMode = 0;
            bl2 = false;
        }
        if ((bl2 || 60000L + this.mLastWriteTime < l) && this.mFile != null) {
            this.writeAsyncLocked();
        }
    }

    public void setRadioScanningTimeout(long l) {
        if (this.mPhoneSignalScanningTimer != null) {
            this.mPhoneSignalScanningTimer.setTimeout(l);
        }
    }

    public void setRecordAllHistoryLocked(boolean bl) {
        block6: {
            block5: {
                this.mRecordAllHistory = bl;
                if (bl) break block5;
                this.mActiveEvents.removeEvents(5);
                HashMap<String, SparseIntArray> hashMap = this.mActiveEvents.getStateForEvent(1);
                if (hashMap == null) break block6;
                long l = SystemClock.elapsedRealtime();
                long l2 = SystemClock.uptimeMillis();
                for (Map.Entry<String, SparseIntArray> entry : hashMap.entrySet()) {
                    SparseIntArray sparseIntArray = entry.getValue();
                    for (int i = 0; i < sparseIntArray.size(); ++i) {
                        this.addHistoryEventLocked(l, l2, 16385, entry.getKey(), sparseIntArray.keyAt(i));
                    }
                }
                break block6;
            }
            HashMap<String, SparseIntArray> hashMap = this.mActiveEvents.getStateForEvent(1);
            if (hashMap != null) {
                long l = SystemClock.elapsedRealtime();
                long l3 = SystemClock.uptimeMillis();
                for (Map.Entry<String, SparseIntArray> entry : hashMap.entrySet()) {
                    SparseIntArray sparseIntArray = entry.getValue();
                    for (int i = 0; i < sparseIntArray.size(); ++i) {
                        this.addHistoryEventLocked(l, l3, 32769, entry.getKey(), sparseIntArray.keyAt(i));
                    }
                }
            }
        }
    }

    public void shutdownLocked() {
        this.writeSyncLocked();
        this.mShuttingDown = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int startAddingCpuLocked() {
        this.mHandler.removeMessages(1);
        int n = this.mPartialTimers.size();
        if (n == 0) {
            this.mLastPartialTimers.clear();
            this.mDistributeWakelockCpu = false;
            return 0;
        }
        if (!this.mOnBatteryScreenOffTimeBase.isRunning() && !this.mDistributeWakelockCpu) return 0;
        this.mDistributeWakelockCpu = false;
        int n2 = 0;
        while (n2 < n) {
            Uid uid;
            StopwatchTimer stopwatchTimer = this.mPartialTimers.get(n2);
            if (stopwatchTimer.mInList && (uid = stopwatchTimer.mUid) != null && uid.mUid != 1000) {
                return 50;
            }
            ++n2;
        }
        return 0;
    }

    @Override
    public boolean startIteratingHistoryLocked() {
        if (this.mHistoryBuffer.dataSize() <= 0) {
            return false;
        }
        this.mHistoryBuffer.setDataPosition(0);
        this.mReadOverflow = false;
        this.mIteratingHistory = true;
        this.mReadHistoryStrings = new String[this.mHistoryTagPool.size()];
        this.mReadHistoryUids = new int[this.mHistoryTagPool.size()];
        this.mReadHistoryChars = 0;
        for (Map.Entry<BatteryStats.HistoryTag, Integer> entry : this.mHistoryTagPool.entrySet()) {
            BatteryStats.HistoryTag historyTag = entry.getKey();
            int n = entry.getValue();
            this.mReadHistoryStrings[n] = historyTag.string;
            this.mReadHistoryUids[n] = historyTag.uid;
            this.mReadHistoryChars += 1 + historyTag.string.length();
        }
        return true;
    }

    @Override
    public boolean startIteratingOldHistoryLocked() {
        BatteryStats.HistoryItem historyItem;
        this.mHistoryIterator = historyItem = this.mHistory;
        if (historyItem == null) {
            return false;
        }
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryReadTmp.clear();
        this.mReadOverflow = false;
        this.mIteratingHistory = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void stopAllPhoneSignalStrengthTimersLocked(int n) {
        long l = SystemClock.elapsedRealtime();
        int n2 = 0;
        while (n2 < 5) {
            if (n2 != n) {
                while (this.mPhoneSignalStrengthsTimer[n2].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[n2].stopRunningLocked(l);
                }
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    void stopAllWifiSignalStrengthTimersLocked(int n) {
        long l = SystemClock.elapsedRealtime();
        int n2 = 0;
        while (n2 < 5) {
            if (n2 != n) {
                while (this.mWifiSignalStrengthsTimer[n2].isRunningLocked()) {
                    this.mWifiSignalStrengthsTimer[n2].stopRunningLocked(l);
                }
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateDischargeScreenLevelsLocked(boolean bl, boolean bl2) {
        if (bl) {
            int n = this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            if (n > 0) {
                this.mDischargeAmountScreenOn = n + this.mDischargeAmountScreenOn;
                this.mDischargeAmountScreenOnSinceCharge = n + this.mDischargeAmountScreenOnSinceCharge;
            }
        } else {
            int n = this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            if (n > 0) {
                this.mDischargeAmountScreenOff = n + this.mDischargeAmountScreenOff;
                this.mDischargeAmountScreenOffSinceCharge = n + this.mDischargeAmountScreenOffSinceCharge;
            }
        }
        if (bl2) {
            this.mDischargeScreenOnUnplugLevel = this.mDischargeCurrentLevel;
            this.mDischargeScreenOffUnplugLevel = 0;
            return;
        }
        this.mDischargeScreenOnUnplugLevel = 0;
        this.mDischargeScreenOffUnplugLevel = this.mDischargeCurrentLevel;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateKernelWakelocksLocked() {
        Map<String, KernelWakelockStats> map = this.readKernelWakelockStats();
        if (map == null) {
            Slog.w(TAG, "Couldn't get kernel wake lock stats");
            return;
        } else {
            for (Map.Entry<String, KernelWakelockStats> entry : map.entrySet()) {
                String string2 = entry.getKey();
                KernelWakelockStats kernelWakelockStats = entry.getValue();
                SamplingTimer samplingTimer = this.mKernelWakelockStats.get(string2);
                if (samplingTimer == null) {
                    samplingTimer = new SamplingTimer(this.mOnBatteryScreenOffTimeBase, true);
                    this.mKernelWakelockStats.put(string2, samplingTimer);
                }
                samplingTimer.updateCurrentReportedCount(kernelWakelockStats.mCount);
                samplingTimer.updateCurrentReportedTotalTime(kernelWakelockStats.mTotalTime);
                samplingTimer.setUpdateVersion(sKernelWakelockUpdateVersion);
            }
            if (map.size() == this.mKernelWakelockStats.size()) return;
            Iterator<Map.Entry<String, SamplingTimer>> iterator = this.mKernelWakelockStats.entrySet().iterator();
            while (iterator.hasNext()) {
                SamplingTimer samplingTimer = iterator.next().getValue();
                if (samplingTimer.getUpdateVersion() == sKernelWakelockUpdateVersion) continue;
                samplingTimer.setStale();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateTimeBasesLocked(boolean bl, boolean bl2, long l, long l2) {
        boolean bl3;
        if (this.mOnBatteryTimeBase.setRunning(bl, l, l2)) {
            if (bl) {
                this.mBluetoothPingStart = this.getCurrentBluetoothPingCount();
                this.mBluetoothPingCount = 0;
            } else {
                this.mBluetoothPingCount = this.getBluetoothPingCount();
                this.mBluetoothPingStart = -1;
            }
        }
        if ((bl3 = bl && bl2) != this.mOnBatteryScreenOffTimeBase.isRunning()) {
            this.updateKernelWakelocksLocked();
            this.requestWakelockCpuUpdate();
            if (!bl3) {
                this.mDistributeWakelockCpu = true;
            }
            this.mOnBatteryScreenOffTimeBase.setRunning(bl3, l, l2);
        }
    }

    public void writeAsyncLocked() {
        this.writeLocked(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeHistory(Parcel parcel, boolean bl, boolean bl2) {
        parcel.writeLong(this.mHistoryBaseTime + this.mLastHistoryElapsedRealtime);
        if (!bl) {
            parcel.writeInt(0);
            parcel.writeInt(0);
            return;
        } else {
            parcel.writeInt(this.mHistoryTagPool.size());
            for (Map.Entry<BatteryStats.HistoryTag, Integer> entry : this.mHistoryTagPool.entrySet()) {
                BatteryStats.HistoryTag historyTag = entry.getKey();
                parcel.writeInt(entry.getValue());
                parcel.writeString(historyTag.string);
                parcel.writeInt(historyTag.uid);
            }
            parcel.writeInt(this.mHistoryBuffer.dataSize());
            parcel.appendFrom(this.mHistoryBuffer, 0, this.mHistoryBuffer.dataSize());
            if (!bl2) return;
            this.writeOldHistory(parcel);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeHistoryDelta(Parcel parcel, BatteryStats.HistoryItem historyItem, BatteryStats.HistoryItem historyItem2) {
        if (historyItem2 == null || historyItem.cmd != 0) {
            parcel.writeInt(524285);
            historyItem.writeToParcel(parcel, 0);
            return;
        } else {
            boolean bl;
            int n;
            boolean bl2;
            long l = historyItem.time - historyItem2.time;
            int n2 = this.buildBatteryLevelInt(historyItem2);
            int n3 = this.buildStateInt(historyItem2);
            int n4 = l < 0L || l > Integer.MAX_VALUE ? 524287 : (l >= 524285L ? 524286 : (int)l);
            int n5 = n4 | 0xFF000000 & historyItem.states;
            int n6 = this.buildBatteryLevelInt(historyItem);
            boolean bl3 = n6 != n2;
            if (bl3) {
                n5 |= 0x80000;
            }
            if (bl2 = (n = this.buildStateInt(historyItem)) != n3) {
                n5 |= 0x100000;
            }
            if (bl = historyItem.states2 != historyItem2.states2) {
                n5 |= 0x200000;
            }
            if (historyItem.wakelockTag != null || historyItem.wakeReasonTag != null) {
                n5 |= 0x400000;
            }
            if (historyItem.eventCode != 0) {
                n5 |= 0x800000;
            }
            parcel.writeInt(n5);
            if (n4 >= 524286) {
                if (n4 == 524286) {
                    parcel.writeInt((int)l);
                } else {
                    parcel.writeLong(l);
                }
            }
            if (bl3) {
                parcel.writeInt(n6);
            }
            if (bl2) {
                parcel.writeInt(n);
            }
            if (bl) {
                parcel.writeInt(historyItem.states2);
            }
            if (historyItem.wakelockTag != null || historyItem.wakeReasonTag != null) {
                int n7 = historyItem.wakelockTag != null ? this.writeHistoryTag(historyItem.wakelockTag) : 65535;
                int n8 = historyItem.wakeReasonTag != null ? this.writeHistoryTag(historyItem.wakeReasonTag) : 65535;
                parcel.writeInt(n7 | n8 << 16);
            }
            if (historyItem.eventCode == 0) return;
            int n9 = this.writeHistoryTag(historyItem.eventTag);
            parcel.writeInt(0xFFFF & historyItem.eventCode | n9 << 16);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeLocked(boolean bl) {
        if (this.mFile == null) {
            Slog.w("BatteryStats", "writeLocked: no file associated with this instance");
            return;
        }
        if (this.mShuttingDown) return;
        Parcel parcel = Parcel.obtain();
        this.writeSummaryToParcel(parcel, true);
        this.mLastWriteTime = SystemClock.elapsedRealtime();
        if (this.mPendingWrite != null) {
            this.mPendingWrite.recycle();
        }
        this.mPendingWrite = parcel;
        if (bl) {
            this.commitPendingDataToDisk();
            return;
        }
        BackgroundThread.getHandler().post(new Runnable(){

            @Override
            public void run() {
                BatteryStatsImpl.this.commitPendingDataToDisk();
            }
        });
    }

    void writeOldHistory(Parcel parcel) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeSummaryToParcel(Parcel parcel, boolean bl) {
        this.pullPendingStateUpdatesLocked();
        long l = this.getStartClockTime();
        long l2 = 1000L * SystemClock.uptimeMillis();
        long l3 = 1000L * SystemClock.elapsedRealtime();
        parcel.writeInt(114);
        this.writeHistory(parcel, bl, true);
        parcel.writeInt(this.mStartCount);
        parcel.writeLong(this.computeUptime(l2, 0));
        parcel.writeLong(this.computeRealtime(l3, 0));
        parcel.writeLong(l);
        parcel.writeString(this.mStartPlatformVersion);
        parcel.writeString(this.mEndPlatformVersion);
        this.mOnBatteryTimeBase.writeSummaryToParcel(parcel, l2, l3);
        this.mOnBatteryScreenOffTimeBase.writeSummaryToParcel(parcel, l2, l3);
        parcel.writeInt(this.mDischargeUnplugLevel);
        parcel.writeInt(this.mDischargePlugLevel);
        parcel.writeInt(this.mDischargeCurrentLevel);
        parcel.writeInt(this.mCurrentBatteryLevel);
        parcel.writeInt(this.getLowDischargeAmountSinceCharge());
        parcel.writeInt(this.getHighDischargeAmountSinceCharge());
        parcel.writeInt(this.getDischargeAmountScreenOnSinceCharge());
        parcel.writeInt(this.getDischargeAmountScreenOffSinceCharge());
        parcel.writeInt(this.mNumDischargeStepDurations);
        parcel.writeLongArray(this.mDischargeStepDurations);
        parcel.writeInt(this.mNumChargeStepDurations);
        parcel.writeLongArray(this.mChargeStepDurations);
        this.mScreenOnTimer.writeSummaryFromParcelLocked(parcel, l3);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeSummaryFromParcelLocked(parcel, l3);
        }
        this.mInteractiveTimer.writeSummaryFromParcelLocked(parcel, l3);
        this.mLowPowerModeEnabledTimer.writeSummaryFromParcelLocked(parcel, l3);
        this.mPhoneOnTimer.writeSummaryFromParcelLocked(parcel, l3);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeSummaryFromParcelLocked(parcel, l3);
        }
        this.mPhoneSignalScanningTimer.writeSummaryFromParcelLocked(parcel, l3);
        for (int i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeSummaryFromParcelLocked(parcel, l3);
        }
        for (int i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i].writeSummaryFromParcelLocked(parcel);
            this.mNetworkPacketActivityCounters[i].writeSummaryFromParcelLocked(parcel);
        }
        this.mMobileRadioActiveTimer.writeSummaryFromParcelLocked(parcel, l3);
        this.mMobileRadioActivePerAppTimer.writeSummaryFromParcelLocked(parcel, l3);
        this.mMobileRadioActiveAdjustedTime.writeSummaryFromParcelLocked(parcel);
        this.mMobileRadioActiveUnknownTime.writeSummaryFromParcelLocked(parcel);
        this.mMobileRadioActiveUnknownCount.writeSummaryFromParcelLocked(parcel);
        this.mWifiOnTimer.writeSummaryFromParcelLocked(parcel, l3);
        this.mGlobalWifiRunningTimer.writeSummaryFromParcelLocked(parcel, l3);
        for (int i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].writeSummaryFromParcelLocked(parcel, l3);
        }
        for (int i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].writeSummaryFromParcelLocked(parcel, l3);
        }
        for (int i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].writeSummaryFromParcelLocked(parcel, l3);
        }
        this.mBluetoothOnTimer.writeSummaryFromParcelLocked(parcel, l3);
        for (int i = 0; i < 4; ++i) {
            this.mBluetoothStateTimer[i].writeSummaryFromParcelLocked(parcel, l3);
        }
        this.mFlashlightOnTimer.writeSummaryFromParcelLocked(parcel, l3);
        parcel.writeInt(this.mKernelWakelockStats.size());
        for (Map.Entry<String, SamplingTimer> entry : this.mKernelWakelockStats.entrySet()) {
            Timer timer = entry.getValue();
            if (timer != null) {
                parcel.writeInt(1);
                parcel.writeString(entry.getKey());
                timer.writeSummaryFromParcelLocked(parcel, l3);
                continue;
            }
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mWakeupReasonStats.size());
        for (Map.Entry<String, SamplingTimer> entry : this.mWakeupReasonStats.entrySet()) {
            SamplingTimer samplingTimer = entry.getValue();
            if (samplingTimer != null) {
                parcel.writeInt(1);
                parcel.writeString(entry.getKey());
                samplingTimer.writeSummaryFromParcelLocked(parcel, l3);
                continue;
            }
            parcel.writeInt(0);
        }
        parcel.writeInt(sNumSpeedSteps);
        int n = this.mUidStats.size();
        parcel.writeInt(n);
        int n2 = 0;
        block10: while (n2 < n) {
            parcel.writeInt(this.mUidStats.keyAt(n2));
            Uid uid = this.mUidStats.valueAt(n2);
            if (uid.mWifiRunningTimer != null) {
                parcel.writeInt(1);
                uid.mWifiRunningTimer.writeSummaryFromParcelLocked(parcel, l3);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mFullWifiLockTimer != null) {
                parcel.writeInt(1);
                uid.mFullWifiLockTimer.writeSummaryFromParcelLocked(parcel, l3);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mWifiScanTimer != null) {
                parcel.writeInt(1);
                uid.mWifiScanTimer.writeSummaryFromParcelLocked(parcel, l3);
            } else {
                parcel.writeInt(0);
            }
            for (int i = 0; i < 5; ++i) {
                if (uid.mWifiBatchedScanTimer[i] != null) {
                    parcel.writeInt(1);
                    uid.mWifiBatchedScanTimer[i].writeSummaryFromParcelLocked(parcel, l3);
                    continue;
                }
                parcel.writeInt(0);
            }
            if (uid.mWifiMulticastTimer != null) {
                parcel.writeInt(1);
                uid.mWifiMulticastTimer.writeSummaryFromParcelLocked(parcel, l3);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mAudioTurnedOnTimer != null) {
                parcel.writeInt(1);
                uid.mAudioTurnedOnTimer.writeSummaryFromParcelLocked(parcel, l3);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mVideoTurnedOnTimer != null) {
                parcel.writeInt(1);
                uid.mVideoTurnedOnTimer.writeSummaryFromParcelLocked(parcel, l3);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mForegroundActivityTimer != null) {
                parcel.writeInt(1);
                uid.mForegroundActivityTimer.writeSummaryFromParcelLocked(parcel, l3);
            } else {
                parcel.writeInt(0);
            }
            for (int i = 0; i < 3; ++i) {
                if (uid.mProcessStateTimer[i] != null) {
                    parcel.writeInt(1);
                    uid.mProcessStateTimer[i].writeSummaryFromParcelLocked(parcel, l3);
                    continue;
                }
                parcel.writeInt(0);
            }
            if (uid.mVibratorOnTimer != null) {
                parcel.writeInt(1);
                uid.mVibratorOnTimer.writeSummaryFromParcelLocked(parcel, l3);
            } else {
                parcel.writeInt(0);
            }
            if (uid.mUserActivityCounters == null) {
                parcel.writeInt(0);
            } else {
                parcel.writeInt(1);
                for (int i = 0; i < 3; ++i) {
                    uid.mUserActivityCounters[i].writeSummaryFromParcelLocked(parcel);
                }
            }
            if (uid.mNetworkByteActivityCounters == null) {
                parcel.writeInt(0);
            } else {
                parcel.writeInt(1);
                for (int i = 0; i < 4; ++i) {
                    uid.mNetworkByteActivityCounters[i].writeSummaryFromParcelLocked(parcel);
                    uid.mNetworkPacketActivityCounters[i].writeSummaryFromParcelLocked(parcel);
                }
                uid.mMobileRadioActiveTime.writeSummaryFromParcelLocked(parcel);
                uid.mMobileRadioActiveCount.writeSummaryFromParcelLocked(parcel);
            }
            ArrayMap<String, Uid.Wakelock> arrayMap = uid.mWakelockStats.getMap();
            int n3 = arrayMap.size();
            parcel.writeInt(n3);
            for (int i = 0; i < n3; ++i) {
                parcel.writeString(arrayMap.keyAt(i));
                Uid.Wakelock wakelock = arrayMap.valueAt(i);
                if (wakelock.mTimerFull != null) {
                    parcel.writeInt(1);
                    wakelock.mTimerFull.writeSummaryFromParcelLocked(parcel, l3);
                } else {
                    parcel.writeInt(0);
                }
                if (wakelock.mTimerPartial != null) {
                    parcel.writeInt(1);
                    wakelock.mTimerPartial.writeSummaryFromParcelLocked(parcel, l3);
                } else {
                    parcel.writeInt(0);
                }
                if (wakelock.mTimerWindow != null) {
                    parcel.writeInt(1);
                    wakelock.mTimerWindow.writeSummaryFromParcelLocked(parcel, l3);
                    continue;
                }
                parcel.writeInt(0);
            }
            ArrayMap<String, StopwatchTimer> arrayMap2 = uid.mSyncStats.getMap();
            int n4 = arrayMap2.size();
            parcel.writeInt(n4);
            for (int i = 0; i < n4; ++i) {
                parcel.writeString(arrayMap2.keyAt(i));
                arrayMap2.valueAt(i).writeSummaryFromParcelLocked(parcel, l3);
            }
            ArrayMap<String, StopwatchTimer> arrayMap3 = uid.mJobStats.getMap();
            int n5 = arrayMap3.size();
            parcel.writeInt(n5);
            for (int i = 0; i < n5; ++i) {
                parcel.writeString(arrayMap3.keyAt(i));
                arrayMap3.valueAt(i).writeSummaryFromParcelLocked(parcel, l3);
            }
            int n6 = uid.mSensorStats.size();
            parcel.writeInt(n6);
            for (int i = 0; i < n6; ++i) {
                parcel.writeInt(uid.mSensorStats.keyAt(i));
                Uid.Sensor sensor = uid.mSensorStats.valueAt(i);
                if (sensor.mTimer != null) {
                    parcel.writeInt(1);
                    sensor.mTimer.writeSummaryFromParcelLocked(parcel, l3);
                    continue;
                }
                parcel.writeInt(0);
            }
            int n7 = uid.mProcessStats.size();
            parcel.writeInt(n7);
            int n8 = 0;
            while (true) {
                int n9;
                Uid.Proc proc;
                if (n8 < n7) {
                    parcel.writeString(uid.mProcessStats.keyAt(n8));
                    proc = uid.mProcessStats.valueAt(n8);
                    parcel.writeLong(proc.mUserTime);
                    parcel.writeLong(proc.mSystemTime);
                    parcel.writeLong(proc.mForegroundTime);
                    parcel.writeInt(proc.mStarts);
                    n9 = proc.mSpeedBins.length;
                    parcel.writeInt(n9);
                } else {
                    int n10 = uid.mPackageStats.size();
                    parcel.writeInt(n10);
                    if (n10 > 0) {
                        for (Map.Entry<String, Uid.Pkg> entry : uid.mPackageStats.entrySet()) {
                            parcel.writeString(entry.getKey());
                            Uid.Pkg pkg = entry.getValue();
                            parcel.writeInt(pkg.mWakeups);
                            int n11 = pkg.mServiceStats.size();
                            parcel.writeInt(n11);
                            if (n11 <= 0) continue;
                            for (Map.Entry<String, Uid.Pkg.Serv> entry2 : pkg.mServiceStats.entrySet()) {
                                parcel.writeString(entry2.getKey());
                                Uid.Pkg.Serv serv = entry2.getValue();
                                parcel.writeLong(serv.getStartTimeToNowLocked(this.mOnBatteryTimeBase.getUptime(l2)));
                                parcel.writeInt(serv.mStarts);
                                parcel.writeInt(serv.mLaunches);
                            }
                        }
                    }
                    ++n2;
                    continue block10;
                }
                for (int i = 0; i < n9; ++i) {
                    if (proc.mSpeedBins[i] != null) {
                        parcel.writeInt(1);
                        proc.mSpeedBins[i].writeSummaryFromParcelLocked(parcel);
                        continue;
                    }
                    parcel.writeInt(0);
                }
                proc.writeExcessivePowerToParcelLocked(parcel);
                ++n8;
            }
            break;
        }
        return;
    }

    public void writeSyncLocked() {
        this.writeLocked(true);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.writeToParcelLocked(parcel, true, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeToParcelLocked(Parcel parcel, boolean bl, int n) {
        this.pullPendingStateUpdatesLocked();
        long l = this.getStartClockTime();
        long l2 = 1000L * SystemClock.uptimeMillis();
        long l3 = 1000L * SystemClock.elapsedRealtime();
        this.mOnBatteryTimeBase.getRealtime(l3);
        this.mOnBatteryScreenOffTimeBase.getRealtime(l3);
        parcel.writeInt(-1166707595);
        this.writeHistory(parcel, true, false);
        parcel.writeInt(this.mStartCount);
        parcel.writeLong(l);
        parcel.writeString(this.mStartPlatformVersion);
        parcel.writeString(this.mEndPlatformVersion);
        parcel.writeLong(this.mUptime);
        parcel.writeLong(this.mUptimeStart);
        parcel.writeLong(this.mRealtime);
        parcel.writeLong(this.mRealtimeStart);
        int n2 = this.mOnBattery ? 1 : 0;
        parcel.writeInt(n2);
        this.mOnBatteryTimeBase.writeToParcel(parcel, l2, l3);
        this.mOnBatteryScreenOffTimeBase.writeToParcel(parcel, l2, l3);
        this.mScreenOnTimer.writeToParcel(parcel, l3);
        for (int i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeToParcel(parcel, l3);
        }
        this.mInteractiveTimer.writeToParcel(parcel, l3);
        this.mLowPowerModeEnabledTimer.writeToParcel(parcel, l3);
        this.mPhoneOnTimer.writeToParcel(parcel, l3);
        for (int i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeToParcel(parcel, l3);
        }
        this.mPhoneSignalScanningTimer.writeToParcel(parcel, l3);
        for (int i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeToParcel(parcel, l3);
        }
        for (int i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i].writeToParcel(parcel);
            this.mNetworkPacketActivityCounters[i].writeToParcel(parcel);
        }
        this.mMobileRadioActiveTimer.writeToParcel(parcel, l3);
        this.mMobileRadioActivePerAppTimer.writeToParcel(parcel, l3);
        this.mMobileRadioActiveAdjustedTime.writeToParcel(parcel);
        this.mMobileRadioActiveUnknownTime.writeToParcel(parcel);
        this.mMobileRadioActiveUnknownCount.writeToParcel(parcel);
        this.mWifiOnTimer.writeToParcel(parcel, l3);
        this.mGlobalWifiRunningTimer.writeToParcel(parcel, l3);
        for (int i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].writeToParcel(parcel, l3);
        }
        for (int i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].writeToParcel(parcel, l3);
        }
        for (int i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].writeToParcel(parcel, l3);
        }
        this.mBluetoothOnTimer.writeToParcel(parcel, l3);
        for (int i = 0; i < 4; ++i) {
            this.mBluetoothStateTimer[i].writeToParcel(parcel, l3);
        }
        this.mFlashlightOnTimer.writeToParcel(parcel, l3);
        parcel.writeInt(this.mDischargeUnplugLevel);
        parcel.writeInt(this.mDischargePlugLevel);
        parcel.writeInt(this.mDischargeCurrentLevel);
        parcel.writeInt(this.mCurrentBatteryLevel);
        parcel.writeInt(this.mLowDischargeAmountSinceCharge);
        parcel.writeInt(this.mHighDischargeAmountSinceCharge);
        parcel.writeInt(this.mDischargeAmountScreenOn);
        parcel.writeInt(this.mDischargeAmountScreenOnSinceCharge);
        parcel.writeInt(this.mDischargeAmountScreenOff);
        parcel.writeInt(this.mDischargeAmountScreenOffSinceCharge);
        parcel.writeInt(this.mNumDischargeStepDurations);
        parcel.writeLongArray(this.mDischargeStepDurations);
        parcel.writeInt(this.mNumChargeStepDurations);
        parcel.writeLongArray(this.mChargeStepDurations);
        parcel.writeLong(this.mLastWriteTime);
        parcel.writeInt(this.getBluetoothPingCount());
        if (!bl) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(this.mKernelWakelockStats.size());
            for (Map.Entry<String, SamplingTimer> entry : this.mKernelWakelockStats.entrySet()) {
                SamplingTimer samplingTimer = entry.getValue();
                if (samplingTimer != null) {
                    parcel.writeInt(1);
                    parcel.writeString(entry.getKey());
                    samplingTimer.writeToParcel(parcel, l3);
                    continue;
                }
                parcel.writeInt(0);
            }
            parcel.writeInt(this.mWakeupReasonStats.size());
            for (Map.Entry<String, SamplingTimer> entry : this.mWakeupReasonStats.entrySet()) {
                SamplingTimer samplingTimer = entry.getValue();
                if (samplingTimer != null) {
                    parcel.writeInt(1);
                    parcel.writeString(entry.getKey());
                    samplingTimer.writeToParcel(parcel, l3);
                    continue;
                }
                parcel.writeInt(0);
            }
        }
        parcel.writeInt(sNumSpeedSteps);
        if (bl) {
            int n3 = this.mUidStats.size();
            parcel.writeInt(n3);
            for (int i = 0; i < n3; ++i) {
                parcel.writeInt(this.mUidStats.keyAt(i));
                this.mUidStats.valueAt(i).writeToParcelLocked(parcel, l3);
            }
            return;
        } else {
            parcel.writeInt(0);
        }
    }

    @Override
    public void writeToParcelWithoutUids(Parcel parcel, int n) {
        this.writeToParcelLocked(parcel, false, n);
    }

    public static final class BatchTimer
    extends Timer {
        boolean mInDischarge;
        long mLastAddedDuration;
        long mLastAddedTime;
        final Uid mUid;

        BatchTimer(Uid uid, int n, TimeBase timeBase) {
            super(n, timeBase);
            this.mUid = uid;
            this.mInDischarge = timeBase.isRunning();
        }

        BatchTimer(Uid uid, int n, TimeBase timeBase, Parcel parcel) {
            super(n, timeBase, parcel);
            this.mUid = uid;
            this.mLastAddedTime = parcel.readLong();
            this.mLastAddedDuration = parcel.readLong();
            this.mInDischarge = timeBase.isRunning();
        }

        private long computeOverage(long l) {
            long l2 = 0L;
            if (this.mLastAddedTime > l2) {
                l2 = this.mLastTime + this.mLastAddedDuration - l;
            }
            return l2;
        }

        private void recomputeLastDuration(long l, boolean bl) {
            long l2;
            block5: {
                block4: {
                    l2 = this.computeOverage(l);
                    if (l2 <= 0L) break block4;
                    if (this.mInDischarge) {
                        this.mTotalTime -= l2;
                    }
                    if (!bl) break block5;
                    this.mLastAddedTime = 0L;
                }
                return;
            }
            this.mLastAddedTime = l;
            this.mLastAddedDuration -= l2;
        }

        public void abortLastDuration(BatteryStatsImpl batteryStatsImpl) {
            this.recomputeLastDuration(1000L * SystemClock.elapsedRealtime(), true);
        }

        public void addDuration(BatteryStatsImpl batteryStatsImpl, long l) {
            long l2 = 1000L * SystemClock.elapsedRealtime();
            this.recomputeLastDuration(l2, true);
            this.mLastAddedTime = l2;
            this.mLastAddedDuration = l * 1000L;
            if (this.mInDischarge) {
                this.mTotalTime += this.mLastAddedDuration;
                this.mCount = 1 + this.mCount;
            }
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        @Override
        protected long computeRunTimeLocked(long l) {
            long l2 = this.computeOverage(1000L * SystemClock.elapsedRealtime());
            if (l2 > 0L) {
                this.mTotalTime = l2;
                return l2;
            }
            return this.mTotalTime;
        }

        @Override
        public void logState(Printer printer, String string2) {
            super.logState(printer, string2);
            printer.println(string2 + "mLastAddedTime=" + this.mLastAddedTime + " mLastAddedDuration=" + this.mLastAddedDuration);
        }

        @Override
        public void onTimeStarted(long l, long l2, long l3) {
            this.recomputeLastDuration(l, false);
            this.mInDischarge = true;
            if (this.mLastAddedTime == l) {
                this.mTotalTime += this.mLastAddedDuration;
            }
            super.onTimeStarted(l, l2, l3);
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            this.recomputeLastDuration(1000L * SystemClock.elapsedRealtime(), false);
            this.mInDischarge = false;
            super.onTimeStopped(l, l2, l3);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        boolean reset(boolean bl) {
            long l = 1000L * SystemClock.elapsedRealtime();
            this.recomputeLastDuration(l, true);
            boolean bl2 = this.mLastAddedTime == l;
            boolean bl3 = !bl2 && bl;
            super.reset(bl3);
            return !bl2;
        }

        @Override
        public void writeToParcel(Parcel parcel, long l) {
            super.writeToParcel(parcel, l);
            parcel.writeLong(this.mLastAddedTime);
            parcel.writeLong(this.mLastAddedDuration);
        }
    }

    public static interface BatteryCallback {
        public void batteryNeedsCpuUpdate();

        public void batteryPowerChanged(boolean var1);
    }

    public static class Counter
    extends BatteryStats.Counter
    implements TimeBaseObs {
        final AtomicInteger mCount = new AtomicInteger();
        int mLastCount;
        int mLoadedCount;
        int mPluggedCount;
        final TimeBase mTimeBase;
        int mUnpluggedCount;

        Counter(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        Counter(TimeBase timeBase, Parcel parcel) {
            this.mTimeBase = timeBase;
            this.mPluggedCount = parcel.readInt();
            this.mCount.set(this.mPluggedCount);
            this.mLoadedCount = parcel.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = parcel.readInt();
            timeBase.add(this);
        }

        public static void writeCounterToParcel(Parcel parcel, Counter counter) {
            if (counter == null) {
                parcel.writeInt(0);
                return;
            }
            parcel.writeInt(1);
            counter.writeToParcel(parcel);
        }

        void detach() {
            this.mTimeBase.remove(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int getCountLocked(int n) {
            int n2 = this.mCount.get();
            if (n == 2) {
                n2 -= this.mUnpluggedCount;
                return n2;
            } else {
                if (n == 0) return n2;
                return n2 - this.mLoadedCount;
            }
        }

        @Override
        public void logState(Printer printer, String string2) {
            printer.println(string2 + "mCount=" + this.mCount.get() + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount + " mPluggedCount=" + this.mPluggedCount);
        }

        @Override
        public void onTimeStarted(long l, long l2, long l3) {
            this.mUnpluggedCount = this.mPluggedCount;
            this.mCount.set(this.mPluggedCount);
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            this.mPluggedCount = this.mCount.get();
        }

        void readSummaryFromParcelLocked(Parcel parcel) {
            int n;
            this.mLoadedCount = parcel.readInt();
            this.mCount.set(this.mLoadedCount);
            this.mLastCount = 0;
            this.mPluggedCount = n = this.mLoadedCount;
            this.mUnpluggedCount = n;
        }

        void reset(boolean bl) {
            this.mCount.set(0);
            this.mUnpluggedCount = 0;
            this.mPluggedCount = 0;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            if (bl) {
                this.detach();
            }
        }

        void stepAtomic() {
            this.mCount.incrementAndGet();
        }

        void writeSummaryFromParcelLocked(Parcel parcel) {
            parcel.writeInt(this.mCount.get());
        }

        public void writeToParcel(Parcel parcel) {
            parcel.writeInt(this.mCount.get());
            parcel.writeInt(this.mLoadedCount);
            parcel.writeInt(this.mUnpluggedCount);
        }
    }

    private class KernelWakelockStats {
        public int mCount;
        public long mTotalTime;
        public int mVersion;

        KernelWakelockStats(int n, long l, int n2) {
            this.mCount = n;
            this.mTotalTime = l;
            this.mVersion = n2;
        }
    }

    public static class LongSamplingCounter
    extends BatteryStats.LongCounter
    implements TimeBaseObs {
        long mCount;
        long mLastCount;
        long mLoadedCount;
        long mPluggedCount;
        final TimeBase mTimeBase;
        long mUnpluggedCount;

        LongSamplingCounter(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        LongSamplingCounter(TimeBase timeBase, Parcel parcel) {
            this.mTimeBase = timeBase;
            this.mCount = this.mPluggedCount = parcel.readLong();
            this.mLoadedCount = parcel.readLong();
            this.mLastCount = 0L;
            this.mUnpluggedCount = parcel.readLong();
            timeBase.add(this);
        }

        void addCountLocked(long l) {
            this.mCount = l + this.mCount;
        }

        void detach() {
            this.mTimeBase.remove(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public long getCountLocked(int n) {
            long l = this.mCount;
            if (n == 2) {
                l -= this.mUnpluggedCount;
                return l;
            } else {
                if (n == 0) return l;
                return l - this.mLoadedCount;
            }
        }

        @Override
        public void logState(Printer printer, String string2) {
            printer.println(string2 + "mCount=" + this.mCount + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount + " mPluggedCount=" + this.mPluggedCount);
        }

        @Override
        public void onTimeStarted(long l, long l2, long l3) {
            this.mUnpluggedCount = this.mPluggedCount;
            this.mCount = this.mPluggedCount;
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            this.mPluggedCount = this.mCount;
        }

        void readSummaryFromParcelLocked(Parcel parcel) {
            long l;
            this.mCount = this.mLoadedCount = parcel.readLong();
            this.mLastCount = 0L;
            this.mPluggedCount = l = this.mLoadedCount;
            this.mUnpluggedCount = l;
        }

        void reset(boolean bl) {
            this.mCount = 0L;
            this.mUnpluggedCount = 0L;
            this.mPluggedCount = 0L;
            this.mLastCount = 0L;
            this.mLoadedCount = 0L;
            if (bl) {
                this.detach();
            }
        }

        void writeSummaryFromParcelLocked(Parcel parcel) {
            parcel.writeLong(this.mCount);
        }

        public void writeToParcel(Parcel parcel) {
            parcel.writeLong(this.mCount);
            parcel.writeLong(this.mLoadedCount);
            parcel.writeLong(this.mUnpluggedCount);
        }
    }

    final class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            boolean bl;
            BatteryCallback batteryCallback = BatteryStatsImpl.this.mCallback;
            switch (message.what) {
                case 1: {
                    if (batteryCallback == null) return;
                    batteryCallback.batteryNeedsCpuUpdate();
                    return;
                }
                default: {
                    return;
                }
                case 2: {
                    if (batteryCallback == null) return;
                    bl = message.arg1 != 0;
                }
            }
            batteryCallback.batteryPowerChanged(bl);
        }
    }

    public abstract class OverflowArrayMap<T> {
        private static final String OVERFLOW_NAME = "*overflow*";
        ArrayMap<String, MutableInt> mActiveOverflow;
        T mCurOverflow;
        final ArrayMap<String, T> mMap = new ArrayMap();

        public void add(String string2, T t) {
            this.mMap.put(string2, t);
            if (OVERFLOW_NAME.equals(string2)) {
                this.mCurOverflow = t;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void cleanup() {
            if (this.mActiveOverflow != null && this.mActiveOverflow.size() == 0) {
                this.mActiveOverflow = null;
            }
            if (this.mActiveOverflow == null) {
                if (this.mMap.containsKey(OVERFLOW_NAME)) {
                    Slog.wtf(BatteryStatsImpl.TAG, "Cleaning up with no active overflow, but have overflow entry " + this.mMap.get(OVERFLOW_NAME));
                    this.mMap.remove(OVERFLOW_NAME);
                }
                this.mCurOverflow = null;
                return;
            } else {
                if (this.mCurOverflow != null && this.mMap.containsKey(OVERFLOW_NAME)) return;
                Slog.wtf(BatteryStatsImpl.TAG, "Cleaning up with active overflow, but no overflow entry: cur=" + this.mCurOverflow + " map=" + this.mMap.get(OVERFLOW_NAME));
                return;
            }
        }

        public void clear() {
            this.mMap.clear();
            this.mCurOverflow = null;
            this.mActiveOverflow = null;
        }

        public ArrayMap<String, T> getMap() {
            return this.mMap;
        }

        public abstract T instantiateObject();

        public T startObject(String string2) {
            MutableInt mutableInt;
            T t = this.mMap.get(string2);
            if (t != null) {
                return t;
            }
            if (this.mActiveOverflow != null && (mutableInt = this.mActiveOverflow.get(string2)) != null) {
                T t2 = this.mCurOverflow;
                if (t2 == null) {
                    Slog.wtf(BatteryStatsImpl.TAG, "Have active overflow " + string2 + " but null overflow");
                    this.mCurOverflow = t2 = this.instantiateObject();
                    this.mMap.put(OVERFLOW_NAME, t2);
                }
                mutableInt.value = 1 + mutableInt.value;
                return t2;
            }
            if (this.mMap.size() >= 100) {
                T t3 = this.mCurOverflow;
                if (t3 == null) {
                    this.mCurOverflow = t3 = this.instantiateObject();
                    this.mMap.put(OVERFLOW_NAME, t3);
                }
                if (this.mActiveOverflow == null) {
                    this.mActiveOverflow = new ArrayMap();
                }
                this.mActiveOverflow.put(string2, new MutableInt(1));
                return t3;
            }
            T t4 = this.instantiateObject();
            this.mMap.put(string2, t4);
            return t4;
        }

        public T stopObject(String string2) {
            T t;
            MutableInt mutableInt;
            T t2 = this.mMap.get(string2);
            if (t2 != null) {
                return t2;
            }
            if (this.mActiveOverflow != null && (mutableInt = this.mActiveOverflow.get(string2)) != null && (t = this.mCurOverflow) != null) {
                mutableInt.value = -1 + mutableInt.value;
                if (mutableInt.value <= 0) {
                    this.mActiveOverflow.remove(string2);
                }
                return t;
            }
            Slog.wtf(BatteryStatsImpl.TAG, "Unable to find object for " + string2 + " mapsize=" + this.mMap.size() + " activeoverflow=" + this.mActiveOverflow + " curoverflow=" + this.mCurOverflow);
            return null;
        }
    }

    public static class SamplingCounter
    extends Counter {
        SamplingCounter(TimeBase timeBase) {
            super(timeBase);
        }

        SamplingCounter(TimeBase timeBase, Parcel parcel) {
            super(timeBase, parcel);
        }

        public void addCountAtomic(long l) {
            this.mCount.addAndGet((int)l);
        }
    }

    public static final class SamplingTimer
    extends Timer {
        int mCurrentReportedCount;
        long mCurrentReportedTotalTime;
        boolean mTimeBaseRunning;
        boolean mTrackingReportedValues;
        int mUnpluggedReportedCount;
        long mUnpluggedReportedTotalTime;
        int mUpdateVersion;

        /*
         * Enabled aggressive block sorting
         */
        SamplingTimer(TimeBase timeBase, Parcel parcel) {
            int n = 1;
            super(0, timeBase, parcel);
            this.mCurrentReportedCount = parcel.readInt();
            this.mUnpluggedReportedCount = parcel.readInt();
            this.mCurrentReportedTotalTime = parcel.readLong();
            this.mUnpluggedReportedTotalTime = parcel.readLong();
            if (parcel.readInt() != n) {
                n = 0;
            }
            this.mTrackingReportedValues = n;
            this.mTimeBaseRunning = timeBase.isRunning();
        }

        SamplingTimer(TimeBase timeBase, boolean bl) {
            super(0, timeBase);
            this.mTrackingReportedValues = bl;
            this.mTimeBaseRunning = timeBase.isRunning();
        }

        public void addCurrentReportedCount(int n) {
            this.updateCurrentReportedCount(n + this.mCurrentReportedCount);
        }

        public void addCurrentReportedTotalTime(long l) {
            this.updateCurrentReportedTotalTime(l + this.mCurrentReportedTotalTime);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected int computeCurrentCountLocked() {
            int n;
            int n2 = this.mCount;
            if (this.mTimeBaseRunning && this.mTrackingReportedValues) {
                n = this.mCurrentReportedCount - this.mUnpluggedReportedCount;
                return n + n2;
            }
            n = 0;
            return n + n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected long computeRunTimeLocked(long l) {
            long l2;
            long l3 = this.mTotalTime;
            if (this.mTimeBaseRunning && this.mTrackingReportedValues) {
                l2 = this.mCurrentReportedTotalTime - this.mUnpluggedReportedTotalTime;
                return l2 + l3;
            }
            l2 = 0L;
            return l2 + l3;
        }

        public int getUpdateVersion() {
            return this.mUpdateVersion;
        }

        @Override
        public void logState(Printer printer, String string2) {
            super.logState(printer, string2);
            printer.println(string2 + "mCurrentReportedCount=" + this.mCurrentReportedCount + " mUnpluggedReportedCount=" + this.mUnpluggedReportedCount + " mCurrentReportedTotalTime=" + this.mCurrentReportedTotalTime + " mUnpluggedReportedTotalTime=" + this.mUnpluggedReportedTotalTime);
        }

        @Override
        public void onTimeStarted(long l, long l2, long l3) {
            super.onTimeStarted(l, l2, l3);
            if (this.mTrackingReportedValues) {
                this.mUnpluggedReportedTotalTime = this.mCurrentReportedTotalTime;
                this.mUnpluggedReportedCount = this.mCurrentReportedCount;
            }
            this.mTimeBaseRunning = true;
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            super.onTimeStopped(l, l2, l3);
            this.mTimeBaseRunning = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void readSummaryFromParcelLocked(Parcel parcel) {
            int n;
            long l;
            int n2 = 1;
            super.readSummaryFromParcelLocked(parcel);
            this.mCurrentReportedTotalTime = l = parcel.readLong();
            this.mUnpluggedReportedTotalTime = l;
            this.mCurrentReportedCount = n = parcel.readInt();
            this.mUnpluggedReportedCount = n;
            if (parcel.readInt() != n2) {
                n2 = 0;
            }
            this.mTrackingReportedValues = n2;
        }

        @Override
        boolean reset(boolean bl) {
            super.reset(bl);
            this.setStale();
            return true;
        }

        public void setStale() {
            this.mTrackingReportedValues = false;
            this.mUnpluggedReportedTotalTime = 0L;
            this.mUnpluggedReportedCount = 0;
        }

        public void setUpdateVersion(int n) {
            this.mUpdateVersion = n;
        }

        public void updateCurrentReportedCount(int n) {
            if (this.mTimeBaseRunning && this.mUnpluggedReportedCount == 0) {
                this.mUnpluggedReportedCount = n;
                this.mTrackingReportedValues = true;
            }
            this.mCurrentReportedCount = n;
        }

        public void updateCurrentReportedTotalTime(long l) {
            if (this.mTimeBaseRunning && this.mUnpluggedReportedTotalTime == 0L) {
                this.mUnpluggedReportedTotalTime = l;
                this.mTrackingReportedValues = true;
            }
            this.mCurrentReportedTotalTime = l;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void writeSummaryFromParcelLocked(Parcel parcel, long l) {
            super.writeSummaryFromParcelLocked(parcel, l);
            parcel.writeLong(this.mCurrentReportedTotalTime);
            parcel.writeInt(this.mCurrentReportedCount);
            int n = this.mTrackingReportedValues ? 1 : 0;
            parcel.writeInt(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, long l) {
            super.writeToParcel(parcel, l);
            parcel.writeInt(this.mCurrentReportedCount);
            parcel.writeInt(this.mUnpluggedReportedCount);
            parcel.writeLong(this.mCurrentReportedTotalTime);
            parcel.writeLong(this.mUnpluggedReportedTotalTime);
            int n = this.mTrackingReportedValues ? 1 : 0;
            parcel.writeInt(n);
        }
    }

    public static final class StopwatchTimer
    extends Timer {
        long mAcquireTime;
        boolean mInList;
        int mNesting;
        long mTimeout;
        final ArrayList<StopwatchTimer> mTimerPool;
        final Uid mUid;
        long mUpdateTime;

        StopwatchTimer(Uid uid, int n, ArrayList<StopwatchTimer> arrayList, TimeBase timeBase) {
            super(n, timeBase);
            this.mUid = uid;
            this.mTimerPool = arrayList;
        }

        StopwatchTimer(Uid uid, int n, ArrayList<StopwatchTimer> arrayList, TimeBase timeBase, Parcel parcel) {
            super(n, timeBase, parcel);
            this.mUid = uid;
            this.mTimerPool = arrayList;
            this.mUpdateTime = parcel.readLong();
        }

        private static long refreshTimersLocked(long l, ArrayList<StopwatchTimer> arrayList, StopwatchTimer stopwatchTimer) {
            long l2 = 0L;
            int n = arrayList.size();
            for (int i = n - 1; i >= 0; --i) {
                StopwatchTimer stopwatchTimer2 = arrayList.get(i);
                long l3 = l - stopwatchTimer2.mUpdateTime;
                if (l3 > 0L) {
                    long l4 = l3 / (long)n;
                    if (stopwatchTimer2 == stopwatchTimer) {
                        l2 = l4;
                    }
                    stopwatchTimer2.mTotalTime = l4 + stopwatchTimer2.mTotalTime;
                }
                stopwatchTimer2.mUpdateTime = l;
            }
            return l2;
        }

        long checkpointRunningLocked(long l) {
            if (this.mNesting > 0) {
                long l2 = this.mTimeBase.getRealtime(1000L * l);
                if (this.mTimerPool != null) {
                    return StopwatchTimer.refreshTimersLocked(l2, this.mTimerPool, this);
                }
                long l3 = l2 - this.mUpdateTime;
                this.mUpdateTime = l2;
                this.mTotalTime = l3 + this.mTotalTime;
                return l3;
            }
            return 0L;
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected long computeRunTimeLocked(long l) {
            long l2 = 0L;
            if (this.mTimeout > l2 && l > this.mUpdateTime + this.mTimeout) {
                l = this.mUpdateTime + this.mTimeout;
            }
            long l3 = this.mTotalTime;
            if (this.mNesting > 0) {
                long l4 = l - this.mUpdateTime;
                int n = this.mTimerPool != null ? this.mTimerPool.size() : 1;
                l2 = l4 / (long)n;
            }
            return l2 + l3;
        }

        @Override
        void detach() {
            super.detach();
            if (this.mTimerPool != null) {
                this.mTimerPool.remove(this);
            }
        }

        boolean isRunningLocked() {
            return this.mNesting > 0;
        }

        @Override
        public void logState(Printer printer, String string2) {
            super.logState(printer, string2);
            printer.println(string2 + "mNesting=" + this.mNesting + " mUpdateTime=" + this.mUpdateTime + " mAcquireTime=" + this.mAcquireTime);
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            if (this.mNesting > 0) {
                super.onTimeStopped(l, l2, l3);
                this.mUpdateTime = l3;
            }
        }

        @Override
        void readSummaryFromParcelLocked(Parcel parcel) {
            super.readSummaryFromParcelLocked(parcel);
            this.mNesting = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        boolean reset(boolean bl) {
            boolean bl2 = true;
            boolean bl3 = this.mNesting <= 0 ? bl2 : false;
            if (!bl3 || !bl) {
                bl2 = false;
            }
            super.reset(bl2);
            if (this.mNesting > 0) {
                this.mUpdateTime = this.mTimeBase.getRealtime(1000L * SystemClock.elapsedRealtime());
            }
            this.mAcquireTime = this.mTotalTime;
            return bl3;
        }

        void setTimeout(long l) {
            this.mTimeout = l;
        }

        void startRunningLocked(long l) {
            int n = this.mNesting;
            this.mNesting = n + 1;
            if (n == 0) {
                long l2;
                this.mUpdateTime = l2 = this.mTimeBase.getRealtime(1000L * l);
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(l2, this.mTimerPool, null);
                    this.mTimerPool.add(this);
                }
                this.mCount = 1 + this.mCount;
                this.mAcquireTime = this.mTotalTime;
            }
        }

        void stopAllRunningLocked(long l) {
            if (this.mNesting > 0) {
                this.mNesting = 1;
                this.stopRunningLocked(l);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void stopRunningLocked(long l) {
            block6: {
                block5: {
                    int n;
                    if (this.mNesting == 0) break block5;
                    this.mNesting = n = -1 + this.mNesting;
                    if (n != 0) break block5;
                    long l2 = this.mTimeBase.getRealtime(1000L * l);
                    if (this.mTimerPool != null) {
                        StopwatchTimer.refreshTimersLocked(l2, this.mTimerPool, null);
                        this.mTimerPool.remove(this);
                    } else {
                        this.mNesting = 1;
                        this.mTotalTime = this.computeRunTimeLocked(l2);
                        this.mNesting = 0;
                    }
                    if (this.mTotalTime == this.mAcquireTime) break block6;
                }
                return;
            }
            this.mCount = -1 + this.mCount;
        }

        /*
         * Enabled aggressive block sorting
         */
        void stopRunningLocked(long l, boolean bl) {
            block7: {
                block6: {
                    int n;
                    if (this.mNesting == 0) break block6;
                    this.mNesting = n = -1 + this.mNesting;
                    if (n != 0) break block6;
                    long l2 = this.mTimeBase.getRealtime(1000L * l);
                    if (this.mTimerPool != null) {
                        StopwatchTimer.refreshTimersLocked(l2, this.mTimerPool, null);
                        this.mTimerPool.remove(this);
                    } else {
                        this.mNesting = 1;
                        this.mTotalTime = this.computeRunTimeLocked(l2);
                        this.mNesting = 0;
                    }
                    if (!bl) {
                        this.mBackgroundTime += this.mTotalTime - this.mAcquireTime;
                    }
                    if (this.mTotalTime == this.mAcquireTime) break block7;
                }
                return;
            }
            this.mCount = -1 + this.mCount;
        }

        @Override
        public void writeToParcel(Parcel parcel, long l) {
            super.writeToParcel(parcel, l);
            parcel.writeLong(this.mUpdateTime);
        }
    }

    static class TimeBase {
        private final ArrayList<TimeBaseObs> mObservers = new ArrayList();
        private long mPastRealtime;
        private long mPastUptime;
        private long mRealtime;
        private long mRealtimeStart;
        private boolean mRunning;
        private long mUnpluggedRealtime;
        private long mUnpluggedUptime;
        private long mUptime;
        private long mUptimeStart;

        TimeBase() {
        }

        public void add(TimeBaseObs timeBaseObs) {
            this.mObservers.add(timeBaseObs);
        }

        public long computeRealtime(long l, int n) {
            switch (n) {
                default: {
                    return 0L;
                }
                case 0: {
                    return this.mRealtime + this.getRealtime(l);
                }
                case 1: {
                    return this.getRealtime(l);
                }
                case 2: 
            }
            return this.getRealtime(l) - this.mUnpluggedRealtime;
        }

        public long computeUptime(long l, int n) {
            switch (n) {
                default: {
                    return 0L;
                }
                case 0: {
                    return this.mUptime + this.getUptime(l);
                }
                case 1: {
                    return this.getUptime(l);
                }
                case 2: 
            }
            return this.getUptime(l) - this.mUnpluggedUptime;
        }

        public void dump(PrintWriter printWriter, String string2) {
            StringBuilder stringBuilder = new StringBuilder(128);
            printWriter.print(string2);
            printWriter.print("mRunning=");
            printWriter.println(this.mRunning);
            stringBuilder.setLength(0);
            stringBuilder.append(string2);
            stringBuilder.append("mUptime=");
            BatteryStats.formatTimeMs(stringBuilder, this.mUptime / 1000L);
            printWriter.println(stringBuilder.toString());
            stringBuilder.setLength(0);
            stringBuilder.append(string2);
            stringBuilder.append("mRealtime=");
            BatteryStats.formatTimeMs(stringBuilder, this.mRealtime / 1000L);
            printWriter.println(stringBuilder.toString());
            stringBuilder.setLength(0);
            stringBuilder.append(string2);
            stringBuilder.append("mPastUptime=");
            BatteryStats.formatTimeMs(stringBuilder, this.mPastUptime / 1000L);
            stringBuilder.append("mUptimeStart=");
            BatteryStats.formatTimeMs(stringBuilder, this.mUptimeStart / 1000L);
            stringBuilder.append("mUnpluggedUptime=");
            BatteryStats.formatTimeMs(stringBuilder, this.mUnpluggedUptime / 1000L);
            printWriter.println(stringBuilder.toString());
            stringBuilder.setLength(0);
            stringBuilder.append(string2);
            stringBuilder.append("mPastRealtime=");
            BatteryStats.formatTimeMs(stringBuilder, this.mPastRealtime / 1000L);
            stringBuilder.append("mRealtimeStart=");
            BatteryStats.formatTimeMs(stringBuilder, this.mRealtimeStart / 1000L);
            stringBuilder.append("mUnpluggedRealtime=");
            BatteryStats.formatTimeMs(stringBuilder, this.mUnpluggedRealtime / 1000L);
            printWriter.println(stringBuilder.toString());
        }

        public long getRealtime(long l) {
            long l2 = this.mPastRealtime;
            if (this.mRunning) {
                l2 += l - this.mRealtimeStart;
            }
            return l2;
        }

        public long getRealtimeStart() {
            return this.mRealtimeStart;
        }

        public long getUptime(long l) {
            long l2 = this.mPastUptime;
            if (this.mRunning) {
                l2 += l - this.mUptimeStart;
            }
            return l2;
        }

        public long getUptimeStart() {
            return this.mUptimeStart;
        }

        public void init(long l, long l2) {
            this.mRealtime = 0L;
            this.mUptime = 0L;
            this.mPastUptime = 0L;
            this.mPastRealtime = 0L;
            this.mUptimeStart = l;
            this.mRealtimeStart = l2;
            this.mUnpluggedUptime = this.getUptime(this.mUptimeStart);
            this.mUnpluggedRealtime = this.getRealtime(this.mRealtimeStart);
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public void readFromParcel(Parcel parcel) {
            this.mRunning = false;
            this.mUptime = parcel.readLong();
            this.mPastUptime = parcel.readLong();
            this.mUptimeStart = parcel.readLong();
            this.mRealtime = parcel.readLong();
            this.mPastRealtime = parcel.readLong();
            this.mRealtimeStart = parcel.readLong();
            this.mUnpluggedUptime = parcel.readLong();
            this.mUnpluggedRealtime = parcel.readLong();
        }

        public void readSummaryFromParcel(Parcel parcel) {
            this.mUptime = parcel.readLong();
            this.mRealtime = parcel.readLong();
        }

        public void remove(TimeBaseObs timeBaseObs) {
            if (!this.mObservers.remove(timeBaseObs)) {
                Slog.wtf(BatteryStatsImpl.TAG, "Removed unknown observer: " + timeBaseObs);
            }
        }

        public void reset(long l, long l2) {
            if (!this.mRunning) {
                this.mPastUptime = 0L;
                this.mPastRealtime = 0L;
                return;
            }
            this.mUptimeStart = l;
            this.mRealtimeStart = l2;
            this.mUnpluggedUptime = this.getUptime(l);
            this.mUnpluggedRealtime = this.getRealtime(l2);
        }

        public boolean setRunning(boolean bl, long l, long l2) {
            if (this.mRunning != bl) {
                this.mRunning = bl;
                if (bl) {
                    long l3;
                    long l4;
                    this.mUptimeStart = l;
                    this.mRealtimeStart = l2;
                    this.mUnpluggedUptime = l4 = this.getUptime(l);
                    this.mUnpluggedRealtime = l3 = this.getRealtime(l2);
                    for (int i = -1 + this.mObservers.size(); i >= 0; --i) {
                        this.mObservers.get(i).onTimeStarted(l2, l4, l3);
                    }
                } else {
                    this.mPastUptime += l - this.mUptimeStart;
                    this.mPastRealtime += l2 - this.mRealtimeStart;
                    long l5 = this.getUptime(l);
                    long l6 = this.getRealtime(l2);
                    for (int i = -1 + this.mObservers.size(); i >= 0; --i) {
                        this.mObservers.get(i).onTimeStopped(l2, l5, l6);
                    }
                }
                return true;
            }
            return false;
        }

        public void writeSummaryToParcel(Parcel parcel, long l, long l2) {
            parcel.writeLong(this.computeUptime(l, 0));
            parcel.writeLong(this.computeRealtime(l2, 0));
        }

        public void writeToParcel(Parcel parcel, long l, long l2) {
            long l3 = this.getUptime(l);
            long l4 = this.getRealtime(l2);
            parcel.writeLong(this.mUptime);
            parcel.writeLong(l3);
            parcel.writeLong(this.mUptimeStart);
            parcel.writeLong(this.mRealtime);
            parcel.writeLong(l4);
            parcel.writeLong(this.mRealtimeStart);
            parcel.writeLong(this.mUnpluggedUptime);
            parcel.writeLong(this.mUnpluggedRealtime);
        }
    }

    public static interface TimeBaseObs {
        public void onTimeStarted(long var1, long var3, long var5);

        public void onTimeStopped(long var1, long var3, long var5);
    }

    public static abstract class Timer
    extends BatteryStats.Timer
    implements TimeBaseObs {
        long mBackgroundTime;
        int mCount;
        int mLastCount;
        long mLastTime;
        int mLoadedCount;
        long mLoadedTime;
        final TimeBase mTimeBase;
        long mTotalTime;
        final int mType;
        int mUnpluggedCount;
        long mUnpluggedTime;

        Timer(int n, TimeBase timeBase) {
            this.mType = n;
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        Timer(int n, TimeBase timeBase, Parcel parcel) {
            this.mType = n;
            this.mTimeBase = timeBase;
            this.mCount = parcel.readInt();
            this.mLoadedCount = parcel.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = parcel.readInt();
            this.mTotalTime = parcel.readLong();
            this.mLoadedTime = parcel.readLong();
            this.mLastTime = 0L;
            this.mUnpluggedTime = parcel.readLong();
            this.mBackgroundTime = parcel.readLong();
            timeBase.add(this);
        }

        public static void writeTimerToParcel(Parcel parcel, Timer timer, long l) {
            if (timer == null) {
                parcel.writeInt(0);
                return;
            }
            parcel.writeInt(1);
            timer.writeToParcel(parcel, l);
        }

        protected abstract int computeCurrentCountLocked();

        protected abstract long computeRunTimeLocked(long var1);

        void detach() {
            this.mTimeBase.remove(this);
        }

        @Override
        public long getBackgroundTimeLocked() {
            return this.mBackgroundTime;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int getCountLocked(int n) {
            int n2 = this.computeCurrentCountLocked();
            if (n == 2) {
                n2 -= this.mUnpluggedCount;
                return n2;
            } else {
                if (n == 0) return n2;
                return n2 - this.mLoadedCount;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public long getTotalTimeLocked(long l, int n) {
            long l2 = this.computeRunTimeLocked(this.mTimeBase.getRealtime(l));
            if (n == 2) {
                l2 -= this.mUnpluggedTime;
                return l2;
            } else {
                if (n == 0) return l2;
                return l2 - this.mLoadedTime;
            }
        }

        @Override
        public void logState(Printer printer, String string2) {
            printer.println(string2 + "mCount=" + this.mCount + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount);
            printer.println(string2 + "mTotalTime=" + this.mTotalTime + " mLoadedTime=" + this.mLoadedTime);
            printer.println(string2 + "mLastTime=" + this.mLastTime + " mUnpluggedTime=" + this.mUnpluggedTime);
        }

        @Override
        public void onTimeStarted(long l, long l2, long l3) {
            this.mUnpluggedTime = this.computeRunTimeLocked(l3);
            this.mUnpluggedCount = this.mCount;
        }

        @Override
        public void onTimeStopped(long l, long l2, long l3) {
            this.mTotalTime = this.computeRunTimeLocked(l3);
            this.mCount = this.computeCurrentCountLocked();
        }

        void readSummaryFromParcelLocked(Parcel parcel) {
            int n;
            long l;
            this.mLoadedTime = l = parcel.readLong();
            this.mTotalTime = l;
            this.mLastTime = 0L;
            this.mUnpluggedTime = this.mTotalTime;
            this.mBackgroundTime = 1000L * parcel.readLong();
            this.mLoadedCount = n = parcel.readInt();
            this.mCount = n;
            this.mLastCount = 0;
            this.mUnpluggedCount = this.mCount;
        }

        boolean reset(boolean bl) {
            this.mLastTime = 0L;
            this.mLoadedTime = 0L;
            this.mTotalTime = 0L;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            this.mCount = 0;
            this.mBackgroundTime = 0L;
            if (bl) {
                this.detach();
            }
            return true;
        }

        void writeSummaryFromParcelLocked(Parcel parcel, long l) {
            parcel.writeLong(this.computeRunTimeLocked(this.mTimeBase.getRealtime(l)));
            parcel.writeLong(this.mBackgroundTime / 1000L);
            parcel.writeInt(this.mCount);
        }

        public void writeToParcel(Parcel parcel, long l) {
            parcel.writeInt(this.mCount);
            parcel.writeInt(this.mLoadedCount);
            parcel.writeInt(this.mUnpluggedCount);
            parcel.writeLong(this.computeRunTimeLocked(this.mTimeBase.getRealtime(l)));
            parcel.writeLong(this.mLoadedTime);
            parcel.writeLong(this.mUnpluggedTime);
            parcel.writeLong(this.mBackgroundTime);
        }
    }

    public final class Uid
    extends BatteryStats.Uid {
        static final int NO_BATCHED_SCAN_STARTED = -1;
        static final int PROCESS_STATE_NONE = 3;
        StopwatchTimer mAudioTurnedOnTimer;
        StopwatchTimer mForegroundActivityTimer;
        boolean mFullWifiLockOut;
        StopwatchTimer mFullWifiLockTimer;
        final OverflowArrayMap<StopwatchTimer> mJobStats;
        LongSamplingCounter mMobileRadioActiveCount;
        LongSamplingCounter mMobileRadioActiveTime;
        LongSamplingCounter[] mNetworkByteActivityCounters;
        LongSamplingCounter[] mNetworkPacketActivityCounters;
        final ArrayMap<String, Pkg> mPackageStats;
        final SparseArray<BatteryStats.Uid.Pid> mPids;
        int mProcessState = 3;
        StopwatchTimer[] mProcessStateTimer;
        final ArrayMap<String, Proc> mProcessStats;
        final SparseArray<Sensor> mSensorStats;
        final OverflowArrayMap<StopwatchTimer> mSyncStats;
        final int mUid;
        Counter[] mUserActivityCounters;
        BatchTimer mVibratorOnTimer;
        StopwatchTimer mVideoTurnedOnTimer;
        final OverflowArrayMap<Wakelock> mWakelockStats = new OverflowArrayMap<Wakelock>(){

            @Override
            public Wakelock instantiateObject() {
                return new Wakelock();
            }
        };
        int mWifiBatchedScanBinStarted = -1;
        StopwatchTimer[] mWifiBatchedScanTimer;
        boolean mWifiMulticastEnabled;
        StopwatchTimer mWifiMulticastTimer;
        boolean mWifiRunning;
        StopwatchTimer mWifiRunningTimer;
        boolean mWifiScanStarted;
        StopwatchTimer mWifiScanTimer;

        public Uid(int n) {
            this.mSyncStats = new OverflowArrayMap<StopwatchTimer>(){

                @Override
                public StopwatchTimer instantiateObject() {
                    return new StopwatchTimer(Uid.this, 13, null, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
            };
            this.mJobStats = new OverflowArrayMap<StopwatchTimer>(){

                @Override
                public StopwatchTimer instantiateObject() {
                    return new StopwatchTimer(Uid.this, 14, null, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
            };
            this.mSensorStats = new SparseArray();
            this.mProcessStats = new ArrayMap();
            this.mPackageStats = new ArrayMap();
            this.mPids = new SparseArray();
            this.mUid = n;
            this.mWifiRunningTimer = new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mFullWifiLockTimer = new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mWifiScanTimer = new StopwatchTimer(this, 6, BatteryStatsImpl.this.mWifiScanTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mWifiBatchedScanTimer = new StopwatchTimer[5];
            this.mWifiMulticastTimer = new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mProcessStateTimer = new StopwatchTimer[3];
        }

        public StopwatchTimer createAudioTurnedOnTimerLocked() {
            if (this.mAudioTurnedOnTimer == null) {
                this.mAudioTurnedOnTimer = new StopwatchTimer(this, 7, BatteryStatsImpl.this.mAudioTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            return this.mAudioTurnedOnTimer;
        }

        public StopwatchTimer createForegroundActivityTimerLocked() {
            if (this.mForegroundActivityTimer == null) {
                this.mForegroundActivityTimer = new StopwatchTimer(this, 10, null, BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            return this.mForegroundActivityTimer;
        }

        public BatchTimer createVibratorOnTimerLocked() {
            if (this.mVibratorOnTimer == null) {
                this.mVibratorOnTimer = new BatchTimer(this, 9, BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            return this.mVibratorOnTimer;
        }

        public StopwatchTimer createVideoTurnedOnTimerLocked() {
            if (this.mVideoTurnedOnTimer == null) {
                this.mVideoTurnedOnTimer = new StopwatchTimer(this, 8, BatteryStatsImpl.this.mVideoTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            return this.mVideoTurnedOnTimer;
        }

        @Override
        public long getAudioTurnedOnTime(long l, int n) {
            if (this.mAudioTurnedOnTimer == null) {
                return 0L;
            }
            return this.mAudioTurnedOnTimer.getTotalTimeLocked(l, n);
        }

        public BatteryStatsImpl getBatteryStats() {
            return BatteryStatsImpl.this;
        }

        @Override
        public Timer getForegroundActivityTimer() {
            return this.mForegroundActivityTimer;
        }

        @Override
        public long getFullWifiLockTime(long l, int n) {
            if (this.mFullWifiLockTimer == null) {
                return 0L;
            }
            return this.mFullWifiLockTimer.getTotalTimeLocked(l, n);
        }

        @Override
        public Map<String, ? extends BatteryStats.Timer> getJobStats() {
            return this.mJobStats.getMap();
        }

        @Override
        public int getMobileRadioActiveCount(int n) {
            if (this.mMobileRadioActiveCount != null) {
                return (int)this.mMobileRadioActiveCount.getCountLocked(n);
            }
            return 0;
        }

        @Override
        public long getMobileRadioActiveTime(int n) {
            if (this.mMobileRadioActiveTime != null) {
                return this.mMobileRadioActiveTime.getCountLocked(n);
            }
            return 0L;
        }

        @Override
        public long getNetworkActivityBytes(int n, int n2) {
            if (this.mNetworkByteActivityCounters != null && n >= 0 && n < this.mNetworkByteActivityCounters.length) {
                return this.mNetworkByteActivityCounters[n].getCountLocked(n2);
            }
            return 0L;
        }

        @Override
        public long getNetworkActivityPackets(int n, int n2) {
            if (this.mNetworkPacketActivityCounters != null && n >= 0 && n < this.mNetworkPacketActivityCounters.length) {
                return this.mNetworkPacketActivityCounters[n].getCountLocked(n2);
            }
            return 0L;
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Pkg> getPackageStats() {
            return this.mPackageStats;
        }

        public Pkg getPackageStatsLocked(String string2) {
            Pkg pkg = this.mPackageStats.get(string2);
            if (pkg == null) {
                pkg = new Pkg();
                this.mPackageStats.put(string2, pkg);
            }
            return pkg;
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Pid> getPidStats() {
            return this.mPids;
        }

        public BatteryStats.Uid.Pid getPidStatsLocked(int n) {
            BatteryStats.Uid.Pid pid = this.mPids.get(n);
            if (pid == null) {
                pid = new BatteryStats.Uid.Pid(this);
                this.mPids.put(n, pid);
            }
            return pid;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public long getProcessStateTime(int n, long l, int n2) {
            if (n < 0 || n >= 3 || this.mProcessStateTimer[n] == null) {
                return 0L;
            }
            return this.mProcessStateTimer[n].getTotalTimeLocked(l, n2);
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Proc> getProcessStats() {
            return this.mProcessStats;
        }

        public Proc getProcessStatsLocked(String string2) {
            Proc proc = this.mProcessStats.get(string2);
            if (proc == null) {
                proc = new Proc(string2);
                this.mProcessStats.put(string2, proc);
            }
            return proc;
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Sensor> getSensorStats() {
            return this.mSensorStats;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public StopwatchTimer getSensorTimerLocked(int n, boolean bl) {
            void var5_7;
            StopwatchTimer stopwatchTimer;
            StopwatchTimer stopwatchTimer2;
            Sensor sensor = this.mSensorStats.get(n);
            if (sensor == null) {
                if (!bl) {
                    return null;
                }
                sensor = new Sensor(n);
                this.mSensorStats.put(n, sensor);
            }
            if ((stopwatchTimer2 = sensor.mTimer) != null) return stopwatchTimer2;
            ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mSensorTimers.get(n);
            if (arrayList == null) {
                ArrayList arrayList2 = new ArrayList();
                BatteryStatsImpl.this.mSensorTimers.put(n, arrayList2);
            }
            sensor.mTimer = stopwatchTimer = new StopwatchTimer(this, 3, (ArrayList<StopwatchTimer>)var5_7, BatteryStatsImpl.this.mOnBatteryTimeBase);
            return stopwatchTimer;
        }

        public Pkg.Serv getServiceStatsLocked(String string2, String string3) {
            Pkg pkg = this.getPackageStatsLocked(string2);
            Pkg.Serv serv = pkg.mServiceStats.get(string3);
            if (serv == null) {
                serv = pkg.newServiceStatsLocked();
                pkg.mServiceStats.put(string3, serv);
            }
            return serv;
        }

        @Override
        public Map<String, ? extends BatteryStats.Timer> getSyncStats() {
            return this.mSyncStats.getMap();
        }

        @Override
        public int getUid() {
            return this.mUid;
        }

        @Override
        public int getUserActivityCount(int n, int n2) {
            if (this.mUserActivityCounters == null) {
                return 0;
            }
            return this.mUserActivityCounters[n].getCountLocked(n2);
        }

        @Override
        public Timer getVibratorOnTimer() {
            return this.mVibratorOnTimer;
        }

        @Override
        public long getVideoTurnedOnTime(long l, int n) {
            if (this.mVideoTurnedOnTimer == null) {
                return 0L;
            }
            return this.mVideoTurnedOnTimer.getTotalTimeLocked(l, n);
        }

        @Override
        public Map<String, ? extends BatteryStats.Uid.Wakelock> getWakelockStats() {
            return this.mWakelockStats.getMap();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public long getWifiBatchedScanTime(int n, long l, int n2) {
            if (n < 0 || n >= 5 || this.mWifiBatchedScanTimer[n] == null) {
                return 0L;
            }
            return this.mWifiBatchedScanTimer[n].getTotalTimeLocked(l, n2);
        }

        @Override
        public long getWifiMulticastTime(long l, int n) {
            if (this.mWifiMulticastTimer == null) {
                return 0L;
            }
            return this.mWifiMulticastTimer.getTotalTimeLocked(l, n);
        }

        @Override
        public long getWifiRunningTime(long l, int n) {
            if (this.mWifiRunningTimer == null) {
                return 0L;
            }
            return this.mWifiRunningTimer.getTotalTimeLocked(l, n);
        }

        @Override
        public long getWifiScanTime(long l, int n) {
            if (this.mWifiScanTimer == null) {
                return 0L;
            }
            return this.mWifiScanTimer.getTotalTimeLocked(l, n);
        }

        @Override
        public boolean hasNetworkActivity() {
            return this.mNetworkByteActivityCounters != null;
        }

        @Override
        public boolean hasUserActivity() {
            return this.mUserActivityCounters != null;
        }

        void initNetworkActivityLocked() {
            this.mNetworkByteActivityCounters = new LongSamplingCounter[4];
            this.mNetworkPacketActivityCounters = new LongSamplingCounter[4];
            for (int i = 0; i < 4; ++i) {
                this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
                this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            this.mMobileRadioActiveTime = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mMobileRadioActiveCount = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
        }

        void initUserActivityLocked() {
            this.mUserActivityCounters = new Counter[3];
            for (int i = 0; i < 3; ++i) {
                this.mUserActivityCounters[i] = new Counter(BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
        }

        void makeProcessState(int n, Parcel parcel) {
            if (n < 0 || n >= 3) {
                return;
            }
            if (parcel == null) {
                this.mProcessStateTimer[n] = new StopwatchTimer(this, 12, null, BatteryStatsImpl.this.mOnBatteryTimeBase);
                return;
            }
            this.mProcessStateTimer[n] = new StopwatchTimer(this, 12, null, BatteryStatsImpl.this.mOnBatteryTimeBase, parcel);
        }

        void makeWifiBatchedScanBin(int n, Parcel parcel) {
            if (n < 0 || n >= 5) {
                return;
            }
            ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mWifiBatchedScanTimers.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList();
                BatteryStatsImpl.this.mWifiBatchedScanTimers.put(n, arrayList);
            }
            if (parcel == null) {
                this.mWifiBatchedScanTimer[n] = new StopwatchTimer(this, 11, arrayList, BatteryStatsImpl.this.mOnBatteryTimeBase);
                return;
            }
            this.mWifiBatchedScanTimer[n] = new StopwatchTimer(this, 11, arrayList, BatteryStatsImpl.this.mOnBatteryTimeBase, parcel);
        }

        @Override
        public void noteActivityPausedLocked(long l) {
            if (this.mForegroundActivityTimer != null) {
                this.mForegroundActivityTimer.stopRunningLocked(l);
            }
        }

        @Override
        public void noteActivityResumedLocked(long l) {
            this.createForegroundActivityTimerLocked().startRunningLocked(l);
        }

        public void noteAudioTurnedOffLocked(long l) {
            if (this.mAudioTurnedOnTimer != null) {
                this.mAudioTurnedOnTimer.stopRunningLocked(l);
            }
        }

        public void noteAudioTurnedOnLocked(long l) {
            this.createAudioTurnedOnTimerLocked().startRunningLocked(l);
        }

        @Override
        public void noteFullWifiLockAcquiredLocked(long l) {
            if (!this.mFullWifiLockOut) {
                this.mFullWifiLockOut = true;
                if (this.mFullWifiLockTimer == null) {
                    this.mFullWifiLockTimer = new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
                this.mFullWifiLockTimer.startRunningLocked(l);
            }
        }

        @Override
        public void noteFullWifiLockReleasedLocked(long l) {
            if (this.mFullWifiLockOut) {
                this.mFullWifiLockOut = false;
                this.mFullWifiLockTimer.stopRunningLocked(l);
            }
        }

        void noteMobileRadioActiveTimeLocked(long l) {
            if (this.mNetworkByteActivityCounters == null) {
                this.initNetworkActivityLocked();
            }
            this.mMobileRadioActiveTime.addCountLocked(l);
            this.mMobileRadioActiveCount.addCountLocked(1L);
        }

        void noteNetworkActivityLocked(int n, long l, long l2) {
            if (this.mNetworkByteActivityCounters == null) {
                this.initNetworkActivityLocked();
            }
            if (n >= 0 && n < 4) {
                this.mNetworkByteActivityCounters[n].addCountLocked(l);
                this.mNetworkPacketActivityCounters[n].addCountLocked(l2);
                return;
            }
            Slog.w(BatteryStatsImpl.TAG, "Unknown network activity type " + n + " was specified.", new Throwable());
        }

        public void noteResetAudioLocked(long l) {
            if (this.mAudioTurnedOnTimer != null) {
                this.mAudioTurnedOnTimer.stopAllRunningLocked(l);
            }
        }

        public void noteResetVideoLocked(long l) {
            if (this.mVideoTurnedOnTimer != null) {
                this.mVideoTurnedOnTimer.stopAllRunningLocked(l);
            }
        }

        public void noteStartGps(long l) {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(-10000, true);
            if (stopwatchTimer != null) {
                stopwatchTimer.startRunningLocked(l);
            }
        }

        public void noteStartJobLocked(String string2, long l) {
            StopwatchTimer stopwatchTimer = this.mJobStats.startObject(string2);
            if (stopwatchTimer != null) {
                stopwatchTimer.startRunningLocked(l);
            }
        }

        public void noteStartSensor(int n, long l) {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(n, true);
            if (stopwatchTimer != null) {
                stopwatchTimer.startRunningLocked(l);
            }
        }

        public void noteStartSyncLocked(String string2, long l) {
            StopwatchTimer stopwatchTimer = this.mSyncStats.startObject(string2);
            if (stopwatchTimer != null) {
                stopwatchTimer.startRunningLocked(l);
            }
        }

        public void noteStartWakeLocked(int n, String string2, int n2, long l) {
            Wakelock wakelock = this.mWakelockStats.startObject(string2);
            if (wakelock != null) {
                wakelock.getStopwatchTimer(n2).startRunningLocked(l);
            }
            if (n >= 0 && n2 == 0) {
                BatteryStats.Uid.Pid pid = this.getPidStatsLocked(n);
                int n3 = pid.mWakeNesting;
                pid.mWakeNesting = n3 + 1;
                if (n3 == 0) {
                    pid.mWakeStartMs = l;
                }
            }
        }

        public void noteStopGps(long l) {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(-10000, false);
            if (stopwatchTimer != null) {
                stopwatchTimer.stopRunningLocked(l);
            }
        }

        public void noteStopJobLocked(String string2, long l) {
            StopwatchTimer stopwatchTimer = this.mJobStats.stopObject(string2);
            if (stopwatchTimer != null) {
                stopwatchTimer.stopRunningLocked(l);
            }
        }

        public void noteStopSensor(int n, long l) {
            StopwatchTimer stopwatchTimer = this.getSensorTimerLocked(n, false);
            if (stopwatchTimer != null) {
                stopwatchTimer.stopRunningLocked(l);
            }
        }

        public void noteStopSyncLocked(String string2, long l) {
            StopwatchTimer stopwatchTimer = this.mSyncStats.stopObject(string2);
            if (stopwatchTimer != null) {
                stopwatchTimer.stopRunningLocked(l);
            }
        }

        public void noteStopWakeLocked(int n, String string2, int n2, long l) {
            BatteryStats.Uid.Pid pid;
            Wakelock wakelock = this.mWakelockStats.stopObject(string2);
            if (wakelock != null) {
                wakelock.getStopwatchTimer(n2).stopRunningLocked(l, false);
            }
            if (n >= 0 && n2 == 0 && (pid = this.mPids.get(n)) != null && pid.mWakeNesting > 0) {
                int n3 = pid.mWakeNesting;
                pid.mWakeNesting = n3 - 1;
                if (n3 == 1) {
                    pid.mWakeSumMs += l - pid.mWakeStartMs;
                    pid.mWakeStartMs = 0L;
                }
            }
        }

        @Override
        public void noteUserActivityLocked(int n) {
            if (this.mUserActivityCounters == null) {
                this.initUserActivityLocked();
            }
            if (n >= 0 && n < 3) {
                this.mUserActivityCounters[n].stepAtomic();
                return;
            }
            Slog.w(BatteryStatsImpl.TAG, "Unknown user activity type " + n + " was specified.", new Throwable());
        }

        public void noteVibratorOffLocked() {
            if (this.mVibratorOnTimer != null) {
                this.mVibratorOnTimer.abortLastDuration(BatteryStatsImpl.this);
            }
        }

        public void noteVibratorOnLocked(long l) {
            this.createVibratorOnTimerLocked().addDuration(BatteryStatsImpl.this, l);
        }

        public void noteVideoTurnedOffLocked(long l) {
            if (this.mVideoTurnedOnTimer != null) {
                this.mVideoTurnedOnTimer.stopRunningLocked(l);
            }
        }

        public void noteVideoTurnedOnLocked(long l) {
            this.createVideoTurnedOnTimerLocked().startRunningLocked(l);
        }

        @Override
        public void noteWifiBatchedScanStartedLocked(int n, long l) {
            int n2;
            for (n2 = 0; n > 8 && n2 < 5; n >>= 3, ++n2) {
            }
            if (this.mWifiBatchedScanBinStarted == n2) {
                return;
            }
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(l);
            }
            this.mWifiBatchedScanBinStarted = n2;
            if (this.mWifiBatchedScanTimer[n2] == null) {
                this.makeWifiBatchedScanBin(n2, null);
            }
            this.mWifiBatchedScanTimer[n2].startRunningLocked(l);
        }

        @Override
        public void noteWifiBatchedScanStoppedLocked(long l) {
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(l);
                this.mWifiBatchedScanBinStarted = -1;
            }
        }

        @Override
        public void noteWifiMulticastDisabledLocked(long l) {
            if (this.mWifiMulticastEnabled) {
                this.mWifiMulticastEnabled = false;
                this.mWifiMulticastTimer.stopRunningLocked(l);
            }
        }

        @Override
        public void noteWifiMulticastEnabledLocked(long l) {
            if (!this.mWifiMulticastEnabled) {
                this.mWifiMulticastEnabled = true;
                if (this.mWifiMulticastTimer == null) {
                    this.mWifiMulticastTimer = new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
                this.mWifiMulticastTimer.startRunningLocked(l);
            }
        }

        @Override
        public void noteWifiRunningLocked(long l) {
            if (!this.mWifiRunning) {
                this.mWifiRunning = true;
                if (this.mWifiRunningTimer == null) {
                    this.mWifiRunningTimer = new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
                this.mWifiRunningTimer.startRunningLocked(l);
            }
        }

        @Override
        public void noteWifiScanStartedLocked(long l) {
            if (!this.mWifiScanStarted) {
                this.mWifiScanStarted = true;
                if (this.mWifiScanTimer == null) {
                    this.mWifiScanTimer = new StopwatchTimer(this, 6, BatteryStatsImpl.this.mWifiScanTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
                this.mWifiScanTimer.startRunningLocked(l);
            }
        }

        @Override
        public void noteWifiScanStoppedLocked(long l) {
            if (this.mWifiScanStarted) {
                this.mWifiScanStarted = false;
                this.mWifiScanTimer.stopRunningLocked(l);
            }
        }

        @Override
        public void noteWifiStoppedLocked(long l) {
            if (this.mWifiRunning) {
                this.mWifiRunning = false;
                this.mWifiRunningTimer.stopRunningLocked(l);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void readFromParcelLocked(TimeBase timeBase, TimeBase timeBase2, Parcel parcel) {
            int n = parcel.readInt();
            this.mWakelockStats.clear();
            for (int i = 0; i < n; ++i) {
                String string2 = parcel.readString();
                Wakelock wakelock = new Wakelock();
                wakelock.readFromParcelLocked(timeBase, timeBase2, parcel);
                this.mWakelockStats.add(string2, wakelock);
            }
            int n2 = parcel.readInt();
            this.mSyncStats.clear();
            for (int i = 0; i < n2; ++i) {
                String string3 = parcel.readString();
                if (parcel.readInt() == 0) continue;
                this.mSyncStats.add(string3, new StopwatchTimer(this, 13, null, timeBase, parcel));
            }
            int n3 = parcel.readInt();
            this.mJobStats.clear();
            for (int i = 0; i < n3; ++i) {
                String string4 = parcel.readString();
                if (parcel.readInt() == 0) continue;
                this.mJobStats.add(string4, new StopwatchTimer(this, 14, null, timeBase, parcel));
            }
            int n4 = parcel.readInt();
            this.mSensorStats.clear();
            for (int i = 0; i < n4; ++i) {
                int n5 = parcel.readInt();
                Sensor sensor = new Sensor(n5);
                sensor.readFromParcelLocked(BatteryStatsImpl.this.mOnBatteryTimeBase, parcel);
                this.mSensorStats.put(n5, sensor);
            }
            int n6 = parcel.readInt();
            this.mProcessStats.clear();
            for (int i = 0; i < n6; ++i) {
                String string5 = parcel.readString();
                Proc proc = new Proc(string5);
                proc.readFromParcelLocked(parcel);
                this.mProcessStats.put(string5, proc);
            }
            int n7 = parcel.readInt();
            this.mPackageStats.clear();
            for (int i = 0; i < n7; ++i) {
                String string6 = parcel.readString();
                Pkg pkg = new Pkg();
                pkg.readFromParcelLocked(parcel);
                this.mPackageStats.put(string6, pkg);
            }
            this.mWifiRunning = false;
            this.mWifiRunningTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, parcel) : null;
            this.mFullWifiLockOut = false;
            this.mFullWifiLockTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, parcel) : null;
            this.mWifiScanStarted = false;
            this.mWifiScanTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 6, BatteryStatsImpl.this.mWifiScanTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, parcel) : null;
            this.mWifiBatchedScanBinStarted = -1;
            for (int i = 0; i < 5; ++i) {
                if (parcel.readInt() != 0) {
                    this.makeWifiBatchedScanBin(i, parcel);
                    continue;
                }
                this.mWifiBatchedScanTimer[i] = null;
            }
            this.mWifiMulticastEnabled = false;
            this.mWifiMulticastTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, parcel) : null;
            this.mAudioTurnedOnTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 7, BatteryStatsImpl.this.mAudioTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, parcel) : null;
            this.mVideoTurnedOnTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 8, BatteryStatsImpl.this.mVideoTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, parcel) : null;
            this.mForegroundActivityTimer = parcel.readInt() != 0 ? new StopwatchTimer(this, 10, null, BatteryStatsImpl.this.mOnBatteryTimeBase, parcel) : null;
            this.mProcessState = 3;
            for (int i = 0; i < 3; ++i) {
                if (parcel.readInt() != 0) {
                    this.makeProcessState(i, parcel);
                    continue;
                }
                this.mProcessStateTimer[i] = null;
            }
            this.mVibratorOnTimer = parcel.readInt() != 0 ? new BatchTimer(this, 9, BatteryStatsImpl.this.mOnBatteryTimeBase, parcel) : null;
            if (parcel.readInt() != 0) {
                this.mUserActivityCounters = new Counter[3];
                for (int i = 0; i < 3; ++i) {
                    this.mUserActivityCounters[i] = new Counter(BatteryStatsImpl.this.mOnBatteryTimeBase, parcel);
                }
            } else {
                this.mUserActivityCounters = null;
            }
            if (parcel.readInt() == 0) {
                this.mNetworkByteActivityCounters = null;
                this.mNetworkPacketActivityCounters = null;
                return;
            }
            this.mNetworkByteActivityCounters = new LongSamplingCounter[4];
            this.mNetworkPacketActivityCounters = new LongSamplingCounter[4];
            int n8 = 0;
            while (true) {
                if (n8 >= 4) {
                    this.mMobileRadioActiveTime = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, parcel);
                    this.mMobileRadioActiveCount = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, parcel);
                    return;
                }
                this.mNetworkByteActivityCounters[n8] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, parcel);
                this.mNetworkPacketActivityCounters[n8] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, parcel);
                ++n8;
            }
        }

        public void readJobSummaryFromParcelLocked(String string2, Parcel parcel) {
            StopwatchTimer stopwatchTimer = this.mJobStats.instantiateObject();
            stopwatchTimer.readSummaryFromParcelLocked(parcel);
            this.mJobStats.add(string2, stopwatchTimer);
        }

        public void readSyncSummaryFromParcelLocked(String string2, Parcel parcel) {
            StopwatchTimer stopwatchTimer = this.mSyncStats.instantiateObject();
            stopwatchTimer.readSummaryFromParcelLocked(parcel);
            this.mSyncStats.add(string2, stopwatchTimer);
        }

        public void readWakeSummaryFromParcelLocked(String string2, Parcel parcel) {
            Wakelock wakelock = new Wakelock();
            this.mWakelockStats.add(string2, wakelock);
            if (parcel.readInt() != 0) {
                wakelock.getStopwatchTimer(1).readSummaryFromParcelLocked(parcel);
            }
            if (parcel.readInt() != 0) {
                wakelock.getStopwatchTimer(0).readSummaryFromParcelLocked(parcel);
            }
            if (parcel.readInt() != 0) {
                wakelock.getStopwatchTimer(2).readSummaryFromParcelLocked(parcel);
            }
        }

        public void reportExcessiveCpuLocked(String string2, long l, long l2) {
            Proc proc = this.getProcessStatsLocked(string2);
            if (proc != null) {
                proc.addExcessiveCpu(l, l2);
            }
        }

        public void reportExcessiveWakeLocked(String string2, long l, long l2) {
            Proc proc = this.getProcessStatsLocked(string2);
            if (proc != null) {
                proc.addExcessiveWake(l, l2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean reset() {
            StopwatchTimer stopwatchTimer = this.mWifiRunningTimer;
            boolean bl = false;
            if (stopwatchTimer != null) {
                boolean bl2 = !this.mWifiRunningTimer.reset(false);
                bl = false | bl2 | this.mWifiRunning;
            }
            if (this.mFullWifiLockTimer != null) {
                boolean bl3 = !this.mFullWifiLockTimer.reset(false);
                bl = bl | bl3 | this.mFullWifiLockOut;
            }
            if (this.mWifiScanTimer != null) {
                boolean bl4 = !this.mWifiScanTimer.reset(false);
                bl = bl | bl4 | this.mWifiScanStarted;
            }
            if (this.mWifiBatchedScanTimer != null) {
                for (int i = 0; i < 5; ++i) {
                    if (this.mWifiBatchedScanTimer[i] == null) continue;
                    boolean bl5 = !this.mWifiBatchedScanTimer[i].reset(false);
                    bl |= bl5;
                }
                boolean bl6 = this.mWifiBatchedScanBinStarted != -1;
                bl |= bl6;
            }
            if (this.mWifiMulticastTimer != null) {
                boolean bl7 = !this.mWifiMulticastTimer.reset(false);
                bl = bl | bl7 | this.mWifiMulticastEnabled;
            }
            if (this.mAudioTurnedOnTimer != null) {
                boolean bl8 = !this.mAudioTurnedOnTimer.reset(false);
                bl |= bl8;
            }
            if (this.mVideoTurnedOnTimer != null) {
                boolean bl9 = !this.mVideoTurnedOnTimer.reset(false);
                bl |= bl9;
            }
            if (this.mForegroundActivityTimer != null) {
                boolean bl10 = !this.mForegroundActivityTimer.reset(false);
                bl |= bl10;
            }
            if (this.mProcessStateTimer != null) {
                for (int i = 0; i < 3; ++i) {
                    if (this.mProcessStateTimer[i] == null) continue;
                    boolean bl11 = !this.mProcessStateTimer[i].reset(false);
                    bl |= bl11;
                }
                boolean bl12 = this.mProcessState != 3;
                bl |= bl12;
            }
            if (this.mVibratorOnTimer != null) {
                if (this.mVibratorOnTimer.reset(false)) {
                    this.mVibratorOnTimer.detach();
                    this.mVibratorOnTimer = null;
                } else {
                    bl = true;
                }
            }
            if (this.mUserActivityCounters != null) {
                for (int i = 0; i < 3; ++i) {
                    this.mUserActivityCounters[i].reset(false);
                }
            }
            if (this.mNetworkByteActivityCounters != null) {
                for (int i = 0; i < 4; ++i) {
                    this.mNetworkByteActivityCounters[i].reset(false);
                    this.mNetworkPacketActivityCounters[i].reset(false);
                }
                this.mMobileRadioActiveTime.reset(false);
                this.mMobileRadioActiveCount.reset(false);
            }
            ArrayMap<String, Wakelock> arrayMap = this.mWakelockStats.getMap();
            for (int i = -1 + arrayMap.size(); i >= 0; --i) {
                if (arrayMap.valueAt(i).reset()) {
                    arrayMap.removeAt(i);
                    continue;
                }
                bl = true;
            }
            this.mWakelockStats.cleanup();
            ArrayMap<String, StopwatchTimer> arrayMap2 = this.mSyncStats.getMap();
            for (int i = -1 + arrayMap2.size(); i >= 0; --i) {
                StopwatchTimer stopwatchTimer2 = arrayMap2.valueAt(i);
                if (stopwatchTimer2.reset(false)) {
                    arrayMap2.removeAt(i);
                    stopwatchTimer2.detach();
                    continue;
                }
                bl = true;
            }
            this.mSyncStats.cleanup();
            ArrayMap<String, StopwatchTimer> arrayMap3 = this.mJobStats.getMap();
            for (int i = -1 + arrayMap3.size(); i >= 0; --i) {
                StopwatchTimer stopwatchTimer3 = arrayMap3.valueAt(i);
                if (stopwatchTimer3.reset(false)) {
                    arrayMap3.removeAt(i);
                    stopwatchTimer3.detach();
                    continue;
                }
                bl = true;
            }
            this.mJobStats.cleanup();
            for (int i = -1 + this.mSensorStats.size(); i >= 0; --i) {
                if (this.mSensorStats.valueAt(i).reset()) {
                    this.mSensorStats.removeAt(i);
                    continue;
                }
                bl = true;
            }
            for (int i = -1 + this.mProcessStats.size(); i >= 0; --i) {
                Proc proc = this.mProcessStats.valueAt(i);
                if (proc.mProcessState == 3) {
                    proc.detach();
                    this.mProcessStats.removeAt(i);
                    continue;
                }
                proc.reset();
                bl = true;
            }
            if (this.mPids.size() > 0) {
                for (int i = -1 + this.mPids.size(); i >= 0; --i) {
                    if (this.mPids.valueAt((int)i).mWakeNesting > 0) {
                        bl = true;
                        continue;
                    }
                    this.mPids.removeAt(i);
                }
            }
            if (this.mPackageStats.size() > 0) {
                Iterator<Map.Entry<String, Pkg>> iterator = this.mPackageStats.entrySet().iterator();
                while (iterator.hasNext()) {
                    Pkg pkg = iterator.next().getValue();
                    pkg.detach();
                    if (pkg.mServiceStats.size() <= 0) continue;
                    Iterator<Map.Entry<String, Pkg.Serv>> iterator2 = pkg.mServiceStats.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        iterator2.next().getValue().detach();
                    }
                }
                this.mPackageStats.clear();
            }
            if (!bl) {
                if (this.mWifiRunningTimer != null) {
                    this.mWifiRunningTimer.detach();
                }
                if (this.mFullWifiLockTimer != null) {
                    this.mFullWifiLockTimer.detach();
                }
                if (this.mWifiScanTimer != null) {
                    this.mWifiScanTimer.detach();
                }
                for (int i = 0; i < 5; ++i) {
                    if (this.mWifiBatchedScanTimer[i] == null) continue;
                    this.mWifiBatchedScanTimer[i].detach();
                }
                if (this.mWifiMulticastTimer != null) {
                    this.mWifiMulticastTimer.detach();
                }
                if (this.mAudioTurnedOnTimer != null) {
                    this.mAudioTurnedOnTimer.detach();
                    this.mAudioTurnedOnTimer = null;
                }
                if (this.mVideoTurnedOnTimer != null) {
                    this.mVideoTurnedOnTimer.detach();
                    this.mVideoTurnedOnTimer = null;
                }
                if (this.mForegroundActivityTimer != null) {
                    this.mForegroundActivityTimer.detach();
                    this.mForegroundActivityTimer = null;
                }
                if (this.mUserActivityCounters != null) {
                    for (int i = 0; i < 3; ++i) {
                        this.mUserActivityCounters[i].detach();
                    }
                }
                if (this.mNetworkByteActivityCounters != null) {
                    for (int i = 0; i < 4; ++i) {
                        this.mNetworkByteActivityCounters[i].detach();
                        this.mNetworkPacketActivityCounters[i].detach();
                    }
                }
                this.mPids.clear();
            }
            return !bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void updateProcessStateLocked(String string2, int n, long l) {
            int n2 = n <= 3 ? 0 : (n <= 8 ? 1 : 2);
            this.updateRealProcessStateLocked(string2, n2, l);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void updateRealProcessStateLocked(String string2, int n, long l) {
            boolean bl = true;
            Proc proc = this.getProcessStatsLocked(string2);
            if (proc.mProcessState != n) {
                if (n < proc.mProcessState) {
                    if (this.mProcessState <= n) {
                        bl = false;
                    }
                } else if (this.mProcessState != proc.mProcessState) {
                    bl = false;
                }
                proc.mProcessState = n;
                if (bl) {
                    int n2 = 3;
                    for (int i = -1 + this.mProcessStats.size(); i >= 0; --i) {
                        Proc proc2 = this.mProcessStats.valueAt(i);
                        if (proc2.mProcessState >= n2) continue;
                        n2 = proc2.mProcessState;
                    }
                    this.updateUidProcessStateLocked(n2, l);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void updateUidProcessStateLocked(int n, long l) {
            block6: {
                block5: {
                    if (this.mProcessState == n) break block5;
                    if (this.mProcessState != 3) {
                        this.mProcessStateTimer[this.mProcessState].stopRunningLocked(l);
                    }
                    this.mProcessState = n;
                    if (n != 3) break block6;
                }
                return;
            }
            if (this.mProcessStateTimer[n] == null) {
                this.makeProcessState(n, null);
            }
            this.mProcessStateTimer[n].startRunningLocked(l);
        }

        /*
         * Enabled aggressive block sorting
         */
        void writeToParcelLocked(Parcel parcel, long l) {
            ArrayMap<String, Wakelock> arrayMap = this.mWakelockStats.getMap();
            int n = arrayMap.size();
            parcel.writeInt(n);
            for (int i = 0; i < n; ++i) {
                parcel.writeString(arrayMap.keyAt(i));
                arrayMap.valueAt(i).writeToParcelLocked(parcel, l);
            }
            ArrayMap<String, StopwatchTimer> arrayMap2 = this.mSyncStats.getMap();
            int n2 = arrayMap2.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeString(arrayMap2.keyAt(i));
                Timer.writeTimerToParcel(parcel, arrayMap2.valueAt(i), l);
            }
            ArrayMap<String, StopwatchTimer> arrayMap3 = this.mJobStats.getMap();
            int n3 = arrayMap3.size();
            parcel.writeInt(n3);
            for (int i = 0; i < n3; ++i) {
                parcel.writeString(arrayMap3.keyAt(i));
                Timer.writeTimerToParcel(parcel, arrayMap3.valueAt(i), l);
            }
            int n4 = this.mSensorStats.size();
            parcel.writeInt(n4);
            for (int i = 0; i < n4; ++i) {
                parcel.writeInt(this.mSensorStats.keyAt(i));
                this.mSensorStats.valueAt(i).writeToParcelLocked(parcel, l);
            }
            int n5 = this.mProcessStats.size();
            parcel.writeInt(n5);
            for (int i = 0; i < n5; ++i) {
                parcel.writeString(this.mProcessStats.keyAt(i));
                this.mProcessStats.valueAt(i).writeToParcelLocked(parcel);
            }
            parcel.writeInt(this.mPackageStats.size());
            for (Map.Entry<String, Pkg> entry : this.mPackageStats.entrySet()) {
                parcel.writeString(entry.getKey());
                entry.getValue().writeToParcelLocked(parcel);
            }
            if (this.mWifiRunningTimer != null) {
                parcel.writeInt(1);
                this.mWifiRunningTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mFullWifiLockTimer != null) {
                parcel.writeInt(1);
                this.mFullWifiLockTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mWifiScanTimer != null) {
                parcel.writeInt(1);
                this.mWifiScanTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            for (int i = 0; i < 5; ++i) {
                if (this.mWifiBatchedScanTimer[i] != null) {
                    parcel.writeInt(1);
                    this.mWifiBatchedScanTimer[i].writeToParcel(parcel, l);
                    continue;
                }
                parcel.writeInt(0);
            }
            if (this.mWifiMulticastTimer != null) {
                parcel.writeInt(1);
                this.mWifiMulticastTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mAudioTurnedOnTimer != null) {
                parcel.writeInt(1);
                this.mAudioTurnedOnTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mVideoTurnedOnTimer != null) {
                parcel.writeInt(1);
                this.mVideoTurnedOnTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mForegroundActivityTimer != null) {
                parcel.writeInt(1);
                this.mForegroundActivityTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            for (int i = 0; i < 3; ++i) {
                if (this.mProcessStateTimer[i] != null) {
                    parcel.writeInt(1);
                    this.mProcessStateTimer[i].writeToParcel(parcel, l);
                    continue;
                }
                parcel.writeInt(0);
            }
            if (this.mVibratorOnTimer != null) {
                parcel.writeInt(1);
                this.mVibratorOnTimer.writeToParcel(parcel, l);
            } else {
                parcel.writeInt(0);
            }
            if (this.mUserActivityCounters != null) {
                parcel.writeInt(1);
                for (int i = 0; i < 3; ++i) {
                    this.mUserActivityCounters[i].writeToParcel(parcel);
                }
            } else {
                parcel.writeInt(0);
            }
            if (this.mNetworkByteActivityCounters == null) {
                parcel.writeInt(0);
                return;
            }
            parcel.writeInt(1);
            int n6 = 0;
            while (true) {
                if (n6 >= 4) {
                    this.mMobileRadioActiveTime.writeToParcel(parcel);
                    this.mMobileRadioActiveCount.writeToParcel(parcel);
                    return;
                }
                this.mNetworkByteActivityCounters[n6].writeToParcel(parcel);
                this.mNetworkPacketActivityCounters[n6].writeToParcel(parcel);
                ++n6;
            }
        }

        public final class Pkg
        extends BatteryStats.Uid.Pkg
        implements TimeBaseObs {
            int mLastWakeups;
            int mLoadedWakeups;
            final HashMap<String, Serv> mServiceStats = new HashMap();
            int mUnpluggedWakeups;
            int mWakeups;

            Pkg() {
                BatteryStatsImpl.this.mOnBatteryScreenOffTimeBase.add(this);
            }

            void detach() {
                BatteryStatsImpl.this.mOnBatteryScreenOffTimeBase.remove(this);
            }

            public BatteryStatsImpl getBatteryStats() {
                return BatteryStatsImpl.this;
            }

            @Override
            public Map<String, ? extends BatteryStats.Uid.Pkg.Serv> getServiceStats() {
                return this.mServiceStats;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public int getWakeups(int n) {
                int n2 = this.mWakeups;
                if (n == 1) {
                    n2 -= this.mLoadedWakeups;
                    return n2;
                } else {
                    if (n != 2) return n2;
                    return n2 - this.mUnpluggedWakeups;
                }
            }

            public void incWakeupsLocked() {
                this.mWakeups = 1 + this.mWakeups;
            }

            final Serv newServiceStatsLocked() {
                return new Serv();
            }

            @Override
            public void onTimeStarted(long l, long l2, long l3) {
                this.mUnpluggedWakeups = this.mWakeups;
            }

            @Override
            public void onTimeStopped(long l, long l2, long l3) {
            }

            void readFromParcelLocked(Parcel parcel) {
                this.mWakeups = parcel.readInt();
                this.mLoadedWakeups = parcel.readInt();
                this.mLastWakeups = 0;
                this.mUnpluggedWakeups = parcel.readInt();
                int n = parcel.readInt();
                this.mServiceStats.clear();
                for (int i = 0; i < n; ++i) {
                    String string2 = parcel.readString();
                    Serv serv = new Serv();
                    this.mServiceStats.put(string2, serv);
                    serv.readFromParcelLocked(parcel);
                }
            }

            void writeToParcelLocked(Parcel parcel) {
                parcel.writeInt(this.mWakeups);
                parcel.writeInt(this.mLoadedWakeups);
                parcel.writeInt(this.mUnpluggedWakeups);
                parcel.writeInt(this.mServiceStats.size());
                for (Map.Entry<String, Serv> entry : this.mServiceStats.entrySet()) {
                    parcel.writeString(entry.getKey());
                    entry.getValue().writeToParcelLocked(parcel);
                }
            }

            public final class Serv
            extends BatteryStats.Uid.Pkg.Serv
            implements TimeBaseObs {
                int mLastLaunches;
                long mLastStartTime;
                int mLastStarts;
                boolean mLaunched;
                long mLaunchedSince;
                long mLaunchedTime;
                int mLaunches;
                int mLoadedLaunches;
                long mLoadedStartTime;
                int mLoadedStarts;
                boolean mRunning;
                long mRunningSince;
                long mStartTime;
                int mStarts;
                int mUnpluggedLaunches;
                long mUnpluggedStartTime;
                int mUnpluggedStarts;

                Serv() {
                    super(Pkg.this);
                    BatteryStatsImpl.this.mOnBatteryTimeBase.add(this);
                }

                void detach() {
                    BatteryStatsImpl.this.mOnBatteryTimeBase.remove(this);
                }

                public BatteryStatsImpl getBatteryStats() {
                    return BatteryStatsImpl.this;
                }

                long getLaunchTimeToNowLocked(long l) {
                    if (!this.mLaunched) {
                        return this.mLaunchedTime;
                    }
                    return l + this.mLaunchedTime - this.mLaunchedSince;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public int getLaunches(int n) {
                    int n2 = this.mLaunches;
                    if (n == 1) {
                        n2 -= this.mLoadedLaunches;
                        return n2;
                    } else {
                        if (n != 2) return n2;
                        return n2 - this.mUnpluggedLaunches;
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public long getStartTime(long l, int n) {
                    long l2 = this.getStartTimeToNowLocked(l);
                    if (n == 1) {
                        l2 -= this.mLoadedStartTime;
                        return l2;
                    } else {
                        if (n != 2) return l2;
                        return l2 - this.mUnpluggedStartTime;
                    }
                }

                long getStartTimeToNowLocked(long l) {
                    if (!this.mRunning) {
                        return this.mStartTime;
                    }
                    return l + this.mStartTime - this.mRunningSince;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public int getStarts(int n) {
                    int n2 = this.mStarts;
                    if (n == 1) {
                        n2 -= this.mLoadedStarts;
                        return n2;
                    } else {
                        if (n != 2) return n2;
                        return n2 - this.mUnpluggedStarts;
                    }
                }

                @Override
                public void onTimeStarted(long l, long l2, long l3) {
                    this.mUnpluggedStartTime = this.getStartTimeToNowLocked(l2);
                    this.mUnpluggedStarts = this.mStarts;
                    this.mUnpluggedLaunches = this.mLaunches;
                }

                @Override
                public void onTimeStopped(long l, long l2, long l3) {
                }

                /*
                 * Enabled aggressive block sorting
                 */
                void readFromParcelLocked(Parcel parcel) {
                    boolean bl = true;
                    this.mStartTime = parcel.readLong();
                    this.mRunningSince = parcel.readLong();
                    boolean bl2 = parcel.readInt() != 0 ? bl : false;
                    this.mRunning = bl2;
                    this.mStarts = parcel.readInt();
                    this.mLaunchedTime = parcel.readLong();
                    this.mLaunchedSince = parcel.readLong();
                    if (parcel.readInt() == 0) {
                        bl = false;
                    }
                    this.mLaunched = bl;
                    this.mLaunches = parcel.readInt();
                    this.mLoadedStartTime = parcel.readLong();
                    this.mLoadedStarts = parcel.readInt();
                    this.mLoadedLaunches = parcel.readInt();
                    this.mLastStartTime = 0L;
                    this.mLastStarts = 0;
                    this.mLastLaunches = 0;
                    this.mUnpluggedStartTime = parcel.readLong();
                    this.mUnpluggedStarts = parcel.readInt();
                    this.mUnpluggedLaunches = parcel.readInt();
                }

                public void startLaunchedLocked() {
                    if (!this.mLaunched) {
                        this.mLaunches = 1 + this.mLaunches;
                        this.mLaunchedSince = BatteryStatsImpl.this.getBatteryUptimeLocked();
                        this.mLaunched = true;
                    }
                }

                public void startRunningLocked() {
                    if (!this.mRunning) {
                        this.mStarts = 1 + this.mStarts;
                        this.mRunningSince = BatteryStatsImpl.this.getBatteryUptimeLocked();
                        this.mRunning = true;
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void stopLaunchedLocked() {
                    if (this.mLaunched) {
                        long l = BatteryStatsImpl.this.getBatteryUptimeLocked() - this.mLaunchedSince;
                        if (l > 0L) {
                            this.mLaunchedTime = l + this.mLaunchedTime;
                        } else {
                            this.mLaunches = -1 + this.mLaunches;
                        }
                        this.mLaunched = false;
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void stopRunningLocked() {
                    if (this.mRunning) {
                        long l = BatteryStatsImpl.this.getBatteryUptimeLocked() - this.mRunningSince;
                        if (l > 0L) {
                            this.mStartTime = l + this.mStartTime;
                        } else {
                            this.mStarts = -1 + this.mStarts;
                        }
                        this.mRunning = false;
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 */
                void writeToParcelLocked(Parcel parcel) {
                    int n = 1;
                    parcel.writeLong(this.mStartTime);
                    parcel.writeLong(this.mRunningSince);
                    int n2 = this.mRunning ? n : 0;
                    parcel.writeInt(n2);
                    parcel.writeInt(this.mStarts);
                    parcel.writeLong(this.mLaunchedTime);
                    parcel.writeLong(this.mLaunchedSince);
                    if (!this.mLaunched) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(this.mLaunches);
                    parcel.writeLong(this.mLoadedStartTime);
                    parcel.writeInt(this.mLoadedStarts);
                    parcel.writeInt(this.mLoadedLaunches);
                    parcel.writeLong(this.mUnpluggedStartTime);
                    parcel.writeInt(this.mUnpluggedStarts);
                    parcel.writeInt(this.mUnpluggedLaunches);
                }
            }
        }

        public final class Proc
        extends BatteryStats.Uid.Proc
        implements TimeBaseObs {
            boolean mActive = true;
            ArrayList<BatteryStats.Uid.Proc.ExcessivePower> mExcessivePower;
            long mForegroundTime;
            long mLastForegroundTime;
            int mLastStarts;
            long mLastSystemTime;
            long mLastUserTime;
            long mLoadedForegroundTime;
            int mLoadedStarts;
            long mLoadedSystemTime;
            long mLoadedUserTime;
            final String mName;
            int mProcessState = 3;
            SamplingCounter[] mSpeedBins;
            int mStarts;
            long mSystemTime;
            long mUnpluggedForegroundTime;
            int mUnpluggedStarts;
            long mUnpluggedSystemTime;
            long mUnpluggedUserTime;
            long mUserTime;

            Proc(String string2) {
                this.mName = string2;
                BatteryStatsImpl.this.mOnBatteryTimeBase.add(this);
                this.mSpeedBins = new SamplingCounter[BatteryStatsImpl.this.getCpuSpeedSteps()];
            }

            public void addCpuTimeLocked(int n, int n2) {
                this.mUserTime += (long)n;
                this.mSystemTime += (long)n2;
            }

            public void addExcessiveCpu(long l, long l2) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower excessivePower = new BatteryStats.Uid.Proc.ExcessivePower();
                excessivePower.type = 2;
                excessivePower.overTime = l;
                excessivePower.usedTime = l2;
                this.mExcessivePower.add(excessivePower);
            }

            public void addExcessiveWake(long l, long l2) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower excessivePower = new BatteryStats.Uid.Proc.ExcessivePower();
                excessivePower.type = 1;
                excessivePower.overTime = l;
                excessivePower.usedTime = l2;
                this.mExcessivePower.add(excessivePower);
            }

            public void addForegroundTimeLocked(long l) {
                this.mForegroundTime = l + this.mForegroundTime;
            }

            public void addSpeedStepTimes(long[] lArray) {
                for (int i = 0; i < this.mSpeedBins.length && i < lArray.length; ++i) {
                    if (lArray[i] == 0L) continue;
                    SamplingCounter samplingCounter = this.mSpeedBins[i];
                    if (samplingCounter == null) {
                        SamplingCounter[] samplingCounterArray = this.mSpeedBins;
                        samplingCounterArray[i] = samplingCounter = new SamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
                    }
                    samplingCounter.addCountAtomic(lArray[i]);
                }
            }

            @Override
            public int countExcessivePowers() {
                if (this.mExcessivePower != null) {
                    return this.mExcessivePower.size();
                }
                return 0;
            }

            void detach() {
                this.mActive = false;
                BatteryStatsImpl.this.mOnBatteryTimeBase.remove(this);
                for (int i = 0; i < this.mSpeedBins.length; ++i) {
                    SamplingCounter samplingCounter = this.mSpeedBins[i];
                    if (samplingCounter == null) continue;
                    BatteryStatsImpl.this.mOnBatteryTimeBase.remove(samplingCounter);
                    this.mSpeedBins[i] = null;
                }
            }

            public BatteryStatsImpl getBatteryStats() {
                return BatteryStatsImpl.this;
            }

            @Override
            public BatteryStats.Uid.Proc.ExcessivePower getExcessivePower(int n) {
                if (this.mExcessivePower != null) {
                    return this.mExcessivePower.get(n);
                }
                return null;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public long getForegroundTime(int n) {
                long l = this.mForegroundTime;
                if (n == 1) {
                    l -= this.mLoadedForegroundTime;
                    return l;
                } else {
                    if (n != 2) return l;
                    return l - this.mUnpluggedForegroundTime;
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public int getStarts(int n) {
                int n2 = this.mStarts;
                if (n == 1) {
                    n2 -= this.mLoadedStarts;
                    return n2;
                } else {
                    if (n != 2) return n2;
                    return n2 - this.mUnpluggedStarts;
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public long getSystemTime(int n) {
                long l = this.mSystemTime;
                if (n == 1) {
                    l -= this.mLoadedSystemTime;
                    return l;
                } else {
                    if (n != 2) return l;
                    return l - this.mUnpluggedSystemTime;
                }
            }

            @Override
            public long getTimeAtCpuSpeedStep(int n, int n2) {
                SamplingCounter samplingCounter;
                long l = 0L;
                if (n < this.mSpeedBins.length && (samplingCounter = this.mSpeedBins[n]) != null) {
                    l = samplingCounter.getCountLocked(n2);
                }
                return l;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public long getUserTime(int n) {
                long l = this.mUserTime;
                if (n == 1) {
                    l -= this.mLoadedUserTime;
                    return l;
                } else {
                    if (n != 2) return l;
                    return l - this.mUnpluggedUserTime;
                }
            }

            public void incStartsLocked() {
                this.mStarts = 1 + this.mStarts;
            }

            @Override
            public boolean isActive() {
                return this.mActive;
            }

            @Override
            public void onTimeStarted(long l, long l2, long l3) {
                this.mUnpluggedUserTime = this.mUserTime;
                this.mUnpluggedSystemTime = this.mSystemTime;
                this.mUnpluggedForegroundTime = this.mForegroundTime;
                this.mUnpluggedStarts = this.mStarts;
            }

            @Override
            public void onTimeStopped(long l, long l2, long l3) {
            }

            /*
             * Enabled aggressive block sorting
             */
            boolean readExcessivePowerFromParcelLocked(Parcel parcel) {
                int n = parcel.readInt();
                if (n == 0) {
                    this.mExcessivePower = null;
                    return true;
                } else {
                    if (n > 10000) {
                        Slog.w(BatteryStatsImpl.TAG, "File corrupt: too many excessive power entries " + n);
                        return false;
                    }
                    this.mExcessivePower = new ArrayList();
                    for (int i = 0; i < n; ++i) {
                        BatteryStats.Uid.Proc.ExcessivePower excessivePower = new BatteryStats.Uid.Proc.ExcessivePower();
                        excessivePower.type = parcel.readInt();
                        excessivePower.overTime = parcel.readLong();
                        excessivePower.usedTime = parcel.readLong();
                        this.mExcessivePower.add(excessivePower);
                    }
                }
                return true;
            }

            void readFromParcelLocked(Parcel parcel) {
                int n;
                this.mUserTime = parcel.readLong();
                this.mSystemTime = parcel.readLong();
                this.mForegroundTime = parcel.readLong();
                this.mStarts = parcel.readInt();
                this.mLoadedUserTime = parcel.readLong();
                this.mLoadedSystemTime = parcel.readLong();
                this.mLoadedForegroundTime = parcel.readLong();
                this.mLoadedStarts = parcel.readInt();
                this.mLastUserTime = 0L;
                this.mLastSystemTime = 0L;
                this.mLastForegroundTime = 0L;
                this.mLastStarts = 0;
                this.mUnpluggedUserTime = parcel.readLong();
                this.mUnpluggedSystemTime = parcel.readLong();
                this.mUnpluggedForegroundTime = parcel.readLong();
                this.mUnpluggedStarts = parcel.readInt();
                int n2 = parcel.readInt();
                if (n2 >= (n = BatteryStatsImpl.this.getCpuSpeedSteps())) {
                    n = n2;
                }
                this.mSpeedBins = new SamplingCounter[n];
                for (int i = 0; i < n2; ++i) {
                    if (parcel.readInt() == 0) continue;
                    this.mSpeedBins[i] = new SamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, parcel);
                }
                this.readExcessivePowerFromParcelLocked(parcel);
            }

            void reset() {
                this.mForegroundTime = 0L;
                this.mSystemTime = 0L;
                this.mUserTime = 0L;
                this.mStarts = 0;
                this.mLoadedForegroundTime = 0L;
                this.mLoadedSystemTime = 0L;
                this.mLoadedUserTime = 0L;
                this.mLoadedStarts = 0;
                this.mLastForegroundTime = 0L;
                this.mLastSystemTime = 0L;
                this.mLastUserTime = 0L;
                this.mLastStarts = 0;
                this.mUnpluggedForegroundTime = 0L;
                this.mUnpluggedSystemTime = 0L;
                this.mUnpluggedUserTime = 0L;
                this.mUnpluggedStarts = 0;
                for (int i = 0; i < this.mSpeedBins.length; ++i) {
                    SamplingCounter samplingCounter = this.mSpeedBins[i];
                    if (samplingCounter == null) continue;
                    samplingCounter.reset(false);
                }
                this.mExcessivePower = null;
            }

            /*
             * Enabled aggressive block sorting
             */
            void writeExcessivePowerToParcelLocked(Parcel parcel) {
                if (this.mExcessivePower == null) {
                    parcel.writeInt(0);
                    return;
                } else {
                    int n = this.mExcessivePower.size();
                    parcel.writeInt(n);
                    for (int i = 0; i < n; ++i) {
                        BatteryStats.Uid.Proc.ExcessivePower excessivePower = this.mExcessivePower.get(i);
                        parcel.writeInt(excessivePower.type);
                        parcel.writeLong(excessivePower.overTime);
                        parcel.writeLong(excessivePower.usedTime);
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            void writeToParcelLocked(Parcel parcel) {
                parcel.writeLong(this.mUserTime);
                parcel.writeLong(this.mSystemTime);
                parcel.writeLong(this.mForegroundTime);
                parcel.writeInt(this.mStarts);
                parcel.writeLong(this.mLoadedUserTime);
                parcel.writeLong(this.mLoadedSystemTime);
                parcel.writeLong(this.mLoadedForegroundTime);
                parcel.writeInt(this.mLoadedStarts);
                parcel.writeLong(this.mUnpluggedUserTime);
                parcel.writeLong(this.mUnpluggedSystemTime);
                parcel.writeLong(this.mUnpluggedForegroundTime);
                parcel.writeInt(this.mUnpluggedStarts);
                parcel.writeInt(this.mSpeedBins.length);
                int n = 0;
                while (true) {
                    if (n >= this.mSpeedBins.length) {
                        this.writeExcessivePowerToParcelLocked(parcel);
                        return;
                    }
                    SamplingCounter samplingCounter = this.mSpeedBins[n];
                    if (samplingCounter != null) {
                        parcel.writeInt(1);
                        samplingCounter.writeToParcel(parcel);
                    } else {
                        parcel.writeInt(0);
                    }
                    ++n;
                }
            }
        }

        public final class Sensor
        extends BatteryStats.Uid.Sensor {
            final int mHandle;
            StopwatchTimer mTimer;

            public Sensor(int n) {
                this.mHandle = n;
            }

            private StopwatchTimer readTimerFromParcel(TimeBase timeBase, Parcel parcel) {
                if (parcel.readInt() == 0) {
                    return null;
                }
                ArrayList<StopwatchTimer> arrayList = BatteryStatsImpl.this.mSensorTimers.get(this.mHandle);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    BatteryStatsImpl.this.mSensorTimers.put(this.mHandle, arrayList);
                }
                return new StopwatchTimer(Uid.this, 0, arrayList, timeBase, parcel);
            }

            @Override
            public int getHandle() {
                return this.mHandle;
            }

            @Override
            public Timer getSensorTime() {
                return this.mTimer;
            }

            void readFromParcelLocked(TimeBase timeBase, Parcel parcel) {
                this.mTimer = this.readTimerFromParcel(timeBase, parcel);
            }

            boolean reset() {
                if (this.mTimer.reset(true)) {
                    this.mTimer = null;
                    return true;
                }
                return false;
            }

            void writeToParcelLocked(Parcel parcel, long l) {
                Timer.writeTimerToParcel(parcel, this.mTimer, l);
            }
        }

        public final class Wakelock
        extends BatteryStats.Uid.Wakelock {
            StopwatchTimer mTimerFull;
            StopwatchTimer mTimerPartial;
            StopwatchTimer mTimerWindow;

            private StopwatchTimer readTimerFromParcel(int n, ArrayList<StopwatchTimer> arrayList, TimeBase timeBase, Parcel parcel) {
                if (parcel.readInt() == 0) {
                    return null;
                }
                return new StopwatchTimer(Uid.this, n, arrayList, timeBase, parcel);
            }

            public StopwatchTimer getStopwatchTimer(int n) {
                switch (n) {
                    default: {
                        throw new IllegalArgumentException("type=" + n);
                    }
                    case 0: {
                        StopwatchTimer stopwatchTimer = this.mTimerPartial;
                        if (stopwatchTimer == null) {
                            this.mTimerPartial = stopwatchTimer = new StopwatchTimer(Uid.this, 0, BatteryStatsImpl.this.mPartialTimers, BatteryStatsImpl.this.mOnBatteryScreenOffTimeBase);
                        }
                        return stopwatchTimer;
                    }
                    case 1: {
                        StopwatchTimer stopwatchTimer = this.mTimerFull;
                        if (stopwatchTimer == null) {
                            this.mTimerFull = stopwatchTimer = new StopwatchTimer(Uid.this, 1, BatteryStatsImpl.this.mFullTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                        }
                        return stopwatchTimer;
                    }
                    case 2: 
                }
                StopwatchTimer stopwatchTimer = this.mTimerWindow;
                if (stopwatchTimer == null) {
                    this.mTimerWindow = stopwatchTimer = new StopwatchTimer(Uid.this, 2, BatteryStatsImpl.this.mWindowTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
                return stopwatchTimer;
            }

            @Override
            public Timer getWakeTime(int n) {
                switch (n) {
                    default: {
                        throw new IllegalArgumentException("type = " + n);
                    }
                    case 1: {
                        return this.mTimerFull;
                    }
                    case 0: {
                        return this.mTimerPartial;
                    }
                    case 2: 
                }
                return this.mTimerWindow;
            }

            void readFromParcelLocked(TimeBase timeBase, TimeBase timeBase2, Parcel parcel) {
                this.mTimerPartial = this.readTimerFromParcel(0, BatteryStatsImpl.this.mPartialTimers, timeBase2, parcel);
                this.mTimerFull = this.readTimerFromParcel(1, BatteryStatsImpl.this.mFullTimers, timeBase, parcel);
                this.mTimerWindow = this.readTimerFromParcel(2, BatteryStatsImpl.this.mWindowTimers, timeBase, parcel);
            }

            /*
             * Enabled aggressive block sorting
             */
            boolean reset() {
                StopwatchTimer stopwatchTimer = this.mTimerFull;
                boolean bl = false;
                if (stopwatchTimer != null) {
                    boolean bl2 = !this.mTimerFull.reset(false);
                    bl = false | bl2;
                }
                if (this.mTimerPartial != null) {
                    boolean bl3 = !this.mTimerPartial.reset(false);
                    bl |= bl3;
                }
                if (this.mTimerWindow != null) {
                    boolean bl4 = !this.mTimerWindow.reset(false);
                    bl |= bl4;
                }
                if (!bl) {
                    if (this.mTimerFull != null) {
                        this.mTimerFull.detach();
                        this.mTimerFull = null;
                    }
                    if (this.mTimerPartial != null) {
                        this.mTimerPartial.detach();
                        this.mTimerPartial = null;
                    }
                    if (this.mTimerWindow != null) {
                        this.mTimerWindow.detach();
                        this.mTimerWindow = null;
                    }
                }
                return !bl;
            }

            void writeToParcelLocked(Parcel parcel, long l) {
                Timer.writeTimerToParcel(parcel, this.mTimerPartial, l);
                Timer.writeTimerToParcel(parcel, this.mTimerFull, l);
                Timer.writeTimerToParcel(parcel, this.mTimerWindow, l);
            }
        }
    }
}

