/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.os.BatteryStats;
import android.os.Bundle;
import android.os.MemoryFile;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.PowerProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class BatteryStatsHelper {
    private static final boolean DEBUG;
    private static final String TAG;
    private static Intent sBatteryBroadcastXfer;
    private static ArrayMap<File, BatteryStats> sFileXfer;
    private static BatteryStats sStatsXfer;
    private long mAppMobileActive;
    private long mAppWifiRunning;
    private Intent mBatteryBroadcast;
    private IBatteryStats mBatteryInfo;
    long mBatteryRealtime;
    long mBatteryTimeRemaining;
    long mBatteryUptime;
    private double mBluetoothPower;
    private final List<BatterySipper> mBluetoothSippers;
    long mChargeTimeRemaining;
    private final boolean mCollectBatteryBroadcast;
    private double mComputedPower;
    private final Context mContext;
    private double mMaxDrainedPower;
    private double mMaxPower = 1.0;
    private double mMaxRealPower = 1.0;
    private double mMinDrainedPower;
    private final List<BatterySipper> mMobilemsppList;
    private PowerProfile mPowerProfile;
    long mRawRealtime;
    long mRawUptime;
    private BatteryStats mStats;
    private long mStatsPeriod = 0L;
    private int mStatsType = 0;
    private double mTotalPower;
    long mTypeBatteryRealtime;
    long mTypeBatteryUptime;
    private final List<BatterySipper> mUsageList = new ArrayList<BatterySipper>();
    private final SparseArray<Double> mUserPower;
    private final SparseArray<List<BatterySipper>> mUserSippers;
    private final boolean mWifiOnly;
    private double mWifiPower;
    private final List<BatterySipper> mWifiSippers = new ArrayList<BatterySipper>();

    static {
        TAG = BatteryStatsHelper.class.getSimpleName();
        sFileXfer = new ArrayMap();
    }

    public BatteryStatsHelper(Context context) {
        this(context, true);
    }

    public BatteryStatsHelper(Context context, boolean bl) {
        this.mBluetoothSippers = new ArrayList<BatterySipper>();
        this.mUserSippers = new SparseArray();
        this.mUserPower = new SparseArray();
        this.mMobilemsppList = new ArrayList<BatterySipper>();
        this.mContext = context;
        this.mCollectBatteryBroadcast = bl;
        this.mWifiOnly = BatteryStatsHelper.checkWifiOnly(context);
    }

    public BatteryStatsHelper(Context context, boolean bl, boolean bl2) {
        this.mBluetoothSippers = new ArrayList<BatterySipper>();
        this.mUserSippers = new SparseArray();
        this.mUserPower = new SparseArray();
        this.mMobilemsppList = new ArrayList<BatterySipper>();
        this.mContext = context;
        this.mCollectBatteryBroadcast = bl;
        this.mWifiOnly = bl2;
    }

    private void addBluetoothUsage() {
        long l = this.mStats.getBluetoothOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double d = (double)l * this.mPowerProfile.getAveragePower("bluetooth.on") / 3600000.0 + (double)this.mStats.getBluetoothPingCount() * this.mPowerProfile.getAveragePower("bluetooth.at") / 3600000.0;
        if (d + this.mBluetoothPower != 0.0) {
            this.aggregateSippers(this.addEntry(BatterySipper.DrainType.BLUETOOTH, l, d + this.mBluetoothPower), this.mBluetoothSippers, "Bluetooth");
        }
    }

    private BatterySipper addEntry(BatterySipper.DrainType drainType, long l, double d) {
        this.mComputedPower = d + this.mComputedPower;
        if (d > this.mMaxRealPower) {
            this.mMaxRealPower = d;
        }
        return this.addEntryNoTotal(drainType, l, d);
    }

    private BatterySipper addEntryNoTotal(BatterySipper.DrainType drainType, long l, double d) {
        if (d > this.mMaxPower) {
            this.mMaxPower = d;
        }
        BatterySipper batterySipper = new BatterySipper(drainType, null, new double[]{d});
        batterySipper.usageTime = l;
        this.mUsageList.add(batterySipper);
        return batterySipper;
    }

    private void addFlashlightUsage() {
        long l = this.mStats.getFlashlightOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double d = (double)l * this.mPowerProfile.getAveragePower("camera.flashlight") / 3600000.0;
        if (d != 0.0) {
            this.addEntry(BatterySipper.DrainType.FLASHLIGHT, l, d);
        }
    }

    private void addIdleUsage() {
        long l = (this.mTypeBatteryRealtime - this.mStats.getScreenOnTime(this.mRawRealtime, this.mStatsType)) / 1000L;
        double d = (double)l * this.mPowerProfile.getAveragePower("cpu.idle") / 3600000.0;
        if (d != 0.0) {
            this.addEntry(BatterySipper.DrainType.IDLE, l, d);
        }
    }

    private void addPhoneUsage() {
        long l = this.mStats.getPhoneOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double d = this.mPowerProfile.getAveragePower("radio.active") * (double)l / 3600000.0;
        if (d != 0.0) {
            this.addEntry(BatterySipper.DrainType.PHONE, l, d);
        }
    }

    private void addRadioUsage() {
        double d = 0.0;
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < 5; ++i) {
            long l3 = this.mStats.getPhoneSignalStrengthTime(i, this.mRawRealtime, this.mStatsType) / 1000L;
            d += (double)l3 * this.mPowerProfile.getAveragePower("radio.on", i) / 3600000.0;
            l += l3;
            if (i != 0) continue;
            l2 = l3;
        }
        double d2 = d + (double)(this.mStats.getPhoneSignalScanningTime(this.mRawRealtime, this.mStatsType) / 1000L) * this.mPowerProfile.getAveragePower("radio.scanning") / 3600000.0;
        long l4 = (this.mStats.getMobileRadioActiveTime(this.mRawRealtime, this.mStatsType) - this.mAppMobileActive) / 1000L;
        if (l4 > 0L) {
            d2 += this.getMobilePowerPerMs() * (double)l4;
        }
        if (d2 != 0.0) {
            BatterySipper batterySipper = this.addEntry(BatterySipper.DrainType.CELL, l, d2);
            if (l != 0L) {
                batterySipper.noCoveragePercent = 100.0 * (double)l2 / (double)l;
            }
            batterySipper.mobileActive = l4;
            batterySipper.mobileActiveCount = this.mStats.getMobileRadioActiveUnknownCount(this.mStatsType);
        }
    }

    private void addScreenUsage() {
        long l = this.mStats.getScreenOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double d = 0.0 + (double)l * this.mPowerProfile.getAveragePower("screen.on");
        double d2 = this.mPowerProfile.getAveragePower("screen.full");
        for (int i = 0; i < 5; ++i) {
            d += d2 * (double)(0.5f + (float)i) / 5.0 * (double)(this.mStats.getScreenBrightnessTime(i, this.mRawRealtime, this.mStatsType) / 1000L);
        }
        double d3 = d / 3600000.0;
        if (d3 != 0.0) {
            this.addEntry(BatterySipper.DrainType.SCREEN, l, d3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addUserUsage() {
        int n = 0;
        while (n < this.mUserSippers.size()) {
            int n2 = this.mUserSippers.keyAt(n);
            List<BatterySipper> list = this.mUserSippers.valueAt(n);
            Double d = this.mUserPower.get(n2);
            double d2 = d != null ? d : 0.0;
            BatterySipper batterySipper = this.addEntry(BatterySipper.DrainType.USER, 0L, d2);
            batterySipper.userId = n2;
            this.aggregateSippers(batterySipper, list, "User");
            ++n;
        }
        return;
    }

    private void addWiFiUsage() {
        double d;
        long l = this.mStats.getWifiOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        long l2 = this.mStats.getGlobalWifiRunningTime(this.mRawRealtime, this.mStatsType) / 1000L - this.mAppWifiRunning;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if ((d = ((double)(0L * l) * this.mPowerProfile.getAveragePower("wifi.on") + (double)l2 * this.mPowerProfile.getAveragePower("wifi.on")) / 3600000.0) + this.mWifiPower != 0.0) {
            this.aggregateSippers(this.addEntry(BatterySipper.DrainType.WIFI, l2, d + this.mWifiPower), this.mWifiSippers, "WIFI");
        }
    }

    private void aggregateSippers(BatterySipper batterySipper, List<BatterySipper> list, String string2) {
        for (int i = 0; i < list.size(); ++i) {
            BatterySipper batterySipper2 = list.get(i);
            batterySipper.cpuTime += batterySipper2.cpuTime;
            batterySipper.gpsTime += batterySipper2.gpsTime;
            batterySipper.wifiRunningTime += batterySipper2.wifiRunningTime;
            batterySipper.cpuFgTime += batterySipper2.cpuFgTime;
            batterySipper.wakeLockTime += batterySipper2.wakeLockTime;
            batterySipper.mobileRxPackets += batterySipper2.mobileRxPackets;
            batterySipper.mobileTxPackets += batterySipper2.mobileTxPackets;
            batterySipper.mobileActive += batterySipper2.mobileActive;
            batterySipper.mobileActiveCount += batterySipper2.mobileActiveCount;
            batterySipper.wifiRxPackets += batterySipper2.wifiRxPackets;
            batterySipper.wifiTxPackets += batterySipper2.wifiTxPackets;
            batterySipper.mobileRxBytes += batterySipper2.mobileRxBytes;
            batterySipper.mobileTxBytes += batterySipper2.mobileTxBytes;
            batterySipper.wifiRxBytes += batterySipper2.wifiRxBytes;
            batterySipper.wifiTxBytes += batterySipper2.wifiTxBytes;
        }
        batterySipper.computeMobilemspp();
    }

    public static boolean checkWifiOnly(Context context) {
        boolean bl = ((ConnectivityManager)context.getSystemService("connectivity")).isNetworkSupported(0);
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        }
        return bl2;
    }

    public static void dropFile(Context context, String string2) {
        BatteryStatsHelper.makeFilePath(context, string2).delete();
    }

    private double getMobilePowerPerMs() {
        return this.mPowerProfile.getAveragePower("radio.active") / 3600000.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double getMobilePowerPerPacket() {
        double d;
        double d2 = this.mPowerProfile.getAveragePower("radio.active") / 3600.0;
        long l = this.mStats.getNetworkActivityPackets(0, this.mStatsType) + this.mStats.getNetworkActivityPackets(1, this.mStatsType);
        long l2 = this.mStats.getMobileRadioActiveTime(this.mRawRealtime, this.mStatsType) / 1000L;
        if (l != 0L && l2 != 0L) {
            d = (double)l / (double)l2;
            return d2 / d / 3600.0;
        }
        d = 12.20703125;
        return d2 / d / 3600.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BatteryStatsImpl getStats(IBatteryStats iBatteryStats) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = iBatteryStats.getStatisticsStream();
            if (parcelFileDescriptor == null) return new BatteryStatsImpl();
            ParcelFileDescriptor.AutoCloseInputStream autoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream(parcelFileDescriptor);
            try {
                byte[] byArray = BatteryStatsHelper.readFully(autoCloseInputStream, MemoryFile.getSize(parcelFileDescriptor.getFileDescriptor()));
                Parcel parcel = Parcel.obtain();
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
                batteryStatsImpl.distributeWorkLocked(0);
                return batteryStatsImpl;
            }
            catch (IOException iOException) {
                Log.w(TAG, "Unable to read statistics stream", iOException);
            }
            return new BatteryStatsImpl();
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "RemoteException:", remoteException);
            return new BatteryStatsImpl();
        }
    }

    private double getWifiPowerPerPacket() {
        return this.mPowerProfile.getAveragePower("wifi.active") / 3600.0 / 61.03515625 / 3600.0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void load() {
        block3: {
            block2: {
                if (this.mBatteryInfo == null) break block2;
                this.mStats = BatteryStatsHelper.getStats(this.mBatteryInfo);
                if (this.mCollectBatteryBroadcast) break block3;
            }
            return;
        }
        this.mBatteryBroadcast = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
    }

    private static File makeFilePath(Context context, String string2) {
        return new File(context.getFilesDir(), string2);
    }

    public static String makemAh(double d) {
        if (d < 1.0E-5) {
            Object[] objectArray = new Object[]{d};
            return String.format("%.8f", objectArray);
        }
        if (d < 1.0E-4) {
            Object[] objectArray = new Object[]{d};
            return String.format("%.7f", objectArray);
        }
        if (d < 0.001) {
            Object[] objectArray = new Object[]{d};
            return String.format("%.6f", objectArray);
        }
        if (d < 0.01) {
            Object[] objectArray = new Object[]{d};
            return String.format("%.5f", objectArray);
        }
        if (d < 0.1) {
            Object[] objectArray = new Object[]{d};
            return String.format("%.4f", objectArray);
        }
        if (d < 1.0) {
            Object[] objectArray = new Object[]{d};
            return String.format("%.3f", objectArray);
        }
        if (d < 10.0) {
            Object[] objectArray = new Object[]{d};
            return String.format("%.2f", objectArray);
        }
        if (d < 100.0) {
            Object[] objectArray = new Object[]{d};
            return String.format("%.1f", objectArray);
        }
        Object[] objectArray = new Object[]{d};
        return String.format("%.0f", objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processAppUsage(SparseArray<UserHandle> sparseArray) {
        boolean bl = sparseArray.get(-1) != null;
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        int n = this.mStatsType;
        int n2 = this.mPowerProfile.getNumSpeedSteps();
        double[] dArray = new double[n2];
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = this.mPowerProfile.getAveragePower("cpu.active", i);
        }
        double d = this.getMobilePowerPerPacket();
        double d2 = this.getMobilePowerPerMs();
        double d3 = this.getWifiPowerPerPacket();
        long l = 0L;
        BatterySipper batterySipper = null;
        this.mStatsPeriod = this.mTypeBatteryRealtime;
        SparseArray<? extends BatteryStats.Uid> sparseArray2 = this.mStats.getUidStats();
        int n3 = sparseArray2.size();
        int n4 = 0;
        while (true) {
            long l2;
            double d4;
            double d5;
            String string2;
            long l3;
            long l4;
            long l5;
            long l6;
            double d6;
            BatteryStats.Uid uid;
            block33: {
                Iterator<Map.Entry<String, ? extends BatteryStats.Uid.Proc>> iterator;
                double d7;
                block34: {
                    long l7;
                    block32: {
                        if (n4 >= n3) break block32;
                        uid = sparseArray2.valueAt(n4);
                        d6 = 0.0;
                        d7 = 0.0;
                        Map<String, ? extends BatteryStats.Uid.Proc> map = uid.getProcessStats();
                        l6 = 0L;
                        l5 = 0L;
                        l4 = 0L;
                        l3 = 0L;
                        int n5 = map.size();
                        string2 = null;
                        if (n5 <= 0) break block33;
                        iterator = map.entrySet().iterator();
                        break block34;
                    }
                    if (batterySipper != null && (l7 = this.mBatteryUptime / 1000L - (l / 1000L + this.mStats.getScreenOnTime(this.mRawRealtime, n) / 1000L)) > 0L) {
                        double d8;
                        long l8;
                        double d9 = (double)l7 * this.mPowerProfile.getAveragePower("cpu.awake") / 3600000.0;
                        batterySipper.wakeLockTime = l8 = l7 + batterySipper.wakeLockTime;
                        batterySipper.value = d8 = d9 + batterySipper.value;
                        double[] dArray2 = batterySipper.values;
                        dArray2[0] = d9 + dArray2[0];
                        if (batterySipper.value > this.mMaxPower) {
                            this.mMaxPower = batterySipper.value;
                        }
                        if (batterySipper.value > this.mMaxRealPower) {
                            this.mMaxRealPower = batterySipper.value;
                        }
                        this.mComputedPower = d9 + this.mComputedPower;
                    }
                    return;
                }
                while (iterator.hasNext()) {
                    Map.Entry<String, ? extends BatteryStats.Uid.Proc> entry = iterator.next();
                    BatteryStats.Uid.Proc proc = entry.getValue();
                    long l9 = proc.getUserTime(n);
                    long l10 = proc.getSystemTime(n);
                    l5 += 10L * proc.getForegroundTime(n);
                    long l11 = 10L * (l9 + l10);
                    int n6 = 0;
                    for (int i = 0; i < n2; ++i) {
                        lArray[i] = proc.getTimeAtCpuSpeedStep(i, n);
                        n6 = (int)((long)n6 + lArray[i]);
                    }
                    if (n6 == 0) {
                        n6 = 1;
                    }
                    double d10 = 0.0;
                    for (int i = 0; i < n2; d10 += (double)lArray[i] / (double)n6 * (double)l11 * dArray[i], ++i) {
                    }
                    l6 += l11;
                    d6 += d10;
                    if (string2 == null || string2.startsWith("*")) {
                        d7 = d10;
                        string2 = entry.getKey();
                        continue;
                    }
                    if (!(d7 < d10) || entry.getKey().startsWith("*")) continue;
                    d7 = d10;
                    string2 = entry.getKey();
                }
            }
            if (l5 > l6) {
                l6 = l5;
            }
            double d11 = d6 / 3600000.0;
            Iterator<Map.Entry<String, ? extends BatteryStats.Uid.Wakelock>> iterator = uid.getWakelockStats().entrySet().iterator();
            while (iterator.hasNext()) {
                BatteryStats.Timer timer = iterator.next().getValue().getWakeTime(0);
                if (timer == null) continue;
                l4 += timer.getTotalTimeLocked(this.mRawRealtime, n);
            }
            l += l4;
            long l12 = l4 / 1000L;
            double d12 = d11 + (double)l12 * this.mPowerProfile.getAveragePower("cpu.awake") / 3600000.0;
            long l13 = uid.getNetworkActivityPackets(0, this.mStatsType);
            long l14 = uid.getNetworkActivityPackets(1, this.mStatsType);
            long l15 = uid.getNetworkActivityBytes(0, this.mStatsType);
            long l16 = uid.getNetworkActivityBytes(1, this.mStatsType);
            long l17 = uid.getMobileRadioActiveTime(this.mStatsType);
            if (l17 > 0L) {
                this.mAppMobileActive = l17 + this.mAppMobileActive;
                d5 = d2 * (double)l17 / 1000.0;
            } else {
                d5 = d * (double)(l13 + l14);
            }
            double d13 = d12 + d5;
            long l18 = uid.getNetworkActivityPackets(2, this.mStatsType);
            long l19 = uid.getNetworkActivityPackets(3, this.mStatsType);
            long l20 = uid.getNetworkActivityBytes(2, this.mStatsType);
            long l21 = uid.getNetworkActivityBytes(3, this.mStatsType);
            double d14 = d13 + d3 * (double)(l18 + l19);
            long l22 = uid.getWifiRunningTime(this.mRawRealtime, n) / 1000L;
            this.mAppWifiRunning = l22 + this.mAppWifiRunning;
            double d15 = d14 + (double)l22 * this.mPowerProfile.getAveragePower("wifi.on") / 3600000.0 + (double)(uid.getWifiScanTime(this.mRawRealtime, n) / 1000L) * this.mPowerProfile.getAveragePower("wifi.scan") / 3600000.0;
            for (int i = 0; i < 5; d15 += (double)(uid.getWifiBatchedScanTime(i, this.mRawRealtime, n) / 1000L) * this.mPowerProfile.getAveragePower("wifi.batchedscan", i) / 3600000.0, ++i) {
            }
            SparseArray<? extends BatteryStats.Uid.Sensor> sparseArray3 = uid.getSensorStats();
            int n7 = sparseArray3.size();
            block10: for (int i = 0; i < n7; d15 += d4 * (double)l2 / 3600000.0, ++i) {
                BatteryStats.Uid.Sensor sensor = sparseArray3.valueAt(i);
                int n8 = sparseArray3.keyAt(i);
                l2 = sensor.getSensorTime().getTotalTimeLocked(this.mRawRealtime, n) / 1000L;
                d4 = 0.0;
                switch (n8) {
                    default: {
                        for (Sensor sensor2 : sensorManager.getSensorList(-1)) {
                            if (sensor2.getHandle() != n8) continue;
                            d4 = sensor2.getPower();
                            continue block10;
                        }
                        continue block10;
                    }
                    case -10000: {
                        d4 = this.mPowerProfile.getAveragePower("gps.on");
                        l3 = l2;
                    }
                }
            }
            int n9 = UserHandle.getUserId(uid.getUid());
            if (d15 != 0.0 || uid.getUid() == 0) {
                BatterySipper batterySipper2 = new BatterySipper(BatterySipper.DrainType.APP, uid, new double[]{d15});
                batterySipper2.cpuTime = l6;
                batterySipper2.gpsTime = l3;
                batterySipper2.wifiRunningTime = l22;
                batterySipper2.cpuFgTime = l5;
                batterySipper2.wakeLockTime = l12;
                batterySipper2.mobileRxPackets = l13;
                batterySipper2.mobileTxPackets = l14;
                batterySipper2.mobileActive = l17 / 1000L;
                batterySipper2.mobileActiveCount = uid.getMobileRadioActiveCount(this.mStatsType);
                batterySipper2.wifiRxPackets = l18;
                batterySipper2.wifiTxPackets = l19;
                batterySipper2.mobileRxBytes = l15;
                batterySipper2.mobileTxBytes = l16;
                batterySipper2.wifiRxBytes = l20;
                batterySipper2.wifiTxBytes = l21;
                batterySipper2.packageWithHighestDrain = string2;
                if (uid.getUid() == 1010) {
                    this.mWifiSippers.add(batterySipper2);
                    this.mWifiPower = d15 + this.mWifiPower;
                } else if (uid.getUid() == 1002) {
                    this.mBluetoothSippers.add(batterySipper2);
                    this.mBluetoothPower = d15 + this.mBluetoothPower;
                } else if (!bl && sparseArray.get(n9) == null && UserHandle.getAppId(uid.getUid()) >= 10000) {
                    List<BatterySipper> list = this.mUserSippers.get(n9);
                    if (list == null) {
                        list = new ArrayList<BatterySipper>();
                        this.mUserSippers.put(n9, list);
                    }
                    list.add(batterySipper2);
                    if (d15 != 0.0) {
                        Double d16 = this.mUserPower.get(n9);
                        Double d17 = d16 == null ? Double.valueOf(d15) : Double.valueOf(d15 + d16);
                        this.mUserPower.put(n9, d17);
                    }
                } else {
                    this.mUsageList.add(batterySipper2);
                    if (d15 > this.mMaxPower) {
                        this.mMaxPower = d15;
                    }
                    if (d15 > this.mMaxRealPower) {
                        this.mMaxRealPower = d15;
                    }
                    this.mComputedPower = d15 + this.mComputedPower;
                }
                if (uid.getUid() == 0) {
                    batterySipper = batterySipper2;
                }
            }
            ++n4;
        }
    }

    private void processMiscUsage() {
        this.addUserUsage();
        this.addPhoneUsage();
        this.addScreenUsage();
        this.addFlashlightUsage();
        this.addWiFiUsage();
        this.addBluetoothUsage();
        this.addIdleUsage();
        if (!this.mWifiOnly) {
            this.addRadioUsage();
        }
    }

    public static byte[] readFully(FileInputStream fileInputStream) throws IOException {
        return BatteryStatsHelper.readFully(fileInputStream, fileInputStream.available());
    }

    public static byte[] readFully(FileInputStream fileInputStream, int n) throws IOException {
        int n2 = 0;
        byte[] byArray = new byte[n];
        int n3;
        while ((n3 = fileInputStream.read(byArray, n2, byArray.length - n2)) > 0) {
            int n4 = fileInputStream.available();
            if (n4 <= byArray.length - (n2 += n3)) continue;
            byte[] byArray2 = new byte[n2 + n4];
            System.arraycopy((byte[])byArray, (int)0, (byte[])byArray2, (int)0, (int)n2);
            byArray = byArray2;
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BatteryStats statsFromFile(Context var0, String var1_1) {
        var2_2 = BatteryStatsHelper.sFileXfer;
        synchronized (var2_2) {
            var4_3 = BatteryStatsHelper.makeFilePath(var0, var1_1);
            var5_4 = BatteryStatsHelper.sFileXfer.get(var4_3);
            if (var5_4 != null) {
                return var5_4;
            }
            var6_5 = null;
            var7_6 = new FileInputStream(var4_3);
            var13_7 = BatteryStatsHelper.readFully(var7_6);
            var14_8 = Parcel.obtain();
            var14_8.unmarshall(var13_7, 0, var13_7.length);
            var14_8.setDataPosition(0);
            var15_9 = BatteryStatsImpl.CREATOR.createFromParcel(var14_8);
            if (var7_6 == null) return var15_9;
            var7_6.close();
lbl19:
            // 2 sources

            return var15_9;
            catch (IOException var8_10) lbl-1000:
            // 2 sources

            {
                while (true) {
                    Log.w(BatteryStatsHelper.TAG, "Unable to read history to file", (Throwable)var8_11);
                    if (var6_5 == null) return BatteryStatsHelper.getStats(IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats")));
                    var6_5.close();
lbl29:
                    // 2 sources

                    ** do 
lbl30:
                    // 1 sources

                    return BatteryStatsHelper.getStats(IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats")));
                    catch (Throwable var9_13) lbl-1000:
                    // 2 sources

                    {
                        block21: {
                            while (true) {
                                if (var6_5 == null) throw var9_14;
                                try {}
                                catch (IOException var10_18) {
                                    throw var9_14;
                                }
                                break block21;
                                break;
                            }
                            catch (IOException var12_17) {
                                ** continue;
                            }
                        }
                        var6_5.close();
                        throw var9_14;
                    }
                    break;
                }
            }
            catch (Throwable var9_15) {
                var6_5 = var7_6;
                ** continue;
            }
            catch (IOException var8_12) {
                var6_5 = var7_6;
                ** continue;
            }
            catch (IOException var16_16) {
                ** continue;
            }
        }
    }

    public void clearStats() {
        this.mStats = null;
    }

    public void create(BatteryStats batteryStats) {
        this.mPowerProfile = new PowerProfile(this.mContext);
        this.mStats = batteryStats;
    }

    public void create(Bundle bundle) {
        if (bundle != null) {
            this.mStats = sStatsXfer;
            this.mBatteryBroadcast = sBatteryBroadcastXfer;
        }
        this.mBatteryInfo = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mPowerProfile = new PowerProfile(this.mContext);
    }

    public Intent getBatteryBroadcast() {
        if (this.mBatteryBroadcast == null && this.mCollectBatteryBroadcast) {
            this.load();
        }
        return this.mBatteryBroadcast;
    }

    public long getBatteryTimeRemaining() {
        return this.mBatteryTimeRemaining;
    }

    public long getChargeTimeRemaining() {
        return this.mChargeTimeRemaining;
    }

    public double getComputedPower() {
        return this.mComputedPower;
    }

    public double getMaxDrainedPower() {
        return this.mMaxDrainedPower;
    }

    public double getMaxPower() {
        return this.mMaxPower;
    }

    public double getMaxRealPower() {
        return this.mMaxRealPower;
    }

    public double getMinDrainedPower() {
        return this.mMinDrainedPower;
    }

    public List<BatterySipper> getMobilemsppList() {
        return this.mMobilemsppList;
    }

    public PowerProfile getPowerProfile() {
        return this.mPowerProfile;
    }

    public BatteryStats getStats() {
        if (this.mStats == null) {
            this.load();
        }
        return this.mStats;
    }

    public long getStatsPeriod() {
        return this.mStatsPeriod;
    }

    public int getStatsType() {
        return this.mStatsType;
    }

    public double getTotalPower() {
        return this.mTotalPower;
    }

    public List<BatterySipper> getUsageList() {
        return this.mUsageList;
    }

    public void refreshStats(int n, int n2) {
        SparseArray<UserHandle> sparseArray = new SparseArray<UserHandle>(1);
        sparseArray.put(n2, new UserHandle(n2));
        this.refreshStats(n, sparseArray);
    }

    public void refreshStats(int n, SparseArray<UserHandle> sparseArray) {
        this.refreshStats(n, sparseArray, 1000L * SystemClock.elapsedRealtime(), 1000L * SystemClock.uptimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void refreshStats(int n, SparseArray<UserHandle> sparseArray, long l, long l2) {
        this.getStats();
        this.mMaxPower = 0.0;
        this.mMaxRealPower = 0.0;
        this.mComputedPower = 0.0;
        this.mTotalPower = 0.0;
        this.mWifiPower = 0.0;
        this.mBluetoothPower = 0.0;
        this.mAppMobileActive = 0L;
        this.mAppWifiRunning = 0L;
        this.mUsageList.clear();
        this.mWifiSippers.clear();
        this.mBluetoothSippers.clear();
        this.mUserSippers.clear();
        this.mUserPower.clear();
        this.mMobilemsppList.clear();
        if (this.mStats == null) {
            return;
        }
        this.mStatsType = n;
        this.mRawUptime = l2;
        this.mRawRealtime = l;
        this.mBatteryUptime = this.mStats.getBatteryUptime(l2);
        this.mBatteryRealtime = this.mStats.getBatteryRealtime(l);
        this.mTypeBatteryUptime = this.mStats.computeBatteryUptime(l2, this.mStatsType);
        this.mTypeBatteryRealtime = this.mStats.computeBatteryRealtime(l, this.mStatsType);
        this.mBatteryTimeRemaining = this.mStats.computeBatteryTimeRemaining(l);
        this.mChargeTimeRemaining = this.mStats.computeChargeTimeRemaining(l);
        this.mMinDrainedPower = (double)this.mStats.getLowDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.mMaxDrainedPower = (double)this.mStats.getHighDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.processAppUsage(sparseArray);
        for (int i = 0; i < this.mUsageList.size(); ++i) {
            BatterySipper batterySipper = this.mUsageList.get(i);
            batterySipper.computeMobilemspp();
            if (batterySipper.mobilemspp == 0.0) continue;
            this.mMobilemsppList.add(batterySipper);
        }
        for (int i = 0; i < this.mUserSippers.size(); ++i) {
            List<BatterySipper> list = this.mUserSippers.valueAt(i);
            for (int j = 0; j < list.size(); ++j) {
                BatterySipper batterySipper = list.get(j);
                batterySipper.computeMobilemspp();
                if (batterySipper.mobilemspp == 0.0) continue;
                this.mMobilemsppList.add(batterySipper);
            }
        }
        Collections.sort(this.mMobilemsppList, new Comparator<BatterySipper>(){

            @Override
            public int compare(BatterySipper batterySipper, BatterySipper batterySipper2) {
                if (batterySipper.mobilemspp < batterySipper2.mobilemspp) {
                    return 1;
                }
                if (batterySipper.mobilemspp > batterySipper2.mobilemspp) {
                    return -1;
                }
                return 0;
            }
        });
        this.processMiscUsage();
        this.mTotalPower = this.mComputedPower;
        if (this.mStats.getLowDischargeAmountSinceCharge() > 1) {
            if (this.mMinDrainedPower > this.mComputedPower) {
                double d = this.mMinDrainedPower - this.mComputedPower;
                this.mTotalPower = this.mMinDrainedPower;
                this.addEntryNoTotal(BatterySipper.DrainType.UNACCOUNTED, 0L, d);
            } else if (this.mMaxDrainedPower < this.mComputedPower) {
                double d = this.mComputedPower - this.mMaxDrainedPower;
                this.addEntryNoTotal(BatterySipper.DrainType.OVERCOUNTED, 0L, d);
            }
        }
        Collections.sort(this.mUsageList);
    }

    public void refreshStats(int n, List<UserHandle> list) {
        int n2 = list.size();
        SparseArray<UserHandle> sparseArray = new SparseArray<UserHandle>(n2);
        for (int i = 0; i < n2; ++i) {
            UserHandle userHandle = list.get(i);
            sparseArray.put(userHandle.getIdentifier(), userHandle);
        }
        this.refreshStats(n, sparseArray);
    }

    public void storeState() {
        sStatsXfer = this.mStats;
        sBatteryBroadcastXfer = this.mBatteryBroadcast;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeStatsHistoryInFile(String var1_1) {
        var2_2 = BatteryStatsHelper.sFileXfer;
        synchronized (var2_2) {
            var4_3 = BatteryStatsHelper.makeFilePath(this.mContext, var1_1);
            BatteryStatsHelper.sFileXfer.put(var4_3, this.getStats());
            var6_4 = null;
            var7_5 = new FileOutputStream(var4_3);
            var13_6 = Parcel.obtain();
            this.getStats().writeToParcelWithoutUids(var13_6, 0);
            var7_5.write(var13_6.marshall());
            if (var7_5 == null) return;
            try {
                var7_5.close();
            }
            catch (IOException var14_7) {}
            ** GOTO lbl41
            catch (IOException var8_8) {}
            ** GOTO lbl-1000
            catch (Throwable var9_14) {
                var6_4 = var7_5;
                ** GOTO lbl-1000
            }
            catch (IOException var8_10) {
                var6_4 = var7_5;
            }
lbl-1000:
            // 2 sources

            {
                try {
                    Log.w(BatteryStatsHelper.TAG, "Unable to write history to file", (Throwable)var8_9);
                    if (var6_4 == null) return;
                }
                catch (Throwable var9_12) lbl-1000:
                // 2 sources

                {
                    if (var6_4 == null) throw var9_13;
                    try {
                        var6_4.close();
                    }
                    catch (IOException var10_15) {
                        throw var9_13;
                    }
                    throw var9_13;
                }
                try {
                    var6_4.close();
                }
                catch (IOException var12_11) {}
lbl41:
                // 4 sources

                return;
            }
        }
    }
}

