/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;

public class VpnProfile
implements Cloneable,
Parcelable {
    public static final Parcelable.Creator<VpnProfile> CREATOR = new Parcelable.Creator<VpnProfile>(){

        @Override
        public VpnProfile createFromParcel(Parcel parcel) {
            return new VpnProfile(parcel);
        }

        public VpnProfile[] newArray(int n) {
            return new VpnProfile[n];
        }
    };
    private static final String TAG = "VpnProfile";
    public static final int TYPE_IPSEC_HYBRID_RSA = 5;
    public static final int TYPE_IPSEC_XAUTH_PSK = 3;
    public static final int TYPE_IPSEC_XAUTH_RSA = 4;
    public static final int TYPE_L2TP_IPSEC_PSK = 1;
    public static final int TYPE_L2TP_IPSEC_RSA = 2;
    public static final int TYPE_MAX = 5;
    public static final int TYPE_PPTP;
    public String dnsServers;
    public String ipsecCaCert;
    public String ipsecIdentifier;
    public String ipsecSecret;
    public String ipsecServerCert;
    public String ipsecUserCert;
    public final String key;
    public String l2tpSecret;
    public boolean mppe;
    public String name;
    public String password;
    public String routes;
    public boolean saveLogin;
    public String searchDomains;
    public String server;
    public int type;
    public String username;

    /*
     * Enabled aggressive block sorting
     */
    public VpnProfile(Parcel parcel) {
        boolean bl = true;
        this.name = "";
        this.type = 0;
        this.server = "";
        this.username = "";
        this.password = "";
        this.dnsServers = "";
        this.searchDomains = "";
        this.routes = "";
        this.mppe = bl;
        this.l2tpSecret = "";
        this.ipsecIdentifier = "";
        this.ipsecSecret = "";
        this.ipsecUserCert = "";
        this.ipsecCaCert = "";
        this.ipsecServerCert = "";
        this.saveLogin = false;
        this.key = parcel.readString();
        this.name = parcel.readString();
        this.type = parcel.readInt();
        this.server = parcel.readString();
        this.username = parcel.readString();
        this.password = parcel.readString();
        this.dnsServers = parcel.readString();
        this.searchDomains = parcel.readString();
        this.routes = parcel.readString();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.mppe = bl2;
        this.l2tpSecret = parcel.readString();
        this.ipsecIdentifier = parcel.readString();
        this.ipsecSecret = parcel.readString();
        this.ipsecUserCert = parcel.readString();
        this.ipsecCaCert = parcel.readString();
        this.ipsecServerCert = parcel.readString();
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.saveLogin = bl;
    }

    public VpnProfile(String string2) {
        this.name = "";
        this.type = 0;
        this.server = "";
        this.username = "";
        this.password = "";
        this.dnsServers = "";
        this.searchDomains = "";
        this.routes = "";
        this.mppe = true;
        this.l2tpSecret = "";
        this.ipsecIdentifier = "";
        this.ipsecSecret = "";
        this.ipsecUserCert = "";
        this.ipsecCaCert = "";
        this.ipsecServerCert = "";
        this.saveLogin = false;
        this.key = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VpnProfile decode(String string2, byte[] byArray) {
        if (string2 == null) {
            return null;
        }
        try {
            boolean bl;
            VpnProfile vpnProfile;
            block9: {
                block8: {
                    String[] stringArray = new String(byArray, StandardCharsets.UTF_8).split("\u0000", -1);
                    if (stringArray.length < 14) return null;
                    if (stringArray.length > 15) {
                        return null;
                    }
                    vpnProfile = new VpnProfile(string2);
                    vpnProfile.name = stringArray[0];
                    vpnProfile.type = Integer.valueOf(stringArray[1]);
                    if (vpnProfile.type < 0) return null;
                    if (vpnProfile.type > 5) {
                        return null;
                    }
                    vpnProfile.server = stringArray[2];
                    vpnProfile.username = stringArray[3];
                    vpnProfile.password = stringArray[4];
                    vpnProfile.dnsServers = stringArray[5];
                    vpnProfile.searchDomains = stringArray[6];
                    vpnProfile.routes = stringArray[7];
                    vpnProfile.mppe = Boolean.valueOf(stringArray[8]);
                    vpnProfile.l2tpSecret = stringArray[9];
                    vpnProfile.ipsecIdentifier = stringArray[10];
                    vpnProfile.ipsecSecret = stringArray[11];
                    vpnProfile.ipsecUserCert = stringArray[12];
                    vpnProfile.ipsecCaCert = stringArray[13];
                    String string3 = stringArray.length > 14 ? stringArray[14] : "";
                    vpnProfile.ipsecServerCert = string3;
                    if (!vpnProfile.username.isEmpty()) break block8;
                    boolean bl2 = vpnProfile.password.isEmpty();
                    bl = false;
                    if (bl2) break block9;
                }
                bl = true;
            }
            vpnProfile.saveLogin = bl;
            return vpnProfile;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] encode() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        stringBuilder.append('\u0000').append(this.type);
        stringBuilder.append('\u0000').append(this.server);
        StringBuilder stringBuilder2 = stringBuilder.append('\u0000');
        String string2 = this.saveLogin ? this.username : "";
        stringBuilder2.append(string2);
        StringBuilder stringBuilder3 = stringBuilder.append('\u0000');
        String string3 = this.saveLogin ? this.password : "";
        stringBuilder3.append(string3);
        stringBuilder.append('\u0000').append(this.dnsServers);
        stringBuilder.append('\u0000').append(this.searchDomains);
        stringBuilder.append('\u0000').append(this.routes);
        stringBuilder.append('\u0000').append(this.mppe);
        stringBuilder.append('\u0000').append(this.l2tpSecret);
        stringBuilder.append('\u0000').append(this.ipsecIdentifier);
        stringBuilder.append('\u0000').append(this.ipsecSecret);
        stringBuilder.append('\u0000').append(this.ipsecUserCert);
        stringBuilder.append('\u0000').append(this.ipsecCaCert);
        stringBuilder.append('\u0000').append(this.ipsecServerCert);
        return stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
    }

    public boolean isValidLockdownProfile() {
        InetAddress.parseNumericAddress((String)this.server);
        String[] stringArray = this.dnsServers.split(" +");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String cfr_ignored_0 = stringArray[i];
            InetAddress.parseNumericAddress((String)this.dnsServers);
            continue;
        }
        try {
            if (TextUtils.isEmpty(this.dnsServers)) {
                Log.w(TAG, "DNS required");
                return false;
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w(TAG, "Invalid address", illegalArgumentException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeString(this.key);
        parcel.writeString(this.name);
        parcel.writeInt(this.type);
        parcel.writeString(this.server);
        parcel.writeString(this.username);
        parcel.writeString(this.password);
        parcel.writeString(this.dnsServers);
        parcel.writeString(this.searchDomains);
        parcel.writeString(this.routes);
        int n3 = this.mppe ? n2 : 0;
        parcel.writeInt(n3);
        parcel.writeString(this.l2tpSecret);
        parcel.writeString(this.ipsecIdentifier);
        parcel.writeString(this.ipsecSecret);
        parcel.writeString(this.ipsecUserCert);
        parcel.writeString(this.ipsecCaCert);
        parcel.writeString(this.ipsecServerCert);
        if (!this.saveLogin) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

