/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.location;

import android.location.LocationRequest;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.TimeUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ProviderRequest
implements Parcelable {
    public static final Parcelable.Creator<ProviderRequest> CREATOR = new Parcelable.Creator<ProviderRequest>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ProviderRequest createFromParcel(Parcel parcel) {
            int n = 1;
            ProviderRequest providerRequest = new ProviderRequest();
            if (parcel.readInt() != n) {
                n = 0;
            }
            providerRequest.reportLocation = n;
            providerRequest.interval = parcel.readLong();
            int n2 = parcel.readInt();
            int n3 = 0;
            while (n3 < n2) {
                providerRequest.locationRequests.add(LocationRequest.CREATOR.createFromParcel(parcel));
                ++n3;
            }
            return providerRequest;
        }

        public ProviderRequest[] newArray(int n) {
            return new ProviderRequest[n];
        }
    };
    public long interval = Long.MAX_VALUE;
    public List<LocationRequest> locationRequests = new ArrayList<LocationRequest>();
    public boolean reportLocation = false;

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ProviderRequest[");
        if (this.reportLocation) {
            stringBuilder.append("ON");
            stringBuilder.append(" interval=");
            TimeUtils.formatDuration(this.interval, stringBuilder);
        } else {
            stringBuilder.append("OFF");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.reportLocation ? 1 : 0;
        parcel.writeInt(n2);
        parcel.writeLong(this.interval);
        parcel.writeInt(this.locationRequests.size());
        Iterator<LocationRequest> iterator = this.locationRequests.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeToParcel(parcel, n);
        }
        return;
    }
}

