/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.location;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.INetInitiatedListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.telephony.PhoneNumberUtils;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.app.NetInitiatedActivity;
import com.android.internal.telephony.GsmAlphabet;
import java.io.UnsupportedEncodingException;

public class GpsNetInitiatedHandler {
    public static final String ACTION_NI_VERIFY = "android.intent.action.NETWORK_INITIATED_VERIFY";
    private static final boolean DEBUG = true;
    public static final int GPS_ENC_NONE = 0;
    public static final int GPS_ENC_SUPL_GSM_DEFAULT = 1;
    public static final int GPS_ENC_SUPL_UCS2 = 3;
    public static final int GPS_ENC_SUPL_UTF8 = 2;
    public static final int GPS_ENC_UNKNOWN = -1;
    public static final int GPS_NI_NEED_NOTIFY = 1;
    public static final int GPS_NI_NEED_VERIFY = 2;
    public static final int GPS_NI_PRIVACY_OVERRIDE = 4;
    public static final int GPS_NI_RESPONSE_ACCEPT = 1;
    public static final int GPS_NI_RESPONSE_DENY = 2;
    public static final int GPS_NI_RESPONSE_IGNORE = 4;
    public static final int GPS_NI_RESPONSE_NORESP = 3;
    public static final int GPS_NI_TYPE_EMERGENCY_SUPL = 4;
    public static final int GPS_NI_TYPE_UMTS_CTRL_PLANE = 3;
    public static final int GPS_NI_TYPE_UMTS_SUPL = 2;
    public static final int GPS_NI_TYPE_VOICE = 1;
    public static final String NI_EXTRA_CMD_NOTIF_ID = "notif_id";
    public static final String NI_EXTRA_CMD_RESPONSE = "response";
    public static final String NI_INTENT_KEY_DEFAULT_RESPONSE = "default_resp";
    public static final String NI_INTENT_KEY_MESSAGE = "message";
    public static final String NI_INTENT_KEY_NOTIF_ID = "notif_id";
    public static final String NI_INTENT_KEY_TIMEOUT = "timeout";
    public static final String NI_INTENT_KEY_TITLE = "title";
    public static final String NI_RESPONSE_EXTRA_CMD = "send_ni_response";
    private static final String TAG = "GpsNetInitiatedHandler";
    private static final boolean VERBOSE;
    private static boolean mIsHexInput;
    private final BroadcastReceiver mBroadcastReciever = new BroadcastReceiver(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if (string2.equals("android.intent.action.NEW_OUTGOING_CALL")) {
                String string3 = intent.getStringExtra("android.intent.extra.PHONE_NUMBER");
                GpsNetInitiatedHandler.this.setInEmergency(PhoneNumberUtils.isEmergencyNumber(string3));
                Log.v(GpsNetInitiatedHandler.TAG, "ACTION_NEW_OUTGOING_CALL - " + GpsNetInitiatedHandler.this.getInEmergency());
                return;
            } else {
                if (!string2.equals("android.location.MODE_CHANGED")) return;
                GpsNetInitiatedHandler.this.updateLocationMode();
                Log.d(GpsNetInitiatedHandler.TAG, "location enabled :" + GpsNetInitiatedHandler.this.getLocationEnabled());
                return;
            }
        }
    };
    private final Context mContext;
    private volatile boolean mIsInEmergency;
    private volatile boolean mIsLocationEnabled = false;
    private volatile boolean mIsSuplEsEnabled;
    private final LocationManager mLocationManager;
    private final INetInitiatedListener mNetInitiatedListener;
    private final PhoneStateListener mPhoneStateListener;
    private boolean mPlaySounds = false;
    private boolean mPopupImmediately = true;
    private final TelephonyManager mTelephonyManager;

    static {
        mIsHexInput = true;
    }

    public GpsNetInitiatedHandler(Context context, INetInitiatedListener iNetInitiatedListener, boolean bl) {
        this.mContext = context;
        if (iNetInitiatedListener == null) {
            throw new IllegalArgumentException("netInitiatedListener is null");
        }
        this.mNetInitiatedListener = iNetInitiatedListener;
        this.setSuplEsEnabled(bl);
        this.mLocationManager = (LocationManager)context.getSystemService("location");
        this.updateLocationMode();
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mPhoneStateListener = new PhoneStateListener(){

            @Override
            public void onCallStateChanged(int n, String string2) {
                Log.d(GpsNetInitiatedHandler.TAG, "onCallStateChanged(): state is " + n);
                if (n == 0) {
                    GpsNetInitiatedHandler.this.setInEmergency(false);
                }
            }
        };
        this.mTelephonyManager.listen(this.mPhoneStateListener, 32);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.NEW_OUTGOING_CALL");
        intentFilter.addAction("android.location.MODE_CHANGED");
        this.mContext.registerReceiver(this.mBroadcastReciever, intentFilter);
    }

    static String decodeGSMPackedString(byte[] byArray) {
        String string2;
        int n = byArray.length;
        int n2 = n * 8 / 7;
        if (n % 7 == 0 && n > 0 && byArray[n - 1] >> 1 == 0) {
            --n2;
        }
        if ((string2 = GsmAlphabet.gsm7BitPackedToString(byArray, 0, n2)) == null) {
            Log.e(TAG, "Decoding of GSM packed string failed");
            string2 = "";
        }
        return string2;
    }

    private static String decodeString(String string2, boolean bl, int n) {
        byte[] byArray = GpsNetInitiatedHandler.stringToByteArray(string2, bl);
        switch (n) {
            default: {
                Log.e(TAG, "Unknown encoding " + n + " for NI text " + string2);
                return string2;
            }
            case 0: {
                return string2;
            }
            case 1: {
                return GpsNetInitiatedHandler.decodeGSMPackedString(byArray);
            }
            case 2: {
                return GpsNetInitiatedHandler.decodeUTF8String(byArray);
            }
            case 3: {
                return GpsNetInitiatedHandler.decodeUCS2String(byArray);
            }
            case -1: 
        }
        return string2;
    }

    static String decodeUCS2String(byte[] byArray) {
        try {
            String string2 = new String(byArray, "UTF-16");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError();
        }
    }

    static String decodeUTF8String(byte[] byArray) {
        try {
            String string2 = new String(byArray, "UTF-8");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError();
        }
    }

    private static String getDialogMessage(GpsNiNotification gpsNiNotification, Context context) {
        return GpsNetInitiatedHandler.getNotifMessage(gpsNiNotification, context);
    }

    public static String getDialogTitle(GpsNiNotification gpsNiNotification, Context context) {
        return GpsNetInitiatedHandler.getNotifTitle(gpsNiNotification, context);
    }

    private Intent getDlgIntent(GpsNiNotification gpsNiNotification) {
        Intent intent = new Intent();
        String string2 = GpsNetInitiatedHandler.getDialogTitle(gpsNiNotification, this.mContext);
        String string3 = GpsNetInitiatedHandler.getDialogMessage(gpsNiNotification, this.mContext);
        intent.setFlags(0x10008000);
        intent.setClass(this.mContext, NetInitiatedActivity.class);
        intent.putExtra("notif_id", gpsNiNotification.notificationId);
        intent.putExtra(NI_INTENT_KEY_TITLE, string2);
        intent.putExtra(NI_INTENT_KEY_MESSAGE, string3);
        intent.putExtra(NI_INTENT_KEY_TIMEOUT, gpsNiNotification.timeout);
        intent.putExtra(NI_INTENT_KEY_DEFAULT_RESPONSE, gpsNiNotification.defaultResponse);
        Log.d(TAG, "generateIntent, title: " + string2 + ", message: " + string3 + ", timeout: " + gpsNiNotification.timeout);
        return intent;
    }

    private static String getNotifMessage(GpsNiNotification gpsNiNotification, Context context) {
        String string2 = context.getString(17040739);
        Object[] objectArray = new Object[]{GpsNetInitiatedHandler.decodeString(gpsNiNotification.requestorId, mIsHexInput, gpsNiNotification.requestorIdEncoding), GpsNetInitiatedHandler.decodeString(gpsNiNotification.text, mIsHexInput, gpsNiNotification.textEncoding)};
        return String.format(string2, objectArray);
    }

    private static String getNotifTicker(GpsNiNotification gpsNiNotification, Context context) {
        String string2 = context.getString(17040737);
        Object[] objectArray = new Object[]{GpsNetInitiatedHandler.decodeString(gpsNiNotification.requestorId, mIsHexInput, gpsNiNotification.requestorIdEncoding), GpsNetInitiatedHandler.decodeString(gpsNiNotification.text, mIsHexInput, gpsNiNotification.textEncoding)};
        return String.format(string2, objectArray);
    }

    private static String getNotifTitle(GpsNiNotification gpsNiNotification, Context context) {
        return String.format(context.getString(17040738), new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void handleNi(GpsNiNotification gpsNiNotification) {
        Log.d(TAG, "in handleNi () : needNotify: " + gpsNiNotification.needNotify + " needVerify: " + gpsNiNotification.needVerify + " privacyOverride: " + gpsNiNotification.privacyOverride + " mPopupImmediately: " + this.mPopupImmediately + " mInEmergency: " + this.getInEmergency());
        if (!this.getLocationEnabled() && !this.getInEmergency()) {
            try {
                this.mNetInitiatedListener.sendNiResponse(gpsNiNotification.notificationId, 4);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in sendNiResponse");
            }
        }
        if (gpsNiNotification.needNotify) {
            if (gpsNiNotification.needVerify && this.mPopupImmediately) {
                this.openNiDialog(gpsNiNotification);
            } else {
                this.setNiNotification(gpsNiNotification);
            }
        }
        if (gpsNiNotification.needVerify) {
            if (!gpsNiNotification.privacyOverride) return;
        }
        try {
            this.mNetInitiatedListener.sendNiResponse(gpsNiNotification.notificationId, 1);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in sendNiResponse");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleNiInEs(GpsNiNotification gpsNiNotification) {
        Log.d(TAG, "in handleNiInEs () : niType: " + gpsNiNotification.niType + " notificationId: " + gpsNiNotification.notificationId);
        boolean bl = gpsNiNotification.niType == 4;
        if (bl == this.getInEmergency()) {
            this.handleNi(gpsNiNotification);
            return;
        }
        try {
            this.mNetInitiatedListener.sendNiResponse(gpsNiNotification.notificationId, 4);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in sendNiResponse");
            return;
        }
    }

    private void openNiDialog(GpsNiNotification gpsNiNotification) {
        Intent intent = this.getDlgIntent(gpsNiNotification);
        Log.d(TAG, "openNiDialog, notifyId: " + gpsNiNotification.notificationId + ", requestorId: " + gpsNiNotification.requestorId + ", text: " + gpsNiNotification.text);
        this.mContext.startActivity(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setNiNotification(GpsNiNotification gpsNiNotification) {
        synchronized (this) {
            NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
            if (notificationManager != null) {
                String string2 = GpsNetInitiatedHandler.getNotifTitle(gpsNiNotification, this.mContext);
                String string3 = GpsNetInitiatedHandler.getNotifMessage(gpsNiNotification, this.mContext);
                if (string2 == null) {
                    string2 = new String();
                }
                if (string3 == null) {
                    string3 = new String();
                }
                Log.d(TAG, "setNiNotification, notifyId: " + gpsNiNotification.notificationId + ", title: " + string2 + ", message: " + string3);
                Intent intent = !this.mPopupImmediately ? this.getDlgIntent(gpsNiNotification) : new Intent();
                PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
                Notification notification = new Notification.Builder(this.mContext).setWhen(0L).setSmallIcon(17303395).setContentTitle(string2).setContentText(string3).setStyle(new Notification.BigTextStyle().bigText(string3)).setContentIntent(pendingIntent).build();
                notification.defaults = this.mPlaySounds ? 1 | notification.defaults : 0xFFFFFFFE & notification.defaults;
                notification.flags = 18;
                notification.tickerText = GpsNetInitiatedHandler.getNotifTicker(gpsNiNotification, this.mContext);
                notificationManager.notifyAsUser(null, gpsNiNotification.notificationId, notification, UserHandle.ALL);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static byte[] stringToByteArray(String string2, boolean bl) {
        int n = bl ? string2.length() / 2 : string2.length();
        byte[] byArray = new byte[n];
        if (bl) {
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)Integer.parseInt(string2.substring(i * 2, 2 + i * 2), 16);
            }
            return byArray;
        } else {
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)string2.charAt(i);
            }
        }
        return byArray;
    }

    public boolean getInEmergency() {
        boolean bl = Boolean.parseBoolean(SystemProperties.get("ril.cdma.inecmmode"));
        return this.mIsInEmergency || bl;
    }

    public boolean getLocationEnabled() {
        return this.mIsLocationEnabled;
    }

    public boolean getSuplEsEnabled() {
        return this.mIsSuplEsEnabled;
    }

    public void handleNiNotification(GpsNiNotification gpsNiNotification) {
        Log.d(TAG, "in handleNiNotification () : notificationId: " + gpsNiNotification.notificationId + " requestorId: " + gpsNiNotification.requestorId + " text: " + gpsNiNotification.text + " mIsSuplEsEnabled" + this.getSuplEsEnabled() + " mIsLocationEnabled" + this.getLocationEnabled());
        if (this.getSuplEsEnabled()) {
            this.handleNiInEs(gpsNiNotification);
            return;
        }
        this.handleNi(gpsNiNotification);
    }

    public void setInEmergency(boolean bl) {
        this.mIsInEmergency = bl;
    }

    public void setSuplEsEnabled(boolean bl) {
        this.mIsSuplEsEnabled = bl;
    }

    public void updateLocationMode() {
        this.mIsLocationEnabled = this.mLocationManager.isProviderEnabled("gps");
    }

    public static class GpsNiNotification {
        public int defaultResponse;
        public Bundle extras;
        public boolean needNotify;
        public boolean needVerify;
        public int niType;
        public int notificationId;
        public boolean privacyOverride;
        public String requestorId;
        public int requestorIdEncoding;
        public String text;
        public int textEncoding;
        public int timeout;
    }

    public static class GpsNiResponse {
        Bundle extras;
        int userResponse;
    }
}

