/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.backup;

import android.app.backup.BackupDataOutput;
import android.app.backup.BackupTransport;
import android.app.backup.RestoreDescription;
import android.app.backup.RestoreSet;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.SELinux;
import android.util.Log;
import com.android.org.bouncycastle.util.encoders.Base64;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class LocalTransport
extends BackupTransport {
    private static final long CURRENT_SET_TOKEN = 1L;
    private static final boolean DEBUG = false;
    private static final String FULL_DATA_DIR = "_full";
    private static final String INCREMENTAL_DIR = "_delta";
    static final long[] POSSIBLE_SETS = new long[]{2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L};
    private static final String TAG = "LocalTransport";
    private static final String TRANSPORT_DATA_MANAGEMENT_LABEL = "";
    private static final String TRANSPORT_DESTINATION_STRING = "Backing up to debug-only private cache";
    private static final String TRANSPORT_DIR_NAME = "com.android.internal.backup.LocalTransport";
    private Context mContext;
    private FileInputStream mCurFullRestoreStream;
    private File mCurrentSetDir;
    private File mCurrentSetFullDir;
    private File mCurrentSetIncrementalDir;
    private File mDataDir = new File(Environment.getDownloadCacheDirectory(), "backup");
    private byte[] mFullBackupBuffer;
    private BufferedOutputStream mFullBackupOutputStream;
    private byte[] mFullRestoreBuffer;
    private HashSet<String> mFullRestorePackages;
    private File mFullRestoreSetDir;
    private FileOutputStream mFullRestoreSocketStream;
    private String mFullTargetPackage;
    private int mRestorePackage = -1;
    private PackageInfo[] mRestorePackages = null;
    private File mRestoreSetDir;
    private File mRestoreSetFullDir;
    private File mRestoreSetIncrementalDir;
    private long mRestoreToken;
    private int mRestoreType;
    private ParcelFileDescriptor mSocket;
    private FileInputStream mSocketInputStream;

    public LocalTransport(Context context) {
        this.mCurrentSetDir = new File(this.mDataDir, Long.toString(1L));
        this.mCurrentSetIncrementalDir = new File(this.mCurrentSetDir, INCREMENTAL_DIR);
        this.mCurrentSetFullDir = new File(this.mCurrentSetDir, FULL_DATA_DIR);
        this.mContext = context;
        this.mCurrentSetDir.mkdirs();
        this.mCurrentSetFullDir.mkdir();
        this.mCurrentSetIncrementalDir.mkdir();
        if (!SELinux.restorecon(this.mCurrentSetDir)) {
            Log.e(TAG, "SELinux restorecon failed for " + this.mCurrentSetDir);
        }
    }

    private ArrayList<DecodedFilename> contentsByKey(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        ArrayList<DecodedFilename> arrayList = new ArrayList<DecodedFilename>();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(new DecodedFilename(fileArray[i]));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void deleteContents(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.deleteContents(file2);
                }
                file2.delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetFullRestoreState() {
        try {
            this.mCurFullRestoreStream.close();
        }
        catch (IOException iOException) {
            Log.w(TAG, "Unable to close full restore input stream");
        }
        this.mCurFullRestoreStream = null;
        this.mFullRestoreSocketStream = null;
        this.mFullRestoreBuffer = null;
    }

    private File tarballFile(String string2) {
        return new File(this.mCurrentSetFullDir, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int tearDownFullBackup() {
        if (this.mSocket == null) return 0;
        try {
            this.mFullBackupOutputStream.flush();
            this.mFullBackupOutputStream.close();
            this.mSocketInputStream = null;
            this.mFullTargetPackage = null;
            this.mSocket.close();
        }
        catch (IOException iOException) {
            return -1000;
        }
        finally {
            this.mSocket = null;
        }
        return 0;
    }

    @Override
    public int abortFullRestore() {
        if (this.mRestoreType != 2) {
            throw new IllegalStateException("abortFullRestore() but not currently restoring");
        }
        this.resetFullRestoreState();
        this.mRestoreType = 0;
        return 0;
    }

    @Override
    public void cancelFullBackup() {
        File file = this.tarballFile(this.mFullTargetPackage);
        this.tearDownFullBackup();
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public int clearBackupData(PackageInfo packageInfo) {
        File file;
        File[] fileArray;
        File file2 = new File(this.mCurrentSetIncrementalDir, packageInfo.packageName);
        File[] fileArray2 = file2.listFiles();
        if (fileArray2 != null) {
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                fileArray2[i].delete();
            }
            file2.delete();
        }
        if ((fileArray = (file = new File(this.mCurrentSetFullDir, packageInfo.packageName)).listFiles()) != null) {
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                fileArray[i].delete();
            }
            file.delete();
        }
        return 0;
    }

    @Override
    public Intent configurationIntent() {
        return null;
    }

    @Override
    public String currentDestinationString() {
        return TRANSPORT_DESTINATION_STRING;
    }

    @Override
    public Intent dataManagementIntent() {
        return null;
    }

    @Override
    public String dataManagementLabel() {
        return TRANSPORT_DATA_MANAGEMENT_LABEL;
    }

    @Override
    public int finishBackup() {
        return this.tearDownFullBackup();
    }

    @Override
    public void finishRestore() {
        if (this.mRestoreType == 2) {
            this.resetFullRestoreState();
        }
        this.mRestoreType = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public RestoreSet[] getAvailableRestoreSets() {
        long[] lArray = new long[1 + POSSIBLE_SETS.length];
        long[] lArray2 = POSSIBLE_SETS;
        int n = lArray2.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            long l = lArray2[i];
            if (new File(this.mDataDir, Long.toString(l)).exists()) {
                n3 = n2 + 1;
                lArray[n2] = l;
            } else {
                n3 = n2;
            }
            n2 = n3;
        }
        int n4 = n2 + 1;
        lArray[n2] = 1L;
        RestoreSet[] restoreSetArray = new RestoreSet[n4];
        int n5 = 0;
        while (n5 < restoreSetArray.length) {
            restoreSetArray[n5] = new RestoreSet("Local disk image", "flash", lArray[n5]);
            ++n5;
        }
        return restoreSetArray;
    }

    @Override
    public long getCurrentRestoreSet() {
        return 1L;
    }

    /*
     * Loose catch block
     */
    @Override
    public int getNextFullRestoreDataChunk(ParcelFileDescriptor parcelFileDescriptor) {
        int n;
        block11: {
            String string2;
            if (this.mRestoreType != 2) {
                throw new IllegalStateException("Asked for full restore data for non-stream package");
            }
            if (this.mCurFullRestoreStream == null) {
                string2 = this.mRestorePackages[this.mRestorePackage].packageName;
                File file = new File(this.mRestoreSetFullDir, string2);
                this.mCurFullRestoreStream = new FileInputStream(file);
                this.mFullRestoreSocketStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
                this.mFullRestoreBuffer = new byte[2048];
            }
            n = this.mCurFullRestoreStream.read(this.mFullRestoreBuffer);
            if (n < 0) {
                return -1;
            }
            break block11;
            catch (IOException iOException) {
                Log.e(TAG, "Unable to read archive for " + string2);
                return -1002;
            }
        }
        if (n == 0) {
            Log.w(TAG, "read() of archive file returned 0; treating as EOF");
            return -1;
        }
        try {
            this.mFullRestoreSocketStream.write(this.mFullRestoreBuffer, 0, n);
            return n;
        }
        catch (IOException iOException) {
            return -1000;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getRestoreData(ParcelFileDescriptor var1_1) {
        if (this.mRestorePackages == null) {
            throw new IllegalStateException("startRestore not called");
        }
        if (this.mRestorePackage < 0) {
            throw new IllegalStateException("nextRestorePackage not called");
        }
        if (this.mRestoreType != 1) {
            throw new IllegalStateException("getRestoreData(fd) for non-key/value dataset");
        }
        var2_2 = new File(this.mRestoreSetIncrementalDir, this.mRestorePackages[this.mRestorePackage].packageName);
        var3_3 = this.contentsByKey(var2_2);
        if (var3_3 == null) {
            Log.e("LocalTransport", "No keys for package: " + var2_2);
            return -1000;
        }
        var4_4 = new BackupDataOutput(var1_1.getFileDescriptor());
        for (DecodedFilename var8_6 : var3_3) {
            var9_7 = var8_6.file;
            var10_8 = new FileInputStream(var9_7);
            ** GOTO lbl24
        }
        return 0;
        {
            catch (IOException var5_11) {
                Log.e("LocalTransport", "Unable to read backup records", var5_11);
                return -1000;
            }
lbl24:
            // 1 sources

            try {
                var12_9 = (int)var9_7.length();
                var13_10 = new byte[var12_9];
                var10_8.read(var13_10);
                var4_4.writeEntityHeader(var8_6.key, var12_9);
                var4_4.writeEntityData(var13_10, var12_9);
                ** GOTO lbl-1000
            }
            finally {
                var10_8.close();
                ** GOTO lbl-1000
            }
        }
    }

    @Override
    public int initializeDevice() {
        this.deleteContents(this.mCurrentSetDir);
        return 0;
    }

    @Override
    public String name() {
        return new ComponentName(this.mContext, this.getClass()).flattenToShortString();
    }

    @Override
    public RestoreDescription nextRestorePackage() {
        block3: {
            String string2;
            if (this.mRestorePackages == null) {
                throw new IllegalStateException("startRestore not called");
            }
            boolean bl = false;
            do {
                int n;
                this.mRestorePackage = n = 1 + this.mRestorePackage;
                if (n >= this.mRestorePackages.length) break block3;
                string2 = this.mRestorePackages[this.mRestorePackage].packageName;
                String[] stringArray = new File(this.mRestoreSetIncrementalDir, string2).list();
                if (stringArray != null && stringArray.length > 0) {
                    this.mRestoreType = 1;
                    bl = true;
                }
                if (bl || new File(this.mRestoreSetFullDir, string2).length() <= 0L) continue;
                this.mRestoreType = 2;
                this.mCurFullRestoreStream = null;
                bl = true;
            } while (!bl);
            return new RestoreDescription(string2, this.mRestoreType);
        }
        return RestoreDescription.NO_MORE_PACKAGES;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int performBackup(PackageInfo var1_1, ParcelFileDescriptor var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [10 : 213->218)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int performFullBackup(PackageInfo packageInfo, ParcelFileDescriptor parcelFileDescriptor) {
        if (this.mSocket != null) {
            Log.e(TAG, "Attempt to initiate full backup while one is in progress");
            return -1000;
        }
        try {
            this.mSocket = ParcelFileDescriptor.dup(parcelFileDescriptor.getFileDescriptor());
            this.mSocketInputStream = new FileInputStream(this.mSocket.getFileDescriptor());
            this.mFullTargetPackage = packageInfo.packageName;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Unable to process socket for full backup");
            return -1000;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.tarballFile(this.mFullTargetPackage));
            this.mFullBackupOutputStream = new BufferedOutputStream(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return -1000;
        }
        this.mFullBackupBuffer = new byte[4096];
        return 0;
    }

    @Override
    public long requestBackupTime() {
        return 0L;
    }

    @Override
    public long requestFullBackupTime() {
        return 0L;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int sendBackupData(int n) {
        if (this.mFullBackupBuffer == null) {
            Log.w(TAG, "Attempted sendBackupData before performFullBackup");
            return -1000;
        }
        if (n > this.mFullBackupBuffer.length) {
            this.mFullBackupBuffer = new byte[n];
        }
        while (n > 0) {
            int n2;
            try {
                n2 = this.mSocketInputStream.read(this.mFullBackupBuffer, 0, n);
                if (n2 < 0) {
                    Log.w(TAG, "Unexpected EOD; failing backup");
                    return -1000;
                }
            }
            catch (IOException iOException) {
                Log.e(TAG, "Error handling backup data for " + this.mFullTargetPackage);
                return -1000;
            }
            {
                this.mFullBackupOutputStream.write(this.mFullBackupBuffer, 0, n2);
                n -= n2;
                continue;
            }
            break;
        }
        return 0;
    }

    @Override
    public int startRestore(long l, PackageInfo[] packageInfoArray) {
        this.mRestorePackages = packageInfoArray;
        this.mRestorePackage = -1;
        this.mRestoreToken = l;
        this.mRestoreSetDir = new File(this.mDataDir, Long.toString(l));
        this.mRestoreSetIncrementalDir = new File(this.mRestoreSetDir, INCREMENTAL_DIR);
        this.mRestoreSetFullDir = new File(this.mRestoreSetDir, FULL_DATA_DIR);
        return 0;
    }

    @Override
    public String transportDirName() {
        return TRANSPORT_DIR_NAME;
    }

    static class DecodedFilename
    implements Comparable<DecodedFilename> {
        public File file;
        public String key;

        public DecodedFilename(File file) {
            this.file = file;
            this.key = new String(Base64.decode((String)file.getName()));
        }

        @Override
        public int compareTo(DecodedFilename decodedFilename) {
            return this.key.compareTo(decodedFilename.key);
        }
    }
}

