/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.os.Bundle;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;

public class PlatLogoActivity
extends Activity {
    static final int[] FLAVORS = new int[]{-6543440, -4560696, -26624, -18611, -1023342, -476208, -5262293, -3285959, -5317, -3722, -8825528, -6190977};
    PathInterpolator mInterpolator = new PathInterpolator(0.0f, 0.0f, 0.5f, 1.0f);
    int mKeyCount;
    FrameLayout mLayout;
    int mTapCount;

    static int newColorIndex() {
        return 2 * (int)(Math.random() * (double)FLAVORS.length / 2.0);
    }

    Drawable makeRipple() {
        int n = PlatLogoActivity.newColorIndex();
        ShapeDrawable shapeDrawable = new ShapeDrawable(new OvalShape());
        shapeDrawable.getPaint().setColor(FLAVORS[n]);
        return new RippleDrawable(ColorStateList.valueOf(FLAVORS[n + 1]), shapeDrawable, null);
    }

    @Override
    public void onAttachedToWindow() {
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        float f = displayMetrics.density;
        final int n = (int)(Math.min((float)Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels), 600.0f * f) - 100.0f * f);
        final View view = new View(this){
            Paint mPaint;
            Path mShadow;
            {
                super(context);
                this.mPaint = new Paint();
                this.mShadow = new Path();
            }

            @Override
            public void onAttachedToWindow() {
                super.onAttachedToWindow();
                this.setWillNotDraw(false);
                this.setOutlineProvider(new ViewOutlineProvider(){

                    @Override
                    public void getOutline(View view, Outline outline) {
                        outline.setRect(0, this.getHeight() / 2, this.getWidth(), this.getHeight());
                    }
                });
            }

            @Override
            public void onDraw(Canvas canvas) {
                int n3 = canvas.getWidth();
                int n2 = canvas.getHeight() / 2;
                canvas.translate(0.0f, n2);
                GradientDrawable gradientDrawable = new GradientDrawable();
                gradientDrawable.setOrientation(GradientDrawable.Orientation.LEFT_RIGHT);
                gradientDrawable.setGradientCenter(0.75f * (float)n3, 0.0f);
                gradientDrawable.setColors(new int[]{-1, -5592406});
                gradientDrawable.setBounds(0, 0, n3, n2);
                gradientDrawable.draw(canvas);
                this.mPaint.setColor(-5592406);
                this.mShadow.reset();
                this.mShadow.moveTo(0.0f, 0.0f);
                this.mShadow.lineTo(n3, 0.0f);
                this.mShadow.lineTo(n3, (float)(n / 2) + 1.5f * (float)n3);
                this.mShadow.lineTo(0.0f, n / 2);
                this.mShadow.close();
                canvas.drawPath(this.mShadow, this.mPaint);
            }
        };
        this.mLayout.addView(view, new FrameLayout.LayoutParams((int)(32.0f * f), -1, 1));
        view.setAlpha(0.0f);
        final ImageView imageView = new ImageView(this);
        imageView.setTranslationZ(20.0f);
        imageView.setScaleX(0.0f);
        imageView.setScaleY(0.0f);
        final Drawable drawable2 = this.getDrawable(17303079);
        drawable2.setAlpha(0);
        imageView.setImageDrawable(drawable2);
        imageView.setBackground(this.makeRipple());
        imageView.setClickable(true);
        ShapeDrawable shapeDrawable = new ShapeDrawable(new OvalShape());
        shapeDrawable.getPaint().setColor(0x10FFFFFF);
        shapeDrawable.setBounds((int)(0.15f * (float)n), (int)(0.15f * (float)n), (int)(0.6f * (float)n), (int)(0.6f * (float)n));
        imageView.getOverlay().add(shapeDrawable);
        imageView.setOnClickListener(new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onClick(View view2) {
                if (PlatLogoActivity.this.mTapCount == 0) {
                    imageView.animate().translationZ(40.0f).scaleX(1.0f).scaleY(1.0f).setInterpolator(PlatLogoActivity.this.mInterpolator).setDuration(700L).setStartDelay(500L).start();
                    ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)drawable2, "alpha", 0, 255);
                    objectAnimator.setInterpolator(PlatLogoActivity.this.mInterpolator);
                    objectAnimator.setStartDelay(1000L);
                    objectAnimator.start();
                    view.animate().translationZ(20.0f).alpha(1.0f).setInterpolator(PlatLogoActivity.this.mInterpolator).setDuration(700L).setStartDelay(750L).start();
                    imageView.setOnLongClickListener(new View.OnLongClickListener(){

                        @Override
                        public boolean onLongClick(View view) {
                            if (PlatLogoActivity.this.mTapCount < 5) {
                                return false;
                            }
                            ContentResolver contentResolver = PlatLogoActivity.this.getContentResolver();
                            if (Settings.System.getLong(contentResolver, "egg_mode", 0L) == 0L) {
                                Settings.System.putLong(contentResolver, "egg_mode", System.currentTimeMillis());
                            }
                            imageView.post(new Runnable(){

                                /*
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                @Override
                                public void run() {
                                    try {
                                        PlatLogoActivity.this.startActivity(new Intent("android.intent.action.MAIN").setFlags(0x10808000).addCategory("com.android.internal.category.PLATLOGO"));
                                    }
                                    catch (ActivityNotFoundException activityNotFoundException) {
                                        Log.e("PlatLogoActivity", "No more eggs.");
                                    }
                                    PlatLogoActivity.this.finish();
                                }
                            });
                            return true;
                        }
                    });
                } else {
                    imageView.setBackground(PlatLogoActivity.this.makeRipple());
                }
                PlatLogoActivity platLogoActivity = PlatLogoActivity.this;
                platLogoActivity.mTapCount = 1 + platLogoActivity.mTapCount;
            }
        });
        imageView.setFocusable(true);
        imageView.requestFocus();
        imageView.setOnKeyListener(new View.OnKeyListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                block4: {
                    block3: {
                        if (n == 4 || keyEvent.getAction() != 0) return false;
                        PlatLogoActivity platLogoActivity = PlatLogoActivity.this;
                        platLogoActivity.mKeyCount = 1 + platLogoActivity.mKeyCount;
                        if (PlatLogoActivity.this.mKeyCount <= 2) break block3;
                        if (PlatLogoActivity.this.mTapCount <= 5) break block4;
                        imageView.performLongClick();
                    }
                    return true;
                }
                imageView.performClick();
                return true;
            }
        });
        this.mLayout.addView((View)imageView, new FrameLayout.LayoutParams(n, n, 17));
        imageView.animate().scaleX(0.3f).scaleY(0.3f).setInterpolator(this.mInterpolator).setDuration(500L).setStartDelay(800L).start();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mLayout = new FrameLayout(this);
        this.setContentView(this.mLayout);
    }
}

