/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.ims.ImsStreamMediaProfile;

public class ImsCallProfile
implements Parcelable {
    public static final int CALL_TYPE_VIDEO_N_VOICE = 3;
    public static final int CALL_TYPE_VOICE = 2;
    public static final int CALL_TYPE_VOICE_N_VIDEO = 1;
    public static final int CALL_TYPE_VS = 8;
    public static final int CALL_TYPE_VS_RX = 10;
    public static final int CALL_TYPE_VS_TX = 9;
    public static final int CALL_TYPE_VT = 4;
    public static final int CALL_TYPE_VT_NODIR = 7;
    public static final int CALL_TYPE_VT_RX = 6;
    public static final int CALL_TYPE_VT_TX = 5;
    public static final Parcelable.Creator<ImsCallProfile> CREATOR = new Parcelable.Creator<ImsCallProfile>(){

        @Override
        public ImsCallProfile createFromParcel(Parcel parcel) {
            return new ImsCallProfile(parcel);
        }

        public ImsCallProfile[] newArray(int n) {
            return new ImsCallProfile[n];
        }
    };
    public static final int DIALSTRING_NORMAL = 0;
    public static final int DIALSTRING_SS_CONF = 1;
    public static final int DIALSTRING_USSD = 2;
    public static final String EXTRA_CALL_MODE_CHANGEABLE = "call_mode_changeable";
    public static final String EXTRA_CNA = "cna";
    public static final String EXTRA_CNAP = "cnap";
    public static final String EXTRA_CONFERENCE = "conference";
    public static final String EXTRA_CONFERENCE_AVAIL = "conference_avail";
    public static final String EXTRA_DIALSTRING = "dialstring";
    public static final String EXTRA_E_CALL = "e_call";
    public static final String EXTRA_OI = "oi";
    public static final String EXTRA_OIR = "oir";
    public static final String EXTRA_REMOTE_URI = "remote_uri";
    public static final String EXTRA_USSD = "ussd";
    public static final String EXTRA_VMS = "vms";
    public static final int OIR_DEFAULT = 0;
    public static final int OIR_PRESENTATION_NOT_RESTRICTED = 2;
    public static final int OIR_PRESENTATION_RESTRICTED = 1;
    public static final int SERVICE_TYPE_EMERGENCY = 2;
    public static final int SERVICE_TYPE_NONE = 0;
    public static final int SERVICE_TYPE_NORMAL = 1;
    private static final String TAG = "ImsCallProfile";
    public Bundle mCallExtras;
    public int mCallType;
    public ImsStreamMediaProfile mMediaProfile;
    public int mServiceType;

    public ImsCallProfile() {
        this.mServiceType = 1;
        this.mCallType = 1;
        this.mCallExtras = new Bundle();
        this.mMediaProfile = new ImsStreamMediaProfile();
    }

    public ImsCallProfile(int n, int n2) {
        this.mServiceType = n;
        this.mCallType = n2;
        this.mCallExtras = new Bundle();
        this.mMediaProfile = new ImsStreamMediaProfile();
    }

    public ImsCallProfile(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public static int OIRToPresentation(int n) {
        switch (n) {
            default: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 2: 
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getCallTypeFromVideoState(int n) {
        int n2 = 4;
        boolean bl = ImsCallProfile.isVideoStateSet(n, 1);
        boolean bl2 = ImsCallProfile.isVideoStateSet(n, 2);
        if (ImsCallProfile.isVideoStateSet(n, n2)) {
            return 7;
        }
        if (bl && !bl2) {
            return 5;
        }
        if (!bl && bl2) {
            return 6;
        }
        if (!bl) return 2;
        if (bl2) return n2;
        return 2;
    }

    public static int getVideoStateFromCallType(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 7: {
                return 7;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 4: 
        }
        return 3;
    }

    private static boolean isVideoStateSet(int n, int n2) {
        return (n & n2) == n2;
    }

    public static int presentationToOIR(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 1: 
        }
        return 2;
    }

    private void readFromParcel(Parcel parcel) {
        this.mServiceType = parcel.readInt();
        this.mCallType = parcel.readInt();
        this.mCallExtras = (Bundle)parcel.readParcelable(null);
        this.mMediaProfile = (ImsStreamMediaProfile)parcel.readParcelable(null);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getCallExtra(String string2) {
        return this.getCallExtra(string2, "");
    }

    public String getCallExtra(String string2, String string3) {
        if (this.mCallExtras == null) {
            return string3;
        }
        return this.mCallExtras.getString(string2, string3);
    }

    public boolean getCallExtraBoolean(String string2) {
        return this.getCallExtraBoolean(string2, false);
    }

    public boolean getCallExtraBoolean(String string2, boolean bl) {
        if (this.mCallExtras == null) {
            return bl;
        }
        return this.mCallExtras.getBoolean(string2, bl);
    }

    public int getCallExtraInt(String string2) {
        return this.getCallExtraInt(string2, -1);
    }

    public int getCallExtraInt(String string2, int n) {
        if (this.mCallExtras == null) {
            return n;
        }
        return this.mCallExtras.getInt(string2, n);
    }

    public void setCallExtra(String string2, String string3) {
        if (this.mCallExtras != null) {
            this.mCallExtras.putString(string2, string3);
        }
    }

    public void setCallExtraBoolean(String string2, boolean bl) {
        if (this.mCallExtras != null) {
            this.mCallExtras.putBoolean(string2, bl);
        }
    }

    public void setCallExtraInt(String string2, int n) {
        if (this.mCallExtras != null) {
            this.mCallExtras.putInt(string2, n);
        }
    }

    public String toString() {
        return "{ serviceType=" + this.mServiceType + ", callType=" + this.mCallType + ", callExtras=" + this.mCallExtras.toString() + ", mediaProfile=" + this.mMediaProfile.toString() + " }";
    }

    public void updateCallExtras(ImsCallProfile imsCallProfile) {
        this.mCallExtras.clear();
        this.mCallExtras = (Bundle)imsCallProfile.mCallExtras.clone();
    }

    public void updateCallType(ImsCallProfile imsCallProfile) {
        this.mCallType = imsCallProfile.mCallType;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mServiceType);
        parcel.writeInt(this.mCallType);
        parcel.writeParcelable(this.mCallExtras, 0);
        parcel.writeParcelable(this.mMediaProfile, 0);
    }
}

