/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.DatePickerController;
import android.widget.ListView;
import android.widget.OnDateChangedListener;
import android.widget.TextViewWithCircularIndicator;

class YearPickerView
extends ListView
implements AdapterView.OnItemClickListener,
OnDateChangedListener {
    private YearAdapter mAdapter;
    private int mChildSize;
    private DatePickerController mController;
    private int mSelectedPosition = -1;
    private int mViewSize;
    private int mYearSelectedCircleColor;

    public YearPickerView(Context context) {
        this(context, null);
    }

    public YearPickerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842868);
    }

    public YearPickerView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public YearPickerView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.setLayoutParams(new AbsListView.LayoutParams(-1, -2));
        Resources resources = context.getResources();
        this.mViewSize = resources.getDimensionPixelOffset(17105036);
        this.mChildSize = resources.getDimensionPixelOffset(17105038);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        this.setPadding(0, resources.getDimensionPixelSize(17105037), 0, 0);
        this.setOnItemClickListener(this);
        this.setDividerHeight(0);
    }

    private void updateAdapterData() {
        this.mAdapter.clear();
        int n = this.mController.getMaxYear();
        for (int i = this.mController.getMinYear(); i <= n; ++i) {
            this.mAdapter.add(i);
        }
    }

    public int getFirstPositionOffset() {
        View view = this.getChildAt(0);
        if (view == null) {
            return 0;
        }
        return view.getTop();
    }

    public int getYearSelectedCircleColor() {
        return this.mYearSelectedCircleColor;
    }

    public void init(DatePickerController datePickerController) {
        this.mController = datePickerController;
        this.mController.registerOnDateChangedListener(this);
        this.mAdapter = new YearAdapter(this.getContext(), 17367306);
        this.updateAdapterData();
        this.setAdapter(this.mAdapter);
        this.onDateChanged();
    }

    @Override
    public void onDateChanged() {
        this.updateAdapterData();
        this.mAdapter.notifyDataSetChanged();
        this.postSetSelectionCentered(this.mController.getSelectedDay().get(1) - this.mController.getMinYear());
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        if (accessibilityEvent.getEventType() == 4096) {
            accessibilityEvent.setFromIndex(0);
            accessibilityEvent.setToIndex(0);
        }
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        this.mController.tryVibrate();
        if (n != this.mSelectedPosition) {
            this.mSelectedPosition = n;
            this.mAdapter.notifyDataSetChanged();
        }
        this.mController.onYearSelected((Integer)this.mAdapter.getItem(n));
    }

    public void postSetSelectionCentered(int n) {
        this.postSetSelectionFromTop(n, this.mViewSize / 2 - this.mChildSize / 2);
    }

    public void postSetSelectionFromTop(final int n, final int n2) {
        this.post(new Runnable(){

            @Override
            public void run() {
                YearPickerView.this.setSelectionFromTop(n, n2);
                YearPickerView.this.requestLayout();
            }
        });
    }

    void setItemTextAppearance(int n) {
        this.mAdapter.setItemTextAppearance(n);
    }

    public void setYearSelectedCircleColor(int n) {
        if (n != this.mYearSelectedCircleColor) {
            this.mYearSelectedCircleColor = n;
        }
        this.requestLayout();
    }

    private class YearAdapter
    extends ArrayAdapter<Integer> {
        int mItemTextAppearanceResId;

        public YearAdapter(Context context, int n) {
            super(context, n);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            boolean bl = true;
            TextViewWithCircularIndicator textViewWithCircularIndicator = (TextViewWithCircularIndicator)super.getView(n, view, viewGroup);
            textViewWithCircularIndicator.setTextAppearance(this.getContext(), this.mItemTextAppearanceResId);
            textViewWithCircularIndicator.requestLayout();
            int n2 = (Integer)this.getItem(n);
            if (YearPickerView.this.mController.getSelectedDay().get(bl ? 1 : 0) != n2) {
                bl = false;
            }
            textViewWithCircularIndicator.setDrawIndicator(bl);
            if (bl) {
                textViewWithCircularIndicator.setCircleColor(YearPickerView.this.mYearSelectedCircleColor);
            }
            return textViewWithCircularIndicator;
        }

        public void setItemTextAppearance(int n) {
            this.mItemTextAppearanceResId = n;
        }
    }
}

