/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActionBar;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.CollapsibleActionView;
import android.view.ContextThemeWrapper;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ActionMenuPresenter;
import android.widget.ActionMenuView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RtlSpacingHelper;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import com.android.internal.widget.DecorToolbar;
import com.android.internal.widget.ToolbarWidgetWrapper;
import java.util.ArrayList;
import java.util.List;

public class Toolbar
extends ViewGroup {
    private static final String TAG = "Toolbar";
    private MenuPresenter.Callback mActionMenuPresenterCallback;
    private int mButtonGravity;
    private ImageButton mCollapseButtonView;
    private Drawable mCollapseIcon;
    private boolean mCollapsible;
    private final RtlSpacingHelper mContentInsets = new RtlSpacingHelper();
    private boolean mEatingTouch;
    View mExpandedActionView;
    private ExpandedActionViewMenuPresenter mExpandedMenuPresenter;
    private int mGravity = 8388627;
    private ImageView mLogoView;
    private int mMaxButtonHeight;
    private MenuBuilder.Callback mMenuBuilderCallback;
    private ActionMenuView mMenuView;
    private final ActionMenuView.OnMenuItemClickListener mMenuViewItemClickListener;
    private int mNavButtonStyle;
    private ImageButton mNavButtonView;
    private OnMenuItemClickListener mOnMenuItemClickListener;
    private ActionMenuPresenter mOuterActionMenuPresenter;
    private Context mPopupContext;
    private int mPopupTheme;
    private final Runnable mShowOverflowMenuRunnable;
    private CharSequence mSubtitleText;
    private int mSubtitleTextAppearance;
    private int mSubtitleTextColor;
    private TextView mSubtitleTextView;
    private final int[] mTempMargins;
    private final ArrayList<View> mTempViews = new ArrayList();
    private int mTitleMarginBottom;
    private int mTitleMarginEnd;
    private int mTitleMarginStart;
    private int mTitleMarginTop;
    private CharSequence mTitleText;
    private int mTitleTextAppearance;
    private int mTitleTextColor;
    private TextView mTitleTextView;
    private ToolbarWidgetWrapper mWrapper;

    public Toolbar(Context context) {
        this(context, null);
    }

    public Toolbar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843946);
    }

    public Toolbar(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public Toolbar(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        CharSequence charSequence;
        CharSequence charSequence2;
        int n3;
        int n4;
        int n5;
        int n6;
        Runnable runnable;
        ActionMenuView.OnMenuItemClickListener onMenuItemClickListener;
        this.mTempMargins = new int[2];
        this.mMenuViewItemClickListener = onMenuItemClickListener = new ActionMenuView.OnMenuItemClickListener(){

            @Override
            public boolean onMenuItemClick(MenuItem menuItem) {
                if (Toolbar.this.mOnMenuItemClickListener != null) {
                    return Toolbar.this.mOnMenuItemClickListener.onMenuItemClick(menuItem);
                }
                return false;
            }
        };
        this.mShowOverflowMenuRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                Toolbar.this.showOverflowMenu();
            }
        };
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Toolbar, n, n2);
        this.mTitleTextAppearance = typedArray.getResourceId(3, 0);
        this.mSubtitleTextAppearance = typedArray.getResourceId(4, 0);
        this.mNavButtonStyle = typedArray.getResourceId(18, 0);
        this.mGravity = typedArray.getInteger(0, this.mGravity);
        this.mButtonGravity = typedArray.getInteger(19, 48);
        this.mTitleMarginBottom = n6 = typedArray.getDimensionPixelOffset(12, 0);
        this.mTitleMarginTop = n6;
        this.mTitleMarginEnd = n6;
        this.mTitleMarginStart = n6;
        int n7 = typedArray.getDimensionPixelOffset(13, -1);
        if (n7 >= 0) {
            this.mTitleMarginStart = n7;
        }
        if ((n5 = typedArray.getDimensionPixelOffset(14, -1)) >= 0) {
            this.mTitleMarginEnd = n5;
        }
        if ((n4 = typedArray.getDimensionPixelOffset(15, -1)) >= 0) {
            this.mTitleMarginTop = n4;
        }
        if ((n3 = typedArray.getDimensionPixelOffset(16, -1)) >= 0) {
            this.mTitleMarginBottom = n3;
        }
        this.mMaxButtonHeight = typedArray.getDimensionPixelSize(17, -1);
        int n8 = typedArray.getDimensionPixelOffset(5, Integer.MIN_VALUE);
        int n9 = typedArray.getDimensionPixelOffset(6, Integer.MIN_VALUE);
        int n10 = typedArray.getDimensionPixelSize(7, 0);
        int n11 = typedArray.getDimensionPixelSize(8, 0);
        this.mContentInsets.setAbsolute(n10, n11);
        if (n8 != Integer.MIN_VALUE || n9 != Integer.MIN_VALUE) {
            this.mContentInsets.setRelative(n8, n9);
        }
        this.mCollapseIcon = typedArray.getDrawable(20);
        CharSequence charSequence3 = typedArray.getText(1);
        if (!TextUtils.isEmpty(charSequence3)) {
            this.setTitle(charSequence3);
        }
        if (!TextUtils.isEmpty(charSequence2 = typedArray.getText(2))) {
            this.setSubtitle(charSequence2);
        }
        this.mPopupContext = this.mContext;
        this.setPopupTheme(typedArray.getResourceId(9, 0));
        Drawable drawable2 = typedArray.getDrawable(10);
        if (drawable2 != null) {
            this.setNavigationIcon(drawable2);
        }
        if (!TextUtils.isEmpty(charSequence = typedArray.getText(11))) {
            this.setNavigationContentDescription(charSequence);
        }
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addCustomViewsWithGravity(List<View> list, int n) {
        int n2 = 1;
        if (this.getLayoutDirection() != n2) {
            n2 = 0;
        }
        int n3 = this.getChildCount();
        int n4 = Gravity.getAbsoluteGravity(n, this.getLayoutDirection());
        list.clear();
        if (n2 != 0) {
            for (int i = n3 - 1; i >= 0; --i) {
                View view = this.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (layoutParams.mViewType != 0 || !this.shouldLayout(view) || this.getChildHorizontalGravity(layoutParams.gravity) != n4) continue;
                list.add(view);
            }
            return;
        } else {
            for (int i = 0; i < n3; ++i) {
                View view = this.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (layoutParams.mViewType != 0 || !this.shouldLayout(view) || this.getChildHorizontalGravity(layoutParams.gravity) != n4) continue;
                list.add(view);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addSystemView(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        ViewGroup.LayoutParams layoutParams2 = layoutParams == null ? this.generateDefaultLayoutParams() : (!this.checkLayoutParams(layoutParams) ? this.generateLayoutParams(layoutParams) : (LayoutParams)layoutParams);
        ((LayoutParams)layoutParams2).mViewType = 1;
        this.addView(view, layoutParams2);
    }

    private void ensureCollapseButtonView() {
        if (this.mCollapseButtonView == null) {
            this.mCollapseButtonView = new ImageButton(this.getContext(), null, 0, this.mNavButtonStyle);
            this.mCollapseButtonView.setImageDrawable(this.mCollapseIcon);
            ViewGroup.LayoutParams layoutParams = this.generateDefaultLayoutParams();
            ((LayoutParams)layoutParams).gravity = 0x800003 | 0x70 & this.mButtonGravity;
            ((LayoutParams)layoutParams).mViewType = 2;
            this.mCollapseButtonView.setLayoutParams(layoutParams);
            this.mCollapseButtonView.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View view) {
                    Toolbar.this.collapseActionView();
                }
            });
        }
    }

    private void ensureLogoView() {
        if (this.mLogoView == null) {
            this.mLogoView = new ImageView(this.getContext());
        }
    }

    private void ensureMenu() {
        this.ensureMenuView();
        if (this.mMenuView.peekMenu() == null) {
            MenuBuilder menuBuilder = (MenuBuilder)this.mMenuView.getMenu();
            if (this.mExpandedMenuPresenter == null) {
                this.mExpandedMenuPresenter = new ExpandedActionViewMenuPresenter();
            }
            this.mMenuView.setExpandedActionViewsExclusive(true);
            menuBuilder.addMenuPresenter(this.mExpandedMenuPresenter, this.mPopupContext);
        }
    }

    private void ensureMenuView() {
        if (this.mMenuView == null) {
            this.mMenuView = new ActionMenuView(this.getContext());
            this.mMenuView.setPopupTheme(this.mPopupTheme);
            this.mMenuView.setOnMenuItemClickListener(this.mMenuViewItemClickListener);
            this.mMenuView.setMenuCallbacks(this.mActionMenuPresenterCallback, this.mMenuBuilderCallback);
            ViewGroup.LayoutParams layoutParams = this.generateDefaultLayoutParams();
            ((LayoutParams)layoutParams).gravity = 0x800005 | 0x70 & this.mButtonGravity;
            this.mMenuView.setLayoutParams(layoutParams);
            this.addSystemView(this.mMenuView);
        }
    }

    private void ensureNavButtonView() {
        if (this.mNavButtonView == null) {
            this.mNavButtonView = new ImageButton(this.getContext(), null, 0, this.mNavButtonStyle);
            ViewGroup.LayoutParams layoutParams = this.generateDefaultLayoutParams();
            ((LayoutParams)layoutParams).gravity = 0x800003 | 0x70 & this.mButtonGravity;
            this.mNavButtonView.setLayoutParams(layoutParams);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getChildHorizontalGravity(int n) {
        int n2 = this.getLayoutDirection();
        int n3 = 7 & Gravity.getAbsoluteGravity(n, n2);
        switch (n3) {
            default: {
                if (n2 != 1) return 3;
                return 5;
            }
            case 1: 
            case 3: 
            case 5: 
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getChildTop(View view, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n6 = view.getMeasuredHeight();
        int n7 = n > 0 ? (n6 - n) / 2 : 0;
        switch (this.getChildVerticalGravity(layoutParams.gravity)) {
            default: {
                n5 = this.getPaddingTop();
                n4 = this.getPaddingBottom();
                n3 = this.getHeight();
                n2 = (n3 - n5 - n4 - n6) / 2;
                if (n2 >= layoutParams.topMargin) break;
                n2 = layoutParams.topMargin;
                return n5 + n2;
            }
            case 48: {
                return this.getPaddingTop() - n7;
            }
            case 80: {
                return this.getHeight() - this.getPaddingBottom() - n6 - layoutParams.bottomMargin - n7;
            }
        }
        int n8 = n3 - n4 - n6 - n2 - n5;
        if (n8 >= layoutParams.bottomMargin) return n5 + n2;
        n2 = Math.max(0, n2 - (layoutParams.bottomMargin - n8));
        return n5 + n2;
    }

    private int getChildVerticalGravity(int n) {
        int n2 = n & 0x70;
        switch (n2) {
            default: {
                n2 = 0x70 & this.mGravity;
            }
            case 16: 
            case 48: 
            case 80: 
        }
        return n2;
    }

    private int getHorizontalMargins(View view) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        return marginLayoutParams.getMarginStart() + marginLayoutParams.getMarginEnd();
    }

    private MenuInflater getMenuInflater() {
        return new MenuInflater(this.getContext());
    }

    private int getVerticalMargins(View view) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        return marginLayoutParams.topMargin + marginLayoutParams.bottomMargin;
    }

    private int getViewListMeasuredWidth(List<View> list, int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = 0;
        int n4 = list.size();
        for (int i = 0; i < n4; ++i) {
            View view = list.get(i);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n5 = layoutParams.leftMargin - n;
            int n6 = layoutParams.rightMargin - n2;
            int n7 = Math.max(0, n5);
            int n8 = Math.max(0, n6);
            n = Math.max(0, -n5);
            n2 = Math.max(0, -n6);
            n3 += n8 + (n7 + view.getMeasuredWidth());
        }
        return n3;
    }

    private static boolean isCustomView(View view) {
        return ((LayoutParams)view.getLayoutParams()).mViewType == 0;
    }

    private int layoutChildLeft(View view, int n, int[] nArray, int n2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n3 = layoutParams.leftMargin - nArray[0];
        int n4 = n + Math.max(0, n3);
        nArray[0] = Math.max(0, -n3);
        int n5 = this.getChildTop(view, n2);
        int n6 = view.getMeasuredWidth();
        view.layout(n4, n5, n4 + n6, n5 + view.getMeasuredHeight());
        return n4 + (n6 + layoutParams.rightMargin);
    }

    private int layoutChildRight(View view, int n, int[] nArray, int n2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n3 = layoutParams.rightMargin - nArray[1];
        int n4 = n - Math.max(0, n3);
        nArray[1] = Math.max(0, -n3);
        int n5 = this.getChildTop(view, n2);
        int n6 = view.getMeasuredWidth();
        view.layout(n4 - n6, n5, n4, n5 + view.getMeasuredHeight());
        return n4 - (n6 + layoutParams.leftMargin);
    }

    private int measureChildCollapseMargins(View view, int n, int n2, int n3, int n4, int[] nArray) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        int n5 = marginLayoutParams.leftMargin - nArray[0];
        int n6 = marginLayoutParams.rightMargin - nArray[1];
        int n7 = Math.max(0, n5) + Math.max(0, n6);
        nArray[0] = Math.max(0, -n5);
        nArray[1] = Math.max(0, -n6);
        view.measure(Toolbar.getChildMeasureSpec(n, n2 + (n7 + (this.mPaddingLeft + this.mPaddingRight)), marginLayoutParams.width), Toolbar.getChildMeasureSpec(n3, n4 + (this.mPaddingTop + this.mPaddingBottom + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin), marginLayoutParams.height));
        return n7 + view.getMeasuredWidth();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureChildConstrained(View view, int n, int n2, int n3, int n4, int n5) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        int n6 = Toolbar.getChildMeasureSpec(n, n2 + (this.mPaddingLeft + this.mPaddingRight + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin), marginLayoutParams.width);
        int n7 = Toolbar.getChildMeasureSpec(n3, n4 + (this.mPaddingTop + this.mPaddingBottom + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin), marginLayoutParams.height);
        int n8 = View.MeasureSpec.getMode(n7);
        if (n8 != 0x40000000 && n5 >= 0) {
            int n9 = n8 != 0 ? Math.min(View.MeasureSpec.getSize(n7), n5) : n5;
            n7 = View.MeasureSpec.makeMeasureSpec(n9, 0x40000000);
        }
        view.measure(n6, n7);
    }

    private void postShowOverflowMenu() {
        this.removeCallbacks(this.mShowOverflowMenuRunnable);
        this.post(this.mShowOverflowMenuRunnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setChildVisibilityForExpandedActionView(boolean bl) {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            View view = this.getChildAt(n2);
            if (((LayoutParams)view.getLayoutParams()).mViewType != 2 && view != this.mMenuView) {
                int n3 = bl ? 8 : 0;
                view.setVisibility(n3);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean shouldCollapse() {
        if (this.mCollapsible) {
            int n = this.getChildCount();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                View view = this.getChildAt(n2);
                if (this.shouldLayout(view) && view.getMeasuredWidth() > 0 && view.getMeasuredHeight() > 0) break;
                ++n2;
            }
        }
        return false;
    }

    private boolean shouldLayout(View view) {
        return view != null && view.getParent() == this && view.getVisibility() != 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateChildVisibilityForExpandedActionView(View view) {
        if (((LayoutParams)view.getLayoutParams()).mViewType != 2 && view != this.mMenuView) {
            int n = this.mExpandedActionView != null ? 8 : 0;
            view.setVisibility(n);
        }
    }

    public boolean canShowOverflowMenu() {
        return this.getVisibility() == 0 && this.mMenuView != null && this.mMenuView.isOverflowReserved();
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return super.checkLayoutParams(layoutParams) && layoutParams instanceof LayoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void collapseActionView() {
        if (this.mExpandedMenuPresenter == null) {
            return;
        }
        MenuItemImpl menuItemImpl = this.mExpandedMenuPresenter.mCurrentExpandedItem;
        if (menuItemImpl == null) return;
        menuItemImpl.collapseActionView();
    }

    public void dismissPopupMenus() {
        if (this.mMenuView != null) {
            this.mMenuView.dismissPopupMenus();
        }
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)layoutParams);
        }
        if (layoutParams instanceof ActionBar.LayoutParams) {
            return new LayoutParams((ActionBar.LayoutParams)layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    public int getContentInsetEnd() {
        return this.mContentInsets.getEnd();
    }

    public int getContentInsetLeft() {
        return this.mContentInsets.getLeft();
    }

    public int getContentInsetRight() {
        return this.mContentInsets.getRight();
    }

    public int getContentInsetStart() {
        return this.mContentInsets.getStart();
    }

    public Drawable getLogo() {
        if (this.mLogoView != null) {
            return this.mLogoView.getDrawable();
        }
        return null;
    }

    public CharSequence getLogoDescription() {
        if (this.mLogoView != null) {
            return this.mLogoView.getContentDescription();
        }
        return null;
    }

    public Menu getMenu() {
        this.ensureMenu();
        return this.mMenuView.getMenu();
    }

    public CharSequence getNavigationContentDescription() {
        if (this.mNavButtonView != null) {
            return this.mNavButtonView.getContentDescription();
        }
        return null;
    }

    public Drawable getNavigationIcon() {
        if (this.mNavButtonView != null) {
            return this.mNavButtonView.getDrawable();
        }
        return null;
    }

    public int getPopupTheme() {
        return this.mPopupTheme;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitleText;
    }

    public CharSequence getTitle() {
        return this.mTitleText;
    }

    public DecorToolbar getWrapper() {
        if (this.mWrapper == null) {
            this.mWrapper = new ToolbarWidgetWrapper(this, true);
        }
        return this.mWrapper;
    }

    public boolean hasExpandedActionView() {
        return this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null;
    }

    public boolean hideOverflowMenu() {
        return this.mMenuView != null && this.mMenuView.hideOverflowMenu();
    }

    public void inflateMenu(int n) {
        this.getMenuInflater().inflate(n, this.getMenu());
    }

    public boolean isOverflowMenuShowPending() {
        return this.mMenuView != null && this.mMenuView.isOverflowMenuShowPending();
    }

    public boolean isOverflowMenuShowing() {
        return this.mMenuView != null && this.mMenuView.isOverflowMenuShowing();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isTitleTruncated() {
        Layout layout2;
        if (this.mTitleTextView != null && (layout2 = this.mTitleTextView.getLayout()) != null) {
            int n = layout2.getLineCount();
            for (int i = 0; i < n; ++i) {
                if (layout2.getEllipsisCount(i) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mShowOverflowMenuRunnable);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        block37: {
            block38: {
                var6_6 = this.getLayoutDirection() == 1;
                var7_7 = this.getWidth();
                var8_8 = this.getHeight();
                var9_9 = this.getPaddingLeft();
                var10_10 = this.getPaddingRight();
                var11_11 = this.getPaddingTop();
                var12_12 = this.getPaddingBottom();
                var13_13 = var9_9;
                var14_14 = var7_7 - var10_10;
                var15_15 = this.mTempMargins;
                var15_15[1] = 0;
                var15_15[0] = 0;
                var16_16 = this.getMinimumHeight();
                if (this.shouldLayout(this.mNavButtonView)) {
                    if (var6_6) {
                        var14_14 = this.layoutChildRight(this.mNavButtonView, var14_14, var15_15, var16_16);
                    } else {
                        var13_13 = this.layoutChildLeft(this.mNavButtonView, var13_13, var15_15, var16_16);
                    }
                }
                if (this.shouldLayout(this.mCollapseButtonView)) {
                    if (var6_6) {
                        var14_14 = this.layoutChildRight(this.mCollapseButtonView, var14_14, var15_15, var16_16);
                    } else {
                        var13_13 = this.layoutChildLeft(this.mCollapseButtonView, var13_13, var15_15, var16_16);
                    }
                }
                if (this.shouldLayout(this.mMenuView)) {
                    if (var6_6) {
                        var13_13 = this.layoutChildLeft(this.mMenuView, var13_13, var15_15, var16_16);
                    } else {
                        var14_14 = this.layoutChildRight(this.mMenuView, var14_14, var15_15, var16_16);
                    }
                }
                var15_15[0] = Math.max(0, this.getContentInsetLeft() - var13_13);
                var15_15[1] = Math.max(0, this.getContentInsetRight() - (var7_7 - var10_10 - var14_14));
                var17_17 = this.getContentInsetLeft();
                var18_18 = Math.max(var13_13, var17_17);
                var19_19 = var7_7 - var10_10 - this.getContentInsetRight();
                var20_20 = Math.min(var14_14, var19_19);
                if (this.shouldLayout(this.mExpandedActionView)) {
                    if (var6_6) {
                        var20_20 = this.layoutChildRight(this.mExpandedActionView, var20_20, var15_15, var16_16);
                    } else {
                        var18_18 = this.layoutChildLeft(this.mExpandedActionView, var18_18, var15_15, var16_16);
                    }
                }
                if (this.shouldLayout(this.mLogoView)) {
                    if (var6_6) {
                        var20_20 = this.layoutChildRight(this.mLogoView, var20_20, var15_15, var16_16);
                    } else {
                        var18_18 = this.layoutChildLeft(this.mLogoView, var18_18, var15_15, var16_16);
                    }
                }
                var21_21 = this.shouldLayout(this.mTitleTextView);
                var22_22 = this.shouldLayout(this.mSubtitleTextView);
                var23_23 = 0;
                if (var21_21) {
                    var67_24 = (LayoutParams)this.mTitleTextView.getLayoutParams();
                    var23_23 = 0 + (var67_24.topMargin + this.mTitleTextView.getMeasuredHeight() + var67_24.bottomMargin);
                }
                if (var22_22) {
                    var66_25 = (LayoutParams)this.mSubtitleTextView.getLayoutParams();
                    var23_23 += var66_25.topMargin + this.mSubtitleTextView.getMeasuredHeight() + var66_25.bottomMargin;
                }
                if (!var21_21 && !var22_22) break block37;
                var24_26 = var21_21 != false ? this.mTitleTextView : this.mSubtitleTextView;
                var25_27 = var22_22 != false ? this.mSubtitleTextView : this.mTitleTextView;
                var26_28 = (LayoutParams)var24_26.getLayoutParams();
                var27_29 = (LayoutParams)var25_27.getLayoutParams();
                var28_30 = var21_21 != false && this.mTitleTextView.getMeasuredWidth() > 0 || var22_22 != false && this.mSubtitleTextView.getMeasuredWidth() > 0;
                switch (112 & this.mGravity) {
                    default: {
                        var63_31 = (var8_8 - var11_11 - var12_12 - var23_23) / 2;
                        var64_32 = var26_28.topMargin + this.mTitleMarginTop;
                        if (var63_31 >= var64_32) ** GOTO lbl70
                        var63_31 = var26_28.topMargin + this.mTitleMarginTop;
                        ** GOTO lbl73
                    }
                    case 48: {
                        var29_34 = this.getPaddingTop() + var26_28.topMargin + this.mTitleMarginTop;
                        break block38;
                    }
lbl70:
                    // 1 sources

                    var65_33 = var8_8 - var12_12 - var23_23 - var63_31 - var11_11;
                    if (var65_33 < var26_28.bottomMargin + this.mTitleMarginBottom) {
                        var63_31 = Math.max(0, var63_31 - (var27_29.bottomMargin + this.mTitleMarginBottom - var65_33));
                    }
lbl73:
                    // 4 sources

                    var29_34 = var11_11 + var63_31;
                    break block38;
                    case 80: 
                }
                var29_34 = var8_8 - var12_12 - var27_29.bottomMargin - this.mTitleMarginBottom - var23_23;
            }
            if (var6_6) {
                var51_35 = var28_30 != false ? this.mTitleMarginStart : 0;
                var52_36 = var51_35 - var15_15[1];
                var15_15[1] = Math.max(0, -var52_36);
                var53_37 = var20_20 -= Math.max(0, var52_36);
                var54_38 = var20_20;
                if (var21_21) {
                    var60_39 = (LayoutParams)this.mTitleTextView.getLayoutParams();
                    var61_40 = var53_37 - this.mTitleTextView.getMeasuredWidth();
                    var62_41 = var29_34 + this.mTitleTextView.getMeasuredHeight();
                    this.mTitleTextView.layout(var61_40, var29_34, var53_37, var62_41);
                    var53_37 = var61_40 - this.mTitleMarginEnd;
                    var29_34 = var62_41 + var60_39.bottomMargin;
                }
                if (var22_22) {
                    var55_42 = (LayoutParams)this.mSubtitleTextView.getLayoutParams();
                    var56_43 = var29_34 + var55_42.topMargin;
                    var57_44 = var54_38 - this.mSubtitleTextView.getMeasuredWidth();
                    var58_45 = var56_43 + this.mSubtitleTextView.getMeasuredHeight();
                    this.mSubtitleTextView.layout(var57_44, var56_43, var54_38, var58_45);
                    var54_38 -= this.mTitleMarginEnd;
                    var58_45 + var55_42.bottomMargin;
                }
                if (var28_30) {
                    var20_20 = Math.min(var53_37, var54_38);
                }
            } else {
                var30_46 = var28_30 != false ? this.mTitleMarginStart : 0;
                var31_47 = var30_46 - var15_15[0];
                var15_15[0] = Math.max(0, -var31_47);
                var32_48 = var18_18 += Math.max(0, var31_47);
                var33_49 = var18_18;
                if (var21_21) {
                    var48_54 = (LayoutParams)this.mTitleTextView.getLayoutParams();
                    var49_55 = var32_48 + this.mTitleTextView.getMeasuredWidth();
                    var50_56 = var29_34 + this.mTitleTextView.getMeasuredHeight();
                    this.mTitleTextView.layout(var32_48, var29_34, var49_55, var50_56);
                    var32_48 = var49_55 + this.mTitleMarginEnd;
                    var29_34 = var50_56 + var48_54.bottomMargin;
                }
                if (var22_22) {
                    var43_50 = (LayoutParams)this.mSubtitleTextView.getLayoutParams();
                    var44_51 = var29_34 + var43_50.topMargin;
                    var45_52 = var33_49 + this.mSubtitleTextView.getMeasuredWidth();
                    var46_53 = var44_51 + this.mSubtitleTextView.getMeasuredHeight();
                    this.mSubtitleTextView.layout(var33_49, var44_51, var45_52, var46_53);
                    var33_49 = var45_52 + this.mTitleMarginEnd;
                    var46_53 + var43_50.bottomMargin;
                }
                if (var28_30) {
                    var18_18 = Math.max(var32_48, var33_49);
                }
            }
        }
        this.addCustomViewsWithGravity(this.mTempViews, 3);
        var34_57 = this.mTempViews.size();
        for (var35_58 = 0; var35_58 < var34_57; ++var35_58) {
            var18_18 = this.layoutChildLeft(this.mTempViews.get(var35_58), var18_18, var15_15, var16_16);
        }
        this.addCustomViewsWithGravity(this.mTempViews, 5);
        var36_59 = this.mTempViews.size();
        for (var37_60 = 0; var37_60 < var36_59; ++var37_60) {
            var20_20 = this.layoutChildRight(this.mTempViews.get(var37_60), var20_20, var15_15, var16_16);
        }
        this.addCustomViewsWithGravity(this.mTempViews, 1);
        var38_61 = this.getViewListMeasuredWidth(this.mTempViews, var15_15);
        var39_62 = var9_9 + (var7_7 - var9_9 - var10_10) / 2 - var38_61 / 2;
        var40_63 = var39_62 + var38_61;
        if (var39_62 < var18_18) {
            var39_62 = var18_18;
        } else if (var40_63 > var20_20) {
            var39_62 -= var40_63 - var20_20;
        }
        var41_64 = this.mTempViews.size();
        var42_65 = 0;
        while (true) {
            if (var42_65 >= var41_64) {
                this.mTempViews.clear();
                return;
            }
            var39_62 = this.layoutChildLeft(this.mTempViews.get(var42_65), var39_62, var15_15, var16_16);
            ++var42_65;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int[] nArray = this.mTempMargins;
        if (this.isLayoutRtl()) {
            n4 = 1;
            n3 = 0;
        } else {
            n3 = 1;
            n4 = 0;
        }
        boolean bl = this.shouldLayout(this.mNavButtonView);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (bl) {
            this.measureChildConstrained(this.mNavButtonView, n, 0, n2, 0, this.mMaxButtonHeight);
            n7 = this.mNavButtonView.getMeasuredWidth() + this.getHorizontalMargins(this.mNavButtonView);
            n6 = Math.max(0, this.mNavButtonView.getMeasuredHeight() + this.getVerticalMargins(this.mNavButtonView));
            n5 = Toolbar.combineMeasuredStates(0, this.mNavButtonView.getMeasuredState());
        }
        if (this.shouldLayout(this.mCollapseButtonView)) {
            this.measureChildConstrained(this.mCollapseButtonView, n, 0, n2, 0, this.mMaxButtonHeight);
            n7 = this.mCollapseButtonView.getMeasuredWidth() + this.getHorizontalMargins(this.mCollapseButtonView);
            int n8 = this.mCollapseButtonView.getMeasuredHeight() + this.getVerticalMargins(this.mCollapseButtonView);
            n6 = Math.max(n6, n8);
            int n9 = this.mCollapseButtonView.getMeasuredState();
            n5 = Toolbar.combineMeasuredStates(n5, n9);
        }
        int n10 = this.getContentInsetStart();
        int n11 = 0 + Math.max(n10, n7);
        nArray[n4] = Math.max(0, n10 - n7);
        boolean bl2 = this.shouldLayout(this.mMenuView);
        int n12 = 0;
        if (bl2) {
            this.measureChildConstrained(this.mMenuView, n, n11, n2, 0, this.mMaxButtonHeight);
            n12 = this.mMenuView.getMeasuredWidth() + this.getHorizontalMargins(this.mMenuView);
            int n13 = this.mMenuView.getMeasuredHeight() + this.getVerticalMargins(this.mMenuView);
            n6 = Math.max(n6, n13);
            int n14 = this.mMenuView.getMeasuredState();
            n5 = Toolbar.combineMeasuredStates(n5, n14);
        }
        int n15 = this.getContentInsetEnd();
        int n16 = n11 + Math.max(n15, n12);
        nArray[n3] = Math.max(0, n15 - n12);
        if (this.shouldLayout(this.mExpandedActionView)) {
            n16 += this.measureChildCollapseMargins(this.mExpandedActionView, n, n16, n2, 0, nArray);
            int n17 = this.mExpandedActionView.getMeasuredHeight() + this.getVerticalMargins(this.mExpandedActionView);
            n6 = Math.max(n6, n17);
            int n18 = this.mExpandedActionView.getMeasuredState();
            n5 = Toolbar.combineMeasuredStates(n5, n18);
        }
        if (this.shouldLayout(this.mLogoView)) {
            n16 += this.measureChildCollapseMargins(this.mLogoView, n, n16, n2, 0, nArray);
            int n19 = this.mLogoView.getMeasuredHeight() + this.getVerticalMargins(this.mLogoView);
            n6 = Math.max(n6, n19);
            int n20 = this.mLogoView.getMeasuredState();
            n5 = Toolbar.combineMeasuredStates(n5, n20);
        }
        int n21 = this.getChildCount();
        for (int i = 0; i < n21; ++i) {
            View view = this.getChildAt(i);
            if (((LayoutParams)view.getLayoutParams()).mViewType != 0 || !this.shouldLayout(view)) continue;
            n16 += this.measureChildCollapseMargins(view, n, n16, n2, 0, nArray);
            int n22 = view.getMeasuredHeight() + this.getVerticalMargins(view);
            n6 = Math.max(n6, n22);
            int n23 = view.getMeasuredState();
            n5 = Toolbar.combineMeasuredStates(n5, n23);
        }
        int n24 = this.mTitleMarginTop + this.mTitleMarginBottom;
        int n25 = this.mTitleMarginStart + this.mTitleMarginEnd;
        boolean bl3 = this.shouldLayout(this.mTitleTextView);
        int n26 = 0;
        int n27 = 0;
        if (bl3) {
            this.measureChildCollapseMargins(this.mTitleTextView, n, n16 + n25, n2, n24, nArray);
            n27 = this.mTitleTextView.getMeasuredWidth() + this.getHorizontalMargins(this.mTitleTextView);
            n26 = this.mTitleTextView.getMeasuredHeight() + this.getVerticalMargins(this.mTitleTextView);
            int n28 = this.mTitleTextView.getMeasuredState();
            n5 = Toolbar.combineMeasuredStates(n5, n28);
        }
        if (this.shouldLayout(this.mSubtitleTextView)) {
            int n29 = this.measureChildCollapseMargins(this.mSubtitleTextView, n, n16 + n25, n2, n26 + n24, nArray);
            n27 = Math.max(n27, n29);
            n26 += this.mSubtitleTextView.getMeasuredHeight() + this.getVerticalMargins(this.mSubtitleTextView);
            int n30 = this.mSubtitleTextView.getMeasuredState();
            n5 = Toolbar.combineMeasuredStates(n5, n30);
        }
        int n31 = n16 + n27;
        int n32 = Math.max(n6, n26);
        int n33 = n31 + (this.getPaddingLeft() + this.getPaddingRight());
        int n34 = n32 + (this.getPaddingTop() + this.getPaddingBottom());
        int n35 = Toolbar.resolveSizeAndState(Math.max(n33, this.getSuggestedMinimumWidth()), n, 0xFF000000 & n5);
        int n36 = Toolbar.resolveSizeAndState(Math.max(n34, this.getSuggestedMinimumHeight()), n2, n5 << 16);
        if (this.shouldCollapse()) {
            n36 = 0;
        }
        this.setMeasuredDimension(n35, n36);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        MenuItem menuItem;
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        MenuBuilder menuBuilder = this.mMenuView != null ? this.mMenuView.peekMenu() : null;
        if (savedState.expandedMenuItemId != 0 && this.mExpandedMenuPresenter != null && menuBuilder != null && (menuItem = menuBuilder.findItem(savedState.expandedMenuItemId)) != null) {
            menuItem.expandActionView();
        }
        if (savedState.isOverflowOpen) {
            this.postShowOverflowMenu();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRtlPropertiesChanged(int n) {
        int n2 = 1;
        super.onRtlPropertiesChanged(n);
        RtlSpacingHelper rtlSpacingHelper = this.mContentInsets;
        if (n != n2) {
            n2 = 0;
        }
        rtlSpacingHelper.setDirection(n2 != 0);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        if (this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null) {
            savedState.expandedMenuItemId = this.mExpandedMenuPresenter.mCurrentExpandedItem.getItemId();
        }
        savedState.isOverflowOpen = this.isOverflowMenuShowing();
        return savedState;
    }

    @Override
    protected void onSetLayoutParams(View view, ViewGroup.LayoutParams layoutParams) {
        if (!this.checkLayoutParams(layoutParams)) {
            view.setLayoutParams(this.generateLayoutParams(layoutParams));
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.mEatingTouch = false;
        }
        if (!this.mEatingTouch) {
            boolean bl = super.onTouchEvent(motionEvent);
            if (n == 0 && !bl) {
                this.mEatingTouch = true;
            }
        }
        if (n == 1 || n == 3) {
            this.mEatingTouch = false;
        }
        return true;
    }

    public void setCollapsible(boolean bl) {
        this.mCollapsible = bl;
        this.requestLayout();
    }

    public void setContentInsetsAbsolute(int n, int n2) {
        this.mContentInsets.setAbsolute(n, n2);
    }

    public void setContentInsetsRelative(int n, int n2) {
        this.mContentInsets.setRelative(n, n2);
    }

    public void setLogo(int n) {
        this.setLogo(this.getContext().getDrawable(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setLogo(Drawable drawable2) {
        if (drawable2 != null) {
            this.ensureLogoView();
            if (this.mLogoView.getParent() == null) {
                this.addSystemView(this.mLogoView);
                this.updateChildVisibilityForExpandedActionView(this.mLogoView);
            }
        } else if (this.mLogoView != null && this.mLogoView.getParent() != null) {
            this.removeView(this.mLogoView);
        }
        if (this.mLogoView != null) {
            this.mLogoView.setImageDrawable(drawable2);
        }
    }

    public void setLogoDescription(int n) {
        this.setLogoDescription(this.getContext().getText(n));
    }

    public void setLogoDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            this.ensureLogoView();
        }
        if (this.mLogoView != null) {
            this.mLogoView.setContentDescription(charSequence);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMenu(MenuBuilder menuBuilder, ActionMenuPresenter actionMenuPresenter) {
        MenuBuilder menuBuilder2;
        block8: {
            block7: {
                if (menuBuilder == null && this.mMenuView == null) break block7;
                this.ensureMenuView();
                menuBuilder2 = this.mMenuView.peekMenu();
                if (menuBuilder2 != menuBuilder) break block8;
            }
            return;
        }
        if (menuBuilder2 != null) {
            menuBuilder2.removeMenuPresenter(this.mOuterActionMenuPresenter);
            menuBuilder2.removeMenuPresenter(this.mExpandedMenuPresenter);
        }
        if (this.mExpandedMenuPresenter == null) {
            this.mExpandedMenuPresenter = new ExpandedActionViewMenuPresenter();
        }
        actionMenuPresenter.setExpandedActionViewsExclusive(true);
        if (menuBuilder != null) {
            menuBuilder.addMenuPresenter(actionMenuPresenter, this.mPopupContext);
            menuBuilder.addMenuPresenter(this.mExpandedMenuPresenter, this.mPopupContext);
        } else {
            actionMenuPresenter.initForMenu(this.mPopupContext, null);
            this.mExpandedMenuPresenter.initForMenu(this.mPopupContext, null);
            actionMenuPresenter.updateMenuView(true);
            this.mExpandedMenuPresenter.updateMenuView(true);
        }
        this.mMenuView.setPopupTheme(this.mPopupTheme);
        this.mMenuView.setPresenter(actionMenuPresenter);
        this.mOuterActionMenuPresenter = actionMenuPresenter;
    }

    public void setMenuCallbacks(MenuPresenter.Callback callback, MenuBuilder.Callback callback2) {
        this.mActionMenuPresenterCallback = callback;
        this.mMenuBuilderCallback = callback2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setNavigationContentDescription(int n) {
        CharSequence charSequence = n != 0 ? this.getContext().getText(n) : null;
        this.setNavigationContentDescription(charSequence);
    }

    public void setNavigationContentDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            this.ensureNavButtonView();
        }
        if (this.mNavButtonView != null) {
            this.mNavButtonView.setContentDescription(charSequence);
        }
    }

    public void setNavigationIcon(int n) {
        this.setNavigationIcon(this.getContext().getDrawable(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setNavigationIcon(Drawable drawable2) {
        if (drawable2 != null) {
            this.ensureNavButtonView();
            if (this.mNavButtonView.getParent() == null) {
                this.addSystemView(this.mNavButtonView);
                this.updateChildVisibilityForExpandedActionView(this.mNavButtonView);
            }
        } else if (this.mNavButtonView != null && this.mNavButtonView.getParent() != null) {
            this.removeView(this.mNavButtonView);
        }
        if (this.mNavButtonView != null) {
            this.mNavButtonView.setImageDrawable(drawable2);
        }
    }

    public void setNavigationOnClickListener(View.OnClickListener onClickListener) {
        this.ensureNavButtonView();
        this.mNavButtonView.setOnClickListener(onClickListener);
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener onMenuItemClickListener) {
        this.mOnMenuItemClickListener = onMenuItemClickListener;
    }

    public void setPopupTheme(int n) {
        block3: {
            block2: {
                if (this.mPopupTheme == n) break block2;
                this.mPopupTheme = n;
                if (n != 0) break block3;
                this.mPopupContext = this.mContext;
            }
            return;
        }
        this.mPopupContext = new ContextThemeWrapper(this.mContext, n);
    }

    public void setSubtitle(int n) {
        this.setSubtitle(this.getContext().getText(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSubtitle(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            if (this.mSubtitleTextView == null) {
                Context context = this.getContext();
                this.mSubtitleTextView = new TextView(context);
                this.mSubtitleTextView.setSingleLine();
                this.mSubtitleTextView.setEllipsize(TextUtils.TruncateAt.END);
                if (this.mSubtitleTextAppearance != 0) {
                    this.mSubtitleTextView.setTextAppearance(context, this.mSubtitleTextAppearance);
                }
                if (this.mSubtitleTextColor != 0) {
                    this.mSubtitleTextView.setTextColor(this.mSubtitleTextColor);
                }
            }
            if (this.mSubtitleTextView.getParent() == null) {
                this.addSystemView(this.mSubtitleTextView);
                this.updateChildVisibilityForExpandedActionView(this.mSubtitleTextView);
            }
        } else if (this.mSubtitleTextView != null && this.mSubtitleTextView.getParent() != null) {
            this.removeView(this.mSubtitleTextView);
        }
        if (this.mSubtitleTextView != null) {
            this.mSubtitleTextView.setText(charSequence);
        }
        this.mSubtitleText = charSequence;
    }

    public void setSubtitleTextAppearance(Context context, int n) {
        this.mSubtitleTextAppearance = n;
        if (this.mSubtitleTextView != null) {
            this.mSubtitleTextView.setTextAppearance(context, n);
        }
    }

    public void setSubtitleTextColor(int n) {
        this.mSubtitleTextColor = n;
        if (this.mSubtitleTextView != null) {
            this.mSubtitleTextView.setTextColor(n);
        }
    }

    public void setTitle(int n) {
        this.setTitle(this.getContext().getText(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTitle(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            if (this.mTitleTextView == null) {
                Context context = this.getContext();
                this.mTitleTextView = new TextView(context);
                this.mTitleTextView.setSingleLine();
                this.mTitleTextView.setEllipsize(TextUtils.TruncateAt.END);
                if (this.mTitleTextAppearance != 0) {
                    this.mTitleTextView.setTextAppearance(context, this.mTitleTextAppearance);
                }
                if (this.mTitleTextColor != 0) {
                    this.mTitleTextView.setTextColor(this.mTitleTextColor);
                }
            }
            if (this.mTitleTextView.getParent() == null) {
                this.addSystemView(this.mTitleTextView);
                this.updateChildVisibilityForExpandedActionView(this.mTitleTextView);
            }
        } else if (this.mTitleTextView != null && this.mTitleTextView.getParent() != null) {
            this.removeView(this.mTitleTextView);
        }
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setText(charSequence);
        }
        this.mTitleText = charSequence;
    }

    public void setTitleTextAppearance(Context context, int n) {
        this.mTitleTextAppearance = n;
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setTextAppearance(context, n);
        }
    }

    public void setTitleTextColor(int n) {
        this.mTitleTextColor = n;
        if (this.mTitleTextView != null) {
            this.mTitleTextView.setTextColor(n);
        }
    }

    public boolean showOverflowMenu() {
        return this.mMenuView != null && this.mMenuView.showOverflowMenu();
    }

    private class ExpandedActionViewMenuPresenter
    implements MenuPresenter {
        MenuItemImpl mCurrentExpandedItem;
        MenuBuilder mMenu;

        private ExpandedActionViewMenuPresenter() {
        }

        @Override
        public boolean collapseItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
            if (Toolbar.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)((Object)Toolbar.this.mExpandedActionView)).onActionViewCollapsed();
            }
            Toolbar.this.removeView(Toolbar.this.mExpandedActionView);
            Toolbar.this.removeView(Toolbar.this.mCollapseButtonView);
            Toolbar.this.mExpandedActionView = null;
            Toolbar.this.setChildVisibilityForExpandedActionView(false);
            this.mCurrentExpandedItem = null;
            Toolbar.this.requestLayout();
            menuItemImpl.setActionViewExpanded(false);
            return true;
        }

        @Override
        public boolean expandItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
            Toolbar.this.ensureCollapseButtonView();
            if (Toolbar.this.mCollapseButtonView.getParent() != Toolbar.this) {
                Toolbar.this.addView(Toolbar.this.mCollapseButtonView);
            }
            Toolbar.this.mExpandedActionView = menuItemImpl.getActionView();
            this.mCurrentExpandedItem = menuItemImpl;
            if (Toolbar.this.mExpandedActionView.getParent() != Toolbar.this) {
                ViewGroup.LayoutParams layoutParams = Toolbar.this.generateDefaultLayoutParams();
                ((LayoutParams)layoutParams).gravity = 0x800003 | 0x70 & Toolbar.this.mButtonGravity;
                ((LayoutParams)layoutParams).mViewType = 2;
                Toolbar.this.mExpandedActionView.setLayoutParams(layoutParams);
                Toolbar.this.addView(Toolbar.this.mExpandedActionView);
            }
            Toolbar.this.setChildVisibilityForExpandedActionView(true);
            Toolbar.this.requestLayout();
            menuItemImpl.setActionViewExpanded(true);
            if (Toolbar.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)((Object)Toolbar.this.mExpandedActionView)).onActionViewExpanded();
            }
            return true;
        }

        @Override
        public boolean flagActionItems() {
            return false;
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public MenuView getMenuView(ViewGroup viewGroup) {
            return null;
        }

        @Override
        public void initForMenu(Context context, MenuBuilder menuBuilder) {
            if (this.mMenu != null && this.mCurrentExpandedItem != null) {
                this.mMenu.collapseItemActionView(this.mCurrentExpandedItem);
            }
            this.mMenu = menuBuilder;
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        }

        @Override
        public void onRestoreInstanceState(Parcelable parcelable) {
        }

        @Override
        public Parcelable onSaveInstanceState() {
            return null;
        }

        @Override
        public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
            return false;
        }

        @Override
        public void setCallback(MenuPresenter.Callback callback) {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void updateMenuView(boolean bl) {
            if (this.mCurrentExpandedItem == null) return;
            MenuBuilder menuBuilder = this.mMenu;
            boolean bl2 = false;
            if (menuBuilder != null) {
                int n = this.mMenu.size();
                int n2 = 0;
                while (true) {
                    bl2 = false;
                    if (n2 >= n) break;
                    if (this.mMenu.getItem(n2) == this.mCurrentExpandedItem) {
                        return;
                    }
                    ++n2;
                }
            }
            if (bl2) return;
            this.collapseItemActionView(this.mMenu, this.mCurrentExpandedItem);
        }
    }

    public static class LayoutParams
    extends ActionBar.LayoutParams {
        static final int CUSTOM = 0;
        static final int EXPANDED = 2;
        static final int SYSTEM = 1;
        int mViewType = 0;

        public LayoutParams(int n) {
            this(-2, -1, n);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.gravity = 8388627;
        }

        public LayoutParams(int n, int n2, int n3) {
            super(n, n2);
            this.gravity = n3;
        }

        public LayoutParams(ActionBar.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super((ViewGroup.LayoutParams)marginLayoutParams);
            this.copyMarginsFrom(marginLayoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.mViewType = layoutParams.mViewType;
        }
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(MenuItem var1);
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        public int expandedMenuItemId;
        public boolean isOverflowOpen;

        /*
         * Enabled aggressive block sorting
         */
        public SavedState(Parcel parcel) {
            super(parcel);
            this.expandedMenuItemId = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            this.isOverflowOpen = bl;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.expandedMenuItemId);
            int n2 = this.isOverflowOpen ? 1 : 0;
            parcel.writeInt(n2);
        }
    }
}

