/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.Gravity;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import com.android.internal.R;

public class TableRow
extends LinearLayout {
    private ChildrenTracker mChildrenTracker;
    private SparseIntArray mColumnToChildIndex;
    private int[] mColumnWidths;
    private int[] mConstrainedColumnWidths;
    private int mNumColumns = 0;

    public TableRow(Context context) {
        super(context);
        this.initTableRow();
    }

    public TableRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initTableRow();
    }

    static /* synthetic */ SparseIntArray access$302(TableRow tableRow, SparseIntArray sparseIntArray) {
        tableRow.mColumnToChildIndex = sparseIntArray;
        return sparseIntArray;
    }

    private void initTableRow() {
        ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener = this.mOnHierarchyChangeListener;
        this.mChildrenTracker = new ChildrenTracker();
        if (onHierarchyChangeListener != null) {
            this.mChildrenTracker.setOnHierarchyChangeListener(onHierarchyChangeListener);
        }
        super.setOnHierarchyChangeListener(this.mChildrenTracker);
    }

    private void mapIndexAndColumns() {
        if (this.mColumnToChildIndex == null) {
            int n = 0;
            int n2 = this.getChildCount();
            SparseIntArray sparseIntArray = this.mColumnToChildIndex = new SparseIntArray();
            for (int i = 0; i < n2; ++i) {
                LayoutParams layoutParams = (LayoutParams)this.getChildAt(i).getLayoutParams();
                if (layoutParams.column >= n) {
                    n = layoutParams.column;
                }
                for (int j = 0; j < layoutParams.span; ++j) {
                    int n3 = n + 1;
                    sparseIntArray.put(n, i);
                    n = n3;
                }
            }
            this.mNumColumns = n;
        }
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    protected LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    @Override
    int getChildrenSkipCount(View view, int n) {
        return -1 + ((LayoutParams)view.getLayoutParams()).span;
    }

    /*
     * Enabled aggressive block sorting
     */
    int[] getColumnsWidths(int n) {
        int n2 = this.getVirtualChildCount();
        if (this.mColumnWidths == null || n2 != this.mColumnWidths.length) {
            this.mColumnWidths = new int[n2];
        }
        int[] nArray = this.mColumnWidths;
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getVirtualChildAt(n3);
            if (view != null && view.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (layoutParams.span == 1) {
                    int n4;
                    switch (layoutParams.width) {
                        default: {
                            n4 = View.MeasureSpec.makeMeasureSpec(layoutParams.width, 0x40000000);
                            break;
                        }
                        case -2: {
                            n4 = TableRow.getChildMeasureSpec(n, 0, -2);
                            break;
                        }
                        case -1: {
                            n4 = View.MeasureSpec.makeMeasureSpec(0, 0);
                        }
                    }
                    view.measure(n4, n4);
                    nArray[n3] = view.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
                } else {
                    nArray[n3] = 0;
                }
            } else {
                nArray[n3] = 0;
            }
            ++n3;
        }
        return nArray;
    }

    @Override
    int getLocationOffset(View view) {
        return ((LayoutParams)view.getLayoutParams()).mOffset[0];
    }

    @Override
    int getNextLocationOffset(View view) {
        return ((LayoutParams)view.getLayoutParams()).mOffset[1];
    }

    @Override
    public View getVirtualChildAt(int n) {
        int n2;
        if (this.mColumnToChildIndex == null) {
            this.mapIndexAndColumns();
        }
        if ((n2 = this.mColumnToChildIndex.get(n, -1)) != -1) {
            return this.getChildAt(n2);
        }
        return null;
    }

    @Override
    public int getVirtualChildCount() {
        if (this.mColumnToChildIndex == null) {
            this.mapIndexAndColumns();
        }
        return this.mNumColumns;
    }

    @Override
    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        if (this.mConstrainedColumnWidths != null) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n6 = 0x40000000;
            int n7 = 0;
            int n8 = layoutParams.span;
            int[] nArray = this.mConstrainedColumnWidths;
            for (int i = 0; i < n8; ++i) {
                n7 += nArray[n + i];
            }
            int n9 = layoutParams.gravity;
            boolean bl = Gravity.isHorizontal(n9);
            if (bl) {
                n6 = Integer.MIN_VALUE;
            }
            view.measure(View.MeasureSpec.makeMeasureSpec(Math.max(0, n7 - layoutParams.leftMargin - layoutParams.rightMargin), n6), TableRow.getChildMeasureSpec(n4, n5 + (this.mPaddingTop + this.mPaddingBottom + layoutParams.topMargin + layoutParams.bottomMargin), layoutParams.height));
            if (bl) {
                int n10 = view.getMeasuredWidth();
                ((LayoutParams)layoutParams).mOffset[1] = n7 - n10;
                switch (7 & Gravity.getAbsoluteGravity(n9, this.getLayoutDirection())) {
                    default: {
                        return;
                    }
                    case 5: {
                        ((LayoutParams)layoutParams).mOffset[0] = layoutParams.mOffset[1];
                        return;
                    }
                    case 1: 
                }
                ((LayoutParams)layoutParams).mOffset[0] = layoutParams.mOffset[1] / 2;
                return;
            }
            int[] nArray2 = layoutParams.mOffset;
            ((LayoutParams)layoutParams).mOffset[1] = 0;
            nArray2[0] = 0;
            return;
        }
        super.measureChildBeforeLayout(view, n, n2, n3, n4, n5);
    }

    @Override
    int measureNullChild(int n) {
        return this.mConstrainedColumnWidths[n];
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(TableRow.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(TableRow.class.getName());
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.layoutHorizontal(n, n2, n3, n4);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        this.measureHorizontal(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setColumnCollapsed(int n, boolean bl) {
        View view = this.getVirtualChildAt(n);
        if (view != null) {
            int n2 = bl ? 8 : 0;
            view.setVisibility(n2);
        }
    }

    void setColumnsWidthConstraints(int[] nArray) {
        if (nArray == null || nArray.length < this.getVirtualChildCount()) {
            throw new IllegalArgumentException("columnWidths should be >= getVirtualChildCount()");
        }
        this.mConstrainedColumnWidths = nArray;
    }

    @Override
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.mChildrenTracker.setOnHierarchyChangeListener(onHierarchyChangeListener);
    }

    private class ChildrenTracker
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener listener;

        private ChildrenTracker() {
        }

        private void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
            this.listener = onHierarchyChangeListener;
        }

        @Override
        public void onChildViewAdded(View view, View view2) {
            TableRow.access$302(TableRow.this, null);
            if (this.listener != null) {
                this.listener.onChildViewAdded(view, view2);
            }
        }

        @Override
        public void onChildViewRemoved(View view, View view2) {
            TableRow.access$302(TableRow.this, null);
            if (this.listener != null) {
                this.listener.onChildViewRemoved(view, view2);
            }
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        private static final int LOCATION = 0;
        private static final int LOCATION_NEXT = 1;
        @ViewDebug.ExportedProperty(category="layout")
        public int column;
        private int[] mOffset = new int[2];
        @ViewDebug.ExportedProperty(category="layout")
        public int span;

        public LayoutParams() {
            super(-1, -2);
            this.column = -1;
            this.span = 1;
        }

        public LayoutParams(int n) {
            this();
            this.column = n;
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.column = -1;
            this.span = 1;
        }

        public LayoutParams(int n, int n2, float f) {
            super(n, n2, f);
            this.column = -1;
            this.span = 1;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TableRow_Cell);
            this.column = typedArray.getInt(0, -1);
            this.span = typedArray.getInt(1, 1);
            if (this.span <= 1) {
                this.span = 1;
            }
            typedArray.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            this.width = typedArray.hasValue(n) ? typedArray.getLayoutDimension(n, "layout_width") : -1;
            if (typedArray.hasValue(n2)) {
                this.height = typedArray.getLayoutDimension(n2, "layout_height");
                return;
            }
            this.height = -2;
        }
    }
}

