/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import android.widget.TableRow;
import com.android.internal.R;
import java.util.regex.Pattern;

public class TableLayout
extends LinearLayout {
    private SparseBooleanArray mCollapsedColumns;
    private boolean mInitialized;
    private int[] mMaxWidths;
    private PassThroughHierarchyChangeListener mPassThroughListener;
    private boolean mShrinkAllColumns;
    private SparseBooleanArray mShrinkableColumns;
    private boolean mStretchAllColumns;
    private SparseBooleanArray mStretchableColumns;

    public TableLayout(Context context) {
        super(context);
        this.initTableLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    public TableLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        String string2;
        String string3;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TableLayout);
        String string4 = typedArray.getString(0);
        if (string4 != null) {
            if (string4.charAt(0) == '*') {
                this.mStretchAllColumns = true;
            } else {
                this.mStretchableColumns = TableLayout.parseColumns(string4);
            }
        }
        if ((string3 = typedArray.getString(1)) != null) {
            if (string3.charAt(0) == '*') {
                this.mShrinkAllColumns = true;
            } else {
                this.mShrinkableColumns = TableLayout.parseColumns(string3);
            }
        }
        if ((string2 = typedArray.getString(2)) != null) {
            this.mCollapsedColumns = TableLayout.parseColumns(string2);
        }
        typedArray.recycle();
        this.initTableLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void findLargestCells(int n) {
        boolean bl = true;
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getChildAt(n3);
            if (view.getVisibility() != 8 && view instanceof TableRow) {
                TableRow tableRow = (TableRow)view;
                tableRow.getLayoutParams().height = -2;
                int[] nArray = tableRow.getColumnsWidths(n);
                int n4 = nArray.length;
                if (bl) {
                    if (this.mMaxWidths == null || this.mMaxWidths.length != n4) {
                        this.mMaxWidths = new int[n4];
                    }
                    System.arraycopy((int[])nArray, (int)0, (int[])this.mMaxWidths, (int)0, (int)n4);
                    bl = false;
                } else {
                    int n5 = this.mMaxWidths.length;
                    int n6 = n4 - n5;
                    if (n6 > 0) {
                        int[] nArray2 = this.mMaxWidths;
                        this.mMaxWidths = new int[n4];
                        System.arraycopy((int[])nArray2, (int)0, (int[])this.mMaxWidths, (int)0, (int)nArray2.length);
                        System.arraycopy((int[])nArray, (int)nArray2.length, (int[])this.mMaxWidths, (int)nArray2.length, (int)n6);
                    }
                    int[] nArray3 = this.mMaxWidths;
                    int n7 = Math.min(n5, n4);
                    for (int i = 0; i < n7; ++i) {
                        nArray3[i] = Math.max(nArray3[i], nArray[i]);
                    }
                }
            }
            ++n3;
        }
        return;
    }

    private void initTableLayout() {
        if (this.mCollapsedColumns == null) {
            this.mCollapsedColumns = new SparseBooleanArray();
        }
        if (this.mStretchableColumns == null) {
            this.mStretchableColumns = new SparseBooleanArray();
        }
        if (this.mShrinkableColumns == null) {
            this.mShrinkableColumns = new SparseBooleanArray();
        }
        this.setOrientation(1);
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener(this.mPassThroughListener);
        this.mInitialized = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mutateColumnsWidth(SparseBooleanArray sparseBooleanArray, boolean bl, int n, int n2) {
        int n3 = 0;
        int[] nArray = this.mMaxWidths;
        int n4 = nArray.length;
        int n5 = bl ? n4 : sparseBooleanArray.size();
        int n6 = (n - n2) / n5;
        int n7 = this.getChildCount();
        for (int i = 0; i < n7; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof TableRow)) continue;
            view.forceLayout();
        }
        if (bl) {
            for (int i = 0; i < n5; ++i) {
                nArray[i] = n6 + nArray[i];
            }
            return;
        }
        for (int i = 0; i < n5; ++i) {
            int n8 = sparseBooleanArray.keyAt(i);
            if (!sparseBooleanArray.valueAt(i)) continue;
            if (n8 < n4) {
                nArray[n8] = n6 + nArray[n8];
                continue;
            }
            ++n3;
        }
        if (n3 <= 0 || n3 >= n5) return;
        int n9 = n3 * n6 / (n5 - n3);
        for (int i = 0; i < n5; ++i) {
            int n10 = sparseBooleanArray.keyAt(i);
            if (!sparseBooleanArray.valueAt(i) || n10 >= n4) continue;
            nArray[n10] = n9 > nArray[n10] ? 0 : n9 + nArray[n10];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SparseBooleanArray parseColumns(String string2) {
        SparseBooleanArray sparseBooleanArray = new SparseBooleanArray();
        String[] stringArray = Pattern.compile("\\s*,\\s*").split(string2);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            try {
                int n3 = Integer.parseInt(string3);
                if (n3 >= 0) {
                    sparseBooleanArray.put(n3, true);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        return sparseBooleanArray;
    }

    private void requestRowsLayout() {
        if (this.mInitialized) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.getChildAt(i).requestLayout();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void shrinkAndStretchColumns(int n) {
        int n2;
        int n3;
        block6: {
            block5: {
                if (this.mMaxWidths == null) break block5;
                n3 = 0;
                int[] nArray = this.mMaxWidths;
                int n4 = nArray.length;
                for (int i = 0; i < n4; n3 += nArray[i], ++i) {
                }
                n2 = View.MeasureSpec.getSize(n) - this.mPaddingLeft - this.mPaddingRight;
                if (n3 > n2 && (this.mShrinkAllColumns || this.mShrinkableColumns.size() > 0)) {
                    this.mutateColumnsWidth(this.mShrinkableColumns, this.mShrinkAllColumns, n2, n3);
                    return;
                }
                if (n3 < n2 && (this.mStretchAllColumns || this.mStretchableColumns.size() > 0)) break block6;
            }
            return;
        }
        this.mutateColumnsWidth(this.mStretchableColumns, this.mStretchAllColumns, n2, n3);
    }

    private void trackCollapsedColumns(View view) {
        if (view instanceof TableRow) {
            TableRow tableRow = (TableRow)view;
            SparseBooleanArray sparseBooleanArray = this.mCollapsedColumns;
            int n = sparseBooleanArray.size();
            for (int i = 0; i < n; ++i) {
                int n2 = sparseBooleanArray.keyAt(i);
                boolean bl = sparseBooleanArray.valueAt(i);
                if (!bl) continue;
                tableRow.setColumnCollapsed(n2, bl);
            }
        }
    }

    @Override
    public void addView(View view) {
        super.addView(view);
        this.requestRowsLayout();
    }

    @Override
    public void addView(View view, int n) {
        super.addView(view, n);
        this.requestRowsLayout();
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        this.requestRowsLayout();
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, layoutParams);
        this.requestRowsLayout();
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    protected LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    public boolean isColumnCollapsed(int n) {
        return this.mCollapsedColumns.get(n);
    }

    public boolean isColumnShrinkable(int n) {
        return this.mShrinkAllColumns || this.mShrinkableColumns.get(n);
    }

    public boolean isColumnStretchable(int n) {
        return this.mStretchAllColumns || this.mStretchableColumns.get(n);
    }

    public boolean isShrinkAllColumns() {
        return this.mShrinkAllColumns;
    }

    public boolean isStretchAllColumns() {
        return this.mStretchAllColumns;
    }

    @Override
    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        if (view instanceof TableRow) {
            ((TableRow)view).setColumnsWidthConstraints(this.mMaxWidths);
        }
        super.measureChildBeforeLayout(view, n, n2, n3, n4, n5);
    }

    @Override
    void measureVertical(int n, int n2) {
        this.findLargestCells(n);
        this.shrinkAndStretchColumns(n);
        super.measureVertical(n, n2);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(TableLayout.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(TableLayout.class.getName());
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.layoutVertical(n, n2, n3, n4);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        this.measureVertical(n, n2);
    }

    @Override
    public void requestLayout() {
        if (this.mInitialized) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.getChildAt(i).forceLayout();
            }
        }
        super.requestLayout();
    }

    public void setColumnCollapsed(int n, boolean bl) {
        this.mCollapsedColumns.put(n, bl);
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof TableRow)) continue;
            ((TableRow)view).setColumnCollapsed(n, bl);
        }
        this.requestRowsLayout();
    }

    public void setColumnShrinkable(int n, boolean bl) {
        this.mShrinkableColumns.put(n, bl);
        this.requestRowsLayout();
    }

    public void setColumnStretchable(int n, boolean bl) {
        this.mStretchableColumns.put(n, bl);
        this.requestRowsLayout();
    }

    @Override
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        PassThroughHierarchyChangeListener.access$102(this.mPassThroughListener, onHierarchyChangeListener);
    }

    public void setShrinkAllColumns(boolean bl) {
        this.mShrinkAllColumns = bl;
    }

    public void setStretchAllColumns(boolean bl) {
        this.mStretchAllColumns = bl;
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams() {
            super(-1, -2);
        }

        public LayoutParams(int n, int n2) {
            super(-1, n2);
        }

        public LayoutParams(int n, int n2, float f) {
            super(-1, n2, f);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        @Override
        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            this.width = -1;
            if (typedArray.hasValue(n2)) {
                this.height = typedArray.getLayoutDimension(n2, "layout_height");
                return;
            }
            this.height = -2;
        }
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        static /* synthetic */ ViewGroup.OnHierarchyChangeListener access$102(PassThroughHierarchyChangeListener passThroughHierarchyChangeListener, ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
            passThroughHierarchyChangeListener.mOnHierarchyChangeListener = onHierarchyChangeListener;
            return onHierarchyChangeListener;
        }

        @Override
        public void onChildViewAdded(View view, View view2) {
            TableLayout.this.trackCollapsedColumns(view2);
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(view, view2);
            }
        }

        @Override
        public void onChildViewRemoved(View view, View view2) {
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(view, view2);
            }
        }
    }
}

