/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Pools;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AlphaAnimation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.ArrayList;

@RemoteViews.RemoteView
public class ProgressBar
extends View {
    private static final int MAX_LEVEL = 10000;
    private static final int TIMEOUT_SEND_ACCESSIBILITY_EVENT = 200;
    private AccessibilityEventSender mAccessibilityEventSender;
    private AlphaAnimation mAnimation;
    private float mAnimationPosition;
    private boolean mAttached;
    private int mBehavior;
    private Drawable mCurrentDrawable;
    private int mDuration;
    private boolean mHasAnimation;
    private boolean mInDrawing;
    private boolean mIndeterminate;
    private Drawable mIndeterminateDrawable;
    private Interpolator mInterpolator;
    private int mMax;
    int mMaxHeight;
    int mMaxWidth;
    int mMinHeight;
    int mMinWidth;
    boolean mMirrorForRtl;
    private boolean mNoInvalidate;
    private boolean mOnlyIndeterminate;
    private int mProgress;
    private Drawable mProgressDrawable;
    private ProgressTintInfo mProgressTintInfo;
    private final ArrayList<RefreshData> mRefreshData;
    private boolean mRefreshIsPosted;
    private RefreshProgressRunnable mRefreshProgressRunnable;
    Bitmap mSampleTile;
    private int mSecondaryProgress;
    private boolean mShouldStartAnimationDrawable;
    private Transformation mTransformation;
    private long mUiThreadId;

    public ProgressBar(Context context) {
        this(context, null);
    }

    public ProgressBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010077);
    }

    public ProgressBar(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ProgressBar(Context context, AttributeSet attributeSet, int n, int n2) {
        boolean bl;
        TypedArray typedArray;
        block24: {
            block23: {
                super(context, attributeSet, n, n2);
                this.mMirrorForRtl = false;
                this.mRefreshData = new ArrayList();
                this.mUiThreadId = Thread.currentThread().getId();
                this.initProgressBar();
                typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ProgressBar, n, n2);
                this.mNoInvalidate = true;
                Drawable drawable2 = typedArray.getDrawable(8);
                if (drawable2 != null) {
                    this.setProgressDrawableTiled(drawable2);
                }
                this.mDuration = typedArray.getInt(9, this.mDuration);
                this.mMinWidth = typedArray.getDimensionPixelSize(11, this.mMinWidth);
                this.mMaxWidth = typedArray.getDimensionPixelSize(0, this.mMaxWidth);
                this.mMinHeight = typedArray.getDimensionPixelSize(12, this.mMinHeight);
                this.mMaxHeight = typedArray.getDimensionPixelSize(1, this.mMaxHeight);
                this.mBehavior = typedArray.getInt(10, this.mBehavior);
                int n3 = typedArray.getResourceId(13, 17432587);
                if (n3 > 0) {
                    this.setInterpolator(context, n3);
                }
                this.setMax(typedArray.getInt(2, this.mMax));
                this.setProgress(typedArray.getInt(3, this.mProgress));
                this.setSecondaryProgress(typedArray.getInt(4, this.mSecondaryProgress));
                Drawable drawable3 = typedArray.getDrawable(7);
                if (drawable3 != null) {
                    this.setIndeterminateDrawableTiled(drawable3);
                }
                this.mOnlyIndeterminate = typedArray.getBoolean(6, this.mOnlyIndeterminate);
                this.mNoInvalidate = false;
                if (this.mOnlyIndeterminate) break block23;
                boolean bl2 = typedArray.getBoolean(5, this.mIndeterminate);
                bl = false;
                if (!bl2) break block24;
            }
            bl = true;
        }
        this.setIndeterminate(bl);
        this.mMirrorForRtl = typedArray.getBoolean(15, this.mMirrorForRtl);
        if (typedArray.hasValue(17)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressTintMode = Drawable.parseTintMode(typedArray.getInt(19, -1), null);
            this.mProgressTintInfo.mHasProgressTintMode = true;
        }
        if (typedArray.hasValue(16)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressTintList = typedArray.getColorStateList(16);
            this.mProgressTintInfo.mHasProgressTint = true;
        }
        if (typedArray.hasValue(19)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressBackgroundTintMode = Drawable.parseTintMode(typedArray.getInt(17, -1), null);
            this.mProgressTintInfo.mHasProgressBackgroundTintMode = true;
        }
        if (typedArray.hasValue(18)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressBackgroundTintList = typedArray.getColorStateList(18);
            this.mProgressTintInfo.mHasProgressBackgroundTint = true;
        }
        if (typedArray.hasValue(21)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mSecondaryProgressTintMode = Drawable.parseTintMode(typedArray.getInt(21, -1), null);
            this.mProgressTintInfo.mHasSecondaryProgressTintMode = true;
        }
        if (typedArray.hasValue(20)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mSecondaryProgressTintList = typedArray.getColorStateList(20);
            this.mProgressTintInfo.mHasSecondaryProgressTint = true;
        }
        if (typedArray.hasValue(22)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mIndeterminateTintMode = Drawable.parseTintMode(typedArray.getInt(23, -1), null);
            this.mProgressTintInfo.mHasIndeterminateTintMode = true;
        }
        if (typedArray.hasValue(22)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mIndeterminateTintList = typedArray.getColorStateList(22);
            this.mProgressTintInfo.mHasIndeterminateTint = true;
        }
        typedArray.recycle();
        this.applyProgressTints();
        this.applyIndeterminateTint();
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    static /* synthetic */ boolean access$302(ProgressBar progressBar, boolean bl) {
        progressBar.mRefreshIsPosted = bl;
        return bl;
    }

    private void applyIndeterminateTint() {
        if (this.mIndeterminateDrawable != null && this.mProgressTintInfo != null) {
            ProgressTintInfo progressTintInfo = this.mProgressTintInfo;
            if (progressTintInfo.mHasIndeterminateTint || progressTintInfo.mHasIndeterminateTintMode) {
                this.mIndeterminateDrawable = this.mIndeterminateDrawable.mutate();
                if (progressTintInfo.mHasIndeterminateTint) {
                    this.mIndeterminateDrawable.setTintList(progressTintInfo.mIndeterminateTintList);
                }
                if (progressTintInfo.mHasIndeterminateTintMode) {
                    this.mIndeterminateDrawable.setTintMode(progressTintInfo.mIndeterminateTintMode);
                }
            }
        }
    }

    private void applyPrimaryProgressTint() {
        Drawable drawable2;
        if ((this.mProgressTintInfo.mHasProgressTint || this.mProgressTintInfo.mHasProgressTintMode) && (drawable2 = this.getTintTarget(16908301, true)) != null) {
            if (this.mProgressTintInfo.mHasProgressTint) {
                drawable2.setTintList(this.mProgressTintInfo.mProgressTintList);
            }
            if (this.mProgressTintInfo.mHasProgressTintMode) {
                drawable2.setTintMode(this.mProgressTintInfo.mProgressTintMode);
            }
        }
    }

    private void applyProgressBackgroundTint() {
        Drawable drawable2;
        if ((this.mProgressTintInfo.mHasProgressBackgroundTint || this.mProgressTintInfo.mHasProgressBackgroundTintMode) && (drawable2 = this.getTintTarget(0x1020000, false)) != null) {
            if (this.mProgressTintInfo.mHasProgressBackgroundTint) {
                drawable2.setTintList(this.mProgressTintInfo.mProgressBackgroundTintList);
            }
            if (this.mProgressTintInfo.mHasProgressBackgroundTintMode) {
                drawable2.setTintMode(this.mProgressTintInfo.mProgressBackgroundTintMode);
            }
        }
    }

    private void applyProgressTints() {
        if (this.mProgressDrawable != null && this.mProgressTintInfo != null) {
            this.applyPrimaryProgressTint();
            this.applyProgressBackgroundTint();
            this.applySecondaryProgressTint();
        }
    }

    private void applySecondaryProgressTint() {
        Drawable drawable2;
        if ((this.mProgressTintInfo.mHasSecondaryProgressTint || this.mProgressTintInfo.mHasSecondaryProgressTintMode) && (drawable2 = this.getTintTarget(16908303, false)) != null) {
            if (this.mProgressTintInfo.mHasSecondaryProgressTint) {
                drawable2.setTintList(this.mProgressTintInfo.mSecondaryProgressTintList);
            }
            if (this.mProgressTintInfo.mHasSecondaryProgressTintMode) {
                drawable2.setTintMode(this.mProgressTintInfo.mSecondaryProgressTintMode);
            }
        }
    }

    private void doRefreshProgress(int n, float f, boolean bl, boolean bl2) {
        synchronized (this) {
            this.doRefreshProgress(n, f, bl, bl2, false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRefreshProgress(int n, float f, boolean bl, boolean bl2, boolean bl3) {
        synchronized (this) {
            float f2 = this.getScale(f);
            Drawable drawable2 = this.mCurrentDrawable;
            if (drawable2 == null) {
                this.invalidate();
            } else {
                boolean bl4 = drawable2 instanceof LayerDrawable;
                Drawable drawable3 = null;
                if (bl4 && (drawable3 = ((LayerDrawable)drawable2).findDrawableByLayerId(n)) != null && this.canResolveLayoutDirection()) {
                    drawable3.setLayoutDirection(this.getLayoutDirection());
                }
                int n2 = (int)(10000.0f * f2);
                if (drawable3 == null) {
                    drawable3 = drawable2;
                }
                drawable3.setLevel(n2);
            }
            if (n == 16908301) {
                if (bl3) {
                    this.onAnimatePosition(f2, bl);
                } else if (bl2) {
                    this.onProgressRefresh(f2, bl);
                }
            }
            return;
        }
    }

    private float getScale(float f) {
        if (this.mMax > 0) {
            return f / (float)this.mMax;
        }
        return 0.0f;
    }

    private Drawable getTintTarget(int n, boolean bl) {
        Drawable drawable2 = this.mProgressDrawable;
        Drawable drawable3 = null;
        if (drawable2 != null) {
            this.mProgressDrawable = drawable2.mutate();
            boolean bl2 = drawable2 instanceof LayerDrawable;
            drawable3 = null;
            if (bl2) {
                drawable3 = ((LayerDrawable)drawable2).findDrawableByLayerId(n);
            }
            if (bl && drawable3 == null) {
                drawable3 = drawable2;
            }
        }
        return drawable3;
    }

    private void initProgressBar() {
        this.mMax = 100;
        this.mProgress = 0;
        this.mSecondaryProgress = 0;
        this.mIndeterminate = false;
        this.mOnlyIndeterminate = false;
        this.mDuration = 4000;
        this.mBehavior = 1;
        this.mMinWidth = 24;
        this.mMaxWidth = 48;
        this.mMinHeight = 24;
        this.mMaxHeight = 48;
    }

    private void refreshProgress(int n, float f, boolean bl) {
        synchronized (this) {
            this.refreshProgress(n, f, bl, false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshProgress(int n, float f, boolean bl, boolean bl2) {
        synchronized (this) {
            if (this.mUiThreadId == Thread.currentThread().getId()) {
                this.doRefreshProgress(n, f, bl, true, bl2);
            } else {
                if (this.mRefreshProgressRunnable == null) {
                    this.mRefreshProgressRunnable = new RefreshProgressRunnable();
                }
                RefreshData refreshData = RefreshData.obtain(n, f, bl, bl2);
                this.mRefreshData.add(refreshData);
                if (this.mAttached && !this.mRefreshIsPosted) {
                    this.post(this.mRefreshProgressRunnable);
                    this.mRefreshIsPosted = true;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scheduleAccessibilityEventSender() {
        if (this.mAccessibilityEventSender == null) {
            this.mAccessibilityEventSender = new AccessibilityEventSender();
        } else {
            this.removeCallbacks(this.mAccessibilityEventSender);
        }
        this.postDelayed(this.mAccessibilityEventSender, 200L);
    }

    private void setDrawableTint(int n, ColorStateList colorStateList, PorterDuff.Mode mode, boolean bl) {
        Drawable drawable2 = this.mCurrentDrawable;
        boolean bl2 = drawable2 instanceof LayerDrawable;
        Drawable drawable3 = null;
        if (bl2) {
            drawable3 = ((LayerDrawable)drawable2).findDrawableByLayerId(n);
        }
        if (bl && drawable3 == null) {
            drawable3 = drawable2;
        }
        drawable3.mutate();
        drawable3.setTintList(colorStateList);
        drawable3.setTintMode(mode);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Drawable tileify(Drawable drawable2, boolean bl) {
        Drawable[] drawableArray;
        int n;
        LayerDrawable layerDrawable;
        if (drawable2 instanceof LayerDrawable) {
            layerDrawable = (LayerDrawable)drawable2;
            n = layerDrawable.getNumberOfLayers();
            drawableArray = new Drawable[n];
        } else {
            ClipDrawable clipDrawable;
            void var5_20;
            if (drawable2 instanceof StateListDrawable) {
                StateListDrawable stateListDrawable = (StateListDrawable)drawable2;
                StateListDrawable stateListDrawable2 = new StateListDrawable();
                int n2 = stateListDrawable.getStateCount();
                int n3 = 0;
                while (n3 < n2) {
                    stateListDrawable2.addState(stateListDrawable.getStateSet(n3), this.tileify(stateListDrawable.getStateDrawable(n3), bl));
                    ++n3;
                }
                return stateListDrawable2;
            }
            if (!(drawable2 instanceof BitmapDrawable)) {
                return drawable2;
            }
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
            Bitmap bitmap = bitmapDrawable.getBitmap();
            if (this.mSampleTile == null) {
                this.mSampleTile = bitmap;
            }
            ShapeDrawable shapeDrawable = new ShapeDrawable(this.getDrawableShape());
            BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
            shapeDrawable.getPaint().setShader(bitmapShader);
            shapeDrawable.setTintList(bitmapDrawable.getTint());
            shapeDrawable.setTintMode(bitmapDrawable.getTintMode());
            shapeDrawable.setColorFilter(bitmapDrawable.getColorFilter());
            if (!bl) return var5_20;
            ClipDrawable clipDrawable2 = clipDrawable = new ClipDrawable(shapeDrawable, 3, 1);
            return var5_20;
        }
        for (int i = 0; i < n; ++i) {
            int n4 = layerDrawable.getId(i);
            Drawable drawable3 = layerDrawable.getDrawable(i);
            boolean bl2 = n4 == 16908301 || n4 == 16908303;
            drawableArray[i] = this.tileify(drawable3, bl2);
        }
        Drawable drawable4 = new LayerDrawable(drawableArray);
        int n5 = 0;
        while (n5 < n) {
            ((LayerDrawable)drawable4).setId(n5, layerDrawable.getId(n5));
            ++n5;
        }
        return drawable4;
    }

    private Drawable tileifyIndeterminate(Drawable drawable2) {
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable)drawable2;
            int n = animationDrawable.getNumberOfFrames();
            AnimationDrawable animationDrawable2 = new AnimationDrawable();
            animationDrawable2.setOneShot(animationDrawable.isOneShot());
            for (int i = 0; i < n; ++i) {
                Drawable drawable3 = this.tileify(animationDrawable.getFrame(i), true);
                drawable3.setLevel(10000);
                animationDrawable2.addFrame(drawable3, animationDrawable.getDuration(i));
            }
            animationDrawable2.setLevel(10000);
            drawable2 = animationDrawable2;
        }
        return drawable2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateDrawableBounds(int n, int n2) {
        int n3 = n - (this.mPaddingRight + this.mPaddingLeft);
        int n4 = n2 - (this.mPaddingTop + this.mPaddingBottom);
        int n5 = n3;
        int n6 = n4;
        if (this.mIndeterminateDrawable != null) {
            boolean bl = this.mOnlyIndeterminate;
            int n7 = 0;
            int n8 = 0;
            if (bl) {
                boolean bl2 = this.mIndeterminateDrawable instanceof AnimationDrawable;
                n7 = 0;
                n8 = 0;
                if (!bl2) {
                    int n9 = this.mIndeterminateDrawable.getIntrinsicWidth();
                    int n10 = this.mIndeterminateDrawable.getIntrinsicHeight();
                    float f = (float)n9 / (float)n10;
                    float f2 = (float)n3 / (float)n4;
                    float f3 = f == f2 ? 0 : (f > f2 ? 1 : -1);
                    n7 = 0;
                    n8 = 0;
                    if (f3 != false) {
                        if (f2 > f) {
                            int n11 = (int)(f * (float)n4);
                            n7 = (n3 - n11) / 2;
                            n5 = n7 + n11;
                        } else {
                            int n12 = (int)((float)n3 * (1.0f / f));
                            n8 = (n4 - n12) / 2;
                            n6 = n8 + n12;
                            n7 = 0;
                        }
                    }
                }
            }
            if (this.isLayoutRtl() && this.mMirrorForRtl) {
                int n13 = n7;
                n7 = n3 - n5;
                n5 = n3 - n13;
            }
            this.mIndeterminateDrawable.setBounds(n7, n8, n5, n6);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setBounds(0, 0, n5, n6);
        }
    }

    private void updateDrawableState() {
        int[] nArray = this.getDrawableState();
        if (this.mProgressDrawable != null && this.mProgressDrawable.isStateful()) {
            this.mProgressDrawable.setState(nArray);
        }
        if (this.mIndeterminateDrawable != null && this.mIndeterminateDrawable.isStateful()) {
            this.mIndeterminateDrawable.setState(nArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void drawTrack(Canvas canvas) {
        Drawable drawable2 = this.mCurrentDrawable;
        if (drawable2 != null) {
            int n = canvas.save();
            if (this.isLayoutRtl() && this.mMirrorForRtl) {
                canvas.translate(this.getWidth() - this.mPaddingRight, this.mPaddingTop);
                canvas.scale(-1.0f, 1.0f);
            } else {
                canvas.translate(this.mPaddingLeft, this.mPaddingTop);
            }
            long l = this.getDrawingTime();
            if (this.mHasAnimation) {
                this.mAnimation.getTransformation(l, this.mTransformation);
                float f = this.mTransformation.getAlpha();
                this.mInDrawing = true;
                drawable2.setLevel((int)(10000.0f * f));
                this.postInvalidateOnAnimation();
            }
            drawable2.draw(canvas);
            canvas.restoreToCount(n);
            if (this.mShouldStartAnimationDrawable && drawable2 instanceof Animatable) {
                ((Animatable)((Object)drawable2)).start();
                this.mShouldStartAnimationDrawable = false;
            }
        }
        return;
        finally {
            this.mInDrawing = false;
        }
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        super.drawableHotspotChanged(f, f2);
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setHotspot(f, f2);
        }
        if (this.mIndeterminateDrawable != null) {
            this.mIndeterminateDrawable.setHotspot(f, f2);
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateDrawableState();
    }

    float getAnimationPosition() {
        return this.mAnimationPosition;
    }

    Drawable getCurrentDrawable() {
        return this.mCurrentDrawable;
    }

    Shape getDrawableShape() {
        return new RoundRectShape(new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f}, null, null);
    }

    public Drawable getIndeterminateDrawable() {
        return this.mIndeterminateDrawable;
    }

    public ColorStateList getIndeterminateTintList() {
        if (this.mProgressTintInfo != null) {
            return this.mProgressTintInfo.mIndeterminateTintList;
        }
        return null;
    }

    public PorterDuff.Mode getIndeterminateTintMode() {
        if (this.mProgressTintInfo != null) {
            return this.mProgressTintInfo.mIndeterminateTintMode;
        }
        return null;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    @ViewDebug.ExportedProperty(category="progress")
    public int getMax() {
        synchronized (this) {
            int n = this.mMax;
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ViewDebug.ExportedProperty(category="progress")
    public int getProgress() {
        synchronized (this) {
            block6: {
                boolean bl = this.mIndeterminate;
                if (!bl) break block6;
                return 0;
            }
            int n = this.mProgress;
            return n;
        }
    }

    public ColorStateList getProgressBackgroundTintList() {
        if (this.mProgressTintInfo != null) {
            return this.mProgressTintInfo.mProgressBackgroundTintList;
        }
        return null;
    }

    public PorterDuff.Mode getProgressBackgroundTintMode() {
        if (this.mProgressTintInfo != null) {
            return this.mProgressTintInfo.mProgressBackgroundTintMode;
        }
        return null;
    }

    public Drawable getProgressDrawable() {
        return this.mProgressDrawable;
    }

    public ColorStateList getProgressTintList() {
        if (this.mProgressTintInfo != null) {
            return this.mProgressTintInfo.mProgressTintList;
        }
        return null;
    }

    public PorterDuff.Mode getProgressTintMode() {
        if (this.mProgressTintInfo != null) {
            return this.mProgressTintInfo.mProgressTintMode;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ViewDebug.ExportedProperty(category="progress")
    public int getSecondaryProgress() {
        synchronized (this) {
            block6: {
                boolean bl = this.mIndeterminate;
                if (!bl) break block6;
                return 0;
            }
            int n = this.mSecondaryProgress;
            return n;
        }
    }

    public ColorStateList getSecondaryProgressTintList() {
        if (this.mProgressTintInfo != null) {
            return this.mProgressTintInfo.mSecondaryProgressTintList;
        }
        return null;
    }

    public PorterDuff.Mode getSecondaryProgressTintMode() {
        if (this.mProgressTintInfo != null) {
            return this.mProgressTintInfo.mSecondaryProgressTintMode;
        }
        return null;
    }

    public final void incrementProgressBy(int n) {
        synchronized (this) {
            this.setProgress(n + this.mProgress);
            return;
        }
    }

    public final void incrementSecondaryProgressBy(int n) {
        synchronized (this) {
            this.setSecondaryProgress(n + this.mSecondaryProgress);
            return;
        }
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        block3: {
            block2: {
                if (this.mInDrawing) break block2;
                if (!this.verifyDrawable(drawable2)) break block3;
                Rect rect = drawable2.getBounds();
                int n = this.mScrollX + this.mPaddingLeft;
                int n2 = this.mScrollY + this.mPaddingTop;
                this.invalidate(n + rect.left, n2 + rect.top, n + rect.right, n2 + rect.bottom);
            }
            return;
        }
        super.invalidateDrawable(drawable2);
    }

    @ViewDebug.ExportedProperty(category="progress")
    public boolean isIndeterminate() {
        synchronized (this) {
            boolean bl = this.mIndeterminate;
            return bl;
        }
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.jumpToCurrentState();
        }
        if (this.mIndeterminateDrawable != null) {
            this.mIndeterminateDrawable.jumpToCurrentState();
        }
    }

    void onAnimatePosition(float f, boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIndeterminate) {
            this.startAnimation();
        }
        if (this.mRefreshData != null) {
            synchronized (this) {
                int n = this.mRefreshData.size();
                for (int i = 0; i < n; ++i) {
                    RefreshData refreshData = this.mRefreshData.get(i);
                    this.doRefreshProgress(refreshData.id, refreshData.progress, refreshData.fromUser, refreshData.animate);
                    refreshData.recycle();
                }
                this.mRefreshData.clear();
            }
        }
        this.mAttached = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void onDetachedFromWindow() {
        if (this.mIndeterminate) {
            this.stopAnimation();
        }
        if (this.mRefreshProgressRunnable != null) {
            this.removeCallbacks(this.mRefreshProgressRunnable);
        }
        // MONITORENTER : this
        if (this.mRefreshProgressRunnable != null && this.mRefreshIsPosted) {
            this.removeCallbacks(this.mRefreshProgressRunnable);
            this.mRefreshIsPosted = false;
        }
        // MONITOREXIT : this
        if (this.mAccessibilityEventSender != null) {
            this.removeCallbacks(this.mAccessibilityEventSender);
        }
        super.onDetachedFromWindow();
        this.mAttached = false;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        synchronized (this) {
            super.onDraw(canvas);
            this.drawTrack(canvas);
            return;
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(ProgressBar.class.getName());
        accessibilityEvent.setItemCount(this.mMax);
        accessibilityEvent.setCurrentItemIndex(this.mProgress);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(ProgressBar.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onMeasure(int n, int n2) {
        synchronized (this) {
            Drawable drawable2 = this.mCurrentDrawable;
            int n3 = 0;
            int n4 = 0;
            if (drawable2 != null) {
                n4 = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, drawable2.getIntrinsicWidth()));
                n3 = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, drawable2.getIntrinsicHeight()));
            }
            this.updateDrawableState();
            int n5 = n4 + (this.mPaddingLeft + this.mPaddingRight);
            int n6 = n3 + (this.mPaddingTop + this.mPaddingBottom);
            this.setMeasuredDimension(ProgressBar.resolveSizeAndState(n5, n, 0), ProgressBar.resolveSizeAndState(n6, n2, 0));
            return;
        }
    }

    void onProgressRefresh(float f, boolean bl) {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            this.scheduleAccessibilityEventSender();
        }
    }

    @Override
    public void onResolveDrawables(int n) {
        Drawable drawable2 = this.mCurrentDrawable;
        if (drawable2 != null) {
            drawable2.setLayoutDirection(n);
        }
        if (this.mIndeterminateDrawable != null) {
            this.mIndeterminateDrawable.setLayoutDirection(n);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setLayoutDirection(n);
        }
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setProgress(savedState.progress);
        this.setSecondaryProgress(savedState.secondaryProgress);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.progress = this.mProgress;
        savedState.secondaryProgress = this.mSecondaryProgress;
        return savedState;
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.updateDrawableBounds(n, n2);
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        block3: {
            block2: {
                super.onVisibilityChanged(view, n);
                if (!this.mIndeterminate) break block2;
                if (n != 8 && n != 4) break block3;
                this.stopAnimation();
            }
            return;
        }
        this.startAnimation();
    }

    @Override
    public void postInvalidate() {
        if (!this.mNoInvalidate) {
            super.postInvalidate();
        }
    }

    void setAnimationPosition(float f) {
        this.mAnimationPosition = f;
        this.refreshProgress(16908301, f, true, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RemotableViewMethod
    public void setIndeterminate(boolean bl) {
        synchronized (this) {
            block9: {
                block8: {
                    if (this.mOnlyIndeterminate && this.mIndeterminate || bl == this.mIndeterminate) break block8;
                    this.mIndeterminate = bl;
                    if (!bl) break block9;
                    this.mCurrentDrawable = this.mIndeterminateDrawable;
                    this.startAnimation();
                }
                return;
            }
            this.mCurrentDrawable = this.mProgressDrawable;
            this.stopAnimation();
            return;
        }
    }

    public void setIndeterminateDrawable(Drawable drawable2) {
        if (this.mIndeterminateDrawable != drawable2) {
            if (this.mIndeterminateDrawable != null) {
                this.mIndeterminateDrawable.setCallback(null);
                this.unscheduleDrawable(this.mIndeterminateDrawable);
            }
            this.mIndeterminateDrawable = drawable2;
            if (drawable2 != null) {
                drawable2.setCallback(this);
                drawable2.setLayoutDirection(this.getLayoutDirection());
                if (drawable2.isStateful()) {
                    drawable2.setState(this.getDrawableState());
                }
                this.applyIndeterminateTint();
            }
            if (this.mIndeterminate) {
                this.mCurrentDrawable = drawable2;
                this.postInvalidate();
            }
        }
    }

    public void setIndeterminateDrawableTiled(Drawable drawable2) {
        if (drawable2 != null) {
            drawable2 = this.tileifyIndeterminate(drawable2);
        }
        this.setIndeterminateDrawable(drawable2);
    }

    public void setIndeterminateTintList(ColorStateList colorStateList) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mIndeterminateTintList = colorStateList;
        this.mProgressTintInfo.mHasIndeterminateTint = true;
        this.applyIndeterminateTint();
    }

    public void setIndeterminateTintMode(PorterDuff.Mode mode) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mIndeterminateTintMode = mode;
        this.mProgressTintInfo.mHasIndeterminateTintMode = true;
        this.applyIndeterminateTint();
    }

    public void setInterpolator(Context context, int n) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, n));
    }

    public void setInterpolator(Interpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    @RemotableViewMethod
    public void setMax(int n) {
        synchronized (this) {
            if (n < 0) {
                n = 0;
            }
            if (n != this.mMax) {
                this.mMax = n;
                this.postInvalidate();
                if (this.mProgress > n) {
                    this.mProgress = n;
                }
                this.refreshProgress(16908301, this.mProgress, false);
            }
            return;
        }
    }

    @RemotableViewMethod
    public void setProgress(int n) {
        synchronized (this) {
            this.setProgress(n, false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RemotableViewMethod
    void setProgress(int n, boolean bl) {
        synchronized (this) {
            boolean bl2 = this.mIndeterminate;
            if (!bl2) {
                if (n < 0) {
                    n = 0;
                }
                if (n > this.mMax) {
                    n = this.mMax;
                }
                if (n != this.mProgress) {
                    this.mProgress = n;
                    this.refreshProgress(16908301, this.mProgress, bl);
                }
            }
            return;
        }
    }

    public void setProgressBackgroundTintList(ColorStateList colorStateList) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressBackgroundTintList = colorStateList;
        this.mProgressTintInfo.mHasProgressBackgroundTint = true;
        if (this.mProgressDrawable != null) {
            this.applyProgressBackgroundTint();
        }
    }

    public void setProgressBackgroundTintMode(PorterDuff.Mode mode) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressBackgroundTintMode = mode;
        this.mProgressTintInfo.mHasProgressBackgroundTintMode = true;
        if (this.mProgressDrawable != null) {
            this.applyProgressBackgroundTint();
        }
    }

    public void setProgressDrawable(Drawable drawable2) {
        if (this.mProgressDrawable != drawable2) {
            if (this.mProgressDrawable != null) {
                this.mProgressDrawable.setCallback(null);
                this.unscheduleDrawable(this.mProgressDrawable);
            }
            this.mProgressDrawable = drawable2;
            if (drawable2 != null) {
                int n;
                drawable2.setCallback(this);
                drawable2.setLayoutDirection(this.getLayoutDirection());
                if (drawable2.isStateful()) {
                    drawable2.setState(this.getDrawableState());
                }
                if (this.mMaxHeight < (n = drawable2.getMinimumHeight())) {
                    this.mMaxHeight = n;
                    this.requestLayout();
                }
                this.applyProgressTints();
            }
            if (!this.mIndeterminate) {
                this.mCurrentDrawable = drawable2;
                this.postInvalidate();
            }
            this.updateDrawableBounds(this.getWidth(), this.getHeight());
            this.updateDrawableState();
            this.doRefreshProgress(16908301, this.mProgress, false, false);
            this.doRefreshProgress(16908303, this.mSecondaryProgress, false, false);
        }
    }

    public void setProgressDrawableTiled(Drawable drawable2) {
        if (drawable2 != null) {
            drawable2 = this.tileify(drawable2, false);
        }
        this.setProgressDrawable(drawable2);
    }

    public void setProgressTintList(ColorStateList colorStateList) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressTintList = colorStateList;
        this.mProgressTintInfo.mHasProgressTint = true;
        if (this.mProgressDrawable != null) {
            this.applyPrimaryProgressTint();
        }
    }

    public void setProgressTintMode(PorterDuff.Mode mode) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressTintMode = mode;
        this.mProgressTintInfo.mHasProgressTintMode = true;
        if (this.mProgressDrawable != null) {
            this.applyPrimaryProgressTint();
        }
    }

    void setProgressValueOnly(int n) {
        this.mProgress = n;
        this.onProgressRefresh(this.getScale(n), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RemotableViewMethod
    public void setSecondaryProgress(int n) {
        synchronized (this) {
            boolean bl = this.mIndeterminate;
            if (!bl) {
                if (n < 0) {
                    n = 0;
                }
                if (n > this.mMax) {
                    n = this.mMax;
                }
                if (n != this.mSecondaryProgress) {
                    this.mSecondaryProgress = n;
                    this.refreshProgress(16908303, this.mSecondaryProgress, false);
                }
            }
            return;
        }
    }

    public void setSecondaryProgressTintList(ColorStateList colorStateList) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mSecondaryProgressTintList = colorStateList;
        this.mProgressTintInfo.mHasSecondaryProgressTint = true;
        if (this.mProgressDrawable != null) {
            this.applySecondaryProgressTint();
        }
    }

    public void setSecondaryProgressTintMode(PorterDuff.Mode mode) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mSecondaryProgressTintMode = mode;
        this.mProgressTintInfo.mHasSecondaryProgressTintMode = true;
        if (this.mProgressDrawable != null) {
            this.applySecondaryProgressTint();
        }
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        block3: {
            block2: {
                if (this.getVisibility() == n) break block2;
                super.setVisibility(n);
                if (!this.mIndeterminate) break block2;
                if (n != 8 && n != 4) break block3;
                this.stopAnimation();
            }
            return;
        }
        this.startAnimation();
    }

    /*
     * Enabled aggressive block sorting
     */
    void startAnimation() {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.mIndeterminateDrawable instanceof Animatable) {
            this.mShouldStartAnimationDrawable = true;
            this.mHasAnimation = false;
        } else {
            this.mHasAnimation = true;
            if (this.mInterpolator == null) {
                this.mInterpolator = new LinearInterpolator();
            }
            if (this.mTransformation == null) {
                this.mTransformation = new Transformation();
            } else {
                this.mTransformation.clear();
            }
            if (this.mAnimation == null) {
                this.mAnimation = new AlphaAnimation(0.0f, 1.0f);
            } else {
                this.mAnimation.reset();
            }
            this.mAnimation.setRepeatMode(this.mBehavior);
            this.mAnimation.setRepeatCount(-1);
            this.mAnimation.setDuration(this.mDuration);
            this.mAnimation.setInterpolator(this.mInterpolator);
            this.mAnimation.setStartTime(-1L);
        }
        this.postInvalidate();
    }

    void stopAnimation() {
        this.mHasAnimation = false;
        if (this.mIndeterminateDrawable instanceof Animatable) {
            ((Animatable)((Object)this.mIndeterminateDrawable)).stop();
            this.mShouldStartAnimationDrawable = false;
        }
        this.postInvalidate();
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return drawable2 == this.mProgressDrawable || drawable2 == this.mIndeterminateDrawable || super.verifyDrawable(drawable2);
    }

    private class AccessibilityEventSender
    implements Runnable {
        private AccessibilityEventSender() {
        }

        @Override
        public void run() {
            ProgressBar.this.sendAccessibilityEvent(4);
        }
    }

    private static class ProgressTintInfo {
        boolean mHasIndeterminateTint;
        boolean mHasIndeterminateTintMode;
        boolean mHasProgressBackgroundTint;
        boolean mHasProgressBackgroundTintMode;
        boolean mHasProgressTint;
        boolean mHasProgressTintMode;
        boolean mHasSecondaryProgressTint;
        boolean mHasSecondaryProgressTintMode;
        ColorStateList mIndeterminateTintList;
        PorterDuff.Mode mIndeterminateTintMode;
        ColorStateList mProgressBackgroundTintList;
        PorterDuff.Mode mProgressBackgroundTintMode;
        ColorStateList mProgressTintList;
        PorterDuff.Mode mProgressTintMode;
        ColorStateList mSecondaryProgressTintList;
        PorterDuff.Mode mSecondaryProgressTintMode;

        private ProgressTintInfo() {
        }
    }

    private static class RefreshData {
        private static final int POOL_MAX = 24;
        private static final Pools.SynchronizedPool<RefreshData> sPool = new Pools.SynchronizedPool(24);
        public boolean animate;
        public boolean fromUser;
        public int id;
        public float progress;

        private RefreshData() {
        }

        public static RefreshData obtain(int n, float f, boolean bl, boolean bl2) {
            RefreshData refreshData = sPool.acquire();
            if (refreshData == null) {
                refreshData = new RefreshData();
            }
            refreshData.id = n;
            refreshData.progress = f;
            refreshData.fromUser = bl;
            refreshData.animate = bl2;
            return refreshData;
        }

        public void recycle() {
            sPool.release(this);
        }
    }

    private class RefreshProgressRunnable
    implements Runnable {
        private RefreshProgressRunnable() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ProgressBar progressBar = ProgressBar.this;
            synchronized (progressBar) {
                int n = ProgressBar.this.mRefreshData.size();
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        ProgressBar.this.mRefreshData.clear();
                        ProgressBar.access$302(ProgressBar.this, false);
                        return;
                    }
                    RefreshData refreshData = (RefreshData)ProgressBar.this.mRefreshData.get(n2);
                    ProgressBar.this.doRefreshProgress(refreshData.id, refreshData.progress, refreshData.fromUser, true, refreshData.animate);
                    refreshData.recycle();
                    ++n2;
                }
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int progress;
        int secondaryProgress;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.progress = parcel.readInt();
            this.secondaryProgress = parcel.readInt();
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.progress);
            parcel.writeInt(this.secondaryProgress);
        }
    }
}

