/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.animation.DecelerateInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Scroller;
import android.widget.TextView;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import libcore.icu.LocaleData;

public class NumberPicker
extends LinearLayout {
    private static final int DEFAULT_LAYOUT_RESOURCE_ID = 17367201;
    private static final long DEFAULT_LONG_PRESS_UPDATE_INTERVAL = 300L;
    private static final char[] DIGIT_CHARACTERS;
    private static final int SELECTOR_ADJUSTMENT_DURATION_MILLIS = 800;
    private static final int SELECTOR_MAX_FLING_VELOCITY_ADJUSTMENT = 8;
    private static final int SELECTOR_MIDDLE_ITEM_INDEX = 1;
    private static final int SELECTOR_WHEEL_ITEM_COUNT = 3;
    private static final int SIZE_UNSPECIFIED = -1;
    private static final int SNAP_SCROLL_DURATION = 300;
    private static final float TOP_AND_BOTTOM_FADING_EDGE_STRENGTH = 0.9f;
    private static final int UNSCALED_DEFAULT_SELECTION_DIVIDERS_DISTANCE = 48;
    private static final int UNSCALED_DEFAULT_SELECTION_DIVIDER_HEIGHT = 2;
    private static final TwoDigitFormatter sTwoDigitFormatter;
    private AccessibilityNodeProviderImpl mAccessibilityNodeProvider;
    private final Scroller mAdjustScroller;
    private BeginSoftInputOnLongPressCommand mBeginSoftInputOnLongPressCommand;
    private int mBottomSelectionDividerBottom;
    private ChangeCurrentByOneFromLongPressCommand mChangeCurrentByOneFromLongPressCommand;
    private final boolean mComputeMaxWidth;
    private int mCurrentScrollOffset;
    private final ImageButton mDecrementButton;
    private boolean mDecrementVirtualButtonPressed;
    private String[] mDisplayedValues;
    private final Scroller mFlingScroller;
    private Formatter mFormatter;
    private final boolean mHasSelectorWheel;
    private boolean mHideWheelUntilFocused;
    private boolean mIgnoreMoveEvents;
    private final ImageButton mIncrementButton;
    private boolean mIncrementVirtualButtonPressed;
    private int mInitialScrollOffset;
    private final EditText mInputText;
    private long mLastDownEventTime;
    private float mLastDownEventY;
    private float mLastDownOrMoveEventY;
    private int mLastHandledDownDpadKeyCode = -1;
    private int mLastHoveredChildVirtualViewId;
    private long mLongPressUpdateInterval = 300L;
    private final int mMaxHeight;
    private int mMaxValue;
    private int mMaxWidth;
    private int mMaximumFlingVelocity;
    private final int mMinHeight;
    private int mMinValue;
    private final int mMinWidth;
    private int mMinimumFlingVelocity;
    private OnScrollListener mOnScrollListener;
    private OnValueChangeListener mOnValueChangeListener;
    private boolean mPerformClickOnTap;
    private final PressedStateHelper mPressedStateHelper;
    private int mPreviousScrollerY;
    private int mScrollState = 0;
    private final Drawable mSelectionDivider;
    private final int mSelectionDividerHeight;
    private final int mSelectionDividersDistance;
    private int mSelectorElementHeight;
    private final SparseArray<String> mSelectorIndexToStringCache = new SparseArray();
    private final int[] mSelectorIndices = new int[3];
    private int mSelectorTextGapHeight;
    private final Paint mSelectorWheelPaint;
    private SetSelectionCommand mSetSelectionCommand;
    private final int mSolidColor;
    private final int mTextSize;
    private int mTopSelectionDividerTop;
    private int mTouchSlop;
    private int mValue;
    private VelocityTracker mVelocityTracker;
    private final Drawable mVirtualButtonPressedDrawable;
    private boolean mWrapSelectorWheel;

    static {
        sTwoDigitFormatter = new TwoDigitFormatter();
        DIGIT_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0660', '\u0661', '\u0662', '\u0663', '\u0664', '\u0665', '\u0666', '\u0667', '\u0668', '\u0669', '\u06f0', '\u06f1', '\u06f2', '\u06f3', '\u06f4', '\u06f5', '\u06f6', '\u06f7', '\u06f8', '\u06f9', '\u0966', '\u0967', '\u0968', '\u0969', '\u096a', '\u096b', '\u096c', '\u096d', '\u096e', '\u096f', '\u09e6', '\u09e7', '\u09e8', '\u09e9', '\u09ea', '\u09eb', '\u09ec', '\u09ed', '\u09ee', '\u09ef', '\u0ce6', '\u0ce7', '\u0ce8', '\u0ce9', '\u0cea', '\u0ceb', '\u0cec', '\u0ced', '\u0cee', '\u0cef'};
    }

    public NumberPicker(Context context) {
        this(context, null);
    }

    public NumberPicker(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843810);
    }

    public NumberPicker(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public NumberPicker(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mInitialScrollOffset = Integer.MIN_VALUE;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.NumberPicker, n, n2);
        int n3 = typedArray.getResourceId(1, 17367201);
        boolean bl = n3 != 17367201;
        this.mHasSelectorWheel = bl;
        this.mHideWheelUntilFocused = typedArray.getBoolean(10, false);
        this.mSolidColor = typedArray.getColor(0, 0);
        this.mSelectionDivider = typedArray.getDrawable(2);
        this.mSelectionDividerHeight = typedArray.getDimensionPixelSize(3, (int)TypedValue.applyDimension(1, 2.0f, this.getResources().getDisplayMetrics()));
        this.mSelectionDividersDistance = typedArray.getDimensionPixelSize(4, (int)TypedValue.applyDimension(1, 48.0f, this.getResources().getDisplayMetrics()));
        this.mMinHeight = typedArray.getDimensionPixelSize(5, -1);
        this.mMaxHeight = typedArray.getDimensionPixelSize(6, -1);
        if (this.mMinHeight != -1 && this.mMaxHeight != -1 && this.mMinHeight > this.mMaxHeight) {
            throw new IllegalArgumentException("minHeight > maxHeight");
        }
        this.mMinWidth = typedArray.getDimensionPixelSize(7, -1);
        this.mMaxWidth = typedArray.getDimensionPixelSize(8, -1);
        if (this.mMinWidth != -1 && this.mMaxWidth != -1 && this.mMinWidth > this.mMaxWidth) {
            throw new IllegalArgumentException("minWidth > maxWidth");
        }
        boolean bl2 = this.mMaxWidth == -1;
        this.mComputeMaxWidth = bl2;
        this.mVirtualButtonPressedDrawable = typedArray.getDrawable(9);
        typedArray.recycle();
        this.mPressedStateHelper = new PressedStateHelper();
        boolean bl3 = !this.mHasSelectorWheel;
        this.setWillNotDraw(bl3);
        ((LayoutInflater)this.getContext().getSystemService("layout_inflater")).inflate(n3, (ViewGroup)this, true);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                NumberPicker.this.hideSoftInput();
                NumberPicker.this.mInputText.clearFocus();
                if (view.getId() == 16909197) {
                    NumberPicker.this.changeValueByOne(true);
                    return;
                }
                NumberPicker.this.changeValueByOne(false);
            }
        };
        View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){

            @Override
            public boolean onLongClick(View view) {
                NumberPicker.this.hideSoftInput();
                NumberPicker.this.mInputText.clearFocus();
                if (view.getId() == 16909197) {
                    NumberPicker.this.postChangeCurrentByOneFromLongPress(true, 0L);
                    return true;
                }
                NumberPicker.this.postChangeCurrentByOneFromLongPress(false, 0L);
                return true;
            }
        };
        if (!this.mHasSelectorWheel) {
            this.mIncrementButton = (ImageButton)this.findViewById(16909197);
            this.mIncrementButton.setOnClickListener(onClickListener);
            this.mIncrementButton.setOnLongClickListener(onLongClickListener);
        } else {
            this.mIncrementButton = null;
        }
        if (!this.mHasSelectorWheel) {
            this.mDecrementButton = (ImageButton)this.findViewById(16909199);
            this.mDecrementButton.setOnClickListener(onClickListener);
            this.mDecrementButton.setOnLongClickListener(onLongClickListener);
        } else {
            this.mDecrementButton = null;
        }
        EditText editText = this.mInputText = (EditText)this.findViewById(16909198);
        View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

            @Override
            public void onFocusChange(View view, boolean bl) {
                if (bl) {
                    NumberPicker.this.mInputText.selectAll();
                    return;
                }
                NumberPicker.this.mInputText.setSelection(0, 0);
                NumberPicker.this.validateInputTextView(view);
            }
        };
        editText.setOnFocusChangeListener(onFocusChangeListener);
        EditText editText2 = this.mInputText;
        InputFilter[] inputFilterArray = new InputFilter[]{new InputTextFilter()};
        editText2.setFilters(inputFilterArray);
        this.mInputText.setRawInputType(2);
        this.mInputText.setImeOptions(6);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinimumFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity() / 8;
        this.mTextSize = (int)this.mInputText.getTextSize();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setTextSize(this.mTextSize);
        paint.setTypeface(this.mInputText.getTypeface());
        paint.setColor(this.mInputText.getTextColors().getColorForState(ENABLED_STATE_SET, -1));
        this.mSelectorWheelPaint = paint;
        this.mFlingScroller = new Scroller(this.getContext(), null, true);
        this.mAdjustScroller = new Scroller(this.getContext(), new DecelerateInterpolator(2.5f));
        this.updateInputTextView();
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    static /* synthetic */ boolean access$1302(NumberPicker numberPicker, boolean bl) {
        numberPicker.mIncrementVirtualButtonPressed = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1380(NumberPicker numberPicker, int n) {
        boolean bl;
        numberPicker.mIncrementVirtualButtonPressed = bl = (byte)(n ^ numberPicker.mIncrementVirtualButtonPressed);
        return bl;
    }

    static /* synthetic */ boolean access$1702(NumberPicker numberPicker, boolean bl) {
        numberPicker.mDecrementVirtualButtonPressed = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1780(NumberPicker numberPicker, int n) {
        boolean bl;
        numberPicker.mDecrementVirtualButtonPressed = bl = (byte)(n ^ numberPicker.mDecrementVirtualButtonPressed);
        return bl;
    }

    static /* synthetic */ int access$5200(NumberPicker numberPicker) {
        return numberPicker.mRight;
    }

    static /* synthetic */ int access$5300(NumberPicker numberPicker) {
        return numberPicker.mBottom;
    }

    static /* synthetic */ int access$5400(NumberPicker numberPicker) {
        return numberPicker.mRight;
    }

    static /* synthetic */ int access$5500(NumberPicker numberPicker) {
        return numberPicker.mBottom;
    }

    static /* synthetic */ int access$5600(NumberPicker numberPicker) {
        return numberPicker.mRight;
    }

    static /* synthetic */ int access$5700(NumberPicker numberPicker) {
        return numberPicker.mRight;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void changeValueByOne(boolean bl) {
        if (this.mHasSelectorWheel) {
            this.mInputText.setVisibility(4);
            if (!this.moveToFinalScrollerPosition(this.mFlingScroller)) {
                this.moveToFinalScrollerPosition(this.mAdjustScroller);
            }
            this.mPreviousScrollerY = 0;
            if (bl) {
                this.mFlingScroller.startScroll(0, 0, 0, -this.mSelectorElementHeight, 300);
            } else {
                this.mFlingScroller.startScroll(0, 0, 0, this.mSelectorElementHeight, 300);
            }
            this.invalidate();
            return;
        }
        if (bl) {
            this.setValueInternal(1 + this.mValue, true);
            return;
        }
        this.setValueInternal(-1 + this.mValue, true);
    }

    private void decrementSelectorIndices(int[] nArray) {
        for (int i = -1 + nArray.length; i > 0; --i) {
            nArray[i] = nArray[i - 1];
        }
        int n = -1 + nArray[1];
        if (this.mWrapSelectorWheel && n < this.mMinValue) {
            n = this.mMaxValue;
        }
        nArray[0] = n;
        this.ensureCachedScrollSelectorValue(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ensureCachedScrollSelectorValue(int n) {
        String string2;
        SparseArray<String> sparseArray = this.mSelectorIndexToStringCache;
        if (sparseArray.get(n) != null) {
            return;
        }
        if (n < this.mMinValue || n > this.mMaxValue) {
            string2 = "";
        } else if (this.mDisplayedValues != null) {
            int n2 = n - this.mMinValue;
            string2 = this.mDisplayedValues[n2];
        } else {
            string2 = this.formatNumber(n);
        }
        sparseArray.put(n, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean ensureScrollWheelAdjusted() {
        int n = this.mInitialScrollOffset - this.mCurrentScrollOffset;
        boolean bl = false;
        if (n == 0) return bl;
        this.mPreviousScrollerY = 0;
        if (Math.abs(n) > this.mSelectorElementHeight / 2) {
            int n2 = n > 0 ? -this.mSelectorElementHeight : this.mSelectorElementHeight;
            n += n2;
        }
        this.mAdjustScroller.startScroll(0, 0, 0, n, 800);
        this.invalidate();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fling(int n) {
        this.mPreviousScrollerY = 0;
        if (n > 0) {
            this.mFlingScroller.fling(0, 0, 0, n, 0, 0, 0, Integer.MAX_VALUE);
        } else {
            this.mFlingScroller.fling(0, Integer.MAX_VALUE, 0, n, 0, 0, 0, Integer.MAX_VALUE);
        }
        this.invalidate();
    }

    private String formatNumber(int n) {
        if (this.mFormatter != null) {
            return this.mFormatter.format(n);
        }
        return NumberPicker.formatNumberWithLocale(n);
    }

    private static String formatNumberWithLocale(int n) {
        Locale locale = Locale.getDefault();
        Object[] objectArray = new Object[]{n};
        return String.format(locale, "%d", objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getSelectedPos(String string2) {
        if (this.mDisplayedValues == null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return this.mMinValue;
            }
        }
        for (int i = 0; i < this.mDisplayedValues.length; string2 = string2.toLowerCase(), ++i) {
            if (!this.mDisplayedValues[i].toLowerCase().startsWith(string2)) continue;
            return i + this.mMinValue;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return this.mMinValue;
        }
    }

    public static final Formatter getTwoDigitFormatter() {
        return sTwoDigitFormatter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getWrappedSelectorIndex(int n) {
        if (n > this.mMaxValue) {
            return -1 + (this.mMinValue + (n - this.mMaxValue) % (this.mMaxValue - this.mMinValue));
        }
        if (n >= this.mMinValue) return n;
        return 1 + (this.mMaxValue - (this.mMinValue - n) % (this.mMaxValue - this.mMinValue));
    }

    private void hideSoftInput() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null && inputMethodManager.isActive(this.mInputText)) {
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            if (this.mHasSelectorWheel) {
                this.mInputText.setVisibility(4);
            }
        }
    }

    private void incrementSelectorIndices(int[] nArray) {
        for (int i = 0; i < -1 + nArray.length; ++i) {
            nArray[i] = nArray[i + 1];
        }
        int n = 1 + nArray[-2 + nArray.length];
        if (this.mWrapSelectorWheel && n > this.mMaxValue) {
            n = this.mMinValue;
        }
        nArray[-1 + nArray.length] = n;
        this.ensureCachedScrollSelectorValue(n);
    }

    private void initializeFadingEdges() {
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength((this.mBottom - this.mTop - this.mTextSize) / 2);
    }

    private void initializeSelectorWheel() {
        this.initializeSelectorWheelIndices();
        int[] nArray = this.mSelectorIndices;
        int n = nArray.length * this.mTextSize;
        this.mSelectorTextGapHeight = (int)(0.5f + (float)(this.mBottom - this.mTop - n) / (float)nArray.length);
        this.mSelectorElementHeight = this.mTextSize + this.mSelectorTextGapHeight;
        this.mCurrentScrollOffset = this.mInitialScrollOffset = this.mInputText.getBaseline() + this.mInputText.getTop() - 1 * this.mSelectorElementHeight;
        this.updateInputTextView();
    }

    private void initializeSelectorWheelIndices() {
        this.mSelectorIndexToStringCache.clear();
        int[] nArray = this.mSelectorIndices;
        int n = this.getValue();
        for (int i = 0; i < this.mSelectorIndices.length; ++i) {
            int n2 = n + (i - 1);
            if (this.mWrapSelectorWheel) {
                n2 = this.getWrappedSelectorIndex(n2);
            }
            nArray[i] = n2;
            this.ensureCachedScrollSelectorValue(nArray[i]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int makeMeasureSpec(int n, int n2) {
        if (n2 == -1) {
            return n;
        }
        int n3 = View.MeasureSpec.getSize(n);
        int n4 = View.MeasureSpec.getMode(n);
        switch (n4) {
            case 0x40000000: {
                return n;
            }
            default: {
                throw new IllegalArgumentException("Unknown measure mode: " + n4);
            }
            case -2147483648: {
                return View.MeasureSpec.makeMeasureSpec(Math.min(n3, n2), 0x40000000);
            }
            case 0: 
        }
        return View.MeasureSpec.makeMeasureSpec(n2, 0x40000000);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean moveToFinalScrollerPosition(Scroller scroller) {
        scroller.forceFinished(true);
        int n = scroller.getFinalY() - scroller.getCurrY();
        int n2 = (n + this.mCurrentScrollOffset) % this.mSelectorElementHeight;
        int n3 = this.mInitialScrollOffset - n2;
        if (n3 == 0) {
            return false;
        }
        if (Math.abs(n3) > this.mSelectorElementHeight / 2) {
            n3 = n3 > 0 ? (n3 -= this.mSelectorElementHeight) : (n3 += this.mSelectorElementHeight);
        }
        this.scrollBy(0, n + n3);
        return true;
    }

    private void notifyChange(int n, int n2) {
        if (this.mOnValueChangeListener != null) {
            this.mOnValueChangeListener.onValueChange(this, n, this.mValue);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onScrollStateChange(int n) {
        block3: {
            block2: {
                if (this.mScrollState == n) break block2;
                this.mScrollState = n;
                if (this.mOnScrollListener != null) break block3;
            }
            return;
        }
        this.mOnScrollListener.onScrollStateChange(this, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onScrollerFinished(Scroller scroller) {
        if (scroller == this.mFlingScroller) {
            if (!this.ensureScrollWheelAdjusted()) {
                this.updateInputTextView();
            }
            this.onScrollStateChange(0);
            return;
        } else {
            if (this.mScrollState == 1) return;
            this.updateInputTextView();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void postBeginSoftInputOnLongPressCommand() {
        if (this.mBeginSoftInputOnLongPressCommand == null) {
            this.mBeginSoftInputOnLongPressCommand = new BeginSoftInputOnLongPressCommand();
        } else {
            this.removeCallbacks(this.mBeginSoftInputOnLongPressCommand);
        }
        this.postDelayed(this.mBeginSoftInputOnLongPressCommand, ViewConfiguration.getLongPressTimeout());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void postChangeCurrentByOneFromLongPress(boolean bl, long l) {
        if (this.mChangeCurrentByOneFromLongPressCommand == null) {
            this.mChangeCurrentByOneFromLongPressCommand = new ChangeCurrentByOneFromLongPressCommand();
        } else {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        this.mChangeCurrentByOneFromLongPressCommand.setStep(bl);
        this.postDelayed(this.mChangeCurrentByOneFromLongPressCommand, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void postSetSelectionCommand(int n, int n2) {
        if (this.mSetSelectionCommand == null) {
            this.mSetSelectionCommand = new SetSelectionCommand();
        } else {
            this.removeCallbacks(this.mSetSelectionCommand);
        }
        SetSelectionCommand.access$602(this.mSetSelectionCommand, n);
        SetSelectionCommand.access$702(this.mSetSelectionCommand, n2);
        this.post(this.mSetSelectionCommand);
    }

    private void removeAllCallbacks() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        if (this.mSetSelectionCommand != null) {
            this.removeCallbacks(this.mSetSelectionCommand);
        }
        if (this.mBeginSoftInputOnLongPressCommand != null) {
            this.removeCallbacks(this.mBeginSoftInputOnLongPressCommand);
        }
        this.mPressedStateHelper.cancel();
    }

    private void removeBeginSoftInputCommand() {
        if (this.mBeginSoftInputOnLongPressCommand != null) {
            this.removeCallbacks(this.mBeginSoftInputOnLongPressCommand);
        }
    }

    private void removeChangeCurrentByOneFromLongPress() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
    }

    private int resolveSizeAndStateRespectingMinSize(int n, int n2, int n3) {
        if (n != -1) {
            n2 = NumberPicker.resolveSizeAndState(Math.max(n, n2), n3, 0);
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setValueInternal(int n, boolean bl) {
        if (this.mValue == n) {
            return;
        }
        int n2 = this.mWrapSelectorWheel ? this.getWrappedSelectorIndex(n) : Math.min(Math.max(n, this.mMinValue), this.mMaxValue);
        int n3 = this.mValue;
        this.mValue = n2;
        this.updateInputTextView();
        if (bl) {
            this.notifyChange(n3, n2);
        }
        this.initializeSelectorWheelIndices();
        this.invalidate();
    }

    private void showSoftInput() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null) {
            if (this.mHasSelectorWheel) {
                this.mInputText.setVisibility(0);
            }
            this.mInputText.requestFocus();
            inputMethodManager.showSoftInput(this.mInputText, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void tryComputeMaxWidth() {
        int n;
        block9: {
            block8: {
                if (!this.mComputeMaxWidth) break block8;
                int n2 = 0;
                if (this.mDisplayedValues == null) {
                    float f = 0.0f;
                    for (int i = 0; i <= 9; ++i) {
                        float f2 = this.mSelectorWheelPaint.measureText(NumberPicker.formatNumberWithLocale(i));
                        if (!(f2 > f)) continue;
                        f = f2;
                    }
                    int n3 = 0;
                    for (int i = this.mMaxValue; i > 0; ++n3, i /= 10) {
                    }
                    n2 = (int)(f * (float)n3);
                } else {
                    int n4 = this.mDisplayedValues.length;
                    for (int i = 0; i < n4; ++i) {
                        float f = this.mSelectorWheelPaint.measureText(this.mDisplayedValues[i]);
                        if (!(f > (float)n2)) continue;
                        n2 = (int)f;
                    }
                }
                if (this.mMaxWidth != (n = n2 + (this.mInputText.getPaddingLeft() + this.mInputText.getPaddingRight()))) break block9;
            }
            return;
        }
        this.mMaxWidth = n > this.mMinWidth ? n : this.mMinWidth;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateInputTextView() {
        String string2 = this.mDisplayedValues == null ? this.formatNumber(this.mValue) : this.mDisplayedValues[this.mValue - this.mMinValue];
        if (!TextUtils.isEmpty(string2) && !string2.equals(this.mInputText.getText().toString())) {
            this.mInputText.setText(string2);
            return true;
        }
        return false;
    }

    private void validateInputTextView(View view) {
        String string2 = String.valueOf(((TextView)view).getText());
        if (TextUtils.isEmpty(string2)) {
            this.updateInputTextView();
            return;
        }
        this.setValueInternal(this.getSelectedPos(string2.toString()), true);
    }

    @Override
    public void computeScroll() {
        Scroller scroller = this.mFlingScroller;
        if (scroller.isFinished() && (scroller = this.mAdjustScroller).isFinished()) {
            return;
        }
        scroller.computeScrollOffset();
        int n = scroller.getCurrY();
        if (this.mPreviousScrollerY == 0) {
            this.mPreviousScrollerY = scroller.getStartY();
        }
        this.scrollBy(0, n - this.mPreviousScrollerY);
        this.mPreviousScrollerY = n;
        if (scroller.isFinished()) {
            this.onScrollerFinished(scroller);
            return;
        }
        this.invalidate();
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return this.getHeight();
    }

    @Override
    protected int computeVerticalScrollOffset() {
        return this.mCurrentScrollOffset;
    }

    @Override
    protected int computeVerticalScrollRange() {
        return (1 + (this.mMaxValue - this.mMinValue)) * this.mSelectorElementHeight;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean dispatchHoverEvent(MotionEvent motionEvent) {
        if (!this.mHasSelectorWheel) {
            return super.dispatchHoverEvent(motionEvent);
        }
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) return false;
        int n = (int)motionEvent.getY();
        int n2 = n < this.mTopSelectionDividerTop ? 3 : (n > this.mBottomSelectionDividerBottom ? 1 : 2);
        int n3 = motionEvent.getActionMasked();
        AccessibilityNodeProviderImpl accessibilityNodeProviderImpl = (AccessibilityNodeProviderImpl)this.getAccessibilityNodeProvider();
        switch (n3) {
            case 9: {
                accessibilityNodeProviderImpl.sendAccessibilityEventForVirtualView(n2, 128);
                this.mLastHoveredChildVirtualViewId = n2;
                accessibilityNodeProviderImpl.performAction(n2, 64, null);
                return false;
            }
            case 7: {
                if (this.mLastHoveredChildVirtualViewId == n2) return false;
                if (this.mLastHoveredChildVirtualViewId == -1) return false;
                accessibilityNodeProviderImpl.sendAccessibilityEventForVirtualView(this.mLastHoveredChildVirtualViewId, 256);
                accessibilityNodeProviderImpl.sendAccessibilityEventForVirtualView(n2, 128);
                this.mLastHoveredChildVirtualViewId = n2;
                accessibilityNodeProviderImpl.performAction(n2, 64, null);
                return false;
            }
            case 10: {
                accessibilityNodeProviderImpl.sendAccessibilityEventForVirtualView(n2, 256);
                this.mLastHoveredChildVirtualViewId = -1;
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        boolean bl = true;
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 23: 
            case 66: {
                this.removeAllCallbacks();
            }
            default: {
                return super.dispatchKeyEvent(keyEvent);
            }
            case 19: 
            case 20: {
                if (!this.mHasSelectorWheel) return super.dispatchKeyEvent(keyEvent);
                switch (keyEvent.getAction()) {
                    default: {
                        return super.dispatchKeyEvent(keyEvent);
                    }
                    case 0: {
                        if (!this.mWrapSelectorWheel) {
                            if (n == 20) {
                                if (this.getValue() >= this.getMaxValue()) return super.dispatchKeyEvent(keyEvent);
                            } else if (this.getValue() <= this.getMinValue()) return super.dispatchKeyEvent(keyEvent);
                        }
                        this.requestFocus();
                        this.mLastHandledDownDpadKeyCode = n;
                        this.removeAllCallbacks();
                        if (!this.mFlingScroller.isFinished()) return bl;
                        boolean bl2 = n == 20 ? bl : false;
                        this.changeValueByOne(bl2);
                        return bl;
                    }
                    case 1: {
                        if (this.mLastHandledDownDpadKeyCode != n) return super.dispatchKeyEvent(keyEvent);
                        this.mLastHandledDownDpadKeyCode = -1;
                        return bl;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            default: {
                return super.dispatchTouchEvent(motionEvent);
            }
            case 1: 
            case 3: 
        }
        this.removeAllCallbacks();
        return super.dispatchTouchEvent(motionEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            default: {
                return super.dispatchTrackballEvent(motionEvent);
            }
            case 1: 
            case 3: 
        }
        this.removeAllCallbacks();
        return super.dispatchTrackballEvent(motionEvent);
    }

    @Override
    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (!this.mHasSelectorWheel) {
            return super.getAccessibilityNodeProvider();
        }
        if (this.mAccessibilityNodeProvider == null) {
            this.mAccessibilityNodeProvider = new AccessibilityNodeProviderImpl();
        }
        return this.mAccessibilityNodeProvider;
    }

    @Override
    protected float getBottomFadingEdgeStrength() {
        return 0.9f;
    }

    public String[] getDisplayedValues() {
        return this.mDisplayedValues;
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    @Override
    public int getSolidColor() {
        return this.mSolidColor;
    }

    @Override
    protected float getTopFadingEdgeStrength() {
        return 0.9f;
    }

    public int getValue() {
        return this.mValue;
    }

    public boolean getWrapSelectorWheel() {
        return this.mWrapSelectorWheel;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeAllCallbacks();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        if (!this.mHasSelectorWheel) {
            super.onDraw(canvas);
            return;
        } else {
            boolean bl = this.mHideWheelUntilFocused ? this.hasFocus() : true;
            float f = (this.mRight - this.mLeft) / 2;
            float f2 = this.mCurrentScrollOffset;
            if (bl && this.mVirtualButtonPressedDrawable != null && this.mScrollState == 0) {
                if (this.mDecrementVirtualButtonPressed) {
                    this.mVirtualButtonPressedDrawable.setState(PRESSED_STATE_SET);
                    this.mVirtualButtonPressedDrawable.setBounds(0, 0, this.mRight, this.mTopSelectionDividerTop);
                    this.mVirtualButtonPressedDrawable.draw(canvas);
                }
                if (this.mIncrementVirtualButtonPressed) {
                    this.mVirtualButtonPressedDrawable.setState(PRESSED_STATE_SET);
                    this.mVirtualButtonPressedDrawable.setBounds(0, this.mBottomSelectionDividerBottom, this.mRight, this.mBottom);
                    this.mVirtualButtonPressedDrawable.draw(canvas);
                }
            }
            int[] nArray = this.mSelectorIndices;
            for (int i = 0; i < nArray.length; f2 += (float)this.mSelectorElementHeight, ++i) {
                int n = nArray[i];
                String string2 = this.mSelectorIndexToStringCache.get(n);
                if ((!bl || i == 1) && (i != 1 || this.mInputText.getVisibility() == 0)) continue;
                canvas.drawText(string2, f, f2, this.mSelectorWheelPaint);
            }
            if (!bl || this.mSelectionDivider == null) return;
            int n = this.mTopSelectionDividerTop;
            int n2 = n + this.mSelectionDividerHeight;
            this.mSelectionDivider.setBounds(0, n, this.mRight, n2);
            this.mSelectionDivider.draw(canvas);
            int n3 = this.mBottomSelectionDividerBottom;
            int n4 = n3 - this.mSelectionDividerHeight;
            this.mSelectionDivider.setBounds(0, n4, this.mRight, n3);
            this.mSelectionDivider.draw(canvas);
            return;
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(NumberPicker.class.getName());
        accessibilityEvent.setScrollable(true);
        accessibilityEvent.setScrollY((this.mMinValue + this.mValue) * this.mSelectorElementHeight);
        accessibilityEvent.setMaxScrollY((this.mMaxValue - this.mMinValue) * this.mSelectorElementHeight);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        float f;
        if (!this.mHasSelectorWheel || !this.isEnabled()) {
            return false;
        }
        switch (motionEvent.getActionMasked()) {
            default: {
                return false;
            }
            case 0: 
        }
        this.removeAllCallbacks();
        this.mInputText.setVisibility(4);
        this.mLastDownEventY = f = motionEvent.getY();
        this.mLastDownOrMoveEventY = f;
        this.mLastDownEventTime = motionEvent.getEventTime();
        this.mIgnoreMoveEvents = false;
        this.mPerformClickOnTap = false;
        if (this.mLastDownEventY < (float)this.mTopSelectionDividerTop) {
            if (this.mScrollState == 0) {
                this.mPressedStateHelper.buttonPressDelayed(2);
            }
        } else if (this.mLastDownEventY > (float)this.mBottomSelectionDividerBottom && this.mScrollState == 0) {
            this.mPressedStateHelper.buttonPressDelayed(1);
        }
        this.getParent().requestDisallowInterceptTouchEvent(true);
        if (!this.mFlingScroller.isFinished()) {
            this.mFlingScroller.forceFinished(true);
            this.mAdjustScroller.forceFinished(true);
            this.onScrollStateChange(0);
            return true;
        }
        if (!this.mAdjustScroller.isFinished()) {
            this.mFlingScroller.forceFinished(true);
            this.mAdjustScroller.forceFinished(true);
            return true;
        }
        if (this.mLastDownEventY < (float)this.mTopSelectionDividerTop) {
            this.hideSoftInput();
            this.postChangeCurrentByOneFromLongPress(false, ViewConfiguration.getLongPressTimeout());
            return true;
        }
        if (this.mLastDownEventY > (float)this.mBottomSelectionDividerBottom) {
            this.hideSoftInput();
            this.postChangeCurrentByOneFromLongPress(true, ViewConfiguration.getLongPressTimeout());
            return true;
        }
        this.mPerformClickOnTap = true;
        this.postBeginSoftInputOnLongPressCommand();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (!this.mHasSelectorWheel) {
            super.onLayout(bl, n, n2, n3, n4);
            return;
        } else {
            int n5 = this.getMeasuredWidth();
            int n6 = this.getMeasuredHeight();
            int n7 = this.mInputText.getMeasuredWidth();
            int n8 = this.mInputText.getMeasuredHeight();
            int n9 = (n5 - n7) / 2;
            int n10 = (n6 - n8) / 2;
            int n11 = n9 + n7;
            int n12 = n10 + n8;
            this.mInputText.layout(n9, n10, n11, n12);
            if (!bl) return;
            this.initializeSelectorWheel();
            this.initializeFadingEdges();
            this.mTopSelectionDividerTop = (this.getHeight() - this.mSelectionDividersDistance) / 2 - this.mSelectionDividerHeight;
            this.mBottomSelectionDividerBottom = this.mTopSelectionDividerTop + 2 * this.mSelectionDividerHeight + this.mSelectionDividersDistance;
            return;
        }
    }

    @Override
    protected void onMeasure(int n, int n2) {
        if (!this.mHasSelectorWheel) {
            super.onMeasure(n, n2);
            return;
        }
        super.onMeasure(this.makeMeasureSpec(n, this.mMaxWidth), this.makeMeasureSpec(n2, this.mMaxHeight));
        this.setMeasuredDimension(this.resolveSizeAndStateRespectingMinSize(this.mMinWidth, this.getMeasuredWidth(), n), this.resolveSizeAndStateRespectingMinSize(this.mMinHeight, this.getMeasuredHeight(), n2));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        block13: {
            block16: {
                block14: {
                    int n;
                    block15: {
                        block12: {
                            if (!this.isEnabled()) return false;
                            if (!this.mHasSelectorWheel) {
                                return false;
                            }
                            if (this.mVelocityTracker == null) {
                                this.mVelocityTracker = VelocityTracker.obtain();
                            }
                            this.mVelocityTracker.addMovement(motionEvent);
                            switch (motionEvent.getActionMasked()) {
                                case 2: {
                                    if (this.mIgnoreMoveEvents) return true;
                                    float f = motionEvent.getY();
                                    if (this.mScrollState != 1) {
                                        if ((int)Math.abs(f - this.mLastDownEventY) > this.mTouchSlop) {
                                            this.removeAllCallbacks();
                                            this.onScrollStateChange(1);
                                        }
                                    } else {
                                        this.scrollBy(0, (int)(f - this.mLastDownOrMoveEventY));
                                        this.invalidate();
                                    }
                                    this.mLastDownOrMoveEventY = f;
                                }
                                default: {
                                    return true;
                                }
                                case 1: 
                            }
                            this.removeBeginSoftInputCommand();
                            this.removeChangeCurrentByOneFromLongPress();
                            this.mPressedStateHelper.cancel();
                            VelocityTracker velocityTracker = this.mVelocityTracker;
                            velocityTracker.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                            int n2 = (int)velocityTracker.getYVelocity();
                            if (Math.abs(n2) <= this.mMinimumFlingVelocity) break block12;
                            this.fling(n2);
                            this.onScrollStateChange(2);
                            break block13;
                        }
                        n = (int)motionEvent.getY();
                        int n3 = (int)Math.abs((float)n - this.mLastDownEventY);
                        long l = motionEvent.getEventTime() - this.mLastDownEventTime;
                        if (n3 > this.mTouchSlop || l >= (long)ViewConfiguration.getTapTimeout()) break block14;
                        if (!this.mPerformClickOnTap) break block15;
                        this.mPerformClickOnTap = false;
                        this.performClick();
                        break block16;
                    }
                    int n4 = -1 + n / this.mSelectorElementHeight;
                    if (n4 > 0) {
                        this.changeValueByOne(true);
                        this.mPressedStateHelper.buttonTapped(1);
                        break block16;
                    } else if (n4 < 0) {
                        this.changeValueByOne(false);
                        this.mPressedStateHelper.buttonTapped(2);
                    }
                    break block16;
                }
                this.ensureScrollWheelAdjusted();
            }
            this.onScrollStateChange(0);
        }
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
        return true;
    }

    @Override
    public boolean performClick() {
        if (!this.mHasSelectorWheel) {
            return super.performClick();
        }
        if (!super.performClick()) {
            this.showSoftInput();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean performLongClick() {
        boolean bl = true;
        if (!this.mHasSelectorWheel) {
            return super.performLongClick();
        }
        if (super.performLongClick()) return bl;
        this.showSoftInput();
        this.mIgnoreMoveEvents = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void scrollBy(int n, int n2) {
        int[] nArray = this.mSelectorIndices;
        if (!this.mWrapSelectorWheel && n2 > 0 && nArray[1] <= this.mMinValue) {
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
            return;
        } else {
            if (!this.mWrapSelectorWheel && n2 < 0 && nArray[1] >= this.mMaxValue) {
                this.mCurrentScrollOffset = this.mInitialScrollOffset;
                return;
            }
            this.mCurrentScrollOffset = n2 + this.mCurrentScrollOffset;
            while (this.mCurrentScrollOffset - this.mInitialScrollOffset > this.mSelectorTextGapHeight) {
                this.mCurrentScrollOffset -= this.mSelectorElementHeight;
                this.decrementSelectorIndices(nArray);
                this.setValueInternal(nArray[1], true);
                if (this.mWrapSelectorWheel || nArray[1] > this.mMinValue) continue;
                this.mCurrentScrollOffset = this.mInitialScrollOffset;
            }
            while (this.mCurrentScrollOffset - this.mInitialScrollOffset < -this.mSelectorTextGapHeight) {
                this.mCurrentScrollOffset += this.mSelectorElementHeight;
                this.incrementSelectorIndices(nArray);
                this.setValueInternal(nArray[1], true);
                if (this.mWrapSelectorWheel || nArray[1] < this.mMaxValue) continue;
                this.mCurrentScrollOffset = this.mInitialScrollOffset;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDisplayedValues(String[] stringArray) {
        if (this.mDisplayedValues == stringArray) {
            return;
        }
        this.mDisplayedValues = stringArray;
        if (this.mDisplayedValues != null) {
            this.mInputText.setRawInputType(524289);
        } else {
            this.mInputText.setRawInputType(2);
        }
        this.updateInputTextView();
        this.initializeSelectorWheelIndices();
        this.tryComputeMaxWidth();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!this.mHasSelectorWheel) {
            this.mIncrementButton.setEnabled(bl);
        }
        if (!this.mHasSelectorWheel) {
            this.mDecrementButton.setEnabled(bl);
        }
        this.mInputText.setEnabled(bl);
    }

    public void setFormatter(Formatter formatter) {
        if (formatter == this.mFormatter) {
            return;
        }
        this.mFormatter = formatter;
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMaxValue(int n) {
        if (this.mMaxValue == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("maxValue must be >= 0");
        }
        this.mMaxValue = n;
        if (this.mMaxValue < this.mValue) {
            this.mValue = this.mMaxValue;
        }
        boolean bl = this.mMaxValue - this.mMinValue > this.mSelectorIndices.length;
        this.setWrapSelectorWheel(bl);
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.tryComputeMaxWidth();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMinValue(int n) {
        if (this.mMinValue == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("minValue must be >= 0");
        }
        this.mMinValue = n;
        if (this.mMinValue > this.mValue) {
            this.mValue = this.mMinValue;
        }
        boolean bl = this.mMaxValue - this.mMinValue > this.mSelectorIndices.length;
        this.setWrapSelectorWheel(bl);
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.tryComputeMaxWidth();
        this.invalidate();
    }

    public void setOnLongPressUpdateInterval(long l) {
        this.mLongPressUpdateInterval = l;
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    public void setOnValueChangedListener(OnValueChangeListener onValueChangeListener) {
        this.mOnValueChangeListener = onValueChangeListener;
    }

    public void setValue(int n) {
        this.setValueInternal(n, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setWrapSelectorWheel(boolean bl) {
        boolean bl2 = this.mMaxValue - this.mMinValue >= this.mSelectorIndices.length;
        if ((!bl || bl2) && bl != this.mWrapSelectorWheel) {
            this.mWrapSelectorWheel = bl;
        }
    }

    class AccessibilityNodeProviderImpl
    extends AccessibilityNodeProvider {
        private static final int UNDEFINED = Integer.MIN_VALUE;
        private static final int VIRTUAL_VIEW_ID_DECREMENT = 3;
        private static final int VIRTUAL_VIEW_ID_INCREMENT = 1;
        private static final int VIRTUAL_VIEW_ID_INPUT = 2;
        private int mAccessibilityFocusedView;
        private final int[] mTempArray;
        private final Rect mTempRect = new Rect();

        AccessibilityNodeProviderImpl() {
            this.mTempArray = new int[2];
            this.mAccessibilityFocusedView = Integer.MIN_VALUE;
        }

        private AccessibilityNodeInfo createAccessibilityNodeInfoForNumberPicker(int n, int n2, int n3, int n4) {
            AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain();
            accessibilityNodeInfo.setClassName(NumberPicker.class.getName());
            accessibilityNodeInfo.setPackageName(NumberPicker.this.mContext.getPackageName());
            accessibilityNodeInfo.setSource(NumberPicker.this);
            if (this.hasVirtualDecrementButton()) {
                accessibilityNodeInfo.addChild(NumberPicker.this, 3);
            }
            accessibilityNodeInfo.addChild(NumberPicker.this, 2);
            if (this.hasVirtualIncrementButton()) {
                accessibilityNodeInfo.addChild(NumberPicker.this, 1);
            }
            accessibilityNodeInfo.setParent((View)((Object)NumberPicker.this.getParentForAccessibility()));
            accessibilityNodeInfo.setEnabled(NumberPicker.this.isEnabled());
            accessibilityNodeInfo.setScrollable(true);
            float f = NumberPicker.this.getContext().getResources().getCompatibilityInfo().applicationScale;
            Rect rect = this.mTempRect;
            rect.set(n, n2, n3, n4);
            rect.scale(f);
            accessibilityNodeInfo.setBoundsInParent(rect);
            accessibilityNodeInfo.setVisibleToUser(NumberPicker.this.isVisibleToUser());
            int[] nArray = this.mTempArray;
            NumberPicker.this.getLocationOnScreen(nArray);
            rect.offset(nArray[0], nArray[1]);
            rect.scale(f);
            accessibilityNodeInfo.setBoundsInScreen(rect);
            if (this.mAccessibilityFocusedView != -1) {
                accessibilityNodeInfo.addAction(64);
            }
            if (this.mAccessibilityFocusedView == -1) {
                accessibilityNodeInfo.addAction(128);
            }
            if (NumberPicker.this.isEnabled()) {
                if (NumberPicker.this.getWrapSelectorWheel() || NumberPicker.this.getValue() < NumberPicker.this.getMaxValue()) {
                    accessibilityNodeInfo.addAction(4096);
                }
                if (NumberPicker.this.getWrapSelectorWheel() || NumberPicker.this.getValue() > NumberPicker.this.getMinValue()) {
                    accessibilityNodeInfo.addAction(8192);
                }
            }
            return accessibilityNodeInfo;
        }

        private AccessibilityNodeInfo createAccessibilityNodeInfoForVirtualButton(int n, String string2, int n2, int n3, int n4, int n5) {
            AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain();
            accessibilityNodeInfo.setClassName(Button.class.getName());
            accessibilityNodeInfo.setPackageName(NumberPicker.this.mContext.getPackageName());
            accessibilityNodeInfo.setSource(NumberPicker.this, n);
            accessibilityNodeInfo.setParent(NumberPicker.this);
            accessibilityNodeInfo.setText(string2);
            accessibilityNodeInfo.setClickable(true);
            accessibilityNodeInfo.setLongClickable(true);
            accessibilityNodeInfo.setEnabled(NumberPicker.this.isEnabled());
            Rect rect = this.mTempRect;
            rect.set(n2, n3, n4, n5);
            accessibilityNodeInfo.setVisibleToUser(NumberPicker.this.isVisibleToUser(rect));
            accessibilityNodeInfo.setBoundsInParent(rect);
            int[] nArray = this.mTempArray;
            NumberPicker.this.getLocationOnScreen(nArray);
            rect.offset(nArray[0], nArray[1]);
            accessibilityNodeInfo.setBoundsInScreen(rect);
            if (this.mAccessibilityFocusedView != n) {
                accessibilityNodeInfo.addAction(64);
            }
            if (this.mAccessibilityFocusedView == n) {
                accessibilityNodeInfo.addAction(128);
            }
            if (NumberPicker.this.isEnabled()) {
                accessibilityNodeInfo.addAction(16);
            }
            return accessibilityNodeInfo;
        }

        private AccessibilityNodeInfo createAccessibiltyNodeInfoForInputText(int n, int n2, int n3, int n4) {
            AccessibilityNodeInfo accessibilityNodeInfo = NumberPicker.this.mInputText.createAccessibilityNodeInfo();
            accessibilityNodeInfo.setSource(NumberPicker.this, 2);
            if (this.mAccessibilityFocusedView != 2) {
                accessibilityNodeInfo.addAction(64);
            }
            if (this.mAccessibilityFocusedView == 2) {
                accessibilityNodeInfo.addAction(128);
            }
            Rect rect = this.mTempRect;
            rect.set(n, n2, n3, n4);
            accessibilityNodeInfo.setVisibleToUser(NumberPicker.this.isVisibleToUser(rect));
            accessibilityNodeInfo.setBoundsInParent(rect);
            int[] nArray = this.mTempArray;
            NumberPicker.this.getLocationOnScreen(nArray);
            rect.offset(nArray[0], nArray[1]);
            accessibilityNodeInfo.setBoundsInScreen(rect);
            return accessibilityNodeInfo;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void findAccessibilityNodeInfosByTextInChild(String string2, int n, List<AccessibilityNodeInfo> list) {
            switch (n) {
                case 3: {
                    String string3 = this.getVirtualDecrementButtonText();
                    if (TextUtils.isEmpty(string3) || !string3.toString().toLowerCase().contains(string2)) return;
                    list.add(this.createAccessibilityNodeInfo(3));
                    return;
                }
                case 2: {
                    Editable editable = NumberPicker.this.mInputText.getText();
                    if (!TextUtils.isEmpty(editable) && editable.toString().toLowerCase().contains(string2)) {
                        list.add(this.createAccessibilityNodeInfo(2));
                        return;
                    }
                    Editable editable2 = NumberPicker.this.mInputText.getText();
                    if (TextUtils.isEmpty(editable2) || !editable2.toString().toLowerCase().contains(string2)) return;
                    list.add(this.createAccessibilityNodeInfo(2));
                    return;
                }
                default: {
                    return;
                }
                case 1: 
            }
            String string4 = this.getVirtualIncrementButtonText();
            if (TextUtils.isEmpty(string4) || !string4.toString().toLowerCase().contains(string2)) return;
            list.add(this.createAccessibilityNodeInfo(1));
        }

        private String getVirtualDecrementButtonText() {
            int n = -1 + NumberPicker.this.mValue;
            if (NumberPicker.this.mWrapSelectorWheel) {
                n = NumberPicker.this.getWrappedSelectorIndex(n);
            }
            if (n >= NumberPicker.this.mMinValue) {
                if (NumberPicker.this.mDisplayedValues == null) {
                    return NumberPicker.this.formatNumber(n);
                }
                return NumberPicker.this.mDisplayedValues[n - NumberPicker.this.mMinValue];
            }
            return null;
        }

        private String getVirtualIncrementButtonText() {
            int n = 1 + NumberPicker.this.mValue;
            if (NumberPicker.this.mWrapSelectorWheel) {
                n = NumberPicker.this.getWrappedSelectorIndex(n);
            }
            if (n <= NumberPicker.this.mMaxValue) {
                if (NumberPicker.this.mDisplayedValues == null) {
                    return NumberPicker.this.formatNumber(n);
                }
                return NumberPicker.this.mDisplayedValues[n - NumberPicker.this.mMinValue];
            }
            return null;
        }

        private boolean hasVirtualDecrementButton() {
            return NumberPicker.this.getWrapSelectorWheel() || NumberPicker.this.getValue() > NumberPicker.this.getMinValue();
        }

        private boolean hasVirtualIncrementButton() {
            return NumberPicker.this.getWrapSelectorWheel() || NumberPicker.this.getValue() < NumberPicker.this.getMaxValue();
        }

        private void sendAccessibilityEventForVirtualButton(int n, int n2, String string2) {
            if (AccessibilityManager.getInstance(NumberPicker.this.mContext).isEnabled()) {
                AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain(n2);
                accessibilityEvent.setClassName(Button.class.getName());
                accessibilityEvent.setPackageName(NumberPicker.this.mContext.getPackageName());
                accessibilityEvent.getText().add(string2);
                accessibilityEvent.setEnabled(NumberPicker.this.isEnabled());
                accessibilityEvent.setSource(NumberPicker.this, n);
                NumberPicker.this.requestSendAccessibilityEvent(NumberPicker.this, accessibilityEvent);
            }
        }

        private void sendAccessibilityEventForVirtualText(int n) {
            if (AccessibilityManager.getInstance(NumberPicker.this.mContext).isEnabled()) {
                AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain(n);
                NumberPicker.this.mInputText.onInitializeAccessibilityEvent(accessibilityEvent);
                NumberPicker.this.mInputText.onPopulateAccessibilityEvent(accessibilityEvent);
                accessibilityEvent.setSource(NumberPicker.this, 2);
                NumberPicker.this.requestSendAccessibilityEvent(NumberPicker.this, accessibilityEvent);
            }
        }

        @Override
        public AccessibilityNodeInfo createAccessibilityNodeInfo(int n) {
            switch (n) {
                default: {
                    return super.createAccessibilityNodeInfo(n);
                }
                case -1: {
                    return this.createAccessibilityNodeInfoForNumberPicker(NumberPicker.this.mScrollX, NumberPicker.this.mScrollY, NumberPicker.this.mScrollX + (NumberPicker.this.mRight - NumberPicker.this.mLeft), NumberPicker.this.mScrollY + (NumberPicker.this.mBottom - NumberPicker.this.mTop));
                }
                case 3: {
                    return this.createAccessibilityNodeInfoForVirtualButton(3, this.getVirtualDecrementButtonText(), NumberPicker.this.mScrollX, NumberPicker.this.mScrollY, NumberPicker.this.mScrollX + (NumberPicker.this.mRight - NumberPicker.this.mLeft), NumberPicker.this.mTopSelectionDividerTop + NumberPicker.this.mSelectionDividerHeight);
                }
                case 2: {
                    return this.createAccessibiltyNodeInfoForInputText(NumberPicker.this.mScrollX, NumberPicker.this.mTopSelectionDividerTop + NumberPicker.this.mSelectionDividerHeight, NumberPicker.this.mScrollX + (NumberPicker.this.mRight - NumberPicker.this.mLeft), NumberPicker.this.mBottomSelectionDividerBottom - NumberPicker.this.mSelectionDividerHeight);
                }
                case 1: 
            }
            return this.createAccessibilityNodeInfoForVirtualButton(1, this.getVirtualIncrementButtonText(), NumberPicker.this.mScrollX, NumberPicker.this.mBottomSelectionDividerBottom - NumberPicker.this.mSelectionDividerHeight, NumberPicker.this.mScrollX + (NumberPicker.this.mRight - NumberPicker.this.mLeft), NumberPicker.this.mScrollY + (NumberPicker.this.mBottom - NumberPicker.this.mTop));
        }

        @Override
        public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String string2, int n) {
            if (TextUtils.isEmpty(string2)) {
                return Collections.emptyList();
            }
            String string3 = string2.toLowerCase();
            ArrayList<AccessibilityNodeInfo> arrayList = new ArrayList<AccessibilityNodeInfo>();
            switch (n) {
                default: {
                    return super.findAccessibilityNodeInfosByText(string2, n);
                }
                case -1: {
                    this.findAccessibilityNodeInfosByTextInChild(string3, 3, arrayList);
                    this.findAccessibilityNodeInfosByTextInChild(string3, 2, arrayList);
                    this.findAccessibilityNodeInfosByTextInChild(string3, 1, arrayList);
                    return arrayList;
                }
                case 1: 
                case 2: 
                case 3: 
            }
            this.findAccessibilityNodeInfosByTextInChild(string3, n, arrayList);
            return arrayList;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean performAction(int var1_1, int var2_2, Bundle var3_3) {
            switch (var1_1) lbl-1000:
            // 2 sources

            {
                default: {
                    var5_4 = super.performAction(var1_1, var2_2, var3_3);
lbl4:
                    // 21 sources

                    return var5_4;
                }
                case -1: {
                    switch (var2_2) {
                        default: {
                            ** GOTO lbl-1000
                        }
                        case 64: {
                            var29_5 = this.mAccessibilityFocusedView;
                            var5_4 = false;
                            if (var29_5 == var1_1) ** GOTO lbl4
                            this.mAccessibilityFocusedView = var1_1;
                            NumberPicker.this.requestAccessibilityFocus();
                            return true;
                        }
                        case 128: {
                            var28_6 = this.mAccessibilityFocusedView;
                            var5_4 = false;
                            if (var28_6 != var1_1) ** GOTO lbl4
                            this.mAccessibilityFocusedView = -2147483648;
                            NumberPicker.this.clearAccessibilityFocus();
                            return true;
                        }
                        case 4096: {
                            var25_7 = NumberPicker.this.isEnabled();
                            var5_4 = false;
                            if (!var25_7) ** GOTO lbl4
                            if (NumberPicker.this.getWrapSelectorWheel()) ** GOTO lbl34
                            var26_8 = NumberPicker.this.getValue();
                            var27_9 = NumberPicker.this.getMaxValue();
                            var5_4 = false;
                            if (var26_8 >= var27_9) ** GOTO lbl4
lbl34:
                            // 2 sources

                            NumberPicker.access$200(NumberPicker.this, true);
                            return true;
                        }
                        case 8192: 
                    }
                    var22_10 = NumberPicker.this.isEnabled();
                    var5_4 = false;
                    if (!var22_10) ** GOTO lbl4
                    if (NumberPicker.this.getWrapSelectorWheel()) ** GOTO lbl45
                    var23_11 = NumberPicker.this.getValue();
                    var24_12 = NumberPicker.this.getMinValue();
                    var5_4 = false;
                    if (var23_11 <= var24_12) ** GOTO lbl4
lbl45:
                    // 2 sources

                    NumberPicker.access$200(NumberPicker.this, false);
                    return true;
                }
                case 2: {
                    switch (var2_2) {
                        default: {
                            return NumberPicker.access$100(NumberPicker.this).performAccessibilityAction(var2_2, var3_3);
                        }
                        case 1: {
                            var20_13 = NumberPicker.this.isEnabled();
                            var5_4 = false;
                            if (!var20_13) ** GOTO lbl4
                            var21_14 = NumberPicker.access$100(NumberPicker.this).isFocused();
                            var5_4 = false;
                            if (var21_14) ** GOTO lbl4
                            return NumberPicker.access$100(NumberPicker.this).requestFocus();
                        }
                        case 2: {
                            var18_15 = NumberPicker.this.isEnabled();
                            var5_4 = false;
                            if (!var18_15) ** GOTO lbl4
                            var19_16 = NumberPicker.access$100(NumberPicker.this).isFocused();
                            var5_4 = false;
                            if (!var19_16) ** GOTO lbl4
                            NumberPicker.access$100(NumberPicker.this).clearFocus();
                            return true;
                        }
                        case 16: {
                            var16_17 = NumberPicker.this.isEnabled();
                            var5_4 = false;
                            if (!var16_17) ** GOTO lbl4
                            NumberPicker.this.performClick();
                            return true;
                        }
                        case 32: {
                            var14_18 = NumberPicker.this.isEnabled();
                            var5_4 = false;
                            if (!var14_18) ** GOTO lbl4
                            NumberPicker.this.performLongClick();
                            return true;
                        }
                        case 64: {
                            var13_19 = this.mAccessibilityFocusedView;
                            var5_4 = false;
                            if (var13_19 == var1_1) ** GOTO lbl4
                            this.mAccessibilityFocusedView = var1_1;
                            this.sendAccessibilityEventForVirtualView(var1_1, 32768);
                            NumberPicker.access$100(NumberPicker.this).invalidate();
                            return true;
                        }
                        case 128: 
                    }
                    var12_20 = this.mAccessibilityFocusedView;
                    var5_4 = false;
                    if (var12_20 != var1_1) ** GOTO lbl4
                    this.mAccessibilityFocusedView = -2147483648;
                    this.sendAccessibilityEventForVirtualView(var1_1, 65536);
                    NumberPicker.access$100(NumberPicker.this).invalidate();
                    return true;
                }
                case 1: {
                    switch (var2_2) {
                        default: {
                            return false;
                        }
                        case 16: {
                            var11_21 = NumberPicker.this.isEnabled();
                            var5_4 = false;
                            if (!var11_21) ** GOTO lbl4
                            NumberPicker.access$200(NumberPicker.this, true);
                            this.sendAccessibilityEventForVirtualView(var1_1, 1);
                            return true;
                        }
                        case 64: {
                            var10_22 = this.mAccessibilityFocusedView;
                            var5_4 = false;
                            if (var10_22 == var1_1) ** GOTO lbl4
                            this.mAccessibilityFocusedView = var1_1;
                            this.sendAccessibilityEventForVirtualView(var1_1, 32768);
                            NumberPicker.this.invalidate(0, NumberPicker.access$1400(NumberPicker.this), NumberPicker.access$5200(NumberPicker.this), NumberPicker.access$5300(NumberPicker.this));
                            return true;
                        }
                        case 128: 
                    }
                    var9_23 = this.mAccessibilityFocusedView;
                    var5_4 = false;
                    if (var9_23 != var1_1) ** GOTO lbl4
                    this.mAccessibilityFocusedView = -2147483648;
                    this.sendAccessibilityEventForVirtualView(var1_1, 65536);
                    NumberPicker.this.invalidate(0, NumberPicker.access$1400(NumberPicker.this), NumberPicker.access$5400(NumberPicker.this), NumberPicker.access$5500(NumberPicker.this));
                    return true;
                }
                case 3: 
            }
            switch (var2_2) {
                default: {
                    return false;
                }
                case 16: {
                    var7_24 = NumberPicker.this.isEnabled();
                    var5_4 = false;
                    if (!var7_24) ** GOTO lbl4
                    var8_25 = false;
                    if (var1_1 == 1) {
                        var8_25 = true;
                    }
                    NumberPicker.access$200(NumberPicker.this, var8_25);
                    this.sendAccessibilityEventForVirtualView(var1_1, 1);
                    return true;
                }
                case 64: {
                    var6_26 = this.mAccessibilityFocusedView;
                    var5_4 = false;
                    if (var6_26 == var1_1) ** GOTO lbl4
                    this.mAccessibilityFocusedView = var1_1;
                    this.sendAccessibilityEventForVirtualView(var1_1, 32768);
                    NumberPicker.this.invalidate(0, 0, NumberPicker.access$5600(NumberPicker.this), NumberPicker.access$1900(NumberPicker.this));
                    return true;
                }
                case 128: 
            }
            var4_27 = this.mAccessibilityFocusedView;
            var5_4 = false;
            if (var4_27 == var1_1) ** break;
            ** while (true)
            this.mAccessibilityFocusedView = -2147483648;
            this.sendAccessibilityEventForVirtualView(var1_1, 65536);
            NumberPicker.this.invalidate(0, 0, NumberPicker.access$5700(NumberPicker.this), NumberPicker.access$1900(NumberPicker.this));
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void sendAccessibilityEventForVirtualView(int n, int n2) {
            switch (n) {
                case 3: {
                    if (!this.hasVirtualDecrementButton()) return;
                    this.sendAccessibilityEventForVirtualButton(n, n2, this.getVirtualDecrementButtonText());
                    return;
                }
                default: {
                    return;
                }
                case 2: {
                    this.sendAccessibilityEventForVirtualText(n2);
                    return;
                }
                case 1: {
                    if (!this.hasVirtualIncrementButton()) return;
                    this.sendAccessibilityEventForVirtualButton(n, n2, this.getVirtualIncrementButtonText());
                    return;
                }
            }
        }
    }

    class BeginSoftInputOnLongPressCommand
    implements Runnable {
        BeginSoftInputOnLongPressCommand() {
        }

        @Override
        public void run() {
            NumberPicker.this.performLongClick();
        }
    }

    class ChangeCurrentByOneFromLongPressCommand
    implements Runnable {
        private boolean mIncrement;

        ChangeCurrentByOneFromLongPressCommand() {
        }

        private void setStep(boolean bl) {
            this.mIncrement = bl;
        }

        @Override
        public void run() {
            NumberPicker.this.changeValueByOne(this.mIncrement);
            NumberPicker.this.postDelayed(this, NumberPicker.this.mLongPressUpdateInterval);
        }
    }

    public static class CustomEditText
    extends EditText {
        public CustomEditText(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        @Override
        public void onEditorAction(int n) {
            super.onEditorAction(n);
            if (n == 6) {
                this.clearFocus();
            }
        }
    }

    public static interface Formatter {
        public String format(int var1);
    }

    class InputTextFilter
    extends NumberKeyListener {
        InputTextFilter() {
        }

        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            if (NumberPicker.this.mDisplayedValues == null) {
                String string2;
                CharSequence charSequence2 = super.filter(charSequence, n, n2, spanned, n3, n4);
                if (charSequence2 == null) {
                    charSequence2 = charSequence.subSequence(n, n2);
                }
                if ("".equals(string2 = String.valueOf(spanned.subSequence(0, n3)) + charSequence2 + spanned.subSequence(n4, spanned.length()))) {
                    return string2;
                }
                if (NumberPicker.this.getSelectedPos(string2) > NumberPicker.this.mMaxValue || string2.length() > String.valueOf(NumberPicker.this.mMaxValue).length()) {
                    return "";
                }
                return charSequence2;
            }
            String string3 = String.valueOf(charSequence.subSequence(n, n2));
            if (TextUtils.isEmpty(string3)) {
                return "";
            }
            String string4 = String.valueOf(spanned.subSequence(0, n3)) + string3 + spanned.subSequence(n4, spanned.length());
            String string5 = String.valueOf(string4).toLowerCase();
            for (String string6 : NumberPicker.this.mDisplayedValues) {
                if (!string6.toLowerCase().startsWith(string5)) continue;
                NumberPicker.this.postSetSelectionCommand(string4.length(), string6.length());
                return string6.subSequence(n3, string6.length());
            }
            return "";
        }

        @Override
        protected char[] getAcceptedChars() {
            return DIGIT_CHARACTERS;
        }

        @Override
        public int getInputType() {
            return 1;
        }
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_FLING = 2;
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;

        public void onScrollStateChange(NumberPicker var1, int var2);
    }

    public static interface OnValueChangeListener {
        public void onValueChange(NumberPicker var1, int var2, int var3);
    }

    class PressedStateHelper
    implements Runnable {
        public static final int BUTTON_DECREMENT = 2;
        public static final int BUTTON_INCREMENT = 1;
        private final int MODE_PRESS;
        private final int MODE_TAPPED;
        private int mManagedButton;
        private int mMode;

        PressedStateHelper() {
            this.MODE_PRESS = 1;
            this.MODE_TAPPED = 2;
        }

        public void buttonPressDelayed(int n) {
            this.cancel();
            this.mMode = 1;
            this.mManagedButton = n;
            NumberPicker.this.postDelayed(this, ViewConfiguration.getTapTimeout());
        }

        public void buttonTapped(int n) {
            this.cancel();
            this.mMode = 2;
            this.mManagedButton = n;
            NumberPicker.this.post(this);
        }

        public void cancel() {
            this.mMode = 0;
            this.mManagedButton = 0;
            NumberPicker.this.removeCallbacks(this);
            if (NumberPicker.this.mIncrementVirtualButtonPressed) {
                NumberPicker.access$1302(NumberPicker.this, false);
                NumberPicker.this.invalidate(0, NumberPicker.this.mBottomSelectionDividerBottom, NumberPicker.this.mRight, NumberPicker.this.mBottom);
            }
            NumberPicker.access$1702(NumberPicker.this, false);
            if (NumberPicker.this.mDecrementVirtualButtonPressed) {
                NumberPicker.this.invalidate(0, 0, NumberPicker.this.mRight, NumberPicker.this.mTopSelectionDividerTop);
            }
        }

        @Override
        public void run() {
            switch (this.mMode) {
                default: {
                    return;
                }
                case 1: {
                    switch (this.mManagedButton) {
                        default: {
                            return;
                        }
                        case 1: {
                            NumberPicker.access$1302(NumberPicker.this, true);
                            NumberPicker.this.invalidate(0, NumberPicker.this.mBottomSelectionDividerBottom, NumberPicker.this.mRight, NumberPicker.this.mBottom);
                            return;
                        }
                        case 2: 
                    }
                    NumberPicker.access$1702(NumberPicker.this, true);
                    NumberPicker.this.invalidate(0, 0, NumberPicker.this.mRight, NumberPicker.this.mTopSelectionDividerTop);
                    return;
                }
                case 2: 
            }
            switch (this.mManagedButton) {
                default: {
                    return;
                }
                case 1: {
                    if (!NumberPicker.this.mIncrementVirtualButtonPressed) {
                        NumberPicker.this.postDelayed(this, ViewConfiguration.getPressedStateDuration());
                    }
                    NumberPicker.access$1380(NumberPicker.this, 1);
                    NumberPicker.this.invalidate(0, NumberPicker.this.mBottomSelectionDividerBottom, NumberPicker.this.mRight, NumberPicker.this.mBottom);
                    return;
                }
                case 2: 
            }
            if (!NumberPicker.this.mDecrementVirtualButtonPressed) {
                NumberPicker.this.postDelayed(this, ViewConfiguration.getPressedStateDuration());
            }
            NumberPicker.access$1780(NumberPicker.this, 1);
            NumberPicker.this.invalidate(0, 0, NumberPicker.this.mRight, NumberPicker.this.mTopSelectionDividerTop);
        }
    }

    class SetSelectionCommand
    implements Runnable {
        private int mSelectionEnd;
        private int mSelectionStart;

        SetSelectionCommand() {
        }

        static /* synthetic */ int access$602(SetSelectionCommand setSelectionCommand, int n) {
            setSelectionCommand.mSelectionStart = n;
            return n;
        }

        static /* synthetic */ int access$702(SetSelectionCommand setSelectionCommand, int n) {
            setSelectionCommand.mSelectionEnd = n;
            return n;
        }

        @Override
        public void run() {
            NumberPicker.this.mInputText.setSelection(this.mSelectionStart, this.mSelectionEnd);
        }
    }

    private static class TwoDigitFormatter
    implements Formatter {
        final Object[] mArgs;
        final StringBuilder mBuilder = new StringBuilder();
        java.util.Formatter mFmt;
        char mZeroDigit;

        TwoDigitFormatter() {
            this.mArgs = new Object[1];
            this.init(Locale.getDefault());
        }

        private java.util.Formatter createFormatter(Locale locale) {
            return new java.util.Formatter(this.mBuilder, locale);
        }

        private static char getZeroDigit(Locale locale) {
            return LocaleData.get((Locale)locale).zeroDigit;
        }

        private void init(Locale locale) {
            this.mFmt = this.createFormatter(locale);
            this.mZeroDigit = TwoDigitFormatter.getZeroDigit(locale);
        }

        @Override
        public String format(int n) {
            Locale locale = Locale.getDefault();
            if (this.mZeroDigit != TwoDigitFormatter.getZeroDigit(locale)) {
                this.init(locale);
            }
            this.mArgs[0] = n;
            this.mBuilder.delete(0, this.mBuilder.length());
            this.mFmt.format("%02d", this.mArgs);
            return this.mFmt.toString();
        }
    }
}

