/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.io.IOException;

@RemoteViews.RemoteView
public class ImageView
extends View {
    private static final Matrix.ScaleToFit[] sS2FArray;
    private static final ScaleType[] sScaleTypeArray;
    private boolean mAdjustViewBounds = false;
    private boolean mAdjustViewBoundsCompat = false;
    private int mAlpha = 255;
    private int mBaseline = -1;
    private boolean mBaselineAlignBottom = false;
    private ColorFilter mColorFilter = null;
    private boolean mColorMod = false;
    private boolean mCropToPadding;
    private Matrix mDrawMatrix = null;
    private Drawable mDrawable = null;
    private int mDrawableHeight;
    private ColorStateList mDrawableTintList = null;
    private PorterDuff.Mode mDrawableTintMode = null;
    private int mDrawableWidth;
    private boolean mHasColorFilter = false;
    private boolean mHasDrawableTint = false;
    private boolean mHasDrawableTintMode = false;
    private boolean mHaveFrame = false;
    private int mLevel = 0;
    private Matrix mMatrix;
    private int mMaxHeight;
    private int mMaxWidth = Integer.MAX_VALUE;
    private boolean mMergeState = false;
    private int mResource = 0;
    private ScaleType mScaleType;
    private int[] mState = null;
    private RectF mTempDst;
    private RectF mTempSrc;
    private Uri mUri;
    private int mViewAlphaScale = 256;
    private Xfermode mXfermode;

    static {
        ScaleType[] scaleTypeArray = new ScaleType[]{ScaleType.MATRIX, ScaleType.FIT_XY, ScaleType.FIT_START, ScaleType.FIT_CENTER, ScaleType.FIT_END, ScaleType.CENTER, ScaleType.CENTER_CROP, ScaleType.CENTER_INSIDE};
        sScaleTypeArray = scaleTypeArray;
        Matrix.ScaleToFit[] scaleToFitArray = new Matrix.ScaleToFit[]{Matrix.ScaleToFit.FILL, Matrix.ScaleToFit.START, Matrix.ScaleToFit.CENTER, Matrix.ScaleToFit.END};
        sS2FArray = scaleToFitArray;
    }

    public ImageView(Context context) {
        super(context);
        this.mMaxHeight = Integer.MAX_VALUE;
        this.mTempSrc = new RectF();
        this.mTempDst = new RectF();
        this.initImageView();
    }

    public ImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ImageView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ImageView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mMaxHeight = Integer.MAX_VALUE;
        this.mTempSrc = new RectF();
        this.mTempDst = new RectF();
        this.initImageView();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ImageView, n, n2);
        Drawable drawable2 = typedArray.getDrawable(0);
        if (drawable2 != null) {
            this.setImageDrawable(drawable2);
        }
        this.mBaselineAlignBottom = typedArray.getBoolean(6, false);
        this.mBaseline = typedArray.getDimensionPixelSize(8, -1);
        this.setAdjustViewBounds(typedArray.getBoolean(2, false));
        this.setMaxWidth(typedArray.getDimensionPixelSize(3, Integer.MAX_VALUE));
        this.setMaxHeight(typedArray.getDimensionPixelSize(4, Integer.MAX_VALUE));
        int n3 = typedArray.getInt(1, -1);
        if (n3 >= 0) {
            this.setScaleType(sScaleTypeArray[n3]);
        }
        if (typedArray.hasValue(5)) {
            this.mDrawableTintList = typedArray.getColorStateList(5);
            this.mHasDrawableTint = true;
            this.mDrawableTintMode = PorterDuff.Mode.SRC_ATOP;
            this.mHasDrawableTintMode = true;
        }
        if (typedArray.hasValue(9)) {
            this.mDrawableTintMode = Drawable.parseTintMode(typedArray.getInt(9, -1), this.mDrawableTintMode);
            this.mHasDrawableTintMode = true;
        }
        this.applyImageTint();
        int n4 = typedArray.getInt(10, 255);
        if (n4 != 255) {
            this.setAlpha(n4);
        }
        this.mCropToPadding = typedArray.getBoolean(7, false);
        typedArray.recycle();
    }

    private void applyColorMod() {
        if (this.mDrawable != null && this.mColorMod) {
            this.mDrawable = this.mDrawable.mutate();
            if (this.mHasColorFilter) {
                this.mDrawable.setColorFilter(this.mColorFilter);
            }
            this.mDrawable.setXfermode(this.mXfermode);
            this.mDrawable.setAlpha(this.mAlpha * this.mViewAlphaScale >> 8);
        }
    }

    private void applyImageTint() {
        if (this.mDrawable != null && (this.mHasDrawableTint || this.mHasDrawableTintMode)) {
            this.mDrawable = this.mDrawable.mutate();
            if (this.mHasDrawableTint) {
                this.mDrawable.setTintList(this.mDrawableTintList);
            }
            if (this.mHasDrawableTintMode) {
                this.mDrawable.setTintMode(this.mDrawableTintMode);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void configureBounds() {
        if (this.mDrawable == null || !this.mHaveFrame) {
            return;
        }
        int n = this.mDrawableWidth;
        int n2 = this.mDrawableHeight;
        int n3 = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
        int n4 = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
        boolean bl = !(n >= 0 && n3 != n || n2 >= 0 && n4 != n2);
        if (n <= 0 || n2 <= 0 || ScaleType.FIT_XY == this.mScaleType) {
            this.mDrawable.setBounds(0, 0, n3, n4);
            this.mDrawMatrix = null;
            return;
        }
        this.mDrawable.setBounds(0, 0, n, n2);
        if (ScaleType.MATRIX == this.mScaleType) {
            if (this.mMatrix.isIdentity()) {
                this.mDrawMatrix = null;
                return;
            }
            this.mDrawMatrix = this.mMatrix;
            return;
        }
        if (bl) {
            this.mDrawMatrix = null;
            return;
        }
        if (ScaleType.CENTER == this.mScaleType) {
            this.mDrawMatrix = this.mMatrix;
            this.mDrawMatrix.setTranslate((int)(0.5f + 0.5f * (float)(n3 - n)), (int)(0.5f + 0.5f * (float)(n4 - n2)));
            return;
        }
        if (ScaleType.CENTER_CROP == this.mScaleType) {
            float f;
            float f2;
            this.mDrawMatrix = this.mMatrix;
            float f3 = 0.0f;
            if (n * n4 > n3 * n2) {
                f2 = (float)n4 / (float)n2;
                f = 0.5f * ((float)n3 - f2 * (float)n);
            } else {
                f2 = (float)n3 / (float)n;
                f3 = 0.5f * ((float)n4 - f2 * (float)n2);
                f = 0.0f;
            }
            this.mDrawMatrix.setScale(f2, f2);
            this.mDrawMatrix.postTranslate((int)(f + 0.5f), (int)(f3 + 0.5f));
            return;
        }
        if (ScaleType.CENTER_INSIDE != this.mScaleType) {
            this.mTempSrc.set(0.0f, 0.0f, n, n2);
            this.mTempDst.set(0.0f, 0.0f, n3, n4);
            this.mDrawMatrix = this.mMatrix;
            this.mDrawMatrix.setRectToRect(this.mTempSrc, this.mTempDst, ImageView.scaleTypeToScaleToFit(this.mScaleType));
            return;
        }
        this.mDrawMatrix = this.mMatrix;
        float f = n <= n3 && n2 <= n4 ? 1.0f : Math.min((float)n3 / (float)n, (float)n4 / (float)n2);
        float f4 = (int)(0.5f + 0.5f * ((float)n3 - f * (float)n));
        float f5 = (int)(0.5f + 0.5f * ((float)n4 - f * (float)n2));
        this.mDrawMatrix.setScale(f, f);
        this.mDrawMatrix.postTranslate(f4, f5);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initImageView() {
        this.mMatrix = new Matrix();
        this.mScaleType = ScaleType.FIT_CENTER;
        boolean bl = this.mContext.getApplicationInfo().targetSdkVersion <= 17;
        this.mAdjustViewBoundsCompat = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFilledByImage() {
        boolean bl = true;
        if (this.mDrawable == null) {
            return false;
        }
        Rect rect = this.mDrawable.getBounds();
        Matrix matrix = this.mDrawMatrix;
        if (matrix == null) {
            if (rect.left > 0) return false;
            if (rect.top > 0) return false;
            if (rect.right < this.getWidth()) return false;
            if (rect.bottom < this.getHeight()) return false;
            return bl;
        }
        if (!matrix.rectStaysRect()) return false;
        RectF rectF = this.mTempSrc;
        RectF rectF2 = this.mTempDst;
        rectF.set(rect);
        matrix.mapRect(rectF2, rectF);
        if (!(rectF2.left <= 0.0f)) return false;
        if (!(rectF2.top <= 0.0f)) return false;
        if (!(rectF2.right >= (float)this.getWidth())) return false;
        if (!(rectF2.bottom >= (float)this.getHeight())) return false;
        return bl;
    }

    private void resizeFromDrawable() {
        Drawable drawable2 = this.mDrawable;
        if (drawable2 != null) {
            int n;
            int n2 = drawable2.getIntrinsicWidth();
            if (n2 < 0) {
                n2 = this.mDrawableWidth;
            }
            if ((n = drawable2.getIntrinsicHeight()) < 0) {
                n = this.mDrawableHeight;
            }
            if (n2 != this.mDrawableWidth || n != this.mDrawableHeight) {
                this.mDrawableWidth = n2;
                this.mDrawableHeight = n;
                this.requestLayout();
            }
        }
    }

    private int resolveAdjustedSize(int n, int n2, int n3) {
        int n4 = View.MeasureSpec.getMode(n3);
        int n5 = View.MeasureSpec.getSize(n3);
        switch (n4) {
            default: {
                return n;
            }
            case 0: {
                return Math.min(n, n2);
            }
            case -2147483648: {
                return Math.min(Math.min(n, n5), n2);
            }
            case 0x40000000: 
        }
        return n5;
    }

    /*
     * Unable to fully structure code
     */
    private void resolveUri() {
        block22: {
            block21: {
                block20: {
                    if (this.mDrawable != null) lbl-1000:
                    // 3 sources

                    {
                        return;
                    }
                    if (this.getResources() == null) ** GOTO lbl-1000
                    if (this.mResource == 0) break block20;
                    try {
                        var8_2 = var20_1 = this.mContext.getDrawable(this.mResource);
                    }
                    catch (Exception var18_3) {
                        Log.w("ImageView", "Unable to find resource: " + this.mResource, var18_3);
                        this.mUri = null;
                        var8_2 = null;
                    }
lbl8:
                    // 4 sources

                    while (true) {
                        this.updateDrawable(var8_2);
                        return;
                    }
                }
                if (this.mUri != null) ** break;
                ** while (true)
                var1_4 = this.mUri.getScheme();
                if (!"android.resource".equals(var1_4)) break block21;
                try {
                    var16_5 = this.mContext.getContentResolver().getResourceId(this.mUri);
                    var8_2 = var17_6 = var16_5.r.getDrawable(var16_5.id, this.mContext.getTheme());
                }
                catch (Exception var14_7) {
                    Log.w("ImageView", "Unable to open content: " + this.mUri, var14_7);
                    var8_2 = null;
                }
lbl25:
                // 8 sources

                while (true) {
                    if (var8_2 != null) ** GOTO lbl8
                    System.out.println("resolveUri failed on bad bitmap uri: " + this.mUri);
                    this.mUri = null;
                    ** continue;
                    break;
                }
                ** GOTO lbl25
            }
            if (!"content".equals(var1_4) && !"file".equals(var1_4)) break block22;
            var2_8 = null;
            var2_8 = this.mContext.getContentResolver().openInputStream(this.mUri);
            var8_2 = var11_9 = Drawable.createFromStream(var2_8, null);
            if (var2_8 == null) ** GOTO lbl25
            try {
                var2_8.close();
            }
            catch (IOException var12_10) {
                Log.w("ImageView", "Unable to close content: " + this.mUri, var12_10);
            }
            ** GOTO lbl25
            catch (Exception var6_11) {
                try {
                    Log.w("ImageView", "Unable to open content: " + this.mUri, var6_11);
                    var8_2 = null;
                    if (var2_8 == null) ** GOTO lbl25
                }
                catch (Throwable var3_13) {
                    if (var2_8 != null) {
                        var2_8.close();
                    }
lbl59:
                    // 4 sources

                    throw var3_13;
                    catch (IOException var4_14) {
                        Log.w("ImageView", "Unable to close content: " + this.mUri, var4_14);
                        ** continue;
                    }
                }
                try {
                    var2_8.close();
                    var8_2 = null;
                }
                catch (IOException var9_12) {
                    Log.w("ImageView", "Unable to close content: " + this.mUri, var9_12);
                    var8_2 = null;
                }
                ** GOTO lbl25
            }
        }
        var8_2 = Drawable.createFromPath(this.mUri.toString());
        ** while (true)
    }

    private static Matrix.ScaleToFit scaleTypeToScaleToFit(ScaleType scaleType) {
        return sS2FArray[-1 + scaleType.nativeInt];
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateDrawable(Drawable drawable2) {
        if (this.mDrawable != null) {
            this.mDrawable.setCallback(null);
            this.unscheduleDrawable(this.mDrawable);
        }
        this.mDrawable = drawable2;
        if (drawable2 == null) {
            this.mDrawableHeight = -1;
            this.mDrawableWidth = -1;
            return;
        }
        drawable2.setCallback(this);
        drawable2.setLayoutDirection(this.getLayoutDirection());
        if (drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
        boolean bl = this.getVisibility() == 0;
        drawable2.setVisible(bl, true);
        drawable2.setLevel(this.mLevel);
        this.mDrawableWidth = drawable2.getIntrinsicWidth();
        this.mDrawableHeight = drawable2.getIntrinsicHeight();
        this.applyImageTint();
        this.applyColorMod();
        this.configureBounds();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void animateTransform(Matrix matrix) {
        if (matrix == null) {
            this.mDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.mDrawable.setBounds(0, 0, this.mDrawableWidth, this.mDrawableHeight);
            if (this.mDrawMatrix == null) {
                this.mDrawMatrix = new Matrix();
            }
            this.mDrawMatrix.set(matrix);
        }
        this.invalidate();
    }

    public final void clearColorFilter() {
        this.setColorFilter(null);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        super.drawableHotspotChanged(f, f2);
        if (this.mDrawable != null) {
            this.mDrawable.setHotspot(f, f2);
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.mDrawable;
        if (drawable2 != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    public boolean getAdjustViewBounds() {
        return this.mAdjustViewBounds;
    }

    @Override
    @ViewDebug.ExportedProperty(category="layout")
    public int getBaseline() {
        if (this.mBaselineAlignBottom) {
            return this.getMeasuredHeight();
        }
        return this.mBaseline;
    }

    public boolean getBaselineAlignBottom() {
        return this.mBaselineAlignBottom;
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public boolean getCropToPadding() {
        return this.mCropToPadding;
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public int getImageAlpha() {
        return this.mAlpha;
    }

    public Matrix getImageMatrix() {
        if (this.mDrawMatrix == null) {
            return new Matrix(Matrix.IDENTITY_MATRIX);
        }
        return this.mDrawMatrix;
    }

    public ColorStateList getImageTintList() {
        return this.mDrawableTintList;
    }

    public PorterDuff.Mode getImageTintMode() {
        return this.mDrawableTintMode;
    }

    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public ScaleType getScaleType() {
        return this.mScaleType;
    }

    @Override
    public boolean hasOverlappingRendering() {
        return this.getBackground() != null && this.getBackground().getCurrent() != null;
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (drawable2 == this.mDrawable) {
            this.invalidate();
            return;
        }
        super.invalidateDrawable(drawable2);
    }

    @Override
    public boolean isOpaque() {
        return super.isOpaque() || this.mDrawable != null && this.mXfermode == null && this.mDrawable.getOpacity() == -1 && this.mAlpha * this.mViewAlphaScale >> 8 == 255 && this.isFilledByImage();
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mDrawable != null) {
            this.mDrawable.jumpToCurrentState();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mDrawable != null) {
            Drawable drawable2 = this.mDrawable;
            boolean bl = this.getVisibility() == 0;
            drawable2.setVisible(bl, false);
        }
    }

    @Override
    public int[] onCreateDrawableState(int n) {
        if (this.mState == null) {
            return super.onCreateDrawableState(n);
        }
        if (!this.mMergeState) {
            return this.mState;
        }
        return ImageView.mergeDrawableStates(super.onCreateDrawableState(n + this.mState.length), this.mState);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mDrawable != null) {
            this.mDrawable.setVisible(false, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawable == null || this.mDrawableWidth == 0 || this.mDrawableHeight == 0) {
            return;
        }
        if (this.mDrawMatrix == null && this.mPaddingTop == 0 && this.mPaddingLeft == 0) {
            this.mDrawable.draw(canvas);
            return;
        }
        int n = canvas.getSaveCount();
        canvas.save();
        if (this.mCropToPadding) {
            int n2 = this.mScrollX;
            int n3 = this.mScrollY;
            canvas.clipRect(n2 + this.mPaddingLeft, n3 + this.mPaddingTop, n2 + this.mRight - this.mLeft - this.mPaddingRight, n3 + this.mBottom - this.mTop - this.mPaddingBottom);
        }
        canvas.translate(this.mPaddingLeft, this.mPaddingTop);
        if (this.mDrawMatrix != null) {
            canvas.concat(this.mDrawMatrix);
        }
        this.mDrawable.draw(canvas);
        canvas.restoreToCount(n);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(ImageView.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(ImageView.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        block12: {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            block11: {
                this.resolveUri();
                float f = 0.0f;
                boolean bl = false;
                boolean bl2 = false;
                int n11 = View.MeasureSpec.getMode(n);
                int n12 = View.MeasureSpec.getMode(n2);
                if (this.mDrawable == null) {
                    this.mDrawableWidth = -1;
                    this.mDrawableHeight = -1;
                    n10 = 0;
                    n9 = 0;
                } else {
                    n9 = this.mDrawableWidth;
                    n10 = this.mDrawableHeight;
                    if (n9 <= 0) {
                        n9 = 1;
                    }
                    if (n10 <= 0) {
                        n10 = 1;
                    }
                    boolean bl3 = this.mAdjustViewBounds;
                    f = 0.0f;
                    bl2 = false;
                    bl = false;
                    if (bl3) {
                        bl = n11 != 0x40000000;
                        bl2 = n12 != 0x40000000;
                        f = (float)n9 / (float)n10;
                    }
                }
                n8 = this.mPaddingLeft;
                n7 = this.mPaddingRight;
                n6 = this.mPaddingTop;
                n5 = this.mPaddingBottom;
                if (!bl && !bl2) break block11;
                n4 = this.resolveAdjustedSize(n7 + (n9 + n8), this.mMaxWidth, n);
                n3 = this.resolveAdjustedSize(n5 + (n10 + n6), this.mMaxHeight, n2);
                if (f == 0.0f || !((double)Math.abs((float)(n4 - n8 - n7) / (float)(n3 - n6 - n5) - f) > 1.0E-7)) break block12;
                boolean bl4 = false;
                if (bl) {
                    int n13 = n7 + (n8 + (int)(f * (float)(n3 - n6 - n5)));
                    if (!bl2 && !this.mAdjustViewBoundsCompat) {
                        n4 = this.resolveAdjustedSize(n13, this.mMaxWidth, n);
                    }
                    int n14 = n4;
                    bl4 = false;
                    if (n13 <= n14) {
                        n4 = n13;
                        bl4 = true;
                    }
                }
                if (!bl4 && bl2) {
                    int n15 = n5 + (n6 + (int)((float)(n4 - n8 - n7) / f));
                    if (!bl && !this.mAdjustViewBoundsCompat) {
                        n3 = this.resolveAdjustedSize(n15, this.mMaxHeight, n2);
                    }
                    if (n15 <= n3) {
                        n3 = n15;
                    }
                }
                break block12;
            }
            int n16 = n9 + (n8 + n7);
            int n17 = n10 + (n6 + n5);
            int n18 = Math.max(n16, this.getSuggestedMinimumWidth());
            int n19 = Math.max(n17, this.getSuggestedMinimumHeight());
            n4 = ImageView.resolveSizeAndState(n18, n, 0);
            n3 = ImageView.resolveSizeAndState(n19, n2, 0);
        }
        this.setMeasuredDimension(n4, n3);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onPopulateAccessibilityEvent(accessibilityEvent);
        CharSequence charSequence = this.getContentDescription();
        if (!TextUtils.isEmpty(charSequence)) {
            accessibilityEvent.getText().add(charSequence);
        }
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        super.onRtlPropertiesChanged(n);
        if (this.mDrawable != null) {
            this.mDrawable.setLayoutDirection(n);
        }
    }

    @RemotableViewMethod
    public void setAdjustViewBounds(boolean bl) {
        this.mAdjustViewBounds = bl;
        if (bl) {
            this.setScaleType(ScaleType.FIT_CENTER);
        }
    }

    @RemotableViewMethod
    @Deprecated
    public void setAlpha(int n) {
        int n2 = n & 0xFF;
        if (this.mAlpha != n2) {
            this.mAlpha = n2;
            this.mColorMod = true;
            this.applyColorMod();
            this.invalidate();
        }
    }

    public void setBaseline(int n) {
        if (this.mBaseline != n) {
            this.mBaseline = n;
            this.requestLayout();
        }
    }

    public void setBaselineAlignBottom(boolean bl) {
        if (this.mBaselineAlignBottom != bl) {
            this.mBaselineAlignBottom = bl;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public final void setColorFilter(int n) {
        this.setColorFilter(n, PorterDuff.Mode.SRC_ATOP);
    }

    public final void setColorFilter(int n, PorterDuff.Mode mode) {
        this.setColorFilter(new PorterDuffColorFilter(n, mode));
    }

    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mColorFilter != colorFilter) {
            this.mColorFilter = colorFilter;
            this.mHasColorFilter = true;
            this.mColorMod = true;
            this.applyColorMod();
            this.invalidate();
        }
    }

    public void setCropToPadding(boolean bl) {
        if (this.mCropToPadding != bl) {
            this.mCropToPadding = bl;
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        boolean bl = super.setFrame(n, n2, n3, n4);
        this.mHaveFrame = true;
        this.configureBounds();
        return bl;
    }

    @RemotableViewMethod
    public void setImageAlpha(int n) {
        this.setAlpha(n);
    }

    @RemotableViewMethod
    public void setImageBitmap(Bitmap bitmap) {
        this.setImageDrawable(new BitmapDrawable(this.mContext.getResources(), bitmap));
    }

    public void setImageDrawable(Drawable drawable2) {
        if (this.mDrawable != drawable2) {
            this.mResource = 0;
            this.mUri = null;
            int n = this.mDrawableWidth;
            int n2 = this.mDrawableHeight;
            this.updateDrawable(drawable2);
            if (n != this.mDrawableWidth || n2 != this.mDrawableHeight) {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    @RemotableViewMethod
    public void setImageLevel(int n) {
        this.mLevel = n;
        if (this.mDrawable != null) {
            this.mDrawable.setLevel(n);
            this.resizeFromDrawable();
        }
    }

    public void setImageMatrix(Matrix matrix) {
        if (matrix != null && matrix.isIdentity()) {
            matrix = null;
        }
        if (matrix == null && !this.mMatrix.isIdentity() || matrix != null && !this.mMatrix.equals(matrix)) {
            this.mMatrix.set(matrix);
            this.configureBounds();
            this.invalidate();
        }
    }

    @RemotableViewMethod
    public void setImageResource(int n) {
        if (this.mUri != null || this.mResource != n) {
            int n2 = this.mDrawableWidth;
            int n3 = this.mDrawableHeight;
            this.updateDrawable(null);
            this.mResource = n;
            this.mUri = null;
            this.resolveUri();
            if (n2 != this.mDrawableWidth || n3 != this.mDrawableHeight) {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    public void setImageState(int[] nArray, boolean bl) {
        this.mState = nArray;
        this.mMergeState = bl;
        if (this.mDrawable != null) {
            this.refreshDrawableState();
            this.resizeFromDrawable();
        }
    }

    public void setImageTintList(ColorStateList colorStateList) {
        this.mDrawableTintList = colorStateList;
        this.mHasDrawableTint = true;
        this.applyImageTint();
    }

    public void setImageTintMode(PorterDuff.Mode mode) {
        this.mDrawableTintMode = mode;
        this.mHasDrawableTintMode = true;
        this.applyImageTint();
    }

    @RemotableViewMethod
    public void setImageURI(Uri uri) {
        if (this.mResource != 0 || this.mUri != uri && (uri == null || this.mUri == null || !uri.equals(this.mUri))) {
            this.updateDrawable(null);
            this.mResource = 0;
            this.mUri = uri;
            int n = this.mDrawableWidth;
            int n2 = this.mDrawableHeight;
            this.resolveUri();
            if (n != this.mDrawableWidth || n2 != this.mDrawableHeight) {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    @RemotableViewMethod
    public void setMaxHeight(int n) {
        this.mMaxHeight = n;
    }

    @RemotableViewMethod
    public void setMaxWidth(int n) {
        this.mMaxWidth = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setScaleType(ScaleType scaleType) {
        if (scaleType == null) {
            throw new NullPointerException();
        }
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            boolean bl = this.mScaleType == ScaleType.CENTER;
            this.setWillNotCacheDrawing(bl);
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.resizeFromDrawable();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        super.setVisibility(n);
        if (this.mDrawable != null) {
            Drawable drawable2 = this.mDrawable;
            boolean bl = n == 0;
            drawable2.setVisible(bl, false);
        }
    }

    public final void setXfermode(Xfermode xfermode) {
        if (this.mXfermode != xfermode) {
            this.mXfermode = xfermode;
            this.mColorMod = true;
            this.applyColorMod();
            this.invalidate();
        }
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return this.mDrawable == drawable2 || super.verifyDrawable(drawable2);
    }

    public static final class ScaleType
    extends Enum<ScaleType> {
        private static final /* synthetic */ ScaleType[] $VALUES;
        public static final /* enum */ ScaleType CENTER;
        public static final /* enum */ ScaleType CENTER_CROP;
        public static final /* enum */ ScaleType CENTER_INSIDE;
        public static final /* enum */ ScaleType FIT_CENTER;
        public static final /* enum */ ScaleType FIT_END;
        public static final /* enum */ ScaleType FIT_START;
        public static final /* enum */ ScaleType FIT_XY;
        public static final /* enum */ ScaleType MATRIX;
        final int nativeInt;

        static {
            MATRIX = new ScaleType(0);
            FIT_XY = new ScaleType(1);
            FIT_START = new ScaleType(2);
            FIT_CENTER = new ScaleType(3);
            FIT_END = new ScaleType(4);
            CENTER = new ScaleType(5);
            CENTER_CROP = new ScaleType(6);
            CENTER_INSIDE = new ScaleType(7);
            ScaleType[] scaleTypeArray = new ScaleType[]{MATRIX, FIT_XY, FIT_START, FIT_CENTER, FIT_END, CENTER, CENTER_CROP, CENTER_INSIDE};
            $VALUES = scaleTypeArray;
        }

        private ScaleType(int n2) {
            this.nativeInt = n2;
        }

        public static ScaleType valueOf(String string2) {
            return Enum.valueOf(ScaleType.class, string2);
        }

        public static ScaleType[] values() {
            return (ScaleType[])$VALUES.clone();
        }
    }
}

