/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.widget.EdgeEffect;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import java.util.ArrayList;

public class HorizontalScrollView
extends FrameLayout {
    private static final int ANIMATED_SCROLL_GAP = 250;
    private static final int INVALID_POINTER = -1;
    private static final float MAX_SCROLL_FACTOR = 0.5f;
    private static final String TAG = "HorizontalScrollView";
    private int mActivePointerId = -1;
    private View mChildToScrollTo = null;
    private EdgeEffect mEdgeGlowLeft;
    private EdgeEffect mEdgeGlowRight;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mFillViewport;
    private boolean mIsBeingDragged = false;
    private boolean mIsLayoutDirty = true;
    private int mLastMotionX;
    private long mLastScroll;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private int mOverflingDistance;
    private int mOverscrollDistance;
    private SavedState mSavedState;
    private OverScroller mScroller;
    private boolean mSmoothScrollingEnabled = true;
    private final Rect mTempRect = new Rect();
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;

    public HorizontalScrollView(Context context) {
        this(context, null);
    }

    public HorizontalScrollView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843603);
    }

    public HorizontalScrollView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public HorizontalScrollView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.initScrollView();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.HorizontalScrollView, n, n2);
        this.setFillViewport(typedArray.getBoolean(0, false));
        typedArray.recycle();
    }

    private boolean canScroll() {
        View view = this.getChildAt(0);
        boolean bl = false;
        if (view != null) {
            int n = view.getWidth();
            int n2 = this.getWidth();
            int n3 = n + this.mPaddingLeft + this.mPaddingRight;
            bl = false;
            if (n2 < n3) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int clamp(int n, int n2, int n3) {
        if (n2 >= n3) return 0;
        if (n < 0) {
            return 0;
        }
        if (n2 + n <= n3) return n;
        return n3 - n2;
    }

    private void doScrollX(int n) {
        block3: {
            block2: {
                if (n == 0) break block2;
                if (!this.mSmoothScrollingEnabled) break block3;
                this.smoothScrollBy(n, 0);
            }
            return;
        }
        this.scrollBy(n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private View findFocusableViewInBounds(boolean bl, int n, int n2) {
        ArrayList<View> arrayList = this.getFocusables(2);
        View view = null;
        boolean bl2 = false;
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            View view2 = (View)arrayList.get(n4);
            int n5 = view2.getLeft();
            int n6 = view2.getRight();
            if (n < n6 && n5 < n2) {
                boolean bl3 = n < n5 && n6 < n2;
                if (view == null) {
                    view = view2;
                    bl2 = bl3;
                } else {
                    boolean bl4 = bl && n5 < view.getLeft() || !bl && n6 > view.getRight();
                    if (bl2) {
                        if (bl3 && bl4) {
                            view = view2;
                        }
                    } else if (bl3) {
                        view = view2;
                        bl2 = true;
                    } else if (bl4) {
                        view = view2;
                    }
                }
            }
            ++n4;
        }
        return view;
    }

    private View findFocusableViewInMyBounds(boolean bl, int n, View view) {
        int n2 = this.getHorizontalFadingEdgeLength() / 2;
        int n3 = n + n2;
        int n4 = n + this.getWidth() - n2;
        if (view != null && view.getLeft() < n4 && view.getRight() > n3) {
            return view;
        }
        return this.findFocusableViewInBounds(bl, n3, n4);
    }

    private int getScrollRange() {
        int n = this.getChildCount();
        int n2 = 0;
        if (n > 0) {
            n2 = Math.max(0, this.getChildAt(0).getWidth() - (this.getWidth() - this.mPaddingLeft - this.mPaddingRight));
        }
        return n2;
    }

    private boolean inChild(int n, int n2) {
        int n3 = this.getChildCount();
        boolean bl = false;
        if (n3 > 0) {
            int n4 = this.mScrollX;
            View view = this.getChildAt(0);
            int n5 = view.getTop();
            bl = false;
            if (n2 >= n5) {
                int n6 = view.getBottom();
                bl = false;
                if (n2 < n6) {
                    int n7 = view.getLeft() - n4;
                    bl = false;
                    if (n >= n7) {
                        int n8 = view.getRight() - n4;
                        bl = false;
                        if (n < n8) {
                            bl = true;
                        }
                    }
                }
            }
        }
        return bl;
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
            return;
        }
        this.mVelocityTracker.clear();
    }

    private void initScrollView() {
        this.mScroller = new OverScroller(this.getContext());
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.mContext);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = viewConfiguration.getScaledOverscrollDistance();
        this.mOverflingDistance = viewConfiguration.getScaledOverflingDistance();
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private boolean isOffScreen(View view) {
        boolean bl = this.isWithinDeltaOfScreen(view, 0);
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isViewDescendantOf(View view, View view2) {
        ViewParent viewParent;
        return view == view2 || (viewParent = view.getParent()) instanceof ViewGroup && HorizontalScrollView.isViewDescendantOf((View)((Object)viewParent), view2);
    }

    private boolean isWithinDeltaOfScreen(View view, int n) {
        view.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        return n + this.mTempRect.right >= this.getScrollX() && this.mTempRect.left - n <= this.getScrollX() + this.getWidth();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n = (0xFF00 & motionEvent.getAction()) >> 8;
        if (motionEvent.getPointerId(n) == this.mActivePointerId) {
            int n2 = n == 0 ? 1 : 0;
            this.mLastMotionX = (int)motionEvent.getX(n2);
            this.mActivePointerId = motionEvent.getPointerId(n2);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean scrollAndFocus(int n, int n2, int n3) {
        boolean bl = true;
        int n4 = this.getWidth();
        int n5 = this.getScrollX();
        int n6 = n5 + n4;
        boolean bl2 = n == 17;
        View view = this.findFocusableViewInBounds(bl2, n2, n3);
        if (view == null) {
            view = this;
        }
        if (n2 >= n5 && n3 <= n6) {
            bl = false;
        } else {
            int n7 = bl2 ? n2 - n5 : n3 - n6;
            this.doScrollX(n7);
        }
        if (view != this.findFocus()) {
            view.requestFocus(n);
        }
        return bl;
    }

    private void scrollToChild(View view) {
        view.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        int n = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
        if (n != 0) {
            this.scrollBy(n, 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scrollToChildRect(Rect rect, boolean bl) {
        int n = this.computeScrollDeltaToGetChildRectOnScreen(rect);
        if (n == 0) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        if (bl) {
            this.scrollBy(n, 0);
            return bl2;
        }
        this.smoothScrollBy(n, 0);
        return bl2;
    }

    @Override
    public void addView(View view) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(view);
    }

    @Override
    public void addView(View view, int n) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(view, n);
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(view, n, layoutParams);
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(view, layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean arrowScroll(int n) {
        View view = this.findFocus();
        if (view == this) {
            view = null;
        }
        View view2 = FocusFinder.getInstance().findNextFocus(this, view, n);
        int n2 = this.getMaxScrollAmount();
        if (view2 != null && this.isWithinDeltaOfScreen(view2, n2)) {
            view2.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(view2, this.mTempRect);
            this.doScrollX(this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect));
            view2.requestFocus(n);
        } else {
            int n3;
            int n4;
            int n5 = n2;
            if (n == 17 && this.getScrollX() < n5) {
                n5 = this.getScrollX();
            } else if (n == 66 && this.getChildCount() > 0 && (n4 = this.getChildAt(0).getRight()) - (n3 = this.getScrollX() + this.getWidth()) < n2) {
                n5 = n4 - n3;
            }
            boolean bl = false;
            if (n5 == 0) return bl;
            int n6 = n == 66 ? n5 : -n5;
            this.doScrollX(n6);
        }
        if (view == null) return true;
        if (!view.isFocused()) return true;
        if (!this.isOffScreen(view)) return true;
        int n7 = this.getDescendantFocusability();
        this.setDescendantFocusability(131072);
        this.requestFocus();
        this.setDescendantFocusability(n7);
        return true;
    }

    @Override
    protected int computeHorizontalScrollOffset() {
        return Math.max(0, super.computeHorizontalScrollOffset());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int computeHorizontalScrollRange() {
        int n = this.getChildCount();
        int n2 = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
        if (n == 0) {
            return n2;
        }
        int n3 = this.getChildAt(0).getRight();
        int n4 = this.mScrollX;
        int n5 = Math.max(0, n3 - n2);
        if (n4 < 0) {
            n3 -= n4;
            return n3;
        }
        if (n4 <= n5) return n3;
        return n3 += n4 - n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void computeScroll() {
        int n = 1;
        if (!this.mScroller.computeScrollOffset()) return;
        int n2 = this.mScrollX;
        int n3 = this.mScrollY;
        int n4 = this.mScroller.getCurrX();
        int n5 = this.mScroller.getCurrY();
        if (n2 != n4 || n3 != n5) {
            int n6 = this.getScrollRange();
            int n7 = this.getOverScrollMode();
            if (n7 != 0 && (n7 != n || n6 <= 0)) {
                n = 0;
            }
            this.overScrollBy(n4 - n2, n5 - n3, n2, n3, n6, 0, this.mOverflingDistance, 0, false);
            this.onScrollChanged(this.mScrollX, this.mScrollY, n2, n3);
            if (n != 0) {
                if (n4 < 0 && n2 >= 0) {
                    this.mEdgeGlowLeft.onAbsorb((int)this.mScroller.getCurrVelocity());
                } else if (n4 > n6 && n2 <= n6) {
                    this.mEdgeGlowRight.onAbsorb((int)this.mScroller.getCurrVelocity());
                }
            }
        }
        if (!this.awakenScrollBars()) {
            this.postInvalidateOnAnimation();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        int n;
        if (this.getChildCount() == 0) {
            return 0;
        }
        int n2 = this.getWidth();
        int n3 = this.getScrollX();
        int n4 = n3 + n2;
        int n5 = this.getHorizontalFadingEdgeLength();
        if (rect.left > 0) {
            n3 += n5;
        }
        if (rect.right < this.getChildAt(0).getWidth()) {
            n4 -= n5;
        }
        if (rect.right > n4 && rect.left > n3) {
            int n6;
            if (rect.width() > n2) {
                n6 = 0 + (rect.left - n3);
                return Math.min(n6, this.getChildAt(0).getRight() - n4);
            }
            n6 = 0 + (rect.right - n4);
            return Math.min(n6, this.getChildAt(0).getRight() - n4);
        }
        if (rect.left >= n3) return 0;
        if (rect.right >= n4) return 0;
        if (rect.width() > n2) {
            n = 0 - (n4 - rect.right);
            return Math.max(n, -this.getScrollX());
        }
        n = 0 - (n3 - rect.left);
        return Math.max(n, -this.getScrollX());
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || this.executeKeyEvent(keyEvent);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowLeft != null) {
            int n = this.mScrollX;
            if (!this.mEdgeGlowLeft.isFinished()) {
                int n2 = canvas.save();
                int n3 = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                canvas.rotate(270.0f);
                canvas.translate(-n3 + this.mPaddingTop, Math.min(0, n));
                this.mEdgeGlowLeft.setSize(n3, this.getWidth());
                if (this.mEdgeGlowLeft.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(n2);
            }
            if (!this.mEdgeGlowRight.isFinished()) {
                int n4 = canvas.save();
                int n5 = this.getWidth();
                int n6 = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                canvas.rotate(90.0f);
                canvas.translate(-this.mPaddingTop, -(n5 + Math.max(this.getScrollRange(), n)));
                this.mEdgeGlowRight.setSize(n6, n5);
                if (this.mEdgeGlowRight.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(n4);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean executeKeyEvent(KeyEvent keyEvent) {
        this.mTempRect.setEmpty();
        if (!this.canScroll()) {
            boolean bl = this.isFocused();
            boolean bl2 = false;
            if (!bl) return bl2;
            View view = this.findFocus();
            if (view == this) {
                view = null;
            }
            View view2 = FocusFinder.getInstance().findNextFocus(this, view, 66);
            bl2 = false;
            if (view2 == null) return bl2;
            bl2 = false;
            if (view2 == this) return bl2;
            boolean bl3 = view2.requestFocus(66);
            bl2 = false;
            if (!bl3) return bl2;
            return true;
        }
        int n = keyEvent.getAction();
        boolean bl = false;
        if (n != 0) return bl;
        int n2 = keyEvent.getKeyCode();
        bl = false;
        switch (n2) {
            case 21: {
                if (keyEvent.isAltPressed()) return this.fullScroll(17);
                return this.arrowScroll(17);
            }
            case 22: {
                if (keyEvent.isAltPressed()) return this.fullScroll(66);
                return this.arrowScroll(66);
            }
            case 62: {
                int n3 = keyEvent.isShiftPressed() ? 17 : 66;
                this.pageScroll(n3);
                return false;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fling(int n) {
        if (this.getChildCount() > 0) {
            int n2 = this.getWidth() - this.mPaddingRight - this.mPaddingLeft;
            int n3 = this.getChildAt(0).getWidth();
            this.mScroller.fling(this.mScrollX, this.mScrollY, n, 0, 0, Math.max(0, n3 - n2), 0, 0, n2 / 2, 0);
            boolean bl = n > 0;
            View view = this.findFocus();
            View view2 = this.findFocusableViewInMyBounds(bl, this.mScroller.getFinalX(), view);
            if (view2 == null) {
                view2 = this;
            }
            if (view2 != view) {
                int n4 = bl ? 66 : 17;
                view2.requestFocus(n4);
            }
            this.postInvalidateOnAnimation();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean fullScroll(int n) {
        boolean bl = n == 66;
        int n2 = this.getWidth();
        this.mTempRect.left = 0;
        this.mTempRect.right = n2;
        if (bl && this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            this.mTempRect.right = view.getRight();
            this.mTempRect.left = this.mTempRect.right - n2;
        }
        return this.scrollAndFocus(n, this.mTempRect.left, this.mTempRect.right);
    }

    @Override
    protected float getLeftFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int n = this.getHorizontalFadingEdgeLength();
        if (this.mScrollX < n) {
            return (float)this.mScrollX / (float)n;
        }
        return 1.0f;
    }

    public int getMaxScrollAmount() {
        return (int)(0.5f * (float)(this.mRight - this.mLeft));
    }

    @Override
    protected float getRightFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int n = this.getHorizontalFadingEdgeLength();
        int n2 = this.getWidth() - this.mPaddingRight;
        int n3 = this.getChildAt(0).getRight() - this.mScrollX - n2;
        if (n3 < n) {
            return (float)n3 / (float)n;
        }
        return 1.0f;
    }

    public boolean isFillViewport() {
        return this.mFillViewport;
    }

    public boolean isSmoothScrollingEnabled() {
        return this.mSmoothScrollingEnabled;
    }

    @Override
    protected void measureChild(View view, int n, int n2) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        int n3 = HorizontalScrollView.getChildMeasureSpec(n2, this.mPaddingTop + this.mPaddingBottom, layoutParams.height);
        view.measure(View.MeasureSpec.makeMeasureSpec(0, 0), n3);
    }

    @Override
    protected void measureChildWithMargins(View view, int n, int n2, int n3, int n4) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        int n5 = HorizontalScrollView.getChildMeasureSpec(n3, n4 + (this.mPaddingTop + this.mPaddingBottom + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin), marginLayoutParams.height);
        view.measure(View.MeasureSpec.makeMeasureSpec(marginLayoutParams.leftMargin + marginLayoutParams.rightMargin, 0), n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if ((2 & motionEvent.getSource()) == 0) return super.onGenericMotionEvent(motionEvent);
        switch (motionEvent.getAction()) {
            default: {
                return super.onGenericMotionEvent(motionEvent);
            }
            case 8: {
                float f;
                if (this.mIsBeingDragged || (f = (1 & motionEvent.getMetaState()) != 0 ? -motionEvent.getAxisValue(9) : motionEvent.getAxisValue(10)) == 0.0f) return super.onGenericMotionEvent(motionEvent);
                int n = (int)(f * this.getHorizontalScrollFactor());
                int n2 = this.getScrollRange();
                int n3 = this.mScrollX;
                int n4 = n3 + n;
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > n2) {
                    n4 = n2;
                }
                if (n4 == n3) return super.onGenericMotionEvent(motionEvent);
                super.scrollTo(n4, this.mScrollY);
                return true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(HorizontalScrollView.class.getName());
        boolean bl = this.getScrollRange() > 0;
        accessibilityEvent.setScrollable(bl);
        accessibilityEvent.setScrollX(this.mScrollX);
        accessibilityEvent.setScrollY(this.mScrollY);
        accessibilityEvent.setMaxScrollX(this.getScrollRange());
        accessibilityEvent.setMaxScrollY(this.mScrollY);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(HorizontalScrollView.class.getName());
        int n = this.getScrollRange();
        if (n > 0) {
            accessibilityNodeInfo.setScrollable(true);
            if (this.isEnabled() && this.mScrollX > 0) {
                accessibilityNodeInfo.addAction(8192);
            }
            if (this.isEnabled() && this.mScrollX < n) {
                accessibilityNodeInfo.addAction(4096);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (n == 2 && this.mIsBeingDragged) {
            return true;
        }
        switch (n & 0xFF) {
            case 2: {
                int n2 = this.mActivePointerId;
                if (n2 == -1) return this.mIsBeingDragged;
                int n3 = motionEvent.findPointerIndex(n2);
                if (n3 == -1) {
                    Log.e(TAG, "Invalid pointerId=" + n2 + " in onInterceptTouchEvent");
                    return this.mIsBeingDragged;
                }
                int n4 = (int)motionEvent.getX(n3);
                if (Math.abs(n4 - this.mLastMotionX) <= this.mTouchSlop) return this.mIsBeingDragged;
                this.mIsBeingDragged = true;
                this.mLastMotionX = n4;
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(motionEvent);
                if (this.mParent == null) return this.mIsBeingDragged;
                this.mParent.requestDisallowInterceptTouchEvent(true);
                return this.mIsBeingDragged;
            }
            case 0: {
                int n5 = (int)motionEvent.getX();
                if (!this.inChild(n5, (int)motionEvent.getY())) {
                    this.mIsBeingDragged = false;
                    this.recycleVelocityTracker();
                    return this.mIsBeingDragged;
                }
                this.mLastMotionX = n5;
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(motionEvent);
                boolean bl = this.mScroller.isFinished();
                boolean bl2 = false;
                if (!bl) {
                    bl2 = true;
                }
                this.mIsBeingDragged = bl2;
                return this.mIsBeingDragged;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                if (!this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0)) return this.mIsBeingDragged;
                this.postInvalidateOnAnimation();
                return this.mIsBeingDragged;
            }
            case 5: {
                int n6 = motionEvent.getActionIndex();
                this.mLastMotionX = (int)motionEvent.getX(n6);
                this.mActivePointerId = motionEvent.getPointerId(n6);
                return this.mIsBeingDragged;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                this.mLastMotionX = (int)motionEvent.getX(motionEvent.findPointerIndex(this.mActivePointerId));
                return this.mIsBeingDragged;
            }
        }
        return this.mIsBeingDragged;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount();
        int n6 = 0;
        int n7 = 0;
        if (n5 > 0) {
            n7 = this.getChildAt(0).getMeasuredWidth();
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.getChildAt(0).getLayoutParams();
            n6 = layoutParams.leftMargin + layoutParams.rightMargin;
        }
        boolean bl2 = n7 > n3 - n - this.getPaddingLeftWithForeground() - this.getPaddingRightWithForeground() - n6;
        this.layoutChildren(n, n2, n3, n4, bl2);
        this.mIsLayoutDirty = false;
        if (this.mChildToScrollTo != null && HorizontalScrollView.isViewDescendantOf(this.mChildToScrollTo, this)) {
            this.scrollToChild(this.mChildToScrollTo);
        }
        this.mChildToScrollTo = null;
        if (!this.isLaidOut()) {
            int n8 = Math.max(0, n7 - (n3 - n - this.mPaddingLeft - this.mPaddingRight));
            if (this.mSavedState != null) {
                this.mScrollX = this.isLayoutRtl() == this.mSavedState.isLayoutRtl ? this.mSavedState.scrollPosition : n8 - this.mSavedState.scrollPosition;
                this.mSavedState = null;
            } else if (this.isLayoutRtl()) {
                this.mScrollX = n8 - this.mScrollX;
            }
            if (this.mScrollX > n8) {
                this.mScrollX = n8;
            } else if (this.mScrollX < 0) {
                this.mScrollX = 0;
            }
        }
        this.scrollTo(this.mScrollX, this.mScrollY);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        View view;
        block3: {
            block2: {
                super.onMeasure(n, n2);
                if (!this.mFillViewport || View.MeasureSpec.getMode(n) == 0 || this.getChildCount() <= 0) break block2;
                view = this.getChildAt(0);
                n3 = this.getMeasuredWidth();
                if (view.getMeasuredWidth() < n3) break block3;
            }
            return;
        }
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        int n4 = HorizontalScrollView.getChildMeasureSpec(n2, this.mPaddingTop + this.mPaddingBottom, layoutParams.height);
        view.measure(View.MeasureSpec.makeMeasureSpec(n3 - this.mPaddingLeft - this.mPaddingRight, 0x40000000), n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        if (!this.mScroller.isFinished()) {
            int n3 = this.mScrollX;
            int n4 = this.mScrollY;
            this.mScrollX = n;
            this.mScrollY = n2;
            this.invalidateParentIfNeeded();
            this.onScrollChanged(this.mScrollX, this.mScrollY, n3, n4);
            if (bl) {
                this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0);
            }
        } else {
            super.scrollTo(n, n2);
        }
        this.awakenScrollBars();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        if (n == 2) {
            n = 66;
        } else if (n == 1) {
            n = 17;
        }
        View view = rect == null ? FocusFinder.getInstance().findNextFocus(this, null, n) : FocusFinder.getInstance().findNextFocusFromRect(this, rect, n);
        if (view == null || this.isOffScreen(view)) {
            return false;
        }
        return view.requestFocus(n, rect);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (this.mContext.getApplicationInfo().targetSdkVersion <= 18) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mSavedState = savedState;
        this.requestLayout();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        if (this.mContext.getApplicationInfo().targetSdkVersion <= 18) {
            return super.onSaveInstanceState();
        }
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.scrollPosition = this.mScrollX;
        savedState.isLayoutRtl = this.isLayoutRtl();
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        View view = this.findFocus();
        if (view == null || this == view || !this.isWithinDeltaOfScreen(view, this.mRight - this.mLeft)) {
            return;
        }
        view.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        this.doScrollX(this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.initVelocityTrackerIfNotExists();
        this.mVelocityTracker.addMovement(motionEvent);
        switch (0xFF & motionEvent.getAction()) {
            case 0: {
                ViewParent viewParent;
                if (this.getChildCount() == 0) {
                    return false;
                }
                boolean bl = !this.mScroller.isFinished();
                this.mIsBeingDragged = bl;
                if (bl && (viewParent = this.getParent()) != null) {
                    viewParent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionX = (int)motionEvent.getX();
                this.mActivePointerId = motionEvent.getPointerId(0);
                return true;
            }
            case 2: {
                int n = motionEvent.findPointerIndex(this.mActivePointerId);
                if (n == -1) {
                    Log.e(TAG, "Invalid pointerId=" + this.mActivePointerId + " in onTouchEvent");
                    return true;
                }
                int n2 = (int)motionEvent.getX(n);
                int n3 = this.mLastMotionX - n2;
                if (!this.mIsBeingDragged && Math.abs(n3) > this.mTouchSlop) {
                    ViewParent viewParent = this.getParent();
                    if (viewParent != null) {
                        viewParent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mIsBeingDragged = true;
                    n3 = n3 > 0 ? (n3 -= this.mTouchSlop) : (n3 += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) return true;
                this.mLastMotionX = n2;
                int n4 = this.mScrollX;
                int n5 = this.getScrollRange();
                int n6 = this.getOverScrollMode();
                boolean bl = n6 == 0 || n6 == 1 && n5 > 0;
                if (this.overScrollBy(n3, 0, this.mScrollX, 0, n5, 0, this.mOverscrollDistance, 0, true)) {
                    this.mVelocityTracker.clear();
                }
                if (!bl) return true;
                int n7 = n4 + n3;
                if (n7 < 0) {
                    this.mEdgeGlowLeft.onPull((float)n3 / (float)this.getWidth(), 1.0f - motionEvent.getY(n) / (float)this.getHeight());
                    if (!this.mEdgeGlowRight.isFinished()) {
                        this.mEdgeGlowRight.onRelease();
                    }
                } else if (n7 > n5) {
                    this.mEdgeGlowRight.onPull((float)n3 / (float)this.getWidth(), motionEvent.getY(n) / (float)this.getHeight());
                    if (!this.mEdgeGlowLeft.isFinished()) {
                        this.mEdgeGlowLeft.onRelease();
                    }
                }
                if (this.mEdgeGlowLeft == null) return true;
                if (this.mEdgeGlowLeft.isFinished()) {
                    if (this.mEdgeGlowRight.isFinished()) return true;
                }
                this.postInvalidateOnAnimation();
                return true;
            }
            case 1: {
                if (!this.mIsBeingDragged) return true;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int n = (int)velocityTracker.getXVelocity(this.mActivePointerId);
                if (this.getChildCount() > 0) {
                    if (Math.abs(n) > this.mMinimumVelocity) {
                        this.fling(-n);
                    } else if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0)) {
                        this.postInvalidateOnAnimation();
                    }
                }
                this.mActivePointerId = -1;
                this.mIsBeingDragged = false;
                this.recycleVelocityTracker();
                if (this.mEdgeGlowLeft == null) return true;
                this.mEdgeGlowLeft.onRelease();
                this.mEdgeGlowRight.onRelease();
                return true;
            }
            case 3: {
                if (!this.mIsBeingDragged) return true;
                if (this.getChildCount() <= 0) return true;
                if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0)) {
                    this.postInvalidateOnAnimation();
                }
                this.mActivePointerId = -1;
                this.mIsBeingDragged = false;
                this.recycleVelocityTracker();
                if (this.mEdgeGlowLeft == null) return true;
                this.mEdgeGlowLeft.onRelease();
                this.mEdgeGlowRight.onRelease();
                return true;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                return true;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean pageScroll(int n) {
        boolean bl = n == 66;
        int n2 = this.getWidth();
        if (bl) {
            View view;
            this.mTempRect.left = n2 + this.getScrollX();
            if (this.getChildCount() > 0 && n2 + this.mTempRect.left > (view = this.getChildAt(0)).getRight()) {
                this.mTempRect.left = view.getRight() - n2;
            }
        } else {
            this.mTempRect.left = this.getScrollX() - n2;
            if (this.mTempRect.left < 0) {
                this.mTempRect.left = 0;
            }
        }
        this.mTempRect.right = n2 + this.mTempRect.left;
        return this.scrollAndFocus(n, this.mTempRect.left, this.mTempRect.right);
    }

    @Override
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        if (super.performAccessibilityAction(n, bundle)) {
            return true;
        }
        switch (n) {
            default: {
                return false;
            }
            case 4096: {
                if (!this.isEnabled()) {
                    return false;
                }
                int n2 = Math.min(this.getWidth() - this.mPaddingLeft - this.mPaddingRight + this.mScrollX, this.getScrollRange());
                if (n2 != this.mScrollX) {
                    this.smoothScrollTo(n2, 0);
                    return true;
                }
                return false;
            }
            case 8192: 
        }
        if (!this.isEnabled()) {
            return false;
        }
        int n3 = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
        int n4 = Math.max(0, this.mScrollX - n3);
        if (n4 != this.mScrollX) {
            this.smoothScrollTo(n4, 0);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void requestChildFocus(View view, View view2) {
        if (!this.mIsLayoutDirty) {
            this.scrollToChild(view2);
        } else {
            this.mChildToScrollTo = view2;
        }
        super.requestChildFocus(view, view2);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        rect.offset(view.getLeft() - view.getScrollX(), view.getTop() - view.getScrollY());
        return this.scrollToChildRect(rect, bl);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
        if (bl) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(bl);
    }

    @Override
    public void requestLayout() {
        this.mIsLayoutDirty = true;
        super.requestLayout();
    }

    @Override
    public void scrollTo(int n, int n2) {
        if (this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            int n3 = HorizontalScrollView.clamp(n, this.getWidth() - this.mPaddingRight - this.mPaddingLeft, view.getWidth());
            int n4 = HorizontalScrollView.clamp(n2, this.getHeight() - this.mPaddingBottom - this.mPaddingTop, view.getHeight());
            if (n3 != this.mScrollX || n4 != this.mScrollY) {
                super.scrollTo(n3, n4);
            }
        }
    }

    public void setFillViewport(boolean bl) {
        if (bl != this.mFillViewport) {
            this.mFillViewport = bl;
            this.requestLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setOverScrollMode(int n) {
        if (n != 2) {
            if (this.mEdgeGlowLeft == null) {
                Context context = this.getContext();
                this.mEdgeGlowLeft = new EdgeEffect(context);
                this.mEdgeGlowRight = new EdgeEffect(context);
            }
        } else {
            this.mEdgeGlowLeft = null;
            this.mEdgeGlowRight = null;
        }
        super.setOverScrollMode(n);
    }

    public void setSmoothScrollingEnabled(boolean bl) {
        this.mSmoothScrollingEnabled = bl;
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void smoothScrollBy(int n, int n2) {
        if (this.getChildCount() == 0) {
            return;
        }
        if (AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll > 250L) {
            int n3 = this.getWidth() - this.mPaddingRight - this.mPaddingLeft;
            int n4 = Math.max(0, this.getChildAt(0).getWidth() - n3);
            int n5 = this.mScrollX;
            int n6 = Math.max(0, Math.min(n5 + n, n4)) - n5;
            this.mScroller.startScroll(n5, this.mScrollY, n6, 0);
            this.postInvalidateOnAnimation();
        } else {
            if (!this.mScroller.isFinished()) {
                this.mScroller.abortAnimation();
            }
            this.scrollBy(n, n2);
        }
        this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
    }

    public final void smoothScrollTo(int n, int n2) {
        this.smoothScrollBy(n - this.mScrollX, n2 - this.mScrollY);
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        public boolean isLayoutRtl;
        public int scrollPosition;

        /*
         * Enabled aggressive block sorting
         */
        public SavedState(Parcel parcel) {
            super(parcel);
            this.scrollPosition = parcel.readInt();
            boolean bl = parcel.readInt() == 0;
            this.isLayoutRtl = bl;
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "HorizontalScrollView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " scrollPosition=" + this.scrollPosition + " isLayoutRtl=" + this.isLayoutRtl + "}";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.scrollPosition);
            int n2 = this.isLayoutRtl ? 1 : 0;
            parcel.writeInt(n2);
        }
    }
}

