/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.CursorFilter;
import android.widget.Filter;
import android.widget.FilterQueryProvider;
import android.widget.Filterable;

public abstract class CursorTreeAdapter
extends BaseExpandableListAdapter
implements Filterable,
CursorFilter.CursorFilterClient {
    private boolean mAutoRequery;
    SparseArray<MyCursorHelper> mChildrenCursorHelpers;
    private Context mContext;
    CursorFilter mCursorFilter;
    FilterQueryProvider mFilterQueryProvider;
    MyCursorHelper mGroupCursorHelper;
    private Handler mHandler;

    public CursorTreeAdapter(Cursor cursor, Context context) {
        this.init(cursor, context, true);
    }

    public CursorTreeAdapter(Cursor cursor, Context context, boolean bl) {
        this.init(cursor, context, bl);
    }

    private void init(Cursor cursor, Context context, boolean bl) {
        this.mContext = context;
        this.mHandler = new Handler();
        this.mAutoRequery = bl;
        this.mGroupCursorHelper = new MyCursorHelper(cursor);
        this.mChildrenCursorHelpers = new SparseArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseCursorHelpers() {
        synchronized (this) {
            int n = -1 + this.mChildrenCursorHelpers.size();
            while (true) {
                if (n < 0) {
                    this.mChildrenCursorHelpers.clear();
                    return;
                }
                this.mChildrenCursorHelpers.valueAt(n).deactivate();
                --n;
            }
        }
    }

    protected abstract void bindChildView(View var1, Context var2, Cursor var3, boolean var4);

    protected abstract void bindGroupView(View var1, Context var2, Cursor var3, boolean var4);

    @Override
    public void changeCursor(Cursor cursor) {
        this.mGroupCursorHelper.changeCursor(cursor, true);
    }

    @Override
    public String convertToString(Cursor cursor) {
        if (cursor == null) {
            return "";
        }
        return cursor.toString();
    }

    void deactivateChildrenCursorHelper(int n) {
        synchronized (this) {
            MyCursorHelper myCursorHelper = this.getChildrenCursorHelper(n, true);
            this.mChildrenCursorHelpers.remove(n);
            myCursorHelper.deactivate();
            return;
        }
    }

    @Override
    public Cursor getChild(int n, int n2) {
        return this.getChildrenCursorHelper(n, true).moveTo(n2);
    }

    @Override
    public long getChildId(int n, int n2) {
        return this.getChildrenCursorHelper(n, true).getId(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getChildView(int n, int n2, boolean bl, View view, ViewGroup viewGroup) {
        Cursor cursor = this.getChildrenCursorHelper(n, true).moveTo(n2);
        if (cursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        View view2 = view == null ? this.newChildView(this.mContext, cursor, bl, viewGroup) : view;
        this.bindChildView(view2, this.mContext, cursor, bl);
        return view2;
    }

    @Override
    public int getChildrenCount(int n) {
        MyCursorHelper myCursorHelper = this.getChildrenCursorHelper(n, true);
        if (this.mGroupCursorHelper.isValid() && myCursorHelper != null) {
            return myCursorHelper.getCount();
        }
        return 0;
    }

    protected abstract Cursor getChildrenCursor(Cursor var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MyCursorHelper getChildrenCursorHelper(int n, boolean bl) {
        synchronized (this) {
            MyCursorHelper myCursorHelper;
            block5: {
                myCursorHelper = this.mChildrenCursorHelpers.get(n);
                if (myCursorHelper != null) return myCursorHelper;
                Cursor cursor = this.mGroupCursorHelper.moveTo(n);
                if (cursor != null) break block5;
                return null;
            }
            myCursorHelper = new MyCursorHelper(this.getChildrenCursor(this.mGroupCursorHelper.getCursor()));
            this.mChildrenCursorHelpers.put(n, myCursorHelper);
            return myCursorHelper;
        }
    }

    @Override
    public Cursor getCursor() {
        return this.mGroupCursorHelper.getCursor();
    }

    @Override
    public Filter getFilter() {
        if (this.mCursorFilter == null) {
            this.mCursorFilter = new CursorFilter(this);
        }
        return this.mCursorFilter;
    }

    public FilterQueryProvider getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    @Override
    public Cursor getGroup(int n) {
        return this.mGroupCursorHelper.moveTo(n);
    }

    @Override
    public int getGroupCount() {
        return this.mGroupCursorHelper.getCount();
    }

    @Override
    public long getGroupId(int n) {
        return this.mGroupCursorHelper.getId(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getGroupView(int n, boolean bl, View view, ViewGroup viewGroup) {
        Cursor cursor = this.mGroupCursorHelper.moveTo(n);
        if (cursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        View view2 = view == null ? this.newGroupView(this.mContext, cursor, bl, viewGroup) : view;
        this.bindGroupView(view2, this.mContext, cursor, bl);
        return view2;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public boolean isChildSelectable(int n, int n2) {
        return true;
    }

    protected abstract View newChildView(Context var1, Cursor var2, boolean var3, ViewGroup var4);

    protected abstract View newGroupView(Context var1, Cursor var2, boolean var3, ViewGroup var4);

    @Override
    public void notifyDataSetChanged() {
        this.notifyDataSetChanged(true);
    }

    public void notifyDataSetChanged(boolean bl) {
        if (bl) {
            this.releaseCursorHelpers();
        }
        super.notifyDataSetChanged();
    }

    @Override
    public void notifyDataSetInvalidated() {
        this.releaseCursorHelpers();
        super.notifyDataSetInvalidated();
    }

    @Override
    public void onGroupCollapsed(int n) {
        this.deactivateChildrenCursorHelper(n);
    }

    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        if (this.mFilterQueryProvider != null) {
            return this.mFilterQueryProvider.runQuery(charSequence);
        }
        return this.mGroupCursorHelper.getCursor();
    }

    public void setChildrenCursor(int n, Cursor cursor) {
        this.getChildrenCursorHelper(n, false).changeCursor(cursor, false);
    }

    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    public void setGroupCursor(Cursor cursor) {
        this.mGroupCursorHelper.changeCursor(cursor, false);
    }

    class MyCursorHelper {
        private MyContentObserver mContentObserver;
        private Cursor mCursor;
        private MyDataSetObserver mDataSetObserver;
        private boolean mDataValid;
        private int mRowIDColumn;

        /*
         * Enabled aggressive block sorting
         */
        MyCursorHelper(Cursor cursor) {
            boolean bl = cursor != null;
            this.mCursor = cursor;
            this.mDataValid = bl;
            int n = bl ? cursor.getColumnIndex("_id") : -1;
            this.mRowIDColumn = n;
            this.mContentObserver = new MyContentObserver();
            this.mDataSetObserver = new MyDataSetObserver();
            if (bl) {
                cursor.registerContentObserver(this.mContentObserver);
                cursor.registerDataSetObserver(this.mDataSetObserver);
            }
        }

        static /* synthetic */ boolean access$402(MyCursorHelper myCursorHelper, boolean bl) {
            myCursorHelper.mDataValid = bl;
            return bl;
        }

        void changeCursor(Cursor cursor, boolean bl) {
            if (cursor == this.mCursor) {
                return;
            }
            this.deactivate();
            this.mCursor = cursor;
            if (cursor != null) {
                cursor.registerContentObserver(this.mContentObserver);
                cursor.registerDataSetObserver(this.mDataSetObserver);
                this.mRowIDColumn = cursor.getColumnIndex("_id");
                this.mDataValid = true;
                CursorTreeAdapter.this.notifyDataSetChanged(bl);
                return;
            }
            this.mRowIDColumn = -1;
            this.mDataValid = false;
            CursorTreeAdapter.this.notifyDataSetInvalidated();
        }

        void deactivate() {
            if (this.mCursor == null) {
                return;
            }
            this.mCursor.unregisterContentObserver(this.mContentObserver);
            this.mCursor.unregisterDataSetObserver(this.mDataSetObserver);
            this.mCursor.close();
            this.mCursor = null;
        }

        int getCount() {
            if (this.mDataValid && this.mCursor != null) {
                return this.mCursor.getCount();
            }
            return 0;
        }

        Cursor getCursor() {
            return this.mCursor;
        }

        long getId(int n) {
            long l = 0L;
            if (this.mDataValid && this.mCursor != null && this.mCursor.moveToPosition(n)) {
                l = this.mCursor.getLong(this.mRowIDColumn);
            }
            return l;
        }

        boolean isValid() {
            return this.mDataValid && this.mCursor != null;
        }

        Cursor moveTo(int n) {
            if (this.mDataValid && this.mCursor != null && this.mCursor.moveToPosition(n)) {
                return this.mCursor;
            }
            return null;
        }

        private class MyContentObserver
        extends ContentObserver {
            public MyContentObserver() {
                super(CursorTreeAdapter.this.mHandler);
            }

            @Override
            public boolean deliverSelfNotifications() {
                return true;
            }

            @Override
            public void onChange(boolean bl) {
                if (CursorTreeAdapter.this.mAutoRequery && MyCursorHelper.this.mCursor != null && !MyCursorHelper.this.mCursor.isClosed()) {
                    MyCursorHelper.access$402(MyCursorHelper.this, MyCursorHelper.this.mCursor.requery());
                }
            }
        }

        private class MyDataSetObserver
        extends DataSetObserver {
            private MyDataSetObserver() {
            }

            @Override
            public void onChanged() {
                MyCursorHelper.access$402(MyCursorHelper.this, true);
                CursorTreeAdapter.this.notifyDataSetChanged();
            }

            @Override
            public void onInvalidated() {
                MyCursorHelper.access$402(MyCursorHelper.this, false);
                CursorTreeAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

