/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;

@RemoteViews.RemoteView
public class Chronometer
extends TextView {
    private static final String TAG = "Chronometer";
    private static final int TICK_WHAT = 2;
    private long mBase;
    private String mFormat;
    private StringBuilder mFormatBuilder;
    private Formatter mFormatter;
    private Object[] mFormatterArgs = new Object[1];
    private Locale mFormatterLocale;
    private Handler mHandler;
    private boolean mLogged;
    private OnChronometerTickListener mOnChronometerTickListener;
    private StringBuilder mRecycle = new StringBuilder(8);
    private boolean mRunning;
    private boolean mStarted;
    private boolean mVisible;

    public Chronometer(Context context) {
        this(context, null, 0);
    }

    public Chronometer(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public Chronometer(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public Chronometer(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mHandler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                if (Chronometer.this.mRunning) {
                    Chronometer.this.updateText(SystemClock.elapsedRealtime());
                    Chronometer.this.dispatchChronometerTick();
                    this.sendMessageDelayed(Message.obtain((Handler)this, 2), 1000L);
                }
            }
        };
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Chronometer, n, n2);
        this.setFormat(typedArray.getString(0));
        typedArray.recycle();
        this.init();
    }

    private void init() {
        this.mBase = SystemClock.elapsedRealtime();
        this.updateText(this.mBase);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateRunning() {
        boolean bl = this.mVisible && this.mStarted;
        if (bl != this.mRunning) {
            if (bl) {
                this.updateText(SystemClock.elapsedRealtime());
                this.dispatchChronometerTick();
                this.mHandler.sendMessageDelayed(Message.obtain(this.mHandler, 2), 1000L);
            } else {
                this.mHandler.removeMessages(2);
            }
            this.mRunning = bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateText(long l) {
        synchronized (this) {
            String string2;
            block6: {
                long l2 = (l - this.mBase) / 1000L;
                string2 = DateUtils.formatElapsedTime(this.mRecycle, l2);
                if (this.mFormat != null) {
                    Locale locale = Locale.getDefault();
                    if (this.mFormatter == null || !locale.equals(this.mFormatterLocale)) {
                        this.mFormatterLocale = locale;
                        this.mFormatter = new Formatter(this.mFormatBuilder, locale);
                    }
                    this.mFormatBuilder.setLength(0);
                    this.mFormatterArgs[0] = string2;
                    try {
                        String string3;
                        this.mFormatter.format(this.mFormat, this.mFormatterArgs);
                        string2 = string3 = this.mFormatBuilder.toString();
                    }
                    catch (IllegalFormatException illegalFormatException) {
                        if (this.mLogged) break block6;
                        Log.w(TAG, "Illegal format string: " + this.mFormat);
                        this.mLogged = true;
                    }
                }
            }
            this.setText(string2);
            return;
        }
    }

    void dispatchChronometerTick() {
        if (this.mOnChronometerTickListener != null) {
            this.mOnChronometerTickListener.onChronometerTick(this);
        }
    }

    public long getBase() {
        return this.mBase;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public OnChronometerTickListener getOnChronometerTickListener() {
        return this.mOnChronometerTickListener;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.updateRunning();
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(Chronometer.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(Chronometer.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        boolean bl = n == 0;
        this.mVisible = bl;
        this.updateRunning();
    }

    @RemotableViewMethod
    public void setBase(long l) {
        this.mBase = l;
        this.dispatchChronometerTick();
        this.updateText(SystemClock.elapsedRealtime());
    }

    @RemotableViewMethod
    public void setFormat(String string2) {
        this.mFormat = string2;
        if (string2 != null && this.mFormatBuilder == null) {
            this.mFormatBuilder = new StringBuilder(2 * string2.length());
        }
    }

    public void setOnChronometerTickListener(OnChronometerTickListener onChronometerTickListener) {
        this.mOnChronometerTickListener = onChronometerTickListener;
    }

    @RemotableViewMethod
    public void setStarted(boolean bl) {
        this.mStarted = bl;
        this.updateRunning();
    }

    public void start() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void stop() {
        this.mStarted = false;
        this.updateRunning();
    }

    public static interface OnChronometerTickListener {
        public void onChronometerTick(Chronometer var1);
    }
}

