/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Selection;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;
import java.lang.ref.WeakReference;

public class AutoCompleteTextView
extends EditText
implements Filter.FilterListener {
    static final boolean DEBUG = false;
    static final int EXPAND_MAX = 3;
    static final String TAG = "AutoCompleteTextView";
    private ListAdapter mAdapter;
    private boolean mBlockCompletion;
    private int mDropDownAnchorId;
    private boolean mDropDownDismissedOnCompletion = true;
    private Filter mFilter;
    private int mHintResource;
    private CharSequence mHintText;
    private TextView mHintView;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    private int mLastKeyCode = 0;
    private PopupDataSetObserver mObserver;
    private boolean mOpenBefore;
    private PassThroughClickListener mPassThroughClickListener;
    private ListPopupWindow mPopup;
    private boolean mPopupCanBeUpdated = true;
    private int mThreshold;
    private Validator mValidator = null;

    public AutoCompleteTextView(Context context) {
        this(context, null);
    }

    public AutoCompleteTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842859);
    }

    public AutoCompleteTextView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public AutoCompleteTextView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mPopup = new ListPopupWindow(context, attributeSet, n, n2);
        this.mPopup.setSoftInputMode(16);
        this.mPopup.setPromptPosition(1);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.AutoCompleteTextView, n, n2);
        this.mThreshold = typedArray.getInt(2, 2);
        this.mPopup.setListSelector(typedArray.getDrawable(3));
        this.mDropDownAnchorId = typedArray.getResourceId(6, -1);
        this.mPopup.setWidth(typedArray.getLayoutDimension(5, -2));
        this.mPopup.setHeight(typedArray.getLayoutDimension(7, -2));
        this.mHintResource = typedArray.getResourceId(1, 17367269);
        this.mPopup.setOnItemClickListener(new DropDownItemClickListener());
        this.setCompletionHint(typedArray.getText(0));
        int n3 = this.getInputType();
        if ((n3 & 0xF) == 1) {
            this.setRawInputType(n3 | 0x10000);
        }
        typedArray.recycle();
        this.setFocusable(true);
        this.addTextChangedListener(new MyWatcher());
        this.mPassThroughClickListener = new PassThroughClickListener();
        super.setOnClickListener(this.mPassThroughClickListener);
    }

    private void buildImeCompletions() {
        InputMethodManager inputMethodManager;
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter != null && (inputMethodManager = InputMethodManager.peekInstance()) != null) {
            int n = Math.min(listAdapter.getCount(), 20);
            CompletionInfo[] completionInfoArray = new CompletionInfo[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!listAdapter.isEnabled(i)) continue;
                Object object = listAdapter.getItem(i);
                completionInfoArray[n2] = new CompletionInfo(listAdapter.getItemId(i), n2, this.convertSelectionToString(object));
                ++n2;
            }
            if (n2 != n) {
                CompletionInfo[] completionInfoArray2 = new CompletionInfo[n2];
                System.arraycopy(completionInfoArray, 0, completionInfoArray2, 0, n2);
                completionInfoArray = completionInfoArray2;
            }
            inputMethodManager.displayCompletions(this, completionInfoArray);
        }
    }

    private void onClickImpl() {
        if (this.isPopupShowing()) {
            this.ensureImeVisible(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void performCompletion(View view, int n, long l) {
        if (this.isPopupShowing()) {
            Object object = n < 0 ? this.mPopup.getSelectedItem() : this.mAdapter.getItem(n);
            if (object == null) {
                Log.w(TAG, "performCompletion: no selected item");
                return;
            }
            this.mBlockCompletion = true;
            this.replaceText(this.convertSelectionToString(object));
            this.mBlockCompletion = false;
            if (this.mItemClickListener != null) {
                ListPopupWindow listPopupWindow = this.mPopup;
                if (view == null || n < 0) {
                    view = listPopupWindow.getSelectedView();
                    n = listPopupWindow.getSelectedItemPosition();
                    l = listPopupWindow.getSelectedItemId();
                }
                this.mItemClickListener.onItemClick(listPopupWindow.getListView(), view, n, l);
            }
        }
        if (!this.mDropDownDismissedOnCompletion) return;
        if (this.mPopup.isDropDownAlwaysVisible()) return;
        this.dismissDropDown();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateDropDownForFilter(int n) {
        if (this.getWindowVisibility() == 8) return;
        boolean bl = this.mPopup.isDropDownAlwaysVisible();
        boolean bl2 = this.enoughToFilter();
        if ((n > 0 || bl) && bl2) {
            if (!this.hasFocus() || !this.hasWindowFocus() || !this.mPopupCanBeUpdated) return;
            this.showDropDown();
            return;
        }
        if (bl || !this.isPopupShowing()) {
            return;
        }
        this.dismissDropDown();
        this.mPopupCanBeUpdated = true;
    }

    public void clearListSelection() {
        this.mPopup.clearListSelection();
    }

    protected CharSequence convertSelectionToString(Object object) {
        return this.mFilter.convertResultToString(object);
    }

    public void dismissDropDown() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null) {
            inputMethodManager.displayCompletions(this, null);
        }
        this.mPopup.dismiss();
        this.mPopupCanBeUpdated = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void doAfterTextChanged() {
        if (this.mBlockCompletion || this.mOpenBefore && !this.isPopupShowing()) return;
        if (this.enoughToFilter()) {
            if (this.mFilter == null) return;
            this.mPopupCanBeUpdated = true;
            this.performFiltering(this.getText(), this.mLastKeyCode);
            return;
        }
        if (!this.mPopup.isDropDownAlwaysVisible()) {
            this.dismissDropDown();
        }
        if (this.mFilter == null) {
            return;
        }
        this.mFilter.filter(null);
    }

    void doBeforeTextChanged() {
        if (this.mBlockCompletion) {
            return;
        }
        this.mOpenBefore = this.isPopupShowing();
    }

    public boolean enoughToFilter() {
        return this.getText().length() >= this.mThreshold;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void ensureImeVisible(boolean bl) {
        ListPopupWindow listPopupWindow = this.mPopup;
        int n = bl ? 1 : 2;
        listPopupWindow.setInputMethodMode(n);
        if (this.mPopup.isDropDownAlwaysVisible() || this.mFilter != null && this.enoughToFilter()) {
            this.showDropDown();
        }
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public CharSequence getCompletionHint() {
        return this.mHintText;
    }

    public int getDropDownAnchor() {
        return this.mDropDownAnchorId;
    }

    public int getDropDownAnimationStyle() {
        return this.mPopup.getAnimationStyle();
    }

    public Drawable getDropDownBackground() {
        return this.mPopup.getBackground();
    }

    public int getDropDownHeight() {
        return this.mPopup.getHeight();
    }

    public int getDropDownHorizontalOffset() {
        return this.mPopup.getHorizontalOffset();
    }

    public ListView getDropDownListView() {
        return this.mPopup.getListView();
    }

    public int getDropDownVerticalOffset() {
        return this.mPopup.getVerticalOffset();
    }

    public int getDropDownWidth() {
        return this.mPopup.getWidth();
    }

    protected Filter getFilter() {
        return this.mFilter;
    }

    @Deprecated
    public AdapterView.OnItemClickListener getItemClickListener() {
        return this.mItemClickListener;
    }

    @Deprecated
    public AdapterView.OnItemSelectedListener getItemSelectedListener() {
        return this.mItemSelectedListener;
    }

    public int getListSelection() {
        return this.mPopup.getSelectedItemPosition();
    }

    public AdapterView.OnItemClickListener getOnItemClickListener() {
        return this.mItemClickListener;
    }

    public AdapterView.OnItemSelectedListener getOnItemSelectedListener() {
        return this.mItemSelectedListener;
    }

    public int getThreshold() {
        return this.mThreshold;
    }

    public Validator getValidator() {
        return this.mValidator;
    }

    public boolean isDropDownAlwaysVisible() {
        return this.mPopup.isDropDownAlwaysVisible();
    }

    public boolean isDropDownDismissedOnCompletion() {
        return this.mDropDownDismissedOnCompletion;
    }

    public boolean isInputMethodNotNeeded() {
        return this.mPopup.getInputMethodMode() == 2;
    }

    public boolean isPerformingCompletion() {
        return this.mBlockCompletion;
    }

    public boolean isPopupShowing() {
        return this.mPopup.isShowing();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    @Override
    public void onCommitCompletion(CompletionInfo completionInfo) {
        if (this.isPopupShowing()) {
            this.mPopup.performItemClick(completionInfo.getPosition());
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        this.dismissDropDown();
        super.onDetachedFromWindow();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDisplayHint(int n) {
        super.onDisplayHint(n);
        switch (n) {
            default: {
                return;
            }
            case 4: {
                if (this.mPopup.isDropDownAlwaysVisible()) return;
                this.dismissDropDown();
                return;
            }
        }
    }

    @Override
    public void onFilterComplete(int n) {
        this.updateDropDownForFilter(n);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (!bl) {
            this.performValidation();
        }
        if (!bl && !this.mPopup.isDropDownAlwaysVisible()) {
            this.dismissDropDown();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        boolean bl;
        block8: {
            block7: {
                bl = true;
                if (this.mPopup.onKeyDown(n, keyEvent)) break block7;
                if (!this.isPopupShowing()) {
                    switch (n) {
                        default: {
                            break;
                        }
                        case 20: {
                            if (!keyEvent.hasNoModifiers()) break;
                            this.performValidation();
                        }
                    }
                }
                if (this.isPopupShowing() && n == 61 && keyEvent.hasNoModifiers()) break block7;
                this.mLastKeyCode = n;
                bl = super.onKeyDown(n, keyEvent);
                this.mLastKeyCode = 0;
                if (bl && this.isPopupShowing()) break block8;
            }
            return bl;
        }
        this.clearListSelection();
        return bl;
    }

    @Override
    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        if (n == 4 && this.isPopupShowing() && !this.mPopup.isDropDownAlwaysVisible()) {
            if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
                if (dispatcherState != null) {
                    dispatcherState.startTracking(keyEvent, this);
                }
                return true;
            }
            if (keyEvent.getAction() == 1) {
                KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
                if (dispatcherState != null) {
                    dispatcherState.handleUpEvent(keyEvent);
                }
                if (keyEvent.isTracking() && !keyEvent.isCanceled()) {
                    this.dismissDropDown();
                    return true;
                }
            }
        }
        return super.onKeyPreIme(n, keyEvent);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onKeyUp(int var1_1, KeyEvent var2_2) {
        if (!this.mPopup.onKeyUp(var1_1, var2_2)) ** GOTO lbl-1000
        switch (var1_1) {
            default: lbl-1000:
            // 2 sources

            {
                if (!this.isPopupShowing() || var1_1 != 61 || !var2_2.hasNoModifiers()) break;
                this.performCompletion();
                return true;
            }
            case 23: 
            case 61: 
            case 66: {
                if (!var2_2.hasNoModifiers()) ** continue;
                this.performCompletion();
                return true;
            }
        }
        return super.onKeyUp(var1_1, var2_2);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (!bl && !this.mPopup.isDropDownAlwaysVisible()) {
            this.dismissDropDown();
        }
    }

    public void performCompletion() {
        this.performCompletion(null, -1, -1L);
    }

    protected void performFiltering(CharSequence charSequence, int n) {
        this.mFilter.filter(charSequence, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void performValidation() {
        Editable editable;
        if (this.mValidator == null || TextUtils.isEmpty(editable = this.getText()) || this.mValidator.isValid(editable)) {
            return;
        }
        this.setText(this.mValidator.fixText(editable));
    }

    protected void replaceText(CharSequence charSequence) {
        this.clearComposingText();
        this.setText(charSequence);
        Editable editable = this.getText();
        Selection.setSelection(editable, editable.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T extends ListAdapter & Filterable> void setAdapter(T t) {
        if (this.mObserver == null) {
            this.mObserver = new PopupDataSetObserver(this);
        } else if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
        }
        this.mAdapter = t;
        if (this.mAdapter != null) {
            this.mFilter = ((Filterable)((Object)this.mAdapter)).getFilter();
            t.registerDataSetObserver(this.mObserver);
        } else {
            this.mFilter = null;
        }
        this.mPopup.setAdapter(this.mAdapter);
    }

    public void setCompletionHint(CharSequence charSequence) {
        this.mHintText = charSequence;
        if (charSequence != null) {
            if (this.mHintView == null) {
                TextView textView = (TextView)LayoutInflater.from(this.getContext()).inflate(this.mHintResource, null).findViewById(16908308);
                textView.setText(this.mHintText);
                this.mHintView = textView;
                this.mPopup.setPromptView(textView);
                return;
            }
            this.mHintView.setText(charSequence);
            return;
        }
        this.mPopup.setPromptView(null);
        this.mHintView = null;
    }

    public void setDropDownAlwaysVisible(boolean bl) {
        this.mPopup.setDropDownAlwaysVisible(bl);
    }

    public void setDropDownAnchor(int n) {
        this.mDropDownAnchorId = n;
        this.mPopup.setAnchorView(null);
    }

    public void setDropDownAnimationStyle(int n) {
        this.mPopup.setAnimationStyle(n);
    }

    public void setDropDownBackgroundDrawable(Drawable drawable2) {
        this.mPopup.setBackgroundDrawable(drawable2);
    }

    public void setDropDownBackgroundResource(int n) {
        this.mPopup.setBackgroundDrawable(this.getContext().getDrawable(n));
    }

    public void setDropDownDismissedOnCompletion(boolean bl) {
        this.mDropDownDismissedOnCompletion = bl;
    }

    public void setDropDownHeight(int n) {
        this.mPopup.setHeight(n);
    }

    public void setDropDownHorizontalOffset(int n) {
        this.mPopup.setHorizontalOffset(n);
    }

    public void setDropDownVerticalOffset(int n) {
        this.mPopup.setVerticalOffset(n);
    }

    public void setDropDownWidth(int n) {
        this.mPopup.setWidth(n);
    }

    public void setForceIgnoreOutsideTouch(boolean bl) {
        this.mPopup.setForceIgnoreOutsideTouch(bl);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        boolean bl = super.setFrame(n, n2, n3, n4);
        if (this.isPopupShowing()) {
            this.showDropDown();
        }
        return bl;
    }

    public void setListSelection(int n) {
        this.mPopup.setSelection(n);
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        PassThroughClickListener.access$302(this.mPassThroughClickListener, onClickListener);
    }

    public void setOnDismissListener(final OnDismissListener onDismissListener) {
        PopupWindow.OnDismissListener onDismissListener2 = null;
        if (onDismissListener != null) {
            onDismissListener2 = new PopupWindow.OnDismissListener(){

                @Override
                public void onDismiss() {
                    onDismissListener.onDismiss();
                }
            };
        }
        this.mPopup.setOnDismissListener(onDismissListener2);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.mItemClickListener = onItemClickListener;
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        this.mItemSelectedListener = onItemSelectedListener;
    }

    public void setText(CharSequence charSequence, boolean bl) {
        if (bl) {
            this.setText(charSequence);
            return;
        }
        this.mBlockCompletion = true;
        this.setText(charSequence);
        this.mBlockCompletion = false;
    }

    public void setThreshold(int n) {
        if (n <= 0) {
            n = 1;
        }
        this.mThreshold = n;
    }

    public void setValidator(Validator validator) {
        this.mValidator = validator;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showDropDown() {
        this.buildImeCompletions();
        if (this.mPopup.getAnchorView() == null) {
            if (this.mDropDownAnchorId != -1) {
                this.mPopup.setAnchorView(this.getRootView().findViewById(this.mDropDownAnchorId));
            } else {
                this.mPopup.setAnchorView(this);
            }
        }
        if (!this.isPopupShowing()) {
            this.mPopup.setInputMethodMode(1);
            this.mPopup.setListItemExpandMax(3);
        }
        this.mPopup.show();
        this.mPopup.getListView().setOverScrollMode(0);
    }

    public void showDropDownAfterLayout() {
        this.mPopup.postShow();
    }

    private class DropDownItemClickListener
    implements AdapterView.OnItemClickListener {
        private DropDownItemClickListener() {
        }

        public void onItemClick(AdapterView adapterView, View view, int n, long l) {
            AutoCompleteTextView.this.performCompletion(view, n, l);
        }
    }

    private class MyWatcher
    implements TextWatcher {
        private MyWatcher() {
        }

        @Override
        public void afterTextChanged(Editable editable) {
            AutoCompleteTextView.this.doAfterTextChanged();
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            AutoCompleteTextView.this.doBeforeTextChanged();
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    private class PassThroughClickListener
    implements View.OnClickListener {
        private View.OnClickListener mWrapped;

        private PassThroughClickListener() {
        }

        static /* synthetic */ View.OnClickListener access$302(PassThroughClickListener passThroughClickListener, View.OnClickListener onClickListener) {
            passThroughClickListener.mWrapped = onClickListener;
            return onClickListener;
        }

        @Override
        public void onClick(View view) {
            AutoCompleteTextView.this.onClickImpl();
            if (this.mWrapped != null) {
                this.mWrapped.onClick(view);
            }
        }
    }

    private static class PopupDataSetObserver
    extends DataSetObserver {
        private final WeakReference<AutoCompleteTextView> mViewReference;
        private final Runnable updateRunnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                ListAdapter listAdapter;
                AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)PopupDataSetObserver.this.mViewReference.get();
                if (autoCompleteTextView == null || (listAdapter = autoCompleteTextView.mAdapter) == null) {
                    return;
                }
                autoCompleteTextView.updateDropDownForFilter(listAdapter.getCount());
            }
        };

        private PopupDataSetObserver(AutoCompleteTextView autoCompleteTextView) {
            this.mViewReference = new WeakReference<AutoCompleteTextView>(autoCompleteTextView);
        }

        @Override
        public void onChanged() {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView)this.mViewReference.get();
            if (autoCompleteTextView != null && autoCompleteTextView.mAdapter != null) {
                autoCompleteTextView.post(this.updateRunnable);
            }
        }
    }

    public static interface Validator {
        public CharSequence fixText(CharSequence var1);

        public boolean isValid(CharSequence var1);
    }
}

