/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Process;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.TimeZone;

@RemoteViews.RemoteView
public class AnalogClock
extends View {
    private boolean mAttached;
    private Time mCalendar;
    private boolean mChanged;
    private Drawable mDial;
    private int mDialHeight;
    private int mDialWidth;
    private final Handler mHandler = new Handler();
    private float mHour;
    private Drawable mHourHand;
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED")) {
                String string2 = intent.getStringExtra("time-zone");
                AnalogClock.access$002(AnalogClock.this, new Time(TimeZone.getTimeZone(string2).getID()));
            }
            AnalogClock.this.onTimeChanged();
            AnalogClock.this.invalidate();
        }
    };
    private Drawable mMinuteHand;
    private float mMinutes;

    public AnalogClock(Context context) {
        this(context, null);
    }

    public AnalogClock(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public AnalogClock(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public AnalogClock(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        context.getResources();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.AnalogClock, n, n2);
        this.mDial = typedArray.getDrawable(0);
        if (this.mDial == null) {
            this.mDial = context.getDrawable(17302370);
        }
        this.mHourHand = typedArray.getDrawable(1);
        if (this.mHourHand == null) {
            this.mHourHand = context.getDrawable(17302371);
        }
        this.mMinuteHand = typedArray.getDrawable(2);
        if (this.mMinuteHand == null) {
            this.mMinuteHand = context.getDrawable(17302372);
        }
        this.mCalendar = new Time();
        this.mDialWidth = this.mDial.getIntrinsicWidth();
        this.mDialHeight = this.mDial.getIntrinsicHeight();
    }

    static /* synthetic */ Time access$002(AnalogClock analogClock, Time time) {
        analogClock.mCalendar = time;
        return time;
    }

    private void onTimeChanged() {
        this.mCalendar.setToNow();
        int n = this.mCalendar.hour;
        int n2 = this.mCalendar.minute;
        int n3 = this.mCalendar.second;
        this.mMinutes = (float)n2 + (float)n3 / 60.0f;
        this.mHour = (float)n + this.mMinutes / 60.0f;
        this.mChanged = true;
        this.updateContentDescription(this.mCalendar);
    }

    private void updateContentDescription(Time time) {
        this.setContentDescription(DateUtils.formatDateTime(this.mContext, time.toMillis(false), 129));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mAttached) {
            this.mAttached = true;
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.TIME_TICK");
            intentFilter.addAction("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.getContext().registerReceiverAsUser(this.mIntentReceiver, Process.myUserHandle(), intentFilter, null, this.mHandler);
        }
        this.mCalendar = new Time();
        this.onTimeChanged();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAttached) {
            this.getContext().unregisterReceiver(this.mIntentReceiver);
            this.mAttached = false;
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        boolean bl;
        int n;
        int n2;
        Drawable drawable2;
        int n3;
        int n4;
        boolean bl2;
        block9: {
            int n5;
            int n6;
            block8: {
                super.onDraw(canvas);
                bl2 = this.mChanged;
                if (bl2) {
                    this.mChanged = false;
                }
                n6 = this.mRight - this.mLeft;
                n5 = this.mBottom - this.mTop;
                n4 = n6 / 2;
                n3 = n5 / 2;
                drawable2 = this.mDial;
                n2 = drawable2.getIntrinsicWidth();
                n = drawable2.getIntrinsicHeight();
                if (n6 < n2) break block8;
                bl = false;
                if (n5 >= n) break block9;
            }
            bl = true;
            float f = Math.min((float)n6 / (float)n2, (float)n5 / (float)n);
            canvas.save();
            canvas.scale(f, f, n4, n3);
        }
        if (bl2) {
            drawable2.setBounds(n4 - n2 / 2, n3 - n / 2, n4 + n2 / 2, n3 + n / 2);
        }
        drawable2.draw(canvas);
        canvas.save();
        canvas.rotate(360.0f * (this.mHour / 12.0f), n4, n3);
        Drawable drawable3 = this.mHourHand;
        if (bl2) {
            int n7 = drawable3.getIntrinsicWidth();
            int n8 = drawable3.getIntrinsicHeight();
            drawable3.setBounds(n4 - n7 / 2, n3 - n8 / 2, n4 + n7 / 2, n3 + n8 / 2);
        }
        drawable3.draw(canvas);
        canvas.restore();
        canvas.save();
        canvas.rotate(360.0f * (this.mMinutes / 60.0f), n4, n3);
        Drawable drawable4 = this.mMinuteHand;
        if (bl2) {
            int n9 = drawable4.getIntrinsicWidth();
            int n10 = drawable4.getIntrinsicHeight();
            drawable4.setBounds(n4 - n9 / 2, n3 - n10 / 2, n4 + n9 / 2, n3 + n10 / 2);
        }
        drawable4.draw(canvas);
        canvas.restore();
        if (bl) {
            canvas.restore();
        }
    }

    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode(n);
        int n4 = View.MeasureSpec.getSize(n);
        int n5 = View.MeasureSpec.getMode(n2);
        int n6 = View.MeasureSpec.getSize(n2);
        float f = 1.0f;
        float f2 = 1.0f;
        if (n3 != 0 && n4 < this.mDialWidth) {
            f = (float)n4 / (float)this.mDialWidth;
        }
        if (n5 != 0 && n6 < this.mDialHeight) {
            f2 = (float)n6 / (float)this.mDialHeight;
        }
        float f3 = Math.min(f, f2);
        this.setMeasuredDimension(AnalogClock.resolveSizeAndState((int)(f3 * (float)this.mDialWidth), n, 0), AnalogClock.resolveSizeAndState((int)(f3 * (float)this.mDialHeight), n2, 0));
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mChanged = true;
    }
}

