/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import java.io.InputStream;
import java.util.Map;

public class WebResourceResponse {
    private String mEncoding;
    private InputStream mInputStream;
    private String mMimeType;
    private String mReasonPhrase;
    private Map<String, String> mResponseHeaders;
    private int mStatusCode;

    public WebResourceResponse(String string2, String string3, int n, String string4, Map<String, String> map, InputStream inputStream) {
        this(string2, string3, inputStream);
        this.setStatusCodeAndReasonPhrase(n, string4);
        this.setResponseHeaders(map);
    }

    public WebResourceResponse(String string2, String string3, InputStream inputStream) {
        this.mMimeType = string2;
        this.mEncoding = string3;
        this.mInputStream = inputStream;
    }

    public InputStream getData() {
        return this.mInputStream;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public String getReasonPhrase() {
        return this.mReasonPhrase;
    }

    public Map<String, String> getResponseHeaders() {
        return this.mResponseHeaders;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public void setData(InputStream inputStream) {
        this.mInputStream = inputStream;
    }

    public void setEncoding(String string2) {
        this.mEncoding = string2;
    }

    public void setMimeType(String string2) {
        this.mMimeType = string2;
    }

    public void setResponseHeaders(Map<String, String> map) {
        this.mResponseHeaders = map;
    }

    public void setStatusCodeAndReasonPhrase(int n, String string2) {
        if (n < 100) {
            throw new IllegalArgumentException("statusCode can't be less than 100.");
        }
        if (n > 599) {
            throw new IllegalArgumentException("statusCode can't be greater than 599.");
        }
        if (n > 299 && n < 400) {
            throw new IllegalArgumentException("statusCode can't be in the [300, 399] range.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("reasonPhrase can't be null.");
        }
        if (string2.trim().isEmpty()) {
            throw new IllegalArgumentException("reasonPhrase can't be empty.");
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) <= '\u007f') continue;
            throw new IllegalArgumentException("reasonPhrase can't contain non-ASCII characters.");
        }
        this.mStatusCode = n;
        this.mReasonPhrase = string2;
    }
}

