/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.JsPromptResult;
import android.webkit.URLUtil;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import java.net.MalformedURLException;
import java.net.URL;

public class JsDialogHelper {
    public static final int ALERT = 1;
    public static final int CONFIRM = 2;
    public static final int PROMPT = 3;
    private static final String TAG = "JsDialogHelper";
    public static final int UNLOAD = 4;
    private final String mDefaultValue;
    private final String mMessage;
    private final JsPromptResult mResult;
    private final int mType;
    private final String mUrl;

    public JsDialogHelper(JsPromptResult jsPromptResult, int n, String string2, String string3, String string4) {
        this.mResult = jsPromptResult;
        this.mDefaultValue = string2;
        this.mMessage = string3;
        this.mType = n;
        this.mUrl = string4;
    }

    public JsDialogHelper(JsPromptResult jsPromptResult, Message message) {
        this.mResult = jsPromptResult;
        this.mDefaultValue = message.getData().getString("default");
        this.mMessage = message.getData().getString("message");
        this.mType = message.getData().getInt("type");
        this.mUrl = message.getData().getString("url");
    }

    private static boolean canShowAlertDialog(Context context) {
        return context instanceof Activity;
    }

    private String getJsDialogTitle(Context context) {
        String string2 = this.mUrl;
        if (URLUtil.isDataUrl(this.mUrl)) {
            return context.getString(17040335);
        }
        try {
            URL uRL = new URL(this.mUrl);
            Object[] objectArray = new Object[]{uRL.getProtocol() + "://" + uRL.getHost()};
            String string3 = context.getString(17040334, objectArray);
            return string3;
        }
        catch (MalformedURLException malformedURLException) {
            return string2;
        }
    }

    public boolean invokeCallback(WebChromeClient webChromeClient, WebView webView) {
        switch (this.mType) {
            default: {
                throw new IllegalArgumentException("Unexpected type: " + this.mType);
            }
            case 1: {
                return webChromeClient.onJsAlert(webView, this.mUrl, this.mMessage, this.mResult);
            }
            case 2: {
                return webChromeClient.onJsConfirm(webView, this.mUrl, this.mMessage, this.mResult);
            }
            case 4: {
                return webChromeClient.onJsBeforeUnload(webView, this.mUrl, this.mMessage, this.mResult);
            }
            case 3: 
        }
        return webChromeClient.onJsPrompt(webView, this.mUrl, this.mMessage, this.mDefaultValue, this.mResult);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showDialog(Context context) {
        int n;
        int n2;
        String string2;
        String string3;
        if (!JsDialogHelper.canShowAlertDialog(context)) {
            Log.w(TAG, "Cannot create a dialog, the WebView context is not an Activity");
            this.mResult.cancel();
            return;
        }
        if (this.mType == 4) {
            string3 = context.getString(17040336);
            Object[] objectArray = new Object[]{this.mMessage};
            string2 = context.getString(17040339, objectArray);
            n2 = 17040337;
            n = 17040338;
        } else {
            string3 = this.getJsDialogTitle(context);
            string2 = this.mMessage;
            n2 = 17039370;
            n = 0x1040000;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(string3);
        builder.setOnCancelListener(new CancelListener());
        if (this.mType != 3) {
            builder.setMessage(string2);
            builder.setPositiveButton(n2, (DialogInterface.OnClickListener)new PositiveListener(null));
        } else {
            View view = LayoutInflater.from(context).inflate(17367162, null);
            EditText editText = (EditText)view.findViewById(16909144);
            editText.setText(this.mDefaultValue);
            builder.setPositiveButton(n2, (DialogInterface.OnClickListener)new PositiveListener(editText));
            ((TextView)view.findViewById(16908299)).setText(this.mMessage);
            builder.setView(view);
        }
        if (this.mType != 1) {
            builder.setNegativeButton(n, (DialogInterface.OnClickListener)new CancelListener());
        }
        builder.show();
    }

    private class CancelListener
    implements DialogInterface.OnCancelListener,
    DialogInterface.OnClickListener {
        private CancelListener() {
        }

        @Override
        public void onCancel(DialogInterface dialogInterface) {
            JsDialogHelper.this.mResult.cancel();
        }

        @Override
        public void onClick(DialogInterface dialogInterface, int n) {
            JsDialogHelper.this.mResult.cancel();
        }
    }

    private class PositiveListener
    implements DialogInterface.OnClickListener {
        private final EditText mEdit;

        public PositiveListener(EditText editText) {
            this.mEdit = editText;
        }

        @Override
        public void onClick(DialogInterface dialogInterface, int n) {
            if (this.mEdit == null) {
                JsDialogHelper.this.mResult.confirm();
                return;
            }
            JsDialogHelper.this.mResult.confirm(this.mEdit.getText().toString());
        }
    }
}

