/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Slog;
import android.view.inputmethod.InputMethodInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class InputMethodSubtype
implements Parcelable {
    public static final Parcelable.Creator<InputMethodSubtype> CREATOR;
    private static final String EXTRA_KEY_UNTRANSLATABLE_STRING_IN_SUBTYPE_NAME = "UntranslatableReplacementStringInSubtypeName";
    private static final String EXTRA_VALUE_KEY_VALUE_SEPARATOR = "=";
    private static final String EXTRA_VALUE_PAIR_SEPARATOR = ",";
    private static final String TAG;
    private volatile HashMap<String, String> mExtraValueHashMapCache;
    private final boolean mIsAsciiCapable;
    private final boolean mIsAuxiliary;
    private final boolean mOverridesImplicitlyEnabledSubtype;
    private final String mSubtypeExtraValue;
    private final int mSubtypeHashCode;
    private final int mSubtypeIconResId;
    private final int mSubtypeId;
    private final String mSubtypeLocale;
    private final String mSubtypeMode;
    private final int mSubtypeNameResId;

    static {
        TAG = InputMethodSubtype.class.getSimpleName();
        CREATOR = new Parcelable.Creator<InputMethodSubtype>(){

            @Override
            public InputMethodSubtype createFromParcel(Parcel parcel) {
                return new InputMethodSubtype(parcel);
            }

            public InputMethodSubtype[] newArray(int n) {
                return new InputMethodSubtype[n];
            }
        };
    }

    public InputMethodSubtype(int n, int n2, String string2, String string3, String string4, boolean bl, boolean bl2) {
        this(n, n2, string2, string3, string4, bl, bl2, 0);
    }

    public InputMethodSubtype(int n, int n2, String string2, String string3, String string4, boolean bl, boolean bl2, int n3) {
        this(InputMethodSubtype.getBuilder(n, n2, string2, string3, string4, bl, bl2, n3, false));
    }

    /*
     * Enabled aggressive block sorting
     */
    InputMethodSubtype(Parcel parcel) {
        int n = 1;
        this.mSubtypeNameResId = parcel.readInt();
        this.mSubtypeIconResId = parcel.readInt();
        String string2 = parcel.readString();
        if (string2 == null) {
            string2 = "";
        }
        this.mSubtypeLocale = string2;
        String string3 = parcel.readString();
        if (string3 == null) {
            string3 = "";
        }
        this.mSubtypeMode = string3;
        String string4 = parcel.readString();
        if (string4 == null) {
            string4 = "";
        }
        this.mSubtypeExtraValue = string4;
        int n2 = parcel.readInt() == n ? n : 0;
        this.mIsAuxiliary = n2;
        int n3 = parcel.readInt() == n ? n : 0;
        this.mOverridesImplicitlyEnabledSubtype = n3;
        this.mSubtypeHashCode = parcel.readInt();
        this.mSubtypeId = parcel.readInt();
        if (parcel.readInt() != n) {
            n = 0;
        }
        this.mIsAsciiCapable = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private InputMethodSubtype(InputMethodSubtypeBuilder inputMethodSubtypeBuilder) {
        this.mSubtypeNameResId = inputMethodSubtypeBuilder.mSubtypeNameResId;
        this.mSubtypeIconResId = inputMethodSubtypeBuilder.mSubtypeIconResId;
        this.mSubtypeLocale = inputMethodSubtypeBuilder.mSubtypeLocale;
        this.mSubtypeMode = inputMethodSubtypeBuilder.mSubtypeMode;
        this.mSubtypeExtraValue = inputMethodSubtypeBuilder.mSubtypeExtraValue;
        this.mIsAuxiliary = inputMethodSubtypeBuilder.mIsAuxiliary;
        this.mOverridesImplicitlyEnabledSubtype = inputMethodSubtypeBuilder.mOverridesImplicitlyEnabledSubtype;
        this.mSubtypeId = inputMethodSubtypeBuilder.mSubtypeId;
        this.mIsAsciiCapable = inputMethodSubtypeBuilder.mIsAsciiCapable;
        int n = this.mSubtypeId != 0 ? this.mSubtypeId : InputMethodSubtype.hashCodeInternal(this.mSubtypeLocale, this.mSubtypeMode, this.mSubtypeExtraValue, this.mIsAuxiliary, this.mOverridesImplicitlyEnabledSubtype, this.mIsAsciiCapable);
        this.mSubtypeHashCode = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Locale constructLocaleFromString(String string2) {
        String[] stringArray;
        block6: {
            block5: {
                if (TextUtils.isEmpty(string2)) break block5;
                stringArray = string2.split("_", 3);
                if (stringArray.length == 1) {
                    return new Locale(stringArray[0]);
                }
                if (stringArray.length == 2) {
                    return new Locale(stringArray[0], stringArray[1]);
                }
                if (stringArray.length == 3) break block6;
            }
            return null;
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }

    private static InputMethodSubtypeBuilder getBuilder(int n, int n2, String string2, String string3, String string4, boolean bl, boolean bl2, int n3, boolean bl3) {
        InputMethodSubtypeBuilder inputMethodSubtypeBuilder = new InputMethodSubtypeBuilder();
        InputMethodSubtypeBuilder.access$102(inputMethodSubtypeBuilder, n);
        InputMethodSubtypeBuilder.access$202(inputMethodSubtypeBuilder, n2);
        InputMethodSubtypeBuilder.access$302(inputMethodSubtypeBuilder, string2);
        InputMethodSubtypeBuilder.access$402(inputMethodSubtypeBuilder, string3);
        InputMethodSubtypeBuilder.access$502(inputMethodSubtypeBuilder, string4);
        InputMethodSubtypeBuilder.access$602(inputMethodSubtypeBuilder, bl);
        InputMethodSubtypeBuilder.access$702(inputMethodSubtypeBuilder, bl2);
        InputMethodSubtypeBuilder.access$802(inputMethodSubtypeBuilder, n3);
        InputMethodSubtypeBuilder.access$902(inputMethodSubtypeBuilder, bl3);
        return inputMethodSubtypeBuilder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, String> getExtraValueHashMap() {
        if (this.mExtraValueHashMapCache == null) {
            synchronized (this) {
                if (this.mExtraValueHashMapCache == null) {
                    this.mExtraValueHashMapCache = new HashMap();
                    String[] stringArray = this.mSubtypeExtraValue.split(EXTRA_VALUE_PAIR_SEPARATOR);
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String[] stringArray2 = stringArray[i].split(EXTRA_VALUE_KEY_VALUE_SEPARATOR);
                        if (stringArray2.length == 1) {
                            this.mExtraValueHashMapCache.put(stringArray2[0], null);
                            continue;
                        }
                        if (stringArray2.length <= 1) continue;
                        if (stringArray2.length > 2) {
                            Slog.w(TAG, "ExtraValue has two or more '='s");
                        }
                        this.mExtraValueHashMapCache.put(stringArray2[0], stringArray2[1]);
                    }
                }
            }
        }
        return this.mExtraValueHashMapCache;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int hashCodeInternal(String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = !bl3;
        if (bl4) {
            Object[] objectArray = new Object[]{string2, string3, string4, bl, bl2};
            return Arrays.hashCode(objectArray);
        }
        Object[] objectArray = new Object[]{string2, string3, string4, bl, bl2, bl3};
        return Arrays.hashCode(objectArray);
    }

    public static List<InputMethodSubtype> sort(Context context, int n, InputMethodInfo inputMethodInfo, List<InputMethodSubtype> list) {
        if (inputMethodInfo == null) {
            return list;
        }
        HashSet<InputMethodSubtype> hashSet = new HashSet<InputMethodSubtype>(list);
        ArrayList<InputMethodSubtype> arrayList = new ArrayList<InputMethodSubtype>();
        int n2 = inputMethodInfo.getSubtypeCount();
        for (int i = 0; i < n2; ++i) {
            InputMethodSubtype inputMethodSubtype = inputMethodInfo.getSubtypeAt(i);
            if (!hashSet.contains(inputMethodSubtype)) continue;
            arrayList.add(inputMethodSubtype);
            hashSet.remove(inputMethodSubtype);
        }
        Iterator<InputMethodSubtype> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public boolean containsExtraValueKey(String string2) {
        return this.getExtraValueHashMap().containsKey(string2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        if (!(object instanceof InputMethodSubtype)) {
            return false;
        }
        InputMethodSubtype inputMethodSubtype = (InputMethodSubtype)object;
        if (inputMethodSubtype.mSubtypeId != 0 || this.mSubtypeId != 0) {
            if (inputMethodSubtype.hashCode() == this.hashCode()) return true;
            return false;
        }
        if (inputMethodSubtype.hashCode() != this.hashCode() || !inputMethodSubtype.getLocale().equals(this.getLocale()) || !inputMethodSubtype.getMode().equals(this.getMode()) || !inputMethodSubtype.getExtraValue().equals(this.getExtraValue()) || inputMethodSubtype.isAuxiliary() != this.isAuxiliary() || inputMethodSubtype.overridesImplicitlyEnabledSubtype() != this.overridesImplicitlyEnabledSubtype() || inputMethodSubtype.isAsciiCapable() != this.isAsciiCapable()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CharSequence getDisplayName(Context context, String string2, ApplicationInfo applicationInfo) {
        CharSequence charSequence;
        Locale locale = InputMethodSubtype.constructLocaleFromString(this.mSubtypeLocale);
        String string3 = locale != null ? locale.getDisplayName() : this.mSubtypeLocale;
        if (this.mSubtypeNameResId == 0 || TextUtils.isEmpty(charSequence = context.getPackageManager().getText(string2, this.mSubtypeNameResId, applicationInfo))) {
            return string3;
        }
        String string4 = this.containsExtraValueKey(EXTRA_KEY_UNTRANSLATABLE_STRING_IN_SUBTYPE_NAME) ? this.getExtraValueOf(EXTRA_KEY_UNTRANSLATABLE_STRING_IN_SUBTYPE_NAME) : string3;
        try {
            String string5 = charSequence.toString();
            Object[] objectArray = new Object[1];
            if (string4 == null) {
                string4 = "";
            }
            objectArray[0] = string4;
            return String.format(string5, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            Slog.w(TAG, "Found illegal format in subtype name(" + charSequence + "): " + illegalFormatException);
            return "";
        }
    }

    public String getExtraValue() {
        return this.mSubtypeExtraValue;
    }

    public String getExtraValueOf(String string2) {
        return this.getExtraValueHashMap().get(string2);
    }

    public int getIconResId() {
        return this.mSubtypeIconResId;
    }

    public String getLocale() {
        return this.mSubtypeLocale;
    }

    public String getMode() {
        return this.mSubtypeMode;
    }

    public int getNameResId() {
        return this.mSubtypeNameResId;
    }

    public int hashCode() {
        return this.mSubtypeHashCode;
    }

    public boolean isAsciiCapable() {
        return this.mIsAsciiCapable;
    }

    public boolean isAuxiliary() {
        return this.mIsAuxiliary;
    }

    public boolean overridesImplicitlyEnabledSubtype() {
        return this.mOverridesImplicitlyEnabledSubtype;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.mSubtypeNameResId);
        parcel.writeInt(this.mSubtypeIconResId);
        parcel.writeString(this.mSubtypeLocale);
        parcel.writeString(this.mSubtypeMode);
        parcel.writeString(this.mSubtypeExtraValue);
        int n3 = this.mIsAuxiliary ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.mOverridesImplicitlyEnabledSubtype ? n2 : 0;
        parcel.writeInt(n4);
        parcel.writeInt(this.mSubtypeHashCode);
        parcel.writeInt(this.mSubtypeId);
        if (!this.mIsAsciiCapable) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }

    public static class InputMethodSubtypeBuilder {
        private boolean mIsAsciiCapable = false;
        private boolean mIsAuxiliary = false;
        private boolean mOverridesImplicitlyEnabledSubtype = false;
        private String mSubtypeExtraValue = "";
        private int mSubtypeIconResId = 0;
        private int mSubtypeId = 0;
        private String mSubtypeLocale = "";
        private String mSubtypeMode = "";
        private int mSubtypeNameResId = 0;

        static /* synthetic */ int access$102(InputMethodSubtypeBuilder inputMethodSubtypeBuilder, int n) {
            inputMethodSubtypeBuilder.mSubtypeNameResId = n;
            return n;
        }

        static /* synthetic */ int access$202(InputMethodSubtypeBuilder inputMethodSubtypeBuilder, int n) {
            inputMethodSubtypeBuilder.mSubtypeIconResId = n;
            return n;
        }

        static /* synthetic */ String access$302(InputMethodSubtypeBuilder inputMethodSubtypeBuilder, String string2) {
            inputMethodSubtypeBuilder.mSubtypeLocale = string2;
            return string2;
        }

        static /* synthetic */ String access$402(InputMethodSubtypeBuilder inputMethodSubtypeBuilder, String string2) {
            inputMethodSubtypeBuilder.mSubtypeMode = string2;
            return string2;
        }

        static /* synthetic */ String access$502(InputMethodSubtypeBuilder inputMethodSubtypeBuilder, String string2) {
            inputMethodSubtypeBuilder.mSubtypeExtraValue = string2;
            return string2;
        }

        static /* synthetic */ boolean access$602(InputMethodSubtypeBuilder inputMethodSubtypeBuilder, boolean bl) {
            inputMethodSubtypeBuilder.mIsAuxiliary = bl;
            return bl;
        }

        static /* synthetic */ boolean access$702(InputMethodSubtypeBuilder inputMethodSubtypeBuilder, boolean bl) {
            inputMethodSubtypeBuilder.mOverridesImplicitlyEnabledSubtype = bl;
            return bl;
        }

        static /* synthetic */ int access$802(InputMethodSubtypeBuilder inputMethodSubtypeBuilder, int n) {
            inputMethodSubtypeBuilder.mSubtypeId = n;
            return n;
        }

        static /* synthetic */ boolean access$902(InputMethodSubtypeBuilder inputMethodSubtypeBuilder, boolean bl) {
            inputMethodSubtypeBuilder.mIsAsciiCapable = bl;
            return bl;
        }

        public InputMethodSubtype build() {
            return new InputMethodSubtype(this);
        }

        public InputMethodSubtypeBuilder setIsAsciiCapable(boolean bl) {
            this.mIsAsciiCapable = bl;
            return this;
        }

        public InputMethodSubtypeBuilder setIsAuxiliary(boolean bl) {
            this.mIsAuxiliary = bl;
            return this;
        }

        public InputMethodSubtypeBuilder setOverridesImplicitlyEnabledSubtype(boolean bl) {
            this.mOverridesImplicitlyEnabledSubtype = bl;
            return this;
        }

        public InputMethodSubtypeBuilder setSubtypeExtraValue(String string2) {
            if (string2 == null) {
                string2 = "";
            }
            this.mSubtypeExtraValue = string2;
            return this;
        }

        public InputMethodSubtypeBuilder setSubtypeIconResId(int n) {
            this.mSubtypeIconResId = n;
            return this;
        }

        public InputMethodSubtypeBuilder setSubtypeId(int n) {
            this.mSubtypeId = n;
            return this;
        }

        public InputMethodSubtypeBuilder setSubtypeLocale(String string2) {
            if (string2 == null) {
                string2 = "";
            }
            this.mSubtypeLocale = string2;
            return this;
        }

        public InputMethodSubtypeBuilder setSubtypeMode(String string2) {
            if (string2 == null) {
                string2 = "";
            }
            this.mSubtypeMode = string2;
            return this;
        }

        public InputMethodSubtypeBuilder setSubtypeNameResId(int n) {
            this.mSubtypeNameResId = n;
            return this;
        }
    }
}

