/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import com.android.internal.view.animation.NativeInterpolatorFactoryHelper;

@HasNativeInterpolator
public class DecelerateInterpolator
implements Interpolator,
NativeInterpolatorFactory {
    private float mFactor = 1.0f;

    public DecelerateInterpolator() {
    }

    public DecelerateInterpolator(float f) {
        this.mFactor = f;
    }

    public DecelerateInterpolator(Context context, AttributeSet attributeSet) {
        this(context.getResources(), context.getTheme(), attributeSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public DecelerateInterpolator(Resources resources, Resources.Theme theme, AttributeSet attributeSet) {
        TypedArray typedArray = theme != null ? theme.obtainStyledAttributes(attributeSet, R.styleable.DecelerateInterpolator, 0, 0) : resources.obtainAttributes(attributeSet, R.styleable.DecelerateInterpolator);
        this.mFactor = typedArray.getFloat(0, 1.0f);
        typedArray.recycle();
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactoryHelper.createDecelerateInterpolator(this.mFactor);
    }

    @Override
    public float getInterpolation(float f) {
        if (this.mFactor == 1.0f) {
            return 1.0f - (1.0f - f) * (1.0f - f);
        }
        return (float)(1.0 - Math.pow(1.0f - f, 2.0f * this.mFactor));
    }
}

