/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class CaptioningManager {
    private static final int DEFAULT_ENABLED = 0;
    private static final float DEFAULT_FONT_SCALE = 1.0f;
    private static final int DEFAULT_PRESET;
    private final ContentObserver mContentObserver;
    private final ContentResolver mContentResolver;
    private final Handler mHandler;
    private final ArrayList<CaptioningChangeListener> mListeners = new ArrayList();
    private final Runnable mStyleChangedRunnable;

    public CaptioningManager(Context context) {
        this.mHandler = new Handler();
        this.mContentObserver = new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean bl, Uri uri) {
                String string2 = uri.getPath();
                String string3 = string2.substring(1 + string2.lastIndexOf(47));
                if ("accessibility_captioning_enabled".equals(string3)) {
                    CaptioningManager.this.notifyEnabledChanged();
                    return;
                }
                if ("accessibility_captioning_locale".equals(string3)) {
                    CaptioningManager.this.notifyLocaleChanged();
                    return;
                }
                if ("accessibility_captioning_font_scale".equals(string3)) {
                    CaptioningManager.this.notifyFontScaleChanged();
                    return;
                }
                CaptioningManager.this.mHandler.removeCallbacks(CaptioningManager.this.mStyleChangedRunnable);
                CaptioningManager.this.mHandler.post(CaptioningManager.this.mStyleChangedRunnable);
            }
        };
        this.mStyleChangedRunnable = new Runnable(){

            @Override
            public void run() {
                CaptioningManager.this.notifyUserStyleChanged();
            }
        };
        this.mContentResolver = context.getContentResolver();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyEnabledChanged() {
        boolean bl = this.isEnabled();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            Iterator<CaptioningChangeListener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onEnabledChanged(bl);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyFontScaleChanged() {
        float f = this.getFontScale();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            Iterator<CaptioningChangeListener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onFontScaleChanged(f);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyLocaleChanged() {
        Locale locale = this.getLocale();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            Iterator<CaptioningChangeListener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onLocaleChanged(locale);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyUserStyleChanged() {
        CaptionStyle captionStyle = this.getUserStyle();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            Iterator<CaptioningChangeListener> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onUserStyleChanged(captionStyle);
            }
            return;
        }
    }

    private void registerObserver(String string2) {
        this.mContentResolver.registerContentObserver(Settings.Secure.getUriFor(string2), false, this.mContentObserver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCaptioningChangeListener(CaptioningChangeListener captioningChangeListener) {
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            if (this.mListeners.isEmpty()) {
                this.registerObserver("accessibility_captioning_enabled");
                this.registerObserver("accessibility_captioning_foreground_color");
                this.registerObserver("accessibility_captioning_background_color");
                this.registerObserver("accessibility_captioning_window_color");
                this.registerObserver("accessibility_captioning_edge_type");
                this.registerObserver("accessibility_captioning_edge_color");
                this.registerObserver("accessibility_captioning_typeface");
                this.registerObserver("accessibility_captioning_font_scale");
                this.registerObserver("accessibility_captioning_locale");
                this.registerObserver("accessibility_captioning_preset");
            }
            this.mListeners.add(captioningChangeListener);
            return;
        }
    }

    public final float getFontScale() {
        return Settings.Secure.getFloat(this.mContentResolver, "accessibility_captioning_font_scale", 1.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Locale getLocale() {
        String string2 = this.getRawLocale();
        if (TextUtils.isEmpty(string2)) return null;
        String[] stringArray = string2.split("_");
        switch (stringArray.length) {
            default: {
                return null;
            }
            case 3: {
                return new Locale(stringArray[0], stringArray[1], stringArray[2]);
            }
            case 2: {
                return new Locale(stringArray[0], stringArray[1]);
            }
            case 1: 
        }
        return new Locale(stringArray[0]);
    }

    public final String getRawLocale() {
        return Settings.Secure.getString(this.mContentResolver, "accessibility_captioning_locale");
    }

    public int getRawUserStyle() {
        return Settings.Secure.getInt(this.mContentResolver, "accessibility_captioning_preset", 0);
    }

    public CaptionStyle getUserStyle() {
        int n = this.getRawUserStyle();
        if (n == -1) {
            return CaptionStyle.getCustomStyle(this.mContentResolver);
        }
        return CaptionStyle.PRESETS[n];
    }

    public final boolean isEnabled() {
        return Settings.Secure.getInt(this.mContentResolver, "accessibility_captioning_enabled", 0) == 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeCaptioningChangeListener(CaptioningChangeListener captioningChangeListener) {
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.remove(captioningChangeListener);
            if (this.mListeners.isEmpty()) {
                this.mContentResolver.unregisterContentObserver(this.mContentObserver);
            }
            return;
        }
    }

    public static final class CaptionStyle {
        private static final CaptionStyle BLACK_ON_WHITE;
        private static final int COLOR_NONE_OPAQUE = 255;
        private static final int COLOR_UNSPECIFIED = 511;
        public static final CaptionStyle DEFAULT;
        private static final CaptionStyle DEFAULT_CUSTOM;
        public static final int EDGE_TYPE_DEPRESSED = 4;
        public static final int EDGE_TYPE_DROP_SHADOW = 2;
        public static final int EDGE_TYPE_NONE = 0;
        public static final int EDGE_TYPE_OUTLINE = 1;
        public static final int EDGE_TYPE_RAISED = 3;
        public static final int EDGE_TYPE_UNSPECIFIED = -1;
        public static final CaptionStyle[] PRESETS;
        public static final int PRESET_CUSTOM = -1;
        private static final CaptionStyle UNSPECIFIED;
        private static final CaptionStyle WHITE_ON_BLACK;
        private static final CaptionStyle YELLOW_ON_BLACK;
        private static final CaptionStyle YELLOW_ON_BLUE;
        public final int backgroundColor;
        public final int edgeColor;
        public final int edgeType;
        public final int foregroundColor;
        private final boolean mHasBackgroundColor;
        private final boolean mHasEdgeColor;
        private final boolean mHasEdgeType;
        private final boolean mHasForegroundColor;
        private final boolean mHasWindowColor;
        private Typeface mParsedTypeface;
        public final String mRawTypeface;
        public final int windowColor;

        static {
            WHITE_ON_BLACK = new CaptionStyle(-1, -16777216, 0, -16777216, 255, null);
            BLACK_ON_WHITE = new CaptionStyle(-16777216, -1, 0, -16777216, 255, null);
            YELLOW_ON_BLACK = new CaptionStyle(-256, -16777216, 0, -16777216, 255, null);
            YELLOW_ON_BLUE = new CaptionStyle(-256, -16776961, 0, -16777216, 255, null);
            UNSPECIFIED = new CaptionStyle(511, 511, -1, 511, 511, null);
            CaptionStyle[] captionStyleArray = new CaptionStyle[]{WHITE_ON_BLACK, BLACK_ON_WHITE, YELLOW_ON_BLACK, YELLOW_ON_BLUE, UNSPECIFIED};
            PRESETS = captionStyleArray;
            DEFAULT_CUSTOM = WHITE_ON_BLACK;
            DEFAULT = WHITE_ON_BLACK;
        }

        /*
         * Enabled aggressive block sorting
         */
        private CaptionStyle(int n, int n2, int n3, int n4, int n5, String string2) {
            boolean bl = true;
            boolean bl2 = n != 511 ? bl : false;
            this.mHasForegroundColor = bl2;
            boolean bl3 = n2 != 511 ? bl : false;
            this.mHasBackgroundColor = bl3;
            boolean bl4 = n3 != -1 ? bl : false;
            this.mHasEdgeType = bl4;
            boolean bl5 = n4 != 511 ? bl : false;
            this.mHasEdgeColor = bl5;
            if (n5 == 511) {
                bl = false;
            }
            this.mHasWindowColor = bl;
            if (!this.mHasForegroundColor) {
                n = -1;
            }
            this.foregroundColor = n;
            if (!this.mHasBackgroundColor) {
                n2 = -16777216;
            }
            this.backgroundColor = n2;
            if (!this.mHasEdgeType) {
                n3 = 0;
            }
            this.edgeType = n3;
            if (!this.mHasEdgeColor) {
                n4 = -16777216;
            }
            this.edgeColor = n4;
            if (!this.mHasWindowColor) {
                n5 = 255;
            }
            this.windowColor = n5;
            this.mRawTypeface = string2;
        }

        public static CaptionStyle getCustomStyle(ContentResolver contentResolver) {
            CaptionStyle captionStyle = DEFAULT_CUSTOM;
            int n = Settings.Secure.getInt(contentResolver, "accessibility_captioning_foreground_color", captionStyle.foregroundColor);
            int n2 = Settings.Secure.getInt(contentResolver, "accessibility_captioning_background_color", captionStyle.backgroundColor);
            int n3 = Settings.Secure.getInt(contentResolver, "accessibility_captioning_edge_type", captionStyle.edgeType);
            int n4 = Settings.Secure.getInt(contentResolver, "accessibility_captioning_edge_color", captionStyle.edgeColor);
            int n5 = Settings.Secure.getInt(contentResolver, "accessibility_captioning_window_color", captionStyle.windowColor);
            String string2 = Settings.Secure.getString(contentResolver, "accessibility_captioning_typeface");
            if (string2 == null) {
                string2 = captionStyle.mRawTypeface;
            }
            return new CaptionStyle(n, n2, n3, n4, n5, string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public CaptionStyle applyStyle(CaptionStyle captionStyle) {
            String string2;
            int n = captionStyle.hasForegroundColor() ? captionStyle.foregroundColor : this.foregroundColor;
            int n2 = captionStyle.hasBackgroundColor() ? captionStyle.backgroundColor : this.backgroundColor;
            int n3 = captionStyle.hasEdgeType() ? captionStyle.edgeType : this.edgeType;
            int n4 = captionStyle.hasEdgeColor() ? captionStyle.edgeColor : this.edgeColor;
            int n5 = captionStyle.hasWindowColor() ? captionStyle.windowColor : this.windowColor;
            if (captionStyle.mRawTypeface != null) {
                string2 = captionStyle.mRawTypeface;
                return new CaptionStyle(n, n2, n3, n4, n5, string2);
            }
            string2 = this.mRawTypeface;
            return new CaptionStyle(n, n2, n3, n4, n5, string2);
        }

        public Typeface getTypeface() {
            if (this.mParsedTypeface == null && !TextUtils.isEmpty(this.mRawTypeface)) {
                this.mParsedTypeface = Typeface.create(this.mRawTypeface, 0);
            }
            return this.mParsedTypeface;
        }

        public boolean hasBackgroundColor() {
            return this.mHasBackgroundColor;
        }

        public boolean hasEdgeColor() {
            return this.mHasEdgeColor;
        }

        public boolean hasEdgeType() {
            return this.mHasEdgeType;
        }

        public boolean hasForegroundColor() {
            return this.mHasForegroundColor;
        }

        public boolean hasWindowColor() {
            return this.mHasWindowColor;
        }
    }

    public static abstract class CaptioningChangeListener {
        public void onEnabledChanged(boolean bl) {
        }

        public void onFontScaleChanged(float f) {
        }

        public void onLocaleChanged(Locale locale) {
        }

        public void onUserStyleChanged(CaptionStyle captionStyle) {
        }
    }
}

