/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.media.session.MediaController;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.SystemProperties;
import android.transition.Scene;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.view.ActionMode;
import android.view.InputEvent;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.R;

public abstract class Window {
    protected static final int DEFAULT_FEATURES = 65;
    public static final int FEATURE_ACTION_BAR = 8;
    public static final int FEATURE_ACTION_BAR_OVERLAY = 9;
    public static final int FEATURE_ACTION_MODE_OVERLAY = 10;
    public static final int FEATURE_ACTIVITY_TRANSITIONS = 13;
    public static final int FEATURE_CONTENT_TRANSITIONS = 12;
    public static final int FEATURE_CONTEXT_MENU = 6;
    public static final int FEATURE_CUSTOM_TITLE = 7;
    public static final int FEATURE_INDETERMINATE_PROGRESS = 5;
    public static final int FEATURE_LEFT_ICON = 3;
    public static final int FEATURE_MAX = 13;
    public static final int FEATURE_NO_TITLE = 1;
    public static final int FEATURE_OPTIONS_PANEL = 0;
    public static final int FEATURE_PROGRESS = 2;
    public static final int FEATURE_RIGHT_ICON = 4;
    public static final int FEATURE_SWIPE_TO_DISMISS = 11;
    public static final int ID_ANDROID_CONTENT = 0x1020002;
    public static final String NAVIGATION_BAR_BACKGROUND_TRANSITION_NAME = "android:navigation:background";
    public static final int PROGRESS_END = 10000;
    public static final int PROGRESS_INDETERMINATE_OFF = -4;
    public static final int PROGRESS_INDETERMINATE_ON = -3;
    public static final int PROGRESS_SECONDARY_END = 30000;
    public static final int PROGRESS_SECONDARY_START = 20000;
    public static final int PROGRESS_START = 0;
    public static final int PROGRESS_VISIBILITY_OFF = -2;
    public static final int PROGRESS_VISIBILITY_ON = -1;
    private static final String PROPERTY_HARDWARE_UI = "persist.sys.ui.hw";
    public static final String STATUS_BAR_BACKGROUND_TRANSITION_NAME = "android:status:background";
    private Window mActiveChild;
    private String mAppName;
    private IBinder mAppToken;
    private Callback mCallback;
    private boolean mCloseOnTouchOutside = false;
    private Window mContainer;
    private final Context mContext;
    private int mDefaultWindowFormat = -1;
    private boolean mDestroyed;
    private int mFeatures = 65;
    private int mForcedWindowFlags = 0;
    private boolean mHardwareAccelerated;
    private boolean mHasChildren = false;
    private boolean mHasSoftInputMode = false;
    private boolean mHaveDimAmount = false;
    private boolean mHaveWindowFormat = false;
    private boolean mIsActive = false;
    private int mLocalFeatures = 65;
    private OnWindowDismissedCallback mOnWindowDismissedCallback;
    private boolean mSetCloseOnTouchOutside = false;
    private final WindowManager.LayoutParams mWindowAttributes = new WindowManager.LayoutParams();
    private WindowManager mWindowManager;
    private TypedArray mWindowStyle;

    public Window(Context context) {
        this.mContext = context;
    }

    private boolean isOutOfBounds(Context context, MotionEvent motionEvent) {
        int n = (int)motionEvent.getX();
        int n2 = (int)motionEvent.getY();
        int n3 = ViewConfiguration.get(context).getScaledWindowTouchSlop();
        View view = this.getDecorView();
        return n < -n3 || n2 < -n3 || n > n3 + view.getWidth() || n2 > n3 + view.getHeight();
    }

    private void setPrivateFlags(int n, int n2) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.privateFlags = layoutParams.privateFlags & ~n2 | n & n2;
        this.dispatchWindowAttributesChanged(layoutParams);
    }

    public abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    public void addFlags(int n) {
        this.setFlags(n, n);
    }

    public void addPrivateFlags(int n) {
        this.setPrivateFlags(n, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void adjustLayoutParamsForSubWindow(WindowManager.LayoutParams layoutParams) {
        CharSequence charSequence = layoutParams.getTitle();
        if (layoutParams.type >= 1000 && layoutParams.type <= 1999) {
            View view;
            if (layoutParams.token == null && (view = this.peekDecorView()) != null) {
                layoutParams.token = view.getWindowToken();
            }
            if (charSequence == null || charSequence.length() == 0) {
                String string2 = layoutParams.type == 1001 ? "Media" : (layoutParams.type == 1004 ? "MediaOvr" : (layoutParams.type == 1000 ? "Panel" : (layoutParams.type == 1002 ? "SubPanel" : (layoutParams.type == 1003 ? "AtchDlg" : Integer.toString(layoutParams.type)))));
                if (this.mAppName != null) {
                    string2 = string2 + ":" + this.mAppName;
                }
                layoutParams.setTitle(string2);
            }
        } else {
            if (layoutParams.token == null) {
                IBinder iBinder = this.mContainer == null ? this.mAppToken : this.mContainer.mAppToken;
                layoutParams.token = iBinder;
            }
            if ((charSequence == null || charSequence.length() == 0) && this.mAppName != null) {
                layoutParams.setTitle(this.mAppName);
            }
        }
        if (layoutParams.packageName == null) {
            layoutParams.packageName = this.mContext.getPackageName();
        }
        if (this.mHardwareAccelerated) {
            layoutParams.flags = 0x1000000 | layoutParams.flags;
        }
    }

    public abstract void alwaysReadCloseOnTouchAttr();

    public void clearFlags(int n) {
        this.setFlags(0, n);
    }

    public abstract void closeAllPanels();

    public abstract void closePanel(int var1);

    public final void destroy() {
        this.mDestroyed = true;
    }

    public final void dispatchOnWindowDismissed() {
        if (this.mOnWindowDismissedCallback != null) {
            this.mOnWindowDismissedCallback.onWindowDismissed();
        }
    }

    protected void dispatchWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(layoutParams);
        }
    }

    public View findViewById(int n) {
        return this.getDecorView().findViewById(n);
    }

    public boolean getAllowEnterTransitionOverlap() {
        return true;
    }

    public boolean getAllowExitTransitionOverlap() {
        return this.getAllowReturnTransitionOverlap();
    }

    public boolean getAllowReturnTransitionOverlap() {
        return true;
    }

    public final WindowManager.LayoutParams getAttributes() {
        return this.mWindowAttributes;
    }

    public final Callback getCallback() {
        return this.mCallback;
    }

    public final Window getContainer() {
        return this.mContainer;
    }

    public Scene getContentScene() {
        return null;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public abstract View getCurrentFocus();

    public abstract View getDecorView();

    public Transition getEnterTransition() {
        return null;
    }

    public Transition getExitTransition() {
        return null;
    }

    protected final int getFeatures() {
        return this.mFeatures;
    }

    protected final int getForcedWindowFlags() {
        return this.mForcedWindowFlags;
    }

    public abstract LayoutInflater getLayoutInflater();

    protected final int getLocalFeatures() {
        return this.mLocalFeatures;
    }

    public MediaController getMediaController() {
        return null;
    }

    public abstract int getNavigationBarColor();

    public Transition getReenterTransition() {
        return null;
    }

    public Transition getReturnTransition() {
        return null;
    }

    public Transition getSharedElementEnterTransition() {
        return null;
    }

    public Transition getSharedElementExitTransition() {
        return null;
    }

    public Transition getSharedElementReenterTransition() {
        return null;
    }

    public Transition getSharedElementReturnTransition() {
        return null;
    }

    public boolean getSharedElementsUseOverlay() {
        return true;
    }

    public abstract int getStatusBarColor();

    public long getTransitionBackgroundFadeDuration() {
        return 0L;
    }

    public TransitionManager getTransitionManager() {
        return null;
    }

    public abstract int getVolumeControlStream();

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final TypedArray getWindowStyle() {
        synchronized (this) {
            if (this.mWindowStyle != null) return this.mWindowStyle;
            this.mWindowStyle = this.mContext.obtainStyledAttributes(R.styleable.Window);
            return this.mWindowStyle;
        }
    }

    public final boolean hasChildren() {
        return this.mHasChildren;
    }

    public boolean hasFeature(int n) {
        return (this.getFeatures() & 1 << n) != 0;
    }

    protected final boolean hasSoftInputMode() {
        return this.mHasSoftInputMode;
    }

    protected boolean haveDimAmount() {
        return this.mHaveDimAmount;
    }

    public void injectInputEvent(InputEvent inputEvent) {
    }

    public abstract void invalidatePanelMenu(int var1);

    public final boolean isActive() {
        return this.mIsActive;
    }

    public final boolean isDestroyed() {
        return this.mDestroyed;
    }

    public abstract boolean isFloating();

    public abstract boolean isShortcutKey(int var1, KeyEvent var2);

    public final void makeActive() {
        if (this.mContainer != null) {
            if (this.mContainer.mActiveChild != null) {
                this.mContainer.mActiveChild.mIsActive = false;
            }
            this.mContainer.mActiveChild = this;
        }
        this.mIsActive = true;
        this.onActive();
    }

    protected abstract void onActive();

    public abstract void onConfigurationChanged(Configuration var1);

    public abstract void openPanel(int var1, KeyEvent var2);

    public abstract View peekDecorView();

    public abstract boolean performContextMenuIdentifierAction(int var1, int var2);

    public abstract boolean performPanelIdentifierAction(int var1, int var2, int var3);

    public abstract boolean performPanelShortcut(int var1, int var2, KeyEvent var3, int var4);

    protected void removeFeature(int n) {
        int n2 = 1 << n;
        this.mFeatures &= ~n2;
        int n3 = this.mLocalFeatures;
        if (this.mContainer != null) {
            n2 &= 0xFFFFFFFF ^ this.mContainer.mFeatures;
        }
        this.mLocalFeatures = n3 & ~n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean requestFeature(int n) {
        int n2 = 1 << n;
        this.mFeatures = n2 | this.mFeatures;
        int n3 = this.mLocalFeatures;
        int n4 = this.mContainer != null ? n2 & (0xFFFFFFFF ^ this.mContainer.mFeatures) : n2;
        this.mLocalFeatures = n4 | n3;
        return (n2 & this.mFeatures) != 0;
    }

    public abstract void restoreHierarchyState(Bundle var1);

    public abstract Bundle saveHierarchyState();

    public void setAllowEnterTransitionOverlap(boolean bl) {
    }

    public void setAllowExitTransitionOverlap(boolean bl) {
        this.setAllowReturnTransitionOverlap(bl);
    }

    public void setAllowReturnTransitionOverlap(boolean bl) {
    }

    public void setAttributes(WindowManager.LayoutParams layoutParams) {
        this.mWindowAttributes.copyFrom(layoutParams);
        this.dispatchWindowAttributesChanged(this.mWindowAttributes);
    }

    public abstract void setBackgroundDrawable(Drawable var1);

    public void setBackgroundDrawableResource(int n) {
        this.setBackgroundDrawable(this.mContext.getDrawable(n));
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public abstract void setChildDrawable(int var1, Drawable var2);

    public abstract void setChildInt(int var1, int var2);

    public void setCloseOnTouchOutside(boolean bl) {
        this.mCloseOnTouchOutside = bl;
        this.mSetCloseOnTouchOutside = true;
    }

    public void setCloseOnTouchOutsideIfNotSet(boolean bl) {
        if (!this.mSetCloseOnTouchOutside) {
            this.mCloseOnTouchOutside = bl;
            this.mSetCloseOnTouchOutside = true;
        }
    }

    public void setContainer(Window window) {
        this.mContainer = window;
        if (window != null) {
            this.mFeatures = 2 | this.mFeatures;
            this.mLocalFeatures = 2 | this.mLocalFeatures;
            window.mHasChildren = true;
        }
    }

    public abstract void setContentView(int var1);

    public abstract void setContentView(View var1);

    public abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    public void setDefaultIcon(int n) {
    }

    public void setDefaultLogo(int n) {
    }

    protected void setDefaultWindowFormat(int n) {
        this.mDefaultWindowFormat = n;
        if (!this.mHaveWindowFormat) {
            WindowManager.LayoutParams layoutParams = this.getAttributes();
            layoutParams.format = n;
            this.dispatchWindowAttributesChanged(layoutParams);
        }
    }

    public void setDimAmount(float f) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.dimAmount = f;
        this.mHaveDimAmount = true;
        this.dispatchWindowAttributesChanged(layoutParams);
    }

    public void setEnterTransition(Transition transition2) {
    }

    public void setExitTransition(Transition transition2) {
    }

    public abstract void setFeatureDrawable(int var1, Drawable var2);

    public abstract void setFeatureDrawableAlpha(int var1, int var2);

    public abstract void setFeatureDrawableResource(int var1, int var2);

    public abstract void setFeatureDrawableUri(int var1, Uri var2);

    public abstract void setFeatureInt(int var1, int var2);

    public void setFlags(int n, int n2) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.flags = layoutParams.flags & ~n2 | n & n2;
        if ((0x40000000 & n2) != 0) {
            layoutParams.privateFlags = 8 | layoutParams.privateFlags;
        }
        this.mForcedWindowFlags = n2 | this.mForcedWindowFlags;
        this.dispatchWindowAttributesChanged(layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFormat(int n) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        if (n != 0) {
            layoutParams.format = n;
            this.mHaveWindowFormat = true;
        } else {
            layoutParams.format = this.mDefaultWindowFormat;
            this.mHaveWindowFormat = false;
        }
        this.dispatchWindowAttributesChanged(layoutParams);
    }

    public void setGravity(int n) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.gravity = n;
        this.dispatchWindowAttributesChanged(layoutParams);
    }

    public void setIcon(int n) {
    }

    public void setLayout(int n, int n2) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.width = n;
        layoutParams.height = n2;
        this.dispatchWindowAttributesChanged(layoutParams);
    }

    public void setLocalFocus(boolean bl, boolean bl2) {
    }

    public void setLogo(int n) {
    }

    public void setMediaController(MediaController mediaController) {
    }

    public abstract void setNavigationBarColor(int var1);

    public final void setOnWindowDismissedCallback(OnWindowDismissedCallback onWindowDismissedCallback) {
        this.mOnWindowDismissedCallback = onWindowDismissedCallback;
    }

    public void setReenterTransition(Transition transition2) {
    }

    public void setReturnTransition(Transition transition2) {
    }

    public void setSharedElementEnterTransition(Transition transition2) {
    }

    public void setSharedElementExitTransition(Transition transition2) {
    }

    public void setSharedElementReenterTransition(Transition transition2) {
    }

    public void setSharedElementReturnTransition(Transition transition2) {
    }

    public void setSharedElementsUseOverlay(boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSoftInputMode(int n) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        if (n != 0) {
            layoutParams.softInputMode = n;
            this.mHasSoftInputMode = true;
        } else {
            this.mHasSoftInputMode = false;
        }
        this.dispatchWindowAttributesChanged(layoutParams);
    }

    public abstract void setStatusBarColor(int var1);

    public abstract void setTitle(CharSequence var1);

    @Deprecated
    public abstract void setTitleColor(int var1);

    public void setTransitionBackgroundFadeDuration(long l) {
    }

    public void setTransitionManager(TransitionManager transitionManager) {
        throw new UnsupportedOperationException();
    }

    public void setType(int n) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.type = n;
        this.dispatchWindowAttributesChanged(layoutParams);
    }

    public void setUiOptions(int n) {
    }

    public void setUiOptions(int n, int n2) {
    }

    public abstract void setVolumeControlStream(int var1);

    public void setWindowAnimations(int n) {
        WindowManager.LayoutParams layoutParams = this.getAttributes();
        layoutParams.windowAnimations = n;
        this.dispatchWindowAttributesChanged(layoutParams);
    }

    public void setWindowManager(WindowManager windowManager, IBinder iBinder, String string2) {
        this.setWindowManager(windowManager, iBinder, string2, false);
    }

    public void setWindowManager(WindowManager windowManager, IBinder iBinder, String string2, boolean bl) {
        boolean bl2;
        block5: {
            block4: {
                this.mAppToken = iBinder;
                this.mAppName = string2;
                if (bl) break block4;
                boolean bl3 = SystemProperties.getBoolean(PROPERTY_HARDWARE_UI, false);
                bl2 = false;
                if (!bl3) break block5;
            }
            bl2 = true;
        }
        this.mHardwareAccelerated = bl2;
        if (windowManager == null) {
            windowManager = (WindowManager)this.mContext.getSystemService("window");
        }
        this.mWindowManager = ((WindowManagerImpl)windowManager).createLocalWindowManager(this);
    }

    public boolean shouldCloseOnTouch(Context context, MotionEvent motionEvent) {
        return this.mCloseOnTouchOutside && motionEvent.getAction() == 0 && this.isOutOfBounds(context, motionEvent) && this.peekDecorView() != null;
    }

    public abstract boolean superDispatchGenericMotionEvent(MotionEvent var1);

    public abstract boolean superDispatchKeyEvent(KeyEvent var1);

    public abstract boolean superDispatchKeyShortcutEvent(KeyEvent var1);

    public abstract boolean superDispatchTouchEvent(MotionEvent var1);

    public abstract boolean superDispatchTrackballEvent(MotionEvent var1);

    public abstract void takeInputQueue(InputQueue.Callback var1);

    public abstract void takeKeyEvents(boolean var1);

    public abstract void takeSurface(SurfaceHolder.Callback2 var1);

    public abstract void togglePanel(int var1, KeyEvent var2);

    public static interface Callback {
        public boolean dispatchGenericMotionEvent(MotionEvent var1);

        public boolean dispatchKeyEvent(KeyEvent var1);

        public boolean dispatchKeyShortcutEvent(KeyEvent var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public boolean dispatchTouchEvent(MotionEvent var1);

        public boolean dispatchTrackballEvent(MotionEvent var1);

        public void onActionModeFinished(ActionMode var1);

        public void onActionModeStarted(ActionMode var1);

        public void onAttachedToWindow();

        public void onContentChanged();

        public boolean onCreatePanelMenu(int var1, Menu var2);

        public View onCreatePanelView(int var1);

        public void onDetachedFromWindow();

        public boolean onMenuItemSelected(int var1, MenuItem var2);

        public boolean onMenuOpened(int var1, Menu var2);

        public void onPanelClosed(int var1, Menu var2);

        public boolean onPreparePanel(int var1, View var2, Menu var3);

        public boolean onSearchRequested();

        public void onWindowAttributesChanged(WindowManager.LayoutParams var1);

        public void onWindowFocusChanged(boolean var1);

        public ActionMode onWindowStartingActionMode(ActionMode.Callback var1);
    }

    public static interface OnWindowDismissedCallback {
        public void onWindowDismissed();
    }
}

