/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.LayoutTransition;
import android.app.ActivityManagerNative;
import android.content.ClipDescription;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.AndroidRuntimeException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Slog;
import android.util.TypedValue;
import android.view.AccessibilityInteractionController;
import android.view.ActionMode;
import android.view.Choreographer;
import android.view.ContextMenu;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.DragEvent;
import android.view.FallbackEventHandler;
import android.view.FocusFinder;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.HardwareRenderer;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputEventConsistencyVerifier;
import android.view.InputEventReceiver;
import android.view.InputQueue;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MagnificationSpec;
import android.view.MotionEvent;
import android.view.RenderNode;
import android.view.SoundEffectConstants;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.ThreadedRenderer;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.Scroller;
import com.android.internal.os.SomeArgs;
import com.android.internal.policy.PolicyManager;
import com.android.internal.view.BaseSurfaceHolder;
import com.android.internal.view.RootViewSurfaceTaker;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;

public final class ViewRootImpl
implements ViewParent,
View.AttachInfo.Callbacks,
HardwareRenderer.HardwareDrawCallbacks {
    private static final boolean DBG = false;
    private static final boolean DEBUG_CONFIGURATION = false;
    private static final boolean DEBUG_DIALOG = false;
    private static final boolean DEBUG_DRAW = false;
    private static final boolean DEBUG_FPS = false;
    private static final boolean DEBUG_IMF = false;
    private static final boolean DEBUG_INPUT_RESIZE = false;
    private static final boolean DEBUG_INPUT_STAGES = false;
    private static final boolean DEBUG_LAYOUT = false;
    private static final boolean DEBUG_ORIENTATION = false;
    private static final boolean DEBUG_TRACKBALL = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int MAX_QUEUED_INPUT_EVENT_POOL_SIZE = 10;
    static final int MAX_TRACKBALL_DELAY = 250;
    private static final int MSG_CHECK_FOCUS = 13;
    private static final int MSG_CLEAR_ACCESSIBILITY_FOCUS_HOST = 21;
    private static final int MSG_CLOSE_SYSTEM_DIALOGS = 14;
    private static final int MSG_DIE = 3;
    private static final int MSG_DISPATCH_APP_VISIBILITY = 8;
    private static final int MSG_DISPATCH_DONE_ANIMATING = 22;
    private static final int MSG_DISPATCH_DRAG_EVENT = 15;
    private static final int MSG_DISPATCH_DRAG_LOCATION_EVENT = 16;
    private static final int MSG_DISPATCH_GET_NEW_SURFACE = 9;
    private static final int MSG_DISPATCH_INPUT_EVENT = 7;
    private static final int MSG_DISPATCH_KEY_FROM_IME = 11;
    private static final int MSG_DISPATCH_SYSTEM_UI_VISIBILITY = 17;
    private static final int MSG_FINISH_INPUT_CONNECTION = 12;
    private static final int MSG_INVALIDATE = 1;
    private static final int MSG_INVALIDATE_RECT = 2;
    private static final int MSG_INVALIDATE_WORLD = 23;
    private static final int MSG_PROCESS_INPUT_EVENTS = 19;
    private static final int MSG_RESIZED = 4;
    private static final int MSG_RESIZED_REPORT = 5;
    private static final int MSG_SYNTHESIZE_INPUT_EVENT = 25;
    private static final int MSG_UPDATE_CONFIGURATION = 18;
    private static final int MSG_WINDOW_FOCUS_CHANGED = 6;
    private static final int MSG_WINDOW_MOVED = 24;
    public static final String PROPERTY_EMULATOR_CIRCULAR = "ro.emulator.circular";
    private static final String PROPERTY_MEDIA_DISABLED = "config.disable_media";
    private static final String PROPERTY_PROFILE_RENDERING = "viewroot.profile_rendering";
    private static final String TAG = "ViewRootImpl";
    static final Interpolator mResizeInterpolator;
    static final ArrayList<ComponentCallbacks> sConfigCallbacks;
    static boolean sFirstDrawComplete;
    static final ArrayList<Runnable> sFirstDrawHandlers;
    static final ThreadLocal<RunQueue> sRunQueues;
    View mAccessibilityFocusedHost;
    AccessibilityNodeInfo mAccessibilityFocusedVirtualView;
    AccessibilityInteractionConnectionManager mAccessibilityInteractionConnectionManager;
    AccessibilityInteractionController mAccessibilityInteractionController;
    final AccessibilityManager mAccessibilityManager;
    boolean mAdded;
    boolean mAddedTouchMode;
    boolean mAppVisible = true;
    boolean mApplyInsetsRequested;
    final View.AttachInfo mAttachInfo;
    AudioManager mAudioManager;
    final String mBasePackageName;
    boolean mBlockResizeBuffer;
    Choreographer mChoreographer;
    int mClientWindowLayoutFlags;
    final ConsumeBatchedInputImmediatelyRunnable mConsumeBatchedInputImmediatelyRunnable;
    boolean mConsumeBatchedInputImmediatelyScheduled;
    boolean mConsumeBatchedInputScheduled;
    final ConsumeBatchedInputRunnable mConsumedBatchedInputRunnable;
    final Context mContext;
    int mCurScrollY;
    View mCurrentDragView;
    private final int mDensity;
    Rect mDirty;
    final Rect mDispatchContentInsets;
    final Rect mDispatchStableInsets;
    final Display mDisplay;
    final DisplayAdjustments mDisplayAdjustments;
    private final DisplayManager.DisplayListener mDisplayListener;
    final DisplayManager mDisplayManager;
    ClipDescription mDragDescription;
    final PointF mDragPoint;
    boolean mDrawDuringWindowsAnimating;
    boolean mDrawingAllowed;
    FallbackEventHandler mFallbackEventHandler;
    boolean mFirst;
    InputStage mFirstInputStage;
    InputStage mFirstPostImeInputStage;
    private int mFpsNumFrames;
    private long mFpsPrevTime = -1L;
    private long mFpsStartTime = -1L;
    boolean mFullRedrawNeeded;
    final ViewRootHandler mHandler;
    boolean mHandlingLayoutInLayoutRequest = false;
    int mHardwareXOffset;
    int mHardwareYOffset;
    boolean mHasHadWindowFocus;
    int mHeight;
    HighContrastTextManager mHighContrastTextManager;
    private boolean mInLayout = false;
    InputChannel mInputChannel;
    protected final InputEventConsistencyVerifier mInputEventConsistencyVerifier;
    WindowInputEventReceiver mInputEventReceiver;
    InputQueue mInputQueue;
    InputQueue.Callback mInputQueueCallback;
    final InvalidateOnAnimationRunnable mInvalidateOnAnimationRunnable;
    boolean mIsAnimating;
    private boolean mIsCircularEmulator;
    boolean mIsCreating;
    boolean mIsDrawing;
    private boolean mIsEmulator;
    boolean mIsInTraversal;
    final Configuration mLastConfiguration;
    final ViewTreeObserver.InternalInsetsInfo mLastGivenInsets;
    boolean mLastInCompatMode = false;
    boolean mLastOverscanRequested;
    WeakReference<View> mLastScrolledFocus;
    int mLastSystemUiVisibility;
    final PointF mLastTouchPoint;
    boolean mLastWasImTarget;
    boolean mLayoutRequested;
    ArrayList<View> mLayoutRequesters;
    volatile Object mLocalDragState;
    final WindowLeaked mLocation;
    private boolean mMediaDisabled;
    boolean mNewSurfaceNeeded;
    private final int mNoncompatDensity;
    int mOrigWindowType = -1;
    final Configuration mPendingConfiguration;
    final Rect mPendingContentInsets;
    int mPendingInputEventCount;
    QueuedInputEvent mPendingInputEventHead;
    String mPendingInputEventQueueLengthCounterName = "pq";
    QueuedInputEvent mPendingInputEventTail;
    final Rect mPendingOverscanInsets;
    final Rect mPendingStableInsets;
    private ArrayList<LayoutTransition> mPendingTransitions;
    final Rect mPendingVisibleInsets;
    final Region mPreviousTransparentRegion;
    boolean mProcessInputEventsScheduled;
    private boolean mProfile;
    private boolean mProfileRendering;
    private QueuedInputEvent mQueuedInputEventPool;
    private int mQueuedInputEventPoolSize;
    private boolean mRemoved;
    private Choreographer.FrameCallback mRenderProfiler;
    private boolean mRenderProfilingEnabled;
    boolean mReportNextDraw;
    int mResizeAlpha;
    HardwareLayer mResizeBuffer;
    int mResizeBufferDuration;
    long mResizeBufferStartTime;
    final Paint mResizePaint;
    boolean mScrollMayChange;
    int mScrollY;
    Scroller mScroller;
    SendWindowContentChangedAccessibilityEvent mSendWindowContentChangedAccessibilityEvent;
    int mSeq;
    int mSoftInputMode;
    boolean mStopped = false;
    private final Surface mSurface;
    BaseSurfaceHolder mSurfaceHolder;
    SurfaceHolder.Callback2 mSurfaceHolderCallback;
    InputStage mSyntheticInputStage;
    final int mTargetSdkVersion;
    HashSet<View> mTempHashSet;
    final Rect mTempRect;
    final Thread mThread;
    final int[] mTmpLocation = new int[2];
    final TypedValue mTmpValue = new TypedValue();
    CompatibilityInfo.Translator mTranslator;
    final Region mTransparentRegion;
    int mTraversalBarrier;
    final TraversalRunnable mTraversalRunnable;
    boolean mTraversalScheduled;
    boolean mUnbufferedInputDispatch;
    View mView;
    final ViewConfiguration mViewConfiguration;
    private int mViewLayoutDirectionInitial;
    int mViewVisibility;
    final Rect mVisRect;
    int mWidth;
    boolean mWillDrawSoon;
    final Rect mWinFrame;
    final W mWindow;
    final WindowManager.LayoutParams mWindowAttributes = new WindowManager.LayoutParams();
    boolean mWindowAttributesChanged = false;
    int mWindowAttributesChangesFlag = 0;
    private final boolean mWindowIsRound;
    final IWindowSession mWindowSession;
    boolean mWindowsAnimating;

    static {
        sRunQueues = new ThreadLocal();
        sFirstDrawHandlers = new ArrayList();
        sFirstDrawComplete = false;
        sConfigCallbacks = new ArrayList();
        mResizeInterpolator = new AccelerateDecelerateInterpolator();
    }

    /*
     * Enabled aggressive block sorting
     */
    public ViewRootImpl(Context context, Display display) {
        this.mSurface = new Surface();
        this.mPendingOverscanInsets = new Rect();
        this.mPendingVisibleInsets = new Rect();
        this.mPendingStableInsets = new Rect();
        this.mPendingContentInsets = new Rect();
        this.mLastGivenInsets = new ViewTreeObserver.InternalInsetsInfo();
        this.mDispatchContentInsets = new Rect();
        this.mDispatchStableInsets = new Rect();
        this.mLastConfiguration = new Configuration();
        this.mPendingConfiguration = new Configuration();
        this.mDragPoint = new PointF();
        this.mLastTouchPoint = new PointF();
        this.mLayoutRequesters = new ArrayList();
        InputEventConsistencyVerifier inputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
        this.mInputEventConsistencyVerifier = inputEventConsistencyVerifier;
        this.mProfile = false;
        this.mDisplayListener = new DisplayManager.DisplayListener(){

            private int toViewScreenState(int n) {
                int n2 = 1;
                if (n == n2) {
                    n2 = 0;
                }
                return n2;
            }

            @Override
            public void onDisplayAdded(int n) {
            }

            @Override
            public void onDisplayChanged(int n) {
                int n2;
                int n3;
                if (ViewRootImpl.this.mView != null && ViewRootImpl.this.mDisplay.getDisplayId() == n && (n3 = ViewRootImpl.this.mAttachInfo.mDisplayState) != (n2 = ViewRootImpl.this.mDisplay.getState())) {
                    ViewRootImpl.this.mAttachInfo.mDisplayState = n2;
                    if (n3 != 0) {
                        int n4;
                        int n5 = this.toViewScreenState(n3);
                        if (n5 != (n4 = this.toViewScreenState(n2))) {
                            ViewRootImpl.this.mView.dispatchScreenStateChanged(n4);
                        }
                        if (n3 == 1) {
                            ViewRootImpl.this.mFullRedrawNeeded = true;
                            ViewRootImpl.this.scheduleTraversals();
                        }
                    }
                }
            }

            @Override
            public void onDisplayRemoved(int n) {
            }
        };
        this.mResizePaint = new Paint();
        this.mHandler = new ViewRootHandler();
        this.mTraversalRunnable = new TraversalRunnable();
        this.mConsumedBatchedInputRunnable = new ConsumeBatchedInputRunnable();
        this.mConsumeBatchedInputImmediatelyRunnable = new ConsumeBatchedInputImmediatelyRunnable();
        this.mInvalidateOnAnimationRunnable = new InvalidateOnAnimationRunnable();
        this.mContext = context;
        this.mWindowSession = WindowManagerGlobal.getWindowSession();
        this.mDisplay = display;
        this.mBasePackageName = context.getBasePackageName();
        this.mDisplayAdjustments = display.getDisplayAdjustments();
        this.mThread = Thread.currentThread();
        this.mLocation = new WindowLeaked(null);
        this.mLocation.fillInStackTrace();
        this.mWidth = -1;
        this.mHeight = -1;
        this.mDirty = new Rect();
        this.mTempRect = new Rect();
        this.mVisRect = new Rect();
        this.mWinFrame = new Rect();
        this.mWindow = new W(this);
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        this.mViewVisibility = 8;
        this.mTransparentRegion = new Region();
        this.mPreviousTransparentRegion = new Region();
        this.mFirst = true;
        this.mAdded = false;
        this.mAttachInfo = new View.AttachInfo(this.mWindowSession, this.mWindow, display, this, this.mHandler, this);
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
        this.mAccessibilityInteractionConnectionManager = new AccessibilityInteractionConnectionManager();
        this.mAccessibilityManager.addAccessibilityStateChangeListener(this.mAccessibilityInteractionConnectionManager);
        this.mHighContrastTextManager = new HighContrastTextManager();
        this.mAccessibilityManager.addHighTextContrastStateChangeListener(this.mHighContrastTextManager);
        this.mViewConfiguration = ViewConfiguration.get(context);
        this.mDensity = context.getResources().getDisplayMetrics().densityDpi;
        this.mNoncompatDensity = context.getResources().getDisplayMetrics().noncompatDensityDpi;
        this.mFallbackEventHandler = PolicyManager.makeNewFallbackEventHandler(context);
        this.mChoreographer = Choreographer.getInstance();
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
        this.loadSystemProperties();
        this.mWindowIsRound = context.getResources().getBoolean(17956973);
    }

    static /* synthetic */ boolean access$1802(ViewRootImpl viewRootImpl, boolean bl) {
        viewRootImpl.mProfileRendering = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1902(ViewRootImpl viewRootImpl, boolean bl) {
        viewRootImpl.mMediaDisabled = bl;
        return bl;
    }

    static /* synthetic */ void access$200(View view) {
        ViewRootImpl.forceLayout(view);
    }

    static /* synthetic */ boolean access$2002(ViewRootImpl viewRootImpl, boolean bl) {
        viewRootImpl.mIsEmulator = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2102(ViewRootImpl viewRootImpl, boolean bl) {
        viewRootImpl.mIsCircularEmulator = bl;
        return bl;
    }

    static /* synthetic */ boolean access$400(ViewRootImpl viewRootImpl, boolean bl) {
        return viewRootImpl.ensureTouchModeLocally(bl);
    }

    static /* synthetic */ Surface access$500(ViewRootImpl viewRootImpl) {
        return viewRootImpl.mSurface;
    }

    static /* synthetic */ void access$700(ViewRootImpl viewRootImpl, DragEvent dragEvent) {
        viewRootImpl.handleDragEvent(dragEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addConfigCallback(ComponentCallbacks componentCallbacks) {
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            sConfigCallbacks.add(componentCallbacks);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addFirstDrawHandler(Runnable runnable) {
        ArrayList<Runnable> arrayList = sFirstDrawHandlers;
        synchronized (arrayList) {
            if (!sFirstDrawComplete) {
                sFirstDrawHandlers.add(runnable);
            }
            return;
        }
    }

    private void applyKeepScreenOnFlag(WindowManager.LayoutParams layoutParams) {
        if (this.mAttachInfo.mKeepScreenOn) {
            layoutParams.flags = 0x80 | layoutParams.flags;
            return;
        }
        layoutParams.flags = 0xFFFFFF7F & layoutParams.flags | 0x80 & this.mClientWindowLayoutFlags;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkForLeavingTouchModeAndConsume(KeyEvent keyEvent) {
        block5: {
            block4: {
                int n;
                if (!this.mAttachInfo.mInTouchMode || (n = keyEvent.getAction()) != 0 && n != 2 || (4 & keyEvent.getFlags()) != 0) break block4;
                if (ViewRootImpl.isNavigationKey(keyEvent)) {
                    return this.ensureTouchMode(false);
                }
                if (ViewRootImpl.isTypingKey(keyEvent)) break block5;
            }
            return false;
        }
        this.ensureTouchMode(false);
        return false;
    }

    private boolean collectViewAttributes() {
        boolean bl;
        block2: {
            WindowManager.LayoutParams layoutParams;
            block3: {
                boolean bl2 = this.mAttachInfo.mRecomputeGlobalAttributes;
                bl = false;
                if (!bl2) break block2;
                this.mAttachInfo.mRecomputeGlobalAttributes = false;
                boolean bl3 = this.mAttachInfo.mKeepScreenOn;
                this.mAttachInfo.mKeepScreenOn = false;
                this.mAttachInfo.mSystemUiVisibility = 0;
                this.mAttachInfo.mHasSystemUiListeners = false;
                this.mView.dispatchCollectViewAttributes(this.mAttachInfo, 0);
                View.AttachInfo attachInfo = this.mAttachInfo;
                attachInfo.mSystemUiVisibility &= 0xFFFFFFFF ^ this.mAttachInfo.mDisabledSystemUiVisibility;
                layoutParams = this.mWindowAttributes;
                View.AttachInfo attachInfo2 = this.mAttachInfo;
                attachInfo2.mSystemUiVisibility |= this.getImpliedSystemUiVisibility(layoutParams);
                if (this.mAttachInfo.mKeepScreenOn != bl3 || this.mAttachInfo.mSystemUiVisibility != layoutParams.subtreeSystemUiVisibility) break block3;
                boolean bl4 = this.mAttachInfo.mHasSystemUiListeners;
                boolean bl5 = layoutParams.hasSystemUiListeners;
                bl = false;
                if (bl4 == bl5) break block2;
            }
            this.applyKeepScreenOnFlag(layoutParams);
            layoutParams.subtreeSystemUiVisibility = this.mAttachInfo.mSystemUiVisibility;
            layoutParams.hasSystemUiListeners = this.mAttachInfo.mHasSystemUiListeners;
            this.mView.dispatchWindowSystemUiVisiblityChanged(this.mAttachInfo.mSystemUiVisibility);
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void deliverInputEvent(QueuedInputEvent queuedInputEvent) {
        InputStage inputStage;
        Trace.asyncTraceBegin(8L, "deliverInputEvent", queuedInputEvent.mEvent.getSequenceNumber());
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onInputEvent(queuedInputEvent.mEvent, 0);
        }
        if ((inputStage = queuedInputEvent.shouldSendToSynthesizer() ? this.mSyntheticInputStage : (queuedInputEvent.shouldSkipIme() ? this.mFirstPostImeInputStage : this.mFirstInputStage)) != null) {
            inputStage.deliver(queuedInputEvent);
            return;
        }
        this.finishInputEvent(queuedInputEvent);
    }

    private void destroyHardwareRenderer() {
        HardwareRenderer hardwareRenderer = this.mAttachInfo.mHardwareRenderer;
        if (hardwareRenderer != null) {
            if (this.mView != null) {
                hardwareRenderer.destroyHardwareResources(this.mView);
            }
            hardwareRenderer.destroy();
            hardwareRenderer.setRequested(false);
            this.mAttachInfo.mHardwareRenderer = null;
            this.mAttachInfo.mHardwareAccelerated = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void draw(boolean bl) {
        boolean bl2;
        int n;
        Surface surface = this.mSurface;
        if (!surface.isValid()) return;
        if (!sFirstDrawComplete) {
            ArrayList<Runnable> arrayList = sFirstDrawHandlers;
            synchronized (arrayList) {
                sFirstDrawComplete = true;
                int n2 = sFirstDrawHandlers.size();
                for (int i = 0; i < n2; ++i) {
                    this.mHandler.post(sFirstDrawHandlers.get(i));
                }
            }
        }
        this.scrollToRectOrFocus(null, false);
        if (this.mAttachInfo.mViewScrollChanged) {
            this.mAttachInfo.mViewScrollChanged = false;
            this.mAttachInfo.mTreeObserver.dispatchOnScrollChanged();
        }
        if (this.mCurScrollY != (n = (bl2 = this.mScroller != null && this.mScroller.computeScrollOffset()) ? this.mScroller.getCurrY() : this.mScrollY)) {
            this.mCurScrollY = n;
            bl = true;
        }
        float f = this.mAttachInfo.mApplicationScale;
        boolean bl3 = this.mAttachInfo.mScalingRequired;
        HardwareLayer hardwareLayer = this.mResizeBuffer;
        int n3 = 0;
        if (hardwareLayer != null) {
            long l = SystemClock.uptimeMillis() - this.mResizeBufferStartTime;
            if (l < (long)this.mResizeBufferDuration) {
                float f2 = (float)l / (float)this.mResizeBufferDuration;
                float f3 = mResizeInterpolator.getInterpolation(f2);
                bl2 = true;
                n3 = 255 - (int)(255.0f * f3);
            } else {
                this.disposeResizeBuffer();
                n3 = 0;
            }
        }
        Rect rect = this.mDirty;
        if (this.mSurfaceHolder != null) {
            rect.setEmpty();
            if (!bl2) return;
            if (this.mScroller != null) {
                this.mScroller.abortAnimation();
            }
            this.disposeResizeBuffer();
            return;
        }
        if (bl) {
            this.mAttachInfo.mIgnoreDirtyState = true;
            rect.set(0, 0, (int)(0.5f + f * (float)this.mWidth), (int)(0.5f + f * (float)this.mHeight));
        }
        this.mAttachInfo.mTreeObserver.dispatchOnDraw();
        int n4 = n;
        WindowManager.LayoutParams layoutParams = this.mWindowAttributes;
        Rect rect2 = layoutParams != null ? layoutParams.surfaceInsets : null;
        int n5 = 0;
        if (rect2 != null) {
            n5 = 0 - rect2.left;
            n4 -= rect2.top;
            rect.offset(rect2.left, rect2.right);
        }
        if (!rect.isEmpty() || this.mIsAnimating) {
            if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled()) {
                this.mIsAnimating = false;
                if (this.mHardwareYOffset != n4 || this.mHardwareXOffset != n5) {
                    this.mHardwareYOffset = n4;
                    this.mHardwareXOffset = n5;
                    this.mAttachInfo.mHardwareRenderer.invalidateRoot();
                }
                this.mResizeAlpha = n3;
                rect.setEmpty();
                this.mBlockResizeBuffer = false;
                this.mAttachInfo.mHardwareRenderer.draw(this.mView, this.mAttachInfo, this);
            } else {
                if (this.mAttachInfo.mHardwareRenderer != null && !this.mAttachInfo.mHardwareRenderer.isEnabled() && this.mAttachInfo.mHardwareRenderer.isRequested()) {
                    try {
                        this.mAttachInfo.mHardwareRenderer.initializeIfNeeded(this.mWidth, this.mHeight, this.mSurface, rect2);
                        this.mFullRedrawNeeded = true;
                    }
                    catch (Surface.OutOfResourcesException outOfResourcesException) {
                        this.handleOutOfResourcesException(outOfResourcesException);
                        return;
                    }
                    this.scheduleTraversals();
                    return;
                }
                if (!this.drawSoftware(surface, this.mAttachInfo, n5, n4, bl3, rect)) {
                    return;
                }
            }
        }
        if (!bl2) {
            return;
        }
        this.mFullRedrawNeeded = true;
        this.scheduleTraversals();
    }

    /*
     * Exception decompiling
     */
    private boolean drawSoftware(Surface var1_1, View.AttachInfo var2_2, int var3_3, int var4_4, boolean var5_5, Rect var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dumpViewHierarchy(String string2, PrintWriter printWriter, View view) {
        printWriter.print(string2);
        if (view == null) {
            printWriter.println("null");
            return;
        } else {
            ViewGroup viewGroup;
            int n;
            printWriter.println(view.toString());
            if (!(view instanceof ViewGroup) || (n = (viewGroup = (ViewGroup)view).getChildCount()) <= 0) return;
            String string3 = string2 + "  ";
            for (int i = 0; i < n; ++i) {
                this.dumpViewHierarchy(string3, printWriter, viewGroup.getChildAt(i));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enableHardwareAcceleration(WindowManager.LayoutParams layoutParams) {
        this.mAttachInfo.mHardwareAccelerated = false;
        this.mAttachInfo.mHardwareAccelerationRequested = false;
        if (this.mTranslator != null) return;
        if ((0x1000000 & layoutParams.flags) == 0) return;
        boolean bl = true;
        if (!bl) return;
        if (!HardwareRenderer.isAvailable()) return;
        boolean bl2 = (1 & layoutParams.privateFlags) != 0;
        boolean bl3 = (2 & layoutParams.privateFlags) != 0;
        if (bl2) {
            this.mAttachInfo.mHardwareAccelerationRequested = true;
            return;
        }
        if (HardwareRenderer.sRendererDisabled) {
            if (!HardwareRenderer.sSystemRendererDisabled) return;
            if (!bl3) return;
        }
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.destroy();
        }
        boolean bl4 = layoutParams.format != -1;
        this.mAttachInfo.mHardwareRenderer = HardwareRenderer.create(this.mContext, bl4);
        if (this.mAttachInfo.mHardwareRenderer == null) {
            return;
        }
        this.mAttachInfo.mHardwareRenderer.setName(layoutParams.getTitle().toString());
        View.AttachInfo attachInfo = this.mAttachInfo;
        this.mAttachInfo.mHardwareAccelerationRequested = true;
        attachInfo.mHardwareAccelerated = true;
    }

    private boolean ensureTouchModeLocally(boolean bl) {
        if (this.mAttachInfo.mInTouchMode == bl) {
            return false;
        }
        this.mAttachInfo.mInTouchMode = bl;
        this.mAttachInfo.mTreeObserver.dispatchOnTouchModeChanged(bl);
        if (bl) {
            return this.enterTouchMode();
        }
        return this.leaveTouchMode();
    }

    private boolean enterTouchMode() {
        View view;
        if (this.mView != null && this.mView.hasFocus() && (view = this.mView.findFocus()) != null && !view.isFocusableInTouchMode()) {
            ViewGroup viewGroup = ViewRootImpl.findAncestorToTakeFocusInTouchMode(view);
            if (viewGroup != null) {
                return viewGroup.requestFocus();
            }
            view.clearFocusInternal(null, true, false);
            return true;
        }
        return false;
    }

    private static ViewGroup findAncestorToTakeFocusInTouchMode(View view) {
        ViewParent viewParent = view.getParent();
        while (viewParent instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup.getDescendantFocusability() == 262144 && viewGroup.isFocusableInTouchMode()) {
                return viewGroup;
            }
            if (viewGroup.isRootNamespace()) {
                return null;
            }
            viewParent = viewGroup.getParent();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void finishInputEvent(QueuedInputEvent queuedInputEvent) {
        Trace.asyncTraceEnd(8L, "deliverInputEvent", queuedInputEvent.mEvent.getSequenceNumber());
        if (queuedInputEvent.mReceiver != null) {
            boolean bl = (8 & queuedInputEvent.mFlags) != 0;
            queuedInputEvent.mReceiver.finishInputEvent(queuedInputEvent.mEvent, bl);
        } else {
            queuedInputEvent.mEvent.recycleIfNeededAfterDispatch();
        }
        this.recycleQueuedInputEvent(queuedInputEvent);
    }

    private static void forceLayout(View view) {
        view.forceLayout();
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                ViewRootImpl.forceLayout(viewGroup.getChildAt(i));
            }
        }
    }

    private AudioManager getAudioManager() {
        if (this.mView == null) {
            throw new IllegalStateException("getAudioManager called when there is no mView");
        }
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mView.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    private View getCommonPredecessor(View view, View view2) {
        if (this.mTempHashSet == null) {
            this.mTempHashSet = new HashSet();
        }
        HashSet<View> hashSet = this.mTempHashSet;
        hashSet.clear();
        View view3 = view;
        while (view3 != null) {
            hashSet.add(view3);
            ViewParent viewParent = view3.mParent;
            if (viewParent instanceof View) {
                view3 = (View)((Object)viewParent);
                continue;
            }
            view3 = null;
        }
        View view4 = view2;
        while (view4 != null) {
            if (hashSet.contains(view4)) {
                hashSet.clear();
                return view4;
            }
            ViewParent viewParent = view4.mParent;
            if (viewParent instanceof View) {
                view4 = (View)((Object)viewParent);
                continue;
            }
            view4 = null;
        }
        hashSet.clear();
        return null;
    }

    private static void getGfxInfo(View view, int[] nArray) {
        RenderNode renderNode = view.mRenderNode;
        nArray[0] = 1 + nArray[0];
        if (renderNode != null) {
            nArray[1] = nArray[1] + renderNode.getDebugSize();
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                ViewRootImpl.getGfxInfo(viewGroup.getChildAt(i), nArray);
            }
        }
    }

    private int getImpliedSystemUiVisibility(WindowManager.LayoutParams layoutParams) {
        int n = 0x4000000 & layoutParams.flags;
        int n2 = 0;
        if (n != 0) {
            n2 = 0 | 0x500;
        }
        if ((0x8000000 & layoutParams.flags) != 0) {
            n2 |= 0x300;
        }
        return n2;
    }

    private static int getRootMeasureSpec(int n, int n2) {
        switch (n2) {
            default: {
                return View.MeasureSpec.makeMeasureSpec(n2, 0x40000000);
            }
            case -1: {
                return View.MeasureSpec.makeMeasureSpec(n, 0x40000000);
            }
            case -2: 
        }
        return View.MeasureSpec.makeMeasureSpec(n, Integer.MIN_VALUE);
    }

    static RunQueue getRunQueue() {
        RunQueue runQueue = sRunQueues.get();
        if (runQueue != null) {
            return runQueue;
        }
        RunQueue runQueue2 = new RunQueue();
        sRunQueues.set(runQueue2);
        return runQueue2;
    }

    private ArrayList<View> getValidLayoutRequesters(ArrayList<View> arrayList, boolean bl) {
        int n = arrayList.size();
        ArrayList<View> arrayList2 = null;
        block0: for (int i = 0; i < n; ++i) {
            View view = arrayList.get(i);
            if (view == null || view.mAttachInfo == null || view.mParent == null || !bl && (0x1000 & view.mPrivateFlags) != 4096) continue;
            View view2 = view;
            while (true) {
                block12: {
                    boolean bl2;
                    block11: {
                        bl2 = false;
                        if (view2 == null) break block11;
                        if ((0xC & view2.mViewFlags) != 8) break block12;
                        bl2 = true;
                    }
                    if (bl2) continue block0;
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<View>();
                    }
                    arrayList2.add(view);
                    continue block0;
                }
                if (view2.mParent instanceof View) {
                    view2 = (View)((Object)view2.mParent);
                    continue;
                }
                view2 = null;
            }
        }
        if (!bl) {
            for (int i = 0; i < n; ++i) {
                View view = arrayList.get(i);
                while (view != null && (0x1000 & view.mPrivateFlags) != 0) {
                    view.mPrivateFlags = 0xFFFFEFFF & view.mPrivateFlags;
                    if (view.mParent instanceof View) {
                        view = (View)((Object)view.mParent);
                        continue;
                    }
                    view = null;
                }
            }
        }
        arrayList.clear();
        return arrayList2;
    }

    /*
     * Unable to fully structure code
     */
    private void handleDragEvent(DragEvent var1_1) {
        block18: {
            block17: {
                block16: {
                    if (this.mView == null || !this.mAdded) break block16;
                    var2_2 = var1_1.mAction;
                    if (var2_2 != 6) break block17;
                    this.mView.dispatchDragEvent(var1_1);
                }
lbl7:
                // 3 sources

                while (true) {
                    var1_1.recycle();
                    return;
                }
            }
            if (var2_2 != 1) break block18;
            this.mCurrentDragView = null;
            this.mDragDescription = var1_1.mClipDescription;
lbl14:
            // 2 sources

            while (true) {
                block15: {
                    if (var2_2 == 2 || var2_2 == 3) {
                        this.mDragPoint.set(var1_1.mX, var1_1.mY);
                        if (this.mTranslator != null) {
                            this.mTranslator.translatePointInScreenToAppWindow(this.mDragPoint);
                        }
                        if (this.mCurScrollY != 0) {
                            this.mDragPoint.offset(0.0f, this.mCurScrollY);
                        }
                        var1_1.mX = this.mDragPoint.x;
                        var1_1.mY = this.mDragPoint.y;
                    }
                    var3_3 = this.mCurrentDragView;
                    var4_4 = this.mView.dispatchDragEvent(var1_1);
                    if (var3_3 == this.mCurrentDragView) break block15;
                    if (var3_3 == null) ** GOTO lbl29
                    this.mWindowSession.dragRecipientExited(this.mWindow);
lbl29:
                    // 2 sources

                    if (this.mCurrentDragView == null) break block15;
                    this.mWindowSession.dragRecipientEntered(this.mWindow);
                }
lbl32:
                // 2 sources

                while (true) {
                    if (var2_2 == 3) {
                        this.mDragDescription = null;
                        Log.i("ViewRootImpl", "Reporting drop result: " + var4_4);
                        this.mWindowSession.reportDropResult(this.mWindow, var4_4);
                    }
lbl39:
                    // 4 sources

                    while (true) {
                        if (var2_2 != 4) ** GOTO lbl7
                        this.setLocalDragState(null);
                        ** continue;
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var1_1.mClipDescription = this.mDragDescription;
        ** while (true)
        catch (RemoteException var8_5) {
            Slog.e("ViewRootImpl", "Unable to note drag target change");
            ** continue;
        }
        catch (RemoteException var5_6) {
            Log.e("ViewRootImpl", "Unable to report drop result");
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleOutOfResourcesException(Surface.OutOfResourcesException outOfResourcesException) {
        Log.e(TAG, "OutOfResourcesException initializing HW surface", outOfResourcesException);
        try {
            if (!this.mWindowSession.outOfMemory(this.mWindow) && Process.myUid() != 1000) {
                Slog.w(TAG, "No processes killed for memory; killing self");
                Process.killProcess(Process.myPid());
            }
        }
        catch (RemoteException remoteException) {}
        this.mLayoutRequested = true;
    }

    private boolean isInLocalFocusMode() {
        return (0x10000000 & this.mWindowAttributes.flags) != 0;
    }

    static boolean isInTouchMode() {
        IWindowSession iWindowSession = WindowManagerGlobal.peekWindowSession();
        if (iWindowSession != null) {
            try {
                boolean bl = iWindowSession.getInTouchMode();
                return bl;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isNavigationKey(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            default: {
                return false;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 61: 
            case 62: 
            case 66: 
            case 92: 
            case 93: 
            case 122: 
            case 123: 
        }
        return true;
    }

    static boolean isTerminalInputEvent(InputEvent inputEvent) {
        boolean bl;
        block5: {
            block4: {
                if (inputEvent instanceof KeyEvent) {
                    return ((KeyEvent)inputEvent).getAction() == 1;
                }
                int n = ((MotionEvent)inputEvent).getAction();
                if (n == 1 || n == 3) break block4;
                bl = false;
                if (n != 10) break block5;
            }
            bl = true;
        }
        return bl;
    }

    private static boolean isTypingKey(KeyEvent keyEvent) {
        return keyEvent.getUnicodeChar() > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isViewDescendantOf(View view, View view2) {
        ViewParent viewParent;
        return view == view2 || (viewParent = view.getParent()) instanceof ViewGroup && ViewRootImpl.isViewDescendantOf((View)((Object)viewParent), view2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean leaveTouchMode() {
        View view;
        View view2;
        if (this.mView == null || this.mView.hasFocus() && (!((view2 = this.mView.findFocus()) instanceof ViewGroup) || ((ViewGroup)view2).getDescendantFocusability() != 262144) || (view = this.focusSearch(null, 130)) == null) {
            return false;
        }
        return view.requestFocus(130);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean measureHierarchy(View view, WindowManager.LayoutParams layoutParams, Resources resources, int n, int n2) {
        int n3 = layoutParams.width;
        boolean bl = false;
        if (n3 == -2) {
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            resources.getValue(17104905, this.mTmpValue, true);
            int n4 = this.mTmpValue.type;
            int n5 = 0;
            if (n4 == 5) {
                n5 = (int)this.mTmpValue.getDimension(displayMetrics);
            }
            bl = false;
            if (n5 != 0) {
                bl = false;
                if (n > n5) {
                    int n6 = ViewRootImpl.getRootMeasureSpec(n5, layoutParams.width);
                    int n7 = ViewRootImpl.getRootMeasureSpec(n2, layoutParams.height);
                    this.performMeasure(n6, n7);
                    if ((0x1000000 & view.getMeasuredWidthAndState()) == 0) {
                        return false;
                    }
                    this.performMeasure(ViewRootImpl.getRootMeasureSpec((n5 + n) / 2, layoutParams.width), n7);
                    int n8 = 0x1000000 & view.getMeasuredWidthAndState();
                    bl = false;
                    if (n8 == 0) {
                        return false;
                    }
                }
            }
        }
        boolean bl2 = false;
        if (bl) return bl2;
        this.performMeasure(ViewRootImpl.getRootMeasureSpec(n, layoutParams.width), ViewRootImpl.getRootMeasureSpec(n2, layoutParams.height));
        if (this.mWidth != view.getMeasuredWidth()) return true;
        int n9 = this.mHeight;
        int n10 = view.getMeasuredHeight();
        bl2 = false;
        if (n9 == n10) return bl2;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private QueuedInputEvent obtainQueuedInputEvent(InputEvent inputEvent, InputEventReceiver inputEventReceiver, int n) {
        QueuedInputEvent queuedInputEvent = this.mQueuedInputEventPool;
        if (queuedInputEvent != null) {
            this.mQueuedInputEventPoolSize = -1 + this.mQueuedInputEventPoolSize;
            this.mQueuedInputEventPool = queuedInputEvent.mNext;
            queuedInputEvent.mNext = null;
        } else {
            queuedInputEvent = new QueuedInputEvent();
        }
        queuedInputEvent.mEvent = inputEvent;
        queuedInputEvent.mReceiver = inputEventReceiver;
        queuedInputEvent.mFlags = n;
        return queuedInputEvent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performDraw() {
        block16: {
            block14: {
                block13: {
                    block15: {
                        if (this.mAttachInfo.mDisplayState == 1 && !this.mReportNextDraw) break block14;
                        boolean bl = this.mFullRedrawNeeded;
                        this.mFullRedrawNeeded = false;
                        this.mIsDrawing = true;
                        Trace.traceBegin(8L, "draw");
                        this.draw(bl);
                        if (this.mAttachInfo.mPendingAnimatingRenderNodes == null) break block13;
                        int n = this.mAttachInfo.mPendingAnimatingRenderNodes.size();
                        for (int i = 0; i < n; ++i) {
                            this.mAttachInfo.mPendingAnimatingRenderNodes.get(i).endAllAnimators();
                        }
                        break block15;
                        finally {
                            this.mIsDrawing = false;
                            Trace.traceEnd(8L);
                        }
                    }
                    this.mAttachInfo.mPendingAnimatingRenderNodes.clear();
                }
                if (this.mReportNextDraw) break block16;
            }
            return;
        }
        this.mReportNextDraw = false;
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.fence();
        }
        if (this.mSurfaceHolder != null && this.mSurface.isValid()) {
            this.mSurfaceHolderCallback.surfaceRedrawNeeded(this.mSurfaceHolder);
            SurfaceHolder.Callback[] callbackArray = this.mSurfaceHolder.getCallbacks();
            if (callbackArray != null) {
                for (SurfaceHolder.Callback callback : callbackArray) {
                    if (!(callback instanceof SurfaceHolder.Callback2)) continue;
                    ((SurfaceHolder.Callback2)callback).surfaceRedrawNeeded(this.mSurfaceHolder);
                }
            }
        }
        try {
            this.mWindowSession.finishDrawing(this.mWindow);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private void performLayout(WindowManager.LayoutParams layoutParams, int n, int n2) {
        block8: {
            ArrayList<View> arrayList;
            this.mLayoutRequested = false;
            this.mScrollMayChange = true;
            this.mInLayout = true;
            View view = this.mView;
            Trace.traceBegin(8L, "layout");
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
            this.mInLayout = false;
            if (this.mLayoutRequesters.size() <= 0 || (arrayList = this.getValidLayoutRequesters(this.mLayoutRequesters, false)) == null) break block8;
            this.mHandlingLayoutInLayoutRequest = true;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                View view2 = arrayList.get(i);
                Log.w("View", "requestLayout() improperly called by " + view2 + " during layout: running second layout pass");
                view2.requestLayout();
                continue;
            }
            this.measureHierarchy(view, layoutParams, this.mView.getContext().getResources(), n, n2);
            this.mInLayout = true;
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
            this.mHandlingLayoutInLayoutRequest = false;
            final ArrayList<View> arrayList2 = this.getValidLayoutRequesters(this.mLayoutRequesters, true);
            if (arrayList2 == null) break block8;
            ViewRootImpl.getRunQueue().post(new Runnable(){

                @Override
                public void run() {
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        View view = (View)arrayList2.get(i);
                        Log.w("View", "requestLayout() improperly called by " + view + " during second layout pass: posting in next frame");
                        view.requestLayout();
                    }
                }
            });
        }
        this.mInLayout = false;
        return;
        finally {
            Trace.traceEnd(8L);
        }
    }

    private void performMeasure(int n, int n2) {
        Trace.traceBegin(8L, "measure");
        try {
            this.mView.measure(n, n2);
            return;
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    /*
     * Exception decompiling
     */
    private void performTraversals() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [29[CATCHBLOCK]], but top level block is 17[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void postSendWindowContentChangedCallback(View view, int n) {
        if (this.mSendWindowContentChangedAccessibilityEvent == null) {
            this.mSendWindowContentChangedAccessibilityEvent = new SendWindowContentChangedAccessibilityEvent();
        }
        this.mSendWindowContentChangedAccessibilityEvent.runOrPost(view, n);
    }

    private void profileRendering(boolean bl) {
        block6: {
            block5: {
                if (!this.mProfileRendering) break block5;
                this.mRenderProfilingEnabled = bl;
                if (this.mRenderProfiler != null) {
                    this.mChoreographer.removeFrameCallback(this.mRenderProfiler);
                }
                if (!this.mRenderProfilingEnabled) break block6;
                if (this.mRenderProfiler == null) {
                    this.mRenderProfiler = new Choreographer.FrameCallback(){

                        @Override
                        public void doFrame(long l) {
                            ViewRootImpl.this.mDirty.set(0, 0, ViewRootImpl.this.mWidth, ViewRootImpl.this.mHeight);
                            ViewRootImpl.this.scheduleTraversals();
                            if (ViewRootImpl.this.mRenderProfilingEnabled) {
                                ViewRootImpl.this.mChoreographer.postFrameCallback(ViewRootImpl.this.mRenderProfiler);
                            }
                        }
                    };
                }
                this.mChoreographer.postFrameCallback(this.mRenderProfiler);
            }
            return;
        }
        this.mRenderProfiler = null;
    }

    private void recycleQueuedInputEvent(QueuedInputEvent queuedInputEvent) {
        queuedInputEvent.mEvent = null;
        queuedInputEvent.mReceiver = null;
        if (this.mQueuedInputEventPoolSize < 10) {
            this.mQueuedInputEventPoolSize = 1 + this.mQueuedInputEventPoolSize;
            queuedInputEvent.mNext = this.mQueuedInputEventPool;
            this.mQueuedInputEventPool = queuedInputEvent;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int relayoutWindow(WindowManager.LayoutParams layoutParams, int n, boolean bl) throws RemoteException {
        float f = this.mAttachInfo.mApplicationScale;
        boolean bl2 = false;
        if (layoutParams != null) {
            CompatibilityInfo.Translator translator = this.mTranslator;
            bl2 = false;
            if (translator != null) {
                bl2 = true;
                layoutParams.backup();
                this.mTranslator.translateWindowLayout(layoutParams);
            }
        }
        if (layoutParams != null) {
            // empty if block
        }
        this.mPendingConfiguration.seq = 0;
        if (layoutParams != null && this.mOrigWindowType != layoutParams.type && this.mTargetSdkVersion < 14) {
            Slog.w(TAG, "Window type can not be changed after the window is added; ignoring change of " + this.mView);
            layoutParams.type = this.mOrigWindowType;
        }
        IWindowSession iWindowSession = this.mWindowSession;
        W w = this.mWindow;
        int n2 = this.mSeq;
        int n3 = (int)(0.5f + f * (float)this.mView.getMeasuredWidth());
        int n4 = (int)(0.5f + f * (float)this.mView.getMeasuredHeight());
        int n5 = bl ? 1 : 0;
        int n6 = iWindowSession.relayout(w, n2, layoutParams, n3, n4, n, n5, this.mWinFrame, this.mPendingOverscanInsets, this.mPendingContentInsets, this.mPendingVisibleInsets, this.mPendingStableInsets, this.mPendingConfiguration, this.mSurface);
        if (bl2) {
            layoutParams.restore();
        }
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWinFrame(this.mWinFrame);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingOverscanInsets);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingContentInsets);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingVisibleInsets);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingStableInsets);
        }
        return n6;
    }

    private void removeSendWindowContentChangedCallback() {
        if (this.mSendWindowContentChangedAccessibilityEvent != null) {
            this.mHandler.removeCallbacks(this.mSendWindowContentChangedAccessibilityEvent);
        }
    }

    private void scheduleProcessInputEvents() {
        if (!this.mProcessInputEventsScheduled) {
            this.mProcessInputEventsScheduled = true;
            Message message = this.mHandler.obtainMessage(19);
            message.setAsynchronous(true);
            this.mHandler.sendMessage(message);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void trackFPS() {
        long l = System.currentTimeMillis();
        if (this.mFpsStartTime < 0L) {
            this.mFpsPrevTime = l;
            this.mFpsStartTime = l;
            this.mFpsNumFrames = 0;
            return;
        } else {
            this.mFpsNumFrames = 1 + this.mFpsNumFrames;
            String string2 = Integer.toHexString(System.identityHashCode(this));
            long l2 = l - this.mFpsPrevTime;
            long l3 = l - this.mFpsStartTime;
            Log.v(TAG, "0x" + string2 + "\tFrame time:\t" + l2);
            this.mFpsPrevTime = l;
            if (l3 <= 1000L) return;
            float f = 1000.0f * (float)this.mFpsNumFrames / (float)l3;
            Log.v(TAG, "0x" + string2 + "\tFPS:\t" + f);
            this.mFpsStartTime = l;
            this.mFpsNumFrames = 0;
            return;
        }
    }

    @Override
    public void bringChildToFront(View view) {
    }

    @Override
    public boolean canResolveLayoutDirection() {
        return true;
    }

    @Override
    public boolean canResolveTextAlignment() {
        return true;
    }

    @Override
    public boolean canResolveTextDirection() {
        return true;
    }

    public void cancelInvalidate(View view) {
        this.mHandler.removeMessages(1, view);
        this.mHandler.removeMessages(2, view);
        this.mInvalidateOnAnimationRunnable.removeView(view);
    }

    void changeCanvasOpacity(boolean bl) {
        Log.d(TAG, "changeCanvasOpacity: opaque=" + bl);
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.setOpaque(bl);
        }
    }

    void checkThread() {
        if (this.mThread != Thread.currentThread()) {
            throw new CalledFromWrongThreadException("Only the original thread that created a view hierarchy can touch its views.");
        }
    }

    @Override
    public void childDrawableStateChanged(View view) {
    }

    @Override
    public void childHasTransientStateChanged(View view, boolean bl) {
    }

    @Override
    public void clearChildFocus(View view) {
        this.checkThread();
        this.scheduleTraversals();
    }

    @Override
    public void createContextMenu(ContextMenu contextMenu) {
    }

    public void debug() {
        this.mView.debug();
    }

    void destroyHardwareResources() {
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.destroyHardwareResources(this.mView);
            this.mAttachInfo.mHardwareRenderer.destroy();
        }
    }

    public void detachFunctor(long l) {
        this.mBlockResizeBuffer = true;
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.stopDrawing();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean die(boolean bl) {
        if (bl && !this.mIsInTraversal) {
            this.doDie();
            return false;
        }
        if (!this.mIsDrawing) {
            this.destroyHardwareRenderer();
        } else {
            Log.e(TAG, "Attempting to destroy the window while drawing!\n  window=" + this + ", title=" + this.mWindowAttributes.getTitle());
        }
        this.mHandler.sendEmptyMessage(3);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchAppVisibility(boolean bl) {
        Message message = this.mHandler.obtainMessage(8);
        int n = bl ? 1 : 0;
        message.arg1 = n;
        this.mHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    void dispatchApplyInsets(View view) {
        this.mDispatchContentInsets.set(this.mAttachInfo.mContentInsets);
        this.mDispatchStableInsets.set(this.mAttachInfo.mStableInsets);
        boolean bl = this.mIsEmulator && this.mIsCircularEmulator || this.mWindowIsRound;
        view.dispatchApplyWindowInsets(new WindowInsets(this.mDispatchContentInsets, null, this.mDispatchStableInsets, bl));
    }

    public void dispatchCheckFocus() {
        if (!this.mHandler.hasMessages(13)) {
            this.mHandler.sendEmptyMessage(13);
        }
    }

    public void dispatchCloseSystemDialogs(String string2) {
        Message message = Message.obtain();
        message.what = 14;
        message.obj = string2;
        this.mHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchDetachedFromWindow() {
        if (this.mView != null && this.mView.mAttachInfo != null) {
            this.mAttachInfo.mTreeObserver.dispatchOnWindowAttachedChange(false);
            this.mView.dispatchDetachedFromWindow();
        }
        this.mAccessibilityInteractionConnectionManager.ensureNoConnection();
        this.mAccessibilityManager.removeAccessibilityStateChangeListener(this.mAccessibilityInteractionConnectionManager);
        this.mAccessibilityManager.removeHighTextContrastStateChangeListener(this.mHighContrastTextManager);
        this.removeSendWindowContentChangedCallback();
        this.destroyHardwareRenderer();
        this.setAccessibilityFocus(null, null);
        this.mView.assignParent(null);
        this.mView = null;
        this.mAttachInfo.mRootView = null;
        this.mSurface.release();
        if (this.mInputQueueCallback != null && this.mInputQueue != null) {
            this.mInputQueueCallback.onInputQueueDestroyed(this.mInputQueue);
            this.mInputQueue.dispose();
            this.mInputQueueCallback = null;
            this.mInputQueue = null;
        }
        if (this.mInputEventReceiver != null) {
            this.mInputEventReceiver.dispose();
            this.mInputEventReceiver = null;
        }
        try {
            this.mWindowSession.remove(this.mWindow);
        }
        catch (RemoteException remoteException) {}
        if (this.mInputChannel != null) {
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }
        this.mDisplayManager.unregisterDisplayListener(this.mDisplayListener);
        this.unscheduleTraversals();
    }

    public void dispatchDoneAnimating() {
        this.mHandler.sendEmptyMessage(22);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchDragEvent(DragEvent dragEvent) {
        int n;
        if (dragEvent.getAction() == 2) {
            n = 16;
            this.mHandler.removeMessages(n);
        } else {
            n = 15;
        }
        Message message = this.mHandler.obtainMessage(n, dragEvent);
        this.mHandler.sendMessage(message);
    }

    public void dispatchFinishInputConnection(InputConnection inputConnection) {
        Message message = this.mHandler.obtainMessage(12, inputConnection);
        this.mHandler.sendMessage(message);
    }

    public void dispatchGetNewSurface() {
        Message message = this.mHandler.obtainMessage(9);
        this.mHandler.sendMessage(message);
    }

    public void dispatchInputEvent(InputEvent inputEvent) {
        this.dispatchInputEvent(inputEvent, null);
    }

    public void dispatchInputEvent(InputEvent inputEvent, InputEventReceiver inputEventReceiver) {
        SomeArgs someArgs = SomeArgs.obtain();
        someArgs.arg1 = inputEvent;
        someArgs.arg2 = inputEventReceiver;
        Message message = this.mHandler.obtainMessage(7, someArgs);
        message.setAsynchronous(true);
        this.mHandler.sendMessage(message);
    }

    public void dispatchInvalidateDelayed(View view, long l) {
        Message message = this.mHandler.obtainMessage(1, view);
        this.mHandler.sendMessageDelayed(message, l);
    }

    public void dispatchInvalidateOnAnimation(View view) {
        this.mInvalidateOnAnimationRunnable.addView(view);
    }

    public void dispatchInvalidateRectDelayed(View.AttachInfo.InvalidateInfo invalidateInfo, long l) {
        Message message = this.mHandler.obtainMessage(2, invalidateInfo);
        this.mHandler.sendMessageDelayed(message, l);
    }

    public void dispatchInvalidateRectOnAnimation(View.AttachInfo.InvalidateInfo invalidateInfo) {
        this.mInvalidateOnAnimationRunnable.addViewRect(invalidateInfo);
    }

    public void dispatchKeyFromIme(KeyEvent keyEvent) {
        Message message = this.mHandler.obtainMessage(11, keyEvent);
        message.setAsynchronous(true);
        this.mHandler.sendMessage(message);
    }

    public void dispatchMoved(int n, int n2) {
        if (this.mTranslator != null) {
            PointF pointF = new PointF(n, n2);
            this.mTranslator.translatePointInScreenToAppWindow(pointF);
            n = (int)(0.5 + (double)pointF.x);
            n2 = (int)(0.5 + (double)pointF.y);
        }
        Message message = this.mHandler.obtainMessage(24, n, n2);
        this.mHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchResized(Rect rect, Rect rect2, Rect rect3, Rect rect4, Rect rect5, boolean bl, Configuration configuration) {
        ViewRootHandler viewRootHandler = this.mHandler;
        int n = bl ? 5 : 4;
        Message message = viewRootHandler.obtainMessage(n);
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWindow(rect);
            this.mTranslator.translateRectInScreenToAppWindow(rect2);
            this.mTranslator.translateRectInScreenToAppWindow(rect3);
            this.mTranslator.translateRectInScreenToAppWindow(rect4);
        }
        SomeArgs someArgs = SomeArgs.obtain();
        boolean bl2 = Binder.getCallingPid() == Process.myPid();
        if (bl2) {
            rect = new Rect(rect);
        }
        someArgs.arg1 = rect;
        if (bl2) {
            rect3 = new Rect(rect3);
        }
        someArgs.arg2 = rect3;
        if (bl2) {
            rect4 = new Rect(rect4);
        }
        someArgs.arg3 = rect4;
        if (bl2 && configuration != null) {
            configuration = new Configuration(configuration);
        }
        someArgs.arg4 = configuration;
        if (bl2) {
            rect2 = new Rect(rect2);
        }
        someArgs.arg5 = rect2;
        if (bl2) {
            rect5 = new Rect(rect5);
        }
        someArgs.arg6 = rect5;
        message.obj = someArgs;
        this.mHandler.sendMessage(message);
    }

    public void dispatchSystemUiVisibilityChanged(int n, int n2, int n3, int n4) {
        SystemUiVisibilityInfo systemUiVisibilityInfo = new SystemUiVisibilityInfo();
        systemUiVisibilityInfo.seq = n;
        systemUiVisibilityInfo.globalVisibility = n2;
        systemUiVisibilityInfo.localValue = n3;
        systemUiVisibilityInfo.localChanges = n4;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(17, systemUiVisibilityInfo));
    }

    public void dispatchUnhandledInputEvent(InputEvent inputEvent) {
        if (inputEvent instanceof MotionEvent) {
            inputEvent = MotionEvent.obtain((MotionEvent)inputEvent);
        }
        this.synthesizeInputEvent(inputEvent);
    }

    void disposeResizeBuffer() {
        if (this.mResizeBuffer != null) {
            this.mResizeBuffer.destroy();
            this.mResizeBuffer = null;
        }
    }

    void doConsumeBatchedInput(long l) {
        if (this.mConsumeBatchedInputScheduled) {
            this.mConsumeBatchedInputScheduled = false;
            if (this.mInputEventReceiver != null && this.mInputEventReceiver.consumeBatchedInputEvents(l) && l != -1L) {
                this.scheduleConsumeBatchedInput();
            }
            this.doProcessInputEvents();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doDie() {
        boolean bl = true;
        this.checkThread();
        synchronized (this) {
            if (this.mRemoved) {
                return;
            }
            this.mRemoved = true;
            if (this.mAdded) {
                this.dispatchDetachedFromWindow();
            }
            if (this.mAdded && !this.mFirst) {
                this.destroyHardwareRenderer();
                if (this.mView != null) {
                    boolean bl2;
                    int n = this.mView.getVisibility();
                    if (this.mViewVisibility == n) {
                        bl = false;
                    }
                    if ((bl2 = this.mWindowAttributesChanged) || bl) {
                        try {
                            if ((2 & this.relayoutWindow(this.mWindowAttributes, n, false)) != 0) {
                                this.mWindowSession.finishDrawing(this.mWindow);
                            }
                        }
                        catch (RemoteException remoteException) {}
                    }
                    this.mSurface.release();
                }
            }
            this.mAdded = false;
        }
        WindowManagerGlobal.getInstance().doRemoveView(this);
    }

    void doProcessInputEvents() {
        while (this.mPendingInputEventHead != null) {
            QueuedInputEvent queuedInputEvent = this.mPendingInputEventHead;
            this.mPendingInputEventHead = queuedInputEvent.mNext;
            if (this.mPendingInputEventHead == null) {
                this.mPendingInputEventTail = null;
            }
            queuedInputEvent.mNext = null;
            this.mPendingInputEventCount = -1 + this.mPendingInputEventCount;
            Trace.traceCounter(4L, this.mPendingInputEventQueueLengthCounterName, this.mPendingInputEventCount);
            this.deliverInputEvent(queuedInputEvent);
        }
        if (this.mProcessInputEventsScheduled) {
            this.mProcessInputEventsScheduled = false;
            this.mHandler.removeMessages(19);
        }
    }

    void doTraversal() {
        block5: {
            if (this.mTraversalScheduled) {
                this.mTraversalScheduled = false;
                this.mHandler.getLooper().removeSyncBarrier(this.mTraversalBarrier);
                if (this.mProfile) {
                    Debug.startMethodTracing("ViewAncestor");
                }
                Trace.traceBegin(8L, "performTraversals");
                this.performTraversals();
                if (!this.mProfile) break block5;
                Debug.stopMethodTracing();
                this.mProfile = false;
            }
        }
        return;
        finally {
            Trace.traceEnd(8L);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = string2 + "  ";
        printWriter.print(string2);
        printWriter.println("ViewRoot:");
        printWriter.print(string3);
        printWriter.print("mAdded=");
        printWriter.print(this.mAdded);
        printWriter.print(" mRemoved=");
        printWriter.println(this.mRemoved);
        printWriter.print(string3);
        printWriter.print("mConsumeBatchedInputScheduled=");
        printWriter.println(this.mConsumeBatchedInputScheduled);
        printWriter.print(string3);
        printWriter.print("mConsumeBatchedInputImmediatelyScheduled=");
        printWriter.println(this.mConsumeBatchedInputImmediatelyScheduled);
        printWriter.print(string3);
        printWriter.print("mPendingInputEventCount=");
        printWriter.println(this.mPendingInputEventCount);
        printWriter.print(string3);
        printWriter.print("mProcessInputEventsScheduled=");
        printWriter.println(this.mProcessInputEventsScheduled);
        printWriter.print(string3);
        printWriter.print("mTraversalScheduled=");
        printWriter.print(this.mTraversalScheduled);
        if (this.mTraversalScheduled) {
            printWriter.print(" (barrier=");
            printWriter.print(this.mTraversalBarrier);
            printWriter.println(")");
        } else {
            printWriter.println();
        }
        this.mFirstInputStage.dump(string3, printWriter);
        this.mChoreographer.dump(string2, printWriter);
        printWriter.print(string2);
        printWriter.println("View Hierarchy:");
        this.dumpViewHierarchy(string3, printWriter, this.mView);
    }

    public void dumpGfxInfo(int[] nArray) {
        nArray[1] = 0;
        nArray[0] = 0;
        if (this.mView != null) {
            ViewRootImpl.getGfxInfo(this.mView, nArray);
        }
    }

    void enqueueInputEvent(InputEvent inputEvent) {
        this.enqueueInputEvent(inputEvent, null, 0, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    void enqueueInputEvent(InputEvent inputEvent, InputEventReceiver inputEventReceiver, int n, boolean bl) {
        QueuedInputEvent queuedInputEvent = this.obtainQueuedInputEvent(inputEvent, inputEventReceiver, n);
        QueuedInputEvent queuedInputEvent2 = this.mPendingInputEventTail;
        if (queuedInputEvent2 == null) {
            this.mPendingInputEventHead = queuedInputEvent;
            this.mPendingInputEventTail = queuedInputEvent;
        } else {
            queuedInputEvent2.mNext = queuedInputEvent;
            this.mPendingInputEventTail = queuedInputEvent;
        }
        this.mPendingInputEventCount = 1 + this.mPendingInputEventCount;
        Trace.traceCounter(4L, this.mPendingInputEventQueueLengthCounterName, this.mPendingInputEventCount);
        if (bl) {
            this.doProcessInputEvents();
            return;
        }
        this.scheduleProcessInputEvents();
    }

    boolean ensureTouchMode(boolean bl) {
        if (this.mAttachInfo.mInTouchMode == bl) {
            return false;
        }
        try {
            if (!this.isInLocalFocusMode()) {
                this.mWindowSession.setInTouchMode(bl);
            }
            return this.ensureTouchModeLocally(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    @Override
    public View focusSearch(View view, int n) {
        this.checkThread();
        if (!(this.mView instanceof ViewGroup)) {
            return null;
        }
        return FocusFinder.getInstance().findNextFocus((ViewGroup)this.mView, view, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void focusableViewAvailable(View view) {
        this.checkThread();
        if (this.mView == null) return;
        if (!this.mView.hasFocus()) {
            view.requestFocus();
            return;
        } else {
            View view2 = this.mView.findFocus();
            if (!(view2 instanceof ViewGroup) || ((ViewGroup)view2).getDescendantFocusability() != 262144 || !ViewRootImpl.isViewDescendantOf(view, view2)) return;
            view.requestFocus();
            return;
        }
    }

    Drawable getAccessibilityFocusedDrawable() {
        if (this.mAttachInfo.mAccessibilityFocusDrawable == null) {
            TypedValue typedValue = new TypedValue();
            if (this.mView.mContext.getTheme().resolveAttribute(16844044, typedValue, true)) {
                this.mAttachInfo.mAccessibilityFocusDrawable = this.mView.mContext.getDrawable(typedValue.resourceId);
            }
        }
        return this.mAttachInfo.mAccessibilityFocusDrawable;
    }

    public View getAccessibilityFocusedHost() {
        return this.mAccessibilityFocusedHost;
    }

    public AccessibilityNodeInfo getAccessibilityFocusedVirtualView() {
        return this.mAccessibilityFocusedVirtualView;
    }

    public AccessibilityInteractionController getAccessibilityInteractionController() {
        if (this.mView == null) {
            throw new IllegalStateException("getAccessibilityInteractionController called when there is no mView");
        }
        if (this.mAccessibilityInteractionController == null) {
            this.mAccessibilityInteractionController = new AccessibilityInteractionController(this);
        }
        return this.mAccessibilityInteractionController;
    }

    @Override
    public boolean getChildVisibleRect(View view, Rect rect, Point point) {
        if (view != this.mView) {
            throw new RuntimeException("child is not mine, honest!");
        }
        return rect.intersect(0, 0, this.mWidth, this.mHeight);
    }

    int getHostVisibility() {
        if (this.mAppVisible) {
            return this.mView.getVisibility();
        }
        return 8;
    }

    public void getLastTouchPoint(Point point) {
        point.x = (int)this.mLastTouchPoint.x;
        point.y = (int)this.mLastTouchPoint.y;
    }

    @Override
    public int getLayoutDirection() {
        return 0;
    }

    final WindowLeaked getLocation() {
        return this.mLocation;
    }

    @Override
    public ViewParent getParent() {
        return null;
    }

    @Override
    public ViewParent getParentForAccessibility() {
        return null;
    }

    @Override
    public int getTextAlignment() {
        return 1;
    }

    @Override
    public int getTextDirection() {
        return 1;
    }

    public View getView() {
        return this.mView;
    }

    void handleAppVisibility(boolean bl) {
        if (this.mAppVisible != bl) {
            this.mAppVisible = bl;
            this.scheduleTraversals();
            if (!this.mAppVisible) {
                WindowManagerGlobal.trimForeground();
            }
        }
    }

    public void handleDispatchDoneAnimating() {
        if (this.mWindowsAnimating) {
            this.mWindowsAnimating = false;
            if (!this.mDirty.isEmpty() || this.mIsAnimating || this.mFullRedrawNeeded) {
                this.scheduleTraversals();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleDispatchSystemUiVisibilityChanged(SystemUiVisibilityInfo systemUiVisibilityInfo) {
        int n;
        block6: {
            block5: {
                if (this.mSeq != systemUiVisibilityInfo.seq) {
                    this.mSeq = systemUiVisibilityInfo.seq;
                    this.mAttachInfo.mForceReportNewAttributes = true;
                    this.scheduleTraversals();
                }
                if (this.mView == null) break block5;
                if (systemUiVisibilityInfo.localChanges != 0) {
                    this.mView.updateLocalSystemUiVisibility(systemUiVisibilityInfo.localValue, systemUiVisibilityInfo.localChanges);
                }
                if ((n = 7 & systemUiVisibilityInfo.globalVisibility) != this.mAttachInfo.mGlobalSystemUiVisibility) break block6;
            }
            return;
        }
        this.mAttachInfo.mGlobalSystemUiVisibility = n;
        this.mView.dispatchSystemUiVisibilityChanged(n);
    }

    void handleGetNewSurface() {
        this.mNewSurfaceNeeded = true;
        this.mFullRedrawNeeded = true;
        this.scheduleTraversals();
    }

    void invalidate() {
        this.mDirty.set(0, 0, this.mWidth, this.mHeight);
        if (!this.mWillDrawSoon) {
            this.scheduleTraversals();
        }
    }

    @Override
    public void invalidateChild(View view, Rect rect) {
        this.invalidateChildInParent(null, rect);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ViewParent invalidateChildInParent(int[] nArray, Rect rect) {
        this.checkThread();
        if (rect == null) {
            this.invalidate();
            return null;
        } else {
            Rect rect2;
            if (rect.isEmpty() && !this.mIsAnimating) return null;
            if (this.mCurScrollY != 0 || this.mTranslator != null) {
                this.mTempRect.set(rect);
                rect = this.mTempRect;
                if (this.mCurScrollY != 0) {
                    rect.offset(0, -this.mCurScrollY);
                }
                if (this.mTranslator != null) {
                    this.mTranslator.translateRectInAppWindowToScreen(rect);
                }
                if (this.mAttachInfo.mScalingRequired) {
                    rect.inset(-1, -1);
                }
            }
            if (!(rect2 = this.mDirty).isEmpty() && !rect2.contains(rect)) {
                this.mAttachInfo.mSetIgnoreDirtyState = true;
                this.mAttachInfo.mIgnoreDirtyState = true;
            }
            rect2.union(rect.left, rect.top, rect.right, rect.bottom);
            float f = this.mAttachInfo.mApplicationScale;
            boolean bl = rect2.intersect(0, 0, (int)(0.5f + f * (float)this.mWidth), (int)(0.5f + f * (float)this.mHeight));
            if (!bl) {
                rect2.setEmpty();
            }
            if (this.mWillDrawSoon || !bl && !this.mIsAnimating) return null;
            this.scheduleTraversals();
            return null;
        }
    }

    void invalidateWorld(View view) {
        view.invalidate();
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                this.invalidateWorld(viewGroup.getChildAt(i));
            }
        }
    }

    public void invokeFunctor(long l, boolean bl) {
        ThreadedRenderer.invokeFunctor(l, bl);
    }

    boolean isInLayout() {
        return this.mInLayout;
    }

    @Override
    public boolean isLayoutDirectionResolved() {
        return true;
    }

    @Override
    public boolean isLayoutRequested() {
        return this.mLayoutRequested;
    }

    @Override
    public boolean isTextAlignmentResolved() {
        return true;
    }

    @Override
    public boolean isTextDirectionResolved() {
        return true;
    }

    public void loadSystemProperties() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                ViewRootImpl.access$1802(ViewRootImpl.this, SystemProperties.getBoolean(ViewRootImpl.PROPERTY_PROFILE_RENDERING, false));
                ViewRootImpl.this.profileRendering(ViewRootImpl.this.mAttachInfo.mHasWindowFocus);
                ViewRootImpl.access$1902(ViewRootImpl.this, SystemProperties.getBoolean(ViewRootImpl.PROPERTY_MEDIA_DISABLED, false));
                if (ViewRootImpl.this.mAttachInfo.mHardwareRenderer != null && ViewRootImpl.this.mAttachInfo.mHardwareRenderer.loadSystemProperties()) {
                    ViewRootImpl.this.invalidate();
                }
                if ((bl = SystemProperties.getBoolean("debug.layout", false)) != ViewRootImpl.this.mAttachInfo.mDebugLayout) {
                    ViewRootImpl.this.mAttachInfo.mDebugLayout = bl;
                    if (!ViewRootImpl.this.mHandler.hasMessages(23)) {
                        ViewRootImpl.this.mHandler.sendEmptyMessageDelayed(23, 200L);
                    }
                }
                ViewRootImpl.access$2002(ViewRootImpl.this, Build.HARDWARE.contains("goldfish"));
                ViewRootImpl.access$2102(ViewRootImpl.this, SystemProperties.getBoolean(ViewRootImpl.PROPERTY_EMULATOR_CIRCULAR, false));
            }
        });
    }

    void notifyRendererOfFramePending() {
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.notifyFramePending();
        }
    }

    @Override
    public void notifySubtreeAccessibilityStateChanged(View view, View view2, int n) {
        this.postSendWindowContentChangedCallback(view2, n);
    }

    @Override
    public void onHardwarePostDraw(HardwareCanvas hardwareCanvas) {
        if (this.mResizeBuffer != null) {
            this.mResizePaint.setAlpha(this.mResizeAlpha);
            hardwareCanvas.drawHardwareLayer(this.mResizeBuffer, this.mHardwareXOffset, this.mHardwareYOffset, this.mResizePaint);
        }
    }

    @Override
    public void onHardwarePreDraw(HardwareCanvas hardwareCanvas) {
        hardwareCanvas.translate(-this.mHardwareXOffset, -this.mHardwareYOffset);
    }

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return false;
    }

    @Override
    public boolean onNestedPreFling(View view, float f, float f2) {
        return false;
    }

    @Override
    public void onNestedPreScroll(View view, int n, int n2, int[] nArray) {
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return false;
    }

    @Override
    public void onStopNestedScroll(View view) {
    }

    void outputDisplayList(View view) {
        RenderNode renderNode = view.getDisplayList();
        if (renderNode != null) {
            renderNode.output();
        }
    }

    @Override
    public boolean performHapticFeedback(int n, boolean bl) {
        try {
            boolean bl2 = this.mWindowSession.performHapticFeedback(this.mWindow, n, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void playSoundEffect(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 127->162)] java.lang.IllegalStateException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void profile() {
        this.mProfile = true;
    }

    @Override
    public void recomputeViewAttributes(View view) {
        this.checkThread();
        if (this.mView == view) {
            this.mAttachInfo.mRecomputeGlobalAttributes = true;
            if (!this.mWillDrawSoon) {
                this.scheduleTraversals();
            }
        }
    }

    public void registerAnimatingRenderNode(RenderNode renderNode) {
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.registerAnimatingRenderNode(renderNode);
            return;
        }
        if (this.mAttachInfo.mPendingAnimatingRenderNodes == null) {
            this.mAttachInfo.mPendingAnimatingRenderNodes = new ArrayList<RenderNode>();
        }
        this.mAttachInfo.mPendingAnimatingRenderNodes.add(renderNode);
    }

    @Override
    public void requestChildFocus(View view, View view2) {
        this.checkThread();
        this.scheduleTraversals();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        boolean bl2 = this.scrollToRectOrFocus(rect, bl);
        if (rect == null) return bl2;
        this.mTempRect.set(rect);
        this.mTempRect.offset(0, -this.mCurScrollY);
        this.mTempRect.offset(this.mAttachInfo.mWindowLeft, this.mAttachInfo.mWindowTop);
        try {
            this.mWindowSession.onRectangleOnScreenRequested(this.mWindow, this.mTempRect);
        }
        catch (RemoteException remoteException) {
            return bl2;
        }
        return bl2;
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
    }

    @Override
    public void requestFitSystemWindows() {
        this.checkThread();
        this.mApplyInsetsRequested = true;
        this.scheduleTraversals();
    }

    @Override
    public void requestLayout() {
        if (!this.mHandlingLayoutInLayoutRequest) {
            this.checkThread();
            this.mLayoutRequested = true;
            this.scheduleTraversals();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean requestLayoutDuringLayout(View view) {
        block5: {
            block4: {
                if (view.mParent == null || view.mAttachInfo == null) break block4;
                if (!this.mLayoutRequesters.contains(view)) {
                    this.mLayoutRequesters.add(view);
                }
                if (this.mHandlingLayoutInLayoutRequest) break block5;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requestSendAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        if (this.mView == null) {
            return false;
        }
        switch (accessibilityEvent.getEventType()) {
            case 32768: {
                AccessibilityNodeProvider accessibilityNodeProvider;
                long l = accessibilityEvent.getSourceNodeId();
                int n = AccessibilityNodeInfo.getAccessibilityViewId(l);
                View view2 = this.mView.findViewByAccessibilityId(n);
                if (view2 == null || (accessibilityNodeProvider = view2.getAccessibilityNodeProvider()) == null) break;
                int n2 = AccessibilityNodeInfo.getVirtualDescendantId(l);
                AccessibilityNodeInfo accessibilityNodeInfo = n2 == Integer.MAX_VALUE ? accessibilityNodeProvider.createAccessibilityNodeInfo(-1) : accessibilityNodeProvider.createAccessibilityNodeInfo(n2);
                this.setAccessibilityFocus(view2, accessibilityNodeInfo);
                break;
            }
            case 65536: {
                int n = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityEvent.getSourceNodeId());
                View view3 = this.mView.findViewByAccessibilityId(n);
                if (view3 == null || view3.getAccessibilityNodeProvider() == null) break;
                this.setAccessibilityFocus(null, null);
                break;
            }
            case 2048: {
                AccessibilityNodeProvider accessibilityNodeProvider;
                int n;
                if (this.mAccessibilityFocusedHost == null || this.mAccessibilityFocusedVirtualView == null || AccessibilityNodeInfo.getAccessibilityViewId(accessibilityEvent.getSourceNodeId()) != this.mAccessibilityFocusedHost.getAccessibilityViewId() || ((n = accessibilityEvent.getContentChangeTypes()) & 1) == 0 && n != 0 || (accessibilityNodeProvider = this.mAccessibilityFocusedHost.getAccessibilityNodeProvider()) == null) break;
                int n3 = AccessibilityNodeInfo.getVirtualDescendantId(this.mAccessibilityFocusedVirtualView.getSourceNodeId());
                if (n3 == Integer.MAX_VALUE) {
                    this.mAccessibilityFocusedVirtualView = accessibilityNodeProvider.createAccessibilityNodeInfo(-1);
                    break;
                }
                this.mAccessibilityFocusedVirtualView = accessibilityNodeProvider.createAccessibilityNodeInfo(n3);
                break;
            }
        }
        this.mAccessibilityManager.sendAccessibilityEvent(accessibilityEvent);
        return true;
    }

    public void requestTransitionStart(LayoutTransition layoutTransition) {
        if (this.mPendingTransitions == null || !this.mPendingTransitions.contains(layoutTransition)) {
            if (this.mPendingTransitions == null) {
                this.mPendingTransitions = new ArrayList();
            }
            this.mPendingTransitions.add(layoutTransition);
        }
    }

    @Override
    public void requestTransparentRegion(View view) {
        this.checkThread();
        if (this.mView == view) {
            View view2 = this.mView;
            view2.mPrivateFlags = 0x200 | view2.mPrivateFlags;
            this.mWindowAttributesChanged = true;
            this.mWindowAttributesChangesFlag = 0;
            this.requestLayout();
        }
    }

    public void requestUpdateConfiguration(Configuration configuration) {
        Message message = this.mHandler.obtainMessage(18, configuration);
        this.mHandler.sendMessage(message);
    }

    void scheduleConsumeBatchedInput() {
        if (!this.mConsumeBatchedInputScheduled) {
            this.mConsumeBatchedInputScheduled = true;
            this.mChoreographer.postCallback(0, this.mConsumedBatchedInputRunnable, null);
        }
    }

    void scheduleConsumeBatchedInputImmediately() {
        if (!this.mConsumeBatchedInputImmediatelyScheduled) {
            this.unscheduleConsumeBatchedInput();
            this.mConsumeBatchedInputImmediatelyScheduled = true;
            this.mHandler.post(this.mConsumeBatchedInputImmediatelyRunnable);
        }
    }

    void scheduleTraversals() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.mTraversalBarrier = this.mHandler.getLooper().postSyncBarrier();
            this.mChoreographer.postCallback(2, this.mTraversalRunnable, null);
            if (!this.mUnbufferedInputDispatch) {
                this.scheduleConsumeBatchedInput();
            }
            this.notifyRendererOfFramePending();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean scrollToRectOrFocus(Rect rect, boolean bl) {
        int n;
        boolean bl2;
        block19: {
            View view;
            Rect rect2;
            block20: {
                block18: {
                    Rect rect3 = this.mAttachInfo.mContentInsets;
                    rect2 = this.mAttachInfo.mVisibleInsets;
                    if (rect2.left > rect3.left || rect2.top > rect3.top || rect2.right > rect3.right) break block18;
                    int n2 = rect2.bottom;
                    int n3 = rect3.bottom;
                    bl2 = false;
                    n = 0;
                    if (n2 <= n3) break block19;
                }
                n = this.mScrollY;
                view = this.mView.findFocus();
                if (view == null) {
                    return false;
                }
                View view2 = this.mLastScrolledFocus != null ? (View)this.mLastScrolledFocus.get() : null;
                if (view != view2) {
                    rect = null;
                }
                if (view != view2 || this.mScrollMayChange) break block20;
                bl2 = false;
                if (rect == null) break block19;
            }
            this.mLastScrolledFocus = new WeakReference<View>(view);
            this.mScrollMayChange = false;
            boolean bl3 = view.getGlobalVisibleRect(this.mVisRect, null);
            bl2 = false;
            if (bl3) {
                if (rect == null) {
                    view.getFocusedRect(this.mTempRect);
                    if (this.mView instanceof ViewGroup) {
                        ((ViewGroup)this.mView).offsetDescendantRectToMyCoords(view, this.mTempRect);
                    }
                } else {
                    this.mTempRect.set(rect);
                }
                boolean bl4 = this.mTempRect.intersect(this.mVisRect);
                bl2 = false;
                if (bl4) {
                    if (this.mTempRect.height() <= this.mView.getHeight() - rect2.top - rect2.bottom) {
                        if (this.mTempRect.top - n < rect2.top) {
                            n -= rect2.top - (this.mTempRect.top - n);
                        } else if (this.mTempRect.bottom - n > this.mView.getHeight() - rect2.bottom) {
                            n += this.mTempRect.bottom - n - (this.mView.getHeight() - rect2.bottom);
                        }
                    }
                    bl2 = true;
                }
            }
        }
        if (n != this.mScrollY) {
            if (!bl && this.mResizeBuffer == null) {
                if (this.mScroller == null) {
                    this.mScroller = new Scroller(this.mView.getContext());
                }
                this.mScroller.startScroll(0, this.mScrollY, 0, n - this.mScrollY);
            } else if (this.mScroller != null) {
                this.mScroller.abortAnimation();
            }
            this.mScrollY = n;
        }
        return bl2;
    }

    void setAccessibilityFocus(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
        if (this.mAccessibilityFocusedVirtualView != null) {
            AccessibilityNodeInfo accessibilityNodeInfo2 = this.mAccessibilityFocusedVirtualView;
            View view2 = this.mAccessibilityFocusedHost;
            this.mAccessibilityFocusedHost = null;
            this.mAccessibilityFocusedVirtualView = null;
            view2.clearAccessibilityFocusNoCallbacks();
            AccessibilityNodeProvider accessibilityNodeProvider = view2.getAccessibilityNodeProvider();
            if (accessibilityNodeProvider != null) {
                accessibilityNodeInfo2.getBoundsInParent(this.mTempRect);
                view2.invalidate(this.mTempRect);
                accessibilityNodeProvider.performAction(AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeInfo2.getSourceNodeId()), 128, null);
            }
            accessibilityNodeInfo2.recycle();
        }
        if (this.mAccessibilityFocusedHost != null) {
            this.mAccessibilityFocusedHost.clearAccessibilityFocusNoCallbacks();
        }
        this.mAccessibilityFocusedHost = view;
        this.mAccessibilityFocusedVirtualView = accessibilityNodeInfo;
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.invalidateRoot();
        }
    }

    public void setDragFocus(View view) {
        if (this.mCurrentDragView != view) {
            this.mCurrentDragView = view;
        }
    }

    public void setDrawDuringWindowsAnimating(boolean bl) {
        this.mDrawDuringWindowsAnimating = bl;
        if (bl) {
            this.handleDispatchDoneAnimating();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setLayoutParams(WindowManager.LayoutParams layoutParams, boolean bl) {
        synchronized (this) {
            int n = this.mWindowAttributes.surfaceInsets.left;
            int n2 = this.mWindowAttributes.surfaceInsets.top;
            int n3 = this.mWindowAttributes.surfaceInsets.right;
            int n4 = this.mWindowAttributes.surfaceInsets.bottom;
            int n5 = this.mWindowAttributes.softInputMode;
            this.mClientWindowLayoutFlags = layoutParams.flags;
            int n6 = 0x80 & this.mWindowAttributes.privateFlags;
            layoutParams.systemUiVisibility = this.mWindowAttributes.systemUiVisibility;
            layoutParams.subtreeSystemUiVisibility = this.mWindowAttributes.subtreeSystemUiVisibility;
            this.mWindowAttributesChangesFlag = this.mWindowAttributes.copyFrom(layoutParams);
            if ((0x80000 & this.mWindowAttributesChangesFlag) != 0) {
                this.mAttachInfo.mRecomputeGlobalAttributes = true;
            }
            if (this.mWindowAttributes.packageName == null) {
                this.mWindowAttributes.packageName = this.mBasePackageName;
            }
            WindowManager.LayoutParams layoutParams2 = this.mWindowAttributes;
            layoutParams2.privateFlags = n6 | layoutParams2.privateFlags;
            this.mWindowAttributes.surfaceInsets.set(n, n2, n3, n4);
            this.applyKeepScreenOnFlag(this.mWindowAttributes);
            if (bl) {
                this.mSoftInputMode = layoutParams.softInputMode;
                this.requestLayout();
            }
            if ((0xF0 & layoutParams.softInputMode) == 0) {
                this.mWindowAttributes.softInputMode = 0xFFFFFF0F & this.mWindowAttributes.softInputMode | n5 & 0xF0;
            }
            this.mWindowAttributesChanged = true;
            this.scheduleTraversals();
            return;
        }
    }

    void setLocalDragState(Object object) {
        this.mLocalDragState = object;
    }

    void setStopped(boolean bl) {
        if (this.mStopped != bl) {
            this.mStopped = bl;
            if (!bl) {
                this.scheduleTraversals();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setView(View view, WindowManager.LayoutParams layoutParams, View view2) {
        synchronized (this) {
            if (this.mView == null) {
                int n;
                WindowManager.LayoutParams layoutParams2;
                block37: {
                    this.mView = view;
                    this.mAttachInfo.mDisplayState = this.mDisplay.getState();
                    this.mDisplayManager.registerDisplayListener(this.mDisplayListener, this.mHandler);
                    this.mViewLayoutDirectionInitial = this.mView.getRawLayoutDirection();
                    this.mFallbackEventHandler.setView(view);
                    this.mWindowAttributes.copyFrom(layoutParams);
                    if (this.mWindowAttributes.packageName == null) {
                        this.mWindowAttributes.packageName = this.mBasePackageName;
                    }
                    layoutParams2 = this.mWindowAttributes;
                    this.mClientWindowLayoutFlags = layoutParams2.flags;
                    this.setAccessibilityFocus(null, null);
                    if (view instanceof RootViewSurfaceTaker) {
                        this.mSurfaceHolderCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheSurface();
                        if (this.mSurfaceHolderCallback != null) {
                            this.mSurfaceHolder = new TakenSurfaceHolder();
                            this.mSurfaceHolder.setFormat(0);
                        }
                    }
                    int n2 = (int)Math.ceil(2.0f * view.getZ());
                    layoutParams2.surfaceInsets.set(n2, n2, n2, n2);
                    CompatibilityInfo compatibilityInfo = this.mDisplayAdjustments.getCompatibilityInfo();
                    this.mTranslator = compatibilityInfo.getTranslator();
                    this.mDisplayAdjustments.setActivityToken(layoutParams2.token);
                    if (this.mSurfaceHolder == null) {
                        this.enableHardwareAcceleration(layoutParams2);
                    }
                    CompatibilityInfo.Translator translator = this.mTranslator;
                    boolean bl = false;
                    if (translator != null) {
                        this.mSurface.setCompatibilityTranslator(this.mTranslator);
                        bl = true;
                        layoutParams2.backup();
                        this.mTranslator.translateWindowLayout(layoutParams2);
                    }
                    if (!compatibilityInfo.supportsScreen()) {
                        layoutParams2.privateFlags = 0x80 | layoutParams2.privateFlags;
                        this.mLastInCompatMode = true;
                    }
                    this.mSoftInputMode = layoutParams2.softInputMode;
                    this.mWindowAttributesChanged = true;
                    this.mWindowAttributesChangesFlag = -1;
                    this.mAttachInfo.mRootView = view;
                    View.AttachInfo attachInfo = this.mAttachInfo;
                    boolean bl2 = this.mTranslator != null;
                    attachInfo.mScalingRequired = bl2;
                    View.AttachInfo attachInfo2 = this.mAttachInfo;
                    float f = this.mTranslator == null ? 1.0f : this.mTranslator.applicationScale;
                    attachInfo2.mApplicationScale = f;
                    if (view2 != null) {
                        this.mAttachInfo.mPanelParentWindowToken = view2.getApplicationWindowToken();
                    }
                    this.mAdded = true;
                    this.requestLayout();
                    if ((2 & this.mWindowAttributes.inputFeatures) == 0) {
                        this.mInputChannel = new InputChannel();
                    }
                    this.mOrigWindowType = this.mWindowAttributes.type;
                    this.mAttachInfo.mRecomputeGlobalAttributes = true;
                    this.collectViewAttributes();
                    n = this.mWindowSession.addToDisplay(this.mWindow, this.mSeq, this.mWindowAttributes, this.getHostVisibility(), this.mDisplay.getDisplayId(), this.mAttachInfo.mContentInsets, this.mInputChannel);
                    if (this.mTranslator != null) {
                        this.mTranslator.translateRectInScreenToAppWindow(this.mAttachInfo.mContentInsets);
                    }
                    this.mPendingOverscanInsets.set(0, 0, 0, 0);
                    this.mPendingContentInsets.set(this.mAttachInfo.mContentInsets);
                    this.mPendingStableInsets.set(this.mAttachInfo.mStableInsets);
                    this.mPendingVisibleInsets.set(0, 0, 0, 0);
                    if (n >= 0) break block37;
                    this.mAttachInfo.mRootView = null;
                    this.mAdded = false;
                    this.mFallbackEventHandler.setView(null);
                    this.unscheduleTraversals();
                    this.setAccessibilityFocus(null, null);
                    switch (n) {
                        default: {
                            throw new RuntimeException("Unable to add window -- unknown error code " + n);
                        }
                        catch (RemoteException remoteException) {
                            this.mAdded = false;
                            this.mView = null;
                            this.mAttachInfo.mRootView = null;
                            this.mInputChannel = null;
                            this.mFallbackEventHandler.setView(null);
                            this.unscheduleTraversals();
                            this.setAccessibilityFocus(null, null);
                            throw new RuntimeException("Adding window failed", remoteException);
                        }
                        finally {
                            if (bl) {
                                layoutParams2.restore();
                            }
                        }
                        case -2: 
                        case -1: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + layoutParams2.token + " is not valid; is your activity running?");
                        }
                        case -3: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + layoutParams2.token + " is not for an application");
                        }
                        case -4: {
                            throw new WindowManager.BadTokenException("Unable to add window -- app for token " + layoutParams2.token + " is exiting");
                        }
                        case -5: {
                            throw new WindowManager.BadTokenException("Unable to add window -- window " + this.mWindow + " has already been added");
                        }
                        case -6: {
                            return;
                        }
                        case -7: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- another window of this type already exists");
                        }
                        case -8: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- permission denied for this window type");
                        }
                        case -9: 
                    }
                    throw new WindowManager.InvalidDisplayException("Unable to add window " + this.mWindow + " -- the specified display can not be found");
                }
                if (view instanceof RootViewSurfaceTaker) {
                    this.mInputQueueCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheInputQueue();
                }
                if (this.mInputChannel != null) {
                    if (this.mInputQueueCallback != null) {
                        this.mInputQueue = new InputQueue();
                        this.mInputQueueCallback.onInputQueueCreated(this.mInputQueue);
                    }
                    this.mInputEventReceiver = new WindowInputEventReceiver(this.mInputChannel, Looper.myLooper());
                }
                view.assignParent(this);
                boolean bl = (n & 1) != 0;
                this.mAddedTouchMode = bl;
                boolean bl3 = (n & 2) != 0;
                this.mAppVisible = bl3;
                if (this.mAccessibilityManager.isEnabled()) {
                    this.mAccessibilityInteractionConnectionManager.ensureConnection();
                }
                if (view.getImportantForAccessibility() == 0) {
                    view.setImportantForAccessibility(1);
                }
                CharSequence charSequence = layoutParams2.getTitle();
                this.mSyntheticInputStage = new SyntheticInputStage();
                ViewPostImeInputStage viewPostImeInputStage = new ViewPostImeInputStage(this.mSyntheticInputStage);
                NativePostImeInputStage nativePostImeInputStage = new NativePostImeInputStage(viewPostImeInputStage, "aq:native-post-ime:" + charSequence);
                EarlyPostImeInputStage earlyPostImeInputStage = new EarlyPostImeInputStage(nativePostImeInputStage);
                ImeInputStage imeInputStage = new ImeInputStage(earlyPostImeInputStage, "aq:ime:" + charSequence);
                ViewPreImeInputStage viewPreImeInputStage = new ViewPreImeInputStage(imeInputStage);
                NativePreImeInputStage nativePreImeInputStage = new NativePreImeInputStage(viewPreImeInputStage, "aq:native-pre-ime:" + charSequence);
                this.mFirstInputStage = nativePreImeInputStage;
                this.mFirstPostImeInputStage = earlyPostImeInputStage;
                this.mPendingInputEventQueueLengthCounterName = "aq:pending:" + charSequence;
            }
            return;
        }
    }

    @Override
    public boolean showContextMenuForChild(View view) {
        return false;
    }

    @Override
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback) {
        return null;
    }

    public void synthesizeInputEvent(InputEvent inputEvent) {
        Message message = this.mHandler.obtainMessage(25, inputEvent);
        message.setAsynchronous(true);
        this.mHandler.sendMessage(message);
    }

    void transformMatrixToGlobal(Matrix matrix) {
        matrix.preTranslate(this.mAttachInfo.mWindowLeft, this.mAttachInfo.mWindowTop);
    }

    void transformMatrixToLocal(Matrix matrix) {
        matrix.postTranslate(-this.mAttachInfo.mWindowLeft, -this.mAttachInfo.mWindowTop);
    }

    void unscheduleConsumeBatchedInput() {
        if (this.mConsumeBatchedInputScheduled) {
            this.mConsumeBatchedInputScheduled = false;
            this.mChoreographer.removeCallbacks(0, this.mConsumedBatchedInputRunnable, null);
        }
    }

    void unscheduleTraversals() {
        if (this.mTraversalScheduled) {
            this.mTraversalScheduled = false;
            this.mHandler.getLooper().removeSyncBarrier(this.mTraversalBarrier);
            this.mChoreographer.removeCallbacks(2, this.mTraversalRunnable, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void updateConfiguration(Configuration configuration, boolean bl) {
        CompatibilityInfo compatibilityInfo = this.mDisplayAdjustments.getCompatibilityInfo();
        if (!compatibilityInfo.equals(CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO)) {
            Configuration configuration2 = new Configuration(configuration);
            compatibilityInfo.applyToConfiguration(this.mNoncompatDensity, configuration2);
            configuration = configuration2;
        }
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        // MONITORENTER : arrayList
        for (int i = -1 + sConfigCallbacks.size(); i >= 0; --i) {
            sConfigCallbacks.get(i).onConfigurationChanged(configuration);
        }
        // MONITOREXIT : arrayList
        if (this.mView == null) return;
        Configuration configuration3 = this.mView.getResources().getConfiguration();
        if (!bl) {
            if (this.mLastConfiguration.diff(configuration3) == 0) return;
        }
        int n = this.mLastConfiguration.getLayoutDirection();
        int n2 = configuration3.getLayoutDirection();
        this.mLastConfiguration.setTo(configuration3);
        if (n != n2 && this.mViewLayoutDirectionInitial == 2) {
            this.mView.setLayoutDirection(n2);
        }
        this.mView.dispatchConfigurationChanged(configuration3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void windowFocusChanged(boolean bl, boolean bl2) {
        int n = 1;
        Message message = Message.obtain();
        message.what = 6;
        int n2 = bl ? n : 0;
        message.arg1 = n2;
        if (!bl2) {
            n = 0;
        }
        message.arg2 = n;
        this.mHandler.sendMessage(message);
    }

    static final class AccessibilityInteractionConnection
    extends IAccessibilityInteractionConnection.Stub {
        private final WeakReference<ViewRootImpl> mViewRootImpl;

        AccessibilityInteractionConnection(ViewRootImpl viewRootImpl) {
            this.mViewRootImpl = new WeakReference<ViewRootImpl>(viewRootImpl);
        }

        @Override
        public void computeClickPointInScreen(long l, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, long l2, MagnificationSpec magnificationSpec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().computeClickPointInScreenClientThread(l, region, n, iAccessibilityInteractionConnectionCallback, n2, l2, magnificationSpec);
                return;
            }
            try {
                iAccessibilityInteractionConnectionCallback.setComputeClickPointInScreenActionResult(null, n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void findAccessibilityNodeInfoByAccessibilityId(long l, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, int n3, long l2, MagnificationSpec magnificationSpec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfoByAccessibilityIdClientThread(l, region, n, iAccessibilityInteractionConnectionCallback, n2, n3, l2, magnificationSpec);
                return;
            }
            try {
                iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfosResult(null, n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void findAccessibilityNodeInfosByText(long l, String string2, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, int n3, long l2, MagnificationSpec magnificationSpec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfosByTextClientThread(l, string2, region, n, iAccessibilityInteractionConnectionCallback, n2, n3, l2, magnificationSpec);
                return;
            }
            try {
                iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfosResult(null, n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void findAccessibilityNodeInfosByViewId(long l, String string2, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, int n3, long l2, MagnificationSpec magnificationSpec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfosByViewIdClientThread(l, string2, region, n, iAccessibilityInteractionConnectionCallback, n2, n3, l2, magnificationSpec);
                return;
            }
            try {
                iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfoResult(null, n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void findFocus(long l, int n, Region region, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n3, int n4, long l2, MagnificationSpec magnificationSpec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().findFocusClientThread(l, n, region, n2, iAccessibilityInteractionConnectionCallback, n3, n4, l2, magnificationSpec);
                return;
            }
            try {
                iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfoResult(null, n2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void focusSearch(long l, int n, Region region, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n3, int n4, long l2, MagnificationSpec magnificationSpec) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().focusSearchClientThread(l, n, region, n2, iAccessibilityInteractionConnectionCallback, n3, n4, l2, magnificationSpec);
                return;
            }
            try {
                iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfoResult(null, n2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void performAccessibilityAction(long l, int n, Bundle bundle, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n3, int n4, long l2) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewRootImpl.get();
            if (viewRootImpl != null && viewRootImpl.mView != null) {
                viewRootImpl.getAccessibilityInteractionController().performAccessibilityActionClientThread(l, n, bundle, n2, iAccessibilityInteractionConnectionCallback, n3, n4, l2);
                return;
            }
            try {
                iAccessibilityInteractionConnectionCallback.setPerformAccessibilityActionResult(false, n2);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }

    final class AccessibilityInteractionConnectionManager
    implements AccessibilityManager.AccessibilityStateChangeListener {
        AccessibilityInteractionConnectionManager() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void ensureConnection() {
            if (ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId != Integer.MAX_VALUE) {
                return;
            }
            boolean bl = false;
            if (bl) return;
            ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId = ViewRootImpl.this.mAccessibilityManager.addAccessibilityInteractionConnection(ViewRootImpl.this.mWindow, new AccessibilityInteractionConnection(ViewRootImpl.this));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void ensureNoConnection() {
            if (ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId == Integer.MAX_VALUE) return;
            boolean bl = true;
            if (!bl) return;
            ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId = Integer.MAX_VALUE;
            ViewRootImpl.this.mAccessibilityManager.removeAccessibilityInteractionConnection(ViewRootImpl.this.mWindow);
        }

        @Override
        public void onAccessibilityStateChanged(boolean bl) {
            if (bl) {
                this.ensureConnection();
                if (ViewRootImpl.this.mAttachInfo.mHasWindowFocus) {
                    ViewRootImpl.this.mView.sendAccessibilityEvent(32);
                    View view = ViewRootImpl.this.mView.findFocus();
                    if (view != null && view != ViewRootImpl.this.mView) {
                        view.sendAccessibilityEvent(8);
                    }
                }
                return;
            }
            this.ensureNoConnection();
            ViewRootImpl.this.mHandler.obtainMessage(21).sendToTarget();
        }
    }

    abstract class AsyncInputStage
    extends InputStage {
        protected static final int DEFER = 3;
        private QueuedInputEvent mQueueHead;
        private int mQueueLength;
        private QueuedInputEvent mQueueTail;
        private final String mTraceCounter;

        public AsyncInputStage(InputStage inputStage, String string2) {
            super(inputStage);
            this.mTraceCounter = string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void dequeue(QueuedInputEvent queuedInputEvent, QueuedInputEvent queuedInputEvent2) {
            if (queuedInputEvent2 == null) {
                this.mQueueHead = queuedInputEvent.mNext;
            } else {
                queuedInputEvent2.mNext = queuedInputEvent.mNext;
            }
            if (this.mQueueTail == queuedInputEvent) {
                this.mQueueTail = queuedInputEvent2;
            }
            queuedInputEvent.mNext = null;
            this.mQueueLength = -1 + this.mQueueLength;
            Trace.traceCounter(4L, this.mTraceCounter, this.mQueueLength);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void enqueue(QueuedInputEvent queuedInputEvent) {
            if (this.mQueueTail == null) {
                this.mQueueHead = queuedInputEvent;
                this.mQueueTail = queuedInputEvent;
            } else {
                this.mQueueTail.mNext = queuedInputEvent;
                this.mQueueTail = queuedInputEvent;
            }
            this.mQueueLength = 1 + this.mQueueLength;
            Trace.traceCounter(4L, this.mTraceCounter, this.mQueueLength);
        }

        @Override
        protected void apply(QueuedInputEvent queuedInputEvent, int n) {
            if (n == 3) {
                this.defer(queuedInputEvent);
                return;
            }
            super.apply(queuedInputEvent, n);
        }

        protected void defer(QueuedInputEvent queuedInputEvent) {
            queuedInputEvent.mFlags = 2 | queuedInputEvent.mFlags;
            this.enqueue(queuedInputEvent);
        }

        @Override
        void dump(String string2, PrintWriter printWriter) {
            printWriter.print(string2);
            printWriter.print(this.getClass().getName());
            printWriter.print(": mQueueLength=");
            printWriter.println(this.mQueueLength);
            super.dump(string2, printWriter);
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        protected void forward(QueuedInputEvent queuedInputEvent) {
            queuedInputEvent.mFlags = 0xFFFFFFFD & queuedInputEvent.mFlags;
            QueuedInputEvent queuedInputEvent2 = this.mQueueHead;
            if (queuedInputEvent2 == null) {
                super.forward(queuedInputEvent);
                return;
            }
            int n = queuedInputEvent.mEvent.getDeviceId();
            QueuedInputEvent queuedInputEvent3 = null;
            boolean bl = false;
            while (queuedInputEvent2 != null && queuedInputEvent2 != queuedInputEvent) {
                if (!bl && n == queuedInputEvent2.mEvent.getDeviceId()) {
                    bl = true;
                }
                queuedInputEvent3 = queuedInputEvent2;
                queuedInputEvent2 = queuedInputEvent2.mNext;
            }
            if (bl) {
                if (queuedInputEvent2 != null) return;
                this.enqueue(queuedInputEvent);
                return;
            }
            if (queuedInputEvent2 != null) {
                queuedInputEvent2 = queuedInputEvent2.mNext;
                this.dequeue(queuedInputEvent, queuedInputEvent3);
            }
            super.forward(queuedInputEvent);
            while (queuedInputEvent2 != null) {
                if (n == queuedInputEvent2.mEvent.getDeviceId()) {
                    if ((2 & queuedInputEvent2.mFlags) != 0) return;
                    QueuedInputEvent queuedInputEvent4 = queuedInputEvent2.mNext;
                    this.dequeue(queuedInputEvent2, queuedInputEvent3);
                    super.forward(queuedInputEvent2);
                    queuedInputEvent2 = queuedInputEvent4;
                    continue;
                }
                queuedInputEvent3 = queuedInputEvent2;
                queuedInputEvent2 = queuedInputEvent2.mNext;
            }
        }
    }

    public static final class CalledFromWrongThreadException
    extends AndroidRuntimeException {
        public CalledFromWrongThreadException(String string2) {
            super(string2);
        }
    }

    final class ConsumeBatchedInputImmediatelyRunnable
    implements Runnable {
        ConsumeBatchedInputImmediatelyRunnable() {
        }

        @Override
        public void run() {
            ViewRootImpl.this.doConsumeBatchedInput(-1L);
        }
    }

    final class ConsumeBatchedInputRunnable
    implements Runnable {
        ConsumeBatchedInputRunnable() {
        }

        @Override
        public void run() {
            ViewRootImpl.this.doConsumeBatchedInput(ViewRootImpl.this.mChoreographer.getFrameTimeNanos());
        }
    }

    final class EarlyPostImeInputStage
    extends InputStage {
        public EarlyPostImeInputStage(InputStage inputStage) {
            super(inputStage);
        }

        private int processKeyEvent(QueuedInputEvent queuedInputEvent) {
            KeyEvent keyEvent = (KeyEvent)queuedInputEvent.mEvent;
            if (ViewRootImpl.this.checkForLeavingTouchModeAndConsume(keyEvent)) {
                return 1;
            }
            ViewRootImpl.this.mFallbackEventHandler.preDispatchKeyEvent(keyEvent);
            return 0;
        }

        private int processPointerEvent(QueuedInputEvent queuedInputEvent) {
            int n;
            MotionEvent motionEvent = (MotionEvent)queuedInputEvent.mEvent;
            if (ViewRootImpl.this.mTranslator != null) {
                ViewRootImpl.this.mTranslator.translateEventInScreenToAppWindow(motionEvent);
            }
            if ((n = motionEvent.getAction()) == 0 || n == 8) {
                ViewRootImpl.this.ensureTouchMode(true);
            }
            if (ViewRootImpl.this.mCurScrollY != 0) {
                motionEvent.offsetLocation(0.0f, ViewRootImpl.this.mCurScrollY);
            }
            if (motionEvent.isTouchEvent()) {
                ViewRootImpl.this.mLastTouchPoint.x = motionEvent.getRawX();
                ViewRootImpl.this.mLastTouchPoint.y = motionEvent.getRawY();
            }
            return 0;
        }

        @Override
        protected int onProcess(QueuedInputEvent queuedInputEvent) {
            if (queuedInputEvent.mEvent instanceof KeyEvent) {
                return this.processKeyEvent(queuedInputEvent);
            }
            if ((2 & queuedInputEvent.mEvent.getSource()) != 0) {
                return this.processPointerEvent(queuedInputEvent);
            }
            return 0;
        }
    }

    final class HighContrastTextManager
    implements AccessibilityManager.HighTextContrastChangeListener {
        HighContrastTextManager() {
            ViewRootImpl.this.mAttachInfo.mHighContrastText = ViewRootImpl.this.mAccessibilityManager.isHighTextContrastEnabled();
        }

        @Override
        public void onHighTextContrastStateChanged(boolean bl) {
            ViewRootImpl.this.mAttachInfo.mHighContrastText = bl;
            ViewRootImpl.this.destroyHardwareResources();
            ViewRootImpl.this.invalidate();
        }
    }

    final class ImeInputStage
    extends AsyncInputStage
    implements InputMethodManager.FinishedInputEventCallback {
        public ImeInputStage(InputStage inputStage, String string2) {
            super(inputStage, string2);
        }

        @Override
        public void onFinishedInputEvent(Object object, boolean bl) {
            QueuedInputEvent queuedInputEvent = (QueuedInputEvent)object;
            if (bl) {
                this.finish(queuedInputEvent, true);
                return;
            }
            this.forward(queuedInputEvent);
        }

        @Override
        protected int onProcess(QueuedInputEvent queuedInputEvent) {
            InputMethodManager inputMethodManager;
            if (ViewRootImpl.this.mLastWasImTarget && !ViewRootImpl.this.isInLocalFocusMode() && (inputMethodManager = InputMethodManager.peekInstance()) != null) {
                int n = inputMethodManager.dispatchInputEvent(queuedInputEvent.mEvent, queuedInputEvent, this, ViewRootImpl.this.mHandler);
                if (n == 1) {
                    return 1;
                }
                if (n == 0) {
                    return 0;
                }
                return 3;
            }
            return 0;
        }
    }

    abstract class InputStage {
        protected static final int FINISH_HANDLED = 1;
        protected static final int FINISH_NOT_HANDLED = 2;
        protected static final int FORWARD;
        private final InputStage mNext;

        public InputStage(InputStage inputStage) {
            this.mNext = inputStage;
        }

        protected void apply(QueuedInputEvent queuedInputEvent, int n) {
            if (n == 0) {
                this.forward(queuedInputEvent);
                return;
            }
            if (n == 1) {
                this.finish(queuedInputEvent, true);
                return;
            }
            if (n == 2) {
                this.finish(queuedInputEvent, false);
                return;
            }
            throw new IllegalArgumentException("Invalid result: " + n);
        }

        public final void deliver(QueuedInputEvent queuedInputEvent) {
            if ((4 & queuedInputEvent.mFlags) != 0) {
                this.forward(queuedInputEvent);
                return;
            }
            if (this.shouldDropInputEvent(queuedInputEvent)) {
                this.finish(queuedInputEvent, false);
                return;
            }
            this.apply(queuedInputEvent, this.onProcess(queuedInputEvent));
        }

        void dump(String string2, PrintWriter printWriter) {
            if (this.mNext != null) {
                this.mNext.dump(string2, printWriter);
            }
        }

        protected void finish(QueuedInputEvent queuedInputEvent, boolean bl) {
            queuedInputEvent.mFlags = 4 | queuedInputEvent.mFlags;
            if (bl) {
                queuedInputEvent.mFlags = 8 | queuedInputEvent.mFlags;
            }
            this.forward(queuedInputEvent);
        }

        protected void forward(QueuedInputEvent queuedInputEvent) {
            this.onDeliverToNext(queuedInputEvent);
        }

        protected void onDeliverToNext(QueuedInputEvent queuedInputEvent) {
            if (this.mNext != null) {
                this.mNext.deliver(queuedInputEvent);
                return;
            }
            ViewRootImpl.this.finishInputEvent(queuedInputEvent);
        }

        protected int onProcess(QueuedInputEvent queuedInputEvent) {
            return 0;
        }

        protected boolean shouldDropInputEvent(QueuedInputEvent queuedInputEvent) {
            if (ViewRootImpl.this.mView == null || !ViewRootImpl.this.mAdded) {
                Slog.w(ViewRootImpl.TAG, "Dropping event due to root view being removed: " + queuedInputEvent.mEvent);
                return true;
            }
            if (!(ViewRootImpl.this.mAttachInfo.mHasWindowFocus || queuedInputEvent.mEvent.isFromSource(2) || ViewRootImpl.isTerminalInputEvent(queuedInputEvent.mEvent))) {
                Slog.w(ViewRootImpl.TAG, "Dropping event due to no window focus: " + queuedInputEvent.mEvent);
                return true;
            }
            return false;
        }
    }

    final class InvalidateOnAnimationRunnable
    implements Runnable {
        private boolean mPosted;
        private View.AttachInfo.InvalidateInfo[] mTempViewRects;
        private View[] mTempViews;
        private final ArrayList<View.AttachInfo.InvalidateInfo> mViewRects;
        private final ArrayList<View> mViews = new ArrayList();

        InvalidateOnAnimationRunnable() {
            this.mViewRects = new ArrayList();
        }

        private void postIfNeededLocked() {
            if (!this.mPosted) {
                ViewRootImpl.this.mChoreographer.postCallback(1, this, null);
                this.mPosted = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void addView(View view) {
            synchronized (this) {
                this.mViews.add(view);
                this.postIfNeededLocked();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void addViewRect(View.AttachInfo.InvalidateInfo invalidateInfo) {
            synchronized (this) {
                this.mViewRects.add(invalidateInfo);
                this.postIfNeededLocked();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void removeView(View view) {
            synchronized (this) {
                this.mViews.remove(view);
                int n = this.mViewRects.size();
                while (true) {
                    int n2 = n - 1;
                    if (n > 0) {
                        View.AttachInfo.InvalidateInfo invalidateInfo = this.mViewRects.get(n2);
                        if (invalidateInfo.target == view) {
                            this.mViewRects.remove(n2);
                            invalidateInfo.recycle();
                        }
                    } else {
                        if (this.mPosted && this.mViews.isEmpty() && this.mViewRects.isEmpty()) {
                            ViewRootImpl.this.mChoreographer.removeCallbacks(1, this, null);
                            this.mPosted = false;
                        }
                        return;
                    }
                    n = n2;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int n;
            int n2;
            synchronized (this) {
                this.mPosted = false;
                n2 = this.mViews.size();
                if (n2 != 0) {
                    ArrayList<View> arrayList = this.mViews;
                    View[] viewArray = this.mTempViews != null ? this.mTempViews : new View[n2];
                    this.mTempViews = arrayList.toArray(viewArray);
                    this.mViews.clear();
                }
                if ((n = this.mViewRects.size()) != 0) {
                    ArrayList<View.AttachInfo.InvalidateInfo> arrayList = this.mViewRects;
                    View.AttachInfo.InvalidateInfo[] invalidateInfoArray = this.mTempViewRects != null ? this.mTempViewRects : new View.AttachInfo.InvalidateInfo[n];
                    this.mTempViewRects = arrayList.toArray(invalidateInfoArray);
                    this.mViewRects.clear();
                }
            }
            for (int i = 0; i < n2; ++i) {
                this.mTempViews[i].invalidate();
                this.mTempViews[i] = null;
            }
            int n3 = 0;
            while (n3 < n) {
                View.AttachInfo.InvalidateInfo invalidateInfo = this.mTempViewRects[n3];
                invalidateInfo.target.invalidate(invalidateInfo.left, invalidateInfo.top, invalidateInfo.right, invalidateInfo.bottom);
                invalidateInfo.recycle();
                ++n3;
            }
            return;
        }
    }

    final class NativePostImeInputStage
    extends AsyncInputStage
    implements InputQueue.FinishedInputEventCallback {
        public NativePostImeInputStage(InputStage inputStage, String string2) {
            super(inputStage, string2);
        }

        @Override
        public void onFinishedInputEvent(Object object, boolean bl) {
            QueuedInputEvent queuedInputEvent = (QueuedInputEvent)object;
            if (bl) {
                this.finish(queuedInputEvent, true);
                return;
            }
            this.forward(queuedInputEvent);
        }

        @Override
        protected int onProcess(QueuedInputEvent queuedInputEvent) {
            InputQueue inputQueue = ViewRootImpl.this.mInputQueue;
            int n = 0;
            if (inputQueue != null) {
                ViewRootImpl.this.mInputQueue.sendInputEvent(queuedInputEvent.mEvent, queuedInputEvent, false, this);
                n = 3;
            }
            return n;
        }
    }

    final class NativePreImeInputStage
    extends AsyncInputStage
    implements InputQueue.FinishedInputEventCallback {
        public NativePreImeInputStage(InputStage inputStage, String string2) {
            super(inputStage, string2);
        }

        @Override
        public void onFinishedInputEvent(Object object, boolean bl) {
            QueuedInputEvent queuedInputEvent = (QueuedInputEvent)object;
            if (bl) {
                this.finish(queuedInputEvent, true);
                return;
            }
            this.forward(queuedInputEvent);
        }

        @Override
        protected int onProcess(QueuedInputEvent queuedInputEvent) {
            if (ViewRootImpl.this.mInputQueue != null && queuedInputEvent.mEvent instanceof KeyEvent) {
                ViewRootImpl.this.mInputQueue.sendInputEvent(queuedInputEvent.mEvent, queuedInputEvent, true, this);
                return 3;
            }
            return 0;
        }
    }

    private static final class QueuedInputEvent {
        public static final int FLAG_DEFERRED = 2;
        public static final int FLAG_DELIVER_POST_IME = 1;
        public static final int FLAG_FINISHED = 4;
        public static final int FLAG_FINISHED_HANDLED = 8;
        public static final int FLAG_RESYNTHESIZED = 16;
        public static final int FLAG_UNHANDLED = 32;
        public InputEvent mEvent;
        public int mFlags;
        public QueuedInputEvent mNext;
        public InputEventReceiver mReceiver;

        private QueuedInputEvent() {
        }

        private boolean flagToString(String string2, int n, boolean bl, StringBuilder stringBuilder) {
            if ((n & this.mFlags) != 0) {
                if (bl) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(string2);
                bl = true;
            }
            return bl;
        }

        public boolean shouldSendToSynthesizer() {
            return (0x20 & this.mFlags) != 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean shouldSkipIme() {
            return (1 & this.mFlags) != 0 || this.mEvent instanceof MotionEvent && this.mEvent.isFromSource(2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("QueuedInputEvent{flags=");
            if (!this.flagToString("UNHANDLED", 32, this.flagToString("RESYNTHESIZED", 16, this.flagToString("FINISHED_HANDLED", 8, this.flagToString("FINISHED", 4, this.flagToString("DEFERRED", 2, this.flagToString("DELIVER_POST_IME", 1, false, stringBuilder), stringBuilder), stringBuilder), stringBuilder), stringBuilder), stringBuilder)) {
                stringBuilder.append("0");
            }
            StringBuilder stringBuilder2 = new StringBuilder().append(", hasNextQueuedEvent=");
            String string2 = this.mEvent != null ? "true" : "false";
            stringBuilder.append(stringBuilder2.append(string2).toString());
            StringBuilder stringBuilder3 = new StringBuilder().append(", hasInputEventReceiver=");
            String string3 = this.mReceiver != null ? "true" : "false";
            stringBuilder.append(stringBuilder3.append(string3).toString());
            stringBuilder.append(", mEvent=" + this.mEvent + "}");
            return stringBuilder.toString();
        }
    }

    static final class RunQueue {
        private final ArrayList<HandlerAction> mActions = new ArrayList();

        RunQueue() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void executeActions(Handler handler) {
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> arrayList2 = this.mActions;
                int n = arrayList2.size();
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        arrayList2.clear();
                        return;
                    }
                    HandlerAction handlerAction = arrayList2.get(n2);
                    handler.postDelayed(handlerAction.action, handlerAction.delay);
                    ++n2;
                }
            }
        }

        void post(Runnable runnable) {
            this.postDelayed(runnable, 0L);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void postDelayed(Runnable runnable, long l) {
            HandlerAction handlerAction = new HandlerAction();
            handlerAction.action = runnable;
            handlerAction.delay = l;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                this.mActions.add(handlerAction);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void removeCallbacks(Runnable runnable) {
            HandlerAction handlerAction = new HandlerAction();
            handlerAction.action = runnable;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> arrayList2 = this.mActions;
                while (arrayList2.remove(handlerAction)) {
                }
                return;
            }
        }

        private static class HandlerAction {
            Runnable action;
            long delay;

            private HandlerAction() {
            }

            /*
             * Enabled aggressive block sorting
             */
            public boolean equals(Object object) {
                if (this == object) return true;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                HandlerAction handlerAction = (HandlerAction)object;
                if (this.action != null) {
                    if (!this.action.equals(handlerAction.action)) return false;
                    return true;
                }
                if (handlerAction.action == null) return true;
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public int hashCode() {
                int n;
                if (this.action != null) {
                    n = this.action.hashCode();
                    return n * 31 + (int)(this.delay ^ this.delay >>> 32);
                }
                n = 0;
                return n * 31 + (int)(this.delay ^ this.delay >>> 32);
            }
        }
    }

    private class SendWindowContentChangedAccessibilityEvent
    implements Runnable {
        private int mChangeTypes = 0;
        public long mLastEventTimeMillis;
        public View mSource;

        private SendWindowContentChangedAccessibilityEvent() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            if (AccessibilityManager.getInstance(ViewRootImpl.this.mContext).isEnabled()) {
                this.mLastEventTimeMillis = SystemClock.uptimeMillis();
                AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain();
                accessibilityEvent.setEventType(2048);
                accessibilityEvent.setContentChangeTypes(this.mChangeTypes);
                this.mSource.sendAccessibilityEventUnchecked(accessibilityEvent);
            } else {
                this.mLastEventTimeMillis = 0L;
            }
            this.mSource.resetSubtreeAccessibilityStateChanged();
            this.mSource = null;
            this.mChangeTypes = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void runOrPost(View view, int n) {
            long l;
            if (this.mSource != null) {
                View view2 = ViewRootImpl.this.getCommonPredecessor(this.mSource, view);
                if (view2 == null) {
                    view2 = view;
                }
                this.mSource = view2;
                this.mChangeTypes = n | this.mChangeTypes;
                return;
            }
            this.mSource = view;
            this.mChangeTypes = n;
            long l2 = SystemClock.uptimeMillis() - this.mLastEventTimeMillis;
            if (l2 >= (l = ViewConfiguration.getSendRecurringAccessibilityEventsInterval())) {
                this.mSource.removeCallbacks(this);
                this.run();
                return;
            }
            this.mSource.postDelayed(this, l - l2);
        }
    }

    final class SyntheticInputStage
    extends InputStage {
        private final SyntheticJoystickHandler mJoystick;
        private final SyntheticKeyboardHandler mKeyboard;
        private final SyntheticTouchNavigationHandler mTouchNavigation;
        private final SyntheticTrackballHandler mTrackball;

        public SyntheticInputStage() {
            super(null);
            this.mTrackball = new SyntheticTrackballHandler();
            this.mJoystick = new SyntheticJoystickHandler();
            this.mTouchNavigation = new SyntheticTouchNavigationHandler();
            this.mKeyboard = new SyntheticKeyboardHandler();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void onDeliverToNext(QueuedInputEvent queuedInputEvent) {
            if ((0x10 & queuedInputEvent.mFlags) == 0 && queuedInputEvent.mEvent instanceof MotionEvent) {
                MotionEvent motionEvent = (MotionEvent)queuedInputEvent.mEvent;
                int n = motionEvent.getSource();
                if ((n & 4) != 0) {
                    this.mTrackball.cancel(motionEvent);
                } else if ((n & 0x10) != 0) {
                    this.mJoystick.cancel(motionEvent);
                } else if ((n & 0x200000) == 0x200000) {
                    this.mTouchNavigation.cancel(motionEvent);
                }
            }
            super.onDeliverToNext(queuedInputEvent);
        }

        @Override
        protected int onProcess(QueuedInputEvent queuedInputEvent) {
            queuedInputEvent.mFlags = 0x10 | queuedInputEvent.mFlags;
            if (queuedInputEvent.mEvent instanceof MotionEvent) {
                MotionEvent motionEvent = (MotionEvent)queuedInputEvent.mEvent;
                int n = motionEvent.getSource();
                if ((n & 4) != 0) {
                    this.mTrackball.process(motionEvent);
                    return 1;
                }
                if ((n & 0x10) != 0) {
                    this.mJoystick.process(motionEvent);
                    return 1;
                }
                if ((n & 0x200000) == 0x200000) {
                    this.mTouchNavigation.process(motionEvent);
                    return 1;
                }
            } else if ((0x20 & queuedInputEvent.mFlags) != 0) {
                this.mKeyboard.process((KeyEvent)queuedInputEvent.mEvent);
                return 1;
            }
            return 0;
        }
    }

    final class SyntheticJoystickHandler
    extends Handler {
        private static final int MSG_ENQUEUE_X_AXIS_KEY_REPEAT = 1;
        private static final int MSG_ENQUEUE_Y_AXIS_KEY_REPEAT = 2;
        private static final String TAG = "SyntheticJoystickHandler";
        private int mLastXDirection;
        private int mLastXKeyCode;
        private int mLastYDirection;
        private int mLastYKeyCode;

        public SyntheticJoystickHandler() {
            super(true);
        }

        private void cancel(MotionEvent motionEvent) {
            this.removeMessages(1);
            this.removeMessages(2);
            this.update(motionEvent, false);
        }

        private int joystickAxisValueToDirection(float f) {
            if (f >= 0.5f) {
                return 1;
            }
            if (f <= -0.5f) {
                return -1;
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void update(MotionEvent motionEvent, boolean bl) {
            int n;
            int n2;
            int n3;
            long l = motionEvent.getEventTime();
            int n4 = motionEvent.getMetaState();
            int n5 = motionEvent.getDeviceId();
            int n6 = motionEvent.getSource();
            int n7 = this.joystickAxisValueToDirection(motionEvent.getAxisValue(15));
            if (n7 == 0) {
                n7 = this.joystickAxisValueToDirection(motionEvent.getX());
            }
            if ((n3 = this.joystickAxisValueToDirection(motionEvent.getAxisValue(16))) == 0) {
                n3 = this.joystickAxisValueToDirection(motionEvent.getY());
            }
            if (n7 != (n2 = this.mLastXDirection)) {
                if (this.mLastXKeyCode != 0) {
                    this.removeMessages(1);
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(l, l, 1, this.mLastXKeyCode, 0, n4, n5, 0, 1024, n6));
                    this.mLastXKeyCode = 0;
                }
                this.mLastXDirection = n7;
                if (n7 != 0 && bl) {
                    int n8 = n7 > 0 ? 22 : 21;
                    this.mLastXKeyCode = n8;
                    KeyEvent keyEvent = new KeyEvent(l, l, 0, this.mLastXKeyCode, 0, n4, n5, 0, 1024, n6);
                    ViewRootImpl.this.enqueueInputEvent(keyEvent);
                    Message message = this.obtainMessage(1, keyEvent);
                    message.setAsynchronous(true);
                    this.sendMessageDelayed(message, ViewConfiguration.getKeyRepeatTimeout());
                }
            }
            if (n3 != (n = this.mLastYDirection)) {
                if (this.mLastYKeyCode != 0) {
                    this.removeMessages(2);
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(l, l, 1, this.mLastYKeyCode, 0, n4, n5, 0, 1024, n6));
                    this.mLastYKeyCode = 0;
                }
                this.mLastYDirection = n3;
                if (n3 != 0 && bl) {
                    int n9 = n3 > 0 ? 20 : 19;
                    this.mLastYKeyCode = n9;
                    KeyEvent keyEvent = new KeyEvent(l, l, 0, this.mLastYKeyCode, 0, n4, n5, 0, 1024, n6);
                    ViewRootImpl.this.enqueueInputEvent(keyEvent);
                    Message message = this.obtainMessage(2, keyEvent);
                    message.setAsynchronous(true);
                    this.sendMessageDelayed(message, ViewConfiguration.getKeyRepeatTimeout());
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: 
                case 2: {
                    KeyEvent keyEvent = (KeyEvent)message.obj;
                    KeyEvent keyEvent2 = KeyEvent.changeTimeRepeat(keyEvent, SystemClock.uptimeMillis(), 1 + keyEvent.getRepeatCount());
                    if (!ViewRootImpl.this.mAttachInfo.mHasWindowFocus) return;
                    ViewRootImpl.this.enqueueInputEvent(keyEvent2);
                    Message message2 = this.obtainMessage(message.what, keyEvent2);
                    message2.setAsynchronous(true);
                    this.sendMessageDelayed(message2, ViewConfiguration.getKeyRepeatDelay());
                    return;
                }
            }
        }

        public void process(MotionEvent motionEvent) {
            switch (motionEvent.getActionMasked()) {
                default: {
                    Log.w(TAG, "Unexpected action: " + motionEvent.getActionMasked());
                    return;
                }
                case 3: {
                    this.cancel(motionEvent);
                    return;
                }
                case 2: 
            }
            this.update(motionEvent, true);
        }
    }

    final class SyntheticKeyboardHandler {
        SyntheticKeyboardHandler() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void process(KeyEvent keyEvent) {
            KeyCharacterMap.FallbackAction fallbackAction;
            if ((0x400 & keyEvent.getFlags()) != 0 || (fallbackAction = keyEvent.getKeyCharacterMap().getFallbackAction(keyEvent.getKeyCode(), keyEvent.getMetaState())) == null) {
                return;
            }
            int n = 0x400 | keyEvent.getFlags();
            KeyEvent keyEvent2 = KeyEvent.obtain(keyEvent.getDownTime(), keyEvent.getEventTime(), keyEvent.getAction(), fallbackAction.keyCode, keyEvent.getRepeatCount(), fallbackAction.metaState, keyEvent.getDeviceId(), keyEvent.getScanCode(), n, keyEvent.getSource(), null);
            fallbackAction.recycle();
            ViewRootImpl.this.enqueueInputEvent(keyEvent2);
        }
    }

    final class SyntheticTouchNavigationHandler
    extends Handler {
        private static final float DEFAULT_HEIGHT_MILLIMETERS = 48.0f;
        private static final float DEFAULT_WIDTH_MILLIMETERS = 48.0f;
        private static final float FLING_TICK_DECAY = 0.8f;
        private static final boolean LOCAL_DEBUG = false;
        private static final String LOCAL_TAG = "SyntheticTouchNavigationHandler";
        private static final float MAX_FLING_VELOCITY_TICKS_PER_SECOND = 20.0f;
        private static final float MIN_FLING_VELOCITY_TICKS_PER_SECOND = 6.0f;
        private static final int TICK_DISTANCE_MILLIMETERS = 12;
        private float mAccumulatedX;
        private float mAccumulatedY;
        private int mActivePointerId;
        private float mConfigMaxFlingVelocity;
        private float mConfigMinFlingVelocity;
        private float mConfigTickDistance;
        private boolean mConsumedMovement;
        private int mCurrentDeviceId;
        private boolean mCurrentDeviceSupported;
        private int mCurrentSource;
        private final Runnable mFlingRunnable;
        private float mFlingVelocity;
        private boolean mFlinging;
        private float mLastX;
        private float mLastY;
        private int mPendingKeyCode;
        private long mPendingKeyDownTime;
        private int mPendingKeyMetaState;
        private int mPendingKeyRepeatCount;
        private float mStartX;
        private float mStartY;
        private VelocityTracker mVelocityTracker;

        public SyntheticTouchNavigationHandler() {
            super(true);
            this.mCurrentDeviceId = -1;
            this.mActivePointerId = -1;
            this.mPendingKeyCode = 0;
            this.mFlingRunnable = new Runnable(){

                @Override
                public void run() {
                    long l = SystemClock.uptimeMillis();
                    SyntheticTouchNavigationHandler.this.sendKeyDownOrRepeat(l, SyntheticTouchNavigationHandler.this.mPendingKeyCode, SyntheticTouchNavigationHandler.this.mPendingKeyMetaState);
                    SyntheticTouchNavigationHandler.access$1432(SyntheticTouchNavigationHandler.this, 0.8f);
                    if (!SyntheticTouchNavigationHandler.this.postFling(l)) {
                        SyntheticTouchNavigationHandler.access$1602(SyntheticTouchNavigationHandler.this, false);
                        SyntheticTouchNavigationHandler.this.finishKeys(l);
                    }
                }
            };
        }

        static /* synthetic */ float access$1432(SyntheticTouchNavigationHandler syntheticTouchNavigationHandler, float f) {
            float f2;
            syntheticTouchNavigationHandler.mFlingVelocity = f2 = f * syntheticTouchNavigationHandler.mFlingVelocity;
            return f2;
        }

        static /* synthetic */ boolean access$1602(SyntheticTouchNavigationHandler syntheticTouchNavigationHandler, boolean bl) {
            syntheticTouchNavigationHandler.mFlinging = bl;
            return bl;
        }

        private void cancelFling() {
            if (this.mFlinging) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlinging = false;
            }
        }

        private float consumeAccumulatedMovement(long l, int n, float f, int n2, int n3) {
            while (f <= -this.mConfigTickDistance) {
                this.sendKeyDownOrRepeat(l, n2, n);
                f += this.mConfigTickDistance;
            }
            while (f >= this.mConfigTickDistance) {
                this.sendKeyDownOrRepeat(l, n3, n);
                f -= this.mConfigTickDistance;
            }
            return f;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void consumeAccumulatedMovement(long l, int n) {
            float f;
            float f2 = Math.abs(this.mAccumulatedX);
            if (f2 >= (f = Math.abs(this.mAccumulatedY))) {
                if (!(f2 >= this.mConfigTickDistance)) return;
                this.mAccumulatedX = this.consumeAccumulatedMovement(l, n, this.mAccumulatedX, 21, 22);
                this.mAccumulatedY = 0.0f;
                this.mConsumedMovement = true;
                return;
            }
            if (!(f >= this.mConfigTickDistance)) return;
            this.mAccumulatedY = this.consumeAccumulatedMovement(l, n, this.mAccumulatedY, 19, 20);
            this.mAccumulatedX = 0.0f;
            this.mConsumedMovement = true;
        }

        private void finishKeys(long l) {
            this.cancelFling();
            this.sendKeyUp(l);
        }

        private void finishTracking(long l) {
            if (this.mActivePointerId >= 0) {
                this.mActivePointerId = -1;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }

        private boolean postFling(long l) {
            if (this.mFlingVelocity >= this.mConfigMinFlingVelocity) {
                long l2 = (long)(1000.0f * (this.mConfigTickDistance / this.mFlingVelocity));
                this.postAtTime(this.mFlingRunnable, l + l2);
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void sendKeyDownOrRepeat(long l, int n, int n2) {
            if (this.mPendingKeyCode != n) {
                this.sendKeyUp(l);
                this.mPendingKeyDownTime = l;
                this.mPendingKeyCode = n;
                this.mPendingKeyRepeatCount = 0;
            } else {
                this.mPendingKeyRepeatCount = 1 + this.mPendingKeyRepeatCount;
            }
            this.mPendingKeyMetaState = n2;
            ViewRootImpl.this.enqueueInputEvent(new KeyEvent(this.mPendingKeyDownTime, l, 0, this.mPendingKeyCode, this.mPendingKeyRepeatCount, this.mPendingKeyMetaState, this.mCurrentDeviceId, 1024, this.mCurrentSource));
        }

        private void sendKeyUp(long l) {
            if (this.mPendingKeyCode != 0) {
                ViewRootImpl.this.enqueueInputEvent(new KeyEvent(this.mPendingKeyDownTime, l, 1, this.mPendingKeyCode, 0, this.mPendingKeyMetaState, this.mCurrentDeviceId, 0, 1024, this.mCurrentSource));
                this.mPendingKeyCode = 0;
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean startFling(long var1_1, float var3_2, float var4_3) {
            switch (this.mPendingKeyCode) lbl-1000:
            // 4 sources

            {
                default: lbl-1000:
                // 2 sources

                {
                    while (true) {
                        var6_4 = this.mFlinging = this.postFling(var1_1);
lbl5:
                        // 9 sources

                        return var6_4;
                    }
                }
                case 21: {
                    cfr_temp_0 = -var3_2 - this.mConfigMinFlingVelocity;
                    var12_5 = cfr_temp_0 == 0.0f ? 0 : (cfr_temp_0 > 0.0f ? 1 : -1);
                    var6_4 = false;
                    if (var12_5 < 0) ** GOTO lbl5
                    cfr_temp_1 = Math.abs(var4_3) - this.mConfigMinFlingVelocity;
                    var13_6 = cfr_temp_1 == 0.0f ? 0 : (cfr_temp_1 < 0.0f ? -1 : 1);
                    var6_4 = false;
                    if (var13_6 >= 0) ** GOTO lbl5
                    this.mFlingVelocity = -var3_2;
                    ** GOTO lbl-1000
                }
                case 22: {
                    cfr_temp_2 = var3_2 - this.mConfigMinFlingVelocity;
                    var10_7 = cfr_temp_2 == 0.0f ? 0 : (cfr_temp_2 > 0.0f ? 1 : -1);
                    var6_4 = false;
                    if (var10_7 < 0) ** GOTO lbl5
                    cfr_temp_3 = Math.abs(var4_3) - this.mConfigMinFlingVelocity;
                    var11_8 = cfr_temp_3 == 0.0f ? 0 : (cfr_temp_3 < 0.0f ? -1 : 1);
                    var6_4 = false;
                    if (var11_8 >= 0) ** GOTO lbl5
                    this.mFlingVelocity = var3_2;
                    ** GOTO lbl-1000
                }
                case 19: {
                    cfr_temp_4 = -var4_3 - this.mConfigMinFlingVelocity;
                    var8_9 = cfr_temp_4 == 0.0f ? 0 : (cfr_temp_4 > 0.0f ? 1 : -1);
                    var6_4 = false;
                    if (var8_9 < 0) ** GOTO lbl5
                    cfr_temp_5 = Math.abs(var3_2) - this.mConfigMinFlingVelocity;
                    var9_10 = cfr_temp_5 == 0.0f ? 0 : (cfr_temp_5 < 0.0f ? -1 : 1);
                    var6_4 = false;
                    if (var9_10 >= 0) ** GOTO lbl5
                    this.mFlingVelocity = -var4_3;
                    ** GOTO lbl-1000
                }
                case 20: 
            }
            cfr_temp_6 = var4_3 - this.mConfigMinFlingVelocity;
            var5_11 = cfr_temp_6 == 0.0f ? 0 : (cfr_temp_6 > 0.0f ? 1 : -1);
            var6_4 = false;
            if (var5_11 < 0) ** GOTO lbl5
            cfr_temp_7 = Math.abs(var3_2) - this.mConfigMinFlingVelocity;
            var7_12 = cfr_temp_7 == 0.0f ? 0 : (cfr_temp_7 < 0.0f ? -1 : 1);
            var6_4 = false;
            if (var7_12 < 0) ** break;
            ** while (true)
            this.mFlingVelocity = var4_3;
            ** while (true)
        }

        public void cancel(MotionEvent motionEvent) {
            if (this.mCurrentDeviceId == motionEvent.getDeviceId() && this.mCurrentSource == motionEvent.getSource()) {
                long l = motionEvent.getEventTime();
                this.finishKeys(l);
                this.finishTracking(l);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        public void process(MotionEvent motionEvent) {
            long l = motionEvent.getEventTime();
            int n = motionEvent.getDeviceId();
            int n2 = motionEvent.getSource();
            if (this.mCurrentDeviceId != n || this.mCurrentSource != n2) {
                this.finishKeys(l);
                this.finishTracking(l);
                this.mCurrentDeviceId = n;
                this.mCurrentSource = n2;
                this.mCurrentDeviceSupported = false;
                InputDevice inputDevice = motionEvent.getDevice();
                if (inputDevice != null) {
                    InputDevice.MotionRange motionRange = inputDevice.getMotionRange(0);
                    InputDevice.MotionRange motionRange2 = inputDevice.getMotionRange(1);
                    if (motionRange != null && motionRange2 != null) {
                        float f;
                        this.mCurrentDeviceSupported = true;
                        float f2 = motionRange.getResolution();
                        if (f2 <= 0.0f) {
                            f2 = motionRange.getRange() / 48.0f;
                        }
                        if ((f = motionRange2.getResolution()) <= 0.0f) {
                            f = motionRange2.getRange() / 48.0f;
                        }
                        this.mConfigTickDistance = 12.0f * (0.5f * (f2 + f));
                        this.mConfigMinFlingVelocity = 6.0f * this.mConfigTickDistance;
                        this.mConfigMaxFlingVelocity = 20.0f * this.mConfigTickDistance;
                    }
                }
            }
            if (!this.mCurrentDeviceSupported) {
                return;
            }
            int n3 = motionEvent.getActionMasked();
            switch (n3) {
                default: {
                    return;
                }
                case 0: {
                    boolean bl = this.mFlinging;
                    this.finishKeys(l);
                    this.finishTracking(l);
                    this.mActivePointerId = motionEvent.getPointerId(0);
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(motionEvent);
                    this.mStartX = motionEvent.getX();
                    this.mStartY = motionEvent.getY();
                    this.mLastX = this.mStartX;
                    this.mLastY = this.mStartY;
                    this.mAccumulatedX = 0.0f;
                    this.mAccumulatedY = 0.0f;
                    this.mConsumedMovement = bl;
                    return;
                }
                case 1: 
                case 2: {
                    if (this.mActivePointerId < 0) return;
                    int n4 = motionEvent.findPointerIndex(this.mActivePointerId);
                    if (n4 < 0) {
                        this.finishKeys(l);
                        this.finishTracking(l);
                        return;
                    }
                    this.mVelocityTracker.addMovement(motionEvent);
                    float f = motionEvent.getX(n4);
                    float f3 = motionEvent.getY(n4);
                    this.mAccumulatedX += f - this.mLastX;
                    this.mAccumulatedY += f3 - this.mLastY;
                    this.mLastX = f;
                    this.mLastY = f3;
                    this.consumeAccumulatedMovement(l, motionEvent.getMetaState());
                    if (n3 != 1) return;
                    if (this.mConsumedMovement && this.mPendingKeyCode != 0) {
                        this.mVelocityTracker.computeCurrentVelocity(1000, this.mConfigMaxFlingVelocity);
                        if (!this.startFling(l, this.mVelocityTracker.getXVelocity(this.mActivePointerId), this.mVelocityTracker.getYVelocity(this.mActivePointerId))) {
                            this.finishKeys(l);
                        }
                    }
                    this.finishTracking(l);
                    return;
                }
                case 3: 
            }
            this.finishKeys(l);
            this.finishTracking(l);
        }
    }

    final class SyntheticTrackballHandler {
        private long mLastTime;
        private final TrackballAxis mX = new TrackballAxis();
        private final TrackballAxis mY = new TrackballAxis();

        SyntheticTrackballHandler() {
        }

        public void cancel(MotionEvent motionEvent) {
            this.mLastTime = Integer.MIN_VALUE;
            if (ViewRootImpl.this.mView != null && ViewRootImpl.this.mAdded) {
                ViewRootImpl.this.ensureTouchMode(false);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void process(MotionEvent motionEvent) {
            int n;
            int n2;
            long l = SystemClock.uptimeMillis();
            if (250L + this.mLastTime < l) {
                this.mX.reset(0);
                this.mY.reset(0);
                this.mLastTime = l;
            }
            int n3 = motionEvent.getAction();
            int n4 = motionEvent.getMetaState();
            switch (n3) {
                case 0: {
                    this.mX.reset(2);
                    this.mY.reset(2);
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(l, l, 0, 23, 0, n4, -1, 0, 1024, 257));
                    break;
                }
                case 1: {
                    this.mX.reset(2);
                    this.mY.reset(2);
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(l, l, 1, 23, 0, n4, -1, 0, 1024, 257));
                }
            }
            float f = this.mX.collect(motionEvent.getX(), motionEvent.getEventTime(), "X");
            float f2 = this.mY.collect(motionEvent.getY(), motionEvent.getEventTime(), "Y");
            float f3 = 1.0f;
            if (f > f2) {
                n2 = this.mX.generate();
                n = 0;
                if (n2 != 0) {
                    n = n2 > 0 ? 22 : 21;
                    f3 = this.mX.acceleration;
                    this.mY.reset(2);
                }
            } else {
                float f4 = f2 - 0.0f;
                float f5 = f4 == 0.0f ? 0 : (f4 > 0.0f ? 1 : -1);
                n = 0;
                n2 = 0;
                if (f5 > 0) {
                    n2 = this.mY.generate();
                    n = 0;
                    if (n2 != 0) {
                        n = n2 > 0 ? 20 : 19;
                        f3 = this.mY.acceleration;
                        this.mX.reset(2);
                    }
                }
            }
            if (n != 0) {
                int n5;
                if (n2 < 0) {
                    n2 = -n2;
                }
                if ((n5 = (int)(f3 * (float)n2)) > n2) {
                    int n6 = n5 - --n2;
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(l, l, 2, n, n6, n4, -1, 0, 1024, 257));
                }
                while (n2 > 0) {
                    --n2;
                    l = SystemClock.uptimeMillis();
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(l, l, 0, n, 0, n4, -1, 0, 1024, 257));
                    ViewRootImpl.this.enqueueInputEvent(new KeyEvent(l, l, 1, n, 0, n4, -1, 0, 1024, 257));
                }
                this.mLastTime = l;
            }
        }
    }

    static final class SystemUiVisibilityInfo {
        int globalVisibility;
        int localChanges;
        int localValue;
        int seq;

        SystemUiVisibilityInfo() {
        }
    }

    class TakenSurfaceHolder
    extends BaseSurfaceHolder {
        TakenSurfaceHolder() {
        }

        @Override
        public boolean isCreating() {
            return ViewRootImpl.this.mIsCreating;
        }

        @Override
        public boolean onAllowLockCanvas() {
            return ViewRootImpl.this.mDrawingAllowed;
        }

        @Override
        public void onRelayoutContainer() {
        }

        @Override
        public void onUpdateSurface() {
            throw new IllegalStateException("Shouldn't be here");
        }

        @Override
        public void setFixedSize(int n, int n2) {
            throw new UnsupportedOperationException("Currently only support sizing from layout");
        }

        @Override
        public void setFormat(int n) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceFormat(n);
        }

        @Override
        public void setKeepScreenOn(boolean bl) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceKeepScreenOn(bl);
        }

        @Override
        public void setType(int n) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceType(n);
        }
    }

    static final class TrackballAxis {
        static final float ACCEL_MOVE_SCALING_FACTOR = 0.025f;
        static final long FAST_MOVE_TIME = 150L;
        static final float FIRST_MOVEMENT_THRESHOLD = 0.5f;
        static final float MAX_ACCELERATION = 20.0f;
        static final float SECOND_CUMULATIVE_MOVEMENT_THRESHOLD = 2.0f;
        static final float SUBSEQUENT_INCREMENTAL_MOVEMENT_THRESHOLD = 1.0f;
        float acceleration = 1.0f;
        int dir;
        long lastMoveTime = 0L;
        int nonAccelMovement;
        float position;
        int step;

        TrackballAxis() {
        }

        /*
         * Enabled aggressive block sorting
         */
        float collect(float f, long l, String string2) {
            long l2;
            if (f > 0.0f) {
                l2 = (long)(150.0f * f);
                if (this.dir < 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = 1;
            } else if (f < 0.0f) {
                l2 = (long)(150.0f * -f);
                if (this.dir > 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = -1;
            } else {
                l2 = 0L;
            }
            if (l2 > 0L) {
                long l3 = l - this.lastMoveTime;
                this.lastMoveTime = l;
                float f2 = this.acceleration;
                if (l3 < l2) {
                    float f3 = 0.025f * (float)(l2 - l3);
                    if (f3 > 1.0f) {
                        f2 *= f3;
                    }
                    if (!(f2 < 20.0f)) {
                        f2 = 20.0f;
                    }
                    this.acceleration = f2;
                } else {
                    float f4 = 0.025f * (float)(l3 - l2);
                    if (f4 > 1.0f) {
                        f2 /= f4;
                    }
                    if (!(f2 > 1.0f)) {
                        f2 = 1.0f;
                    }
                    this.acceleration = f2;
                }
            }
            this.position = f + this.position;
            return Math.abs(this.position);
        }

        /*
         * Enabled aggressive block sorting
         */
        int generate() {
            int n = 0;
            this.nonAccelMovement = 0;
            block4: while (true) {
                int n2;
                block7: {
                    block8: {
                        n2 = this.position >= 0.0f ? 1 : -1;
                        switch (this.step) {
                            default: {
                                if (Math.abs(this.position) < 1.0f) {
                                    return n;
                                }
                                break block7;
                            }
                            case 0: {
                                if (Math.abs(this.position) < 0.5f) return n;
                                n += n2;
                                this.nonAccelMovement = n2 + this.nonAccelMovement;
                                this.step = 1;
                                continue block4;
                            }
                            case 1: {
                                if (!(Math.abs(this.position) < 2.0f)) break block8;
                            }
                        }
                        return n;
                    }
                    n += n2;
                    this.nonAccelMovement = n2 + this.nonAccelMovement;
                    this.position -= 2.0f * (float)n2;
                    this.step = 2;
                    continue;
                }
                n += n2;
                this.position -= 1.0f * (float)n2;
                float f = 1.1f * this.acceleration;
                if (!(f < 20.0f)) {
                    f = this.acceleration;
                }
                this.acceleration = f;
            }
        }

        void reset(int n) {
            this.position = 0.0f;
            this.acceleration = 1.0f;
            this.lastMoveTime = 0L;
            this.step = n;
            this.dir = 0;
        }
    }

    final class TraversalRunnable
    implements Runnable {
        TraversalRunnable() {
        }

        @Override
        public void run() {
            ViewRootImpl.this.doTraversal();
        }
    }

    final class ViewPostImeInputStage
    extends InputStage {
        public ViewPostImeInputStage(InputStage inputStage) {
            super(inputStage);
        }

        private int processGenericMotionEvent(QueuedInputEvent queuedInputEvent) {
            MotionEvent motionEvent = (MotionEvent)queuedInputEvent.mEvent;
            if (ViewRootImpl.this.mView.dispatchGenericMotionEvent(motionEvent)) {
                return 1;
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        private int processKeyEvent(QueuedInputEvent queuedInputEvent) {
            int n = 2;
            KeyEvent keyEvent = (KeyEvent)queuedInputEvent.mEvent;
            if (keyEvent.getAction() != 1) {
                ViewRootImpl.this.handleDispatchDoneAnimating();
            }
            if (ViewRootImpl.this.mView.dispatchKeyEvent(keyEvent)) {
                return 1;
            }
            if (this.shouldDropInputEvent(queuedInputEvent)) return n;
            if (keyEvent.getAction() == 0 && keyEvent.isCtrlPressed() && keyEvent.getRepeatCount() == 0 && !KeyEvent.isModifierKey(keyEvent.getKeyCode())) {
                if (ViewRootImpl.this.mView.dispatchKeyShortcutEvent(keyEvent)) {
                    return 1;
                }
                if (this.shouldDropInputEvent(queuedInputEvent)) return n;
            }
            if (ViewRootImpl.this.mFallbackEventHandler.dispatchKeyEvent(keyEvent)) {
                return 1;
            }
            if (this.shouldDropInputEvent(queuedInputEvent)) return n;
            if (keyEvent.getAction() != 0) return 0;
            int n2 = keyEvent.getKeyCode();
            int n3 = 0;
            switch (n2) {
                case 21: {
                    boolean bl = keyEvent.hasNoModifiers();
                    n3 = 0;
                    if (!bl) break;
                    n3 = 17;
                    break;
                }
                case 22: {
                    boolean bl = keyEvent.hasNoModifiers();
                    n3 = 0;
                    if (!bl) break;
                    n3 = 66;
                    break;
                }
                case 19: {
                    boolean bl = keyEvent.hasNoModifiers();
                    n3 = 0;
                    if (!bl) break;
                    n3 = 33;
                    break;
                }
                case 20: {
                    boolean bl = keyEvent.hasNoModifiers();
                    n3 = 0;
                    if (!bl) break;
                    n3 = 130;
                    break;
                }
                case 61: {
                    if (keyEvent.hasNoModifiers()) {
                        n3 = 2;
                        break;
                    }
                    boolean bl = keyEvent.hasModifiers(1);
                    n3 = 0;
                    if (!bl) break;
                    n3 = 1;
                }
            }
            if (n3 == 0) return 0;
            View view = ViewRootImpl.this.mView.findFocus();
            if (view != null) {
                View view2 = view.focusSearch(n3);
                if (view2 != null && view2 != view) {
                    view.getFocusedRect(ViewRootImpl.this.mTempRect);
                    if (ViewRootImpl.this.mView instanceof ViewGroup) {
                        ((ViewGroup)ViewRootImpl.this.mView).offsetDescendantRectToMyCoords(view, ViewRootImpl.this.mTempRect);
                        ((ViewGroup)ViewRootImpl.this.mView).offsetRectIntoDescendantCoords(view2, ViewRootImpl.this.mTempRect);
                    }
                    if (view2.requestFocus(n3, ViewRootImpl.this.mTempRect)) {
                        ViewRootImpl.this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(n3));
                        return 1;
                    }
                }
                if (!ViewRootImpl.this.mView.dispatchUnhandledMove(view, n3)) return 0;
                return 1;
            }
            View view3 = ViewRootImpl.this.focusSearch(null, n3);
            if (view3 == null) return 0;
            if (!view3.requestFocus(n3)) return 0;
            return 1;
        }

        private int processPointerEvent(QueuedInputEvent queuedInputEvent) {
            MotionEvent motionEvent = (MotionEvent)queuedInputEvent.mEvent;
            ViewRootImpl.this.mAttachInfo.mUnbufferedDispatchRequested = false;
            boolean bl = ViewRootImpl.this.mView.dispatchPointerEvent(motionEvent);
            if (ViewRootImpl.this.mAttachInfo.mUnbufferedDispatchRequested && !ViewRootImpl.this.mUnbufferedInputDispatch) {
                ViewRootImpl.this.mUnbufferedInputDispatch = true;
                if (ViewRootImpl.this.mConsumeBatchedInputScheduled) {
                    ViewRootImpl.this.scheduleConsumeBatchedInputImmediately();
                }
            }
            if (bl) {
                return 1;
            }
            return 0;
        }

        private int processTrackballEvent(QueuedInputEvent queuedInputEvent) {
            MotionEvent motionEvent = (MotionEvent)queuedInputEvent.mEvent;
            if (ViewRootImpl.this.mView.dispatchTrackballEvent(motionEvent)) {
                return 1;
            }
            return 0;
        }

        @Override
        protected void onDeliverToNext(QueuedInputEvent queuedInputEvent) {
            if (ViewRootImpl.this.mUnbufferedInputDispatch && queuedInputEvent.mEvent instanceof MotionEvent && ((MotionEvent)queuedInputEvent.mEvent).isTouchEvent() && ViewRootImpl.isTerminalInputEvent(queuedInputEvent.mEvent)) {
                ViewRootImpl.this.mUnbufferedInputDispatch = false;
                ViewRootImpl.this.scheduleConsumeBatchedInput();
            }
            super.onDeliverToNext(queuedInputEvent);
        }

        @Override
        protected int onProcess(QueuedInputEvent queuedInputEvent) {
            if (queuedInputEvent.mEvent instanceof KeyEvent) {
                return this.processKeyEvent(queuedInputEvent);
            }
            ViewRootImpl.this.handleDispatchDoneAnimating();
            int n = queuedInputEvent.mEvent.getSource();
            if ((n & 2) != 0) {
                return this.processPointerEvent(queuedInputEvent);
            }
            if ((n & 4) != 0) {
                return this.processTrackballEvent(queuedInputEvent);
            }
            return this.processGenericMotionEvent(queuedInputEvent);
        }
    }

    final class ViewPreImeInputStage
    extends InputStage {
        public ViewPreImeInputStage(InputStage inputStage) {
            super(inputStage);
        }

        private int processKeyEvent(QueuedInputEvent queuedInputEvent) {
            KeyEvent keyEvent = (KeyEvent)queuedInputEvent.mEvent;
            if (ViewRootImpl.this.mView.dispatchKeyEventPreIme(keyEvent)) {
                return 1;
            }
            return 0;
        }

        @Override
        protected int onProcess(QueuedInputEvent queuedInputEvent) {
            if (queuedInputEvent.mEvent instanceof KeyEvent) {
                return this.processKeyEvent(queuedInputEvent);
            }
            return 0;
        }
    }

    final class ViewRootHandler
    extends Handler {
        ViewRootHandler() {
        }

        @Override
        public String getMessageName(Message message) {
            switch (message.what) {
                default: {
                    return super.getMessageName(message);
                }
                case 1: {
                    return "MSG_INVALIDATE";
                }
                case 2: {
                    return "MSG_INVALIDATE_RECT";
                }
                case 3: {
                    return "MSG_DIE";
                }
                case 4: {
                    return "MSG_RESIZED";
                }
                case 5: {
                    return "MSG_RESIZED_REPORT";
                }
                case 6: {
                    return "MSG_WINDOW_FOCUS_CHANGED";
                }
                case 7: {
                    return "MSG_DISPATCH_INPUT_EVENT";
                }
                case 8: {
                    return "MSG_DISPATCH_APP_VISIBILITY";
                }
                case 9: {
                    return "MSG_DISPATCH_GET_NEW_SURFACE";
                }
                case 11: {
                    return "MSG_DISPATCH_KEY_FROM_IME";
                }
                case 12: {
                    return "MSG_FINISH_INPUT_CONNECTION";
                }
                case 13: {
                    return "MSG_CHECK_FOCUS";
                }
                case 14: {
                    return "MSG_CLOSE_SYSTEM_DIALOGS";
                }
                case 15: {
                    return "MSG_DISPATCH_DRAG_EVENT";
                }
                case 16: {
                    return "MSG_DISPATCH_DRAG_LOCATION_EVENT";
                }
                case 17: {
                    return "MSG_DISPATCH_SYSTEM_UI_VISIBILITY";
                }
                case 18: {
                    return "MSG_UPDATE_CONFIGURATION";
                }
                case 19: {
                    return "MSG_PROCESS_INPUT_EVENTS";
                }
                case 21: {
                    return "MSG_CLEAR_ACCESSIBILITY_FOCUS_HOST";
                }
                case 22: {
                    return "MSG_DISPATCH_DONE_ANIMATING";
                }
                case 24: {
                    return "MSG_WINDOW_MOVED";
                }
                case 25: 
            }
            return "MSG_SYNTHESIZE_INPUT_EVENT";
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message var1_1) {
            switch (var1_1.what) {
                case 1: {
                    ((View)var1_1.obj).invalidate();
                    return;
                }
                case 2: {
                    var38_2 = (View.AttachInfo.InvalidateInfo)var1_1.obj;
                    var38_2.target.invalidate(var38_2.left, var38_2.top, var38_2.right, var38_2.bottom);
                    var38_2.recycle();
                    return;
                }
                case 19: {
                    ViewRootImpl.this.mProcessInputEventsScheduled = false;
                    ViewRootImpl.this.doProcessInputEvents();
                    return;
                }
                case 8: {
                    var36_3 = ViewRootImpl.this;
                    var37_4 = var1_1.arg1 != 0;
                    var36_3.handleAppVisibility(var37_4);
                    return;
                }
                case 9: {
                    ViewRootImpl.this.handleGetNewSurface();
                    return;
                }
                case 4: {
                    var35_5 = (SomeArgs)var1_1.obj;
                    if (ViewRootImpl.this.mWinFrame.equals(var35_5.arg1) && ViewRootImpl.this.mPendingOverscanInsets.equals(var35_5.arg5) && ViewRootImpl.this.mPendingContentInsets.equals(var35_5.arg2) && ViewRootImpl.this.mPendingStableInsets.equals(var35_5.arg6) && ViewRootImpl.this.mPendingVisibleInsets.equals(var35_5.arg3) && var35_5.arg4 == null) ** GOTO lbl115
                }
                case 5: {
                    if (ViewRootImpl.this.mAdded) {
                        var33_6 = (SomeArgs)var1_1.obj;
                        var34_7 = (Configuration)var33_6.arg4;
                        if (var34_7 != null) {
                            ViewRootImpl.this.updateConfiguration(var34_7, false);
                        }
                        ViewRootImpl.this.mWinFrame.set((Rect)var33_6.arg1);
                        ViewRootImpl.this.mPendingOverscanInsets.set((Rect)var33_6.arg5);
                        ViewRootImpl.this.mPendingContentInsets.set((Rect)var33_6.arg2);
                        ViewRootImpl.this.mPendingStableInsets.set((Rect)var33_6.arg6);
                        ViewRootImpl.this.mPendingVisibleInsets.set((Rect)var33_6.arg3);
                        var33_6.recycle();
                        if (var1_1.what == 5) {
                            ViewRootImpl.this.mReportNextDraw = true;
                        }
                        if (ViewRootImpl.this.mView != null) {
                            ViewRootImpl.access$200(ViewRootImpl.this.mView);
                        }
                        ViewRootImpl.this.requestLayout();
                        return;
                    } else {
                        ** GOTO lbl44
                    }
                }
                {
lbl44:
                    // 2 sources

                    ** GOTO lbl115
                }
                case 24: {
                    if (ViewRootImpl.this.mAdded) {
                        var29_8 = ViewRootImpl.this.mWinFrame.width();
                        var30_9 = ViewRootImpl.this.mWinFrame.height();
                        var31_10 = var1_1.arg1;
                        var32_11 = var1_1.arg2;
                        ViewRootImpl.this.mWinFrame.left = var31_10;
                        ViewRootImpl.this.mWinFrame.right = var31_10 + var29_8;
                        ViewRootImpl.this.mWinFrame.top = var32_11;
                        ViewRootImpl.this.mWinFrame.bottom = var32_11 + var30_9;
                        if (ViewRootImpl.this.mView != null) {
                            ViewRootImpl.access$200(ViewRootImpl.this.mView);
                        }
                        ViewRootImpl.this.requestLayout();
                        return;
                    }
                    ** GOTO lbl115
                }
                case 6: {
                    if (!ViewRootImpl.this.mAdded) ** GOTO lbl115
                    var11_12 = var1_1.arg1 != 0;
                    ViewRootImpl.this.mAttachInfo.mHasWindowFocus = var11_12;
                    ViewRootImpl.access$300(ViewRootImpl.this, var11_12);
                    if (!var11_12) ** GOTO lbl91
                    var19_13 = var1_1.arg2 != 0;
                    ViewRootImpl.access$400(ViewRootImpl.this, var19_13);
                    if (ViewRootImpl.this.mAttachInfo.mHardwareRenderer == null || !ViewRootImpl.access$500(ViewRootImpl.this).isValid()) ** GOTO lbl91
                    ViewRootImpl.this.mFullRedrawNeeded = true;
                    try {
                        var26_14 = ViewRootImpl.this.mWindowAttributes;
                        var27_15 = var26_14 != null ? var26_14.surfaceInsets : null;
                        ViewRootImpl.this.mAttachInfo.mHardwareRenderer.initializeIfNeeded(ViewRootImpl.this.mWidth, ViewRootImpl.this.mHeight, ViewRootImpl.access$500(ViewRootImpl.this), var27_15);
                        ** GOTO lbl91
                    }
                    catch (Surface.OutOfResourcesException var21_23) {
                        Log.e("ViewRootImpl", "OutOfResourcesException locking surface", var21_23);
                        try {
                            if (ViewRootImpl.this.mWindowSession.outOfMemory(ViewRootImpl.this.mWindow)) ** GOTO lbl87
                            Slog.w("ViewRootImpl", "No processes killed for memory; killing self");
                            Process.killProcess(Process.myPid());
                        }
                        catch (RemoteException var23_33) {
                            ** continue;
                        }
lbl87:
                        // 3 sources

                        while (true) {
                            this.sendMessageDelayed(this.obtainMessage(var1_1.what, var1_1.arg1, var1_1.arg2), 500L);
                            return;
                        }
lbl91:
                        // 3 sources

                        ViewRootImpl.this.mLastWasImTarget = WindowManager.LayoutParams.mayUseInputMethod(ViewRootImpl.this.mWindowAttributes.flags);
                        var12_16 = InputMethodManager.peekInstance();
                        if (ViewRootImpl.this.mView != null) {
                            if (var11_12 && var12_16 != null && ViewRootImpl.this.mLastWasImTarget && !ViewRootImpl.access$600(ViewRootImpl.this)) {
                                var12_16.startGettingWindowFocus(ViewRootImpl.this.mView);
                            }
                            ViewRootImpl.this.mAttachInfo.mKeyDispatchState.reset();
                            ViewRootImpl.this.mView.dispatchWindowFocusChanged(var11_12);
                            ViewRootImpl.this.mAttachInfo.mTreeObserver.dispatchOnWindowFocusChange(var11_12);
                        }
                        if (var11_12) {
                            if (var12_16 != null && ViewRootImpl.this.mLastWasImTarget && !ViewRootImpl.access$600(ViewRootImpl.this)) {
                                var15_17 = ViewRootImpl.this.mView;
                                var16_18 = ViewRootImpl.this.mView.findFocus();
                                var17_19 = ViewRootImpl.this.mWindowAttributes.softInputMode;
                                var18_20 = ViewRootImpl.this.mHasHadWindowFocus == false;
                                var12_16.onWindowFocus(var15_17, var16_18, var17_19, var18_20, ViewRootImpl.this.mWindowAttributes.flags);
                            }
                            var13_21 = ViewRootImpl.this.mWindowAttributes;
                            var13_21.softInputMode = -257 & var13_21.softInputMode;
                            var14_22 = (WindowManager.LayoutParams)ViewRootImpl.this.mView.getLayoutParams();
                            var14_22.softInputMode = -257 & var14_22.softInputMode;
                            ViewRootImpl.this.mHasHadWindowFocus = true;
                        }
                        if (ViewRootImpl.this.mView != null && ViewRootImpl.this.mAccessibilityManager.isEnabled() && var11_12) {
                            ViewRootImpl.this.mView.sendAccessibilityEvent(32);
                            return;
                        }
                    }
                }
lbl115:
                // 10 sources

                default: lbl-1000:
                // 2 sources

                {
                    return;
                }
                case 3: {
                    ViewRootImpl.this.doDie();
                    return;
                }
                case 7: {
                    var8_24 = (SomeArgs)var1_1.obj;
                    var9_25 = (InputEvent)var8_24.arg1;
                    var10_26 = (InputEventReceiver)var8_24.arg2;
                    ViewRootImpl.this.enqueueInputEvent(var9_25, var10_26, 0, true);
                    var8_24.recycle();
                    return;
                }
                case 25: {
                    var7_27 = (InputEvent)var1_1.obj;
                    ViewRootImpl.this.enqueueInputEvent(var7_27, null, 32, true);
                    return;
                }
                case 11: {
                    var6_28 = (KeyEvent)var1_1.obj;
                    if ((8 & var6_28.getFlags()) != 0) {
                        var6_28 = KeyEvent.changeFlags(var6_28, -9 & var6_28.getFlags());
                    }
                    ViewRootImpl.this.enqueueInputEvent(var6_28, null, 1, true);
                    return;
                }
                case 12: {
                    var5_29 = InputMethodManager.peekInstance();
                    if (var5_29 == null) ** GOTO lbl115
                    var5_29.reportFinishInputConnection((InputConnection)var1_1.obj);
                    return;
                }
                case 13: {
                    var4_30 = InputMethodManager.peekInstance();
                    if (var4_30 == null) ** GOTO lbl115
                    var4_30.checkFocus();
                    return;
                }
                case 14: {
                    if (ViewRootImpl.this.mView == null) ** GOTO lbl115
                    ViewRootImpl.this.mView.onCloseSystemDialogs((String)var1_1.obj);
                    return;
                }
                case 15: 
                case 16: {
                    var3_31 = (DragEvent)var1_1.obj;
                    var3_31.mLocalState = ViewRootImpl.this.mLocalDragState;
                    ViewRootImpl.access$700(ViewRootImpl.this, var3_31);
                    return;
                }
                case 17: {
                    ViewRootImpl.this.handleDispatchSystemUiVisibilityChanged((SystemUiVisibilityInfo)var1_1.obj);
                    return;
                }
                case 18: {
                    var2_32 = (Configuration)var1_1.obj;
                    if (var2_32.isOtherSeqNewer(ViewRootImpl.this.mLastConfiguration)) {
                        var2_32 = ViewRootImpl.this.mLastConfiguration;
                    }
                    ViewRootImpl.this.updateConfiguration(var2_32, false);
                    return;
                }
                case 21: {
                    ViewRootImpl.this.setAccessibilityFocus(null, null);
                    return;
                }
                case 22: {
                    ViewRootImpl.this.handleDispatchDoneAnimating();
                    return;
                }
                case 23: 
            }
            ** while (ViewRootImpl.this.mView == null)
lbl174:
            // 1 sources

            ViewRootImpl.this.invalidateWorld(ViewRootImpl.this.mView);
        }
    }

    static class W
    extends IWindow.Stub {
        private final WeakReference<ViewRootImpl> mViewAncestor;
        private final IWindowSession mWindowSession;

        W(ViewRootImpl viewRootImpl) {
            this.mViewAncestor = new WeakReference<ViewRootImpl>(viewRootImpl);
            this.mWindowSession = viewRootImpl.mWindowSession;
        }

        private static int checkCallingPermission(String string2) {
            try {
                int n = ActivityManagerNative.getDefault().checkPermission(string2, Binder.getCallingPid(), Binder.getCallingUid());
                return n;
            }
            catch (RemoteException remoteException) {
                return -1;
            }
        }

        @Override
        public void closeSystemDialogs(String string2) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewAncestor.get();
            if (viewRootImpl != null) {
                viewRootImpl.dispatchCloseSystemDialogs(string2);
            }
        }

        @Override
        public void dispatchAppVisibility(boolean bl) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewAncestor.get();
            if (viewRootImpl != null) {
                viewRootImpl.dispatchAppVisibility(bl);
            }
        }

        @Override
        public void dispatchDragEvent(DragEvent dragEvent) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewAncestor.get();
            if (viewRootImpl != null) {
                viewRootImpl.dispatchDragEvent(dragEvent);
            }
        }

        @Override
        public void dispatchGetNewSurface() {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewAncestor.get();
            if (viewRootImpl != null) {
                viewRootImpl.dispatchGetNewSurface();
            }
        }

        @Override
        public void dispatchSystemUiVisibilityChanged(int n, int n2, int n3, int n4) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewAncestor.get();
            if (viewRootImpl != null) {
                viewRootImpl.dispatchSystemUiVisibilityChanged(n, n2, n3, n4);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void dispatchWallpaperCommand(String string2, int n, int n2, int n3, Bundle bundle, boolean bl) {
            if (!bl) return;
            try {
                this.mWindowSession.wallpaperCommandComplete(this.asBinder(), null);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void dispatchWallpaperOffsets(float f, float f2, float f3, float f4, boolean bl) {
            if (!bl) return;
            try {
                this.mWindowSession.wallpaperOffsetsComplete(this.asBinder());
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public void doneAnimating() {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewAncestor.get();
            if (viewRootImpl != null) {
                viewRootImpl.dispatchDoneAnimating();
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void executeCommand(String var1_1, String var2_2, ParcelFileDescriptor var3_3) {
            var4_4 = (ViewRootImpl)this.mViewAncestor.get();
            if (var4_4 == null || (var5_5 = var4_4.mView) == null) ** GOTO lbl13
            if (W.checkCallingPermission("android.permission.DUMP") != 0) {
                throw new SecurityException("Insufficient permissions to invoke executeCommand() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            }
            var6_6 = null;
            var7_7 = new ParcelFileDescriptor.AutoCloseOutputStream(var3_3);
            ViewDebug.dispatchCommand(var5_5, var1_1, var2_2, var7_7);
            if (var7_7 == null) ** GOTO lbl13
            try {
                var7_7.close();
lbl13:
                // 4 sources

                return;
            }
            catch (IOException var12_8) {
                var12_8.printStackTrace();
                return;
            }
            catch (IOException var8_9) lbl-1000:
            // 2 sources

            {
                while (true) {
                    try {
                        var8_10.printStackTrace();
                        if (var6_6 == null) ** continue;
                    }
                    catch (Throwable var9_13) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var6_6 != null) {
                                var6_6.close();
                            }
lbl28:
                            // 4 sources

                            throw var9_14;
                            catch (IOException var10_16) {
                                var10_16.printStackTrace();
                                ** continue;
                            }
                            break;
                        }
                    }
                    try {
                        var6_6.close();
                        return;
                    }
                    catch (IOException var11_12) {
                        var11_12.printStackTrace();
                        return;
                    }
                    break;
                }
            }
            catch (Throwable var9_15) {
                var6_6 = var7_7;
                ** continue;
            }
            catch (IOException var8_11) {
                var6_6 = var7_7;
                ** continue;
            }
        }

        @Override
        public void moved(int n, int n2) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewAncestor.get();
            if (viewRootImpl != null) {
                viewRootImpl.dispatchMoved(n, n2);
            }
        }

        @Override
        public void resized(Rect rect, Rect rect2, Rect rect3, Rect rect4, Rect rect5, boolean bl, Configuration configuration) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewAncestor.get();
            if (viewRootImpl != null) {
                viewRootImpl.dispatchResized(rect, rect2, rect3, rect4, rect5, bl, configuration);
            }
        }

        @Override
        public void windowFocusChanged(boolean bl, boolean bl2) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mViewAncestor.get();
            if (viewRootImpl != null) {
                viewRootImpl.windowFocusChanged(bl, bl2);
            }
        }
    }

    final class WindowInputEventReceiver
    extends InputEventReceiver {
        public WindowInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        @Override
        public void dispose() {
            ViewRootImpl.this.unscheduleConsumeBatchedInput();
            super.dispose();
        }

        @Override
        public void onBatchedInputEventPending() {
            if (ViewRootImpl.this.mUnbufferedInputDispatch) {
                super.onBatchedInputEventPending();
                return;
            }
            ViewRootImpl.this.scheduleConsumeBatchedInput();
        }

        @Override
        public void onInputEvent(InputEvent inputEvent) {
            ViewRootImpl.this.enqueueInputEvent(inputEvent, this, 0, true);
        }
    }
}

