/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pools;
import android.util.SparseArray;
import android.view.ActionMode;
import android.view.DragEvent;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroupOverlay;
import android.view.ViewManager;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.view.animation.Transformation;
import com.android.internal.R;
import com.android.internal.util.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class ViewGroup
extends View
implements ViewParent,
ViewManager {
    private static final int ARRAY_CAPACITY_INCREMENT = 12;
    private static final int ARRAY_INITIAL_CAPACITY = 12;
    private static final int CHILD_LEFT_INDEX = 0;
    private static final int CHILD_TOP_INDEX = 1;
    protected static final int CLIP_TO_PADDING_MASK = 34;
    private static final boolean DBG = false;
    public static boolean DEBUG_DRAW = false;
    private static final int[] DESCENDANT_FOCUSABILITY_FLAGS;
    private static final int FLAG_ADD_STATES_FROM_CHILDREN = 8192;
    static final int FLAG_ALWAYS_DRAWN_WITH_CACHE = 16384;
    private static final int FLAG_ANIMATION_CACHE = 64;
    static final int FLAG_ANIMATION_DONE = 16;
    static final int FLAG_CHILDREN_DRAWN_WITH_CACHE = 32768;
    static final int FLAG_CLEAR_TRANSFORMATION = 256;
    static final int FLAG_CLIP_CHILDREN = 1;
    private static final int FLAG_CLIP_TO_PADDING = 2;
    protected static final int FLAG_DISALLOW_INTERCEPT = 524288;
    static final int FLAG_INVALIDATE_REQUIRED = 4;
    static final int FLAG_IS_TRANSITION_GROUP = 0x1000000;
    static final int FLAG_IS_TRANSITION_GROUP_SET = 0x2000000;
    private static final int FLAG_LAYOUT_MODE_WAS_EXPLICITLY_SET = 0x800000;
    private static final int FLAG_MASK_FOCUSABILITY = 393216;
    private static final int FLAG_NOTIFY_ANIMATION_LISTENER = 512;
    private static final int FLAG_NOTIFY_CHILDREN_ON_DRAWABLE_STATE_CHANGE = 65536;
    static final int FLAG_OPTIMIZE_INVALIDATE = 128;
    private static final int FLAG_PADDING_NOT_NULL = 32;
    private static final int FLAG_PREVENT_DISPATCH_ATTACHED_TO_WINDOW = 0x400000;
    private static final int FLAG_RUN_ANIMATION = 8;
    private static final int FLAG_SPLIT_MOTION_EVENTS = 0x200000;
    protected static final int FLAG_SUPPORT_STATIC_TRANSFORMATIONS = 2048;
    static final int FLAG_TOUCHSCREEN_BLOCKS_FOCUS = 0x4000000;
    protected static final int FLAG_USE_CHILD_DRAWING_ORDER = 1024;
    public static final int FOCUS_AFTER_DESCENDANTS = 262144;
    public static final int FOCUS_BEFORE_DESCENDANTS = 131072;
    public static final int FOCUS_BLOCK_DESCENDANTS = 393216;
    public static final int LAYOUT_MODE_CLIP_BOUNDS = 0;
    public static int LAYOUT_MODE_DEFAULT = 0;
    public static final int LAYOUT_MODE_OPTICAL_BOUNDS = 1;
    private static final int LAYOUT_MODE_UNDEFINED = -1;
    public static final int PERSISTENT_ALL_CACHES = 3;
    public static final int PERSISTENT_ANIMATION_CACHE = 1;
    public static final int PERSISTENT_NO_CACHE = 0;
    public static final int PERSISTENT_SCROLLING_CACHE = 2;
    private static final String TAG = "ViewGroup";
    private static float[] sDebugLines;
    private static Paint sDebugPaint;
    private Animation.AnimationListener mAnimationListener;
    Paint mCachePaint;
    private boolean mChildAcceptsDrag;
    @ViewDebug.ExportedProperty(category="layout")
    private int mChildCountWithTransientState = 0;
    private Transformation mChildTransformation;
    private View[] mChildren;
    private int mChildrenCount;
    private DragEvent mCurrentDrag;
    private View mCurrentDragView;
    protected ArrayList<View> mDisappearingChildren;
    private HashSet<View> mDragNotifiedChildren;
    private HoverTarget mFirstHoverTarget;
    private TouchTarget mFirstTouchTarget;
    private View mFocused;
    @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(equals=1, mask=1, name="CLIP_CHILDREN"), @ViewDebug.FlagToString(equals=2, mask=2, name="CLIP_TO_PADDING"), @ViewDebug.FlagToString(equals=32, mask=32, name="PADDING_NOT_NULL")}, formatToHexString=true)
    protected int mGroupFlags;
    private boolean mHoveredSelf;
    RectF mInvalidateRegion;
    Transformation mInvalidationTransformation;
    @ViewDebug.ExportedProperty(category="events")
    private int mLastTouchDownIndex = -1;
    @ViewDebug.ExportedProperty(category="events")
    private long mLastTouchDownTime;
    @ViewDebug.ExportedProperty(category="events")
    private float mLastTouchDownX;
    @ViewDebug.ExportedProperty(category="events")
    private float mLastTouchDownY;
    private LayoutAnimationController mLayoutAnimationController;
    private boolean mLayoutCalledWhileSuppressed = false;
    private int mLayoutMode = -1;
    private LayoutTransition.TransitionListener mLayoutTransitionListener = new LayoutTransition.TransitionListener(){

        @Override
        public void endTransition(LayoutTransition layoutTransition, ViewGroup viewGroup, View view, int n) {
            if (ViewGroup.this.mLayoutCalledWhileSuppressed && !layoutTransition.isChangingLayout()) {
                ViewGroup.this.requestLayout();
                ViewGroup.access$302(ViewGroup.this, false);
            }
            if (n == 3 && ViewGroup.this.mTransitioningViews != null) {
                ViewGroup.this.endViewTransition(view);
            }
        }

        @Override
        public void startTransition(LayoutTransition layoutTransition, ViewGroup viewGroup, View view, int n) {
            if (n == 3) {
                ViewGroup.this.startViewTransition(view);
            }
        }
    };
    private PointF mLocalPoint;
    private int mNestedScrollAxes;
    protected OnHierarchyChangeListener mOnHierarchyChangeListener;
    protected int mPersistentDrawingCache;
    private ArrayList<View> mPreSortedChildren;
    boolean mSuppressLayout = false;
    private LayoutTransition mTransition;
    private ArrayList<View> mTransitioningViews;
    private ArrayList<View> mVisibilityChangingChildren;

    static {
        DEBUG_DRAW = false;
        DESCENDANT_FOCUSABILITY_FLAGS = new int[]{131072, 262144, 393216};
        LAYOUT_MODE_DEFAULT = 0;
    }

    public ViewGroup(Context context) {
        this(context, null);
    }

    public ViewGroup(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ViewGroup(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ViewGroup(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.initViewGroup();
        this.initFromAttributes(context, attributeSet, n, n2);
    }

    static /* synthetic */ boolean access$302(ViewGroup viewGroup, boolean bl) {
        viewGroup.mLayoutCalledWhileSuppressed = bl;
        return bl;
    }

    private void addDisappearingView(View view) {
        ArrayList<View> arrayList = this.mDisappearingChildren;
        if (arrayList == null) {
            this.mDisappearingChildren = arrayList = new ArrayList();
        }
        arrayList.add(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addInArray(View view, int n) {
        View[] viewArray = this.mChildren;
        int n2 = this.mChildrenCount;
        int n3 = viewArray.length;
        if (n == n2) {
            if (n3 == n2) {
                this.mChildren = new View[n3 + 12];
                System.arraycopy(viewArray, 0, this.mChildren, 0, n3);
                viewArray = this.mChildren;
            }
            int n4 = this.mChildrenCount;
            this.mChildrenCount = n4 + 1;
            viewArray[n4] = view;
            return;
        } else {
            if (n >= n2) {
                throw new IndexOutOfBoundsException("index=" + n + " count=" + n2);
            }
            if (n3 == n2) {
                this.mChildren = new View[n3 + 12];
                System.arraycopy(viewArray, 0, this.mChildren, 0, n);
                System.arraycopy(viewArray, n, this.mChildren, n + 1, n2 - n);
                viewArray = this.mChildren;
            } else {
                System.arraycopy(viewArray, n, viewArray, n + 1, n2 - n);
            }
            viewArray[n] = view;
            this.mChildrenCount = 1 + this.mChildrenCount;
            if (this.mLastTouchDownIndex < n) return;
            this.mLastTouchDownIndex = 1 + this.mLastTouchDownIndex;
            return;
        }
    }

    private TouchTarget addTouchTarget(View view, int n) {
        TouchTarget touchTarget = TouchTarget.obtain(view, n);
        touchTarget.next = this.mFirstTouchTarget;
        this.mFirstTouchTarget = touchTarget;
        return touchTarget;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addViewInner(View view, int n, LayoutParams layoutParams, boolean bl) {
        View.AttachInfo attachInfo;
        if (this.mTransition != null) {
            this.mTransition.cancel(3);
        }
        if (view.getParent() != null) {
            throw new IllegalStateException("The specified child already has a parent. You must call removeView() on the child's parent first.");
        }
        if (this.mTransition != null) {
            this.mTransition.addChild(this, view);
        }
        if (!this.checkLayoutParams(layoutParams)) {
            layoutParams = this.generateLayoutParams(layoutParams);
        }
        if (bl) {
            view.mLayoutParams = layoutParams;
        } else {
            view.setLayoutParams(layoutParams);
        }
        if (n < 0) {
            n = this.mChildrenCount;
        }
        this.addInArray(view, n);
        if (bl) {
            view.assignParent(this);
        } else {
            view.mParent = this;
        }
        if (view.hasFocus()) {
            this.requestChildFocus(view, view.findFocus());
        }
        if ((attachInfo = this.mAttachInfo) != null && (0x400000 & this.mGroupFlags) == 0) {
            boolean bl2 = attachInfo.mKeepScreenOn;
            attachInfo.mKeepScreenOn = false;
            view.dispatchAttachedToWindow(this.mAttachInfo, 0xC & this.mViewFlags);
            if (attachInfo.mKeepScreenOn) {
                this.needGlobalAttributesUpdate(true);
            }
            attachInfo.mKeepScreenOn = bl2;
        }
        if (view.isLayoutDirectionInherited()) {
            view.resetRtlProperties();
        }
        this.onViewAdded(view);
        if ((0x400000 & view.mViewFlags) == 0x400000) {
            this.mGroupFlags = 0x10000 | this.mGroupFlags;
        }
        if (view.hasTransientState()) {
            this.childHasTransientStateChanged(view, true);
        }
        if (view.getVisibility() != 8) {
            this.notifySubtreeAccessibilityStateChangedIfNeeded();
        }
    }

    private void bindLayoutAnimation(View view) {
        view.setAnimation(this.mLayoutAnimationController.getAnimationForView(view));
    }

    private static boolean canViewReceivePointerEvents(View view) {
        return (0xC & view.mViewFlags) == 0 || view.getAnimation() != null;
    }

    private void cancelAndClearTouchTargets(MotionEvent motionEvent) {
        if (this.mFirstTouchTarget != null) {
            boolean bl = false;
            if (motionEvent == null) {
                long l = SystemClock.uptimeMillis();
                motionEvent = MotionEvent.obtain(l, l, 3, 0.0f, 0.0f, 0);
                motionEvent.setSource(4098);
                bl = true;
            }
            TouchTarget touchTarget = this.mFirstTouchTarget;
            while (touchTarget != null) {
                ViewGroup.resetCancelNextUpFlag(touchTarget.child);
                this.dispatchTransformedTouchEvent(motionEvent, true, touchTarget.child, touchTarget.pointerIdBits);
                touchTarget = touchTarget.next;
            }
            this.clearTouchTargets();
            if (bl) {
                motionEvent.recycle();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void cancelHoverTarget(View view) {
        HoverTarget hoverTarget = null;
        HoverTarget hoverTarget2 = this.mFirstHoverTarget;
        while (hoverTarget2 != null) {
            HoverTarget hoverTarget3 = hoverTarget2.next;
            if (hoverTarget2.child == view) {
                if (hoverTarget == null) {
                    this.mFirstHoverTarget = hoverTarget3;
                } else {
                    hoverTarget.next = hoverTarget3;
                }
                hoverTarget2.recycle();
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain(l, l, 10, 0.0f, 0.0f, 0);
                motionEvent.setSource(4098);
                view.dispatchHoverEvent(motionEvent);
                motionEvent.recycle();
                return;
            }
            hoverTarget = hoverTarget2;
            hoverTarget2 = hoverTarget3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void cancelTouchTarget(View view) {
        TouchTarget touchTarget = null;
        TouchTarget touchTarget2 = this.mFirstTouchTarget;
        while (touchTarget2 != null) {
            TouchTarget touchTarget3 = touchTarget2.next;
            if (touchTarget2.child == view) {
                if (touchTarget == null) {
                    this.mFirstTouchTarget = touchTarget3;
                } else {
                    touchTarget.next = touchTarget3;
                }
                touchTarget2.recycle();
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain(l, l, 3, 0.0f, 0.0f, 0);
                motionEvent.setSource(4098);
                view.dispatchTouchEvent(motionEvent);
                motionEvent.recycle();
                return;
            }
            touchTarget = touchTarget2;
            touchTarget2 = touchTarget3;
        }
    }

    private void clearCachedLayoutMode() {
        if (!this.hasBooleanFlag(0x800000)) {
            this.mLayoutMode = -1;
        }
    }

    private void clearTouchTargets() {
        TouchTarget touchTarget = this.mFirstTouchTarget;
        if (touchTarget != null) {
            TouchTarget touchTarget2;
            do {
                touchTarget2 = touchTarget.next;
                touchTarget.recycle();
            } while ((touchTarget = touchTarget2) != null);
            this.mFirstTouchTarget = null;
        }
    }

    private boolean debugDraw() {
        return DEBUG_DRAW || this.mAttachInfo != null && this.mAttachInfo.mDebugLayout;
    }

    private int dipsToPixels(int n) {
        return (int)(0.5f + this.getContext().getResources().getDisplayMetrics().density * (float)n);
    }

    private boolean dispatchTransformedGenericPointerEvent(MotionEvent motionEvent, View view) {
        float f = this.mScrollX - view.mLeft;
        float f2 = this.mScrollY - view.mTop;
        if (!view.hasIdentityMatrix()) {
            MotionEvent motionEvent2 = MotionEvent.obtain(motionEvent);
            motionEvent2.offsetLocation(f, f2);
            motionEvent2.transform(view.getInverseMatrix());
            boolean bl = view.dispatchGenericMotionEvent(motionEvent2);
            motionEvent2.recycle();
            return bl;
        }
        motionEvent.offsetLocation(f, f2);
        boolean bl = view.dispatchGenericMotionEvent(motionEvent);
        motionEvent.offsetLocation(-f, -f2);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean dispatchTransformedTouchEvent(MotionEvent motionEvent, boolean bl, View view, int n) {
        boolean bl2;
        MotionEvent motionEvent2;
        int n2 = motionEvent.getAction();
        if (bl || n2 == 3) {
            motionEvent.setAction(3);
            boolean bl3 = view == null ? super.dispatchTouchEvent(motionEvent) : view.dispatchTouchEvent(motionEvent);
            motionEvent.setAction(n2);
            return bl3;
        }
        int n3 = motionEvent.getPointerIdBits();
        int n4 = n3 & n;
        if (n4 == 0) {
            return false;
        }
        if (n4 == n3) {
            if (view == null || view.hasIdentityMatrix()) {
                if (view == null) {
                    return super.dispatchTouchEvent(motionEvent);
                }
                float f = this.mScrollX - view.mLeft;
                float f2 = this.mScrollY - view.mTop;
                motionEvent.offsetLocation(f, f2);
                boolean bl4 = view.dispatchTouchEvent(motionEvent);
                motionEvent.offsetLocation(-f, -f2);
                return bl4;
            }
            motionEvent2 = MotionEvent.obtain(motionEvent);
        } else {
            motionEvent2 = motionEvent.split(n4);
        }
        if (view == null) {
            bl2 = super.dispatchTouchEvent(motionEvent2);
        } else {
            motionEvent2.offsetLocation(this.mScrollX - view.mLeft, this.mScrollY - view.mTop);
            if (!view.hasIdentityMatrix()) {
                motionEvent2.transform(view.getInverseMatrix());
            }
            bl2 = view.dispatchTouchEvent(motionEvent2);
        }
        motionEvent2.recycle();
        return bl2;
    }

    private static void drawCorner(Canvas canvas, Paint paint, int n, int n2, int n3, int n4, int n5) {
        ViewGroup.fillRect(canvas, paint, n, n2, n + n3, n2 + n5 * ViewGroup.sign(n4));
        ViewGroup.fillRect(canvas, paint, n, n2, n + n5 * ViewGroup.sign(n3), n2 + n4);
    }

    private static void drawRect(Canvas canvas, Paint paint, int n, int n2, int n3, int n4) {
        if (sDebugLines == null) {
            sDebugLines = new float[16];
        }
        ViewGroup.sDebugLines[0] = n;
        ViewGroup.sDebugLines[1] = n2;
        ViewGroup.sDebugLines[2] = n3;
        ViewGroup.sDebugLines[3] = n2;
        ViewGroup.sDebugLines[4] = n3;
        ViewGroup.sDebugLines[5] = n2;
        ViewGroup.sDebugLines[6] = n3;
        ViewGroup.sDebugLines[7] = n4;
        ViewGroup.sDebugLines[8] = n3;
        ViewGroup.sDebugLines[9] = n4;
        ViewGroup.sDebugLines[10] = n;
        ViewGroup.sDebugLines[11] = n4;
        ViewGroup.sDebugLines[12] = n;
        ViewGroup.sDebugLines[13] = n4;
        ViewGroup.sDebugLines[14] = n;
        ViewGroup.sDebugLines[15] = n2;
        canvas.drawLines(sDebugLines, paint);
    }

    private static void drawRectCorners(Canvas canvas, int n, int n2, int n3, int n4, Paint paint, int n5, int n6) {
        ViewGroup.drawCorner(canvas, paint, n, n2, n5, n5, n6);
        ViewGroup.drawCorner(canvas, paint, n, n4, n5, -n5, n6);
        ViewGroup.drawCorner(canvas, paint, n3, n2, -n5, n5, n6);
        ViewGroup.drawCorner(canvas, paint, n3, n4, -n5, -n5, n6);
    }

    private void exitHoverTargets() {
        if (this.mHoveredSelf || this.mFirstHoverTarget != null) {
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain(l, l, 10, 0.0f, 0.0f, 0);
            motionEvent.setSource(4098);
            this.dispatchHoverEvent(motionEvent);
            motionEvent.recycle();
        }
    }

    private static void fillDifference(Canvas canvas, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Paint paint) {
        int n9 = n - n5;
        int n10 = n2 - n6;
        int n11 = n3 + n7;
        int n12 = n4 + n8;
        ViewGroup.fillRect(canvas, paint, n9, n10, n11, n2);
        ViewGroup.fillRect(canvas, paint, n9, n2, n, n4);
        ViewGroup.fillRect(canvas, paint, n3, n2, n11, n4);
        ViewGroup.fillRect(canvas, paint, n9, n4, n11, n12);
    }

    private static void fillRect(Canvas canvas, Paint paint, int n, int n2, int n3, int n4) {
        if (n != n3 && n2 != n4) {
            if (n > n3) {
                int n5 = n;
                n = n3;
                n3 = n5;
            }
            if (n2 > n4) {
                int n6 = n2;
                n2 = n4;
                n4 = n6;
            }
            canvas.drawRect(n, n2, n3, n4, paint);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getChildMeasureSpec(int n, int n2, int n3) {
        int n4 = View.MeasureSpec.getMode(n);
        int n5 = Math.max(0, View.MeasureSpec.getSize(n) - n2);
        int n6 = 0;
        int n7 = 0;
        switch (n4) {
            case 0x40000000: {
                if (n3 >= 0) {
                    n7 = n3;
                    n6 = 0x40000000;
                    return View.MeasureSpec.makeMeasureSpec(n7, n6);
                }
                if (n3 == -1) {
                    n7 = n5;
                    n6 = 0x40000000;
                    return View.MeasureSpec.makeMeasureSpec(n7, n6);
                }
                n6 = 0;
                n7 = 0;
                if (n3 != -2) return View.MeasureSpec.makeMeasureSpec(n7, n6);
                n7 = n5;
                n6 = Integer.MIN_VALUE;
                return View.MeasureSpec.makeMeasureSpec(n7, n6);
            }
            case -2147483648: {
                if (n3 >= 0) {
                    n7 = n3;
                    n6 = 0x40000000;
                    return View.MeasureSpec.makeMeasureSpec(n7, n6);
                }
                if (n3 == -1) {
                    n7 = n5;
                    n6 = Integer.MIN_VALUE;
                    return View.MeasureSpec.makeMeasureSpec(n7, n6);
                }
                n6 = 0;
                n7 = 0;
                if (n3 != -2) return View.MeasureSpec.makeMeasureSpec(n7, n6);
                n7 = n5;
                n6 = Integer.MIN_VALUE;
                return View.MeasureSpec.makeMeasureSpec(n7, n6);
            }
            case 0: {
                if (n3 >= 0) {
                    n7 = n3;
                    n6 = 0x40000000;
                    return View.MeasureSpec.makeMeasureSpec(n7, n6);
                }
                if (n3 == -1) {
                    n6 = 0;
                    n7 = 0;
                    return View.MeasureSpec.makeMeasureSpec(n7, n6);
                }
                n6 = 0;
                n7 = 0;
                if (n3 != -2) return View.MeasureSpec.makeMeasureSpec(n7, n6);
                n6 = 0;
                n7 = 0;
                return View.MeasureSpec.makeMeasureSpec(n7, n6);
            }
        }
        return View.MeasureSpec.makeMeasureSpec(n7, n6);
    }

    private static Paint getDebugPaint() {
        if (sDebugPaint == null) {
            sDebugPaint = new Paint();
            sDebugPaint.setAntiAlias(false);
        }
        return sDebugPaint;
    }

    private PointF getLocalPoint() {
        if (this.mLocalPoint == null) {
            this.mLocalPoint = new PointF();
        }
        return this.mLocalPoint;
    }

    private TouchTarget getTouchTarget(View view) {
        TouchTarget touchTarget = this.mFirstTouchTarget;
        while (touchTarget != null) {
            if (touchTarget.child == view) {
                return touchTarget;
            }
            touchTarget = touchTarget.next;
        }
        return null;
    }

    private boolean hasBooleanFlag(int n) {
        return (n & this.mGroupFlags) == n;
    }

    private boolean hasChildWithZ() {
        for (int i = 0; i < this.mChildrenCount; ++i) {
            if (this.mChildren[i].getZ() == 0.0f) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initFromAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ViewGroup, n, n2);
        int n3 = typedArray.getIndexCount();
        int n4 = 0;
        while (true) {
            if (n4 >= n3) {
                typedArray.recycle();
                return;
            }
            int n5 = typedArray.getIndex(n4);
            switch (n5) {
                case 0: {
                    this.setClipChildren(typedArray.getBoolean(n5, true));
                    break;
                }
                case 1: {
                    this.setClipToPadding(typedArray.getBoolean(n5, true));
                    break;
                }
                case 3: {
                    this.setAnimationCacheEnabled(typedArray.getBoolean(n5, true));
                    break;
                }
                case 4: {
                    this.setPersistentDrawingCache(typedArray.getInt(n5, 2));
                    break;
                }
                case 6: {
                    this.setAddStatesFromChildren(typedArray.getBoolean(n5, false));
                    break;
                }
                case 5: {
                    this.setAlwaysDrawnWithCacheEnabled(typedArray.getBoolean(n5, true));
                    break;
                }
                case 2: {
                    int n6 = typedArray.getResourceId(n5, -1);
                    if (n6 <= 0) break;
                    this.setLayoutAnimation(AnimationUtils.loadLayoutAnimation(this.mContext, n6));
                    break;
                }
                case 7: {
                    this.setDescendantFocusability(DESCENDANT_FOCUSABILITY_FLAGS[typedArray.getInt(n5, 0)]);
                    break;
                }
                case 8: {
                    this.setMotionEventSplittingEnabled(typedArray.getBoolean(n5, false));
                    break;
                }
                case 9: {
                    if (!typedArray.getBoolean(n5, false)) break;
                    this.setLayoutTransition(new LayoutTransition());
                    break;
                }
                case 10: {
                    this.setLayoutMode(typedArray.getInt(n5, -1));
                    break;
                }
                case 11: {
                    this.setTransitionGroup(typedArray.getBoolean(n5, false));
                    break;
                }
                case 12: {
                    this.setTouchscreenBlocksFocus(typedArray.getBoolean(n5, false));
                    break;
                }
            }
            ++n4;
        }
    }

    private void initViewGroup() {
        if (!this.debugDraw()) {
            this.setFlags(128, 128);
        }
        this.mGroupFlags = 1 | this.mGroupFlags;
        this.mGroupFlags = 2 | this.mGroupFlags;
        this.mGroupFlags = 0x10 | this.mGroupFlags;
        this.mGroupFlags = 0x40 | this.mGroupFlags;
        this.mGroupFlags = 0x4000 | this.mGroupFlags;
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 11) {
            this.mGroupFlags = 0x200000 | this.mGroupFlags;
        }
        this.setDescendantFocusability(131072);
        this.mChildren = new View[12];
        this.mChildrenCount = 0;
        this.mPersistentDrawingCache = 2;
    }

    private void notifyAnimationListener() {
        this.mGroupFlags = 0xFFFFFDFF & this.mGroupFlags;
        this.mGroupFlags = 0x10 | this.mGroupFlags;
        if (this.mAnimationListener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ViewGroup.this.mAnimationListener.onAnimationEnd(ViewGroup.this.mLayoutAnimationController.getAnimation());
                }
            });
        }
        if ((0x40 & this.mGroupFlags) == 64) {
            this.mGroupFlags = 0xFFFF7FFF & this.mGroupFlags;
            if ((1 & this.mPersistentDrawingCache) == 0) {
                this.setChildrenDrawingCacheEnabled(false);
            }
        }
        this.invalidate(true);
    }

    private static MotionEvent obtainMotionEventNoHistoryOrSelf(MotionEvent motionEvent) {
        if (motionEvent.getHistorySize() == 0) {
            return motionEvent;
        }
        return MotionEvent.obtainNoHistory(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void recreateChildDisplayList(View view) {
        boolean bl = (Integer.MIN_VALUE & view.mPrivateFlags) == Integer.MIN_VALUE;
        view.mRecreateDisplayList = bl;
        view.mPrivateFlags = Integer.MAX_VALUE & view.mPrivateFlags;
        view.getDisplayList();
        view.mRecreateDisplayList = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeFromArray(int n) {
        int n2;
        View[] viewArray = this.mChildren;
        if (this.mTransitioningViews == null || !this.mTransitioningViews.contains(viewArray[n])) {
            viewArray[n].mParent = null;
        }
        if (n == (n2 = this.mChildrenCount) - 1) {
            int n3;
            this.mChildrenCount = n3 = -1 + this.mChildrenCount;
            viewArray[n3] = null;
        } else {
            int n4;
            if (n < 0 || n >= n2) throw new IndexOutOfBoundsException();
            System.arraycopy(viewArray, n + 1, viewArray, n, -1 + (n2 - n));
            this.mChildrenCount = n4 = -1 + this.mChildrenCount;
            viewArray[n4] = null;
        }
        if (this.mLastTouchDownIndex == n) {
            this.mLastTouchDownTime = 0L;
            this.mLastTouchDownIndex = -1;
            return;
        } else {
            if (this.mLastTouchDownIndex <= n) return;
            this.mLastTouchDownIndex = -1 + this.mLastTouchDownIndex;
            return;
        }
    }

    private void removeFromArray(int n, int n2) {
        int n3;
        View[] viewArray = this.mChildren;
        int n4 = this.mChildrenCount;
        int n5 = Math.max(0, n);
        if (n5 == (n3 = Math.min(n4, n5 + n2))) {
            return;
        }
        if (n3 == n4) {
            for (int i = n5; i < n3; ++i) {
                viewArray[i].mParent = null;
                viewArray[i] = null;
            }
        } else {
            for (int i = n5; i < n3; ++i) {
                viewArray[i].mParent = null;
            }
            System.arraycopy(viewArray, n3, viewArray, n5, n4 - n3);
            for (int i = n4 - (n3 - n5); i < n4; ++i) {
                viewArray[i] = null;
            }
        }
        this.mChildrenCount -= n3 - n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removePointersFromTouchTargets(int n) {
        TouchTarget touchTarget = null;
        TouchTarget touchTarget2 = this.mFirstTouchTarget;
        while (touchTarget2 != null) {
            TouchTarget touchTarget3 = touchTarget2.next;
            if ((n & touchTarget2.pointerIdBits) != 0) {
                touchTarget2.pointerIdBits &= ~n;
                if (touchTarget2.pointerIdBits == 0) {
                    if (touchTarget == null) {
                        this.mFirstTouchTarget = touchTarget3;
                    } else {
                        touchTarget.next = touchTarget3;
                    }
                    touchTarget2.recycle();
                    touchTarget2 = touchTarget3;
                    continue;
                }
            }
            touchTarget = touchTarget2;
            touchTarget2 = touchTarget3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeViewInternal(int n, View view) {
        if (this.mTransition != null) {
            this.mTransition.removeChild(this, view);
        }
        View view2 = this.mFocused;
        boolean bl = false;
        if (view == view2) {
            view.unFocus(null);
            bl = true;
        }
        if (view.isAccessibilityFocused()) {
            view.clearAccessibilityFocus();
        }
        this.cancelTouchTarget(view);
        this.cancelHoverTarget(view);
        if (view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
            this.addDisappearingView(view);
        } else if (view.mAttachInfo != null) {
            view.dispatchDetachedFromWindow();
        }
        if (view.hasTransientState()) {
            this.childHasTransientStateChanged(view, false);
        }
        this.needGlobalAttributesUpdate(false);
        this.removeFromArray(n);
        if (bl) {
            this.clearChildFocus(view);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(this);
            }
        }
        this.onViewRemoved(view);
        if (view.getVisibility() != 8) {
            this.notifySubtreeAccessibilityStateChangedIfNeeded();
        }
    }

    private void removeViewInternal(View view) {
        int n = this.indexOfChild(view);
        if (n >= 0) {
            this.removeViewInternal(n, view);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeViewsInternal(int n, int n2) {
        View view = this.mFocused;
        boolean bl = this.mAttachInfo != null;
        boolean bl2 = false;
        View[] viewArray = this.mChildren;
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            View view2 = viewArray[i];
            if (this.mTransition != null) {
                this.mTransition.removeChild(this, view2);
            }
            if (view2 == view) {
                view2.unFocus(null);
                bl2 = true;
            }
            if (view2.isAccessibilityFocused()) {
                view2.clearAccessibilityFocus();
            }
            this.cancelTouchTarget(view2);
            this.cancelHoverTarget(view2);
            if (view2.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view2)) {
                this.addDisappearingView(view2);
            } else if (bl) {
                view2.dispatchDetachedFromWindow();
            }
            if (view2.hasTransientState()) {
                this.childHasTransientStateChanged(view2, false);
            }
            this.needGlobalAttributesUpdate(false);
            this.onViewRemoved(view2);
        }
        this.removeFromArray(n, n2);
        if (bl2) {
            this.clearChildFocus(view);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(view);
            }
        }
    }

    private static boolean resetCancelNextUpFlag(View view) {
        if ((0x4000000 & view.mPrivateFlags) != 0) {
            view.mPrivateFlags = 0xFBFFFFFF & view.mPrivateFlags;
            return true;
        }
        return false;
    }

    private void resetTouchState() {
        this.clearTouchTargets();
        ViewGroup.resetCancelNextUpFlag(this);
        this.mGroupFlags = 0xFFF7FFFF & this.mGroupFlags;
        this.mNestedScrollAxes = 0;
    }

    private void setBooleanFlag(int n, boolean bl) {
        if (bl) {
            this.mGroupFlags = n | this.mGroupFlags;
            return;
        }
        this.mGroupFlags &= ~n;
    }

    private void setLayoutMode(int n, boolean bl) {
        this.mLayoutMode = n;
        this.setBooleanFlag(0x800000, bl);
    }

    private static int sign(int n) {
        if (n >= 0) {
            return 1;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addChildrenForAccessibility(ArrayList<View> arrayList) {
        int n;
        int n2;
        ChildListForAccessibility childListForAccessibility = ChildListForAccessibility.obtain(this, true);
        try {
            n2 = childListForAccessibility.getChildCount();
            n = 0;
        }
        catch (Throwable throwable) {
            childListForAccessibility.recycle();
            throw throwable;
        }
        while (true) {
            if (n < n2) {
                View view = childListForAccessibility.getChildAt(n);
                if ((0xC & view.mViewFlags) == 0) {
                    if (view.includeForAccessibility()) {
                        arrayList.add(view);
                    } else {
                        view.addChildrenForAccessibility(arrayList);
                    }
                }
            } else {
                childListForAccessibility.recycle();
                return;
            }
            ++n;
        }
    }

    @Override
    public void addFocusables(ArrayList<View> arrayList, int n, int n2) {
        int n3 = arrayList.size();
        int n4 = this.getDescendantFocusability();
        if (n4 != 393216) {
            if (this.shouldBlockFocusForTouchscreen()) {
                n2 |= 1;
            }
            int n5 = this.mChildrenCount;
            View[] viewArray = this.mChildren;
            for (int i = 0; i < n5; ++i) {
                View view = viewArray[i];
                if ((0xC & view.mViewFlags) != 0) continue;
                view.addFocusables(arrayList, n, n2);
            }
        }
        if (!(n4 == 262144 && n3 != arrayList.size() || !this.isFocusableInTouchMode() && this.shouldBlockFocusForTouchscreen())) {
            super.addFocusables(arrayList, n, n2);
        }
    }

    public boolean addStatesFromChildren() {
        return (0x2000 & this.mGroupFlags) != 0;
    }

    @Override
    public void addTouchables(ArrayList<View> arrayList) {
        super.addTouchables(arrayList);
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            View view = viewArray[i];
            if ((0xC & view.mViewFlags) != 0) continue;
            view.addTouchables(arrayList);
        }
    }

    public void addView(View view) {
        this.addView(view, -1);
    }

    public void addView(View view, int n) {
        LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null && (layoutParams = this.generateDefaultLayoutParams()) == null) {
            throw new IllegalArgumentException("generateDefaultLayoutParams() cannot return null");
        }
        this.addView(view, n, layoutParams);
    }

    public void addView(View view, int n, int n2) {
        LayoutParams layoutParams = this.generateDefaultLayoutParams();
        layoutParams.width = n;
        layoutParams.height = n2;
        this.addView(view, -1, layoutParams);
    }

    public void addView(View view, int n, LayoutParams layoutParams) {
        this.requestLayout();
        this.invalidate(true);
        this.addViewInner(view, n, layoutParams, false);
    }

    @Override
    public void addView(View view, LayoutParams layoutParams) {
        this.addView(view, -1, layoutParams);
    }

    protected boolean addViewInLayout(View view, int n, LayoutParams layoutParams) {
        return this.addViewInLayout(view, n, layoutParams, false);
    }

    protected boolean addViewInLayout(View view, int n, LayoutParams layoutParams, boolean bl) {
        view.mParent = null;
        this.addViewInner(view, n, layoutParams, bl);
        view.mPrivateFlags = 0x20 | 0xFF9FFFFF & view.mPrivateFlags;
        return true;
    }

    protected void attachLayoutAnimationParameters(View view, LayoutParams layoutParams, int n, int n2) {
        LayoutAnimationController.AnimationParameters animationParameters = layoutParams.layoutAnimationParameters;
        if (animationParameters == null) {
            layoutParams.layoutAnimationParameters = animationParameters = new LayoutAnimationController.AnimationParameters();
        }
        animationParameters.count = n2;
        animationParameters.index = n;
    }

    protected void attachViewToParent(View view, int n, LayoutParams layoutParams) {
        view.mLayoutParams = layoutParams;
        if (n < 0) {
            n = this.mChildrenCount;
        }
        this.addInArray(view, n);
        view.mParent = this;
        view.mPrivateFlags = Integer.MIN_VALUE | (0x20 | 0xFFFF7FFF & (0xFF9FFFFF & view.mPrivateFlags));
        this.mPrivateFlags = Integer.MIN_VALUE | this.mPrivateFlags;
        if (view.hasFocus()) {
            this.requestChildFocus(view, view.findFocus());
        }
    }

    @Override
    public void bringChildToFront(View view) {
        int n = this.indexOfChild(view);
        if (n >= 0) {
            this.removeFromArray(n);
            this.addInArray(view, this.mChildrenCount);
            view.mParent = this;
            this.requestLayout();
            this.invalidate();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    ArrayList<View> buildOrderedChildList() {
        int n = this.mChildrenCount;
        if (n <= 1 || !this.hasChildWithZ()) {
            return null;
        }
        if (this.mPreSortedChildren == null) {
            this.mPreSortedChildren = new ArrayList(n);
        } else {
            this.mPreSortedChildren.ensureCapacity(n);
        }
        boolean bl = this.isChildrenDrawingOrderEnabled();
        int n2 = 0;
        while (n2 < this.mChildrenCount) {
            int n3;
            int n4 = bl ? this.getChildDrawingOrder(this.mChildrenCount, n2) : n2;
            View view = this.mChildren[n4];
            float f = view.getZ();
            for (n3 = n2; n3 > 0 && this.mPreSortedChildren.get(n3 - 1).getZ() > f; --n3) {
            }
            this.mPreSortedChildren.add(n3, view);
            ++n2;
        }
        return this.mPreSortedChildren;
    }

    protected boolean canAnimate() {
        return this.mLayoutAnimationController != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void captureTransitioningViews(List<View> list) {
        if (this.getVisibility() == 0) {
            if (this.isTransitionGroup()) {
                list.add(this);
                return;
            }
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.getChildAt(i).captureTransitioningViews(list);
            }
        }
    }

    protected boolean checkLayoutParams(LayoutParams layoutParams) {
        return layoutParams != null;
    }

    @Override
    public void childDrawableStateChanged(View view) {
        if ((0x2000 & this.mGroupFlags) != 0) {
            this.refreshDrawableState();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public void childHasTransientStateChanged(View view, boolean bl) {
        boolean bl2 = this.hasTransientState();
        this.mChildCountWithTransientState = bl ? 1 + this.mChildCountWithTransientState : -1 + this.mChildCountWithTransientState;
        boolean bl3 = this.hasTransientState();
        if (this.mParent == null) return;
        if (bl2 == bl3) return;
        try {
            this.mParent.childHasTransientStateChanged(this, bl3);
            return;
        }
        catch (AbstractMethodError abstractMethodError) {
            Log.e(TAG, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", abstractMethodError);
            return;
        }
    }

    protected void cleanupLayoutState(View view) {
        view.mPrivateFlags = 0xFFFFEFFF & view.mPrivateFlags;
    }

    @Override
    public void clearChildFocus(View view) {
        this.mFocused = null;
        if (this.mParent != null) {
            this.mParent.clearChildFocus(this);
        }
    }

    public void clearDisappearingChildren() {
        ArrayList<View> arrayList = this.mDisappearingChildren;
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                View view = arrayList.get(i);
                if (view.mAttachInfo != null) {
                    view.dispatchDetachedFromWindow();
                }
                view.clearAnimation();
            }
            arrayList.clear();
            this.invalidate();
        }
    }

    @Override
    public void clearFocus() {
        if (this.mFocused == null) {
            super.clearFocus();
            return;
        }
        View view = this.mFocused;
        this.mFocused = null;
        view.clearFocus();
    }

    @Override
    Insets computeOpticalInsets() {
        if (this.isLayoutModeOptical()) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < this.mChildrenCount; ++i) {
                View view = this.getChildAt(i);
                if (view.getVisibility() != 0) continue;
                Insets insets = view.getOpticalInsets();
                n = Math.max(n, insets.left);
                n2 = Math.max(n2, insets.top);
                n3 = Math.max(n3, insets.right);
                n4 = Math.max(n4, insets.bottom);
            }
            return Insets.of(n, n2, n3, n4);
        }
        return Insets.NONE;
    }

    @Override
    Bitmap createSnapshot(Bitmap.Config config, int n, boolean bl) {
        int n2 = this.mChildrenCount;
        int[] nArray = null;
        if (bl) {
            nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                View view = this.getChildAt(i);
                nArray[i] = view.getVisibility();
                if (nArray[i] != 0) continue;
                view.setVisibility(4);
            }
        }
        Bitmap bitmap = super.createSnapshot(config, n, bl);
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                this.getChildAt(i).setVisibility(nArray[i]);
            }
        }
        return bitmap;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void damageChild(View view, Rect rect) {
        if (this.damageChildDeferred(view)) return;
        ViewParent viewParent = this;
        View.AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo == null) {
            return;
        }
        int n = view.mLeft;
        int n2 = view.mTop;
        if (!view.getMatrix().isIdentity()) {
            view.transformRect(rect);
        }
        do {
            if (viewParent instanceof ViewGroup) {
                ViewGroup viewGroup = viewParent;
                if (viewGroup.mLayerType != 0) {
                    viewGroup.invalidate();
                    return;
                }
                viewParent = viewGroup.damageChildInParent(n, n2, rect);
                n = viewGroup.mLeft;
                n2 = viewGroup.mTop;
                continue;
            }
            int[] nArray = attachInfo.mInvalidateChildLocation;
            nArray[0] = n;
            nArray[1] = n2;
            viewParent = viewParent.invalidateChildInParent(nArray, rect);
        } while (viewParent != null);
    }

    public boolean damageChildDeferred(View view) {
        ViewParent viewParent = this.getParent();
        while (viewParent != null) {
            if (viewParent instanceof ViewGroup) {
                viewParent = viewParent.getParent();
                continue;
            }
            if (viewParent instanceof ViewRootImpl) {
                ((ViewRootImpl)viewParent).invalidate();
                return true;
            }
            viewParent = null;
        }
        return false;
    }

    protected ViewParent damageChildInParent(int n, int n2, Rect rect) {
        if ((0x20 & this.mPrivateFlags) != 0 || (0x8000 & this.mPrivateFlags) != 0) {
            rect.offset(n - this.mScrollX, n2 - this.mScrollY);
            if ((1 & this.mGroupFlags) == 0) {
                rect.union(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
            }
            if ((1 & this.mGroupFlags) == 0 || rect.intersect(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop)) {
                if (!this.getMatrix().isIdentity()) {
                    this.transformRect(rect);
                }
                return this.mParent;
            }
        }
        return null;
    }

    @Override
    protected void debug(int n) {
        super.debug(n);
        if (this.mFocused != null) {
            String string2 = ViewGroup.debugIndent(n);
            Log.d("View", string2 + "mFocused");
        }
        if (this.mChildrenCount != 0) {
            String string3 = ViewGroup.debugIndent(n);
            Log.d("View", string3 + "{");
        }
        int n2 = this.mChildrenCount;
        for (int i = 0; i < n2; ++i) {
            this.mChildren[i].debug(n + 1);
        }
        if (this.mChildrenCount != 0) {
            String string4 = ViewGroup.debugIndent(n);
            Log.d("View", string4 + "}");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void detachAllViewsFromParent() {
        int n = this.mChildrenCount;
        if (n > 0) {
            View[] viewArray = this.mChildren;
            this.mChildrenCount = 0;
            for (int i = n - 1; i >= 0; --i) {
                viewArray[i].mParent = null;
                viewArray[i] = null;
            }
        }
    }

    protected void detachViewFromParent(int n) {
        this.removeFromArray(n);
    }

    protected void detachViewFromParent(View view) {
        this.removeFromArray(this.indexOfChild(view));
    }

    protected void detachViewsFromParent(int n, int n2) {
        this.removeFromArray(n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WindowInsets dispatchApplyWindowInsets(WindowInsets windowInsets) {
        WindowInsets windowInsets2 = super.dispatchApplyWindowInsets(windowInsets);
        if (windowInsets2.isConsumed()) return windowInsets2;
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n && !(windowInsets2 = this.getChildAt(n2).dispatchApplyWindowInsets(windowInsets2)).isConsumed()) {
            ++n2;
        }
        return windowInsets2;
    }

    @Override
    void dispatchAttachedToWindow(View.AttachInfo attachInfo, int n) {
        this.mGroupFlags = 0x400000 | this.mGroupFlags;
        super.dispatchAttachedToWindow(attachInfo, n);
        this.mGroupFlags = 0xFFBFFFFF & this.mGroupFlags;
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            View view = viewArray[i];
            view.dispatchAttachedToWindow(attachInfo, n | 0xC & view.mViewFlags);
        }
    }

    @Override
    void dispatchCancelPendingInputEvents() {
        super.dispatchCancelPendingInputEvents();
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        for (int i = 0; i < n; ++i) {
            viewArray[i].dispatchCancelPendingInputEvents();
        }
    }

    @Override
    void dispatchCollectViewAttributes(View.AttachInfo attachInfo, int n) {
        if ((n & 0xC) == 0) {
            super.dispatchCollectViewAttributes(attachInfo, n);
            int n2 = this.mChildrenCount;
            View[] viewArray = this.mChildren;
            for (int i = 0; i < n2; ++i) {
                View view = viewArray[i];
                view.dispatchCollectViewAttributes(attachInfo, n | 0xC & view.mViewFlags);
            }
        }
    }

    @Override
    public void dispatchConfigurationChanged(Configuration configuration) {
        super.dispatchConfigurationChanged(configuration);
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            viewArray[i].dispatchConfigurationChanged(configuration);
        }
    }

    @Override
    void dispatchDetachedFromWindow() {
        this.cancelAndClearTouchTargets(null);
        this.exitHoverTargets();
        this.mLayoutCalledWhileSuppressed = false;
        this.mDragNotifiedChildren = null;
        if (this.mCurrentDrag != null) {
            this.mCurrentDrag.recycle();
            this.mCurrentDrag = null;
        }
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            viewArray[i].dispatchDetachedFromWindow();
        }
        this.clearDisappearingChildren();
        super.dispatchDetachedFromWindow();
    }

    @Override
    public void dispatchDisplayHint(int n) {
        super.dispatchDisplayHint(n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            viewArray[i].dispatchDisplayHint(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchDragEvent(DragEvent dragEvent) {
        float f = dragEvent.mX;
        float f2 = dragEvent.mY;
        ViewRootImpl viewRootImpl = this.getViewRootImpl();
        PointF pointF = this.getLocalPoint();
        int n = dragEvent.mAction;
        boolean bl = false;
        switch (n) {
            case 1: {
                this.mCurrentDragView = null;
                this.mCurrentDrag = DragEvent.obtain(dragEvent);
                if (this.mDragNotifiedChildren == null) {
                    this.mDragNotifiedChildren = new HashSet();
                } else {
                    this.mDragNotifiedChildren.clear();
                }
                this.mChildAcceptsDrag = false;
                int n2 = this.mChildrenCount;
                View[] viewArray = this.mChildren;
                for (int i = 0; i < n2; ++i) {
                    View view = viewArray[i];
                    view.mPrivateFlags2 = 0xFFFFFFFC & view.mPrivateFlags2;
                    if (view.getVisibility() != 0 || !this.notifyChildOfDrag(viewArray[i])) continue;
                    this.mChildAcceptsDrag = true;
                }
                boolean bl2 = this.mChildAcceptsDrag;
                bl = false;
                if (!bl2) break;
                return true;
            }
            case 4: {
                if (this.mDragNotifiedChildren != null) {
                    for (View view : this.mDragNotifiedChildren) {
                        view.dispatchDragEvent(dragEvent);
                        view.mPrivateFlags2 = 0xFFFFFFFC & view.mPrivateFlags2;
                        view.refreshDrawableState();
                    }
                    this.mDragNotifiedChildren.clear();
                    if (this.mCurrentDrag != null) {
                        this.mCurrentDrag.recycle();
                        this.mCurrentDrag = null;
                    }
                }
                boolean bl3 = this.mChildAcceptsDrag;
                bl = false;
                if (!bl3) break;
                return true;
            }
            case 2: {
                View view = this.findFrontmostDroppableChildAt(dragEvent.mX, dragEvent.mY, pointF);
                if (this.mCurrentDragView != view) {
                    viewRootImpl.setDragFocus(view);
                    int n3 = dragEvent.mAction;
                    if (this.mCurrentDragView != null) {
                        View view2 = this.mCurrentDragView;
                        dragEvent.mAction = 6;
                        view2.dispatchDragEvent(dragEvent);
                        view2.mPrivateFlags2 = 0xFFFFFFFD & view2.mPrivateFlags2;
                        view2.refreshDrawableState();
                    }
                    this.mCurrentDragView = view;
                    if (view != null) {
                        dragEvent.mAction = 5;
                        view.dispatchDragEvent(dragEvent);
                        view.mPrivateFlags2 = 2 | view.mPrivateFlags2;
                        view.refreshDrawableState();
                    }
                    dragEvent.mAction = n3;
                }
                bl = false;
                if (view == null) break;
                dragEvent.mX = pointF.x;
                dragEvent.mY = pointF.y;
                bl = view.dispatchDragEvent(dragEvent);
                dragEvent.mX = f;
                dragEvent.mY = f2;
                break;
            }
            case 6: {
                View view = this.mCurrentDragView;
                bl = false;
                if (view == null) break;
                View view3 = this.mCurrentDragView;
                view3.dispatchDragEvent(dragEvent);
                view3.mPrivateFlags2 = 0xFFFFFFFD & view3.mPrivateFlags2;
                view3.refreshDrawableState();
                this.mCurrentDragView = null;
                bl = false;
                break;
            }
            case 3: {
                View view = this.findFrontmostDroppableChildAt(dragEvent.mX, dragEvent.mY, pointF);
                bl = false;
                if (view == null) break;
                dragEvent.mX = pointF.x;
                dragEvent.mY = pointF.y;
                bl = view.dispatchDragEvent(dragEvent);
                dragEvent.mX = f;
                dragEvent.mY = f2;
                break;
            }
        }
        if (bl) return bl;
        return super.dispatchDragEvent(dragEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dispatchDraw(Canvas canvas) {
        int n;
        boolean bl = canvas.isRecordingFor(this.mRenderNode);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n3 = this.mGroupFlags;
        if ((n3 & 8) != 0 && this.canAnimate()) {
            boolean bl2 = (0x40 & this.mGroupFlags) == 64;
            boolean bl3 = !this.isHardwareAccelerated();
            for (int i = 0; i < n2; ++i) {
                View view = viewArray[i];
                if ((0xC & view.mViewFlags) != 0) continue;
                this.attachLayoutAnimationParameters(view, view.getLayoutParams(), i, n2);
                this.bindLayoutAnimation(view);
                if (!bl2) continue;
                view.setDrawingCacheEnabled(true);
                if (!bl3) continue;
                view.buildDrawingCache(true);
            }
            LayoutAnimationController layoutAnimationController = this.mLayoutAnimationController;
            if (layoutAnimationController.willOverlap()) {
                this.mGroupFlags = 0x80 | this.mGroupFlags;
            }
            layoutAnimationController.start();
            this.mGroupFlags = 0xFFFFFFF7 & this.mGroupFlags;
            this.mGroupFlags = 0xFFFFFFEF & this.mGroupFlags;
            if (bl2) {
                this.mGroupFlags = 0x8000 | this.mGroupFlags;
            }
            if (this.mAnimationListener != null) {
                this.mAnimationListener.onAnimationStart(layoutAnimationController.getAnimation());
            }
        }
        boolean bl4 = (n3 & 0x22) == 34;
        int n4 = 0;
        if (bl4) {
            n4 = canvas.save();
            canvas.clipRect(this.mScrollX + this.mPaddingLeft, this.mScrollY + this.mPaddingTop, this.mScrollX + this.mRight - this.mLeft - this.mPaddingRight, this.mScrollY + this.mBottom - this.mTop - this.mPaddingBottom);
        }
        this.mPrivateFlags = 0xFFFFFFBF & this.mPrivateFlags;
        this.mGroupFlags = 0xFFFFFFFB & this.mGroupFlags;
        boolean bl5 = false;
        long l = this.getDrawingTime();
        if (bl) {
            canvas.insertReorderBarrier();
        }
        ArrayList<View> arrayList = bl ? null : this.buildOrderedChildList();
        boolean bl6 = arrayList == null && this.isChildrenDrawingOrderEnabled();
        for (int i = 0; i < n2; ++i) {
            int n5 = bl6 ? this.getChildDrawingOrder(n2, i) : i;
            View view = arrayList == null ? viewArray[n5] : arrayList.get(n5);
            if ((0xC & view.mViewFlags) != 0 && view.getAnimation() == null) continue;
            bl5 |= this.drawChild(canvas, view, l);
        }
        if (arrayList != null) {
            arrayList.clear();
        }
        if (this.mDisappearingChildren != null) {
            ArrayList<View> arrayList2 = this.mDisappearingChildren;
            for (int i = -1 + arrayList2.size(); i >= 0; bl5 |= this.drawChild(canvas, arrayList2.get(i), l), --i) {
            }
        }
        if (bl) {
            canvas.insertInorderBarrier();
        }
        if (this.debugDraw()) {
            this.onDebugDraw(canvas);
        }
        if (bl4) {
            canvas.restoreToCount(n4);
        }
        if (((n = this.mGroupFlags) & 4) == 4) {
            this.invalidate(true);
        }
        if ((n & 0x10) == 0 && (n & 0x200) == 0 && this.mLayoutAnimationController.isDone() && !bl5) {
            this.mGroupFlags = 0x200 | this.mGroupFlags;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ViewGroup.this.notifyAnimationListener();
                }
            };
            this.post(runnable);
        }
    }

    @Override
    public void dispatchFinishTemporaryDetach() {
        super.dispatchFinishTemporaryDetach();
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            viewArray[i].dispatchFinishTemporaryDetach();
        }
    }

    protected void dispatchFreezeSelfOnly(SparseArray<Parcelable> sparseArray) {
        super.dispatchSaveInstanceState(sparseArray);
    }

    @Override
    protected boolean dispatchGenericFocusedEvent(MotionEvent motionEvent) {
        if ((0x12 & this.mPrivateFlags) == 18) {
            return super.dispatchGenericFocusedEvent(motionEvent);
        }
        if (this.mFocused != null && (0x10 & this.mFocused.mPrivateFlags) == 16) {
            return this.mFocused.dispatchGenericMotionEvent(motionEvent);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean dispatchGenericPointerEvent(MotionEvent motionEvent) {
        int n = this.mChildrenCount;
        if (n != 0) {
            float f = motionEvent.getX();
            float f2 = motionEvent.getY();
            ArrayList<View> arrayList = this.buildOrderedChildList();
            boolean bl = arrayList == null && this.isChildrenDrawingOrderEnabled();
            View[] viewArray = this.mChildren;
            for (int i = n - 1; i >= 0; --i) {
                int n2 = bl ? this.getChildDrawingOrder(n, i) : i;
                View view = arrayList == null ? viewArray[n2] : arrayList.get(n2);
                if (!ViewGroup.canViewReceivePointerEvents(view) || !this.isTransformedTouchPointInView(f, f2, view, null) || !this.dispatchTransformedGenericPointerEvent(motionEvent, view)) continue;
                if (arrayList != null) {
                    arrayList.clear();
                }
                return true;
            }
            if (arrayList != null) {
                arrayList.clear();
            }
        }
        return super.dispatchGenericPointerEvent(motionEvent);
    }

    @Override
    protected void dispatchGetDisplayList() {
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            View view = viewArray[i];
            if ((0xC & view.mViewFlags) != 0 && view.getAnimation() == null || !view.hasStaticLayer()) continue;
            this.recreateChildDisplayList(view);
        }
        if (this.mOverlay != null) {
            this.recreateChildDisplayList(this.mOverlay.getOverlayView());
        }
        if (this.mDisappearingChildren != null) {
            ArrayList<View> arrayList = this.mDisappearingChildren;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                this.recreateChildDisplayList(arrayList.get(i));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean dispatchHoverEvent(MotionEvent var1_1) {
        block32: {
            block40: {
                block39: {
                    block38: {
                        block31: {
                            block30: {
                                block37: {
                                    block29: {
                                        block27: {
                                            block28: {
                                                block26: {
                                                    block33: {
                                                        var2_2 = var1_1.getAction();
                                                        var3_3 = this.onInterceptHoverEvent(var1_1);
                                                        var1_1.setAction(var2_2);
                                                        var4_4 = var1_1;
                                                        var5_5 = this.mFirstHoverTarget;
                                                        this.mFirstHoverTarget = null;
                                                        var6_6 = false;
                                                        if (var3_3) ** GOTO lbl60
                                                        var6_6 = false;
                                                        if (var2_2 == 10) ** GOTO lbl60
                                                        var16_7 = var1_1.getX();
                                                        var17_8 = var1_1.getY();
                                                        var18_9 = this.mChildrenCount;
                                                        var6_6 = false;
                                                        if (var18_9 == 0) ** GOTO lbl60
                                                        var19_10 = this.buildOrderedChildList();
                                                        if (var19_10 != null || !this.isChildrenDrawingOrderEnabled()) break block33;
                                                        var20_11 = true;
lbl19:
                                                        // 2 sources

                                                        while (true) {
                                                            var21_12 = this.mChildren;
                                                            var22_13 = null;
                                                            block1: for (var23_14 = var18_9 - 1; var23_14 >= 0; --var23_14) {
                                                                if (!var20_11) break block26;
                                                                var24_15 = this.getChildDrawingOrder(var18_9, var23_14);
lbl25:
                                                                // 2 sources

                                                                while (var19_10 == null) {
                                                                    var25_16 = var21_12[var24_15];
lbl27:
                                                                    // 2 sources

                                                                    while (!ViewGroup.canViewReceivePointerEvents(var25_16) || !this.isTransformedTouchPointInView(var16_7, var17_8, var25_16, null)) {
                                                                        continue block1;
                                                                    }
                                                                    break block27;
                                                                }
                                                                break block28;
                                                            }
                                                            ** GOTO lbl58
                                                            break;
                                                        }
                                                    }
                                                    var20_11 = false;
                                                    ** while (true)
                                                }
                                                var24_15 = var23_14;
                                                ** GOTO lbl25
                                            }
                                            var25_16 = var19_10.get(var24_15);
                                            ** GOTO lbl27
                                        }
                                        var26_17 = var5_5;
                                        var27_18 = null;
                                        while (true) {
                                            block35: {
                                                block36: {
                                                    block34: {
                                                        if (var26_17 != null) break block34;
                                                        var26_17 = HoverTarget.obtain(var25_16);
                                                        var28_19 = false;
lbl49:
                                                        // 2 sources

                                                        while (var22_13 != null) {
                                                            var22_13.next = var26_17;
lbl51:
                                                            // 2 sources

                                                            while (true) {
                                                                var22_13 = var26_17;
                                                                if (var2_2 != 9) break block29;
                                                                if (!var28_19) {
                                                                    var6_6 |= this.dispatchTransformedGenericPointerEvent(var1_1, var25_16);
                                                                }
lbl56:
                                                                // 6 sources

                                                                while (true) {
                                                                    if (!var6_6) ** continue;
lbl58:
                                                                    // 2 sources

                                                                    if (var19_10 != null) {
                                                                        var19_10.clear();
                                                                    }
lbl60:
                                                                    // 7 sources

                                                                    block9: while (var5_5 != null) {
                                                                        var12_22 = var5_5.child;
                                                                        if (var2_2 == 10) {
                                                                            var6_6 |= this.dispatchTransformedGenericPointerEvent(var1_1, var12_22);
lbl64:
                                                                            // 2 sources

                                                                            while (true) {
                                                                                var14_23 = var5_5.next;
                                                                                var5_5.recycle();
                                                                                var5_5 = var14_23;
                                                                                continue block9;
                                                                                break;
                                                                            }
                                                                        }
                                                                        break block30;
                                                                    }
                                                                    break block31;
                                                                    break;
                                                                }
                                                                break;
                                                            }
                                                        }
                                                        break;
                                                    }
                                                    if (var26_17.child != var25_16) break block35;
                                                    if (var27_18 == null) break block36;
                                                    var27_18.next = var30_21 = var26_17.next;
lbl76:
                                                    // 2 sources

                                                    while (true) {
                                                        var26_17.next = null;
                                                        var28_19 = true;
                                                        ** GOTO lbl49
                                                        break;
                                                    }
                                                }
                                                var5_5 = var26_17.next;
                                                ** continue;
                                            }
                                            var27_18 = var26_17;
                                            var26_17 = var26_17.next;
                                        }
                                        this.mFirstHoverTarget = var26_17;
                                        ** while (true)
                                    }
                                    if (var2_2 != 7) ** GOTO lbl56
                                    if (var28_19) break block37;
                                    var4_4 = ViewGroup.obtainMotionEventNoHistoryOrSelf(var4_4);
                                    var4_4.setAction(9);
                                    var29_20 = var6_6 | this.dispatchTransformedGenericPointerEvent(var4_4, var25_16);
                                    var4_4.setAction(var2_2);
                                    var6_6 = var29_20 | this.dispatchTransformedGenericPointerEvent(var4_4, var25_16);
                                    ** GOTO lbl56
                                }
                                var6_6 |= this.dispatchTransformedGenericPointerEvent(var1_1, var25_16);
                                ** while (true)
                            }
                            if (var2_2 == 7) {
                                this.dispatchTransformedGenericPointerEvent(var1_1, var12_22);
                            }
                            var4_4 = ViewGroup.obtainMotionEventNoHistoryOrSelf(var4_4);
                            var4_4.setAction(10);
                            this.dispatchTransformedGenericPointerEvent(var4_4, var12_22);
                            var4_4.setAction(var2_2);
                            ** while (true)
                        }
                        if (var6_6) break block38;
                        var7_24 = true;
lbl114:
                        // 2 sources

                        while (var7_24 == (var8_25 = this.mHoveredSelf)) {
                            if (var7_24) {
                                var6_6 |= super.dispatchHoverEvent(var1_1);
                            }
lbl117:
                            // 6 sources

                            while (true) {
                                if (var4_4 != var1_1) {
                                    var4_4.recycle();
                                }
                                return var6_6;
                            }
                        }
                        break block39;
                    }
                    var7_24 = false;
                    ** GOTO lbl114
                }
                if (!this.mHoveredSelf) ** GOTO lbl131
                if (var2_2 != 10) break block40;
                var6_6 |= super.dispatchHoverEvent(var1_1);
lbl129:
                // 2 sources

                while (true) {
                    this.mHoveredSelf = false;
lbl131:
                    // 2 sources

                    if (var7_24) {
                        if (var2_2 != 9) break block32;
                        var6_6 |= super.dispatchHoverEvent(var1_1);
                        this.mHoveredSelf = true;
                    }
                    ** GOTO lbl117
                    break;
                }
            }
            if (var2_2 == 7) {
                super.dispatchHoverEvent(var1_1);
            }
            var4_4 = ViewGroup.obtainMotionEventNoHistoryOrSelf(var4_4);
            var4_4.setAction(10);
            super.dispatchHoverEvent(var4_4);
            var4_4.setAction(var2_2);
            ** while (true)
        }
        if (var2_2 != 7) ** GOTO lbl117
        var4_4 = ViewGroup.obtainMotionEventNoHistoryOrSelf(var4_4);
        var4_4.setAction(9);
        var9_26 = var6_6 | super.dispatchHoverEvent(var4_4);
        var4_4.setAction(var2_2);
        var6_6 = var9_26 | super.dispatchHoverEvent(var4_4);
        this.mHoveredSelf = true;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onKeyEvent(keyEvent, 1);
        }
        if ((0x12 & this.mPrivateFlags) == 18 ? super.dispatchKeyEvent(keyEvent) : this.mFocused != null && (0x10 & this.mFocused.mPrivateFlags) == 16 && this.mFocused.dispatchKeyEvent(keyEvent)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(keyEvent, 1);
        }
        return false;
    }

    @Override
    public boolean dispatchKeyEventPreIme(KeyEvent keyEvent) {
        if ((0x12 & this.mPrivateFlags) == 18) {
            return super.dispatchKeyEventPreIme(keyEvent);
        }
        if (this.mFocused != null && (0x10 & this.mFocused.mPrivateFlags) == 16) {
            return this.mFocused.dispatchKeyEventPreIme(keyEvent);
        }
        return false;
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
        if ((0x12 & this.mPrivateFlags) == 18) {
            return super.dispatchKeyShortcutEvent(keyEvent);
        }
        if (this.mFocused != null && (0x10 & this.mFocused.mPrivateFlags) == 16) {
            return this.mFocused.dispatchKeyShortcutEvent(keyEvent);
        }
        return false;
    }

    @Override
    boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        int n;
        boolean bl;
        if (this.includeForAccessibility() && (bl = super.dispatchPopulateAccessibilityEventInternal(accessibilityEvent))) {
            return bl;
        }
        ChildListForAccessibility childListForAccessibility = ChildListForAccessibility.obtain(this, true);
        try {
            n = childListForAccessibility.getChildCount();
        }
        catch (Throwable throwable) {
            childListForAccessibility.recycle();
            throw throwable;
        }
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            View view = childListForAccessibility.getChildAt(i);
            if ((0xC & view.mViewFlags) != 0 || !(bl2 = view.dispatchPopulateAccessibilityEvent(accessibilityEvent))) continue;
            childListForAccessibility.recycle();
            return bl2;
        }
        childListForAccessibility.recycle();
        return false;
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        super.dispatchRestoreInstanceState(sparseArray);
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            View view = viewArray[i];
            if ((0x20000000 & view.mViewFlags) == 0x20000000) continue;
            view.dispatchRestoreInstanceState(sparseArray);
        }
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        super.dispatchSaveInstanceState(sparseArray);
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            View view = viewArray[i];
            if ((0x20000000 & view.mViewFlags) == 0x20000000) continue;
            view.dispatchSaveInstanceState(sparseArray);
        }
    }

    @Override
    void dispatchScreenStateChanged(int n) {
        super.dispatchScreenStateChanged(n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            viewArray[i].dispatchScreenStateChanged(n);
        }
    }

    @Override
    public void dispatchSetActivated(boolean bl) {
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        for (int i = 0; i < n; ++i) {
            viewArray[i].setActivated(bl);
        }
    }

    @Override
    protected void dispatchSetPressed(boolean bl) {
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        for (int i = 0; i < n; ++i) {
            View view = viewArray[i];
            if (bl && (view.isClickable() || view.isLongClickable())) continue;
            view.setPressed(bl);
        }
    }

    @Override
    public void dispatchSetSelected(boolean bl) {
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        for (int i = 0; i < n; ++i) {
            viewArray[i].setSelected(bl);
        }
    }

    @Override
    public void dispatchStartTemporaryDetach() {
        super.dispatchStartTemporaryDetach();
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            viewArray[i].dispatchStartTemporaryDetach();
        }
    }

    @Override
    public void dispatchSystemUiVisibilityChanged(int n) {
        super.dispatchSystemUiVisibilityChanged(n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            viewArray[i].dispatchSystemUiVisibilityChanged(n);
        }
    }

    protected void dispatchThawSelfOnly(SparseArray<Parcelable> sparseArray) {
        super.dispatchRestoreInstanceState(sparseArray);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean dispatchTouchEvent(MotionEvent var1_1) {
        block61: {
            block60: {
                block43: {
                    block52: {
                        block57: {
                            block56: {
                                block46: {
                                    block48: {
                                        block49: {
                                            block47: {
                                                block45: {
                                                    block44: {
                                                        block50: {
                                                            block51: {
                                                                block53: {
                                                                    block55: {
                                                                        block54: {
                                                                            if (this.mInputEventConsistencyVerifier != null) {
                                                                                this.mInputEventConsistencyVerifier.onTouchEvent(var1_1, 1);
                                                                            }
                                                                            var2_2 = this.onFilterTouchEventForSecurity(var1_1);
                                                                            var3_3 = false;
                                                                            if (!var2_2) ** GOTO lbl143
                                                                            var4_4 = var1_1.getAction();
                                                                            var5_5 = var4_4 & 255;
                                                                            if (var5_5 == 0) {
                                                                                this.cancelAndClearTouchTargets(var1_1);
                                                                                this.resetTouchState();
                                                                            }
                                                                            if (var5_5 != 0 && this.mFirstTouchTarget == null) break block53;
                                                                            if ((524288 & this.mGroupFlags) == 0) break block54;
                                                                            var6_6 = true;
lbl14:
                                                                            // 2 sources

                                                                            while (!var6_6) {
                                                                                var7_7 = this.onInterceptTouchEvent(var1_1);
                                                                                var1_1.setAction(var4_4);
lbl17:
                                                                                // 3 sources

                                                                                while (ViewGroup.resetCancelNextUpFlag(this) || var5_5 == 3) {
                                                                                    var8_8 = true;
lbl19:
                                                                                    // 2 sources

                                                                                    while ((0x200000 & this.mGroupFlags) != 0) {
                                                                                        var9_9 = true;
lbl21:
                                                                                        // 2 sources

                                                                                        while (true) {
                                                                                            var10_10 = false;
                                                                                            var11_11 = null;
                                                                                            if (var8_8) break block43;
                                                                                            var10_10 = false;
                                                                                            var11_11 = null;
                                                                                            if (var7_7) break block43;
                                                                                            if (!(var5_5 == 0 || var9_9 && var5_5 == 5)) {
                                                                                                var10_10 = false;
                                                                                                var11_11 = null;
                                                                                                if (var5_5 != 7) break block43;
                                                                                            }
                                                                                            var16_12 = var1_1.getActionIndex();
                                                                                            if (!var9_9) break block44;
                                                                                            var17_13 = 1 << var1_1.getPointerId(var16_12);
lbl35:
                                                                                            // 2 sources

                                                                                            while (true) {
                                                                                                this.removePointersFromTouchTargets(var17_13);
                                                                                                var18_14 = this.mChildrenCount;
                                                                                                var10_10 = false;
                                                                                                var11_11 = null;
                                                                                                if (!false) {
                                                                                                    var10_10 = false;
                                                                                                    var11_11 = null;
                                                                                                    if (var18_14 != 0) {
                                                                                                        var20_15 = var1_1.getX(var16_12);
                                                                                                        var21_16 = var1_1.getY(var16_12);
                                                                                                        var22_17 = this.buildOrderedChildList();
                                                                                                        if (var22_17 != null || !this.isChildrenDrawingOrderEnabled()) break block45;
                                                                                                        var23_18 = true;
lbl49:
                                                                                                        // 2 sources

                                                                                                        while (true) {
                                                                                                            var24_19 = this.mChildren;
                                                                                                            var25_20 = var18_14 - 1;
                                                                                                            block6: while (true) {
                                                                                                                var10_10 = false;
                                                                                                                if (var25_20 < 0) break block46;
                                                                                                                if (!var23_18) break block47;
                                                                                                                var26_21 = this.getChildDrawingOrder(var18_14, var25_20);
lbl57:
                                                                                                                // 2 sources

                                                                                                                while (var22_17 == null) {
                                                                                                                    var27_22 = var24_19[var26_21];
lbl59:
                                                                                                                    // 2 sources

                                                                                                                    while (!ViewGroup.canViewReceivePointerEvents(var27_22) || !this.isTransformedTouchPointInView(var20_15, var21_16, var27_22, null)) lbl-1000:
                                                                                                                    // 2 sources

                                                                                                                    {
                                                                                                                        while (true) {
                                                                                                                            --var25_20;
                                                                                                                            continue block6;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        continue block6;
                                                                                                                    }
                                                                                                                    break block48;
                                                                                                                }
                                                                                                                break block49;
                                                                                                                break;
                                                                                                            }
                                                                                                            break;
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                                ** GOTO lbl106
                                                                                                break;
                                                                                            }
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    break block50;
                                                                                }
                                                                                break block51;
                                                                            }
                                                                            break block55;
                                                                        }
                                                                        var6_6 = false;
                                                                        ** GOTO lbl14
                                                                    }
                                                                    var7_7 = false;
                                                                    ** GOTO lbl17
                                                                }
                                                                var7_7 = true;
                                                                ** GOTO lbl17
                                                            }
                                                            var8_8 = false;
                                                            ** GOTO lbl19
                                                        }
                                                        var9_9 = false;
                                                        ** while (true)
                                                    }
                                                    var17_13 = -1;
                                                    ** while (true)
                                                }
                                                var23_18 = false;
                                                ** while (true)
                                            }
                                            var26_21 = var25_20;
                                            ** GOTO lbl57
                                        }
                                        var27_22 = var22_17.get(var26_21);
                                        ** GOTO lbl59
                                    }
                                    var11_11 = this.getTouchTarget(var27_22);
                                    if (var11_11 == null) break block56;
                                    var11_11.pointerIdBits = var30_23 = var17_13 | var11_11.pointerIdBits;
                                }
lbl103:
                                // 2 sources

                                while (true) {
                                    if (var22_17 != null) {
                                        var22_17.clear();
                                    }
lbl106:
                                    // 4 sources

                                    if (var11_11 != null || this.mFirstTouchTarget == null) break block43;
                                    var11_11 = this.mFirstTouchTarget;
                                    while (var11_11.next != null) {
                                        var11_11 = var11_11.next;
                                    }
                                    break block52;
                                    break;
                                }
                            }
                            ViewGroup.resetCancelNextUpFlag(var27_22);
                            ** while (!this.dispatchTransformedTouchEvent((MotionEvent)var1_1, (boolean)false, (View)var27_22, (int)var17_13))
lbl116:
                            // 1 sources

                            this.mLastTouchDownTime = var1_1.getDownTime();
                            if (var22_17 == null) break block57;
                            var29_24 = 0;
                            while (true) {
                                block59: {
                                    block58: {
                                        if (var29_24 >= var18_14) break block58;
                                        if (var24_19[var26_21] != this.mChildren[var29_24]) break block59;
                                        this.mLastTouchDownIndex = var29_24;
                                    }
lbl124:
                                    // 2 sources

                                    while (true) {
                                        this.mLastTouchDownX = var1_1.getX();
                                        this.mLastTouchDownY = var1_1.getY();
                                        var11_11 = this.addTouchTarget(var27_22, var17_13);
                                        var10_10 = true;
                                        ** continue;
                                        break;
                                    }
                                }
                                ++var29_24;
                            }
                        }
                        this.mLastTouchDownIndex = var26_21;
                        ** while (true)
                    }
                    var11_11.pointerIdBits = var19_25 = var17_13 | var11_11.pointerIdBits;
                }
                if (this.mFirstTouchTarget != null) break block60;
                var3_3 = this.dispatchTransformedTouchEvent(var1_1, var8_8, null, -1);
lbl141:
                // 2 sources

                while (var8_8 || var5_5 == 1 || var5_5 == 7) {
                    this.resetTouchState();
lbl143:
                    // 4 sources

                    while (true) {
                        if (!var3_3 && this.mInputEventConsistencyVerifier != null) {
                            this.mInputEventConsistencyVerifier.onUnhandledEvent(var1_1, 1);
                        }
                        return var3_3;
                    }
                }
                break block61;
            }
            var12_26 = null;
            var13_27 = this.mFirstTouchTarget;
            block16: while (var13_27 != null) {
                var14_28 = var13_27.next;
                if (var10_10 && var13_27 == var11_11) {
                    var3_3 = true;
                    while (true) {
                        var12_26 = var13_27;
                        var13_27 = var14_28;
                        continue block16;
                        break;
                    }
                }
                if (ViewGroup.resetCancelNextUpFlag(var13_27.child) || var7_7) {
                    var15_29 = true;
lbl161:
                    // 2 sources

                    while (true) {
                        if (this.dispatchTransformedTouchEvent(var1_1, var15_29, var13_27.child, var13_27.pointerIdBits)) {
                            var3_3 = true;
                        }
                        if (!var15_29) ** continue;
                        if (var12_26 == null) {
                            this.mFirstTouchTarget = var14_28;
lbl167:
                            // 2 sources

                            while (true) {
                                var13_27.recycle();
                                var13_27 = var14_28;
                                continue block16;
                                break;
                            }
                        }
                        break;
                    }
                } else {
                    var15_29 = false;
                    ** continue;
                }
                var12_26.next = var14_28;
                ** continue;
            }
            ** GOTO lbl141
        }
        if (!var9_9 || var5_5 != 6) ** GOTO lbl143
        this.removePointersFromTouchTargets(1 << var1_1.getPointerId(var1_1.getActionIndex()));
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTrackballEvent(motionEvent, 1);
        }
        if ((0x12 & this.mPrivateFlags) == 18 ? super.dispatchTrackballEvent(motionEvent) : this.mFocused != null && (0x10 & this.mFocused.mPrivateFlags) == 16 && this.mFocused.dispatchTrackballEvent(motionEvent)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(motionEvent, 1);
        }
        return false;
    }

    @Override
    public boolean dispatchUnhandledMove(View view, int n) {
        return this.mFocused != null && this.mFocused.dispatchUnhandledMove(view, n);
    }

    @Override
    protected void dispatchVisibilityChanged(View view, int n) {
        super.dispatchVisibilityChanged(view, n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            viewArray[i].dispatchVisibilityChanged(view, n);
        }
    }

    @Override
    public void dispatchWindowFocusChanged(boolean bl) {
        super.dispatchWindowFocusChanged(bl);
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            viewArray[i].dispatchWindowFocusChanged(bl);
        }
    }

    @Override
    public void dispatchWindowSystemUiVisiblityChanged(int n) {
        super.dispatchWindowSystemUiVisiblityChanged(n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            viewArray[i].dispatchWindowSystemUiVisiblityChanged(n);
        }
    }

    @Override
    public void dispatchWindowVisibilityChanged(int n) {
        super.dispatchWindowVisibilityChanged(n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            viewArray[i].dispatchWindowVisibilityChanged(n);
        }
    }

    protected boolean drawChild(Canvas canvas, View view, long l) {
        return view.draw(canvas, this, l);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        super.drawableHotspotChanged(f, f2);
        if ((0x10000 & this.mGroupFlags) != 0) {
            if ((0x2000 & this.mGroupFlags) != 0) {
                throw new IllegalStateException("addStateFromChildren cannot be enabled if a child has duplicateParentState set to true");
            }
            View[] viewArray = this.mChildren;
            int n = this.mChildrenCount;
            for (int i = 0; i < n; ++i) {
                View view = viewArray[i];
                if ((0x400000 & view.mViewFlags) == 0) continue;
                view.drawableHotspotChanged(f, f2);
            }
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if ((0x10000 & this.mGroupFlags) != 0) {
            if ((0x2000 & this.mGroupFlags) != 0) {
                throw new IllegalStateException("addStateFromChildren cannot be enabled if a child has duplicateParentState set to true");
            }
            View[] viewArray = this.mChildren;
            int n = this.mChildrenCount;
            for (int i = 0; i < n; ++i) {
                View view = viewArray[i];
                if ((0x400000 & view.mViewFlags) == 0) continue;
                view.refreshDrawableState();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void endViewTransition(View view) {
        if (this.mTransitioningViews != null) {
            this.mTransitioningViews.remove(view);
            ArrayList<View> arrayList = this.mDisappearingChildren;
            if (arrayList != null && arrayList.contains(view)) {
                arrayList.remove(view);
                if (this.mVisibilityChangingChildren != null && this.mVisibilityChangingChildren.contains(view)) {
                    this.mVisibilityChangingChildren.remove(view);
                } else {
                    if (view.mAttachInfo != null) {
                        view.dispatchDetachedFromWindow();
                    }
                    if (view.mParent != null) {
                        view.mParent = null;
                    }
                }
                this.invalidate();
            }
        }
    }

    @Override
    public View findFocus() {
        if (this.isFocused()) {
            return this;
        }
        if (this.mFocused != null) {
            return this.mFocused.findFocus();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    View findFrontmostDroppableChildAt(float f, float f2, PointF pointF) {
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        int n2 = n - 1;
        while (n2 >= 0) {
            View view = viewArray[n2];
            if (view.canAcceptDrag() && this.isTransformedTouchPointInView(f, f2, view, pointF)) {
                return view;
            }
            --n2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void findNamedViews(Map<String, View> map) {
        if (this.getVisibility() == 0 || this.mGhostView != null) {
            super.findNamedViews(map);
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.getChildAt(i).findNamedViews(map);
            }
        }
    }

    @Override
    public View findViewByAccessibilityIdTraversal(int n) {
        View view = super.findViewByAccessibilityIdTraversal(n);
        if (view != null) {
            return view;
        }
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            View view2 = viewArray[i].findViewByAccessibilityIdTraversal(n);
            if (view2 == null) continue;
            return view2;
        }
        return null;
    }

    @Override
    protected View findViewByPredicateTraversal(Predicate<View> predicate, View view) {
        if (predicate.apply(this)) {
            return this;
        }
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        for (int i = 0; i < n; ++i) {
            View view2;
            View view3 = viewArray[i];
            if (view3 == view || (8 & view3.mPrivateFlags) != 0 || (view2 = view3.findViewByPredicate(predicate)) == null) continue;
            return view2;
        }
        return null;
    }

    @Override
    protected View findViewTraversal(int n) {
        if (n == this.mID) {
            return this;
        }
        View[] viewArray = this.mChildren;
        int n2 = this.mChildrenCount;
        for (int i = 0; i < n2; ++i) {
            View view;
            View view2 = viewArray[i];
            if ((8 & view2.mPrivateFlags) != 0 || (view = view2.findViewById(n)) == null) continue;
            return view;
        }
        return null;
    }

    @Override
    protected View findViewWithTagTraversal(Object object) {
        if (object != null && object.equals(this.mTag)) {
            return this;
        }
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        for (int i = 0; i < n; ++i) {
            View view;
            View view2 = viewArray[i];
            if ((8 & view2.mPrivateFlags) != 0 || (view = view2.findViewWithTag(object)) == null) continue;
            return view;
        }
        return null;
    }

    @Override
    public void findViewsWithText(ArrayList<View> arrayList, CharSequence charSequence, int n) {
        super.findViewsWithText(arrayList, charSequence, n);
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n2; ++i) {
            View view = viewArray[i];
            if ((0xC & view.mViewFlags) != 0 || (8 & view.mPrivateFlags) != 0) continue;
            view.findViewsWithText(arrayList, charSequence, n);
        }
    }

    void finishAnimatingView(View view, Animation animation) {
        ArrayList<View> arrayList = this.mDisappearingChildren;
        if (arrayList != null && arrayList.contains(view)) {
            arrayList.remove(view);
            if (view.mAttachInfo != null) {
                view.dispatchDetachedFromWindow();
            }
            view.clearAnimation();
            this.mGroupFlags = 4 | this.mGroupFlags;
        }
        if (animation != null && !animation.getFillAfter()) {
            view.clearAnimation();
        }
        if ((0x10000 & view.mPrivateFlags) == 65536) {
            view.onAnimationEnd();
            view.mPrivateFlags = 0xFFFEFFFF & view.mPrivateFlags;
            this.mGroupFlags = 4 | this.mGroupFlags;
        }
    }

    @Override
    public View focusSearch(View view, int n) {
        if (this.isRootNamespace()) {
            return FocusFinder.getInstance().findNextFocus(this, view, n);
        }
        if (this.mParent != null) {
            return this.mParent.focusSearch(view, n);
        }
        return null;
    }

    @Override
    public void focusableViewAvailable(View view) {
        if (!(this.mParent == null || this.getDescendantFocusability() == 393216 || !this.isFocusableInTouchMode() && this.shouldBlockFocusForTouchscreen() || this.isFocused() && this.getDescendantFocusability() != 262144)) {
            this.mParent.focusableViewAvailable(view);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean gatherTransparentRegion(Region region) {
        boolean bl = (0x200 & this.mPrivateFlags) == 0;
        if (bl && region == null) {
            return true;
        }
        super.gatherTransparentRegion(region);
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            View view = viewArray[i];
            if ((0xC & view.mViewFlags) != 0 && view.getAnimation() == null || view.gatherTransparentRegion(region)) continue;
            bl2 = false;
        }
        if (bl) return true;
        boolean bl3 = false;
        if (!bl2) return bl3;
        return true;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(LayoutParams layoutParams) {
        return layoutParams;
    }

    public View getChildAt(int n) {
        if (n < 0 || n >= this.mChildrenCount) {
            return null;
        }
        return this.mChildren[n];
    }

    public int getChildCount() {
        return this.mChildrenCount;
    }

    protected int getChildDrawingOrder(int n, int n2) {
        return n2;
    }

    protected boolean getChildStaticTransformation(View view, Transformation transformation) {
        return false;
    }

    Transformation getChildTransformation() {
        if (this.mChildTransformation == null) {
            this.mChildTransformation = new Transformation();
        }
        return this.mChildTransformation;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getChildVisibleRect(View view, Rect rect, Point point) {
        RectF rectF = this.mAttachInfo != null ? this.mAttachInfo.mTmpTransformRect : new RectF();
        rectF.set(rect);
        if (!view.hasIdentityMatrix()) {
            view.getMatrix().mapRect(rectF);
        }
        int n = view.mLeft - this.mScrollX;
        int n2 = view.mTop - this.mScrollY;
        rectF.offset(n, n2);
        if (point != null) {
            if (!view.hasIdentityMatrix()) {
                float[] fArray = this.mAttachInfo != null ? this.mAttachInfo.mTmpTransformLocation : new float[]{point.x, point.y};
                view.getMatrix().mapPoints(fArray);
                point.x = (int)(0.5f + fArray[0]);
                point.y = (int)(0.5f + fArray[1]);
            }
            point.x = n + point.x;
            point.y = n2 + point.y;
        }
        if (!rectF.intersect(0.0f, 0.0f, this.mRight - this.mLeft, this.mBottom - this.mTop)) {
            return false;
        }
        if (this.mParent == null) {
            return true;
        }
        rect.set((int)(0.5f + rectF.left), (int)(0.5f + rectF.top), (int)(0.5f + rectF.right), (int)(0.5f + rectF.bottom));
        return this.mParent.getChildVisibleRect(this, rect, point);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean getClipChildren() {
        return (1 & this.mGroupFlags) != 0;
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean getClipToPadding() {
        return this.hasBooleanFlag(2);
    }

    View getDeepestFocusedChild() {
        View view = this;
        while (view != null) {
            if (view.isFocused()) {
                return view;
            }
            if (view instanceof ViewGroup) {
                view = view.getFocusedChild();
                continue;
            }
            view = null;
        }
        return null;
    }

    @ViewDebug.ExportedProperty(category="focus", mapping={@ViewDebug.IntToString(from=131072, to="FOCUS_BEFORE_DESCENDANTS"), @ViewDebug.IntToString(from=262144, to="FOCUS_AFTER_DESCENDANTS"), @ViewDebug.IntToString(from=393216, to="FOCUS_BLOCK_DESCENDANTS")})
    public int getDescendantFocusability() {
        return 0x60000 & this.mGroupFlags;
    }

    public View getFocusedChild() {
        return this.mFocused;
    }

    public LayoutAnimationController getLayoutAnimation() {
        return this.mLayoutAnimationController;
    }

    public Animation.AnimationListener getLayoutAnimationListener() {
        return this.mAnimationListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getLayoutMode() {
        if (this.mLayoutMode == -1) {
            int n = this.mParent instanceof ViewGroup ? ((ViewGroup)this.mParent).getLayoutMode() : LAYOUT_MODE_DEFAULT;
            this.setLayoutMode(n, false);
        }
        return this.mLayoutMode;
    }

    public LayoutTransition getLayoutTransition() {
        return this.mTransition;
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollAxes;
    }

    @Override
    public ViewGroupOverlay getOverlay() {
        if (this.mOverlay == null) {
            this.mOverlay = new ViewGroupOverlay(this.mContext, this);
        }
        return (ViewGroupOverlay)this.mOverlay;
    }

    @ViewDebug.ExportedProperty(category="drawing", mapping={@ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=1, to="ANIMATION"), @ViewDebug.IntToString(from=2, to="SCROLLING"), @ViewDebug.IntToString(from=3, to="ALL")})
    public int getPersistentDrawingCache() {
        return this.mPersistentDrawingCache;
    }

    public boolean getTouchscreenBlocksFocus() {
        return (0x4000000 & this.mGroupFlags) != 0;
    }

    @Override
    void handleFocusGainInternal(int n, Rect rect) {
        if (this.mFocused != null) {
            this.mFocused.unFocus(this);
            this.mFocused = null;
        }
        super.handleFocusGainInternal(n, rect);
    }

    @Override
    public boolean hasFocus() {
        return (2 & this.mPrivateFlags) != 0 || this.mFocused != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hasFocusable() {
        if ((0xC & this.mViewFlags) == 0) {
            if (this.isFocusable()) {
                return true;
            }
            if (this.getDescendantFocusability() != 393216) {
                int n = this.mChildrenCount;
                View[] viewArray = this.mChildren;
                for (int i = 0; i < n; ++i) {
                    if (!viewArray[i].hasFocusable()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean hasHoveredChild() {
        return this.mFirstHoverTarget != null;
    }

    @Override
    public boolean hasTransientState() {
        return this.mChildCountWithTransientState > 0 || super.hasTransientState();
    }

    public int indexOfChild(View view) {
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            if (viewArray[i] != view) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void internalSetPadding(int n, int n2, int n3, int n4) {
        super.internalSetPadding(n, n2, n3, n4);
        if ((this.mPaddingLeft | this.mPaddingTop | this.mPaddingRight | this.mPaddingBottom) != 0) {
            this.mGroupFlags = 0x20 | this.mGroupFlags;
            return;
        }
        this.mGroupFlags = 0xFFFFFFDF & this.mGroupFlags;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void invalidateChild(View view, Rect rect) {
        block13: {
            int[] nArray;
            int n;
            boolean bl;
            View.AttachInfo attachInfo;
            ViewParent viewParent;
            block14: {
                Matrix matrix;
                RectF rectF;
                block16: {
                    Matrix matrix2;
                    block15: {
                        viewParent = this;
                        attachInfo = this.mAttachInfo;
                        if (attachInfo == null) break block13;
                        bl = (0x40 & view.mPrivateFlags) == 64;
                        matrix2 = view.getMatrix();
                        boolean bl2 = view.isOpaque() && !bl && view.getAnimation() == null && matrix2.isIdentity();
                        n = bl2 ? 0x400000 : 0x200000;
                        if (view.mLayerType != 0) {
                            this.mPrivateFlags = Integer.MIN_VALUE | this.mPrivateFlags;
                            this.mPrivateFlags = 0xFFFF7FFF & this.mPrivateFlags;
                        }
                        nArray = attachInfo.mInvalidateChildLocation;
                        nArray[0] = view.mLeft;
                        nArray[1] = view.mTop;
                        if (matrix2.isIdentity() && (0x800 & this.mGroupFlags) == 0) break block14;
                        rectF = attachInfo.mTmpTransformRect;
                        rectF.set(rect);
                        if ((0x800 & this.mGroupFlags) == 0) break block15;
                        Transformation transformation = attachInfo.mTmpTransformation;
                        if (this.getChildStaticTransformation(view, transformation)) {
                            matrix = attachInfo.mTmpMatrix;
                            matrix.set(transformation.getMatrix());
                            if (!matrix2.isIdentity()) {
                                matrix.preConcat(matrix2);
                            }
                            break block16;
                        } else {
                            matrix = matrix2;
                        }
                        break block16;
                    }
                    matrix = matrix2;
                }
                matrix.mapRect(rectF);
                rect.set((int)(rectF.left - 0.5f), (int)(rectF.top - 0.5f), (int)(0.5f + rectF.right), (int)(0.5f + rectF.bottom));
            }
            do {
                Matrix matrix;
                boolean bl3 = viewParent instanceof View;
                View view2 = null;
                if (bl3) {
                    view2 = viewParent;
                }
                if (bl) {
                    if (view2 != null) {
                        int n2;
                        view2.mPrivateFlags = n2 = 0x40 | view2.mPrivateFlags;
                    } else if (viewParent instanceof ViewRootImpl) {
                        ((ViewRootImpl)viewParent).mIsAnimating = true;
                    }
                }
                if (view2 != null) {
                    if ((0x3000 & view2.mViewFlags) != 0 && view2.getSolidColor() == 0) {
                        n = 0x200000;
                    }
                    if ((0x600000 & view2.mPrivateFlags) != 0x200000) {
                        int n3;
                        view2.mPrivateFlags = n3 = n | 0xFF9FFFFF & view2.mPrivateFlags;
                    }
                }
                viewParent = viewParent.invalidateChildInParent(nArray, rect);
                if (view2 == null || (matrix = view2.getMatrix()).isIdentity()) continue;
                RectF rectF = attachInfo.mTmpTransformRect;
                rectF.set(rect);
                matrix.mapRect(rectF);
                rect.set((int)(rectF.left - 0.5f), (int)(rectF.top - 0.5f), (int)(0.5f + rectF.right), (int)(0.5f + rectF.bottom));
            } while (viewParent != null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ViewParent invalidateChildInParent(int[] nArray, Rect rect) {
        if ((0x20 & this.mPrivateFlags) != 32 && (0x8000 & this.mPrivateFlags) != 32768) {
            return null;
        }
        if ((0x90 & this.mGroupFlags) != 128) {
            rect.offset(nArray[0] - this.mScrollX, nArray[1] - this.mScrollY);
            if ((1 & this.mGroupFlags) == 0) {
                rect.union(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
            }
            int n = this.mLeft;
            int n2 = this.mTop;
            if ((1 & this.mGroupFlags) == 1 && !rect.intersect(0, 0, this.mRight - n, this.mBottom - n2)) {
                rect.setEmpty();
            }
            this.mPrivateFlags = 0xFFFF7FFF & this.mPrivateFlags;
            nArray[0] = n;
            nArray[1] = n2;
            if (this.mLayerType != 0) {
                this.mPrivateFlags = Integer.MIN_VALUE | this.mPrivateFlags;
            }
            return this.mParent;
        }
        this.mPrivateFlags = 0xFFFF7FDF & this.mPrivateFlags;
        nArray[0] = this.mLeft;
        nArray[1] = this.mTop;
        if ((1 & this.mGroupFlags) == 1) {
            rect.set(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
        } else {
            rect.union(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
        }
        if (this.mLayerType != 0) {
            this.mPrivateFlags = Integer.MIN_VALUE | this.mPrivateFlags;
        }
        return this.mParent;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void invalidateInheritedLayoutMode(int n) {
        if (this.mLayoutMode != -1 && this.mLayoutMode != n && !this.hasBooleanFlag(0x800000)) {
            this.setLayoutMode(-1, false);
            int n2 = this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                this.getChildAt(i).invalidateInheritedLayoutMode(n);
            }
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean isAlwaysDrawnWithCacheEnabled() {
        return (0x4000 & this.mGroupFlags) == 16384;
    }

    @ViewDebug.ExportedProperty
    public boolean isAnimationCacheEnabled() {
        return (0x40 & this.mGroupFlags) == 64;
    }

    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean isChildrenDrawingOrderEnabled() {
        return (0x400 & this.mGroupFlags) == 1024;
    }

    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean isChildrenDrawnWithCacheEnabled() {
        return (0x8000 & this.mGroupFlags) == 32768;
    }

    boolean isLayoutModeOptical() {
        return this.mLayoutMode == 1;
    }

    public boolean isLayoutSuppressed() {
        return this.mSuppressLayout;
    }

    public boolean isMotionEventSplittingEnabled() {
        return (0x200000 & this.mGroupFlags) == 0x200000;
    }

    protected boolean isTransformedTouchPointInView(float f, float f2, View view, PointF pointF) {
        boolean bl;
        float f3 = f + (float)this.mScrollX - (float)view.mLeft;
        float f4 = f2 + (float)this.mScrollY - (float)view.mTop;
        if (!view.hasIdentityMatrix() && this.mAttachInfo != null) {
            float[] fArray = this.mAttachInfo.mTmpTransformLocation;
            fArray[0] = f3;
            fArray[1] = f4;
            view.getInverseMatrix().mapPoints(fArray);
            f3 = fArray[0];
            f4 = fArray[1];
        }
        if ((bl = view.pointInView(f3, f4)) && pointF != null) {
            pointF.set(f3, f4);
        }
        return bl;
    }

    public boolean isTransitionGroup() {
        boolean bl;
        block5: {
            block4: {
                if ((0x2000000 & this.mGroupFlags) != 0) {
                    return (0x1000000 & this.mGroupFlags) != 0;
                }
                if (this.getBackground() != null) break block4;
                String string2 = this.getTransitionName();
                bl = false;
                if (string2 == null) break block5;
            }
            bl = true;
        }
        return bl;
    }

    boolean isViewTransitioning(View view) {
        return this.mTransitioningViews != null && this.mTransitioningViews.contains(view);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        for (int i = 0; i < n; ++i) {
            viewArray[i].jumpDrawablesToCurrentState();
        }
    }

    @Override
    public final void layout(int n, int n2, int n3, int n4) {
        if (!(this.mSuppressLayout || this.mTransition != null && this.mTransition.isChangingLayout())) {
            if (this.mTransition != null) {
                this.mTransition.layoutChange(this);
            }
            super.layout(n, n2, n3, n4);
            return;
        }
        this.mLayoutCalledWhileSuppressed = true;
    }

    @Override
    public void makeOptionalFitsSystemWindows() {
        super.makeOptionalFitsSystemWindows();
        int n = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n; ++i) {
            viewArray[i].makeOptionalFitsSystemWindows();
        }
    }

    protected void measureChild(View view, int n, int n2) {
        LayoutParams layoutParams = view.getLayoutParams();
        view.measure(ViewGroup.getChildMeasureSpec(n, this.mPaddingLeft + this.mPaddingRight, layoutParams.width), ViewGroup.getChildMeasureSpec(n2, this.mPaddingTop + this.mPaddingBottom, layoutParams.height));
    }

    protected void measureChildWithMargins(View view, int n, int n2, int n3, int n4) {
        MarginLayoutParams marginLayoutParams = (MarginLayoutParams)view.getLayoutParams();
        view.measure(ViewGroup.getChildMeasureSpec(n, n2 + (this.mPaddingLeft + this.mPaddingRight + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin), marginLayoutParams.width), ViewGroup.getChildMeasureSpec(n3, n4 + (this.mPaddingTop + this.mPaddingBottom + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin), marginLayoutParams.height));
    }

    protected void measureChildren(int n, int n2) {
        int n3 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n3; ++i) {
            View view = viewArray[i];
            if ((0xC & view.mViewFlags) == 8) continue;
            this.measureChild(view, n, n2);
        }
    }

    boolean notifyChildOfDrag(View view) {
        boolean bl = this.mDragNotifiedChildren.contains(view);
        boolean bl2 = false;
        if (!bl) {
            this.mDragNotifiedChildren.add(view);
            bl2 = view.dispatchDragEvent(this.mCurrentDrag);
            if (bl2 && !view.canAcceptDrag()) {
                view.mPrivateFlags2 = 1 | view.mPrivateFlags2;
                view.refreshDrawableState();
            }
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notifySubtreeAccessibilityStateChanged(View view, View view2, int n) {
        if (this.getAccessibilityLiveRegion() != 0) {
            this.notifyViewAccessibilityStateChangedIfNeeded(n);
            return;
        } else {
            if (this.mParent == null) return;
            try {
                this.mParent.notifySubtreeAccessibilityStateChanged(this, view2, n);
                return;
            }
            catch (AbstractMethodError abstractMethodError) {
                Log.e("View", this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", abstractMethodError);
                return;
            }
        }
    }

    public void offsetChildrenTopAndBottom(int n) {
        int n2 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            View view = viewArray[i];
            view.mTop = n + view.mTop;
            view.mBottom = n + view.mBottom;
            if (view.mRenderNode == null) continue;
            bl = true;
            view.mRenderNode.offsetTopAndBottom(n);
        }
        if (bl) {
            this.invalidateViewProperty(false, false);
        }
        this.notifySubtreeAccessibilityStateChangedIfNeeded();
    }

    public final void offsetDescendantRectToMyCoords(View view, Rect rect) {
        this.offsetRectBetweenParentAndChild(view, rect, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    void offsetRectBetweenParentAndChild(View view, Rect rect, boolean bl, boolean bl2) {
        if (view == this) {
            return;
        }
        ViewParent viewParent = view.mParent;
        while (viewParent != null && viewParent instanceof View && viewParent != this) {
            if (bl) {
                rect.offset(view.mLeft - view.mScrollX, view.mTop - view.mScrollY);
                if (bl2) {
                    View view2 = (View)((Object)viewParent);
                    rect.intersect(0, 0, view2.mRight - view2.mLeft, view2.mBottom - view2.mTop);
                }
            } else {
                if (bl2) {
                    View view3 = (View)((Object)viewParent);
                    rect.intersect(0, 0, view3.mRight - view3.mLeft, view3.mBottom - view3.mTop);
                }
                rect.offset(view.mScrollX - view.mLeft, view.mScrollY - view.mTop);
            }
            view = (View)((Object)viewParent);
            viewParent = view.mParent;
        }
        if (viewParent != this) {
            throw new IllegalArgumentException("parameter must be a descendant of this view");
        }
        if (bl) {
            rect.offset(view.mLeft - view.mScrollX, view.mTop - view.mScrollY);
            return;
        }
        rect.offset(view.mScrollX - view.mLeft, view.mScrollY - view.mTop);
    }

    public final void offsetRectIntoDescendantCoords(View view, Rect rect) {
        this.offsetRectBetweenParentAndChild(view, rect, false, false);
    }

    @Override
    protected void onAnimationEnd() {
        super.onAnimationEnd();
        if ((0x40 & this.mGroupFlags) == 64) {
            this.mGroupFlags = 0xFFFF7FFF & this.mGroupFlags;
            if ((1 & this.mPersistentDrawingCache) == 0) {
                this.setChildrenDrawingCacheEnabled(false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onAnimationStart() {
        super.onAnimationStart();
        if ((0x40 & this.mGroupFlags) == 64) {
            int n = this.mChildrenCount;
            View[] viewArray = this.mChildren;
            boolean bl = !this.isHardwareAccelerated();
            for (int i = 0; i < n; ++i) {
                View view = viewArray[i];
                if ((0xC & view.mViewFlags) != 0) continue;
                view.setDrawingCacheEnabled(true);
                if (!bl) continue;
                view.buildDrawingCache(true);
            }
            this.mGroupFlags = 0x8000 | this.mGroupFlags;
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.clearCachedLayoutMode();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onChildVisibilityChanged(View view, int n, int n2) {
        if (this.mTransition != null) {
            if (n2 == 0) {
                this.mTransition.showChild(this, view, n);
            } else {
                this.mTransition.hideChild(this, view, n2);
                if (this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
                    if (this.mVisibilityChangingChildren == null) {
                        this.mVisibilityChangingChildren = new ArrayList();
                    }
                    this.mVisibilityChangingChildren.add(view);
                    this.addDisappearingView(view);
                }
            }
        }
        if (this.mCurrentDrag != null && n2 == 0) {
            this.notifyChildOfDrag(view);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int[] onCreateDrawableState(int n) {
        if ((0x2000 & this.mGroupFlags) == 0) {
            return super.onCreateDrawableState(n);
        }
        int n2 = 0;
        int n3 = this.getChildCount();
        for (int i = 0; i < n3; ++i) {
            int[] nArray = this.getChildAt(i).getDrawableState();
            if (nArray == null) continue;
            n2 += nArray.length;
        }
        int[] nArray = super.onCreateDrawableState(n + n2);
        int n4 = 0;
        while (n4 < n3) {
            int[] nArray2 = this.getChildAt(n4).getDrawableState();
            if (nArray2 != null) {
                nArray = ViewGroup.mergeDrawableStates(nArray, nArray2);
            }
            ++n4;
        }
        return nArray;
    }

    protected void onDebugDraw(Canvas canvas) {
        Paint paint = ViewGroup.getDebugPaint();
        paint.setColor(-65536);
        paint.setStyle(Paint.Style.STROKE);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            Insets insets = view.getOpticalInsets();
            ViewGroup.drawRect(canvas, paint, view.getLeft() + insets.left, view.getTop() + insets.top, -1 + (view.getRight() - insets.right), -1 + (view.getBottom() - insets.bottom));
        }
        paint.setColor(Color.argb(63, 255, 0, 255));
        paint.setStyle(Paint.Style.FILL);
        this.onDebugDrawMargins(canvas, paint);
        paint.setColor(Color.rgb(63, 127, 255));
        paint.setStyle(Paint.Style.FILL);
        int n = this.dipsToPixels(8);
        int n2 = this.dipsToPixels(1);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            ViewGroup.drawRectCorners(canvas, view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), paint, n, n2);
        }
    }

    protected void onDebugDrawMargins(Canvas canvas, Paint paint) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            view.getLayoutParams().onDebugDraw(view, canvas, paint);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clearCachedLayoutMode();
    }

    @Override
    void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEventInternal(accessibilityEvent);
        accessibilityEvent.setClassName(ViewGroup.class.getName());
    }

    @Override
    void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfoInternal(accessibilityNodeInfo);
        if (this.mAttachInfo != null) {
            ArrayList<View> arrayList = this.mAttachInfo.mTempArrayList;
            arrayList.clear();
            this.addChildrenForAccessibility(arrayList);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                accessibilityNodeInfo.addChildUnchecked(arrayList.get(i));
            }
            arrayList.clear();
        }
    }

    public boolean onInterceptHoverEvent(MotionEvent motionEvent) {
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return false;
    }

    @Override
    protected abstract void onLayout(boolean var1, int var2, int var3, int var4, int var5);

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return false;
    }

    @Override
    public boolean onNestedPreFling(View view, float f, float f2) {
        return false;
    }

    @Override
    public void onNestedPreScroll(View view, int n, int n2, int[] nArray) {
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        this.mNestedScrollAxes = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        int n2;
        int n3;
        int n4;
        int n5 = this.mChildrenCount;
        if ((n & 2) != 0) {
            n4 = 0;
            n3 = 1;
            n2 = n5;
        } else {
            n4 = n5 - 1;
            n3 = -1;
            n2 = -1;
        }
        View[] viewArray = this.mChildren;
        int n6 = n4;
        while (n6 != n2) {
            View view = viewArray[n6];
            if ((0xC & view.mViewFlags) == 0 && view.requestFocus(n, rect)) {
                return true;
            }
            n6 += n3;
        }
        return false;
    }

    public boolean onRequestSendAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        if (this.mAccessibilityDelegate != null) {
            return this.mAccessibilityDelegate.onRequestSendAccessibilityEvent(this, view, accessibilityEvent);
        }
        return this.onRequestSendAccessibilityEventInternal(view, accessibilityEvent);
    }

    boolean onRequestSendAccessibilityEventInternal(View view, AccessibilityEvent accessibilityEvent) {
        return true;
    }

    protected void onSetLayoutParams(View view, LayoutParams layoutParams) {
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return false;
    }

    @Override
    public void onStopNestedScroll(View view) {
        this.stopNestedScroll();
    }

    protected void onViewAdded(View view) {
        if (this.mOnHierarchyChangeListener != null) {
            this.mOnHierarchyChangeListener.onChildViewAdded(this, view);
        }
    }

    protected void onViewRemoved(View view) {
        if (this.mOnHierarchyChangeListener != null) {
            this.mOnHierarchyChangeListener.onChildViewRemoved(this, view);
        }
    }

    @Override
    public void recomputeViewAttributes(View view) {
        ViewParent viewParent;
        if (this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes && (viewParent = this.mParent) != null) {
            viewParent.recomputeViewAttributes(this);
        }
    }

    public void removeAllViews() {
        this.removeAllViewsInLayout();
        this.requestLayout();
        this.invalidate(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeAllViewsInLayout() {
        View view;
        block12: {
            block11: {
                int n = this.mChildrenCount;
                if (n <= 0) break block11;
                View[] viewArray = this.mChildren;
                this.mChildrenCount = 0;
                view = this.mFocused;
                boolean bl = this.mAttachInfo != null;
                boolean bl2 = false;
                this.needGlobalAttributesUpdate(false);
                for (int i = n - 1; i >= 0; --i) {
                    View view2 = viewArray[i];
                    if (this.mTransition != null) {
                        this.mTransition.removeChild(this, view2);
                    }
                    if (view2 == view) {
                        view2.unFocus(null);
                        bl2 = true;
                    }
                    if (view2.isAccessibilityFocused()) {
                        view2.clearAccessibilityFocus();
                    }
                    this.cancelTouchTarget(view2);
                    this.cancelHoverTarget(view2);
                    if (view2.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view2)) {
                        this.addDisappearingView(view2);
                    } else if (bl) {
                        view2.dispatchDetachedFromWindow();
                    }
                    if (view2.hasTransientState()) {
                        this.childHasTransientStateChanged(view2, false);
                    }
                    this.onViewRemoved(view2);
                    view2.mParent = null;
                    viewArray[i] = null;
                }
                if (!bl2) break block11;
                this.clearChildFocus(view);
                if (!this.rootViewRequestFocus()) break block12;
            }
            return;
        }
        this.notifyGlobalFocusCleared(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void removeDetachedView(View view, boolean bl) {
        if (this.mTransition != null) {
            this.mTransition.removeChild(this, view);
        }
        if (view == this.mFocused) {
            view.clearFocus();
        }
        view.clearAccessibilityFocus();
        this.cancelTouchTarget(view);
        this.cancelHoverTarget(view);
        if (bl && view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
            this.addDisappearingView(view);
        } else if (view.mAttachInfo != null) {
            view.dispatchDetachedFromWindow();
        }
        if (view.hasTransientState()) {
            this.childHasTransientStateChanged(view, false);
        }
        this.onViewRemoved(view);
    }

    @Override
    public void removeView(View view) {
        this.removeViewInternal(view);
        this.requestLayout();
        this.invalidate(true);
    }

    public void removeViewAt(int n) {
        this.removeViewInternal(n, this.getChildAt(n));
        this.requestLayout();
        this.invalidate(true);
    }

    public void removeViewInLayout(View view) {
        this.removeViewInternal(view);
    }

    public void removeViews(int n, int n2) {
        this.removeViewsInternal(n, n2);
        this.requestLayout();
        this.invalidate(true);
    }

    public void removeViewsInLayout(int n, int n2) {
        this.removeViewsInternal(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void requestChildFocus(View view, View view2) {
        block6: {
            block5: {
                if (this.getDescendantFocusability() == 393216) break block5;
                super.unFocus(view2);
                if (this.mFocused != view) {
                    if (this.mFocused != null) {
                        this.mFocused.unFocus(view2);
                    }
                    this.mFocused = view;
                }
                if (this.mParent != null) break block6;
            }
            return;
        }
        this.mParent.requestChildFocus(this, view2);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
        block3: {
            block2: {
                boolean bl2 = (0x80000 & this.mGroupFlags) != 0;
                if (bl == bl2) break block2;
                this.mGroupFlags = bl ? 0x80000 | this.mGroupFlags : 0xFFF7FFFF & this.mGroupFlags;
                if (this.mParent != null) break block3;
            }
            return;
        }
        this.mParent.requestDisallowInterceptTouchEvent(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean requestFocus(int n, Rect rect) {
        boolean bl;
        int n2 = this.getDescendantFocusability();
        switch (n2) {
            default: {
                throw new IllegalStateException("descendant focusability must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS but is " + n2);
            }
            case 393216: {
                return super.requestFocus(n, rect);
            }
            case 131072: {
                bl = super.requestFocus(n, rect);
                if (bl) return bl;
                return this.onRequestFocusInDescendants(n, rect);
            }
            case 262144: 
        }
        bl = this.onRequestFocusInDescendants(n, rect);
        if (bl) return bl;
        return super.requestFocus(n, rect);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requestSendAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        ViewParent viewParent = this.mParent;
        if (viewParent == null || !this.onRequestSendAccessibilityEvent(view, accessibilityEvent)) {
            return false;
        }
        return viewParent.requestSendAccessibilityEvent(this, accessibilityEvent);
    }

    public void requestTransitionStart(LayoutTransition layoutTransition) {
        ViewRootImpl viewRootImpl = this.getViewRootImpl();
        if (viewRootImpl != null) {
            viewRootImpl.requestTransitionStart(layoutTransition);
        }
    }

    @Override
    public void requestTransparentRegion(View view) {
        if (view != null) {
            view.mPrivateFlags = 0x200 | view.mPrivateFlags;
            if (this.mParent != null) {
                this.mParent.requestTransparentRegion(this);
            }
        }
    }

    @Override
    protected void resetResolvedDrawables() {
        super.resetResolvedDrawables();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (!view.isLayoutDirectionInherited()) continue;
            view.resetResolvedDrawables();
        }
    }

    @Override
    public void resetResolvedLayoutDirection() {
        super.resetResolvedLayoutDirection();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (!view.isLayoutDirectionInherited()) continue;
            view.resetResolvedLayoutDirection();
        }
    }

    @Override
    public void resetResolvedPadding() {
        super.resetResolvedPadding();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (!view.isLayoutDirectionInherited()) continue;
            view.resetResolvedPadding();
        }
    }

    @Override
    public void resetResolvedTextAlignment() {
        super.resetResolvedTextAlignment();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (!view.isTextAlignmentInherited()) continue;
            view.resetResolvedTextAlignment();
        }
    }

    @Override
    public void resetResolvedTextDirection() {
        super.resetResolvedTextDirection();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (!view.isTextDirectionInherited()) continue;
            view.resetResolvedTextDirection();
        }
    }

    @Override
    void resetSubtreeAccessibilityStateChanged() {
        super.resetSubtreeAccessibilityStateChanged();
        View[] viewArray = this.mChildren;
        int n = this.mChildrenCount;
        for (int i = 0; i < n; ++i) {
            viewArray[i].resetSubtreeAccessibilityStateChanged();
        }
    }

    @Override
    protected void resolveDrawables() {
        super.resolveDrawables();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (!view.isLayoutDirectionInherited() || view.areDrawablesResolved()) continue;
            view.resolveDrawables();
        }
    }

    @Override
    public boolean resolveLayoutDirection() {
        boolean bl = super.resolveLayoutDirection();
        if (bl) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (!view.isLayoutDirectionInherited()) continue;
                view.resolveLayoutDirection();
            }
        }
        return bl;
    }

    @Override
    public void resolveLayoutParams() {
        super.resolveLayoutParams();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.getChildAt(i).resolveLayoutParams();
        }
    }

    @Override
    public void resolvePadding() {
        super.resolvePadding();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (!view.isLayoutDirectionInherited() || view.isPaddingResolved()) continue;
            view.resolvePadding();
        }
    }

    @Override
    public boolean resolveRtlPropertiesIfNeeded() {
        boolean bl = super.resolveRtlPropertiesIfNeeded();
        if (bl) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (!view.isLayoutDirectionInherited()) continue;
                view.resolveRtlPropertiesIfNeeded();
            }
        }
        return bl;
    }

    @Override
    public boolean resolveTextAlignment() {
        boolean bl = super.resolveTextAlignment();
        if (bl) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (!view.isTextAlignmentInherited()) continue;
                view.resolveTextAlignment();
            }
        }
        return bl;
    }

    @Override
    public boolean resolveTextDirection() {
        boolean bl = super.resolveTextDirection();
        if (bl) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (!view.isTextDirectionInherited()) continue;
                view.resolveTextDirection();
            }
        }
        return bl;
    }

    public void scheduleLayoutAnimation() {
        this.mGroupFlags = 8 | this.mGroupFlags;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAddStatesFromChildren(boolean bl) {
        this.mGroupFlags = bl ? 0x2000 | this.mGroupFlags : 0xFFFFDFFF & this.mGroupFlags;
        this.refreshDrawableState();
    }

    public void setAlwaysDrawnWithCacheEnabled(boolean bl) {
        this.setBooleanFlag(16384, bl);
    }

    public void setAnimationCacheEnabled(boolean bl) {
        this.setBooleanFlag(64, bl);
    }

    protected void setChildrenDrawingCacheEnabled(boolean bl) {
        if (bl || (3 & this.mPersistentDrawingCache) != 3) {
            View[] viewArray = this.mChildren;
            int n = this.mChildrenCount;
            for (int i = 0; i < n; ++i) {
                viewArray[i].setDrawingCacheEnabled(bl);
            }
        }
    }

    protected void setChildrenDrawingOrderEnabled(boolean bl) {
        this.setBooleanFlag(1024, bl);
    }

    protected void setChildrenDrawnWithCacheEnabled(boolean bl) {
        this.setBooleanFlag(32768, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setClipChildren(boolean bl) {
        boolean bl2 = (1 & this.mGroupFlags) == 1;
        if (bl != bl2) {
            this.setBooleanFlag(1, bl);
            for (int i = 0; i < this.mChildrenCount; ++i) {
                View view = this.getChildAt(i);
                if (view.mRenderNode == null) continue;
                view.mRenderNode.setClipToBounds(bl);
            }
            this.invalidate(true);
        }
    }

    public void setClipToPadding(boolean bl) {
        if (this.hasBooleanFlag(2) != bl) {
            this.setBooleanFlag(2, bl);
            this.invalidate(true);
        }
    }

    public void setDescendantFocusability(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS");
            }
            case 131072: 
            case 262144: 
            case 393216: 
        }
        this.mGroupFlags = 0xFFF9FFFF & this.mGroupFlags;
        this.mGroupFlags |= 0x60000 & n;
    }

    public void setLayoutAnimation(LayoutAnimationController layoutAnimationController) {
        this.mLayoutAnimationController = layoutAnimationController;
        if (this.mLayoutAnimationController != null) {
            this.mGroupFlags = 8 | this.mGroupFlags;
        }
    }

    public void setLayoutAnimationListener(Animation.AnimationListener animationListener) {
        this.mAnimationListener = animationListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setLayoutMode(int n) {
        if (this.mLayoutMode != n) {
            this.invalidateInheritedLayoutMode(n);
            boolean bl = n != -1;
            this.setLayoutMode(n, bl);
            this.requestLayout();
        }
    }

    public void setLayoutTransition(LayoutTransition layoutTransition) {
        if (this.mTransition != null) {
            LayoutTransition layoutTransition2 = this.mTransition;
            layoutTransition2.cancel();
            layoutTransition2.removeTransitionListener(this.mLayoutTransitionListener);
        }
        this.mTransition = layoutTransition;
        if (this.mTransition != null) {
            this.mTransition.addTransitionListener(this.mLayoutTransitionListener);
        }
    }

    public void setMotionEventSplittingEnabled(boolean bl) {
        if (bl) {
            this.mGroupFlags = 0x200000 | this.mGroupFlags;
            return;
        }
        this.mGroupFlags = 0xFFDFFFFF & this.mGroupFlags;
    }

    public void setOnHierarchyChangeListener(OnHierarchyChangeListener onHierarchyChangeListener) {
        this.mOnHierarchyChangeListener = onHierarchyChangeListener;
    }

    public void setPersistentDrawingCache(int n) {
        this.mPersistentDrawingCache = n & 3;
    }

    protected void setStaticTransformationsEnabled(boolean bl) {
        this.setBooleanFlag(2048, bl);
    }

    public void setTouchscreenBlocksFocus(boolean bl) {
        if (bl) {
            View view;
            this.mGroupFlags = 0x4000000 | this.mGroupFlags;
            if (this.hasFocus() && !this.getDeepestFocusedChild().isFocusableInTouchMode() && (view = this.focusSearch(2)) != null) {
                view.requestFocus();
            }
            return;
        }
        this.mGroupFlags = 0xFBFFFFFF & this.mGroupFlags;
    }

    public void setTransitionGroup(boolean bl) {
        this.mGroupFlags = 0x2000000 | this.mGroupFlags;
        if (bl) {
            this.mGroupFlags = 0x1000000 | this.mGroupFlags;
            return;
        }
        this.mGroupFlags = 0xFEFFFFFF & this.mGroupFlags;
    }

    boolean shouldBlockFocusForTouchscreen() {
        return this.getTouchscreenBlocksFocus() && this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
    }

    public boolean shouldDelayChildPressedState() {
        return true;
    }

    @Override
    public boolean showContextMenuForChild(View view) {
        return this.mParent != null && this.mParent.showContextMenuForChild(view);
    }

    @Override
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback) {
        if (this.mParent != null) {
            return this.mParent.startActionModeForChild(view, callback);
        }
        return null;
    }

    public void startLayoutAnimation() {
        if (this.mLayoutAnimationController != null) {
            this.mGroupFlags = 8 | this.mGroupFlags;
            this.requestLayout();
        }
    }

    public void startViewTransition(View view) {
        if (view.mParent == this) {
            if (this.mTransitioningViews == null) {
                this.mTransitioningViews = new ArrayList();
            }
            this.mTransitioningViews.add(view);
        }
    }

    public void suppressLayout(boolean bl) {
        this.mSuppressLayout = bl;
        if (!bl && this.mLayoutCalledWhileSuppressed) {
            this.requestLayout();
            this.mLayoutCalledWhileSuppressed = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean translateBoundsAndIntersectionsInWindowCoordinates(View view, RectF rectF, List<RectF> list) {
        if (this.mAttachInfo == null) {
            return false;
        }
        if (this.getAlpha() <= 0.0f || this.getTransitionAlpha() <= 0.0f || this.getVisibility() != 0) {
            return false;
        }
        if (!view.hasIdentityMatrix()) {
            Matrix matrix = view.getMatrix();
            matrix.mapRect(rectF);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                matrix.mapRect(list.get(i));
            }
        }
        int n = view.mLeft - this.mScrollX;
        int n2 = view.mTop - this.mScrollY;
        rectF.offset(n, n2);
        ViewGroup.offsetRects(list, n, n2);
        if (!rectF.intersects(0.0f, 0.0f, this.getWidth(), this.getHeight())) {
            return false;
        }
        ArrayList<View> arrayList = this.buildOrderedChildList();
        boolean bl = arrayList == null && this.isChildrenDrawingOrderEnabled();
        int n3 = this.mChildrenCount;
        for (int i = n3 - 1; i >= 0; --i) {
            int n4 = bl ? this.getChildDrawingOrder(n3, i) : i;
            View view2 = arrayList == null ? this.mChildren[n4] : arrayList.get(n4);
            if (view2 == view) break;
            if (view2.getVisibility() != 0 || !view2.isClickable() && !view2.isLongClickable()) continue;
            RectF rectF2 = this.mAttachInfo.mTmpTransformRect1;
            rectF2.set(0.0f, 0.0f, view2.getWidth(), view2.getHeight());
            if (!view2.hasIdentityMatrix()) {
                view2.getMatrix().mapRect(rectF2);
            }
            int n5 = view2.mLeft - this.mScrollX;
            int n6 = view2.mTop - this.mScrollY;
            rectF2.offset(n5, n6);
            if (!rectF2.intersect(rectF)) continue;
            if (rectF2.equals(rectF)) {
                return false;
            }
            list.add(new RectF(rectF2));
        }
        if (this.mParent instanceof ViewGroup) {
            return ((ViewGroup)this.mParent).translateBoundsAndIntersectionsInWindowCoordinates(this, rectF, list);
        }
        return true;
    }

    @Override
    void unFocus(View view) {
        if (this.mFocused == null) {
            super.unFocus(view);
            return;
        }
        this.mFocused.unFocus(view);
        this.mFocused = null;
    }

    @Override
    boolean updateLocalSystemUiVisibility(int n, int n2) {
        boolean bl = super.updateLocalSystemUiVisibility(n, n2);
        int n3 = this.mChildrenCount;
        View[] viewArray = this.mChildren;
        for (int i = 0; i < n3; ++i) {
            bl |= viewArray[i].updateLocalSystemUiVisibility(n, n2);
        }
        return bl;
    }

    @Override
    public void updateViewLayout(View view, LayoutParams layoutParams) {
        if (!this.checkLayoutParams(layoutParams)) {
            throw new IllegalArgumentException("Invalid LayoutParams supplied to " + this);
        }
        if (view.mParent != this) {
            throw new IllegalArgumentException("Given view not a child of " + this);
        }
        view.setLayoutParams(layoutParams);
    }

    static class ChildListForAccessibility {
        private static final int MAX_POOL_SIZE = 32;
        private static final Pools.SynchronizedPool<ChildListForAccessibility> sPool = new Pools.SynchronizedPool(32);
        private final ArrayList<View> mChildren = new ArrayList();
        private final ArrayList<ViewLocationHolder> mHolders = new ArrayList();

        ChildListForAccessibility() {
        }

        private void clear() {
            this.mChildren.clear();
        }

        private void init(ViewGroup viewGroup, boolean bl) {
            ArrayList<View> arrayList = this.mChildren;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                arrayList.add(viewGroup.getChildAt(i));
            }
            if (bl) {
                ArrayList<ViewLocationHolder> arrayList2 = this.mHolders;
                for (int i = 0; i < n; ++i) {
                    arrayList2.add(ViewLocationHolder.obtain(viewGroup, arrayList.get(i)));
                }
                this.sort(arrayList2);
                for (int i = 0; i < n; ++i) {
                    ViewLocationHolder viewLocationHolder = arrayList2.get(i);
                    arrayList.set(i, viewLocationHolder.mView);
                    viewLocationHolder.recycle();
                }
                arrayList2.clear();
            }
        }

        public static ChildListForAccessibility obtain(ViewGroup viewGroup, boolean bl) {
            ChildListForAccessibility childListForAccessibility = sPool.acquire();
            if (childListForAccessibility == null) {
                childListForAccessibility = new ChildListForAccessibility();
            }
            childListForAccessibility.init(viewGroup, bl);
            return childListForAccessibility;
        }

        private void sort(ArrayList<ViewLocationHolder> arrayList) {
            try {
                ViewLocationHolder.setComparisonStrategy(1);
                Collections.sort(arrayList);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ViewLocationHolder.setComparisonStrategy(2);
                Collections.sort(arrayList);
                return;
            }
        }

        public View getChildAt(int n) {
            return this.mChildren.get(n);
        }

        public int getChildCount() {
            return this.mChildren.size();
        }

        public int getChildIndex(View view) {
            return this.mChildren.indexOf(view);
        }

        public void recycle() {
            this.clear();
            sPool.release(this);
        }
    }

    private static final class HoverTarget {
        private static final int MAX_RECYCLED = 32;
        private static HoverTarget sRecycleBin;
        private static final Object sRecycleLock;
        private static int sRecycledCount;
        public View child;
        public HoverTarget next;

        static {
            sRecycleLock = new Object[0];
        }

        private HoverTarget() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static HoverTarget obtain(View view) {
            HoverTarget hoverTarget;
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycleBin == null) {
                    hoverTarget = new HoverTarget();
                } else {
                    hoverTarget = sRecycleBin;
                    sRecycleBin = hoverTarget.next;
                    sRecycledCount = -1 + sRecycledCount;
                    hoverTarget.next = null;
                }
            }
            hoverTarget.child = view;
            return hoverTarget;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void recycle() {
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycledCount < 32) {
                    this.next = sRecycleBin;
                    sRecycleBin = this;
                    sRecycledCount = 1 + sRecycledCount;
                } else {
                    this.next = null;
                }
                this.child = null;
                return;
            }
        }
    }

    public static class LayoutParams {
        @Deprecated
        public static final int FILL_PARENT = -1;
        public static final int MATCH_PARENT = -1;
        public static final int WRAP_CONTENT = -2;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="MATCH_PARENT"), @ViewDebug.IntToString(from=-2, to="WRAP_CONTENT")})
        public int height;
        public LayoutAnimationController.AnimationParameters layoutAnimationParameters;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="MATCH_PARENT"), @ViewDebug.IntToString(from=-2, to="WRAP_CONTENT")})
        public int width;

        LayoutParams() {
        }

        public LayoutParams(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ViewGroup_Layout);
            this.setBaseAttributes(typedArray, 0, 1);
            typedArray.recycle();
        }

        public LayoutParams(LayoutParams layoutParams) {
            this.width = layoutParams.width;
            this.height = layoutParams.height;
        }

        protected static String sizeToString(int n) {
            if (n == -2) {
                return "wrap-content";
            }
            if (n == -1) {
                return "match-parent";
            }
            return String.valueOf(n);
        }

        public String debug(String string2) {
            return string2 + "ViewGroup.LayoutParams={ width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " }";
        }

        public void onDebugDraw(View view, Canvas canvas, Paint paint) {
        }

        public void resolveLayoutDirection(int n) {
        }

        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            this.width = typedArray.getLayoutDimension(n, "layout_width");
            this.height = typedArray.getLayoutDimension(n2, "layout_height");
        }
    }

    public static class MarginLayoutParams
    extends LayoutParams {
        public static final int DEFAULT_MARGIN_RELATIVE = Integer.MIN_VALUE;
        private static final int DEFAULT_MARGIN_RESOLVED = 0;
        private static final int LAYOUT_DIRECTION_MASK = 3;
        private static final int LEFT_MARGIN_UNDEFINED_MASK = 4;
        private static final int NEED_RESOLUTION_MASK = 32;
        private static final int RIGHT_MARGIN_UNDEFINED_MASK = 8;
        private static final int RTL_COMPATIBILITY_MODE_MASK = 16;
        private static final int UNDEFINED_MARGIN = Integer.MIN_VALUE;
        @ViewDebug.ExportedProperty(category="layout")
        public int bottomMargin;
        @ViewDebug.ExportedProperty(category="layout")
        private int endMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int leftMargin;
        @ViewDebug.ExportedProperty(category="layout", flagMapping={@ViewDebug.FlagToString(equals=3, mask=3, name="LAYOUT_DIRECTION"), @ViewDebug.FlagToString(equals=4, mask=4, name="LEFT_MARGIN_UNDEFINED_MASK"), @ViewDebug.FlagToString(equals=8, mask=8, name="RIGHT_MARGIN_UNDEFINED_MASK"), @ViewDebug.FlagToString(equals=16, mask=16, name="RTL_COMPATIBILITY_MODE_MASK"), @ViewDebug.FlagToString(equals=32, mask=32, name="NEED_RESOLUTION_MASK")}, formatToHexString=true)
        byte mMarginFlags;
        @ViewDebug.ExportedProperty(category="layout")
        public int rightMargin;
        @ViewDebug.ExportedProperty(category="layout")
        private int startMargin = Integer.MIN_VALUE;
        @ViewDebug.ExportedProperty(category="layout")
        public int topMargin;

        public MarginLayoutParams(int n, int n2) {
            super(n, n2);
            this.endMargin = Integer.MIN_VALUE;
            this.mMarginFlags = (byte)(4 | this.mMarginFlags);
            this.mMarginFlags = (byte)(8 | this.mMarginFlags);
            this.mMarginFlags = (byte)(0xFFFFFFDF & this.mMarginFlags);
            this.mMarginFlags = (byte)(0xFFFFFFEF & this.mMarginFlags);
        }

        /*
         * Enabled aggressive block sorting
         */
        public MarginLayoutParams(Context context, AttributeSet attributeSet) {
            this.endMargin = Integer.MIN_VALUE;
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ViewGroup_MarginLayout);
            this.setBaseAttributes(typedArray, 0, 1);
            int n = typedArray.getDimensionPixelSize(2, -1);
            if (n >= 0) {
                this.leftMargin = n;
                this.topMargin = n;
                this.rightMargin = n;
                this.bottomMargin = n;
            } else {
                this.leftMargin = typedArray.getDimensionPixelSize(3, Integer.MIN_VALUE);
                if (this.leftMargin == Integer.MIN_VALUE) {
                    this.mMarginFlags = (byte)(4 | this.mMarginFlags);
                    this.leftMargin = 0;
                }
                this.rightMargin = typedArray.getDimensionPixelSize(5, Integer.MIN_VALUE);
                if (this.rightMargin == Integer.MIN_VALUE) {
                    this.mMarginFlags = (byte)(8 | this.mMarginFlags);
                    this.rightMargin = 0;
                }
                this.topMargin = typedArray.getDimensionPixelSize(4, 0);
                this.bottomMargin = typedArray.getDimensionPixelSize(6, 0);
                this.startMargin = typedArray.getDimensionPixelSize(7, Integer.MIN_VALUE);
                this.endMargin = typedArray.getDimensionPixelSize(8, Integer.MIN_VALUE);
                if (this.isMarginRelative()) {
                    this.mMarginFlags = (byte)(0x20 | this.mMarginFlags);
                }
            }
            boolean bl = context.getApplicationInfo().hasRtlSupport();
            if (context.getApplicationInfo().targetSdkVersion < 17 || !bl) {
                this.mMarginFlags = (byte)(0x10 | this.mMarginFlags);
            }
            this.mMarginFlags = (byte)(0 | this.mMarginFlags);
            typedArray.recycle();
        }

        public MarginLayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.endMargin = Integer.MIN_VALUE;
            this.mMarginFlags = (byte)(4 | this.mMarginFlags);
            this.mMarginFlags = (byte)(8 | this.mMarginFlags);
            this.mMarginFlags = (byte)(0xFFFFFFDF & this.mMarginFlags);
            this.mMarginFlags = (byte)(0xFFFFFFEF & this.mMarginFlags);
        }

        public MarginLayoutParams(MarginLayoutParams marginLayoutParams) {
            this.endMargin = Integer.MIN_VALUE;
            this.width = marginLayoutParams.width;
            this.height = marginLayoutParams.height;
            this.leftMargin = marginLayoutParams.leftMargin;
            this.topMargin = marginLayoutParams.topMargin;
            this.rightMargin = marginLayoutParams.rightMargin;
            this.bottomMargin = marginLayoutParams.bottomMargin;
            this.startMargin = marginLayoutParams.startMargin;
            this.endMargin = marginLayoutParams.endMargin;
            this.mMarginFlags = marginLayoutParams.mMarginFlags;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void doResolveMargins() {
            block8: {
                int n;
                block7: {
                    if ((0x10 & this.mMarginFlags) != 16) break block7;
                    if ((4 & this.mMarginFlags) == 4 && this.startMargin > Integer.MIN_VALUE) {
                        this.leftMargin = this.startMargin;
                    }
                    if ((8 & this.mMarginFlags) == 8 && this.endMargin > Integer.MIN_VALUE) {
                        this.rightMargin = this.endMargin;
                    }
                    break block8;
                }
                switch (3 & this.mMarginFlags) {
                    default: {
                        n = this.startMargin > Integer.MIN_VALUE ? this.startMargin : 0;
                    }
                    case 1: {
                        int n2 = this.endMargin > Integer.MIN_VALUE ? this.endMargin : 0;
                        this.leftMargin = n2;
                        int n3 = this.startMargin;
                        int n4 = 0;
                        if (n3 > Integer.MIN_VALUE) {
                            n4 = this.startMargin;
                        }
                        this.rightMargin = n4;
                        break block8;
                    }
                }
                this.leftMargin = n;
                int n5 = this.endMargin;
                int n6 = 0;
                if (n5 > Integer.MIN_VALUE) {
                    n6 = this.endMargin;
                }
                this.rightMargin = n6;
            }
            this.mMarginFlags = (byte)(0xFFFFFFDF & this.mMarginFlags);
        }

        public final void copyMarginsFrom(MarginLayoutParams marginLayoutParams) {
            this.leftMargin = marginLayoutParams.leftMargin;
            this.topMargin = marginLayoutParams.topMargin;
            this.rightMargin = marginLayoutParams.rightMargin;
            this.bottomMargin = marginLayoutParams.bottomMargin;
            this.startMargin = marginLayoutParams.startMargin;
            this.endMargin = marginLayoutParams.endMargin;
            this.mMarginFlags = marginLayoutParams.mMarginFlags;
        }

        public int getLayoutDirection() {
            return 3 & this.mMarginFlags;
        }

        public int getMarginEnd() {
            if (this.endMargin != Integer.MIN_VALUE) {
                return this.endMargin;
            }
            if ((0x20 & this.mMarginFlags) == 32) {
                this.doResolveMargins();
            }
            switch (3 & this.mMarginFlags) {
                default: {
                    return this.rightMargin;
                }
                case 1: 
            }
            return this.leftMargin;
        }

        public int getMarginStart() {
            if (this.startMargin != Integer.MIN_VALUE) {
                return this.startMargin;
            }
            if ((0x20 & this.mMarginFlags) == 32) {
                this.doResolveMargins();
            }
            switch (3 & this.mMarginFlags) {
                default: {
                    return this.leftMargin;
                }
                case 1: 
            }
            return this.rightMargin;
        }

        public boolean isLayoutRtl() {
            return (3 & this.mMarginFlags) == 1;
        }

        public boolean isMarginRelative() {
            return this.startMargin != Integer.MIN_VALUE || this.endMargin != Integer.MIN_VALUE;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onDebugDraw(View view, Canvas canvas, Paint paint) {
            Insets insets = View.isLayoutModeOptical(view.mParent) ? view.getOpticalInsets() : Insets.NONE;
            ViewGroup.fillDifference(canvas, view.getLeft() + insets.left, view.getTop() + insets.top, view.getRight() - insets.right, view.getBottom() - insets.bottom, this.leftMargin, this.topMargin, this.rightMargin, this.bottomMargin, paint);
        }

        @Override
        public void resolveLayoutDirection(int n) {
            this.setLayoutDirection(n);
            if (!this.isMarginRelative() || (0x20 & this.mMarginFlags) != 32) {
                return;
            }
            this.doResolveMargins();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setLayoutDirection(int n) {
            if (n != 0 && n != 1 || n == (3 & this.mMarginFlags)) {
                return;
            }
            this.mMarginFlags = (byte)(0xFFFFFFFC & this.mMarginFlags);
            this.mMarginFlags = (byte)(this.mMarginFlags | n & 3);
            if (this.isMarginRelative()) {
                this.mMarginFlags = (byte)(0x20 | this.mMarginFlags);
                return;
            }
            this.mMarginFlags = (byte)(0xFFFFFFDF & this.mMarginFlags);
        }

        public void setMarginEnd(int n) {
            this.endMargin = n;
            this.mMarginFlags = (byte)(0x20 | this.mMarginFlags);
        }

        public void setMarginStart(int n) {
            this.startMargin = n;
            this.mMarginFlags = (byte)(0x20 | this.mMarginFlags);
        }

        public void setMargins(int n, int n2, int n3, int n4) {
            this.leftMargin = n;
            this.topMargin = n2;
            this.rightMargin = n3;
            this.bottomMargin = n4;
            this.mMarginFlags = (byte)(0xFFFFFFFB & this.mMarginFlags);
            this.mMarginFlags = (byte)(0xFFFFFFF7 & this.mMarginFlags);
            if (this.isMarginRelative()) {
                this.mMarginFlags = (byte)(0x20 | this.mMarginFlags);
                return;
            }
            this.mMarginFlags = (byte)(0xFFFFFFDF & this.mMarginFlags);
        }

        public void setMarginsRelative(int n, int n2, int n3, int n4) {
            this.startMargin = n;
            this.topMargin = n2;
            this.endMargin = n3;
            this.bottomMargin = n4;
            this.mMarginFlags = (byte)(0x20 | this.mMarginFlags);
        }
    }

    public static interface OnHierarchyChangeListener {
        public void onChildViewAdded(View var1, View var2);

        public void onChildViewRemoved(View var1, View var2);
    }

    private static final class TouchTarget {
        public static final int ALL_POINTER_IDS = -1;
        private static final int MAX_RECYCLED = 32;
        private static TouchTarget sRecycleBin;
        private static final Object sRecycleLock;
        private static int sRecycledCount;
        public View child;
        public TouchTarget next;
        public int pointerIdBits;

        static {
            sRecycleLock = new Object[0];
        }

        private TouchTarget() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static TouchTarget obtain(View view, int n) {
            TouchTarget touchTarget;
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycleBin == null) {
                    touchTarget = new TouchTarget();
                } else {
                    touchTarget = sRecycleBin;
                    sRecycleBin = touchTarget.next;
                    sRecycledCount = -1 + sRecycledCount;
                    touchTarget.next = null;
                }
            }
            touchTarget.child = view;
            touchTarget.pointerIdBits = n;
            return touchTarget;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void recycle() {
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycledCount < 32) {
                    this.next = sRecycleBin;
                    sRecycleBin = this;
                    sRecycledCount = 1 + sRecycledCount;
                } else {
                    this.next = null;
                }
                this.child = null;
                return;
            }
        }
    }

    static class ViewLocationHolder
    implements Comparable<ViewLocationHolder> {
        public static final int COMPARISON_STRATEGY_LOCATION = 2;
        public static final int COMPARISON_STRATEGY_STRIPE = 1;
        private static final int MAX_POOL_SIZE = 32;
        private static int sComparisonStrategy;
        private static final Pools.SynchronizedPool<ViewLocationHolder> sPool;
        private int mLayoutDirection;
        private final Rect mLocation = new Rect();
        public View mView;

        static {
            sPool = new Pools.SynchronizedPool(32);
            sComparisonStrategy = 1;
        }

        ViewLocationHolder() {
        }

        private void clear() {
            this.mView = null;
            this.mLocation.set(0, 0, 0, 0);
        }

        private void init(ViewGroup viewGroup, View view) {
            Rect rect = this.mLocation;
            view.getDrawingRect(rect);
            viewGroup.offsetDescendantRectToMyCoords(view, rect);
            this.mView = view;
            this.mLayoutDirection = viewGroup.getLayoutDirection();
        }

        public static ViewLocationHolder obtain(ViewGroup viewGroup, View view) {
            ViewLocationHolder viewLocationHolder = sPool.acquire();
            if (viewLocationHolder == null) {
                viewLocationHolder = new ViewLocationHolder();
            }
            viewLocationHolder.init(viewGroup, view);
            return viewLocationHolder;
        }

        public static void setComparisonStrategy(int n) {
            sComparisonStrategy = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int compareTo(ViewLocationHolder viewLocationHolder) {
            int n;
            block10: {
                block9: {
                    int n2;
                    block7: {
                        block8: {
                            n2 = 1;
                            if (viewLocationHolder == null) break block7;
                            if (sComparisonStrategy != n2) break block8;
                            if (this.mLocation.bottom - viewLocationHolder.mLocation.top <= 0) {
                                return -1;
                            }
                            if (this.mLocation.top - viewLocationHolder.mLocation.bottom >= 0) break block7;
                        }
                        if (this.mLayoutDirection != 0) break block9;
                        n2 = this.mLocation.left - viewLocationHolder.mLocation.left;
                        if (n2 == 0) break block10;
                    }
                    return n2;
                }
                int n3 = this.mLocation.right - viewLocationHolder.mLocation.right;
                if (n3 != 0) {
                    return -n3;
                }
            }
            if ((n = this.mLocation.top - viewLocationHolder.mLocation.top) != 0) {
                return n;
            }
            int n4 = this.mLocation.height() - viewLocationHolder.mLocation.height();
            if (n4 != 0) {
                return -n4;
            }
            int n5 = this.mLocation.width() - viewLocationHolder.mLocation.width();
            if (n5 != 0) {
                return -n5;
            }
            return this.mView.getAccessibilityViewId() - viewLocationHolder.mView.getAccessibilityViewId();
        }

        public void recycle() {
            this.clear();
            sPool.release(this);
        }
    }
}

