/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import android.view.OrientationListener;

public abstract class OrientationEventListener {
    private static final boolean DEBUG = false;
    public static final int ORIENTATION_UNKNOWN = -1;
    private static final String TAG = "OrientationEventListener";
    private static final boolean localLOGV;
    private boolean mEnabled = false;
    private OrientationListener mOldListener;
    private int mOrientation = -1;
    private int mRate;
    private Sensor mSensor;
    private SensorEventListener mSensorEventListener;
    private SensorManager mSensorManager;

    public OrientationEventListener(Context context) {
        this(context, 3);
    }

    public OrientationEventListener(Context context, int n) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = n;
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor != null) {
            this.mSensorEventListener = new SensorEventListenerImpl();
        }
    }

    static /* synthetic */ int access$102(OrientationEventListener orientationEventListener, int n) {
        orientationEventListener.mOrientation = n;
        return n;
    }

    public boolean canDetectOrientation() {
        return this.mSensor != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void disable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Invalid disable");
            return;
        } else {
            if (!this.mEnabled) return;
            this.mSensorManager.unregisterListener(this.mSensorEventListener);
            this.mEnabled = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void enable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Not enabled");
            return;
        } else {
            if (this.mEnabled) return;
            this.mSensorManager.registerListener(this.mSensorEventListener, this.mSensor, this.mRate);
            this.mEnabled = true;
            return;
        }
    }

    public abstract void onOrientationChanged(int var1);

    void registerListener(OrientationListener orientationListener) {
        this.mOldListener = orientationListener;
    }

    class SensorEventListenerImpl
    implements SensorEventListener {
        private static final int _DATA_X = 0;
        private static final int _DATA_Y = 1;
        private static final int _DATA_Z = 2;

        SensorEventListenerImpl() {
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int n) {
        }

        @Override
        public void onSensorChanged(SensorEvent sensorEvent) {
            float[] fArray = sensorEvent.values;
            int n = -1;
            float f = -fArray[0];
            float f2 = -fArray[1];
            float f3 = -fArray[2];
            if (4.0f * (f * f + f2 * f2) >= f3 * f3) {
                for (n = 90 - Math.round(57.29578f * (float)Math.atan2(-f2, f)); n >= 360; n -= 360) {
                }
                while (n < 0) {
                    n += 360;
                }
            }
            if (OrientationEventListener.this.mOldListener != null) {
                OrientationEventListener.this.mOldListener.onSensorChanged(1, sensorEvent.values);
            }
            if (n != OrientationEventListener.this.mOrientation) {
                OrientationEventListener.access$102(OrientationEventListener.this, n);
                OrientationEventListener.this.onOrientationChanged(n);
            }
        }
    }
}

