/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.ActionProvider;
import android.view.InflateException;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import com.android.internal.R;
import com.android.internal.view.menu.MenuItemImpl;
import java.io.IOException;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MenuInflater {
    private static final Class<?>[] ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE;
    private static final Class<?>[] ACTION_VIEW_CONSTRUCTOR_SIGNATURE;
    private static final String LOG_TAG = "MenuInflater";
    private static final int NO_ID = 0;
    private static final String XML_GROUP = "group";
    private static final String XML_ITEM = "item";
    private static final String XML_MENU = "menu";
    private final Object[] mActionProviderConstructorArguments;
    private final Object[] mActionViewConstructorArguments;
    private Context mContext;
    private Object mRealOwner;

    static {
        ACTION_VIEW_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class};
        ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE = ACTION_VIEW_CONSTRUCTOR_SIGNATURE;
    }

    public MenuInflater(Context context) {
        this.mContext = context;
        this.mActionViewConstructorArguments = new Object[]{context};
        this.mActionProviderConstructorArguments = this.mActionViewConstructorArguments;
    }

    public MenuInflater(Context context, Object object) {
        this.mContext = context;
        this.mRealOwner = object;
        this.mActionViewConstructorArguments = new Object[]{context};
        this.mActionProviderConstructorArguments = this.mActionViewConstructorArguments;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object findRealOwner(Object object) {
        if (object instanceof Activity || !(object instanceof ContextWrapper)) {
            return object;
        }
        return this.findRealOwner(((ContextWrapper)object).getBaseContext());
    }

    private Object getRealOwner() {
        if (this.mRealOwner == null) {
            this.mRealOwner = this.findRealOwner(this.mContext);
        }
        return this.mRealOwner;
    }

    /*
     * Unable to fully structure code
     */
    private void parseMenu(XmlPullParser var1_1, AttributeSet var2_2, Menu var3_3) throws XmlPullParserException, IOException {
        block9: {
            var4_4 = new MenuState(var3_3);
            var5_5 = var1_1.getEventType();
            var6_6 = false;
            var7_7 = null;
            block5: while (true) {
                if (var5_5 != 2) continue;
                var12_8 = var1_1.getName();
                if (!var12_8.equals("menu")) ** GOTO lbl17
                var5_5 = var1_1.next();
                block6: while (true) {
                    var8_9 = false;
                    block7: while (!var8_9) {
                        switch (var5_5) lbl-1000:
                        // 13 sources

                        {
                            default: {
                                var5_5 = var1_1.next();
                                continue block7;
                            }
lbl17:
                            // 1 sources

                            throw new RuntimeException("Expecting menu, got " + var12_8);
                            if ((var5_5 = var1_1.next()) != 1) continue block5;
                            continue block6;
                            case 2: {
                                if (var6_6) ** GOTO lbl-1000
                                var10_11 = var1_1.getName();
                                if (!var10_11.equals("group")) ** GOTO lbl26
                                var4_4.readGroup(var2_2);
                                ** GOTO lbl-1000
lbl26:
                                // 1 sources

                                if (!var10_11.equals("item")) ** GOTO lbl29
                                var4_4.readItem(var2_2);
                                ** GOTO lbl-1000
lbl29:
                                // 1 sources

                                if (!var10_11.equals("menu")) ** GOTO lbl34
                                var11_12 = var4_4.addSubMenuItem();
                                this.registerMenu(var11_12, var2_2);
                                this.parseMenu(var1_1, var2_2, var11_12);
                                ** GOTO lbl-1000
lbl34:
                                // 1 sources

                                var6_6 = true;
                                var7_7 = var10_11;
                                ** GOTO lbl-1000
                            }
                            case 3: {
                                var9_10 = var1_1.getName();
                                if (!var6_6 || !var9_10.equals(var7_7)) ** GOTO lbl43
                                var6_6 = false;
                                var7_7 = null;
                                ** GOTO lbl-1000
lbl43:
                                // 1 sources

                                if (!var9_10.equals("group")) ** GOTO lbl46
                                var4_4.resetGroup();
                                ** GOTO lbl-1000
lbl46:
                                // 1 sources

                                if (!var9_10.equals("item")) ** GOTO lbl53
                                if (var4_4.hasAddedItem()) ** GOTO lbl-1000
                                if (MenuState.access$000(var4_4) == null || !MenuState.access$000(var4_4).hasSubMenu()) ** GOTO lbl51
                                this.registerMenu(var4_4.addSubMenuItem(), var2_2);
                                ** GOTO lbl-1000
lbl51:
                                // 1 sources

                                this.registerMenu(var4_4.addItem(), var2_2);
                                ** GOTO lbl-1000
lbl53:
                                // 1 sources

                                if (!var9_10.equals("menu")) ** GOTO lbl-1000
                                var8_9 = true;
                                ** GOTO lbl-1000
                            }
                            case 1: {
                                break block5;
                            }
                        }
                    }
                    break block9;
                    break;
                }
                break;
            }
            throw new RuntimeException("Unexpected end of document");
        }
    }

    private void registerMenu(MenuItem menuItem, AttributeSet attributeSet) {
    }

    private void registerMenu(SubMenu subMenu, AttributeSet attributeSet) {
    }

    Context getContext() {
        return this.mContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void inflate(int n, Menu menu2) {
        XmlResourceParser xmlResourceParser = null;
        try {
            xmlResourceParser = this.mContext.getResources().getLayout(n);
            this.parseMenu(xmlResourceParser, Xml.asAttributeSet(xmlResourceParser), menu2);
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new InflateException("Error inflating menu XML", xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new InflateException("Error inflating menu XML", iOException);
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    private static class InflatedOnMenuItemClickListener
    implements MenuItem.OnMenuItemClickListener {
        private static final Class<?>[] PARAM_TYPES = new Class[]{MenuItem.class};
        private Method mMethod;
        private Object mRealOwner;

        public InflatedOnMenuItemClickListener(Object object, String string2) {
            this.mRealOwner = object;
            Class<?> clazz = object.getClass();
            try {
                this.mMethod = clazz.getMethod(string2, PARAM_TYPES);
                return;
            }
            catch (Exception exception) {
                InflateException inflateException = new InflateException("Couldn't resolve menu item onClick handler " + string2 + " in class " + clazz.getName());
                inflateException.initCause(exception);
                throw inflateException;
            }
        }

        @Override
        public boolean onMenuItemClick(MenuItem menuItem) {
            try {
                if (this.mMethod.getReturnType() == Boolean.TYPE) {
                    return (Boolean)this.mMethod.invoke(this.mRealOwner, menuItem);
                }
                this.mMethod.invoke(this.mRealOwner, menuItem);
                return true;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private class MenuState {
        private static final int defaultGroupId = 0;
        private static final int defaultItemCategory = 0;
        private static final int defaultItemCheckable = 0;
        private static final boolean defaultItemChecked = false;
        private static final boolean defaultItemEnabled = true;
        private static final int defaultItemId = 0;
        private static final int defaultItemOrder = 0;
        private static final boolean defaultItemVisible = true;
        private int groupCategory;
        private int groupCheckable;
        private boolean groupEnabled;
        private int groupId;
        private int groupOrder;
        private boolean groupVisible;
        private ActionProvider itemActionProvider;
        private String itemActionProviderClassName;
        private String itemActionViewClassName;
        private int itemActionViewLayout;
        private boolean itemAdded;
        private char itemAlphabeticShortcut;
        private int itemCategoryOrder;
        private int itemCheckable;
        private boolean itemChecked;
        private boolean itemEnabled;
        private int itemIconResId;
        private int itemId;
        private String itemListenerMethodName;
        private char itemNumericShortcut;
        private int itemShowAsAction;
        private CharSequence itemTitle;
        private CharSequence itemTitleCondensed;
        private boolean itemVisible;
        private Menu menu;

        public MenuState(Menu menu2) {
            this.menu = menu2;
            this.resetGroup();
        }

        static /* synthetic */ ActionProvider access$000(MenuState menuState) {
            return menuState.itemActionProvider;
        }

        private char getShortcut(String string2) {
            if (string2 == null) {
                return '\u0000';
            }
            return string2.charAt(0);
        }

        private <T> T newInstance(String string2, Class<?>[] classArray, Object[] objectArray) {
            Object obj;
            try {
                obj = MenuInflater.this.mContext.getClassLoader().loadClass(string2).getConstructor(classArray).newInstance(objectArray);
            }
            catch (Exception exception) {
                Log.w(MenuInflater.LOG_TAG, "Cannot instantiate class: " + string2, exception);
                return null;
            }
            return (T)obj;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void setItem(MenuItem menuItem) {
            MenuItem menuItem2 = menuItem.setChecked(this.itemChecked).setVisible(this.itemVisible).setEnabled(this.itemEnabled);
            boolean bl = this.itemCheckable >= 1;
            menuItem2.setCheckable(bl).setTitleCondensed(this.itemTitleCondensed).setIcon(this.itemIconResId).setAlphabeticShortcut(this.itemAlphabeticShortcut).setNumericShortcut(this.itemNumericShortcut);
            if (this.itemShowAsAction >= 0) {
                menuItem.setShowAsAction(this.itemShowAsAction);
            }
            if (this.itemListenerMethodName != null) {
                if (MenuInflater.this.mContext.isRestricted()) {
                    throw new IllegalStateException("The android:onClick attribute cannot be used within a restricted context");
                }
                menuItem.setOnMenuItemClickListener(new InflatedOnMenuItemClickListener(MenuInflater.this.getRealOwner(), this.itemListenerMethodName));
            }
            if (menuItem instanceof MenuItemImpl) {
                MenuItemImpl menuItemImpl = (MenuItemImpl)menuItem;
                if (this.itemCheckable >= 2) {
                    menuItemImpl.setExclusiveCheckable(true);
                }
            }
            String string2 = this.itemActionViewClassName;
            boolean bl2 = false;
            if (string2 != null) {
                menuItem.setActionView((View)this.newInstance(this.itemActionViewClassName, ACTION_VIEW_CONSTRUCTOR_SIGNATURE, MenuInflater.this.mActionViewConstructorArguments));
                bl2 = true;
            }
            if (this.itemActionViewLayout > 0) {
                if (!bl2) {
                    menuItem.setActionView(this.itemActionViewLayout);
                } else {
                    Log.w(MenuInflater.LOG_TAG, "Ignoring attribute 'itemActionViewLayout'. Action view already specified.");
                }
            }
            if (this.itemActionProvider != null) {
                menuItem.setActionProvider(this.itemActionProvider);
            }
        }

        public MenuItem addItem() {
            this.itemAdded = true;
            MenuItem menuItem = this.menu.add(this.groupId, this.itemId, this.itemCategoryOrder, this.itemTitle);
            this.setItem(menuItem);
            return menuItem;
        }

        public SubMenu addSubMenuItem() {
            this.itemAdded = true;
            SubMenu subMenu = this.menu.addSubMenu(this.groupId, this.itemId, this.itemCategoryOrder, this.itemTitle);
            this.setItem(subMenu.getItem());
            return subMenu;
        }

        public boolean hasAddedItem() {
            return this.itemAdded;
        }

        public void readGroup(AttributeSet attributeSet) {
            TypedArray typedArray = MenuInflater.this.mContext.obtainStyledAttributes(attributeSet, R.styleable.MenuGroup);
            this.groupId = typedArray.getResourceId(1, 0);
            this.groupCategory = typedArray.getInt(3, 0);
            this.groupOrder = typedArray.getInt(4, 0);
            this.groupCheckable = typedArray.getInt(5, 0);
            this.groupVisible = typedArray.getBoolean(2, true);
            this.groupEnabled = typedArray.getBoolean(0, true);
            typedArray.recycle();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readItem(AttributeSet attributeSet) {
            TypedArray typedArray = MenuInflater.this.mContext.obtainStyledAttributes(attributeSet, R.styleable.MenuItem);
            this.itemId = typedArray.getResourceId(2, 0);
            int n = typedArray.getInt(5, this.groupCategory);
            int n2 = typedArray.getInt(6, this.groupOrder);
            this.itemCategoryOrder = 0xFFFF0000 & n | 0xFFFF & n2;
            this.itemTitle = typedArray.getText(7);
            this.itemTitleCondensed = typedArray.getText(8);
            this.itemIconResId = typedArray.getResourceId(0, 0);
            this.itemAlphabeticShortcut = this.getShortcut(typedArray.getString(9));
            this.itemNumericShortcut = this.getShortcut(typedArray.getString(10));
            if (typedArray.hasValue(11)) {
                int n3 = typedArray.getBoolean(11, false) ? 1 : 0;
                this.itemCheckable = n3;
            } else {
                this.itemCheckable = this.groupCheckable;
            }
            this.itemChecked = typedArray.getBoolean(3, false);
            this.itemVisible = typedArray.getBoolean(4, this.groupVisible);
            this.itemEnabled = typedArray.getBoolean(1, this.groupEnabled);
            this.itemShowAsAction = typedArray.getInt(13, -1);
            this.itemListenerMethodName = typedArray.getString(12);
            this.itemActionViewLayout = typedArray.getResourceId(14, 0);
            this.itemActionViewClassName = typedArray.getString(15);
            this.itemActionProviderClassName = typedArray.getString(16);
            boolean bl = this.itemActionProviderClassName != null;
            if (bl && this.itemActionViewLayout == 0 && this.itemActionViewClassName == null) {
                this.itemActionProvider = (ActionProvider)this.newInstance(this.itemActionProviderClassName, ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE, MenuInflater.this.mActionProviderConstructorArguments);
            } else {
                if (bl) {
                    Log.w(MenuInflater.LOG_TAG, "Ignoring attribute 'actionProviderClass'. Action view already specified.");
                }
                this.itemActionProvider = null;
            }
            typedArray.recycle();
            this.itemAdded = false;
        }

        public void resetGroup() {
            this.groupId = 0;
            this.groupCategory = 0;
            this.groupOrder = 0;
            this.groupCheckable = 0;
            this.groupVisible = true;
            this.groupEnabled = true;
        }
    }
}

