/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.view.IInputFilter;
import android.view.IInputFilterHost;
import android.view.InputEvent;
import android.view.InputEventConsistencyVerifier;

public abstract class InputFilter
extends IInputFilter.Stub {
    private static final int MSG_INPUT_EVENT = 3;
    private static final int MSG_INSTALL = 1;
    private static final int MSG_UNINSTALL = 2;
    private final H mH;
    private IInputFilterHost mHost;
    private final InputEventConsistencyVerifier mInboundInputEventConsistencyVerifier;
    private final InputEventConsistencyVerifier mOutboundInputEventConsistencyVerifier;

    /*
     * Enabled aggressive block sorting
     */
    public InputFilter(Looper looper) {
        InputEventConsistencyVerifier inputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 1, "InputFilter#InboundInputEventConsistencyVerifier") : null;
        this.mInboundInputEventConsistencyVerifier = inputEventConsistencyVerifier;
        boolean bl = InputEventConsistencyVerifier.isInstrumentationEnabled();
        InputEventConsistencyVerifier inputEventConsistencyVerifier2 = null;
        if (bl) {
            inputEventConsistencyVerifier2 = new InputEventConsistencyVerifier(this, 1, "InputFilter#OutboundInputEventConsistencyVerifier");
        }
        this.mOutboundInputEventConsistencyVerifier = inputEventConsistencyVerifier2;
        this.mH = new H(looper);
    }

    static /* synthetic */ IInputFilterHost access$002(InputFilter inputFilter, IInputFilterHost iInputFilterHost) {
        inputFilter.mHost = iInputFilterHost;
        return iInputFilterHost;
    }

    @Override
    public final void filterInputEvent(InputEvent inputEvent, int n) {
        this.mH.obtainMessage(3, n, 0, inputEvent).sendToTarget();
    }

    @Override
    public final void install(IInputFilterHost iInputFilterHost) {
        this.mH.obtainMessage(1, iInputFilterHost).sendToTarget();
    }

    public void onInputEvent(InputEvent inputEvent, int n) {
        this.sendInputEvent(inputEvent, n);
    }

    public void onInstalled() {
    }

    public void onUninstalled() {
    }

    public void sendInputEvent(InputEvent inputEvent, int n) {
        if (inputEvent == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (this.mHost == null) {
            throw new IllegalStateException("Cannot send input event because the input filter is not installed.");
        }
        if (this.mOutboundInputEventConsistencyVerifier != null) {
            this.mOutboundInputEventConsistencyVerifier.onInputEvent(inputEvent, 0);
        }
        try {
            this.mHost.sendInputEvent(inputEvent, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public final void uninstall() {
        this.mH.obtainMessage(2).sendToTarget();
    }

    private final class H
    extends Handler {
        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    InputFilter.access$002(InputFilter.this, (IInputFilterHost)message.obj);
                    if (InputFilter.this.mInboundInputEventConsistencyVerifier != null) {
                        InputFilter.this.mInboundInputEventConsistencyVerifier.reset();
                    }
                    if (InputFilter.this.mOutboundInputEventConsistencyVerifier != null) {
                        InputFilter.this.mOutboundInputEventConsistencyVerifier.reset();
                    }
                    InputFilter.this.onInstalled();
                    return;
                }
                case 2: {
                    try {
                        InputFilter.this.onUninstalled();
                        return;
                    }
                    finally {
                        InputFilter.access$002(InputFilter.this, null);
                    }
                }
                case 3: 
            }
            InputEvent inputEvent = (InputEvent)message.obj;
            try {
                if (InputFilter.this.mInboundInputEventConsistencyVerifier != null) {
                    InputFilter.this.mInboundInputEventConsistencyVerifier.onInputEvent(inputEvent, 0);
                }
                InputFilter.this.onInputEvent(inputEvent, message.arg1);
                return;
            }
            finally {
                inputEvent.recycle();
            }
        }
    }
}

