/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Build;
import android.util.Log;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;

public final class InputEventConsistencyVerifier {
    private static final String EVENT_TYPE_GENERIC_MOTION = "GenericMotionEvent";
    private static final String EVENT_TYPE_KEY = "KeyEvent";
    private static final String EVENT_TYPE_TOUCH = "TouchEvent";
    private static final String EVENT_TYPE_TRACKBALL = "TrackballEvent";
    public static final int FLAG_RAW_DEVICE_INPUT = 1;
    private static final boolean IS_ENG_BUILD = false;
    private static final int RECENT_EVENTS_TO_LOG = 5;
    private final Object mCaller;
    private InputEvent mCurrentEvent;
    private String mCurrentEventType;
    private final int mFlags;
    private boolean mHoverEntered;
    private KeyState mKeyStateList;
    private int mLastEventSeq;
    private String mLastEventType;
    private int mLastNestingLevel;
    private final String mLogTag;
    private int mMostRecentEventIndex;
    private InputEvent[] mRecentEvents;
    private boolean[] mRecentEventsUnhandled;
    private int mTouchEventStreamDeviceId = -1;
    private boolean mTouchEventStreamIsTainted;
    private int mTouchEventStreamPointers;
    private int mTouchEventStreamSource;
    private boolean mTouchEventStreamUnhandled;
    private boolean mTrackballDown;
    private boolean mTrackballUnhandled;
    private StringBuilder mViolationMessage;

    static {
        IS_ENG_BUILD = "eng".equals(Build.TYPE);
    }

    public InputEventConsistencyVerifier(Object object, int n) {
        this(object, n, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public InputEventConsistencyVerifier(Object object, int n, String string2) {
        this.mCaller = object;
        this.mFlags = n;
        if (string2 == null) {
            string2 = "InputEventConsistencyVerifier";
        }
        this.mLogTag = string2;
    }

    private void addKeyState(int n, int n2, int n3) {
        KeyState keyState = KeyState.obtain(n, n2, n3);
        keyState.next = this.mKeyStateList;
        this.mKeyStateList = keyState;
    }

    private static void appendEvent(StringBuilder stringBuilder, int n, InputEvent inputEvent, boolean bl) {
        stringBuilder.append(n).append(": sent at ").append(inputEvent.getEventTimeNano());
        stringBuilder.append(", ");
        if (bl) {
            stringBuilder.append("(unhandled) ");
        }
        stringBuilder.append(inputEvent);
    }

    private void ensureHistorySizeIsZeroForThisAction(MotionEvent motionEvent) {
        int n = motionEvent.getHistorySize();
        if (n != 0) {
            this.problem("History size is " + n + " but it should always be 0 for " + MotionEvent.actionToString(motionEvent.getAction()));
        }
    }

    private void ensureMetaStateIsNormalized(int n) {
        int n2 = KeyEvent.normalizeMetaState(n);
        if (n2 != n) {
            Object[] objectArray = new Object[]{n, n2};
            this.problem(String.format("Metastate not normalized.  Was 0x%08x but expected 0x%08x.", objectArray));
        }
    }

    private void ensurePointerCountIsOneForThisAction(MotionEvent motionEvent) {
        int n = motionEvent.getPointerCount();
        if (n != 1) {
            this.problem("Pointer count is " + n + " but it should always be 1 for " + MotionEvent.actionToString(motionEvent.getAction()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private KeyState findKeyState(int n, int n2, int n3, boolean bl) {
        KeyState keyState = null;
        KeyState keyState2 = this.mKeyStateList;
        while (keyState2 != null) {
            if (keyState2.deviceId == n && keyState2.source == n2 && keyState2.keyCode == n3) {
                if (bl) {
                    if (keyState != null) {
                        keyState.next = keyState2.next;
                    } else {
                        this.mKeyStateList = keyState2.next;
                    }
                    keyState2.next = null;
                }
                return keyState2;
            }
            keyState = keyState2;
            keyState2 = keyState2.next;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void finishEvent() {
        int n;
        if (this.mViolationMessage != null && this.mViolationMessage.length() != 0) {
            if (!this.mCurrentEvent.isTainted()) {
                this.mViolationMessage.append("\n  in ").append(this.mCaller);
                this.mViolationMessage.append("\n  ");
                InputEventConsistencyVerifier.appendEvent(this.mViolationMessage, 0, this.mCurrentEvent, false);
                if (this.mRecentEvents != null) {
                    int n2;
                    InputEvent inputEvent;
                    this.mViolationMessage.append("\n  -- recent events --");
                    for (int i = 0; i < 5 && (inputEvent = this.mRecentEvents[n2 = (5 + this.mMostRecentEventIndex - i) % 5]) != null; ++i) {
                        this.mViolationMessage.append("\n  ");
                        InputEventConsistencyVerifier.appendEvent(this.mViolationMessage, i + 1, inputEvent, this.mRecentEventsUnhandled[n2]);
                    }
                }
                Log.d(this.mLogTag, this.mViolationMessage.toString());
                this.mCurrentEvent.setTainted(true);
            }
            this.mViolationMessage.setLength(0);
        }
        if (this.mRecentEvents == null) {
            this.mRecentEvents = new InputEvent[5];
            this.mRecentEventsUnhandled = new boolean[5];
        }
        this.mMostRecentEventIndex = n = (1 + this.mMostRecentEventIndex) % 5;
        if (this.mRecentEvents[n] != null) {
            this.mRecentEvents[n].recycle();
        }
        this.mRecentEvents[n] = this.mCurrentEvent.copy();
        this.mRecentEventsUnhandled[n] = false;
        this.mCurrentEvent = null;
        this.mCurrentEventType = null;
    }

    public static boolean isInstrumentationEnabled() {
        return IS_ENG_BUILD;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void problem(String string2) {
        if (this.mViolationMessage == null) {
            this.mViolationMessage = new StringBuilder();
        }
        if (this.mViolationMessage.length() == 0) {
            this.mViolationMessage.append(this.mCurrentEventType).append(": ");
        } else {
            this.mViolationMessage.append("\n  ");
        }
        this.mViolationMessage.append(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean startEvent(InputEvent inputEvent, int n, String string2) {
        int n2 = inputEvent.getSequenceNumber();
        if (n2 == this.mLastEventSeq && n < this.mLastNestingLevel && string2 == this.mLastEventType) {
            return false;
        }
        if (n > 0) {
            this.mLastEventSeq = n2;
            this.mLastEventType = string2;
            this.mLastNestingLevel = n;
        } else {
            this.mLastEventSeq = -1;
            this.mLastEventType = null;
            this.mLastNestingLevel = 0;
        }
        this.mCurrentEvent = inputEvent;
        this.mCurrentEventType = string2;
        return true;
    }

    /*
     * Exception decompiling
     */
    public void onGenericMotionEvent(MotionEvent var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 104->170)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onInputEvent(InputEvent inputEvent, int n) {
        if (inputEvent instanceof KeyEvent) {
            this.onKeyEvent((KeyEvent)inputEvent, n);
            return;
        }
        MotionEvent motionEvent = (MotionEvent)inputEvent;
        if (motionEvent.isTouchEvent()) {
            this.onTouchEvent(motionEvent, n);
            return;
        }
        if ((4 & motionEvent.getSource()) != 0) {
            this.onTrackballEvent(motionEvent, n);
            return;
        }
        this.onGenericMotionEvent(motionEvent, n);
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onKeyEvent(KeyEvent var1_1, int var2_2) {
        block15: {
            if (!this.startEvent(var1_1, var2_2, "KeyEvent")) {
                return;
            }
            this.ensureMetaStateIsNormalized(var1_1.getMetaState());
            var4_3 = var1_1.getAction();
            var5_4 = var1_1.getDeviceId();
            var6_5 = var1_1.getSource();
            var7_6 = var1_1.getKeyCode();
            cfr_temp_0 = -2147483648;
lbl10:
            // 2 sources

            block12: while (true) {
                switch (cfr_temp_0 == -2147483648 ? var4_3 : cfr_temp_0) {
                    default: {
                        this.problem("Invalid action " + KeyEvent.actionToString(var4_3) + " for key event.");
                        cfr_temp_0 = 2;
                        continue block12;
                    }
                    case 0: {
                        var9_7 = this.findKeyState(var5_4, var6_5, var7_6, false);
                        if (var9_7 == null) ** GOTO lbl34
                        if (!var9_7.unhandled) ** GOTO lbl29
                        var9_7.unhandled = false;
                        ** GOTO lbl36
                    }
                    catch (Throwable var3_8) {
                        throw var3_8;
                    }
                    finally {
                        this.finishEvent();
                    }
lbl29:
                    // 1 sources

                    if ((1 & this.mFlags) != 0) return;
                    if (var1_1.getRepeatCount() != 0) return;
                    this.problem("ACTION_DOWN but key is already down and this event is not a key repeat.");
                    cfr_temp_0 = 2;
                    continue block12;
lbl34:
                    // 1 sources

                    cfr_temp_0 = 2;
                    this.addKeyState(var5_4, var6_5, var7_6);
lbl36:
                    // 2 sources

                    case 2: {
                        return;
                    }
                    case 1: 
                }
                break;
            }
            break block15;
            ** while (true)
        }
        if ((var8_9 = this.findKeyState(var5_4, var6_5, var7_6, true)) == null) {
            this.problem("ACTION_UP but key was not down.");
            return;
        }
        var8_9.recycle();
        return;
        finally {
        }
    }

    /*
     * Exception decompiling
     */
    public void onTouchEvent(MotionEvent var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [10 : 410->442)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onTrackballEvent(MotionEvent var1_1, int var2_2) {
        block17: {
            if (!this.startEvent(var1_1, var2_2, "TrackballEvent")) {
                return;
            }
            this.ensureMetaStateIsNormalized(var1_1.getMetaState());
            var4_3 = var1_1.getAction();
            if ((4 & var1_1.getSource()) == 0) break block17;
            switch (var4_3) {
                default: {
                    ** try [egrp 1[TRYBLOCK] [1 : 64->121)] { 
lbl13:
                    // 1 sources

                    this.problem("Invalid action " + MotionEvent.actionToString(var4_3) + " for trackball event.");
lbl14:
                    // 4 sources

                    while (this.mTrackballDown && var1_1.getPressure() <= 0.0f) {
                        this.problem("Trackball is down but pressure is not greater than 0.");
                        return;
                    }
                    break;
                }
                case 0: {
                    if (this.mTrackballDown && !this.mTrackballUnhandled) {
                        this.problem("ACTION_DOWN but trackball is already down.");
                    } else {
                        this.mTrackballDown = true;
                        this.mTrackballUnhandled = false;
                    }
                    this.ensureHistorySizeIsZeroForThisAction(var1_1);
                    this.ensurePointerCountIsOneForThisAction(var1_1);
                    ** GOTO lbl14
                }
lbl27:
                // 1 sources

                finally {
                    this.finishEvent();
                }
                case 1: {
                    if (!this.mTrackballDown) {
                        this.problem("ACTION_UP but trackball is not down.");
                    } else {
                        this.mTrackballDown = false;
                        this.mTrackballUnhandled = false;
                    }
                    this.ensureHistorySizeIsZeroForThisAction(var1_1);
                    this.ensurePointerCountIsOneForThisAction(var1_1);
                    ** GOTO lbl14
                }
                case 2: {
                    this.ensurePointerCountIsOneForThisAction(var1_1);
                    ** GOTO lbl14
                }
            }
            if (this.mTrackballDown != false) return;
            if (var1_1.getPressure() == 0.0f) return;
            this.problem("Trackball is up but pressure is not equal to 0.");
            return;
        }
        this.problem("Source was not SOURCE_CLASS_TRACKBALL.");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onUnhandledEvent(InputEvent inputEvent, int n) {
        if (n != this.mLastNestingLevel) return;
        if (this.mRecentEventsUnhandled != null) {
            this.mRecentEventsUnhandled[this.mMostRecentEventIndex] = true;
        }
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            KeyState keyState = this.findKeyState(keyEvent.getDeviceId(), keyEvent.getSource(), keyEvent.getKeyCode(), false);
            if (keyState == null) return;
            keyState.unhandled = true;
            return;
        }
        MotionEvent motionEvent = (MotionEvent)inputEvent;
        if (motionEvent.isTouchEvent()) {
            this.mTouchEventStreamUnhandled = true;
            return;
        }
        if ((4 & motionEvent.getSource()) == 0 || !this.mTrackballDown) {
            return;
        }
        this.mTrackballUnhandled = true;
    }

    public void reset() {
        this.mLastEventSeq = -1;
        this.mLastNestingLevel = 0;
        this.mTrackballDown = false;
        this.mTrackballUnhandled = false;
        this.mTouchEventStreamPointers = 0;
        this.mTouchEventStreamIsTainted = false;
        this.mTouchEventStreamUnhandled = false;
        this.mHoverEntered = false;
        while (this.mKeyStateList != null) {
            KeyState keyState = this.mKeyStateList;
            this.mKeyStateList = keyState.next;
            keyState.recycle();
        }
    }

    private static final class KeyState {
        private static KeyState mRecycledList;
        private static Object mRecycledListLock;
        public int deviceId;
        public int keyCode;
        public KeyState next;
        public int source;
        public boolean unhandled;

        static {
            mRecycledListLock = new Object();
        }

        private KeyState() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static KeyState obtain(int n, int n2, int n3) {
            KeyState keyState;
            Object object = mRecycledListLock;
            synchronized (object) {
                keyState = mRecycledList;
                if (keyState != null) {
                    mRecycledList = keyState.next;
                } else {
                    keyState = new KeyState();
                }
            }
            keyState.deviceId = n;
            keyState.source = n2;
            keyState.keyCode = n3;
            keyState.unhandled = false;
            return keyState;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void recycle() {
            Object object = mRecycledListLock;
            synchronized (object) {
                mRecycledList = this.next = mRecycledList;
                return;
            }
        }
    }
}

