/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.GLES20Canvas;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.RenderNode;
import android.view.Surface;
import android.view.ThreadedRenderer;
import android.view.View;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class HardwareRenderer {
    private static final String CACHE_PATH_SHADERS = "com.android.opengl.shaders_cache";
    public static final String DEBUG_DIRTY_REGIONS_PROPERTY = "debug.hwui.show_dirty_regions";
    public static final String DEBUG_OVERDRAW_PROPERTY = "debug.hwui.overdraw";
    public static final String DEBUG_SHOW_LAYERS_UPDATES_PROPERTY = "debug.hwui.show_layers_updates";
    public static final String DEBUG_SHOW_NON_RECTANGULAR_CLIP_PROPERTY = "debug.hwui.show_non_rect_clip";
    static final String LOG_TAG = "HardwareRenderer";
    public static final String OVERDRAW_PROPERTY_SHOW = "show";
    static final String PRINT_CONFIG_PROPERTY = "debug.hwui.print_config";
    static final String PROFILE_MAXFRAMES_PROPERTY = "debug.hwui.profile.maxframes";
    public static final String PROFILE_PROPERTY = "debug.hwui.profile";
    public static final String PROFILE_PROPERTY_VISUALIZE_BARS = "visual_bars";
    static final String RENDER_DIRTY_REGIONS_PROPERTY = "debug.hwui.render_dirty_regions";
    public static boolean sRendererDisabled = false;
    public static boolean sSystemRendererDisabled = false;
    public static boolean sTrimForeground = false;
    private boolean mEnabled;
    private boolean mRequested = true;

    static HardwareRenderer create(Context context, boolean bl) {
        boolean bl2 = GLES20Canvas.isAvailable();
        ThreadedRenderer threadedRenderer = null;
        if (bl2) {
            threadedRenderer = new ThreadedRenderer(context, bl);
        }
        return threadedRenderer;
    }

    public static void disable(boolean bl) {
        sRendererDisabled = true;
        if (bl) {
            sSystemRendererDisabled = true;
        }
    }

    public static void enableForegroundTrimming() {
        sTrimForeground = true;
    }

    public static boolean isAvailable() {
        return GLES20Canvas.isAvailable();
    }

    public static void setupDiskCache(File file) {
        ThreadedRenderer.setupShadersDiskCache(new File(file, CACHE_PATH_SHADERS).getAbsolutePath());
    }

    static void trimMemory(int n) {
        ThreadedRenderer.trimMemory(n);
    }

    abstract void buildLayer(RenderNode var1);

    abstract boolean copyLayerInto(HardwareLayer var1, Bitmap var2);

    abstract HardwareLayer createTextureLayer();

    abstract void destroy();

    abstract void destroyHardwareResources(View var1);

    abstract void detachSurfaceTexture(long var1);

    abstract void draw(View var1, View.AttachInfo var2, HardwareDrawCallbacks var3);

    abstract void dumpGfxInfo(PrintWriter var1, FileDescriptor var2);

    abstract void fence();

    abstract int getHeight();

    abstract int getWidth();

    abstract boolean initialize(Surface var1) throws Surface.OutOfResourcesException;

    boolean initializeIfNeeded(int n, int n2, Surface surface, Rect rect) throws Surface.OutOfResourcesException {
        if (this.isRequested() && !this.isEnabled() && this.initialize(surface)) {
            this.setup(n, n2, rect);
            return true;
        }
        return false;
    }

    abstract void invalidate(Surface var1);

    abstract void invalidateRoot();

    boolean isEnabled() {
        return this.mEnabled;
    }

    boolean isRequested() {
        return this.mRequested;
    }

    abstract boolean loadSystemProperties();

    abstract void notifyFramePending();

    abstract void onLayerDestroyed(HardwareLayer var1);

    abstract void pauseSurface(Surface var1);

    abstract void pushLayerUpdate(HardwareLayer var1);

    abstract void registerAnimatingRenderNode(RenderNode var1);

    void setEnabled(boolean bl) {
        this.mEnabled = bl;
    }

    abstract void setName(String var1);

    abstract void setOpaque(boolean var1);

    void setRequested(boolean bl) {
        this.mRequested = bl;
    }

    abstract void setup(int var1, int var2, Rect var3);

    abstract void stopDrawing();

    abstract void updateSurface(Surface var1) throws Surface.OutOfResourcesException;

    static interface HardwareDrawCallbacks {
        public void onHardwarePostDraw(HardwareCanvas var1);

        public void onHardwarePreDraw(HardwareCanvas var1);
    }
}

