/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.SystemClock;
import java.util.concurrent.TimeoutException;

public abstract class TimedRemoteCaller<T> {
    public static final long DEFAULT_CALL_TIMEOUT_MILLIS = 5000L;
    private static final int UNDEFINED_SEQUENCE = -1;
    private int mAwaitedSequence = -1;
    private final long mCallTimeoutMillis;
    private final Object mLock = new Object();
    private int mReceivedSequence = -1;
    private T mResult;
    private int mSequenceCounter;

    public TimedRemoteCaller(long l) {
        this.mCallTimeoutMillis = l;
    }

    private boolean waitForResultTimedLocked(int n) {
        long l = SystemClock.uptimeMillis();
        while (true) {
            long l2;
            block6: {
                block5: {
                    if (this.mReceivedSequence != n) break block5;
                    return true;
                }
                long l3 = SystemClock.uptimeMillis() - l;
                l2 = this.mCallTimeoutMillis - l3;
                if (l2 > 0L) break block6;
                return false;
            }
            try {
                this.mLock.wait(l2);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final T getResultTimed(int n) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.waitForResultTimedLocked(n)) {
                throw new TimeoutException("No reponse for sequence: " + n);
            }
            T t = this.mResult;
            this.mResult = null;
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int onBeforeRemoteCall() {
        Object object = this.mLock;
        synchronized (object) {
            int n = this.mSequenceCounter;
            this.mSequenceCounter = n + 1;
            this.mAwaitedSequence = n;
            return this.mAwaitedSequence;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onRemoteMethodResult(T t, int n) {
        Object object = this.mLock;
        synchronized (object) {
            if (n == this.mAwaitedSequence) {
                this.mReceivedSequence = n;
                this.mResult = t;
                this.mLock.notifyAll();
            }
            return;
        }
    }
}

