/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import libcore.util.EmptyArray;

public class SparseIntArray
implements Cloneable {
    private int[] mKeys;
    private int mSize;
    private int[] mValues;

    public SparseIntArray() {
        this(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SparseIntArray(int n) {
        if (n == 0) {
            this.mKeys = EmptyArray.INT;
            this.mValues = EmptyArray.INT;
        } else {
            this.mKeys = ArrayUtils.newUnpaddedIntArray(n);
            this.mValues = new int[this.mKeys.length];
        }
        this.mSize = 0;
    }

    public void append(int n, int n2) {
        if (this.mSize != 0 && n <= this.mKeys[-1 + this.mSize]) {
            this.put(n, n2);
            return;
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, n);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, n2);
        this.mSize = 1 + this.mSize;
    }

    public void clear() {
        this.mSize = 0;
    }

    public SparseIntArray clone() {
        SparseIntArray sparseIntArray = null;
        try {
            sparseIntArray = (SparseIntArray)super.clone();
            sparseIntArray.mKeys = (int[])this.mKeys.clone();
            sparseIntArray.mValues = (int[])this.mValues.clone();
            return sparseIntArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return sparseIntArray;
        }
    }

    public void delete(int n) {
        int n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n2 >= 0) {
            this.removeAt(n2);
        }
    }

    public int get(int n) {
        return this.get(n, 0);
    }

    public int get(int n, int n2) {
        int n3 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n3 < 0) {
            return n2;
        }
        return this.mValues[n3];
    }

    public int indexOfKey(int n) {
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
    }

    public int indexOfValue(int n) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int keyAt(int n) {
        return this.mKeys[n];
    }

    public void put(int n, int n2) {
        int n3 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n3 >= 0) {
            this.mValues[n3] = n2;
            return;
        }
        int n4 = ~n3;
        this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, n4, n);
        this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, n4, n2);
        this.mSize = 1 + this.mSize;
    }

    public void removeAt(int n) {
        System.arraycopy((int[])this.mKeys, (int)(n + 1), (int[])this.mKeys, (int)n, (int)(this.mSize - (n + 1)));
        System.arraycopy((int[])this.mValues, (int)(n + 1), (int[])this.mValues, (int)n, (int)(this.mSize - (n + 1)));
        this.mSize = -1 + this.mSize;
    }

    public int size() {
        return this.mSize;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(28 * this.mSize);
        stringBuilder.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyAt(i));
            stringBuilder.append('=');
            stringBuilder.append(this.valueAt(i));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public int valueAt(int n) {
        return this.mValues[n];
    }
}

