/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.Preconditions;

public final class Size {
    private final int mHeight;
    private final int mWidth;

    public Size(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
    }

    private static NumberFormatException invalidSize(String string2) {
        throw new NumberFormatException("Invalid Size: \"" + string2 + "\"");
    }

    public static Size parseSize(String string2) throws NumberFormatException {
        Preconditions.checkNotNull(string2, "string must not be null");
        int n = string2.indexOf(42);
        if (n < 0) {
            n = string2.indexOf(120);
        }
        if (n < 0) {
            throw Size.invalidSize(string2);
        }
        try {
            Size size = new Size(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
            return size;
        }
        catch (NumberFormatException numberFormatException) {
            throw Size.invalidSize(string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = true;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return bl;
        }
        if (!(object instanceof Size)) return false;
        Size size = (Size)object;
        if (this.mWidth != size.mWidth) return false;
        if (this.mHeight != size.mHeight) return false;
        return bl;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int hashCode() {
        return this.mHeight ^ (this.mWidth << 16 | this.mWidth >>> 16);
    }

    public String toString() {
        return this.mWidth + "x" + this.mHeight;
    }
}

