/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;

public final class Rational
extends Number
implements Comparable<Rational> {
    public static final Rational NEGATIVE_INFINITY;
    public static final Rational NaN;
    public static final Rational POSITIVE_INFINITY;
    public static final Rational ZERO;
    private static final long serialVersionUID = 1L;
    private final int mDenominator;
    private final int mNumerator;

    static {
        NaN = new Rational(0, 0);
        POSITIVE_INFINITY = new Rational(1, 0);
        NEGATIVE_INFINITY = new Rational(-1, 0);
        ZERO = new Rational(0, 1);
    }

    public Rational(int n, int n2) {
        if (n2 < 0) {
            n = -n;
            n2 = -n2;
        }
        if (n2 == 0 && n > 0) {
            this.mNumerator = 1;
            this.mDenominator = 0;
            return;
        }
        if (n2 == 0 && n < 0) {
            this.mNumerator = -1;
            this.mDenominator = 0;
            return;
        }
        if (n2 == 0 && n == 0) {
            this.mNumerator = 0;
            this.mDenominator = 0;
            return;
        }
        if (n == 0) {
            this.mNumerator = 0;
            this.mDenominator = 1;
            return;
        }
        int n3 = Rational.gcd(n, n2);
        this.mNumerator = n / n3;
        this.mDenominator = n2 / n3;
    }

    private boolean equals(Rational rational) {
        return this.mNumerator == rational.mNumerator && this.mDenominator == rational.mDenominator;
    }

    public static int gcd(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n4 != 0) {
            int n5 = n4;
            n4 = n3 % n4;
            n3 = n5;
        }
        return Math.abs(n3);
    }

    private static NumberFormatException invalidRational(String string2) {
        throw new NumberFormatException("Invalid Rational: \"" + string2 + "\"");
    }

    private boolean isNegInf() {
        return this.mDenominator == 0 && this.mNumerator < 0;
    }

    private boolean isPosInf() {
        return this.mDenominator == 0 && this.mNumerator > 0;
    }

    public static Rational parseRational(String string2) throws NumberFormatException {
        Preconditions.checkNotNull(string2, "string must not be null");
        if (string2.equals("NaN")) {
            return NaN;
        }
        if (string2.equals("Infinity")) {
            return POSITIVE_INFINITY;
        }
        if (string2.equals("-Infinity")) {
            return NEGATIVE_INFINITY;
        }
        int n = string2.indexOf(58);
        if (n < 0) {
            n = string2.indexOf(47);
        }
        if (n < 0) {
            throw Rational.invalidRational(string2);
        }
        try {
            Rational rational = new Rational(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
            return rational;
        }
        catch (NumberFormatException numberFormatException) {
            throw Rational.invalidRational(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.mNumerator == 0) {
            if (this.mDenominator == 1 || this.mDenominator == 0) return;
            throw new InvalidObjectException("Rational must be deserialized from a reduced form for zero values");
        }
        if (this.mDenominator == 0) {
            if (this.mNumerator == 1 || this.mNumerator == -1) return;
            throw new InvalidObjectException("Rational must be deserialized from a reduced form for infinity values");
        }
        if (Rational.gcd(this.mNumerator, this.mDenominator) > 1) throw new InvalidObjectException("Rational must be deserialized from a reduced form for finite values");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int compareTo(Rational rational) {
        block9: {
            block8: {
                Preconditions.checkNotNull(rational, "another must not be null");
                if (this.equals(rational)) break block8;
                if (this.isNaN()) {
                    return 1;
                }
                if (rational.isNaN()) {
                    return -1;
                }
                if (this.isPosInf() || rational.isNegInf()) {
                    return 1;
                }
                if (this.isNegInf() || rational.isPosInf()) {
                    return -1;
                }
                long l = (long)this.mNumerator * (long)rational.mDenominator;
                long l2 = (long)rational.mNumerator * (long)this.mDenominator;
                if (l < l2) {
                    return -1;
                }
                if (l > l2) break block9;
            }
            return 0;
        }
        return 1;
    }

    @Override
    public double doubleValue() {
        return (double)this.mNumerator / (double)this.mDenominator;
    }

    public boolean equals(Object object) {
        return object instanceof Rational && this.equals((Rational)object);
    }

    @Override
    public float floatValue() {
        return (float)this.mNumerator / (float)this.mDenominator;
    }

    public int getDenominator() {
        return this.mDenominator;
    }

    public int getNumerator() {
        return this.mNumerator;
    }

    public int hashCode() {
        return (this.mNumerator << 16 | this.mNumerator >>> 16) ^ this.mDenominator;
    }

    @Override
    public int intValue() {
        if (this.isPosInf()) {
            return Integer.MAX_VALUE;
        }
        if (this.isNegInf()) {
            return Integer.MIN_VALUE;
        }
        if (this.isNaN()) {
            return 0;
        }
        return this.mNumerator / this.mDenominator;
    }

    public boolean isFinite() {
        return this.mDenominator != 0;
    }

    public boolean isInfinite() {
        return this.mNumerator != 0 && this.mDenominator == 0;
    }

    public boolean isNaN() {
        return this.mDenominator == 0 && this.mNumerator == 0;
    }

    public boolean isZero() {
        return this.isFinite() && this.mNumerator == 0;
    }

    @Override
    public long longValue() {
        if (this.isPosInf()) {
            return Long.MAX_VALUE;
        }
        if (this.isNegInf()) {
            return Long.MIN_VALUE;
        }
        if (this.isNaN()) {
            return 0L;
        }
        return this.mNumerator / this.mDenominator;
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    public float toFloat() {
        return this.floatValue();
    }

    public String toString() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isPosInf()) {
            return "Infinity";
        }
        if (this.isNegInf()) {
            return "-Infinity";
        }
        return this.mNumerator + "/" + this.mDenominator;
    }
}

