/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.util.Calendar;

public class MonthDisplayHelper {
    private Calendar mCalendar;
    private int mNumDaysInMonth;
    private int mNumDaysInPrevMonth;
    private int mOffset;
    private final int mWeekStartDay;

    public MonthDisplayHelper(int n, int n2) {
        this(n, n2, 1);
    }

    public MonthDisplayHelper(int n, int n2, int n3) {
        if (n3 < 1 || n3 > 7) {
            throw new IllegalArgumentException();
        }
        this.mWeekStartDay = n3;
        this.mCalendar = Calendar.getInstance();
        this.mCalendar.set(1, n);
        this.mCalendar.set(2, n2);
        this.mCalendar.set(5, 1);
        this.mCalendar.set(11, 0);
        this.mCalendar.set(12, 0);
        this.mCalendar.set(13, 0);
        this.mCalendar.getTimeInMillis();
        this.recalculate();
    }

    private void recalculate() {
        this.mNumDaysInMonth = this.mCalendar.getActualMaximum(5);
        this.mCalendar.add(2, -1);
        this.mNumDaysInPrevMonth = this.mCalendar.getActualMaximum(5);
        this.mCalendar.add(2, 1);
        int n = this.getFirstDayOfMonth() - this.mWeekStartDay;
        if (n < 0) {
            n += 7;
        }
        this.mOffset = n;
    }

    public int getColumnOf(int n) {
        return (-1 + (n + this.mOffset)) % 7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDayAt(int n, int n2) {
        if (n == 0 && n2 < this.mOffset) {
            return 1 + (n2 + this.mNumDaysInPrevMonth - this.mOffset);
        }
        int n3 = 1 + (n2 + n * 7 - this.mOffset);
        if (n3 <= this.mNumDaysInMonth) return n3;
        return n3 - this.mNumDaysInMonth;
    }

    public int[] getDigitsForRow(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("row " + n + " out of range (0-5)");
        }
        int[] nArray = new int[7];
        for (int i = 0; i < 7; ++i) {
            nArray[i] = this.getDayAt(n, i);
        }
        return nArray;
    }

    public int getFirstDayOfMonth() {
        return this.mCalendar.get(7);
    }

    public int getMonth() {
        return this.mCalendar.get(2);
    }

    public int getNumberOfDaysInMonth() {
        return this.mNumDaysInMonth;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getRowOf(int n) {
        return (-1 + (n + this.mOffset)) / 7;
    }

    public int getWeekStartDay() {
        return this.mWeekStartDay;
    }

    public int getYear() {
        return this.mCalendar.get(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isWithinCurrentMonth(int n, int n2) {
        return n >= 0 && n2 >= 0 && n <= 5 && n2 <= 6 && (n != 0 || n2 >= this.mOffset) && 1 + (n2 + n * 7 - this.mOffset) <= this.mNumDaysInMonth;
    }

    public void nextMonth() {
        this.mCalendar.add(2, 1);
        this.recalculate();
    }

    public void previousMonth() {
        this.mCalendar.add(2, -1);
        this.recalculate();
    }
}

