/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.transition.AutoTransition;
import android.transition.Scene;
import android.transition.Transition;
import android.util.ArrayMap;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public class TransitionManager {
    private static final String[] EMPTY_STRINGS;
    private static String LOG_TAG;
    private static Transition sDefaultTransition;
    private static ArrayList<ViewGroup> sPendingTransitions;
    private static ThreadLocal<WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>>> sRunningTransitions;
    ArrayMap<Scene, ArrayMap<Scene, Transition>> mScenePairTransitions;
    ArrayMap<Scene, Transition> mSceneTransitions = new ArrayMap();

    static {
        LOG_TAG = "TransitionManager";
        sDefaultTransition = new AutoTransition();
        EMPTY_STRINGS = new String[0];
        sRunningTransitions = new ThreadLocal();
        sPendingTransitions = new ArrayList();
    }

    public TransitionManager() {
        this.mScenePairTransitions = new ArrayMap();
    }

    public static void beginDelayedTransition(ViewGroup viewGroup) {
        TransitionManager.beginDelayedTransition(viewGroup, null);
    }

    public static void beginDelayedTransition(ViewGroup viewGroup, Transition transition2) {
        if (!sPendingTransitions.contains(viewGroup) && viewGroup.isLaidOut()) {
            sPendingTransitions.add(viewGroup);
            if (transition2 == null) {
                transition2 = sDefaultTransition;
            }
            Transition transition3 = transition2.clone();
            TransitionManager.sceneChangeSetup(viewGroup, transition3);
            Scene.setCurrentScene(viewGroup, null);
            TransitionManager.sceneChangeRunTransition(viewGroup, transition3);
        }
    }

    private static void changeScene(Scene scene, Transition transition2) {
        Scene scene2;
        ViewGroup viewGroup = scene.getSceneRoot();
        Transition transition3 = null;
        if (transition2 != null) {
            transition3 = transition2.clone();
            transition3.setSceneRoot(viewGroup);
        }
        if ((scene2 = Scene.getCurrentScene(viewGroup)) != null && transition3 != null && scene2.isCreatedFromLayoutResource()) {
            transition3.setCanRemoveViews(true);
        }
        TransitionManager.sceneChangeSetup(viewGroup, transition3);
        scene.enter();
        TransitionManager.sceneChangeRunTransition(viewGroup, transition3);
    }

    public static Transition getDefaultTransition() {
        return sDefaultTransition;
    }

    private static ArrayMap<ViewGroup, ArrayList<Transition>> getRunningTransitions() {
        WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>> weakReference = sRunningTransitions.get();
        if (weakReference == null || weakReference.get() == null) {
            weakReference = new WeakReference(new ArrayMap());
            sRunningTransitions.set(weakReference);
        }
        return (ArrayMap)weakReference.get();
    }

    private Transition getTransition(Scene scene) {
        Transition transition2;
        ArrayMap<Scene, Transition> arrayMap;
        Scene scene2;
        ViewGroup viewGroup = scene.getSceneRoot();
        if (viewGroup != null && (scene2 = Scene.getCurrentScene(viewGroup)) != null && (arrayMap = this.mScenePairTransitions.get(scene)) != null && (transition2 = arrayMap.get(scene2)) != null) {
            return transition2;
        }
        Transition transition3 = this.mSceneTransitions.get(scene);
        if (transition3 != null) {
            return transition3;
        }
        return sDefaultTransition;
    }

    public static void go(Scene scene) {
        TransitionManager.changeScene(scene, sDefaultTransition);
    }

    public static void go(Scene scene, Transition transition2) {
        TransitionManager.changeScene(scene, transition2);
    }

    private static void sceneChangeRunTransition(ViewGroup viewGroup, Transition transition2) {
        if (transition2 != null && viewGroup != null) {
            MultiListener multiListener = new MultiListener(transition2, viewGroup);
            viewGroup.addOnAttachStateChangeListener(multiListener);
            viewGroup.getViewTreeObserver().addOnPreDrawListener(multiListener);
        }
    }

    private static void sceneChangeSetup(ViewGroup viewGroup, Transition transition2) {
        Scene scene;
        ArrayList<Transition> arrayList = TransitionManager.getRunningTransitions().get(viewGroup);
        if (arrayList != null && arrayList.size() > 0) {
            Iterator<Transition> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                iterator.next().pause(viewGroup);
            }
        }
        if (transition2 != null) {
            transition2.captureValues(viewGroup, true);
        }
        if ((scene = Scene.getCurrentScene(viewGroup)) != null) {
            scene.exit();
        }
    }

    public void setDefaultTransition(Transition transition2) {
        sDefaultTransition = transition2;
    }

    public void setTransition(Scene scene, Scene scene2, Transition transition2) {
        ArrayMap<Scene, Transition> arrayMap = this.mScenePairTransitions.get(scene2);
        if (arrayMap == null) {
            arrayMap = new ArrayMap();
            this.mScenePairTransitions.put(scene2, arrayMap);
        }
        arrayMap.put(scene, transition2);
    }

    public void setTransition(Scene scene, Transition transition2) {
        this.mSceneTransitions.put(scene, transition2);
    }

    public void transitionTo(Scene scene) {
        TransitionManager.changeScene(scene, this.getTransition(scene));
    }

    private static class MultiListener
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener {
        ViewGroup mSceneRoot;
        Transition mTransition;

        MultiListener(Transition transition2, ViewGroup viewGroup) {
            this.mTransition = transition2;
            this.mSceneRoot = viewGroup;
        }

        private void removeListeners() {
            this.mSceneRoot.getViewTreeObserver().removeOnPreDrawListener(this);
            this.mSceneRoot.removeOnAttachStateChangeListener(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onPreDraw() {
            this.removeListeners();
            sPendingTransitions.remove(this.mSceneRoot);
            final ArrayMap arrayMap = TransitionManager.getRunningTransitions();
            ArrayList<Transition> arrayList = (ArrayList<Transition>)arrayMap.get(this.mSceneRoot);
            ArrayList arrayList2 = null;
            if (arrayList == null) {
                arrayList = new ArrayList<Transition>();
                arrayMap.put(this.mSceneRoot, arrayList);
            } else {
                int n = arrayList.size();
                arrayList2 = null;
                if (n > 0) {
                    arrayList2 = new ArrayList(arrayList);
                }
            }
            arrayList.add(this.mTransition);
            this.mTransition.addListener(new Transition.TransitionListenerAdapter(){

                @Override
                public void onTransitionEnd(Transition transition2) {
                    ((ArrayList)arrayMap.get(MultiListener.this.mSceneRoot)).remove(transition2);
                }
            });
            this.mTransition.captureValues(this.mSceneRoot, false);
            if (arrayList2 != null) {
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    ((Transition)iterator.next()).resume(this.mSceneRoot);
                }
            }
            this.mTransition.playTransition(this.mSceneRoot);
            return true;
        }

        @Override
        public void onViewAttachedToWindow(View view) {
        }

        @Override
        public void onViewDetachedFromWindow(View view) {
            this.removeListeners();
            sPendingTransitions.remove(this.mSceneRoot);
            ArrayList arrayList = (ArrayList)TransitionManager.getRunningTransitions().get(this.mSceneRoot);
            if (arrayList != null && arrayList.size() > 0) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((Transition)iterator.next()).resume(this.mSceneRoot);
                }
            }
            this.mTransition.clearValues(true);
        }
    }
}

