/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.Rect;
import android.transition.PathMotion;
import android.transition.TransitionPropagation;
import android.transition.TransitionSet;
import android.transition.TransitionValues;
import android.transition.TransitionValuesMaps;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.util.SparseLongArray;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowId;
import android.view.animation.AnimationUtils;
import android.widget.ListView;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public abstract class Transition
implements Cloneable {
    static final boolean DBG = false;
    private static final int[] DEFAULT_MATCH_ORDER = new int[]{2, 1, 3, 4};
    private static final String LOG_TAG = "Transition";
    private static final int MATCH_FIRST = 1;
    public static final int MATCH_ID = 3;
    private static final String MATCH_ID_STR = "id";
    public static final int MATCH_INSTANCE = 1;
    private static final String MATCH_INSTANCE_STR = "instance";
    public static final int MATCH_ITEM_ID = 4;
    private static final String MATCH_ITEM_ID_STR = "itemId";
    private static final int MATCH_LAST = 4;
    public static final int MATCH_NAME = 2;
    private static final String MATCH_NAME_STR = "name";
    private static final String MATCH_VIEW_NAME_STR = "viewName";
    private static final PathMotion STRAIGHT_PATH_MOTION = new PathMotion(){

        @Override
        public Path getPath(float f, float f2, float f3, float f4) {
            Path path = new Path();
            path.moveTo(f, f2);
            path.lineTo(f3, f4);
            return path;
        }
    };
    private static ThreadLocal<ArrayMap<Animator, AnimationInfo>> sRunningAnimators = new ThreadLocal();
    ArrayList<Animator> mAnimators;
    boolean mCanRemoveViews = false;
    private ArrayList<Animator> mCurrentAnimators;
    long mDuration = -1L;
    private TransitionValuesMaps mEndValues;
    ArrayList<TransitionValues> mEndValuesList;
    private boolean mEnded = false;
    EpicenterCallback mEpicenterCallback;
    TimeInterpolator mInterpolator = null;
    ArrayList<TransitionListener> mListeners = null;
    private int[] mMatchOrder;
    private String mName = this.getClass().getName();
    ArrayMap<String, String> mNameOverrides;
    int mNumInstances = 0;
    TransitionSet mParent = null;
    private PathMotion mPathMotion;
    boolean mPaused = false;
    TransitionPropagation mPropagation;
    ViewGroup mSceneRoot = null;
    long mStartDelay = -1L;
    private TransitionValuesMaps mStartValues;
    ArrayList<TransitionValues> mStartValuesList;
    ArrayList<View> mTargetChildExcludes = null;
    ArrayList<View> mTargetExcludes = null;
    ArrayList<Integer> mTargetIdChildExcludes = null;
    ArrayList<Integer> mTargetIdExcludes = null;
    ArrayList<Integer> mTargetIds = new ArrayList();
    ArrayList<String> mTargetNameExcludes = null;
    ArrayList<String> mTargetNames = null;
    ArrayList<Class> mTargetTypeChildExcludes = null;
    ArrayList<Class> mTargetTypeExcludes = null;
    ArrayList<Class> mTargetTypes = null;
    ArrayList<View> mTargets = new ArrayList();

    public Transition() {
        this.mStartValues = new TransitionValuesMaps();
        this.mEndValues = new TransitionValuesMaps();
        this.mMatchOrder = DEFAULT_MATCH_ORDER;
        this.mCurrentAnimators = new ArrayList();
        this.mAnimators = new ArrayList();
        this.mPathMotion = STRAIGHT_PATH_MOTION;
    }

    public Transition(Context context, AttributeSet attributeSet) {
        String string2;
        int n;
        long l;
        this.mStartValues = new TransitionValuesMaps();
        this.mEndValues = new TransitionValuesMaps();
        this.mMatchOrder = DEFAULT_MATCH_ORDER;
        this.mCurrentAnimators = new ArrayList();
        this.mAnimators = new ArrayList();
        this.mPathMotion = STRAIGHT_PATH_MOTION;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Transition);
        long l2 = typedArray.getInt(1, -1);
        if (l2 >= 0L) {
            this.setDuration(l2);
        }
        if ((l = (long)typedArray.getInt(2, -1)) > 0L) {
            this.setStartDelay(l);
        }
        if ((n = typedArray.getResourceId(0, 0)) > 0) {
            this.setInterpolator(AnimationUtils.loadInterpolator(context, n));
        }
        if ((string2 = typedArray.getString(3)) != null) {
            this.setMatchOrder(Transition.parseMatchOrder(string2));
        }
        typedArray.recycle();
    }

    private void addUnmatched(ArrayMap<View, TransitionValues> arrayMap, ArrayMap<View, TransitionValues> arrayMap2) {
        for (int i = 0; i < arrayMap.size(); ++i) {
            this.mStartValuesList.add(arrayMap.valueAt(i));
            this.mEndValuesList.add(null);
        }
        for (int i = 0; i < arrayMap2.size(); ++i) {
            this.mEndValuesList.add(arrayMap2.valueAt(i));
            this.mStartValuesList.add(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void addViewValues(TransitionValuesMaps transitionValuesMaps, View view, TransitionValues transitionValues) {
        ListView listView;
        String string2;
        transitionValuesMaps.viewValues.put(view, transitionValues);
        int n = view.getId();
        if (n >= 0) {
            if (transitionValuesMaps.idValues.indexOfKey(n) >= 0) {
                transitionValuesMaps.idValues.put(n, null);
            } else {
                transitionValuesMaps.idValues.put(n, view);
            }
        }
        if ((string2 = view.getTransitionName()) != null) {
            if (transitionValuesMaps.nameValues.containsKey(string2)) {
                transitionValuesMaps.nameValues.put(string2, null);
            } else {
                transitionValuesMaps.nameValues.put(string2, view);
            }
        }
        if (view.getParent() instanceof ListView && (listView = (ListView)view.getParent()).getAdapter().hasStableIds()) {
            long l = listView.getItemIdAtPosition(listView.getPositionForView(view));
            if (transitionValuesMaps.itemIdValues.indexOfKey(l) < 0) {
                view.setHasTransientState(true);
                transitionValuesMaps.itemIdValues.put(l, view);
                return;
            }
            View view2 = transitionValuesMaps.itemIdValues.get(l);
            if (view2 != null) {
                view2.setHasTransientState(false);
                transitionValuesMaps.itemIdValues.put(l, null);
            }
        }
    }

    private static boolean alreadyContains(int[] nArray, int n) {
        int n2 = nArray[n];
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != n2) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void captureHierarchy(View view, boolean bl) {
        if (view == null) return;
        int n = view.getId();
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(n) || this.mTargetExcludes != null && this.mTargetExcludes.contains(view)) return;
        if (this.mTargetTypeExcludes != null && view != null) {
            int n2 = this.mTargetTypeExcludes.size();
            for (int i = 0; i < n2; ++i) {
                if (this.mTargetTypeExcludes.get(i).isInstance(view)) return;
            }
        } else {
            if (view.getParent() instanceof ViewGroup) {
                TransitionValues transitionValues = new TransitionValues();
                transitionValues.view = view;
                if (bl) {
                    this.captureStartValues(transitionValues);
                } else {
                    this.captureEndValues(transitionValues);
                }
                transitionValues.targetedTransitions.add(this);
                this.capturePropagationValues(transitionValues);
                if (bl) {
                    Transition.addViewValues(this.mStartValues, view, transitionValues);
                } else {
                    Transition.addViewValues(this.mEndValues, view, transitionValues);
                }
            }
            if (!(view instanceof ViewGroup) || this.mTargetIdChildExcludes != null && this.mTargetIdChildExcludes.contains(n) || this.mTargetChildExcludes != null && this.mTargetChildExcludes.contains(view)) return;
            if (this.mTargetTypeChildExcludes != null) {
                int n3 = this.mTargetTypeChildExcludes.size();
                for (int i = 0; i < n3; ++i) {
                    if (this.mTargetTypeChildExcludes.get(i).isInstance(view)) return;
                }
            } else {
                ViewGroup viewGroup = (ViewGroup)view;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    this.captureHierarchy(viewGroup.getChildAt(i), bl);
                }
            }
        }
    }

    private static <T> ArrayList<T> excludeObject(ArrayList<T> arrayList, T t, boolean bl) {
        block3: {
            block2: {
                if (t == null) break block2;
                if (!bl) break block3;
                arrayList = ArrayListManager.add(arrayList, t);
            }
            return arrayList;
        }
        return ArrayListManager.remove(arrayList, t);
    }

    private static ArrayMap<Animator, AnimationInfo> getRunningAnimators() {
        ArrayMap<Animator, AnimationInfo> arrayMap = sRunningAnimators.get();
        if (arrayMap == null) {
            arrayMap = new ArrayMap();
            sRunningAnimators.set(arrayMap);
        }
        return arrayMap;
    }

    private static boolean isValidMatch(int n) {
        return n >= 1 && n <= 4;
    }

    private static boolean isValueChanged(TransitionValues transitionValues, TransitionValues transitionValues2, String string2) {
        Object object = transitionValues.values.get(string2);
        Object object2 = transitionValues2.values.get(string2);
        if (object == null && object2 == null) {
            return false;
        }
        if (object == null || object2 == null) {
            return true;
        }
        return !object.equals(object2);
    }

    private void matchIds(ArrayMap<View, TransitionValues> arrayMap, ArrayMap<View, TransitionValues> arrayMap2, SparseArray<View> sparseArray, SparseArray<View> sparseArray2) {
        int n = sparseArray.size();
        for (int i = 0; i < n; ++i) {
            View view;
            View view2 = sparseArray.valueAt(i);
            if (view2 == null || !this.isValidTarget(view2) || (view = sparseArray2.get(sparseArray.keyAt(i))) == null || !this.isValidTarget(view)) continue;
            TransitionValues transitionValues = arrayMap.get(view2);
            TransitionValues transitionValues2 = arrayMap2.get(view);
            if (transitionValues == null || transitionValues2 == null) continue;
            this.mStartValuesList.add(transitionValues);
            this.mEndValuesList.add(transitionValues2);
            arrayMap.remove(view2);
            arrayMap2.remove(view);
        }
    }

    private void matchInstances(ArrayMap<View, TransitionValues> arrayMap, ArrayMap<View, TransitionValues> arrayMap2) {
        for (int i = -1 + arrayMap.size(); i >= 0; --i) {
            TransitionValues transitionValues = arrayMap2.remove(arrayMap.keyAt(i));
            if (transitionValues == null) continue;
            TransitionValues transitionValues2 = arrayMap.removeAt(i);
            this.mStartValuesList.add(transitionValues2);
            this.mEndValuesList.add(transitionValues);
        }
    }

    private void matchItemIds(ArrayMap<View, TransitionValues> arrayMap, ArrayMap<View, TransitionValues> arrayMap2, LongSparseArray<View> longSparseArray, LongSparseArray<View> longSparseArray2) {
        int n = longSparseArray.size();
        for (int i = 0; i < n; ++i) {
            View view;
            View view2 = longSparseArray.valueAt(i);
            if (view2 == null || (view = longSparseArray2.get(longSparseArray.keyAt(i))) == null) continue;
            TransitionValues transitionValues = arrayMap.get(view2);
            TransitionValues transitionValues2 = arrayMap2.get(view);
            if (transitionValues == null || transitionValues2 == null) continue;
            this.mStartValuesList.add(transitionValues);
            this.mEndValuesList.add(transitionValues2);
            arrayMap.remove(view2);
            arrayMap2.remove(view);
        }
    }

    private void matchNames(ArrayMap<View, TransitionValues> arrayMap, ArrayMap<View, TransitionValues> arrayMap2, ArrayMap<String, View> arrayMap3, ArrayMap<String, View> arrayMap4) {
        int n = arrayMap3.size();
        for (int i = 0; i < n; ++i) {
            View view;
            View view2 = arrayMap3.valueAt(i);
            if (view2 == null || !this.isValidTarget(view2) || (view = arrayMap4.get(arrayMap3.keyAt(i))) == null || !this.isValidTarget(view)) continue;
            TransitionValues transitionValues = arrayMap.get(view2);
            TransitionValues transitionValues2 = arrayMap2.get(view);
            if (transitionValues == null || transitionValues2 == null) continue;
            this.mStartValuesList.add(transitionValues);
            this.mEndValuesList.add(transitionValues2);
            arrayMap.remove(view2);
            arrayMap2.remove(view);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void matchStartAndEnd(TransitionValuesMaps transitionValuesMaps, TransitionValuesMaps transitionValuesMaps2) {
        ArrayMap<View, TransitionValues> arrayMap = new ArrayMap<View, TransitionValues>(transitionValuesMaps.viewValues);
        ArrayMap<View, TransitionValues> arrayMap2 = new ArrayMap<View, TransitionValues>(transitionValuesMaps2.viewValues);
        int n = 0;
        while (true) {
            if (n >= this.mMatchOrder.length) {
                this.addUnmatched(arrayMap, arrayMap2);
                return;
            }
            switch (this.mMatchOrder[n]) {
                case 1: {
                    this.matchInstances(arrayMap, arrayMap2);
                    break;
                }
                case 2: {
                    this.matchNames(arrayMap, arrayMap2, transitionValuesMaps.nameValues, transitionValuesMaps2.nameValues);
                    break;
                }
                case 3: {
                    this.matchIds(arrayMap, arrayMap2, transitionValuesMaps.idValues, transitionValuesMaps2.idValues);
                    break;
                }
                case 4: {
                    this.matchItemIds(arrayMap, arrayMap2, transitionValuesMaps.itemIdValues, transitionValuesMaps2.itemIdValues);
                    break;
                }
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int[] parseMatchOrder(String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (MATCH_ID_STR.equalsIgnoreCase(string3)) {
                nArray[n] = 3;
            } else if (MATCH_INSTANCE_STR.equalsIgnoreCase(string3)) {
                nArray[n] = 1;
            } else if (MATCH_NAME_STR.equalsIgnoreCase(string3)) {
                nArray[n] = 2;
            } else if (MATCH_VIEW_NAME_STR.equalsIgnoreCase(string3)) {
                nArray[n] = 2;
            } else if (MATCH_ITEM_ID_STR.equalsIgnoreCase(string3)) {
                nArray[n] = 4;
            } else {
                if (!string3.isEmpty()) {
                    throw new InflateException("Unknown match type in matchOrder: '" + string3 + "'");
                }
                int[] nArray2 = new int[-1 + nArray.length];
                System.arraycopy((int[])nArray, (int)0, (int[])nArray2, (int)0, (int)n);
                nArray = nArray2;
                --n;
            }
            ++n;
        }
        return nArray;
    }

    private void runAnimator(Animator animator2, final ArrayMap<Animator, AnimationInfo> arrayMap) {
        if (animator2 != null) {
            animator2.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animator2) {
                    arrayMap.remove(animator2);
                    Transition.this.mCurrentAnimators.remove(animator2);
                }

                @Override
                public void onAnimationStart(Animator animator2) {
                    Transition.this.mCurrentAnimators.add(animator2);
                }
            });
            this.animate(animator2);
        }
    }

    public Transition addListener(TransitionListener transitionListener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(transitionListener);
        return this;
    }

    public Transition addTarget(int n) {
        if (n > 0) {
            this.mTargetIds.add(n);
        }
        return this;
    }

    public Transition addTarget(View view) {
        this.mTargets.add(view);
        return this;
    }

    public Transition addTarget(Class clazz) {
        if (clazz != null) {
            if (this.mTargetTypes == null) {
                this.mTargetTypes = new ArrayList();
            }
            this.mTargetTypes.add(clazz);
        }
        return this;
    }

    public Transition addTarget(String string2) {
        if (string2 != null) {
            if (this.mTargetNames == null) {
                this.mTargetNames = new ArrayList();
            }
            this.mTargetNames.add(string2);
        }
        return this;
    }

    protected void animate(Animator animator2) {
        if (animator2 == null) {
            this.end();
            return;
        }
        if (this.getDuration() >= 0L) {
            animator2.setDuration(this.getDuration());
        }
        if (this.getStartDelay() >= 0L) {
            animator2.setStartDelay(this.getStartDelay() + animator2.getStartDelay());
        }
        if (this.getInterpolator() != null) {
            animator2.setInterpolator(this.getInterpolator());
        }
        animator2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                Transition.this.end();
                animator2.removeListener(this);
            }
        });
        animator2.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean areValuesChanged(TransitionValues transitionValues, TransitionValues transitionValues2) {
        boolean bl = false;
        if (transitionValues == null) return bl;
        bl = false;
        if (transitionValues2 == null) return bl;
        String[] stringArray = this.getTransitionProperties();
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                bl = false;
                if (n2 >= n) return bl;
                if (Transition.isValueChanged(transitionValues, transitionValues2, stringArray[n2])) {
                    return true;
                }
                ++n2;
            }
        }
        Iterator<String> iterator = transitionValues.values.keySet().iterator();
        do {
            boolean bl2 = iterator.hasNext();
            bl = false;
            if (!bl2) return bl;
        } while (!Transition.isValueChanged(transitionValues, transitionValues2, iterator.next()));
        return true;
    }

    public boolean canRemoveViews() {
        return this.mCanRemoveViews;
    }

    protected void cancel() {
        for (int i = -1 + this.mCurrentAnimators.size(); i >= 0; --i) {
            this.mCurrentAnimators.get(i).cancel();
        }
        if (this.mListeners != null && this.mListeners.size() > 0) {
            ArrayList arrayList = (ArrayList)this.mListeners.clone();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((TransitionListener)arrayList.get(i)).onTransitionCancel(this);
            }
        }
    }

    public abstract void captureEndValues(TransitionValues var1);

    /*
     * Enabled aggressive block sorting
     */
    void capturePropagationValues(TransitionValues transitionValues) {
        block2: {
            block3: {
                String[] stringArray;
                if (this.mPropagation == null || transitionValues.values.isEmpty() || (stringArray = this.mPropagation.getPropagationProperties()) == null) break block3;
                boolean bl = true;
                int n = 0;
                while (true) {
                    block5: {
                        block4: {
                            if (n >= stringArray.length) break block4;
                            if (transitionValues.values.containsKey(stringArray[n])) break block5;
                            bl = false;
                        }
                        if (bl) break;
                        break block2;
                    }
                    ++n;
                }
            }
            return;
        }
        this.mPropagation.captureValues(transitionValues);
    }

    public abstract void captureStartValues(TransitionValues var1);

    /*
     * Enabled aggressive block sorting
     */
    void captureValues(ViewGroup viewGroup, boolean bl) {
        this.clearValues(bl);
        if (this.mTargetIds.size() <= 0 && this.mTargets.size() <= 0 || this.mTargetNames != null && !this.mTargetNames.isEmpty() || this.mTargetTypes != null && !this.mTargetTypes.isEmpty()) {
            this.captureHierarchy(viewGroup, bl);
        } else {
            for (int i = 0; i < this.mTargetIds.size(); ++i) {
                View view = viewGroup.findViewById(this.mTargetIds.get(i));
                if (view == null) continue;
                TransitionValues transitionValues = new TransitionValues();
                transitionValues.view = view;
                if (bl) {
                    this.captureStartValues(transitionValues);
                } else {
                    this.captureEndValues(transitionValues);
                }
                transitionValues.targetedTransitions.add(this);
                this.capturePropagationValues(transitionValues);
                if (bl) {
                    Transition.addViewValues(this.mStartValues, view, transitionValues);
                    continue;
                }
                Transition.addViewValues(this.mEndValues, view, transitionValues);
            }
            for (int i = 0; i < this.mTargets.size(); ++i) {
                View view = this.mTargets.get(i);
                TransitionValues transitionValues = new TransitionValues();
                transitionValues.view = view;
                if (bl) {
                    this.captureStartValues(transitionValues);
                } else {
                    this.captureEndValues(transitionValues);
                }
                transitionValues.targetedTransitions.add(this);
                this.capturePropagationValues(transitionValues);
                if (bl) {
                    Transition.addViewValues(this.mStartValues, view, transitionValues);
                    continue;
                }
                Transition.addViewValues(this.mEndValues, view, transitionValues);
            }
        }
        if (!bl && this.mNameOverrides != null) {
            int n = this.mNameOverrides.size();
            ArrayList<View> arrayList = new ArrayList<View>(n);
            for (int i = 0; i < n; ++i) {
                String string2 = this.mNameOverrides.keyAt(i);
                arrayList.add(this.mStartValues.nameValues.remove(string2));
            }
            for (int i = 0; i < n; ++i) {
                View view = (View)arrayList.get(i);
                if (view == null) continue;
                String string3 = this.mNameOverrides.valueAt(i);
                this.mStartValues.nameValues.put(string3, view);
            }
        }
    }

    void clearValues(boolean bl) {
        if (bl) {
            this.mStartValues.viewValues.clear();
            this.mStartValues.idValues.clear();
            this.mStartValues.itemIdValues.clear();
            this.mStartValues.nameValues.clear();
            this.mStartValuesList = null;
            return;
        }
        this.mEndValues.viewValues.clear();
        this.mEndValues.idValues.clear();
        this.mEndValues.itemIdValues.clear();
        this.mEndValues.nameValues.clear();
        this.mEndValuesList = null;
    }

    public Transition clone() {
        Transition transition2 = null;
        try {
            transition2 = (Transition)super.clone();
            transition2.mAnimators = new ArrayList();
            transition2.mStartValues = new TransitionValuesMaps();
            transition2.mEndValues = new TransitionValuesMaps();
            transition2.mStartValuesList = null;
            transition2.mEndValuesList = null;
            return transition2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return transition2;
        }
    }

    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected void createAnimators(ViewGroup var1_1, TransitionValuesMaps var2_2, TransitionValuesMaps var3_3, ArrayList<TransitionValues> var4_4, ArrayList<TransitionValues> var5_5) {
        var6_6 = Transition.getRunningAnimators();
        var7_7 = 0x7FFFFFFFFFFFFFFFL;
        this.mAnimators.size();
        var10_8 = new SparseLongArray();
        var11_9 = var4_4.size();
        block0: for (var12_10 = 0; var12_10 < var11_9; ++var12_10) {
            block18: {
                block19: {
                    block20: {
                        var16_11 = var4_4.get(var12_10);
                        var17_12 = var5_5.get(var12_10);
                        if (var16_11 != null && !var16_11.targetedTransitions.contains(this)) {
                            var16_11 = null;
                        }
                        if (var17_12 != null && !var17_12.targetedTransitions.contains(this)) {
                            var17_12 = null;
                        }
                        if (var16_11 == null && var17_12 == null) lbl-1000:
                        // 4 sources

                        {
                            continue block0;
                        }
                        if (var16_11 != null && var17_12 != null && !this.areValuesChanged(var16_11, var17_12)) break block20;
                        var18_13 = true;
lbl19:
                        // 2 sources

                        while (true) {
                            if (!var18_13 || (var19_14 = this.createAnimator(var1_1, var16_11, var17_12)) == null) ** GOTO lbl-1000
                            if (var17_12 == null) break block18;
                            var20_15 = var17_12.view;
                            var26_18 = this.getTransitionProperties();
                            var21_16 = null;
                            if (var20_15 != null) {
                                var21_16 = null;
                                if (var26_18 != null) {
                                    var27_19 = var26_18.length;
                                    var21_16 = null;
                                    if (var27_19 > 0) {
                                        var21_16 = new TransitionValues();
                                        var21_16.view = var20_15;
                                        var28_20 = var3_3.viewValues.get(var20_15);
                                        if (var28_20 != null) {
                                            for (var32_24 = 0; var32_24 < (var33_25 = var26_18.length); ++var32_24) {
                                                var21_16.values.put(var26_18[var32_24], var28_20.values.get(var26_18[var32_24]));
                                            }
                                        }
                                        break block19;
                                    }
                                }
                            }
                            ** GOTO lbl54
                            break;
                        }
                    }
                    var18_13 = false;
                    ** continue;
                }
                var29_21 = var6_6.size();
                var30_22 = 0;
                while (true) {
                    block22: {
                        block21: {
                            if (var30_22 >= var29_21) break block21;
                            var31_23 = var6_6.get(var6_6.keyAt(var30_22));
                            if (var31_23.values == null || var31_23.view != var20_15 || (var31_23.name != null || this.getName() != null) && !var31_23.name.equals(this.getName()) || !var31_23.values.equals(var21_16)) break block22;
                            var19_14 = null;
                        }
lbl55:
                        // 2 sources

                        while (true) {
                            if (var19_14 == null) ** GOTO lbl-1000
                            if (this.mPropagation != null) {
                                var24_17 = this.mPropagation.getStartDelay(var1_1, this, var16_11, var17_12);
                                var10_8.put(this.mAnimators.size(), var24_17);
                                var7_7 = Math.min(var24_17, var7_7);
                            }
                            var6_6.put(var19_14, new AnimationInfo(var20_15, this.getName(), this, var1_1.getWindowId(), var21_16));
                            this.mAnimators.add(var19_14);
                            ** continue;
                            break;
                        }
                    }
                    ++var30_22;
                }
            }
            if (var16_11 != null) {
                var20_15 = var16_11.view;
lbl72:
                // 2 sources

                while (true) {
                    var21_16 = null;
                    ** continue;
                    break;
                }
            }
            var20_15 = null;
            ** continue;
        }
        if (var7_7 != 0L) {
            for (var13_26 = 0; var13_26 < var10_8.size(); ++var13_26) {
                var14_27 = var10_8.keyAt(var13_26);
                var15_28 = this.mAnimators.get(var14_27);
                var15_28.setStartDelay(var10_8.valueAt(var13_26) - var7_7 + var15_28.getStartDelay());
            }
        }
    }

    protected void end() {
        this.mNumInstances = -1 + this.mNumInstances;
        if (this.mNumInstances == 0) {
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList arrayList = (ArrayList)this.mListeners.clone();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ((TransitionListener)arrayList.get(i)).onTransitionEnd(this);
                }
            }
            for (int i = 0; i < this.mStartValues.itemIdValues.size(); ++i) {
                View view = this.mStartValues.itemIdValues.valueAt(i);
                if (view == null) continue;
                view.setHasTransientState(false);
            }
            for (int i = 0; i < this.mEndValues.itemIdValues.size(); ++i) {
                View view = this.mEndValues.itemIdValues.valueAt(i);
                if (view == null) continue;
                view.setHasTransientState(false);
            }
            this.mEnded = true;
        }
    }

    public Transition excludeChildren(int n, boolean bl) {
        if (n >= 0) {
            this.mTargetIdChildExcludes = Transition.excludeObject(this.mTargetIdChildExcludes, n, bl);
        }
        return this;
    }

    public Transition excludeChildren(View view, boolean bl) {
        this.mTargetChildExcludes = Transition.excludeObject(this.mTargetChildExcludes, view, bl);
        return this;
    }

    public Transition excludeChildren(Class clazz, boolean bl) {
        this.mTargetTypeChildExcludes = Transition.excludeObject(this.mTargetTypeChildExcludes, clazz, bl);
        return this;
    }

    public Transition excludeTarget(int n, boolean bl) {
        if (n >= 0) {
            this.mTargetIdExcludes = Transition.excludeObject(this.mTargetIdExcludes, n, bl);
        }
        return this;
    }

    public Transition excludeTarget(View view, boolean bl) {
        this.mTargetExcludes = Transition.excludeObject(this.mTargetExcludes, view, bl);
        return this;
    }

    public Transition excludeTarget(Class clazz, boolean bl) {
        this.mTargetTypeExcludes = Transition.excludeObject(this.mTargetTypeExcludes, clazz, bl);
        return this;
    }

    public Transition excludeTarget(String string2, boolean bl) {
        this.mTargetNameExcludes = Transition.excludeObject(this.mTargetNameExcludes, string2, bl);
        return this;
    }

    public void forceVisibility(int n, boolean bl) {
    }

    public long getDuration() {
        return this.mDuration;
    }

    public Rect getEpicenter() {
        if (this.mEpicenterCallback == null) {
            return null;
        }
        return this.mEpicenterCallback.onGetEpicenter(this);
    }

    public EpicenterCallback getEpicenterCallback() {
        return this.mEpicenterCallback;
    }

    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    /*
     * Enabled aggressive block sorting
     */
    TransitionValues getMatchedTransitionValues(View view, boolean bl) {
        ArrayList<TransitionValues> arrayList;
        if (this.mParent != null) {
            return this.mParent.getMatchedTransitionValues(view, bl);
        }
        ArrayList<TransitionValues> arrayList2 = bl ? this.mStartValuesList : this.mEndValuesList;
        if (arrayList2 == null) {
            return null;
        }
        int n = arrayList2.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            TransitionValues transitionValues = arrayList2.get(i);
            if (transitionValues == null) {
                return null;
            }
            if (transitionValues.view != view) continue;
            n2 = i;
            break;
        }
        TransitionValues transitionValues = null;
        if (n2 < 0) return transitionValues;
        if (bl) {
            arrayList = this.mEndValuesList;
            return arrayList.get(n2);
        }
        arrayList = this.mStartValuesList;
        return arrayList.get(n2);
    }

    public String getName() {
        return this.mName;
    }

    public ArrayMap<String, String> getNameOverrides() {
        return this.mNameOverrides;
    }

    public PathMotion getPathMotion() {
        return this.mPathMotion;
    }

    public TransitionPropagation getPropagation() {
        return this.mPropagation;
    }

    public long getStartDelay() {
        return this.mStartDelay;
    }

    public List<Integer> getTargetIds() {
        return this.mTargetIds;
    }

    public List<String> getTargetNames() {
        return this.mTargetNames;
    }

    public List<Class> getTargetTypes() {
        return this.mTargetTypes;
    }

    public List<String> getTargetViewNames() {
        return this.mTargetNames;
    }

    public List<View> getTargets() {
        return this.mTargets;
    }

    public String[] getTransitionProperties() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TransitionValues getTransitionValues(View view, boolean bl) {
        TransitionValuesMaps transitionValuesMaps;
        if (this.mParent != null) {
            return this.mParent.getTransitionValues(view, bl);
        }
        if (bl) {
            transitionValuesMaps = this.mStartValues;
            return transitionValuesMaps.viewValues.get(view);
        }
        transitionValuesMaps = this.mEndValues;
        return transitionValuesMaps.viewValues.get(view);
    }

    boolean isValidTarget(View view) {
        int n = view.getId();
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(n)) {
            return false;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(view)) {
            return false;
        }
        if (this.mTargetTypeExcludes != null && view != null) {
            int n2 = this.mTargetTypeExcludes.size();
            for (int i = 0; i < n2; ++i) {
                if (!this.mTargetTypeExcludes.get(i).isInstance(view)) continue;
                return false;
            }
        }
        if (this.mTargetNameExcludes != null && view != null && view.getTransitionName() != null && this.mTargetNameExcludes.contains(view.getTransitionName())) {
            return false;
        }
        if (this.mTargetIds.size() == 0 && this.mTargets.size() == 0 && (this.mTargetTypes == null || this.mTargetTypes.isEmpty()) && (this.mTargetNames == null || this.mTargetNames.isEmpty())) {
            return true;
        }
        if (this.mTargetIds.contains(n) || this.mTargets.contains(view)) {
            return true;
        }
        if (this.mTargetNames != null && this.mTargetNames.contains(view.getTransitionName())) {
            return true;
        }
        if (this.mTargetTypes != null) {
            for (int i = 0; i < this.mTargetTypes.size(); ++i) {
                if (!this.mTargetTypes.get(i).isInstance(view)) continue;
                return true;
            }
        }
        return false;
    }

    public void pause(View view) {
        if (!this.mEnded) {
            ArrayMap<Animator, AnimationInfo> arrayMap = Transition.getRunningAnimators();
            int n = arrayMap.size();
            if (view != null) {
                WindowId windowId = view.getWindowId();
                for (int i = n - 1; i >= 0; --i) {
                    AnimationInfo animationInfo = arrayMap.valueAt(i);
                    if (animationInfo.view == null || windowId == null || !windowId.equals(animationInfo.windowId)) continue;
                    arrayMap.keyAt(i).pause();
                }
            }
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList arrayList = (ArrayList)this.mListeners.clone();
                int n2 = arrayList.size();
                for (int i = 0; i < n2; ++i) {
                    ((TransitionListener)arrayList.get(i)).onTransitionPause(this);
                }
            }
            this.mPaused = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void playTransition(ViewGroup viewGroup) {
        this.mStartValuesList = new ArrayList();
        this.mEndValuesList = new ArrayList();
        this.matchStartAndEnd(this.mStartValues, this.mEndValues);
        ArrayMap<Animator, AnimationInfo> arrayMap = Transition.getRunningAnimators();
        int n = arrayMap.size();
        WindowId windowId = viewGroup.getWindowId();
        int n2 = n - 1;
        while (true) {
            AnimationInfo animationInfo;
            if (n2 < 0) {
                this.createAnimators(viewGroup, this.mStartValues, this.mEndValues, this.mStartValuesList, this.mEndValuesList);
                this.runAnimators();
                return;
            }
            Animator animator2 = arrayMap.keyAt(n2);
            if (animator2 != null && (animationInfo = arrayMap.get(animator2)) != null && animationInfo.view != null && animationInfo.windowId == windowId) {
                TransitionValues transitionValues = animationInfo.values;
                View view = animationInfo.view;
                TransitionValues transitionValues2 = this.getTransitionValues(view, true);
                TransitionValues transitionValues3 = this.getMatchedTransitionValues(view, true);
                boolean bl = (transitionValues2 != null || transitionValues3 != null) && animationInfo.transition.areValuesChanged(transitionValues, transitionValues3);
                if (bl) {
                    if (animator2.isRunning() || animator2.isStarted()) {
                        animator2.cancel();
                    } else {
                        arrayMap.remove(animator2);
                    }
                }
            }
            --n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Transition removeListener(TransitionListener transitionListener) {
        block3: {
            block2: {
                if (this.mListeners == null) break block2;
                this.mListeners.remove(transitionListener);
                if (this.mListeners.size() == 0) break block3;
            }
            return this;
        }
        this.mListeners = null;
        return this;
    }

    public Transition removeTarget(int n) {
        if (n > 0) {
            this.mTargetIds.remove(n);
        }
        return this;
    }

    public Transition removeTarget(View view) {
        if (view != null) {
            this.mTargets.remove(view);
        }
        return this;
    }

    public Transition removeTarget(Class clazz) {
        if (clazz != null) {
            this.mTargetTypes.remove(clazz);
        }
        return this;
    }

    public Transition removeTarget(String string2) {
        if (string2 != null && this.mTargetNames != null) {
            this.mTargetNames.remove(string2);
        }
        return this;
    }

    public void resume(View view) {
        if (this.mPaused) {
            if (!this.mEnded) {
                ArrayMap<Animator, AnimationInfo> arrayMap = Transition.getRunningAnimators();
                int n = arrayMap.size();
                WindowId windowId = view.getWindowId();
                for (int i = n - 1; i >= 0; --i) {
                    AnimationInfo animationInfo = arrayMap.valueAt(i);
                    if (animationInfo.view == null || windowId == null || !windowId.equals(animationInfo.windowId)) continue;
                    arrayMap.keyAt(i).resume();
                }
                if (this.mListeners != null && this.mListeners.size() > 0) {
                    ArrayList arrayList = (ArrayList)this.mListeners.clone();
                    int n2 = arrayList.size();
                    for (int i = 0; i < n2; ++i) {
                        ((TransitionListener)arrayList.get(i)).onTransitionResume(this);
                    }
                }
            }
            this.mPaused = false;
        }
    }

    protected void runAnimators() {
        this.start();
        ArrayMap<Animator, AnimationInfo> arrayMap = Transition.getRunningAnimators();
        for (Animator animator2 : this.mAnimators) {
            if (!arrayMap.containsKey(animator2)) continue;
            this.start();
            this.runAnimator(animator2, arrayMap);
        }
        this.mAnimators.clear();
        this.end();
    }

    void setCanRemoveViews(boolean bl) {
        this.mCanRemoveViews = bl;
    }

    public Transition setDuration(long l) {
        this.mDuration = l;
        return this;
    }

    public void setEpicenterCallback(EpicenterCallback epicenterCallback) {
        this.mEpicenterCallback = epicenterCallback;
    }

    public Transition setInterpolator(TimeInterpolator timeInterpolator) {
        this.mInterpolator = timeInterpolator;
        return this;
    }

    public void setMatchOrder(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            this.mMatchOrder = DEFAULT_MATCH_ORDER;
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (!Transition.isValidMatch(nArray[i])) {
                throw new IllegalArgumentException("matches contains invalid value");
            }
            if (!Transition.alreadyContains(nArray, i)) continue;
            throw new IllegalArgumentException("matches contains a duplicate value");
        }
        this.mMatchOrder = (int[])nArray.clone();
    }

    public void setNameOverrides(ArrayMap<String, String> arrayMap) {
        this.mNameOverrides = arrayMap;
    }

    public void setPathMotion(PathMotion pathMotion) {
        if (pathMotion == null) {
            this.mPathMotion = STRAIGHT_PATH_MOTION;
            return;
        }
        this.mPathMotion = pathMotion;
    }

    public void setPropagation(TransitionPropagation transitionPropagation) {
        this.mPropagation = transitionPropagation;
    }

    Transition setSceneRoot(ViewGroup viewGroup) {
        this.mSceneRoot = viewGroup;
        return this;
    }

    public Transition setStartDelay(long l) {
        this.mStartDelay = l;
        return this;
    }

    protected void start() {
        if (this.mNumInstances == 0) {
            if (this.mListeners != null && this.mListeners.size() > 0) {
                ArrayList arrayList = (ArrayList)this.mListeners.clone();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ((TransitionListener)arrayList.get(i)).onTransitionStart(this);
                }
            }
            this.mEnded = false;
        }
        this.mNumInstances = 1 + this.mNumInstances;
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String string2) {
        String string3 = string2 + this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": ";
        if (this.mDuration != -1L) {
            string3 = string3 + "dur(" + this.mDuration + ") ";
        }
        if (this.mStartDelay != -1L) {
            string3 = string3 + "dly(" + this.mStartDelay + ") ";
        }
        if (this.mInterpolator != null) {
            string3 = string3 + "interp(" + this.mInterpolator + ") ";
        }
        if (this.mTargetIds.size() > 0 || this.mTargets.size() > 0) {
            String string4 = string3 + "tgts(";
            if (this.mTargetIds.size() > 0) {
                for (int i = 0; i < this.mTargetIds.size(); ++i) {
                    if (i > 0) {
                        string4 = string4 + ", ";
                    }
                    string4 = string4 + this.mTargetIds.get(i);
                }
            }
            if (this.mTargets.size() > 0) {
                for (int i = 0; i < this.mTargets.size(); ++i) {
                    if (i > 0) {
                        string4 = string4 + ", ";
                    }
                    string4 = string4 + this.mTargets.get(i);
                }
            }
            string3 = string4 + ")";
        }
        return string3;
    }

    public static class AnimationInfo {
        String name;
        Transition transition;
        TransitionValues values;
        public View view;
        WindowId windowId;

        AnimationInfo(View view, String string2, Transition transition2, WindowId windowId, TransitionValues transitionValues) {
            this.view = view;
            this.name = string2;
            this.values = transitionValues;
            this.windowId = windowId;
            this.transition = transition2;
        }
    }

    private static class ArrayListManager {
        private ArrayListManager() {
        }

        static <T> ArrayList<T> add(ArrayList<T> arrayList, T t) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if (!arrayList.contains(t)) {
                arrayList.add(t);
            }
            return arrayList;
        }

        static <T> ArrayList<T> remove(ArrayList<T> arrayList, T t) {
            if (arrayList != null) {
                arrayList.remove(t);
                if (arrayList.isEmpty()) {
                    arrayList = null;
                }
            }
            return arrayList;
        }
    }

    public static abstract class EpicenterCallback {
        public abstract Rect onGetEpicenter(Transition var1);
    }

    public static interface TransitionListener {
        public void onTransitionCancel(Transition var1);

        public void onTransitionEnd(Transition var1);

        public void onTransitionPause(Transition var1);

        public void onTransitionResume(Transition var1);

        public void onTransitionStart(Transition var1);
    }

    public static class TransitionListenerAdapter
    implements TransitionListener {
        @Override
        public void onTransitionCancel(Transition transition2) {
        }

        @Override
        public void onTransitionEnd(Transition transition2) {
        }

        @Override
        public void onTransitionPause(Transition transition2) {
        }

        @Override
        public void onTransitionResume(Transition transition2) {
        }

        @Override
        public void onTransitionStart(Transition transition2) {
        }
    }
}

