/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Rect;
import android.transition.CircularPropagation;
import android.transition.TransitionValues;
import android.transition.TranslationAnimationCreator;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;

public class Explode
extends Visibility {
    private static final String PROPNAME_SCREEN_BOUNDS = "android:explode:screenBounds";
    private static final String TAG = "Explode";
    private static final TimeInterpolator sAccelerate;
    private static final TimeInterpolator sDecelerate;
    private int[] mTempLoc = new int[2];

    static {
        sDecelerate = new DecelerateInterpolator();
        sAccelerate = new AccelerateInterpolator();
    }

    public Explode() {
        this.setPropagation(new CircularPropagation());
    }

    public Explode(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setPropagation(new CircularPropagation());
    }

    private static float calculateDistance(float f, float f2) {
        return FloatMath.sqrt(f * f + f2 * f2);
    }

    private static float calculateMaxDistance(View view, int n, int n2) {
        int n3 = Math.max(n, view.getWidth() - n);
        int n4 = Math.max(n2, view.getHeight() - n2);
        return Explode.calculateDistance(n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculateOut(View view, Rect rect, int[] nArray) {
        int n;
        int n2;
        view.getLocationOnScreen(this.mTempLoc);
        int n3 = this.mTempLoc[0];
        int n4 = this.mTempLoc[1];
        Rect rect2 = this.getEpicenter();
        if (rect2 == null) {
            n2 = n3 + view.getWidth() / 2 + Math.round(view.getTranslationX());
            n = n4 + view.getHeight() / 2 + Math.round(view.getTranslationY());
        } else {
            n2 = rect2.centerX();
            n = rect2.centerY();
        }
        int n5 = rect.centerX();
        int n6 = rect.centerY();
        float f = n5 - n2;
        float f2 = n6 - n;
        if (f == 0.0f && f2 == 0.0f) {
            f = (float)(2.0 * Math.random()) - 1.0f;
            f2 = (float)(2.0 * Math.random()) - 1.0f;
        }
        float f3 = Explode.calculateDistance(f, f2);
        float f4 = f / f3;
        float f5 = f2 / f3;
        float f6 = Explode.calculateMaxDistance(view, n2 - n3, n - n4);
        nArray[0] = Math.round(f6 * f4);
        nArray[1] = Math.round(f6 * f5);
    }

    private void captureValues(TransitionValues transitionValues) {
        View view = transitionValues.view;
        view.getLocationOnScreen(this.mTempLoc);
        int n = this.mTempLoc[0];
        int n2 = this.mTempLoc[1];
        int n3 = n + view.getWidth();
        int n4 = n2 + view.getHeight();
        transitionValues.values.put(PROPNAME_SCREEN_BOUNDS, new Rect(n, n2, n3, n4));
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        super.captureEndValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public Animator onAppear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        if (transitionValues2 == null) {
            return null;
        }
        Rect rect = (Rect)transitionValues2.values.get(PROPNAME_SCREEN_BOUNDS);
        float f = view.getTranslationX();
        float f2 = view.getTranslationY();
        this.calculateOut(viewGroup, rect, this.mTempLoc);
        float f3 = f + (float)this.mTempLoc[0];
        float f4 = f2 + (float)this.mTempLoc[1];
        return TranslationAnimationCreator.createAnimation(view, transitionValues2, rect.left, rect.top, f3, f4, f, f2, sDecelerate);
    }

    @Override
    public Animator onDisappear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        if (transitionValues == null) {
            return null;
        }
        Rect rect = (Rect)transitionValues.values.get(PROPNAME_SCREEN_BOUNDS);
        int n = rect.left;
        int n2 = rect.top;
        float f = view.getTranslationX();
        float f2 = view.getTranslationY();
        float f3 = f;
        float f4 = f2;
        int[] nArray = (int[])transitionValues.view.getTag(16908357);
        if (nArray != null) {
            f3 += (float)(nArray[0] - rect.left);
            f4 += (float)(nArray[1] - rect.top);
            rect.offsetTo(nArray[0], nArray[1]);
        }
        this.calculateOut(viewGroup, rect, this.mTempLoc);
        return TranslationAnimationCreator.createAnimation(view, transitionValues, n, n2, f, f2, f3 + (float)this.mTempLoc[0], f4 + (float)this.mTempLoc[1], sAccelerate);
    }
}

